/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateXMLInput
implements Serializable {
    public static void main(String[] args) throws Exception {
        ValidateXMLInput v = new ValidateXMLInput();
    }

    public String validate(String xslType, String xmlType, String targetDir, String fileNamePrefix, String fileNameSuffix) throws BaseException {
        try {
            String transformedFileName = "";
            switch (CommonConstants.SOURCETYPE) {
                case 0: {
                    transformedFileName = this.useDomSource(xslType, xmlType, targetDir, fileNamePrefix, fileNameSuffix);
                    break;
                }
                case 1: {
                    transformedFileName = this.useSaxSource(xslType, xmlType, targetDir, fileNamePrefix, fileNameSuffix);
                    break;
                }
                case 2: {
                    transformedFileName = this.useStreamSource(xslType, xmlType, targetDir, fileNamePrefix, fileNameSuffix);
                }
            }
            return transformedFileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e, "error while XML transforming");
        }
    }

    public String useStreamSource(String xslType, String xmlType, String targetDir, String fileNamePrefix, String fileNameSuffix) throws BaseException {
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer t = null;
            StreamSource sourceStream = null;
            String transformedFileName = "";
            Handler handler = new Handler();
            long startTime = System.currentTimeMillis();
            BaseLogger.log("3", null, null, "\nCreating transformer Obj...");
            t = xslType.endsWith(".xsl") ? tfactory.newTransformer(new StreamSource(xslType)) : tfactory.newTransformer(new StreamSource(new ByteArrayInputStream(xslType.getBytes())));
            t.setOutputProperty("encoding", CommonConstants.ENCODING);
            BaseLogger.log("3", null, null, "Transformer Obj Created..." + (System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            BaseLogger.log("3", null, null, "\nCreating Stream Source...");
            sourceStream = xmlType.endsWith(".xml") ? new StreamSource(new FileInputStream(xmlType)) : new StreamSource(new ByteArrayInputStream(xmlType.getBytes(CommonConstants.ENCODING)));
            BaseLogger.log("3", null, null, "Stream Source Created..." + (System.currentTimeMillis() - startTime));
            String prefix = String.valueOf(fileNamePrefix) + Math.random();
            File tempDirectory = new File(targetDir);
            BaseLogger.log("3", null, null, "tempDirectory.exists() :[" + tempDirectory.exists() + "]");
            if (!tempDirectory.exists()) {
                BaseLogger.log("3", null, null, "Creating Directory :[" + tempDirectory.getAbsolutePath() + "]");
                tempDirectory.mkdir();
            }
            File tempFile = File.createTempFile(prefix, fileNameSuffix, tempDirectory);
            transformedFileName = tempFile.getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(transformedFileName);
            BaseLogger.log("3", null, null, "Transformation Starter...");
            startTime = System.currentTimeMillis();
            t.transform(sourceStream, new StreamResult(new OutputStreamWriter((OutputStream)fos, CommonConstants.ENCODING)));
            fos.flush();
            fos.close();
            BaseLogger.log("3", null, null, "Transformation Completed..." + (System.currentTimeMillis() - startTime));
            return transformedFileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e, "error while XML transforming");
        }
    }

    public String useSaxSource(String xslType, String xmlType, String targetDir, String fileNamePrefix, String fileNameSuffix) throws BaseException {
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer t = null;
            SAXSource sourceSax = null;
            String transformedFileName = "";
            Handler handler = new Handler();
            long startTime = System.currentTimeMillis();
            BaseLogger.log("3", null, null, "\nCreating transformer Obj...");
            t = xslType.endsWith(".xsl") ? tfactory.newTransformer(new StreamSource(xslType)) : tfactory.newTransformer(new StreamSource(new ByteArrayInputStream(xslType.getBytes())));
            t.setOutputProperty("encoding", CommonConstants.ENCODING);
            BaseLogger.log("3", null, null, "Transformer Obj Created..." + (System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            BaseLogger.log("3", null, null, "\nCreating SAX Source...");
            sourceSax = xmlType.endsWith(".xml") ? new SAXSource(new InputSource(new FileInputStream(xmlType))) : new SAXSource(new InputSource(new ByteArrayInputStream(xmlType.getBytes(CommonConstants.ENCODING))));
            BaseLogger.log("3", null, null, "SAX Source Created..." + (System.currentTimeMillis() - startTime));
            String prefix = String.valueOf(fileNamePrefix) + Math.random();
            File tempDirectory = new File(targetDir);
            BaseLogger.log("3", null, null, "tempDirectory.exists() :[" + tempDirectory.exists() + "]");
            if (!tempDirectory.exists()) {
                BaseLogger.log("3", null, null, "Creating Directory :[" + tempDirectory.getAbsolutePath() + "]");
                tempDirectory.mkdir();
            }
            File tempFile = File.createTempFile(prefix, fileNameSuffix, tempDirectory);
            transformedFileName = tempFile.getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(transformedFileName);
            BaseLogger.log("3", null, null, "Transformation Starter...");
            startTime = System.currentTimeMillis();
            t.transform(sourceSax, new StreamResult(new OutputStreamWriter((OutputStream)fos, CommonConstants.ENCODING)));
            fos.flush();
            fos.close();
            BaseLogger.log("3", null, null, "Transformation Completed..." + (System.currentTimeMillis() - startTime));
            return transformedFileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e, "error while XML transforming");
        }
    }

    public String useDomSource(String xslType, String xmlType, String targetDir, String fileNamePrefix, String fileNameSuffix) throws BaseException {
        try {
            Document DOM;
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer t = null;
            DOMSource sourceDom = null;
            String transformedFileName = "";
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            dfactory.setValidating(false);
            Handler handler = new Handler();
            t = xslType.endsWith(".xsl") ? tfactory.newTransformer(new StreamSource(xslType)) : tfactory.newTransformer(new StreamSource(new ByteArrayInputStream(xslType.getBytes())));
            t.setOutputProperty("encoding", CommonConstants.ENCODING);
            if (xmlType.endsWith(".xml")) {
                DOM = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlType);
                sourceDom = new DOMSource(DOM);
            } else {
                DOM = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xmlType.getBytes(CommonConstants.ENCODING)));
                sourceDom = new DOMSource(DOM);
            }
            String prefix = String.valueOf(fileNamePrefix) + Math.random();
            File tempDirectory = new File(targetDir);
            BaseLogger.log("3", null, null, "tempDirectory.exists() :[" + tempDirectory.exists() + "]");
            if (!tempDirectory.exists()) {
                tempDirectory.mkdir();
            }
            File tempFile = File.createTempFile(prefix, fileNameSuffix, tempDirectory);
            transformedFileName = tempFile.getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(transformedFileName);
            t.transform(sourceDom, new StreamResult(fos));
            fos.flush();
            fos.close();
            return transformedFileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e, "error while XML transforming");
        }
    }

    class Handler
    extends DefaultHandler {
        Handler() {
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            BaseLogger.log("2", null, null, "SAXParseException warning: " + spe.getMessage());
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            BaseLogger.log("2", null, null, "SAXParseException error: " + spe.getMessage());
        }
    }
}

