/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.bean.EventLogInfoBean;
import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ITMProcessModel;
import ibase.webitm.bean.ITMTransactionCoreModel;
import ibase.webitm.bean.ITMTransactionHeaderModel;
import ibase.webitm.bean.ITMTransactionModel;
import ibase.webitm.ejb.ITMActionsEJB;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ITMActionsServlet
extends ITMAuthenticateServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    public String objName = "";
    public int noOfForms = -1;
    public UserInfoBean userInfo = null;
    public String pkValues = null;
    public String argFieldValues = null;
    public String chgStr = null;
    public String valXMLStr = null;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String retXml = "";
        Object outputStream = null;
        String responseStr = "";
        try {
            if (Boolean.valueOf(this.authenticate(request)).booleanValue()) {
                String editFlag;
                String objName;
                String pgContext;
                String objContext;
                Date startTime = new Date();
                HttpSession session = request.getSession();
                ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel)session.getAttribute("itmTransHdrMdl");
                ITMTransactionCoreModel itmTransCoreMdl = null;
                String objType = request.getParameter("OBJ_TYPE") != null ? request.getParameter("OBJ_TYPE") : "";
                ITMProcessModel itmProcessMdl = (ITMProcessModel)session.getAttribute("itmProcessMdl");
                String coreModelID = request.getParameter("CORE_MDL_ID");
                if (!"null".equalsIgnoreCase(coreModelID) && !"".equals(coreModelID) && coreModelID != null) {
                    itmTransCoreMdl = (ITMTransactionCoreModel)session.getAttribute(coreModelID);
                }
                if ("null".equalsIgnoreCase(objContext = request.getParameter("OBJ_CTXT")) || "".equals(objContext) || objContext == null) {
                    responseStr = "Invalid Form No.";
                }
                if ("null".equalsIgnoreCase(pgContext = request.getParameter("PG_CTXT")) || "".equals(pgContext) || pgContext == null) {
                    responseStr = "Invalid Page Context";
                }
                ITMTransactionModel itmTransMdl = null;
                if (!"P".equalsIgnoreCase(objType)) {
                    itmTransMdl = "1".equals(objContext) && "1".equals(pgContext) ? itmTransHdrMdl : itmTransCoreMdl;
                }
                if ("null".equalsIgnoreCase(objName = request.getParameter("OBJ_NAME")) || "".equals(objName) || objName == null) {
                    objName = !"P".equalsIgnoreCase(objType) ? itmTransMdl.getObjName() : itmProcessMdl.getObjName();
                }
                if ("null".equalsIgnoreCase(editFlag = request.getParameter("EDIT_FLAG")) || "".equals(editFlag) || editFlag == null) {
                    editFlag = !"P".equalsIgnoreCase(objType) ? itmTransMdl.getEditFlag() : itmProcessMdl.getEditFlag();
                }
                UserInfoBean userInfoBean = (UserInfoBean)session.getAttribute("USER_INFO");
                String chgXMLStr = request.getParameter("XML_STR");
                responseStr = ITMActionsServlet.getActions(objName, objContext, editFlag, userInfoBean, objType);
                if (userInfoBean != null) {
                    String action = "VIEW";
                    if (editFlag != null && editFlag.equals("A")) {
                        action = "ADD";
                    } else if (editFlag != null && editFlag.equals("E")) {
                        action = "EDIT";
                    }
                    EventLogInfoBean eventInfoBean = new EventLogInfoBean(userInfoBean.getLoginCode());
                    String tranId = "";
                    if (itmTransMdl != null && itmTransMdl.masterStateful != null) {
                        tranId = itmTransMdl.masterStateful.getTranId();
                    }
                }
                response.setBufferSize(1024);
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ServletOutputStream outStream = response.getOutputStream();
                outStream.write(responseStr.getBytes());
                outStream.flush();
                outStream.close();
            }
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                itme.printStackTrace(new PrintStream(baos));
                response.setContentLength(baos.toString().length());
                writer.println(baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                String errMsg = "";
                response.setContentLength(baos.toString().length());
                writer.println("ERR_MSG :" + errMsg + "\n" + baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String getActions(String objName, String objContext, String editFlag, UserInfoBean userInfoBean, String objType) throws Exception, ITMException {
        String retVal = "";
        String titleStr = "";
        String serviceCodeStr = "";
        Object profileID = null;
        StringBuffer titlesBuffer = new StringBuffer();
        StringBuffer serviceCodeBuffer = new StringBuffer();
        String transDB = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            ITMActionsEJB ejbObj = new ITMActionsEJB();
            if (userInfoBean != null && (transDB = userInfoBean.getTransDB()) != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0) {
                retVal = ejbObj.getFilteredActions(objName, objContext, editFlag, userInfoBean.getProfileId(), userInfoBean.getUserLevel(), objType, userInfoBean);
            }
            ejbObj = null;
        }
        catch (ITMException itme) {
            retVal = itme.getMessage();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retVal;
    }
}

