/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.DMSConnLogMonitor;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.DocumentType;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.commons.io.IOUtils;

public class RepositoryHandler {
    private HashMap<String, String> mimeTypes = new HashMap();
    private HashMap<String, String> contentServiceDetailMap = null;
    private UserInfoBean userInfo = null;

    public RepositoryHandler(HashMap<String, String> contentServiceDetailMap, UserInfoBean userInfo) throws ITMException {
        this.userInfo = userInfo;
        this.contentServiceDetailMap = contentServiceDetailMap;
        this.createSession();
    }

    private Session createSession() throws ITMException {
        Session session = null;
        String connectionStatus = "";
        try {
            try {
                String connectionName = this.getConnectionDetail("CONNECTION_NAME");
                BaseLogger.log("3", this.userInfo, null, "connectionName : [" + connectionName + "]");
                session = CommonConstants.contentServiceSessionMap.get(connectionName);
                if (session == null) {
                    String userName = this.getConnectionDetail("USER");
                    String password = this.getConnectionDetail("PASSWORD");
                    String serverUrl = this.getConnectionDetail("SERVER_URL");
                    String bindingType = this.getConnectionDetail("BINDING_TYPE");
                    BaseLogger.log("3", this.userInfo, null, "Not connected, creating new connection to Alfresco with the connection id (" + connectionName + ")");
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("org.apache.chemistry.opencmis.user", userName);
                    parameters.put("org.apache.chemistry.opencmis.password", password);
                    if (BindingType.BROWSER.value().equalsIgnoreCase(bindingType)) {
                        parameters.put("org.apache.chemistry.opencmis.binding.browser.url", serverUrl);
                    } else if (BindingType.WEBSERVICES.value().equalsIgnoreCase(bindingType)) {
                        parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", String.valueOf(serverUrl) + "/ACLService?wsdl");
                        parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", String.valueOf(serverUrl) + "/DiscoveryService?wsdl");
                        parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", String.valueOf(serverUrl) + "/MultiFilingService?wsdl");
                        parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", String.valueOf(serverUrl) + "/NavigationService?wsdl");
                        parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", String.valueOf(serverUrl) + "/ObjectService?wsdl");
                        parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", String.valueOf(serverUrl) + "/PolicyService?wsdl");
                        parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", String.valueOf(serverUrl) + "/RelationshipService?wsdl");
                        parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", String.valueOf(serverUrl) + "/RepositoryService?wsdl");
                        parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", String.valueOf(serverUrl) + "/VersioningService?wsdl");
                    } else {
                        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", serverUrl);
                    }
                    parameters.put("org.apache.chemistry.opencmis.binding.spi.type", bindingType.toLowerCase());
                    parameters.put("org.apache.chemistry.opencmis.binding.compression", "true");
                    parameters.put("org.apache.chemistry.opencmis.cache.objects.ttl", "0");
                    BaseLogger.log("3", this.userInfo, null, "parameters : [" + parameters + "]");
                    SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
                    List repositories = sessionFactory.getRepositories(parameters);
                    Repository alfrescoRepository = null;
                    if (repositories == null || repositories.size() <= 0) {
                        connectionStatus = "exception";
                        throw new CmisConnectionException("Could not connect to the Alfresco Server, no repository found!");
                    }
                    BaseLogger.log("3", this.userInfo, null, "Found (" + repositories.size() + ") Alfresco repositories");
                    alfrescoRepository = (Repository)repositories.get(0);
                    BaseLogger.log("3", this.userInfo, null, "Info about the first Alfresco repo [ID=" + alfrescoRepository.getId() + "]" + "[name=" + alfrescoRepository.getName() + "]" + "[CMIS ver supported=" + alfrescoRepository.getCmisVersionSupported() + "]");
                    session = alfrescoRepository.createSession();
                    connectionStatus = "new";
                    CommonConstants.contentServiceSessionMap.put(connectionName, session);
                } else {
                    connectionStatus = "reused";
                    BaseLogger.log("3", this.userInfo, null, "Already connected to Alfresco with the connection id (" + connectionName + ")");
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :: createSession : [" + e.getMessage() + "]");
                connectionStatus = "exception";
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        catch (Throwable throwable) {
            this.updateConnectionDetails(session, null, connectionStatus);
            throw throwable;
        }
        this.updateConnectionDetails(session, null, connectionStatus);
        return session;
    }

    private Session getSession() {
        String sessionMapKey = this.getConnectionDetail("CONNECTION_NAME");
        BaseLogger.log("3", this.userInfo, null, "sessionMapKey : [" + sessionMapKey + "]");
        return CommonConstants.contentServiceSessionMap.get(sessionMapKey);
    }

    private CmisObject getObject(Session session, Folder parentFolder, String folderPath) {
        CmisObject object = null;
        try {
            String path2Object = parentFolder.getPath();
            if (!path2Object.endsWith("/")) {
                path2Object = String.valueOf(path2Object) + "/";
            }
            if (folderPath != null && folderPath.length() > 0 && folderPath.startsWith("/")) {
                folderPath = folderPath.substring(1);
            }
            path2Object = String.valueOf(path2Object) + folderPath;
            object = session.getObjectByPath(path2Object);
            BaseLogger.log("3", this.userInfo, null, "object : [" + object + "]");
        }
        catch (CmisObjectNotFoundException nfe0) {
            BaseLogger.log("3", this.userInfo, null, "CmisObject does Not exits [" + (Object)((Object)nfe0) + "]");
        }
        return object;
    }

    private Folder obtainPath(String enterprise, String module, String refser, Session session, String docId) {
        String rootPath = "User Homes/";
        Folder rootFolder = (Folder)this.getObject(session, session.getRootFolder(), rootPath);
        BaseLogger.log("3", this.userInfo, null, "In obtainPath rootFolder : [" + rootFolder.getPath() + "]");
        if (enterprise == null || enterprise.length() == 0) {
            enterprise = "admin";
        }
        Folder enterpriseFolder = (Folder)this.getObject(session, rootFolder, enterprise);
        BaseLogger.log("3", this.userInfo, null, "In obtainPath enterpriseFolder : [" + enterpriseFolder + "]");
        rootFolder = enterpriseFolder == null ? this.createFolder(session, rootFolder, enterprise) : enterpriseFolder;
        if (module != null && module.length() > 0) {
            Folder moduleFolder = (Folder)this.getObject(session, rootFolder, module);
            BaseLogger.log("3", this.userInfo, null, "In obtainPath moduleFolder : [" + moduleFolder + "]");
            rootFolder = moduleFolder == null ? this.createFolder(session, rootFolder, module) : moduleFolder;
        }
        if (refser != null && refser.length() > 0) {
            Folder refserFolder = (Folder)this.getObject(session, rootFolder, refser);
            BaseLogger.log("3", this.userInfo, null, "In obtainPath refserFolder : [" + refserFolder + "]");
            rootFolder = refserFolder == null ? this.createFolder(session, rootFolder, refser) : refserFolder;
        }
        Folder docIdFolder = (Folder)this.getObject(session, rootFolder, docId);
        BaseLogger.log("3", this.userInfo, null, "docIdFolder : [" + docIdFolder + "]");
        rootFolder = docIdFolder == null ? this.createFolder(session, rootFolder, docId) : docIdFolder;
        return rootFolder;
    }

    private Folder createFolder(Session session, Folder parentFolder, String folderName) {
        Folder newFolder = null;
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("cmis:objectTypeId", "cmis:folder");
            param.put("cmis:name", folderName);
            newFolder = parentFolder.createFolder(param);
            BaseLogger.log("3", this.userInfo, null, "newFolder created : [" + newFolder.getPath() + "]");
        }
        catch (Exception e) {
            BaseLogger.log("3", this.userInfo, null, "RepositoryHandlerAlfresco.createFolder() :[" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return newFolder;
    }

    public HashMap<String, String> upload(String refser, String refId, String docId, String documentName, byte[] docObjectArray, String cmsPath, List<String> list, String uuidRefID, String enterprise, String module) throws ITMException {
        BaseLogger.log("3", this.userInfo, null, "In AlfrescoRepositoryHandler upload()");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        enterprise = this.checkNull(enterprise);
        BaseLogger.log("3", this.userInfo, null, "enterprise : [" + enterprise + "]");
        Session session = this.getSession();
        dataMap.put("DMS_TENANT", this.getConnectionDetail("USER"));
        module = this.checkNull(module);
        BaseLogger.log("3", this.userInfo, null, "module : [" + module + "]");
        refser = this.checkNull(refser);
        BaseLogger.log("3", this.userInfo, null, "refser : [" + refser + "]");
        Folder docIdFolder = this.obtainPath(enterprise, module, refser, session, docId);
        String docIdFolderPath = docIdFolder.getPath();
        BaseLogger.log("3", this.userInfo, null, "docIdFolderPath : [" + docIdFolderPath + "]");
        dataMap.put("DOCUMENT_PATH", docIdFolderPath);
        Document newDocument = null;
        HashMap<String, String> newDocumentProps = new HashMap<String, String>();
        newDocumentProps.put("cmis:objectTypeId", "cmis:document");
        newDocumentProps.put("cmis:name", documentName);
        ByteArrayInputStream is = null;
        String docUUId = "";
        try {
            is = new ByteArrayInputStream(docObjectArray);
            String mimetype = this.getMimeType(documentName);
            ContentStream contentStream = session.getObjectFactory().createContentStream(documentName, (long)docObjectArray.length, mimetype, (InputStream)is);
            newDocument = docIdFolder.createDocument(newDocumentProps, contentStream, VersioningState.MAJOR);
            docUUId = newDocument.getId();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            this.clearSession(session);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        this.clearSession(session);
        dataMap.put("DOC_UUID", docUUId);
        BaseLogger.log("3", this.userInfo, null, "dataMap : [" + dataMap + "]");
        return dataMap;
    }

    public byte[] download(String refSer, String docId, String refId, String uuId, String enterprise, String module, String documentPath, String dmsTenant) throws ITMException {
        ByteArrayOutputStream baos = null;
        try {
            InputStream isr = this.getFileStream(refSer, docId, refId, uuId, enterprise, module, documentPath, dmsTenant);
            InputStreamReader reader = new InputStreamReader(isr, "ISO-8859-1");
            baos = new ByteArrayOutputStream();
            int c = -1;
            while ((c = reader.read()) != -1) {
                baos.write(c);
            }
            return baos.toByteArray();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getFileStream(String refSer, String docId, String refId, String uuId, String enterprise, String module, String documentPath, String dmsTenant) throws ITMException {
        InputStream fileStream;
        block16: {
            fileStream = null;
            Session session = null;
            try {
                try {
                    session = this.getSession();
                    module = this.checkNull(module);
                    BaseLogger.log("3", this.userInfo, null, "module : [" + module + "]");
                    refSer = this.checkNull(refSer);
                    BaseLogger.log("3", this.userInfo, null, "refser : [" + refSer + "]");
                    String rootPath = "";
                    documentPath = this.checkNull(documentPath);
                    if (documentPath.length() > 0) {
                        rootPath = documentPath;
                    } else {
                        rootPath = "User Homes/";
                        if (enterprise == null || enterprise.length() == 0) {
                            enterprise = "admin";
                        }
                        BaseLogger.log("3", this.userInfo, null, "enterprise : [" + enterprise + "]");
                        rootPath = "User Homes/" + enterprise + "/";
                        BaseLogger.log("3", this.userInfo, null, "rootPath : [" + rootPath + "]");
                        if (module != null && module.length() > 0) {
                            rootPath = String.valueOf(rootPath) + module + "/";
                        }
                        if (refSer != null && refSer.length() > 0) {
                            rootPath = String.valueOf(rootPath) + refSer + "/";
                        }
                        if (docId != null && docId.length() > 0) {
                            rootPath = String.valueOf(rootPath) + docId;
                        }
                    }
                    BaseLogger.log("3", this.userInfo, null, "rootpath in download : [" + rootPath + "]");
                    Folder docIdFolder = (Folder)this.getObject(session, session.getRootFolder(), rootPath);
                    if (docIdFolder != null) {
                        ItemIterable contentItems = docIdFolder.getChildren();
                        for (CmisObject contentItem : contentItems) {
                            if (contentItem instanceof Document && contentItem.getId().equals(uuId)) {
                                Document newDocument = (Document)contentItem;
                                ContentStream docContent = newDocument.getContentStream();
                                try {
                                    fileStream = docContent.getStream();
                                    byte[] fileBytes = E12GenericUtility.readStreamAsBytes(fileStream);
                                    fileStream = new ByteArrayInputStream(fileBytes);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                continue;
                            }
                            BaseLogger.log("3", this.userInfo, null, "Else ( contentItem instanceof Document && contentItem.getId().equals( uuId ) )");
                        }
                        break block16;
                    }
                    throw new Exception(" Unable to find the document at path [" + rootPath + "] [" + session.getRootFolder() + "]");
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "\n\nException :getFileStream " + e.getMessage());
                    throw new ITMException(e);
                }
            }
            finally {
                this.clearSession(session);
            }
        }
        return fileStream;
    }

    private void setMimeType() {
        this.mimeTypes.put("ai", "application/postscript");
        this.mimeTypes.put("aif", "audio/x-aiff");
        this.mimeTypes.put("aifc", "audio/x-aiff");
        this.mimeTypes.put("aiff", "audio/x-aiff");
        this.mimeTypes.put("asc", "text/plain");
        this.mimeTypes.put("asf", "video/x.ms.asf");
        this.mimeTypes.put("asx", "video/x.ms.asx");
        this.mimeTypes.put("au", "audio/basic");
        this.mimeTypes.put("avi", "video/x-msvideo");
        this.mimeTypes.put("bcpio", "application/x-bcpio");
        this.mimeTypes.put("bin", "application/octet-stream");
        this.mimeTypes.put("cab", "application/x-cabinet");
        this.mimeTypes.put("cdf", "application/x-netcdf");
        this.mimeTypes.put("class", "application/java-vm");
        this.mimeTypes.put("cpio", "application/x-cpio");
        this.mimeTypes.put("cpt", "application/mac-compactpro");
        this.mimeTypes.put("crt", "application/x-x509-ca-cert");
        this.mimeTypes.put("csh", "application/x-csh");
        this.mimeTypes.put("css", "text/css");
        this.mimeTypes.put("csv", "text/comma-separated-values");
        this.mimeTypes.put("dcr", "application/x-director");
        this.mimeTypes.put("dir", "application/x-director");
        this.mimeTypes.put("dll", "application/x-msdownload");
        this.mimeTypes.put("dms", "application/octet-stream");
        this.mimeTypes.put("doc", "application/msword");
        this.mimeTypes.put("dtd", "application/xml-dtd");
        this.mimeTypes.put("dvi", "application/x-dvi");
        this.mimeTypes.put("dxr", "application/x-director");
        this.mimeTypes.put("eps", "application/postscript");
        this.mimeTypes.put("etx", "text/x-setext");
        this.mimeTypes.put("exe", "application/octet-stream");
        this.mimeTypes.put("ez", "application/andrew-inset");
        this.mimeTypes.put("gif", "image/gif");
        this.mimeTypes.put("gtar", "application/x-gtar");
        this.mimeTypes.put("gz", "application/gzip");
        this.mimeTypes.put("gzip", "application/gzip");
        this.mimeTypes.put("hdf", "application/x-hdf");
        this.mimeTypes.put("htc", "text/x-component");
        this.mimeTypes.put("hqx", "application/mac-binhex40");
        this.mimeTypes.put("html", "text/html");
        this.mimeTypes.put("htm", "text/html");
        this.mimeTypes.put("ice", "x-conference/x-cooltalk");
        this.mimeTypes.put("ief", "image/ief");
        this.mimeTypes.put("iges", "model/iges");
        this.mimeTypes.put("igs", "model/iges");
        this.mimeTypes.put("jar", "application/java-archive");
        this.mimeTypes.put("java", "text/plain");
        this.mimeTypes.put("jnlp", "application/x-java-jnlp-file");
        this.mimeTypes.put("jpeg", "image/jpeg");
        this.mimeTypes.put("jpe", "image/jpeg");
        this.mimeTypes.put("jpg", "image/jpeg");
        this.mimeTypes.put("js", "application/x-javascript");
        this.mimeTypes.put("jsp", "text/plain");
        this.mimeTypes.put("kar", "audio/midi");
        this.mimeTypes.put("latex", "application/x-latex");
        this.mimeTypes.put("lha", "application/octet-stream");
        this.mimeTypes.put("lzh", "application/octet-stream");
        this.mimeTypes.put("man", "application/x-troff-man");
        this.mimeTypes.put("mathml", "application/mathml+xml");
        this.mimeTypes.put("me", "application/x-troff-me");
        this.mimeTypes.put("mesh", "model/mesh");
        this.mimeTypes.put("mid", "audio/midi");
        this.mimeTypes.put("midi", "audio/midi");
        this.mimeTypes.put("mif", "application/vnd.mif");
        this.mimeTypes.put("mol", "chemical/x-mdl-molfile");
        this.mimeTypes.put("movie", "video/x-sgi-movie");
        this.mimeTypes.put("mov", "video/quicktime");
        this.mimeTypes.put("mp2", "audio/mpeg");
        this.mimeTypes.put("mp3", "audio/mpeg");
        this.mimeTypes.put("mpeg", "video/mpeg");
        this.mimeTypes.put("mpe", "video/mpeg");
        this.mimeTypes.put("mpga", "audio/mpeg");
        this.mimeTypes.put("mpg", "video/mpeg");
        this.mimeTypes.put("ms", "application/x-troff-ms");
        this.mimeTypes.put("msh", "model/mesh");
        this.mimeTypes.put("msi", "application/octet-stream");
        this.mimeTypes.put("nc", "application/x-netcdf");
        this.mimeTypes.put("oda", "application/oda");
        this.mimeTypes.put("ogg", "application/ogg");
        this.mimeTypes.put("pbm", "image/x-portable-bitmap");
        this.mimeTypes.put("pdb", "chemical/x-pdb");
        this.mimeTypes.put("pdf", "application/pdf");
        this.mimeTypes.put("pgm", "image/x-portable-graymap");
        this.mimeTypes.put("pgn", "application/x-chess-pgn");
        this.mimeTypes.put("png", "image/png");
        this.mimeTypes.put("pnm", "image/x-portable-anymap");
        this.mimeTypes.put("ppm", "image/x-portable-pixmap");
        this.mimeTypes.put("ppt", "application/vnd.ms-powerpoint");
        this.mimeTypes.put("ps", "application/postscript");
        this.mimeTypes.put("qt", "video/quicktime");
        this.mimeTypes.put("ra", "audio/x-pn-realaudio");
        this.mimeTypes.put("ra", "audio/x-realaudio");
        this.mimeTypes.put("ram", "audio/x-pn-realaudio");
        this.mimeTypes.put("ras", "image/x-cmu-raster");
        this.mimeTypes.put("rdf", "application/rdf+xml");
        this.mimeTypes.put("rgb", "image/x-rgb");
        this.mimeTypes.put("rm", "audio/x-pn-realaudio");
        this.mimeTypes.put("roff", "application/x-troff");
        this.mimeTypes.put("rpm", "application/x-rpm");
        this.mimeTypes.put("rpm", "audio/x-pn-realaudio");
        this.mimeTypes.put("rtf", "application/rtf");
        this.mimeTypes.put("rtx", "text/richtext");
        this.mimeTypes.put("ser", "application/java-serialized-object");
        this.mimeTypes.put("sgml", "text/sgml");
        this.mimeTypes.put("sgm", "text/sgml");
        this.mimeTypes.put("sh", "application/x-sh");
        this.mimeTypes.put("shar", "application/x-shar");
        this.mimeTypes.put("silo", "model/mesh");
        this.mimeTypes.put("sit", "application/x-stuffit");
        this.mimeTypes.put("skd", "application/x-koan");
        this.mimeTypes.put("skm", "application/x-koan");
        this.mimeTypes.put("skp", "application/x-koan");
        this.mimeTypes.put("skt", "application/x-koan");
        this.mimeTypes.put("smi", "application/smil");
        this.mimeTypes.put("smil", "application/smil");
        this.mimeTypes.put("snd", "audio/basic");
        this.mimeTypes.put("spl", "application/x-futuresplash");
        this.mimeTypes.put("src", "application/x-wais-source");
        this.mimeTypes.put("sv4cpio", "application/x-sv4cpio");
        this.mimeTypes.put("sv4crc", "application/x-sv4crc");
        this.mimeTypes.put("svg", "image/svg+xml");
        this.mimeTypes.put("swf", "application/x-shockwave-flash");
        this.mimeTypes.put("t", "application/x-troff");
        this.mimeTypes.put("tar", "application/x-tar");
        this.mimeTypes.put("tar.gz", "application/x-gtar");
        this.mimeTypes.put("tcl", "application/x-tcl");
        this.mimeTypes.put("tex", "application/x-tex");
        this.mimeTypes.put("texi", "application/x-texinfo");
        this.mimeTypes.put("texinfo", "application/x-texinfo");
        this.mimeTypes.put("tgz", "application/x-gtar");
        this.mimeTypes.put("tiff", "image/tiff");
        this.mimeTypes.put("tif", "image/tiff");
        this.mimeTypes.put("tr", "application/x-troff");
        this.mimeTypes.put("tsv", "text/tab-separated-values");
        this.mimeTypes.put("txt", "text/plain");
        this.mimeTypes.put("ustar", "application/x-ustar");
        this.mimeTypes.put("vcd", "application/x-cdlink");
        this.mimeTypes.put("vrml", "model/vrml");
        this.mimeTypes.put("vxml", "application/voicexml+xml");
        this.mimeTypes.put("wav", "audio/x-wav");
        this.mimeTypes.put("wbmp", "image/vnd.wap.wbmp");
        this.mimeTypes.put("wmlc", "application/vnd.wap.wmlc");
        this.mimeTypes.put("wmlsc", "application/vnd.wap.wmlscriptc");
        this.mimeTypes.put("wmls", "text/vnd.wap.wmlscript");
        this.mimeTypes.put("wml", "text/vnd.wap.wml");
        this.mimeTypes.put("wrl", "model/vrml");
        this.mimeTypes.put("wtls-ca-certificate", "application/vnd.wap.wtls-ca-certificate");
        this.mimeTypes.put("xbm", "image/x-xbitmap");
        this.mimeTypes.put("xht", "application/xhtml+xml");
        this.mimeTypes.put("xhtml", "application/xhtml+xml");
        this.mimeTypes.put("xls", "application/vnd.ms-excel");
        this.mimeTypes.put("xml", "application/xml");
        this.mimeTypes.put("xpm", "image/x-xpixmap");
        this.mimeTypes.put("xpm", "image/x-xpixmap");
        this.mimeTypes.put("xsl", "application/xml");
        this.mimeTypes.put("xslt", "application/xslt+xml");
        this.mimeTypes.put("xul", "application/vnd.mozilla.xul+xml");
        this.mimeTypes.put("xwd", "image/x-xwindowdump");
        this.mimeTypes.put("xyz", "chemical/x-xyz");
        this.mimeTypes.put("z", "application/compress");
        this.mimeTypes.put("zip", "application/zip");
    }

    private String getMimeType(String documentName) {
        String mimeType = "application/octet-stream";
        String docType = "";
        if ((documentName = this.checkNull(documentName)).length() > 0) {
            docType = documentName.substring(documentName.lastIndexOf(".") + 1);
        }
        BaseLogger.log("3", this.userInfo, null, "docType - [" + docType + "]");
        if (this.mimeTypes == null || this.mimeTypes.size() == 0) {
            this.setMimeType();
        }
        if (this.mimeTypes.containsKey(docType)) {
            mimeType = this.mimeTypes.get(docType);
        }
        return mimeType;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public void delete(String refSer, String docId, String refId) throws ITMException {
    }

    public void delete(String refSer, String docId, String refId, String docUuid, String enterprise, String documentPath, String dmsTenant) throws ITMException {
        Session session = null;
        try {
            try {
                session = this.getSession();
                String module = "";
                refSer = this.checkNull(refSer);
                String rootPath = "";
                documentPath = this.checkNull(documentPath);
                if (documentPath.length() > 0) {
                    rootPath = documentPath;
                } else {
                    rootPath = "User Homes/";
                    if (enterprise == null || enterprise.length() == 0) {
                        enterprise = "admin";
                    }
                    BaseLogger.log("3", this.userInfo, null, "enterprise : [" + enterprise + "]");
                    rootPath = "User Homes/" + enterprise + "/";
                    BaseLogger.log("3", this.userInfo, null, "rootPath : [" + rootPath + "]");
                    if (module != null && module.length() > 0) {
                        rootPath = String.valueOf(rootPath) + module + "/";
                    }
                    if (refSer != null && refSer.length() > 0) {
                        rootPath = String.valueOf(rootPath) + refSer + "/";
                    }
                    if (docId != null && docId.length() > 0) {
                        rootPath = String.valueOf(rootPath) + docId;
                    }
                }
                BaseLogger.log("3", this.userInfo, null, "rootpath in download : [" + rootPath + "]");
                Folder docIdFolder = (Folder)this.getObject(session, session.getRootFolder(), rootPath);
                docIdFolder.deleteTree(true, UnfileObject.DELETE, true);
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :: Delete  : [" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            this.clearSession(session);
        }
    }

    public HashMap<String, String> checkInDocument(String docUUId, String docName, byte[] docObjectArray, boolean isMajorVer, String checkinComment) throws ITMException {
        ByteArrayInputStream stream;
        Session session;
        HashMap<String, String> dataMap;
        block10: {
            dataMap = new HashMap<String, String>();
            session = null;
            stream = null;
            try {
                try {
                    BaseLogger.log("3", this.userInfo, null, "docUUId : [" + docUUId + "], docName : [" + docName + "]");
                    BaseLogger.log("3", this.userInfo, null, "isMajorVer : [" + isMajorVer + "], checkinComment : [" + checkinComment + "]");
                    session = this.getSession();
                    dataMap.put("DMS_TENANT", this.getConnectionDetail("USER"));
                    Document doc = (Document)session.getObject(docUUId);
                    if (doc != null) {
                        BaseLogger.log("3", this.userInfo, null, "name : [" + doc.getName() + "], doc.getAllowableActions().getAllowableActions() [" + doc.getAllowableActions().getAllowableActions() + "]");
                        String docIdFolderPath = ((Folder)doc.getParents().get(0)).getPath();
                        dataMap.put("DOCUMENT_PATH", docIdFolderPath);
                        if (doc.getAllowableActions().getAllowableActions().contains(Action.CAN_CHECK_OUT)) {
                            doc.refresh();
                            String fileName = doc.getContentStream().getFileName();
                            BaseLogger.log("3", this.userInfo, null, "fileName : [" + fileName + "]");
                            ObjectId idOfCheckedOutDocument = doc.checkOut();
                            BaseLogger.log("3", this.userInfo, null, "repositoryHandl line no 866 idOfCheckedOutDocument: " + idOfCheckedOutDocument);
                            Document oldDocument = (Document)session.getObject(idOfCheckedOutDocument);
                            BaseLogger.log("3", this.userInfo, null, "repositoryHandl line no 868 oldDocument " + oldDocument);
                            String mimetype = this.getMimeType(docName);
                            BaseLogger.log("3", this.userInfo, null, "mimetype line 871: " + mimetype);
                            stream = new ByteArrayInputStream(docObjectArray);
                            DocumentType documentType = (DocumentType)session.getTypeDefinition("cmis:document");
                            boolean isVersionable = Boolean.TRUE.equals(documentType.isVersionable());
                            BaseLogger.log("3", this.userInfo, null, "isVersionable line 871: " + isVersionable);
                            HashMap<String, String> newDocumentProps = new HashMap<String, String>();
                            newDocumentProps.put("cmis:objectTypeId", "cmis:document");
                            newDocumentProps.put("cmis:name", docName);
                            BaseLogger.log("3", this.userInfo, null, "respository handl line 878");
                            ContentStream contentStream = session.getObjectFactory().createContentStream(docName, (long)((InputStream)stream).available(), mimetype, (InputStream)stream);
                            BaseLogger.log("3", this.userInfo, null, "RepoHandl isMajorVer: [" + isMajorVer + "] newDocumentProps:[ " + newDocumentProps + "] contentStream:[" + contentStream + "] checkinComment:[" + checkinComment + "]");
                            ObjectId objectId = null;
                            try {
                                objectId = oldDocument.checkIn(isMajorVer, null, contentStream, "Version updated");
                            }
                            catch (CmisContentAlreadyExistsException cme) {
                                BaseLogger.log("0", this.userInfo, null, "Exception :: checkInDocument : getExceptionName [" + cme.getExceptionName() + "] getErrorContent [" + cme.getErrorContent() + "] getMessage [" + cme.getMessage() + "]");
                                cme.getStackTrace();
                            }
                            BaseLogger.log("3", this.userInfo, null, "RepoHandl objectId :" + objectId);
                            doc = (Document)session.getObject(objectId);
                            docUUId = doc.getId();
                            dataMap.put("DOC_UUID", docUUId);
                            BaseLogger.log("3", this.userInfo, null, "Created docUUId : [" + docUUId + "]");
                            BaseLogger.log("3", this.userInfo, null, "Version label : [" + doc.getVersionLabel() + "]");
                            break block10;
                        }
                        BaseLogger.log("3", this.userInfo, null, "CHECK_OUT not allowed for docUUId [" + docUUId + "]");
                        break block10;
                    }
                    throw new Exception("Unable to find the document of docUUId [" + docUUId + "]");
                }
                catch (Exception e) {
                    BaseLogger.log("0", this.userInfo, null, "Exception :: checkInDocument : [" + e.getMessage() + "]");
                    throw new ITMException(e);
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    IOUtils.closeQuietly(stream);
                }
                this.clearSession(session);
                throw throwable;
            }
        }
        if (stream != null) {
            IOUtils.closeQuietly(stream);
        }
        this.clearSession(session);
        return dataMap;
    }

    public ArrayList<String> searchDocumentId(String module, String entUser, String searchText) throws ITMException {
        Session session = null;
        ArrayList<String> idList = new ArrayList<String>();
        try {
            try {
                session = this.getSession();
                searchText = this.checkNull(searchText);
                if (!searchText.equals("") && !module.equals("")) {
                    String folderQuery = this.getFolderQuery(module, session);
                    BaseLogger.log("3", this.userInfo, null, "folderQuery [" + folderQuery + "]");
                    ArrayList<CmisObject> results = this.searchDocument(folderQuery, searchText, session);
                    if (results != null) {
                        for (CmisObject result : results) {
                            idList.add(result.getId());
                        }
                    }
                    BaseLogger.log("3", this.userInfo, null, "idList [" + idList + "]");
                }
            }
            catch (Exception e) {
                BaseLogger.log("3", this.userInfo, null, "Exception :: searchDocumentId : [" + e.getMessage() + "]");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            this.clearSession(session);
        }
        return idList;
    }

    private ArrayList<CmisObject> searchDocument(String query, String search, Session session) throws ITMException {
        ArrayList results = null;
        if (query != null && query.length() > 0) {
            String queryString = "select * from cmis:document where contains('" + search + "*" + "') " + query + " ";
            BaseLogger.log("3", this.userInfo, null, "queryString [" + queryString + "]");
            results = (ArrayList)this.getQueryResults(queryString, session);
            BaseLogger.log("3", this.userInfo, null, "getQueryResults :: results : [" + results + "]");
        }
        return results;
    }

    private String getFolderQuery(String folderName, Session session) throws ITMException {
        String folderQuery = "";
        try {
            BaseLogger.log("3", this.userInfo, null, "folderName [" + folderName + "]");
            String queryString = "select * from cmis:folder where cmis:name='" + folderName + "' ";
            BaseLogger.log("3", this.userInfo, null, "In getFolderQuery :: queryString : [" + queryString + "]");
            List<CmisObject> list = this.getQueryResults(queryString, session);
            for (CmisObject item : list) {
                if (!(item instanceof Folder)) continue;
                Folder folder = (Folder)item;
                BaseLogger.log("3", this.userInfo, null, "In getFolderQuery and folder is :[" + folder + "] and folder path is [" + folder.getPath() + "]");
                ItemIterable fol = folder.getChildren();
                for (CmisObject lis : fol) {
                    if (!(lis instanceof Folder)) continue;
                    Folder folder1 = (Folder)lis;
                    folderQuery = String.valueOf(folderQuery) + " IN_TREE( '" + folder1.getId() + "') or";
                }
            }
            if (folderQuery.lastIndexOf("or") != -1) {
                folderQuery = folderQuery.substring(0, folderQuery.length() - 2);
                folderQuery = "and ( " + folderQuery + " )";
            }
            BaseLogger.log("3", this.userInfo, null, "folderQuery : [" + folderQuery + "]");
        }
        catch (Exception e) {
            BaseLogger.log("3", this.userInfo, null, "Exception :: getFolderQuery : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return folderQuery;
    }

    private List<CmisObject> getQueryResults(String queryString, Session session) throws ITMException {
        ArrayList<CmisObject> objList;
        block3: {
            objList = new ArrayList<CmisObject>();
            try {
                ItemIterable results = session.query(queryString, false);
                BaseLogger.log("3", this.userInfo, null, "results [" + results + "]");
                if (results == null) break block3;
                for (QueryResult qResult : results) {
                    String objectId = "";
                    PropertyData propData = qResult.getPropertyById("cmis:objectId");
                    objectId = propData != null ? (String)propData.getFirstValue() : (String)qResult.getPropertyValueByQueryName("d.cmis:objectId");
                    CmisObject obj = session.getObject(session.createObjectId(objectId));
                    objList.add(obj);
                    if (objList.size() != 1000) continue;
                    System.out.println("RepositoryHandler.getQueryResults() exceed count 1000");
                    break;
                }
            }
            catch (Exception e) {
                BaseLogger.log("3", this.userInfo, null, "Exception :: getFolderQuery [" + e.getMessage() + "]");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return objList;
    }

    private void clearSession(Session session) {
        try {
            this.updateConnectionDetails(session, null, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateConnectionDetails(Session session, StackTraceElement[] stackTraceElements, String status) {
        try {
            String connectionId = this.getConnectionDetail("CONNECTION_ID");
            Date startTime = null;
            int successCount = 0;
            Date lastSuccessTime = null;
            int errorCount = 0;
            Date lastErrorTime = null;
            if ("new".equalsIgnoreCase(status) || "reused".equalsIgnoreCase(status)) {
                if ("new".equalsIgnoreCase(status)) {
                    startTime = new Date();
                }
                successCount = 1;
                lastSuccessTime = new Date();
            } else {
                errorCount = 1;
                lastErrorTime = new Date();
            }
            DMSConnLogMonitor dmsConnenctionInfo = new DMSConnLogMonitor(this.userInfo.getLoginCode(), this.userInfo.getTransDB(), connectionId, status, startTime, successCount, lastSuccessTime, errorCount, lastErrorTime, this.userInfo.getRemoteHost());
            dmsConnenctionInfo.updateDMSConnMonitorSummary();
            dmsConnenctionInfo = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in updateConnectionDetails : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private String getStackTrace(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        try {
            if (stackTraceElements != null && stackTraceElements.length >= 7) {
                int i = 3;
                while (i < 6) {
                    sb.append("\n " + stackTraceElements[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getStackTrace:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String getConnectionDetail(String key) {
        if (this.contentServiceDetailMap != null) {
            return this.contentServiceDetailMap.get(key);
        }
        return null;
    }

    public void remove() {
        this.contentServiceDetailMap = null;
        this.userInfo = null;
    }
}

