/*
 * Decompiled with CFR 0.152.
 */
package ibase.util;

import ibase.entity.Employee;
import ibase.entity.FeedbackCalendar;
import ibase.entity.Holiday;
import ibase.entity.Leave;
import ibase.entity.Plan;
import ibase.entity.Report;
import ibase.entity.TodaysPlan;
import ibase.util.DbConnection;
import ibase.utility.BaseLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmployeeDao {
    ResultSet rs = null;
    Statement stmt = null;
    Connection conn = null;

    public List<String> getEmployeeCodeName() {
        ArrayList<String> empCodeList;
        block29: {
            empCodeList = new ArrayList<String>();
            try {
                try {
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    String sql = "select emp_code,EMP_FNAME,EMP_MNAME,EMP_LNAME from employee start with report_to = '1515' connect by prior emp_code = report_to";
                    BaseLogger.log((String)"0", null, null, (Object)("getEmployeeCodeName sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    while (this.rs.next()) {
                        empCodeList.add(String.valueOf(this.rs.getString(1).trim()) + " " + this.rs.getNString(2).trim() + " " + this.rs.getString(3).trim() + " " + this.rs.getString(4).trim());
                    }
                    BaseLogger.log((String)"0", null, null, (Object)("getEmployeeCodeName()=" + empCodeList));
                }
                catch (Exception exception) {
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block29;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return empCodeList;
    }

    public List<String> getEmployeeCodes() {
        ArrayList<String> empCodeList;
        block29: {
            empCodeList = new ArrayList<String>();
            try {
                try {
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    String sql = "select emp_code from employee start with report_to = '1515' connect by prior emp_code = report_to";
                    BaseLogger.log((String)"0", null, null, (Object)("getEmployeeCodes sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    while (this.rs.next()) {
                        empCodeList.add(this.rs.getString(1).trim());
                    }
                    BaseLogger.log((String)"0", null, null, (Object)("getEmployeeCodes()=" + empCodeList));
                }
                catch (Exception exception) {
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block29;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return empCodeList;
    }

    public List<Employee> getEmpList() {
        ArrayList<Employee> empList;
        block29: {
            empList = new ArrayList<Employee>();
            try {
                try {
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    String sql = "select emp_code,EMP_FNAME,EMP_MNAME,EMP_LNAME from employee start with report_to = '1515' connect by prior emp_code = report_to   order by EMP_FNAME,EMP_MNAME,EMP_LNAME";
                    BaseLogger.log((String)"0", null, null, (Object)("getEmpList() sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    while (this.rs.next()) {
                        Employee emp = new Employee();
                        emp.setEmpcode(this.rs.getString(1).trim());
                        emp.setName(String.valueOf(this.rs.getNString(2).trim()) + " " + this.rs.getString(3).trim() + " " + this.rs.getString(4).trim());
                        empList.add(emp);
                    }
                }
                catch (Exception exception) {
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block29;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return empList;
    }

    public List<Report> getData(List<String> empCode, String dateFrom, String dateTo, String requestid, int offset, int limit) {
        ArrayList<Report> list;
        block29: {
            list = new ArrayList<Report>();
            try {
                try {
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    String sql = requestid.isEmpty() ? "select FBD.REQ_ID,SR.DTL_DESCR,E.EMP_FNAME || ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' as name,FB.EMP_CODE, TO_CHAR(FB.EXECUT_DT,'DD-MON-YYYY'),srad.ACTION_DETL,sra.STDTIME, TO_CHAR(srad.PLANSTDATE,'DD-MM-YYYY'),FBD.TIME_SPENT,FBD.ACTION_STATUS  from SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra where FB.FEEDBK_ID = FBD.FEEDBK_ID  AND srad.ACTION_ID = FBD.ACTION_ID AND srad.EMP_CODE  = FB.EMP_CODE AND FBD.REQ_ID = SR.REQ_ID AND FB.EMP_CODE in ('" + String.join((CharSequence)"','", empCode).trim() + "') " + "AND " + "FB.EXECUT_DT between " + "TO_DATE('" + dateFrom + "','yyyy/mm/dd') " + "AND " + "TO_DATE('" + dateTo + "','yyyy/mm/dd') " + "AND " + "FB.EMP_CODE = E.EMP_CODE " + "group by " + "FB.EMP_CODE, FBD.REQ_ID,FBD.ACTION_ID,E.EMP_FNAME ||' '||E.EMP_LNAME || '('|| trim(FB.EMP_CODE) ||')', FB.EMP_CODE,FB.EXECUT_DT,SR.DTL_DESCR,srad.ACTION_DETL,sra.STDTIME,srad.PLANSTDATE,FBD.TIME_SPENT,FBD.ACTION_STATUS  " + "order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR OFFSET " + offset + " ROWS FETCH NEXT " + limit + " ROWS ONLY" : "select FBD.REQ_ID,SR.DTL_DESCR,E.EMP_FNAME || ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' as name,FB.EMP_CODE, TO_CHAR(FB.EXECUT_DT,'DD-MON-YYYY'),srad.ACTION_DETL,sra.STDTIME, TO_CHAR(srad.PLANSTDATE,'DD-MM-YYYY'),FBD.TIME_SPENT,FBD.ACTION_STATUS  from SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra where FB.FEEDBK_ID = FBD.FEEDBK_ID  AND srad.ACTION_ID = FBD.ACTION_ID AND srad.EMP_CODE  = FB.EMP_CODE AND FBD.REQ_ID = SR.REQ_ID AND FB.EMP_CODE in ('" + String.join((CharSequence)"','", empCode).trim() + "') " + "AND " + "FB.EXECUT_DT between " + "TO_DATE('" + dateFrom + "','yyyy/mm/dd') " + "AND " + "TO_DATE('" + dateTo + "','yyyy/mm/dd') " + "AND " + "FB.EMP_CODE = E.EMP_CODE " + " AND " + "FBD.REQ_ID='" + requestid + "'" + "group by " + "FB.EMP_CODE, FBD.REQ_ID,FBD.ACTION_ID,E.EMP_FNAME ||' '||E.EMP_LNAME || '('|| trim(FB.EMP_CODE) ||')', FB.EMP_CODE,FB.EXECUT_DT,SR.DTL_DESCR,srad.ACTION_DETL,sra.STDTIME,srad.PLANSTDATE,FBD.TIME_SPENT,FBD.ACTION_STATUS  " + "order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR OFFSET " + offset + " ROWS FETCH NEXT " + limit + " ROWS ONLY";
                    BaseLogger.log((String)"0", null, null, (Object)("getData sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    Report report = null;
                    while (this.rs.next()) {
                        BaseLogger.log((String)"0", null, null, (Object)("Rs Size" + this.rs.getFetchSize()));
                        report = new Report();
                        report.setPerson(this.rs.getString(3));
                        report.setRequestId(this.rs.getString(1));
                        report.setDescription(this.rs.getString(2));
                        report.setDate(this.rs.getString(5).toString());
                        report.setActiondtl(this.rs.getString(6));
                        report.setStdtime(this.rs.getInt(7));
                        report.setStartdate(this.rs.getString(8).toString());
                        report.setTimespend(this.rs.getInt(9));
                        report.setStatus(this.rs.getString(10));
                        list.add(report);
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"0", null, null, (Object)("Error getData" + e.getMessage()));
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block29;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return list;
    }

    public int getFeedbackDataCount(List<String> empCode, String dateFrom, String dateTo, String requestid) {
        int count;
        block28: {
            count = 0;
            try {
                try {
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    String sql = requestid.isEmpty() ? "SELECT COUNT(*) AS total_rows FROM( select FBD.REQ_ID,SR.DTL_DESCR,E.EMP_FNAME || ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' as name,FB.EMP_CODE, TO_CHAR(FB.EXECUT_DT,'DD-MON-YYYY'),srad.ACTION_DETL,sra.STDTIME, TO_CHAR(srad.PLANSTDATE,'DD-MM-YYYY'),FBD.TIME_SPENT,FBD.ACTION_STATUS  from SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra where FB.FEEDBK_ID = FBD.FEEDBK_ID  AND srad.ACTION_ID = FBD.ACTION_ID AND srad.EMP_CODE  = FB.EMP_CODE AND FBD.REQ_ID = SR.REQ_ID AND FB.EMP_CODE in ('" + String.join((CharSequence)"','", empCode).trim() + "') " + "AND " + "FB.EXECUT_DT between " + "TO_DATE('" + dateFrom + "','yyyy/mm/dd') " + "AND " + "TO_DATE('" + dateTo + "','yyyy/mm/dd') " + "AND " + "FB.EMP_CODE = E.EMP_CODE " + "group by " + "FB.EMP_CODE, FBD.REQ_ID,FBD.ACTION_ID,E.EMP_FNAME ||' '||E.EMP_LNAME || '('|| trim(FB.EMP_CODE) ||')', FB.EMP_CODE,FB.EXECUT_DT,SR.DTL_DESCR,srad.ACTION_DETL,sra.STDTIME,srad.PLANSTDATE,FBD.TIME_SPENT,FBD.ACTION_STATUS  " + "order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR) " : "SELECT COUNT(*) AS total_rows FROM( select FBD.REQ_ID,SR.DTL_DESCR,E.EMP_FNAME || ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' as name,FB.EMP_CODE, TO_CHAR(FB.EXECUT_DT,'DD-MON-YYYY'),srad.ACTION_DETL,sra.STDTIME, TO_CHAR(srad.PLANSTDATE,'DD-MM-YYYY'),FBD.TIME_SPENT,FBD.ACTION_STATUS  from SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra where FB.FEEDBK_ID = FBD.FEEDBK_ID  AND srad.ACTION_ID = FBD.ACTION_ID AND srad.EMP_CODE  = FB.EMP_CODE AND FBD.REQ_ID = SR.REQ_ID AND FB.EMP_CODE in ('" + String.join((CharSequence)"','", empCode).trim() + "') " + "AND " + "FB.EXECUT_DT between " + "TO_DATE('" + dateFrom + "','yyyy/mm/dd') " + "AND " + "TO_DATE('" + dateTo + "','yyyy/mm/dd') " + "AND " + "FB.EMP_CODE = E.EMP_CODE " + " AND " + "FBD.REQ_ID='" + requestid + "'" + "group by " + "FB.EMP_CODE, FBD.REQ_ID,FBD.ACTION_ID,E.EMP_FNAME ||' '||E.EMP_LNAME || '('|| trim(FB.EMP_CODE) ||')', FB.EMP_CODE,FB.EXECUT_DT,SR.DTL_DESCR,srad.ACTION_DETL,sra.STDTIME,srad.PLANSTDATE,FBD.TIME_SPENT,FBD.ACTION_STATUS  " + "order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR) ";
                    BaseLogger.log((String)"0", null, null, (Object)("getDataCount sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    this.rs.next();
                    count = this.rs.getInt(1);
                }
                catch (Exception e) {
                    BaseLogger.log((String)"0", null, null, (Object)("Error getData" + e.getMessage()));
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block28;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return count;
    }

    public String getEmployeeEmailid(String empcode) {
        String email;
        block29: {
            email = null;
            try {
                try {
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    String sql = "select EMAIL_ID_OFF from EMPLOYEE where EMP_CODE='" + empcode + "'";
                    BaseLogger.log((String)"0", null, null, (Object)("getEmployeeEmailid sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    while (this.rs.next()) {
                        email = this.rs.getString(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block29;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return email;
    }

    public List<Plan> getPlanReport(List<String> empCode, String dateFrom, String dateTo, String requestid, int offset, int limit) {
        ArrayList<Plan> list;
        block33: {
            list = new ArrayList<Plan>();
            try {
                try {
                    String sql;
                    if (requestid.isEmpty()) {
                        sql = "SELECT D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' as NAME,  TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY'),  A.REQ_ID, C.DTL_DESCR,  A.STDTIME, B.ACTION_DETL,B.ACTION_ID FROM SER_REQ_ACT A, SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D WHERE A.ACTION_ID = B.ACTION_ID  AND A.REQ_ID = C.REQ_ID AND B.PLANSTDATE BETWEEN TO_DATE('" + dateFrom + "','yyyy/mm/dd') AND TO_DATE('" + dateTo + "','yyyy/mm/dd') " + " AND " + "B.EMP_CODE  = D.EMP_CODE " + "AND " + "B.EMP_CODE in('" + String.join((CharSequence)"','", empCode).trim() + "') " + "ORDER BY D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' ASC,B.PLANSTDATE,A.REQ_ID,C.DTL_DESCR,B.STDTIME,B.ACTION_DETL";
                        sql = "SELECT D.EMP_FNAME || ' ' || D.EMP_LNAME ||'('||trim(B.EMP_CODE)||')' AS name,TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY'), A.REQ_ID, C.DTL_DESCR, B.STDTIME, B.ACTION_DETL FROM SER_REQ_ACT A, SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D WHERE A.ACTION_ID = B.ACTION_ID AND A.REQ_ID = C.REQ_ID AND B.PLANSTDATE BETWEEN TO_DATE('" + dateFrom + "','yyyy/mm/dd') AND TO_DATE('" + dateTo + "','yyyy/mm/dd') " + "AND " + "B.EMP_CODE = D.EMP_CODE " + "AND " + "B.EMP_CODE in('" + String.join((CharSequence)"','", empCode).trim() + "') " + "ORDER BY D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' ASC,B.PLANSTDATE,A.REQ_ID ";
                        if (offset != 0 && limit != 0) {
                            sql = String.valueOf(sql) + " OFFSET " + offset + " ROWS FETCH NEXT " + limit + " ROWS ONLY";
                        }
                    } else {
                        sql = "SELECT D.EMP_FNAME || ' ' || D.EMP_LNAME ||'('||trim(B.EMP_CODE)||')' AS name,TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY'), A.REQ_ID, C.DTL_DESCR, B.STDTIME, B.ACTION_DETL FROM SER_REQ_ACT A, SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D WHERE A.ACTION_ID = B.ACTION_ID AND A.REQ_ID = C.REQ_ID AND B.PLANSTDATE BETWEEN TO_DATE('" + dateFrom + "','yyyy/mm/dd') AND TO_DATE('" + dateTo + "','yyyy/mm/dd') " + "AND " + "B.EMP_CODE = D.EMP_CODE " + "AND " + "B.EMP_CODE in('" + String.join((CharSequence)"','", empCode).trim() + "') " + "AND " + "A.REQ_ID ='" + requestid + "' " + "ORDER BY D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' ASC,B.PLANSTDATE,A.REQ_ID ";
                        if (offset != 0 && limit != 0) {
                            sql = String.valueOf(sql) + " OFFSET " + offset + " ROWS FETCH NEXT " + limit + " ROWS ONLY";
                        }
                    }
                    BaseLogger.log((String)"0", null, null, (Object)("getPlanReport sql=" + sql));
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    this.rs = this.stmt.executeQuery(sql);
                    while (this.rs.next()) {
                        Plan plan = new Plan();
                        plan.setActiondtl(this.rs.getString(6));
                        plan.setDate(this.rs.getString(2));
                        plan.setDescription(this.rs.getString(4));
                        plan.setName(this.rs.getString(1));
                        plan.setRequestid(this.rs.getString(3));
                        plan.setTime(this.rs.getInt(5));
                        list.add(plan);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block33;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return list;
    }

    public int getPlanDataCount(List<String> empCode, String dateFrom, String dateTo, String requestid) {
        int totalCount;
        block31: {
            totalCount = 0;
            try {
                try {
                    String sql;
                    if (requestid.isEmpty()) {
                        sql = "SELECT D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' as NAME,  TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY'),  A.REQ_ID, C.DTL_DESCR,  A.STDTIME, B.ACTION_DETL,B.ACTION_ID FROM SER_REQ_ACT A, SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D WHERE A.ACTION_ID = B.ACTION_ID  AND A.REQ_ID = C.REQ_ID AND B.PLANSTDATE BETWEEN TO_DATE('" + dateFrom + "','yyyy/mm/dd') AND TO_DATE('" + dateTo + "','yyyy/mm/dd') " + " AND " + "B.EMP_CODE  = D.EMP_CODE " + "AND " + "B.EMP_CODE in('" + String.join((CharSequence)"','", empCode).trim() + "') " + "ORDER BY D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' ASC,B.PLANSTDATE,A.REQ_ID,C.DTL_DESCR,B.STDTIME,B.ACTION_DETL";
                        sql = "SELECT COUNT(*) AS total_count FROM(SELECT D.EMP_FNAME || ' ' || D.EMP_LNAME ||'('||trim(B.EMP_CODE)||')' AS name,TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY'), A.REQ_ID, C.DTL_DESCR, B.STDTIME, B.ACTION_DETL FROM SER_REQ_ACT A, SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D WHERE A.ACTION_ID = B.ACTION_ID AND A.REQ_ID = C.REQ_ID AND B.PLANSTDATE BETWEEN TO_DATE('" + dateFrom + "','yyyy/mm/dd') AND TO_DATE('" + dateTo + "','yyyy/mm/dd') " + "AND " + "B.EMP_CODE = D.EMP_CODE " + "AND " + "B.EMP_CODE in('" + String.join((CharSequence)"','", empCode).trim() + "') " + "ORDER BY D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' ASC,B.PLANSTDATE,A.REQ_ID )";
                    } else {
                        sql = "SELECT COUNT(*) AS total_count FROM(SELECT D.EMP_FNAME || ' ' || D.EMP_LNAME ||'('||trim(B.EMP_CODE)||')' AS name,TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY'), A.REQ_ID, C.DTL_DESCR, B.STDTIME, B.ACTION_DETL FROM SER_REQ_ACT A, SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D WHERE A.ACTION_ID = B.ACTION_ID AND A.REQ_ID = C.REQ_ID AND B.PLANSTDATE BETWEEN TO_DATE('" + dateFrom + "','yyyy/mm/dd') AND TO_DATE('" + dateTo + "','yyyy/mm/dd') " + "AND " + "B.EMP_CODE = D.EMP_CODE " + "AND " + "B.EMP_CODE in('" + String.join((CharSequence)"','", empCode).trim() + "') " + "AND " + "A.REQ_ID ='" + requestid + "' " + "ORDER BY D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' ASC,B.PLANSTDATE,A.REQ_ID )";
                    }
                    BaseLogger.log((String)"0", null, null, (Object)("getPlanReportTotal sql=" + sql));
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    this.rs = this.stmt.executeQuery(sql);
                    while (this.rs.next()) {
                        totalCount = this.rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block31;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return totalCount;
    }

    public List<TodaysPlan> getTodysPlan() {
        ArrayList<TodaysPlan> list;
        block29: {
            list = new ArrayList<TodaysPlan>();
            try {
                try {
                    Date currentDate = new Date();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                    String currentDateString = dateFormat.format(currentDate);
                    BaseLogger.log((String)"0", null, null, (Object)("getTodysPlan dsate=" + currentDateString));
                    String sql = "SELECT D.EMP_FNAME || ' ' || D.EMP_LNAME ||'('||trim(B.EMP_CODE)||')' AS name,A.REQ_ID,B.ACTION_DETL,C.DTL_DESCR,B.STDTIME,srf2.TIME_SPENT,TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY') FROM SER_REQ_ACT A,SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D ,SER_REQ_FEEDBK srf ,SER_REQ_FEEDBKDTL srf2 WHERE A.ACTION_ID = B.ACTION_ID AND A.REQ_ID = C.REQ_ID AND B.PLANSTDATE = TO_DATE('" + currentDateString + "','yyyy/MM/dd') " + "AND B.EMP_CODE = D.EMP_CODE " + "AND srf.FEEDBK_ID  = srf2.FEEDBK_ID " + "AND srf2.ACTION_ID  = A.ACTION_ID " + "ORDER BY name ASC ,B.PLANSTDATE,A.REQ_ID";
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    BaseLogger.log((String)"0", null, null, (Object)("getTodysPlan sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    while (this.rs.next()) {
                        TodaysPlan plan = new TodaysPlan();
                        plan.setName(this.rs.getString(1));
                        plan.setRequestid(this.rs.getString(2));
                        plan.setActiondtl(this.rs.getString(3));
                        plan.setDescription(this.rs.getString(4));
                        plan.setTime(this.rs.getInt(5));
                        plan.setSpentTime(this.rs.getInt(6));
                        plan.setDate(this.rs.getString(7));
                        list.add(plan);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block29;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return list;
    }

    public List<Report> getYesterdayFeedback() {
        ArrayList<Report> list;
        block29: {
            list = new ArrayList<Report>();
            try {
                try {
                    String sql = "select FBD.REQ_ID,SR.DTL_DESCR,FBD.ACTION_DETLS,E.EMP_FNAME || ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' as name,FB.EMP_CODE,TO_CHAR(FB.EXECUT_DT,'DD-MON-YYYY'),srad.ACTION_DETL,sra.STDTIME,TO_CHAR(srad.PLANSTDATE,'DD-MM-YYYY'),FBD.TIME_SPENT,TO_CHAR(FB.FEEDBK_DT ,'DD-MM-YYYY')from SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra where FB.FEEDBK_ID = FBD.FEEDBK_ID AND srad.ACTION_ID = FBD.ACTION_ID AND srad.EMP_CODE  = FB.EMP_CODE AND FBD.REQ_ID = SR.REQ_ID AND FB .FEEDBK_DT ='22-03-2022' AND FB.EMP_CODE = E.EMP_CODE group by FB.EMP_CODE, FBD.REQ_ID,FBD.ACTION_ID,E.EMP_FNAME ||' '||E.EMP_LNAME || '('|| trim(FB.EMP_CODE) ||')',FB.EMP_CODE,FB.EXECUT_DT,SR.DTL_DESCR,srad.ACTION_DETL,sra.STDTIME,srad.PLANSTDATE,FBD.TIME_SPENT,FBD.ACTION_DETLS ,FB.FEEDBK_DT order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR";
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    BaseLogger.log((String)"0", null, null, (Object)("getYesterdayFeedback sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    Report report = null;
                    while (this.rs.next()) {
                        report = new Report();
                        report.setRequestId(this.rs.getString(1));
                        report.setDescription(this.rs.getString(2));
                        report.setActiondtl(this.rs.getString(3));
                        report.setPerson(this.rs.getString(4));
                        report.setDate(this.rs.getString(11));
                        report.setStdtime(this.rs.getInt(8));
                        report.setStartdate(this.rs.getString(9));
                        report.setTimespend(this.rs.getInt(10));
                        list.add(report);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block29;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return list;
    }

    public List<Report> getYesterdayFeedback2() {
        ArrayList<Report> list;
        block29: {
            list = new ArrayList<Report>();
            try {
                try {
                    String sql = "select E.EMP_FNAME ||' '||E.EMP_MNAME||  ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' as name,FBD.REQ_ID,SR.DTL_DESCR,FBD.ACTION_DETLS,FBD.TIME_SPENT,srad.STDTIME,FBD.ACTION_STATUS FROM SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra where FB.FEEDBK_ID = FBD.FEEDBK_ID AND srad.ACTION_ID = FBD.ACTION_ID AND srad.EMP_CODE  = FB.EMP_CODE AND FBD.REQ_ID = SR.REQ_ID AND sra.ACTION_ID  = srad.ACTION_ID AND FB.EXECUT_DT =TO_DATE('2022/04/05','yyyy/mm/dd') AND FB.EMP_CODE = E.EMP_CODE order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR";
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    BaseLogger.log((String)"0", null, null, (Object)("getYesterdayFeedback2 sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    while (this.rs.next()) {
                        Report report = new Report();
                        report.setPerson(this.rs.getString(1));
                        report.setRequestId(this.rs.getString(2));
                        report.setActiondtl(this.rs.getString(3));
                        report.setDescription(this.rs.getString(4));
                        report.setTimespend(this.rs.getInt(5));
                        report.setStdtime(this.rs.getInt(6));
                        report.setStatus(this.rs.getString(7));
                        list.add(report);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block29;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return list;
    }

    public String getCurrentStatus(String requestid) {
        String status;
        block29: {
            status = "";
            try {
                try {
                    String sql = "SELECT srf.ACTION_STATUS FROM SER_REQ_FEEDBKDTL srf ,SER_REQ_FEEDBK srf2 WHERE srf2.FEEDBK_ID =srf.FEEDBK_ID AND srf.REQ_ID ='" + requestid + "'" + "AND " + "srf2.FEEDBK_DT  = " + "(SELECT MAx(srf2.FEEDBK_DT)FROM SER_REQ_FEEDBKDTL srf ,SER_REQ_FEEDBK srf2 " + "WHERE " + "srf2.FEEDBK_ID =srf.FEEDBK_ID " + "AND " + "srf.REQ_ID ='" + requestid + "')";
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    BaseLogger.log((String)"0", null, null, (Object)("getCurrentStatus sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    if (this.rs.next()) {
                        status = this.rs.getString(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block29;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return status;
    }

    public Map<String, List<String>> getEmployeeRequestId(LocalDate start, LocalDate end, List<String> empCode) {
        try {
            String sql = "SELECT DISTINCT srf.REQ_ID ,TO_CHAR(srf.EXECUT_DT,'DD-MON-YYYY'),E.EMP_FNAME || ' ' ||E.EMP_LNAME  as name FROM SER_REQ_FEEDBK srf,EMPLOYEE e WHERE e.EMP_CODE  = srf.EMP_CODE AND srf.EMP_CODE in ('" + String.join((CharSequence)"','", empCode).trim() + "') " + "AND " + "srf.EXECUT_DT between TO_DATE('" + start + "','yyyy/mm/dd') AND TO_DATE('" + end + "','yyyy/mm/dd') " + "GROUP BY srf.REQ_ID ,srf.EXECUT_DT,E.EMP_FNAME || ' ' ||E.EMP_LNAME ";
            BaseLogger.log((String)"0", null, null, (Object)("getEmployeeRequestId() sql=" + sql));
            this.conn = new DbConnection().getConnection();
            this.stmt = this.conn.createStatement();
            this.rs = this.stmt.executeQuery(sql);
            Map<String, List<String>> map = new HashMap<String, List<String>>();
            while (this.rs.next()) {
                map = empCode.size() > 1 ? this.addInMap(this.rs.getString(2), String.valueOf(this.rs.getString(1)) + " " + this.rs.getString(3), map) : this.addInMap(this.rs.getString(2), this.rs.getString(1), map);
            }
            HashMap<String, List<String>> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    Map<String, List<String>> addInMap(String date, String reqid, Map<String, List<String>> map) {
        if (map.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(reqid);
            map.put(date, list);
        } else if (map.get(date) == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(reqid);
            map.put(date, list);
        } else {
            map.get(date).add(reqid);
        }
        return map;
    }

    public Map<String, List<FeedbackCalendar>> getFeedbackCalendar(LocalDate start, LocalDate end, List<String> empCode) {
        Map<String, List<FeedbackCalendar>> map = new HashMap<String, List<FeedbackCalendar>>();
        try {
            String sql = "SELECT srf.REQ_ID,TO_CHAR(srf.EXECUT_DT,'DD-MON-YYYY'),E.EMP_FNAME || ' ' ||E.EMP_LNAME as name,sra.STDTIME ,srf2.TIME_SPENT,srf.EMP_CODE,sra.ACTION_ID  FROM SER_REQ_FEEDBK srf,SER_REQ_FEEDBKDTL srf2 ,EMPLOYEE e ,SER_REQ_ACT sra WHERE e.EMP_CODE  = srf.EMP_CODE AND sra.REQ_ID  = srf.REQ_ID AND SRF .FEEDBK_ID  = srf2.FEEDBK_ID AND srf2.ACTION_ID  = sra.ACTION_ID AND srf.EMP_CODE in ('" + String.join((CharSequence)"','", empCode).trim() + "') " + "AND " + "srf.EXECUT_DT between TO_DATE('" + start + "','yyyy/mm/dd') AND TO_DATE('" + end + "','yyyy/mm/dd') " + "GROUP BY srf.REQ_ID ,srf.EXECUT_DT,E.EMP_FNAME || ' ' ||E.EMP_LNAME ,sra.STDTIME,srf2.TIME_SPENT,srf.EMP_CODE,sra.ACTION_ID  " + "ORDER BY srf.EXECUT_DT,E.EMP_FNAME || ' ' ||E.EMP_LNAME";
            BaseLogger.log((String)"0", null, null, (Object)("getFeedbackCalendar() sql=" + sql));
            Connection conn = new DbConnection().getConnection();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FeedbackCalendar cal = new FeedbackCalendar();
                cal.setRequestid(rs.getString(1));
                cal.setDate(rs.getString(2));
                cal.setTime(rs.getInt(4));
                cal.setSpenttime(rs.getInt(5));
                cal.setTotalspent(this.getTotalTimeSpent(rs.getString(1), rs.getString(6), rs.getString(7)));
                cal.setActionid(rs.getString(7));
                if (empCode.size() > 1) {
                    cal.setEmpname(rs.getString(3));
                } else {
                    cal.setEmpname("");
                }
                BaseLogger.log((String)"0", null, null, (Object)("getFeedbackCalendar() cal=" + cal));
                map = this.getFeedbackCalendarMap(cal, cal.getDate(), map);
            }
            BaseLogger.log((String)"0", null, null, (Object)("getFeedbackCalendar() map size=" + map.size()));
            conn.close();
            return map;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("getFeedbackCalendar() Error=" + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    Map<String, List<FeedbackCalendar>> getFeedbackCalendarMap(FeedbackCalendar cal, String date, Map<String, List<FeedbackCalendar>> map) {
        if (map.isEmpty()) {
            ArrayList<FeedbackCalendar> list = new ArrayList<FeedbackCalendar>();
            list.add(cal);
            map.put(date, list);
        } else if (map.get(date) == null) {
            ArrayList<FeedbackCalendar> list = new ArrayList<FeedbackCalendar>();
            list.add(cal);
            map.put(date, list);
        } else {
            map.get(date).add(cal);
        }
        return map;
    }

    int getTotalTimeSpent(String requestid, String empcode, String actionid) {
        int totaltime;
        block28: {
            totaltime = 0;
            try {
                try {
                    String sql = "SELECT sum(srf.TIME_SPENT) FROM SER_REQ_FEEDBKDTL srf,SER_REQ_FEEDBK srf2,SER_REQ_ACT sra ,SER_REQ_ACT_DETL srad WHERE srf.FEEDBK_ID =srf2.FEEDBK_ID AND sra.ACTION_ID  = srad.ACTION_ID AND srf.ACTION_ID  = srad.ACTION_ID AND srf2.EMP_CODE ='" + empcode + "'" + "AND " + "srf.REQ_ID ='" + requestid + "'" + "AND " + "srf.ACTION_ID ='" + actionid + "'";
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    BaseLogger.log((String)"0", null, null, (Object)("getTotalTimeSpent sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    this.rs.next();
                    totaltime = this.rs.getInt(1);
                    this.conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block28;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return totaltime;
    }

    public Map<String, List<Plan>> getPlanCalendar(LocalDate start, LocalDate end, List<String> empcode) {
        Map<String, List<Plan>> map;
        block31: {
            map = new HashMap<String, List<Plan>>();
            try {
                try {
                    String sql = "SELECT e.EMP_FNAME || ' '||e.EMP_LNAME  AS name,TO_CHAR(srad.PLANSTDATE,'DD-MON-YYYY'),sra.REQ_ID,srad.STDTIME FROM EMPLOYEE e,SER_REQ_ACT sra  ,SER_REQ_ACT_DETL srad ,SER_REQUEST sr WHERE sra.ACTION_ID=srad.ACTION_ID AND sra.REQ_ID=sr.REQ_ID AND e.EMP_CODE=srad.EMP_CODE AND srad.PLANSTDATE BETWEEN TO_DATE('" + start + "','yyyy/mm/dd') AND TO_DATE('" + end + "','yyyy/mm/dd') " + "AND " + "srad.EMP_CODE in ('" + String.join((CharSequence)"','", empcode).trim() + "') " + "GROUP BY e.EMP_FNAME || ' '||e.EMP_LNAME,srad.PLANSTDATE,sra.REQ_ID,srad.STDTIME " + "ORDER BY srad.PLANSTDATE ASC";
                    this.conn = new DbConnection().getConnection();
                    this.stmt = this.conn.createStatement();
                    BaseLogger.log((String)"0", null, null, (Object)("getPlanCalendar sql=" + sql));
                    this.rs = this.stmt.executeQuery(sql);
                    while (this.rs.next()) {
                        Plan plan = new Plan();
                        if (empcode.size() > 1) {
                            plan.setName(this.rs.getString(1));
                        } else {
                            plan.setName("");
                        }
                        plan.setDate(this.rs.getString(2));
                        plan.setRequestid(this.rs.getString(3));
                        plan.setTime(this.rs.getInt(4));
                        map = this.addPlanMap(plan, map);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.rs != null) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (this.conn == null) break block31;
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return map;
    }

    Map<String, List<Plan>> addPlanMap(Plan plan, Map<String, List<Plan>> map) {
        if (map.isEmpty()) {
            ArrayList<Plan> list = new ArrayList<Plan>();
            list.add(plan);
            map.put(plan.getDate(), list);
        } else if (map.get(plan.getDate()) == null) {
            ArrayList<Plan> list = new ArrayList<Plan>();
            list.add(plan);
            map.put(plan.getDate(), list);
        } else {
            map.get(plan.getDate()).add(plan);
        }
        return map;
    }

    public List<Holiday> getHoliday() {
        ArrayList<Holiday> list = new ArrayList<Holiday>();
        try {
            String sql = "SELECT H.ID,H.START_DATE ,H.END_DATE ,H.HOLIDAY_DESC  FROM HOLIDAY H";
            this.conn = new DbConnection().getConnection();
            this.stmt = this.conn.createStatement();
            BaseLogger.log((String)"0", null, null, (Object)("getHoliday sql=" + sql));
            this.rs = this.stmt.executeQuery(sql);
            while (this.rs.next()) {
                Holiday holiday = new Holiday();
                holiday.setId(this.rs.getInt(1));
                holiday.setStart(this.rs.getDate(2).toLocalDate());
                holiday.setEnd(this.rs.getDate(3).toLocalDate());
                holiday.setDescription(this.rs.getString(4));
                list.add(holiday);
            }
            this.conn.close();
            ArrayList<Holiday> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return list;
    }

    public List<Holiday> getHoliday(String start, String end) {
        ArrayList<Holiday> list = new ArrayList<Holiday>();
        try {
            String sql = "SELECT h.ID,h.START_DATE ,h.END_DATE ,h.HOLIDAY_DESC FROM HOLIDAY h WHERE h.START_DATE  between TO_DATE('" + start + "','DD-MM-YYYY') AND TO_DATE('" + end + "','DD-MM-YYYY')";
            this.conn = new DbConnection().getConnection();
            this.stmt = this.conn.createStatement();
            this.rs = this.stmt.executeQuery(sql);
            while (this.rs.next()) {
                Holiday holiday = new Holiday();
                holiday.setId(this.rs.getInt(1));
                holiday.setStart(this.rs.getDate(2).toLocalDate());
                holiday.setEnd(this.rs.getDate(3).toLocalDate());
                holiday.setDescription(this.rs.getString(4));
                list.add(holiday);
            }
            this.conn.close();
            ArrayList<Holiday> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return list;
    }

    public List<Leave> getLeave(String empcode, String start, String end) {
        ArrayList<Leave> list = new ArrayList<Leave>();
        try {
            String sql = "SELECT l.ID,l.START_DATE,l.END_DATE,l.EMP_CODE FROM LEAVE l WHERE l.EMP_CODE ='" + empcode + "'" + "AND " + "l.START_DATE  between TO_DATE('" + start + "','DD-MM-YYYY') AND TO_DATE('" + end + "','DD-MM-YYYY')";
            BaseLogger.log((String)"0", null, null, (Object)("getLeave sql=" + sql));
            this.conn = new DbConnection().getConnection();
            this.stmt = this.conn.createStatement();
            this.rs = this.stmt.executeQuery(sql);
            while (this.rs.next()) {
                Leave leave = new Leave();
                leave.setId(this.rs.getInt(1));
                leave.setStartdate(this.rs.getDate(2).toLocalDate());
                leave.setEnddate(this.rs.getDate(3).toLocalDate());
                leave.setEmpcode(this.rs.getString(4));
                list.add(leave);
            }
            this.conn.close();
            ArrayList<Leave> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return list;
    }

    public List<Leave> getLeave(String empcode) {
        ArrayList<Leave> list = new ArrayList<Leave>();
        try {
            String sql = "SELECT l.id,l.START_DATE ,l.END_DATE ,l.EMP_CODE FROM LEAVE l WHERE l.EMP_CODE ='" + empcode + "'";
            BaseLogger.log((String)"0", null, null, (Object)("getLeave() sql=" + sql));
            this.conn = new DbConnection().getConnection();
            this.stmt = this.conn.createStatement();
            this.rs = this.stmt.executeQuery(sql);
            while (this.rs.next()) {
                Leave leave = new Leave();
                leave.setId(this.rs.getInt(1));
                leave.setStartdate(this.rs.getDate(2).toLocalDate());
                leave.setEnddate(this.rs.getDate(3).toLocalDate());
                leave.setEmpcode(this.rs.getString(4));
                list.add(leave);
            }
            this.conn.close();
            ArrayList<Leave> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return list;
    }
}

