/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.ConnectionMonitor;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.ejb.InfinispanRemote;
import ibase.webitm.utility.DMSConnLogMonitor;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.InfinispanLogger;
import ibase.webitm.utility.PopUpProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.json.JSONArray;

@Stateless
public class InfinispanEJB
implements InfinispanLocal,
InfinispanRemote {
    @Resource(lookup="java:jboss/infinispan/container/myCache")
    public CacheContainer container;
    private RemoteCache<String, DWObject> cache;
    private RemoteCache<String, String> formDataCache;
    private RemoteCache<String, ArrayList<String>> userCache;
    private RemoteCache<String, ConnectionMonitor> connectionCache;
    private RemoteCache<String, byte[]> imageCache;
    private RemoteCache<String, HashMap<String, PopUpProperties>> popupMetadataCache;
    private RemoteCache<String, JSONArray> remoteIntentMetadata;
    private RemoteCache<String, DMSConnLogMonitor> dmsConnectionCache;
    private RemoteCache<String, JSONArray> remoteStatefulDataCache;
    private Cache<String, DWObject> localCache;
    private Cache<String, String> localFormDataCache;
    private Cache<String, ArrayList<String>> localUserCache;
    private Cache<String, ConnectionMonitor> localConnectionCache;
    private Cache<String, byte[]> localImageCache;
    private Cache<String, HashMap<String, PopUpProperties>> localPopupMetadataCache;
    private Cache<String, JSONArray> localIntentMetadata;
    private Cache<String, DMSConnLogMonitor> dmsLocalConnectionCache;
    private Cache<String, JSONArray> statefulDataCache;

    @PostConstruct
    public void initCache() throws ITMException {
        InfinispanLogger.log("2", null, null, "In initCache CommonConstants.CACHE_OPT:[" + CommonConstants.CACHE_OPT + "]");
        if (CommonConstants.CACHE_OPT == 1) {
            this.localCache = this.container.getCache();
            this.localFormDataCache = this.container.getCache();
            this.localUserCache = this.container.getCache();
            this.localConnectionCache = this.container.getCache();
            this.localImageCache = this.container.getCache();
            this.localPopupMetadataCache = this.container.getCache();
            this.localIntentMetadata = this.container.getCache();
            this.dmsLocalConnectionCache = this.container.getCache();
            this.statefulDataCache = this.container.getCache();
        } else if (CommonConstants.CACHE_OPT == 2) {
            String host = CommonConstants.INFINISPAN_SERVER_HOST;
            int port = CommonConstants.INFINISPAN_SERVER_PORT;
            Configuration config = new ConfigurationBuilder().addServer().host(host).port(port).build();
            RemoteCacheManager rcm = new RemoteCacheManager(config);
            this.cache = rcm.getCache("myDefault");
            this.formDataCache = rcm.getCache("myDefault");
            this.userCache = rcm.getCache("myDefault");
            this.connectionCache = rcm.getCache("myDefault");
            this.imageCache = rcm.getCache("myDefault");
            this.popupMetadataCache = rcm.getCache("myDefault");
            this.remoteIntentMetadata = rcm.getCache("myDefault");
            this.dmsConnectionCache = rcm.getCache("myDefault");
            this.remoteStatefulDataCache = rcm.getCache("myDefault");
        } else {
            throw new ITMException(new Exception("Disable Infinispan Cache."));
        }
    }

    @Override
    public DWObject get(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            if (this.localCache.get((Object)key) instanceof DWObject) {
                return (DWObject)this.localCache.get((Object)key);
            }
        } else if (CommonConstants.CACHE_OPT == 2 && this.cache.get((Object)key) instanceof DWObject) {
            return (DWObject)this.cache.get((Object)key);
        }
        return null;
    }

    @Override
    public void put(String key, DWObject obj) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localCache.put((Object)key, (Object)obj);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.cache.put((Object)key, (Object)obj);
        }
    }

    @Override
    public void remove(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localCache.remove((Object)key);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.cache.remove((Object)key);
        }
    }

    @Override
    public void clearCache(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localCache.clear();
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.cache.clear();
        }
    }

    @Override
    public boolean contains(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            return this.localCache.containsKey((Object)key);
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return this.cache.containsKey((Object)key);
        }
        return false;
    }

    @Override
    public void replaceValue(String key, DWObject oldObj, DWObject newObj) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localCache.replace((Object)key, (Object)newObj);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.cache.replace((Object)key, (Object)oldObj, (Object)newObj);
        }
    }

    @Override
    public Set<String> getKeySet() {
        if (CommonConstants.CACHE_OPT == 1) {
            return this.localCache.keySet();
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return this.cache.keySet();
        }
        return null;
    }

    @Override
    public String getFormData(String key) {
        key = E12GenericUtility.checkNull(key);
        InfinispanLogger.log("2", null, null, "In InfinispanEJB getformdata() cache storage key : [" + key + "]");
        if (CommonConstants.CACHE_OPT == 1) {
            if (this.localFormDataCache.get((Object)key) instanceof String) {
                InfinispanLogger.log("2", null, null, "In InfinispanEJB getformdata() cache storage value : [" + (String)this.localFormDataCache.get((Object)key) + "]");
                return (String)this.localFormDataCache.get((Object)key);
            }
        } else if (CommonConstants.CACHE_OPT == 2 && this.formDataCache.get((Object)key) instanceof String) {
            InfinispanLogger.log("2", null, null, "In InfinispanEJB getformdata() cache storage value : [" + (String)this.formDataCache.get((Object)key) + "]");
            return (String)this.formDataCache.get((Object)key);
        }
        return null;
    }

    @Override
    public void putFormData(String key, String obj) {
        key = E12GenericUtility.checkNull(key);
        InfinispanLogger.log("2", null, null, "In InfinispanEJB putFormData() cache storage key : [" + key + "]");
        InfinispanLogger.log("2", null, null, "In InfinispanEJB putFormData() cache storage value : [" + obj + "]");
        if (CommonConstants.CACHE_OPT == 1) {
            this.localFormDataCache.put((Object)key, (Object)obj);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.formDataCache.put((Object)key, (Object)obj);
        }
    }

    @Override
    public void removeFormData(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localFormDataCache.remove((Object)key);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.formDataCache.remove((Object)key);
        }
    }

    @Override
    public void clearFormDataCache(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localFormDataCache.clear();
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.formDataCache.clear();
        }
    }

    @Override
    public boolean FormDataContains(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            return this.localFormDataCache.containsKey((Object)key);
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return this.formDataCache.containsKey((Object)key);
        }
        return false;
    }

    @Override
    public void replaceFormDataValue(String key, String oldObj, String newObj) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localFormDataCache.replace((Object)key, (Object)newObj);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.formDataCache.replace((Object)key, (Object)oldObj, (Object)newObj);
        }
    }

    @Override
    public Set<String> getFormDataKeySet() {
        if (CommonConstants.CACHE_OPT == 1) {
            return this.localFormDataCache.keySet();
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return this.formDataCache.keySet();
        }
        return null;
    }

    @Override
    public void setUsers(String value) {
        try {
            if (CommonConstants.CACHE_OPT == 1) {
                ArrayList<String> userList = (ArrayList<String>)this.localUserCache.get((Object)"BASE_USERS");
                if (userList == null) {
                    userList = new ArrayList<String>();
                }
                if (!userList.contains(value)) {
                    userList.add(value);
                }
                this.localUserCache.put((Object)"BASE_USERS", userList);
            } else if (CommonConstants.CACHE_OPT == 2) {
                ArrayList<String> userList = (ArrayList<String>)this.userCache.get((Object)"BASE_USERS");
                if (userList == null) {
                    userList = new ArrayList<String>();
                }
                if (!userList.contains(value)) {
                    userList.add(value);
                }
                this.userCache.put((Object)"BASE_USERS", userList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList<String> getUsers() {
        if (CommonConstants.CACHE_OPT == 1) {
            return (ArrayList)this.localUserCache.get((Object)"BASE_USERS");
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return (ArrayList)this.userCache.get((Object)"BASE_USERS");
        }
        return null;
    }

    @Override
    public void removeUsers(String value) {
        try {
            ArrayList userList;
            if (CommonConstants.CACHE_OPT == 1) {
                ArrayList userList2 = (ArrayList)this.localUserCache.get((Object)"BASE_USERS");
                if (userList2 != null && !userList2.isEmpty()) {
                    int i = 0;
                    while (i < userList2.size()) {
                        if (value.trim().equals(userList2.get(i))) {
                            userList2.remove(i);
                        }
                        ++i;
                    }
                }
            } else if (CommonConstants.CACHE_OPT == 2 && (userList = (ArrayList)this.userCache.get((Object)"BASE_USERS")) != null && !userList.isEmpty()) {
                int i = 0;
                while (i < userList.size()) {
                    if (value.trim().equals(userList.get(i))) {
                        userList.remove(i);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ConnectionMonitor getConnInfo(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            if (this.localConnectionCache.get((Object)key) instanceof ConnectionMonitor) {
                return (ConnectionMonitor)this.localConnectionCache.get((Object)key);
            }
        } else if (CommonConstants.CACHE_OPT == 2 && this.connectionCache.get((Object)key) instanceof ConnectionMonitor) {
            return (ConnectionMonitor)this.connectionCache.get((Object)key);
        }
        return null;
    }

    @Override
    public void putConnInfo(String key, ConnectionMonitor value) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localConnectionCache.put((Object)key, (Object)value);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.connectionCache.put((Object)key, (Object)value);
        }
    }

    @Override
    public void removeConnInfo(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localConnectionCache.remove((Object)key);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.connectionCache.remove((Object)key);
        }
    }

    @Override
    public void clearConnInfoCache(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localConnectionCache.clear();
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.connectionCache.clear();
        }
    }

    @Override
    public boolean containsConnInfo(String key) {
        boolean result = false;
        if (CommonConstants.CACHE_OPT == 1) {
            result = this.localConnectionCache.containsKey((Object)key);
        } else if (CommonConstants.CACHE_OPT == 2) {
            result = this.connectionCache.containsKey((Object)key);
        }
        return result;
    }

    @Override
    public void replaceConnInfoValue(String key, ConnectionMonitor oldObj, ConnectionMonitor newObj) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localConnectionCache.replace((Object)key, (Object)newObj);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.connectionCache.replace((Object)key, (Object)oldObj, (Object)newObj);
        }
    }

    @Override
    public Set<String> getConnInfoKeySet() {
        Set connInfoKeySet = null;
        if (CommonConstants.CACHE_OPT == 1) {
            connInfoKeySet = this.localConnectionCache.keySet();
        } else if (CommonConstants.CACHE_OPT == 2) {
            connInfoKeySet = this.connectionCache.keySet();
        }
        return connInfoKeySet;
    }

    @Override
    public Map<String, ConnectionMonitor> getConnInfoBulk() {
        Map connInfo = null;
        if (CommonConstants.CACHE_OPT == 2) {
            connInfo = this.connectionCache.getBulk();
        }
        return connInfo;
    }

    @Override
    public byte[] getImage(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            if (this.localImageCache.get((Object)key) instanceof byte[]) {
                return (byte[])this.localImageCache.get((Object)key);
            }
        } else if (CommonConstants.CACHE_OPT == 2 && this.imageCache.get((Object)key) instanceof byte[]) {
            return (byte[])this.imageCache.get((Object)key);
        }
        byte[] byteArray = new byte[]{};
        return byteArray;
    }

    @Override
    public void putImage(String key, byte[] obj) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localImageCache.put((Object)key, (Object)obj);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.imageCache.put((Object)key, (Object)obj);
        }
    }

    @Override
    public void removeImage(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localImageCache.remove((Object)key);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.imageCache.remove((Object)key);
        }
    }

    @Override
    public void clearImageCache(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localImageCache.clear();
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.imageCache.clear();
        }
    }

    @Override
    public boolean containsImage(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            return this.localImageCache.containsKey((Object)key);
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return this.imageCache.containsKey((Object)key);
        }
        return false;
    }

    @Override
    public void replaceImage(String key, byte[] oldObj, byte[] newObj) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localImageCache.replace((Object)key, (Object)newObj);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.imageCache.replace((Object)key, (Object)oldObj, (Object)newObj);
        }
    }

    @Override
    public Set<String> getImageKeySet() {
        if (CommonConstants.CACHE_OPT == 1) {
            return this.localImageCache.keySet();
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return this.imageCache.keySet();
        }
        return null;
    }

    @Override
    public void setPopupMetadata(String popupMetadataKey, HashMap<String, PopUpProperties> popupMetadataMap) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localPopupMetadataCache.put((Object)popupMetadataKey, popupMetadataMap);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.popupMetadataCache.put((Object)popupMetadataKey, popupMetadataMap);
        }
    }

    @Override
    public HashMap<String, PopUpProperties> getPopupMetadata(String popupMetadataKey) {
        if (CommonConstants.CACHE_OPT == 1) {
            return (HashMap)this.localPopupMetadataCache.get((Object)popupMetadataKey);
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return (HashMap)this.popupMetadataCache.get((Object)popupMetadataKey);
        }
        return null;
    }

    @Override
    public boolean clearCacheWithtype(String type) throws ITMException {
        boolean isError = false;
        try {
            if (CommonConstants.CACHE_OPT == 1) {
                Set<Object> setMap = this.getKeySets();
                InfinispanLogger.log("3", null, null, "inside ClearAconnInfoCache...679[" + setMap.size() + "]");
                if (setMap != null) {
                    for (String string : setMap) {
                        if (this.getConnInfo(string) != null && type.equalsIgnoreCase("Connection")) {
                            if (!(this.getConnInfo(string) instanceof ConnectionMonitor)) continue;
                            this.removeConnInfo(string);
                            continue;
                        }
                        if (this.get(string) != null && type.equalsIgnoreCase("DWObject")) {
                            if (!(this.get(string) instanceof DWObject)) continue;
                            this.remove(string);
                            continue;
                        }
                        if (this.getFormData(string) != null && type.equalsIgnoreCase("FormData")) {
                            if (!(this.getFormData(string) instanceof String)) continue;
                            this.removeFormData(string);
                            continue;
                        }
                        if (this.getImage(string) != null && type.equalsIgnoreCase("Image")) {
                            if (!(this.getImage(string) instanceof byte[])) continue;
                            this.removeImage(string);
                            continue;
                        }
                        if (this.getUsers() != null && type.equalsIgnoreCase("User")) {
                            this.localUserCache.remove((Object)string);
                            continue;
                        }
                        if (this.getDMSConnInfo(string) != null && type.equalsIgnoreCase("DMSConnection")) {
                            if (!(this.getDMSConnInfo(string) instanceof DMSConnLogMonitor)) continue;
                            this.removeDMSConnInfo(string);
                            continue;
                        }
                        if (!type.equalsIgnoreCase("All")) continue;
                        this.clearCache(string);
                    }
                    InfinispanLogger.log("3", null, null, "inside ClearAconnInfoCache...738[" + setMap.size() + "]");
                }
                isError = false;
            }
        }
        catch (Exception e) {
            InfinispanLogger.log("0", null, null, "Exception in clearCacheWithtype...[" + e.getMessage() + "]");
            isError = true;
            throw new ITMException(e);
        }
        return isError;
    }

    public Set<Object> getKeySets() {
        if (CommonConstants.CACHE_OPT == 1) {
            return this.container.getCache().keySet();
        }
        return null;
    }

    @Override
    public void setIntentMetadata(String intentKey, JSONArray intentsJsonArr) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localIntentMetadata.put((Object)intentKey, (Object)intentsJsonArr);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.remoteIntentMetadata.put((Object)intentKey, (Object)intentsJsonArr);
        }
    }

    @Override
    public JSONArray getIntentMetadata(String intentKey) {
        if (CommonConstants.CACHE_OPT == 1) {
            return (JSONArray)this.localIntentMetadata.get((Object)intentKey);
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return (JSONArray)this.remoteIntentMetadata.get((Object)intentKey);
        }
        return null;
    }

    @Override
    public void setDistionaryMetadata(String intentKey, JSONArray intentsJsonArr) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.localIntentMetadata.put((Object)intentKey, (Object)intentsJsonArr);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.remoteIntentMetadata.put((Object)intentKey, (Object)intentsJsonArr);
        }
    }

    @Override
    public JSONArray getDistionaryMetadata(String intentKey) {
        if (CommonConstants.CACHE_OPT == 1) {
            return (JSONArray)this.localIntentMetadata.get((Object)intentKey);
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return (JSONArray)this.remoteIntentMetadata.get((Object)intentKey);
        }
        return null;
    }

    @Override
    public DMSConnLogMonitor getDMSConnInfo(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            if (this.dmsLocalConnectionCache.get((Object)key) instanceof DMSConnLogMonitor) {
                return (DMSConnLogMonitor)this.dmsLocalConnectionCache.get((Object)key);
            }
        } else if (CommonConstants.CACHE_OPT == 2 && this.dmsConnectionCache.get((Object)key) instanceof DMSConnLogMonitor) {
            return (DMSConnLogMonitor)this.dmsConnectionCache.get((Object)key);
        }
        return null;
    }

    @Override
    public void putDMSConnInfo(String key, DMSConnLogMonitor value) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.dmsLocalConnectionCache.put((Object)key, (Object)value);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.dmsConnectionCache.put((Object)key, (Object)value);
        }
    }

    @Override
    public void removeDMSConnInfo(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.dmsLocalConnectionCache.remove((Object)key);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.dmsConnectionCache.remove((Object)key);
        }
    }

    @Override
    public void clearDMSConnInfoCache(String key) {
        if (CommonConstants.CACHE_OPT == 1) {
            this.dmsLocalConnectionCache.clear();
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.dmsConnectionCache.clear();
        }
    }

    @Override
    public boolean containsDMSConnInfo(String key) {
        boolean result = false;
        if (CommonConstants.CACHE_OPT == 1) {
            result = this.dmsLocalConnectionCache.containsKey((Object)key);
        } else if (CommonConstants.CACHE_OPT == 2) {
            result = this.dmsConnectionCache.containsKey((Object)key);
        }
        return result;
    }

    @Override
    public Set<String> getDMSConnInfoKeySet() {
        Set connInfoKeySet = null;
        if (CommonConstants.CACHE_OPT == 1) {
            connInfoKeySet = this.dmsLocalConnectionCache.keySet();
        } else if (CommonConstants.CACHE_OPT == 2) {
            connInfoKeySet = this.dmsConnectionCache.keySet();
        }
        return connInfoKeySet;
    }

    @Override
    public void setStatefulDataCache(String dataCacheKey, JSONArray dataCacheMap) {
        System.out.println("dataCacheKey : [" + dataCacheKey + "]");
        System.out.println("dataCacheMap : [" + dataCacheMap + "]");
        System.out.println("CommonConstants.CACHE_OPT : [" + CommonConstants.CACHE_OPT + "]");
        if (CommonConstants.CACHE_OPT == 1) {
            this.statefulDataCache.put((Object)dataCacheKey, (Object)dataCacheMap);
        } else if (CommonConstants.CACHE_OPT == 2) {
            this.remoteStatefulDataCache.put((Object)dataCacheKey, (Object)dataCacheMap);
        }
    }

    @Override
    public JSONArray getStatefulDataCache(String dataCacheKey) {
        if (CommonConstants.CACHE_OPT == 1) {
            return (JSONArray)this.statefulDataCache.get((Object)dataCacheKey);
        }
        if (CommonConstants.CACHE_OPT == 2) {
            return (JSONArray)this.remoteStatefulDataCache.get((Object)dataCacheKey);
        }
        return null;
    }

    @Override
    public boolean containsStatefulDataCache(String key) {
        boolean result = false;
        if (CommonConstants.CACHE_OPT == 1) {
            result = this.statefulDataCache.containsKey((Object)key);
        } else if (CommonConstants.CACHE_OPT == 2) {
            result = this.remoteStatefulDataCache.containsKey((Object)key);
        }
        return result;
    }
}

