<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />
	<xsl:template match="/">
	<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none;text-align:left; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: #000;
					display: block; float: right; font-size: 20px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;}
					p {font-size: 12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
				</style>
			</head>
			<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>

			<script language="JavaScript" type="text/javascript">
			<![CDATA[
    var maxId = 0;
    
    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>
			</script>
			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">
					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 17px;
					font-weight: 700;
					padding-top: 10px;
					padding-bottom:10px;
					}
					.title
					{
					font-weight: 100;
					font-size: 13px;
					color:black;
					padding-top: 7px;

					}
					div.displayArea
					{
					width:100%;
					}
					.heading
					{
						font-weight: 400;
						font-size: 16px;
				    	color: #000000;
				    	padding-top: 7px;
				    	padding-bottom: 6px;
				    	PADDING-RIGHT: 11PX;
						width:15%;
						text-align:right;


					}
					.headingl
					{
						font-weight: 400;
						font-size: 16px;
				    	color: #000000;
				    	padding-top: 7px;
				    	padding-bottom: 6px;
				    	PADDING-LEFT: 4PX;
						width:15%;
						text-align:left;


					}
					.break:after
					{
					content:",";

					}
					.firstData
					{
					color:#fff;
					}
					.lineSpace
					{
					padding-top:6px;
					}
					.outerDivSummary
					{
                        background-color: #949494;
					    width: 99%;
					    BORDER: 1px solid #FFF;
					    opacity: 0.9;
					    
					    margin: auto;
					}
					.tdSpanh{
						font-size:13px;
					}
					.tdSpan{
						font-size:17px;
					}
				</style>
				<style>
				   
				    .tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 17px;
					font-weight: 700;
					padding-top: 10px;
					padding-bottom:10px;
					}
					.title
					{
					font-weight: 100;
					font-size: 13px;
					color:black;
					padding-top: 7px;

					}
					div.displayArea
					{
					width:100%;
					}
					.heading
					{
						font-weight: 400;
						font-size: 16px;
				    	color: #000000;
				    	padding-top: 7px;
				    	padding-bottom: 6px;
				    	PADDING-RIGHT: 11PX;
						width:15%;
						text-align:right;


					}
					.headingl
					{
						font-weight: 400;
						font-size: 16px;
				    	color: #000000;
				    	padding-top: 7px;
				    	padding-bottom: 6px;
				    	PADDING-LEFT: 4PX;
						width:15%;
						text-align:left;


					}
					.break:after
					{
					content:",";

					}
					.firstData
					{
					color:#fff;
					}
					.lineSpace
					{
					padding-top:6px;
					}
					.outerDivSummary
					{
                        background-color: #949494;
					    width: 99%;
					    BORDER: 1px solid #FFF;
					    opacity: 0.9;
					    
					    margin: auto;
					}
					.tdSpanh{
						font-size:13px;
					}
					.tdSpan{
						font-size:17px;
					}
					
					
					
					.travelTableCss {
					padding: 10px;
					color: #666;
					font-size: 14px;
					display: grid
					!important;
					grid-template-columns: 50% 50%;
					width: auto;
					grid-column-gap: 0.30em;
					grid-row-gap: 0.25em;
					}

					.travelTitle {
					width:
					auto;
					float: right;
					font-size: 14px;
					text-align: right;
					}

					.travelValue{
					width: auto;
					text-align: left;
					line-height: 1.2;
					}

					.valueFieldCss{
					font-size: 14px;
					color: #666;
					}

					.plcDetailCss {
					display: grid
					!important;
					grid-template-columns: 50% 50%;
					grid-column-gap: 0.25em;
					grid-row-gap: 0.25em;
					width: 100%;
					}

					.custDetailCss{
					color: #666;
					width: 100%;
					font-size: 12px;
					display: grid !important;
					grid-template-columns: 35% 30% 30%;
					grid-column-gap: 0.75em;
					grid-row-gap: 0.75em;
					}

					.dataDivCss{
					height:100%;
					width:100%;
					overflow-x:hidden;
					overflow-y:auto;
					}

					.summaryborderPanel{
					display:
					block;
					border-top: #fff 1px solid;
					width: 98%;
					margin-top: 24px;
					}
					.headerTablediv
					{
					background: #fff;
					box-shadow: 0px -1px 0px 0
					rgba(0,0,0,.1);
					}
					.headerTable1
					{
					text-align:center;
					padding-left:
					0;
					}

                    .mainbody{
                        background: #f5f5f5;
                        margin: auto;
                        max-width: 1024px;
                        width: calc(100% - 32px);
                        font-family: sans-serif !important;
                        font-weight: 500 !important;
                        margin-bottom: 0;
                    }

                    .containerfeed{
                        padding: 12px 0;
                        margin: 4px 0;
                        /*height: auto;*/
                        border-radius: 12px;
                        background-color: #fff;
                        overflow: hidden;
                    }


                    .headerdata{
                        display: flex;
                        align-items: center;
                        white-space: nowrap;
                        /* height: 36px; */
                        margin: 0;
                        font-size: 12px;
                        padding: 0 12px;
                        color: #000;
                        cursor: pointer;
                    } 

                    .doctorDiv{
                        width: 20%;
                        min-width: 200px;
                        text-align: left;
                    }
                    .localityDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .stateDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .qualificationDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .specialityDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .brandsDiv{
                        width: 20%;
                        min-width: 200px;
                        text-align: right;
                    }

                    .single-colDiv{
                        display: inline-flex;
                        align-items: center;
                        text-align: left;
                        justify-content: center;
                        margin: 0 auto;
                        padding: 0 16px;
                        width: 100%;
                        height: 100px;
                        min-height: 100px;
                        -webkit-column-break-inside: avoid;
                        -webkit-column-break-after: avoid;
                    }

                    .imgicon{
                        width: 80px;
                        height: 80px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 100%;
                    }

                    *{
                        margin:0;
                        padding:0;
                        box-sizing: border-box;
                    }
                .textcolor{
                    color:#969696 !Important;
                    font-weight: 500;
                }
                .prescription_btm_border {
                    margin: 4px 16px 0 16px;
                    border-bottom: 1px solid #eeeeee;
                }

                .text-rowgroup-2{
                    font-size: 14px;
                    font-weight: 600;
                    color: #000;
                    margin: 4px 0;
                    text-align: center;
                }
                .text-rowgroup-3{
                    font-size: 18px;
                    font-weight: 600;
                    text-align: center;
                    color: #000;
                }
                .activity-descr-text{
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .mainiconradius{
                    width: 30px;
                    height: 30px;
                    margin: 0 10px;
                }

                .stickysubforms{
                    position: relative;
                    display: contents;
                    -webkit-overflow-scrolling: touch;
                }
                .timeline::before {
                    content: '';
                    position: absolute;
                    height: 22px;
                    width: 1px;
                    background-color: #000;
                    left: 32px;
                    transform: translateY(-118%);
                    /*transform: translate(100%,-100%);*/
                }
                .timeline:first-child::before{
                    width: 0;
                }

                .customerDiv{
                    display: flex;
                    padding: 0 16px;
                    align-items: center;
                    margin-bottom: 16px;
                }

                .customerDiv:last-child{
                    margin-bottom: 0;
                }

                .outerIcon{
                    height: 24px;
                    width: 24px;
                    margin: 0 4px 0 0;
                }

                .large-font{
                    font-size: 14px;
                }
                .small-font{
                    font-size: 12px;
                }
                .row-div{
                    padding: 0 16px 0 40px;
                    display: flex;
                    align-items: center;
                    margin-bottom: 16px;
                }
                .prescription_det {
                    padding: 0 16px 0 16px;
                    display: flex;
                    align-items: center;
                }
                
                .hideoverflow{
                    overflow: hidden;
                    text-overflow: ellipsis;
                    -webkit-line-clamp: 2;
                    display: -webkit-box;
                    -webkit-box-orient: vertical;
                    height: 35px;
                }

                .hideoverflowfeed{
                    overflow: hidden;
                    text-overflow: ellipsis;
                    -webkit-line-clamp: 1;
                    -webkit-box-orient: vertical;
                    height: 20px;
                    min-width: 50px;
                    line-height: 24px;
                }

                .datafontsize{
                    font-size:14px !Important;
                    color: #000;
                }
                .headerfontsize{
                    font-size:12px !Important;
                    color:#969696 !Important;
                }
                .bradius{
                    border-radius: 100px;
		    height: 30px;
                    width: 30px;
                }
		.brandImg{
                    border-radius:30%;
                    width:30px;
                }

                .collapsibleIconRadius{
                    border-radius: 100px;
                    height: 30px;
                    width: 30px;
                }

                .rightcol-spacing{
                    margin-inline-start: auto;
                    text-align: right;
                    font-size: 12px;
                    align-self: baseline;
                    white-space: nowrap;
                }

                .imgradius{
                    border-radius: 100px;
                    height: 80px;
                    width: 80px;
                }

                .main-icon{
                    display: block; 
                    text-align:center;
                    margin: 4px 0;
                }

                .align-imgtext{
                    float:left;
                    text-align:right;
                }
				
				.prescription_data{
                    float:left;
                    text-align:right;
					height: 36px;
                }

                .columnsDiv {
                    display: flex;
                    align-items: center;
                    width: 100%;
                    height: 52px;
                    min-height: 52px;
                    -webkit-column-break-inside: avoid;
                    -webkit-column-break-after: avoid;
                    /* border: 1px solid #e2e2e2; */
                    /* border-radius: 12px;*/
                }

                .btnborder{
                    height: 24px;
                    width: 24px;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    background-color: #f5f5f5;
                    border-radius: 28px;
                }

                .tab{
                    margin-inline-start: auto;
                    cursor: pointer;
                }
                .tablinks{
                    border:none;
                    outline:none;
                    background: none;
                }

                .tab button:active {
                    border: none;
                    outline: none;
                    box-shadow: none;
                }
               
                .left-spacing{
                    width: 60%;
                    padding: 0 8px 0 0;
                    min-width: 80px;
                    overflow: hidden;
                    text-align: left;
                    display: flex;
                    align-items: center;
                }

                .center-spacing{
                    width: 20%;
                    text-align: left;
                    padding: 0 8px 0;
                    min-width: 70px;
                    overflow: hidden;
                }
                .right-spacing{
                    text-align: right;
                    width: 20%;
                    padding: 0 0 0 8px;
                    min-width: 60px;
                    overflow: hidden;
                }

                .bgcolorform{
                    background-color: #f5f5f5;
                }
                .headingwidth{
                    border-bottom: 1px solid #0000001a;
                    white-space: nowrap;
                    display: flex;
                    align-items: flex-start;
                    height: 25px;
                    text-overflow: ellipsis;
                    overflow: hidden;
                    color: #666666 !important;
                    padding: 0 8px;
                }


                .detailswidth{
                    padding: 0 8px;
                    white-space: normal;
                    height: 38px;
                    display:grid;
                    align-items: center;
                    color: #000;
                }
                
                .seperatorDiv{
                    border-bottom: 1px solid #0000001a;
                }
                .firstcolumn{
                    text-align: left;
                    padding: 0 8px 0 0;
                    left: 0;
                }

                .lastcolumn{
                    justify-content: flex-end;
                    padding: 0 0 0 8px;
                }

                .containertable{
                    padding: 0 16px;
                    margin: 12px 0;
                    border-radius: 12px;
                    background:#fff;
                    overflow-x: hidden;
                }

                .doctorcontainer{
                    padding: 8px 0;
                    margin: 8px 0 8px 0;
                    border-radius: 12px;
                    background-color: #fff; 
                    overflow-x: auto;
                    overflow-y: hidden;
                }

                .doctordetails{
                    display: flex;
                    padding: 0px;
                    white-space: initial;
                    height: 25px;
                }
                .docdatadetails{
                    display: flex;
                    align-items: center;
                    padding: 0px;
                    height: 35px;
                    margin: 8px 0;
                }

                .sampleheading{
                    display:flex;
                    align-items:center;
                    padding: 8px 0;
                }

                .samplename{
                    display: flex;
                    align-items: center;
                    color: #666666;
                    padding: 0;
                    height: 25px;
                    border-bottom: 1px solid #0000001a;
                }

                .sampledata{
                    white-space: initial;
                    display: flex;
                    padding: 0;
                    margin: 8px 0;
                    height: 38px;
                    align-items: center;
                }

                .sampledetails{
                    background-color: #ededed;
                    padding: 16px;
                    /*width: 100%;*/
                    left: 0;
                    position: sticky;
                    position: -webkit-sticky;
                }

                .itemlabelDiv {
                    margin : 4px 16px 0 40px;
                    height: 16px;
                    text-align: left;
                }
                .itemOuterDiv{
                    margin-top: 16px;
                }

                .btniconborder{
                    height: 34px;
                    width: 34px;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 100%;
                }

                .feed_default_bg{
                    background-color: #0273d0;
                }

                .table_default_bg{
                    background-color: #e6f4ff;
                }

                .iconborder{
                    min-height: 30px;
                    min-width: 30px;
                    max-width: 30px;
                    max-height: 30px;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 25%;
                }

                .location-icon {
                    background-color: #98ccf4;
                }

                .date-icon {
                    background-color: #d5b3ff;
                }
                .remarks-icon {
                    background-color : #86e7d6;
                }

                .speciality-icon{
                    background-color: #91ecff;
                } 

                .class-icon{
                background-color: #ffa7a7;
                }

                .visitplan-icon {
                    background-color: #f4a8ff;
                }

                .state-icon {
                    background-color: #ffb98e;
                }

                .visitedwith-icon {
                    background-color: #b2bbff;
                }

                .pobvalue-icon {
                    background-color: #fbd607;
                }
                .product-icon  {
                    background-color: #cfbfbf;
                }
                .unlistedcust-icon{
                    background-color: #b2bbff;
                }

                .bluebg-icon{
                    background-color: #e6f4ff;
                }

                .redbg-icon{
                    background-color: #ffe8e9;
                }
				.al-icon{
                    background-color: #d1c5df;
                }
                .pc-icon{
                    background-color: #f4c1a4;
                }
                .ac-icon{
                    background-color: #8bd1bc;
                }
                .event-icon{
                    background-color: #fbcb68;
                }

                .namespacing{
                    padding: 0 0 0 8px;
                    text-align: left;
                    line-height: 1.5;
                }

                #section-n2 {
                    display:none;
                }

                button.rmvborder{
                    cursor: pointer;
                    border: none;
                    outline: none;
                    background-color: #f5f5f5;
                }

                button.rmborder{
                    cursor: pointer;
                    border: none;
                    outline: none;
                    background-color: #fff;
                }

                .tabs {
                    position: relative;
                    text-align: center;
                    background: #f5f5f5;
                    /*width: 100%;*/
                    border-radius: 5px;
                    min-width: 240px;
                    min-height: 500px;
                    overflow-x: auto;
                    overflow-y: hidden;
                    -webkit-overflow-scrolling: touch;
                }

                .tabs .uldiv {
                    list-style-type: none;
                    padding: 0 16px;
                    display: -webkit-box;
                    display: flex;
                    -webkit-box-orient: horizontal;
                    -webkit-box-direction: normal;
                            flex-direction: row;
                    margin-bottom: 4px;
                    -webkit-box-pack: justify;
                            justify-content: space-between;
                    -webkit-box-align: end;
                            align-items: center;
                    flex-wrap: wrap;
                    margin-top: 0;
                    width: 100%;
                }

                .rmv-Mrg{
                    margin: 0;
                }

                .tabs .uldiv li {
                    box-sizing: border-box;
                    -webkit-box-flex: 1;
                    text-align: center;
                    margin-right: 0;
                }
                .lidiv{
                    padding: 0 0 0 16px;
                }


                .tabs .uldiv li label {
                    -webkit-transition: all 0.3s ease-in-out;
                    transition: all 0.3s ease-in-out;
                    padding: 5px auto;
                    overflow: hidden;
                    text-overflow: ellipsis;
                    display: block;
                    cursor: pointer;
                    -webkit-transition: all 0.2s ease-in-out;
                    transition: all 0.2s ease-in-out;
                    white-space: nowrap;
                    -webkit-touch-callout: none;
                    user-select: none;
                }

                .tabs .uldiv li label{
                    font-size: 18px;
                    color: #0273d0;
                }


                .tabs .uldiv li label:hover, .tabs .uldiv li label:focus, tabs .uldiv li label:active{
                    outline: 0;
                    color: #0273d0;
                }

                .tabs .slidertab {
                    position: relative;
                    width: calc(100% - 56px);
                    -webkit-transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                    transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                }
                .tabs .slidertab .indicator {
                    position: relative;
                    width: 16px;
                    max-width: 100%;
                    margin-inline-start: auto;
                    height: 4px;
                    background: #0273d0;
                    border-radius: 1px;
                }

                .tabs .data-content section {
                    -webkit-animation-name: data-content;
                            animation-name: data-content;
                    -webkit-animation-direction: normal;
                            animation-direction: normal;
                    -webkit-animation-duration: 0.3s;
                            animation-duration: 0.3s;
                    -webkit-animation-timing-function: ease-in-out;
                            animation-timing-function: ease-in-out;
                    -webkit-animation-iteration-count: 1;
                            animation-iteration-count: 1;
                    line-height: 1.4;
                }

                .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .uldiv > li:nth-child(1) > label {
                    cursor: default;
                    -webkit-transform: translateX(0%);
                            transform: translateX(0%);
                }
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                    -webkit-transform: translateX(0%);
                            transform: translateX(0%);
                }

                .tabs input[name="tab-control"] {
                    display: none;
                }

                @-webkit-keyframes data-content {
                    from {
                        opacity: 0;
                        -webkit-transform: translateY(5%);
                                transform: translateY(5%);
                    }
                    to {
                        opacity: 1;
                        -webkit-transform: translateY(0%);
                                transform: translateY(0%);
                    }
                }
                @keyframes data-content {
                    from {
                        opacity: 0;
                        -webkit-transform: translateY(5%);
                                transform: translateY(5%);
                    }
                    to {
                        opacity: 1;
                        -webkit-transform: translateY(0%);
                                transform: translateY(0%);
                    }
                }
                @media (max-width: 1000px) {
                    .tabs .uldiv li label {
                        white-space: initial;
                    }
                }


                .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .slidertab {
                    -webkit-transform: translateX(-18px);
                            transform: translateX(-18px);
                }
                /*.tabs input[name="tab-control"]:nth-of-type(1):checked ~ .data-content > section:nth-child(1) {
                    display: block;
                }*/
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .uldiv > li:nth-child(2) > label {
                    cursor: default;
                }
                
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                    -webkit-transform: translateX(32px);
                            transform: translateX(32px);
                }
                /*.tabs input[name="tab-control"]:nth-of-type(2):checked ~ .data-content > section:nth-child(2) {
                    display: block;
                }*/

                .multi-colDiv{
                    margin: 24px 0;
                    text-align: left;
                    padding: 0 16px;
                    
                }
                @media screen and  (min-width:580px) {
                    .multi-colDiv{
                        display: grid;
                        grid-template-columns: 1fr 1fr 1fr;
                    }
                    .columnsDiv{
                        justify-content: center;
                    }
                }
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="ReceiptBackFlushDSR" class="bgcolorform">
					<div ID="dsrDiv" class="outerDivSummary" style="MARGIN-BOTTOM: 10PX;">

						<div id='dataDiv' class="dataDiv"
							style="height:100%;width:100%;overflow-y:auto">
							<div>
								<table id="receiptTable" class="tTitleD" border="0"
									cellspacing="1" cellpadding="1" width="100%" style="padding: 15px;padding-top: 8px;">
									<xsl:for-each select="//Detail1">
									<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="tdSpanh" style="width:auto;float: left;text-align:left;margin-bottom: -4px;">Tran Date</span>
											</td>
									</tr>
									<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">
												<span CLASS="tdSpan" style="width:auto;float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="tran_date" />
												</span>
											</td>
									</tr>
									<tr>
											<td class="cellttl1 firstData lineSpace" width="auto">
												<span CLASS="tdSpanh" style="width:auto;float: left;text-align:left;margin-bottom: -4px;">Worker Details</span>
											</td>
								 	</tr>
								 	<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">

												<span class="tdSpan" style="text-transform:capitalize; float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="loc_code" />
												</span>

											</td>
									</tr>
									<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">

												<span class="tdSpan" style="text-transform:capitalize; float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="loc_code_descr" />
												</span>

											</td>
									</tr>
									<tr>
											<td class="cellttl1 firstData lineSpace" width="auto">
												<span CLASS="tdSpanh" style="width:auto;float: left; text-align:left;margin-bottom: -4px;">Item Details</span>
											</td>
									</tr>
									<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">

												<span class="tdSpan" style="text-transform:capitalize; float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="item_code" />
												</span>

											</td>
									</tr>
									<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">

												<span class="tdSpan" style="text-transform:capitalize; float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="item_code_descr" />
												</span>

											</td>
									</tr>
									<tr>
											<td class="cellttl1 firstData lineSpace" width="auto">
												<span CLASS="tdSpanh" style="width:auto;float: left; text-align:left;margin-bottom: -4px;">Quantity</span>
											</td>
									</tr>
									<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">

												<span class="tdSpan" style="text-transform:capitalize; float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="quantity" />
												</span>

											</td>
									</tr>
									<!-- <tr>
											<td class="cellttl1 firstData lineSpace" width="auto">
												<span CLASS="tdSpanh" style="width:auto;float: left; text-align:left;margin-bottom: -4px;">BOM Quantity</span>
											</td>
									</tr>
									<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">

												<span class="tdSpan" style="text-transform:capitalize; float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="batch_qty" />
												</span>

											</td>
									</tr> -->
								</xsl:for-each>
							</table>
						</div>
					</div>
				</div>
					<div class="mainbody">
					      <xsl:variable name="hostUrl">
                                    <xsl:for-each select="//Detail1">
                                        <xsl:if test="attribute/@updateFlag!='D'">
                                            <xsl:value-of select="host_url" />
                                        </xsl:if>
                                    </xsl:for-each>
                          </xsl:variable>
                          
                          <xsl:variable name="feed">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_feed.svg')" />
                        	</xsl:variable>
                        	<xsl:variable name="feed_alt">
                         	 <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_feed_alt.svg')" />
                        	</xsl:variable>
                        	<xsl:variable name="table">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_table.svg')" />
                        	</xsl:variable>
                        	<xsl:variable name="table_alt">
                           	 <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_table_alt.svg')" />
                        	</xsl:variable>
					    
					     <div class="tabs">
                            <input type="radio" id="tab1" name="tab-control" checked="true"  />
                            <input type="radio" id="tab2" name="tab-control" />
                            <ul class="uldiv">
                                <li class="rightcol-spacing" title="Feed View">
                                    <label for="tab1" role="button" class="tablinks" >
                                        <span>
                                            <div class="btniconborder feed_default_bg" id="feedbg" style="display: none">
                                                <IMG 
                                                    id="feedicon" width ="30" height="30"
                                                    onclick="focusView('focusOnFeed','{normalize-space($feed_alt)}','{normalize-space($table)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$feed_alt" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                                <li class="lidiv rmv-Mrg" title="Table View">
                                    
                                    <label for="tab2" role="button" class="tablinks" >
                                        <span style="display: none">
                                            <div class="btniconborder table_default_bg" id="tablebg">
                                                <IMG 
                                                    id="tableicon" width ="30" height="30"
                                                    onclick="focusView('focusOnTable','{normalize-space($table_alt)}','{normalize-space($feed)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$table" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                            </ul>
                            <div class="slidertab" style="display: none">
                                <div class="indicator"></div>
                            </div>
							<xsl:variable name="host_url">
                                <xsl:for-each select="//Detail1">
                                    <xsl:value-of select="host_url" />
                                </xsl:for-each>
                            </xsl:variable>
							<div class="data-content">
								<section id="section-n1">

                                    <xsl:variable name="detail2_listed_count">
                                        <xsl:for-each select="//Detail2">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail2)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail2_listed_count) > '0'">
                                        <xsl:variable name="detail2_form">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','2',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail2_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail2_form,',')" />
                                        </xsl:variable>
                                        
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail2_form_name" />
                                        </xsl:call-template>
                                        
                                    </xsl:if>

                                </section>
									
								</div>
							</div>
						</div>
				</form>
			</body>
	</html>
	</xsl:template>
	<xsl:variable name="host">
        <xsl:for-each select="//Detail1">
                <xsl:value-of select="host_url" />
        </xsl:for-each>
    </xsl:variable>
    <xsl:template name="tmpSplitStringFeed">
		<xsl:param name="stringtosplit" />
		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>
		<xsl:variable name="form_no">
			<xsl:value-of select="substring-after($value,'(')" />
		</xsl:variable>
		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>
		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>
		<xsl:variable name="collapse">
			<xsl:value-of
				select="concat(normalize-space($host),'/ibase/webitm/images/Summary/collapse.svg')" />
		</xsl:variable>
		<xsl:variable name="expand">
			<xsl:value-of
				select="concat(normalize-space($host),'/ibase/webitm/images/Summary/expand.svg')" />
		</xsl:variable>
		<xsl:if test="normalize-space($form_name) = 'item'">
			<xsl:variable name="item_count">
				<xsl:value-of
					select="count(//node()[starts-with(name(), $detail)][attribute/@updateFlag!='D'])" />
			</xsl:variable>
			<xsl:if test="normalize-space($item_count) > '0'">
				<div  class="headerdata datafontsize">
               Item Details
            	</div>
				<div  class="headerdata datafontsize">
                	<div class="headerfontsize">
                	<xsl:value-of
                        select="normalize-space($item_count)" />
                    Products
                    </div>
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext" style="display: none">
                                <IMG
                                    id="item_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('item_list', 'item_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>
                <div id='item_list'>
  
				
                                <div class="containerfeed datafontsize">

									<xsl:variable name="item_descr">
											<xsl:value-of select="item_descr" />
									</xsl:variable>
									<xsl:variable name="lot_no">
											<xsl:value-of select="lot_no" />
									</xsl:variable>
									<xsl:variable name="balance_qty">
											<xsl:value-of select="balance_qty" />
									</xsl:variable>
									<xsl:variable name="quantity">
											<xsl:value-of select="quantity" />
									</xsl:variable>
									<xsl:call-template name="tmpOrderFeed">
										<xsl:with-param name="orderFormName"
											select="concat($host,'@',$item_descr,'#',$lot_no,'*',$balance_qty,'!',$quantity)" />
									</xsl:call-template>  

                                </div>

                </div>
            </xsl:if>
		</xsl:if>
		
	</xsl:template>
	
	<xsl:template name="tmpOrderFeed">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="item_descr">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="lot_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '*')" />
		</xsl:variable>
		
		<xsl:variable name="balance_qty">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="quantity">
			<xsl:value-of
				select="substring-after($ord_value,'!')" />
		</xsl:variable>
		
		<xsl:variable name="item_detail">
			<xsl:value-of select="concat('Detail','2')" />
		</xsl:variable>
		<xsl:variable name="item_listed_count">
			
				<xsl:for-each
					select="//node()[starts-with(name(), $item_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $item_detail)])" />
					</xsl:if>
				</xsl:for-each>
				
		</xsl:variable>

		
                <div>
                     <xsl:call-template name="tempOrderDataFeed">
                        <xsl:with-param name="orderData"
                            select="concat($item_detail,'@',$item_listed_count,'#',$ord_host_url)" />
                    </xsl:call-template> 
                </div>
 
	</xsl:template>
	
	<xsl:template name="tempOrderDataFeed">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="item_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="item_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
        <xsl:variable name="ord_data_url">
            <xsl:value-of
				select="substring-after($order_data_value,'#')" />
        </xsl:variable>
        
        <div>
			<xsl:for-each
				select="//node()[starts-with(name(), $item_details)]">
						
				<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="item_descr">
									<xsl:value-of select="item_descr" />
									</xsl:variable>
									<xsl:variable name="lot_no">
											<xsl:value-of select="lot_no" />
									</xsl:variable>
									<xsl:variable name="balance_qty">
											<xsl:value-of select="balance_qty" />
									</xsl:variable>
									<xsl:variable name="quantity">
											<xsl:value-of select="quantity" />
									</xsl:variable>
						<div class="itemOuterDiv">
                                    <div class="prescription_det">
                                        <div class="iconborder product-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_data_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($item_descr)}&amp;object=rcpt_backflush_wiz&amp;objName=rcpt_backflush_wiz&amp;ALT_FLD_VALUE={normalize-space($item_descr)}"
                                
                                class="brandImg align-imgtext">
                            </IMG>
                        </div> 
                        <div class="namespacing">
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$item_descr" />
                            </div>
                            <div class="headerfontsize">
                                Issue Qty: <xsl:value-of select="$quantity" />
                            </div>
                        </div>
                         <div class=" align-imgtext rightcol-spacing">
                       		<div class="hideoverflowfeed">
                   				<xsl:value-of select="$lot_no" />
                   			</div>
              				<div class="headerfontsize">
                 				Balance Qty: <xsl:value-of select="$balance_qty" />
                             </div>
                         </div>
                      </div>
                   </div>
                   <div class="prescription_btm_border"></div>
				</xsl:if>
			</xsl:for-each>
		</div>
        
	</xsl:template>
</xsl:stylesheet>
	