package com.servlet;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


@WebServlet("/apiDetails")
public class SendAPIDetails extends HttpServlet
{

	
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException
	{
	
		try 
		{

			String firstNAme = request.getParameter("firstname");
			String lastName = request.getParameter("lastname");
			String phonNo = request.getParameter("phoneno");
			String email = request.getParameter("email");

			
			URL url = new URL("http://httpbin.org/post");
			
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			
			connection.setRequestMethod("POST");
			//connection.setRequestProperty("Content-Type","application/x-www-form-urlencoded");
			connection.setRequestProperty("X-HTTP-Method-Override","POST");

			
			connection.setDoOutput(true);
			connection.setUseCaches(false);
			
			Map<String, String> paramMap = new HashMap<String,String>();
			paramMap.put("First Name", firstNAme);
			paramMap.put("last Name", lastName);
			paramMap.put("Phone No", phonNo);
			paramMap.put("Email", email);
			
			StringBuilder parameterBuilder = new StringBuilder();
			for(Map.Entry<String, String> params :  paramMap.entrySet())
			{
				if(params != null)
				{
					parameterBuilder.append("&");
				
				}
				parameterBuilder.append(params.getKey()).append("=").append(params.getValue());
			}
			
			String requestBody = parameterBuilder.toString();
			
			byte requestBodyBytes[] =requestBody.getBytes(StandardCharsets.UTF_8);
		
			connection.setRequestProperty("Content-Length", String.valueOf( requestBody.length() ) );
		
			
			DataOutputStream dataoutputstream = new DataOutputStream(connection.getOutputStream());
			dataoutputstream.write(requestBodyBytes);
			dataoutputstream.close();
			dataoutputstream.flush();
			
			int responseCode = connection.getResponseCode();
			System.out.println("REsponse COde"+responseCode);
			
			
			BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
			String line;
			StringBuilder urlresponse = new StringBuilder();
			
			while((line = bufferedreader.readLine()) != null)
			{
				
				urlresponse.append(line);
			}
			
			bufferedreader.close();
			
			System.out.println("Response Body"+urlresponse.toString() );
			
			connection.disconnect();
			
			
			response.sendRedirect("");
		}
		
		
		catch (MalformedURLException e) 
		{
			e.printStackTrace();
			System.out.println("Exception is"+e);
		}
		
		
		catch (Exception e) {
		
			e.printStackTrace();
			System.out.println("Exception is"+e);
			
		}

	}
	
}
