<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
<html>
	<head>
	<TITLE>Audit Trail Detail</TITLE>
	<script language="Javascript" src="/ibase/webitm/js/ITMUserAuditTrail.js"></script>
	<script language="Javascript" src="/ibase/webitm/js/jsrsClient.js"/>
	<script language="Javascript" src="/ibase/webitm/js/ValidateColumn.js"/>
	<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/ITMAttachmentView.css"/>  
	
	<style>
		.ImgErrDivClass
		{
			border-radius: 50%;
			width: 30px;
			background-color: #cfbebe;
			height: 30px;
			line-height: 30px;
			display: none;
			text-align: center;
		}
		
		.ImgErrDivClass1
		{
			display:none; 
			color: #fff;
		}
		
		.ImgDivClass
		{
            <!--Added width by shrutika on 28-06-18 [start] for UI related change in Audit trail-->
            width :30px;
			height: 30px;
			border-radius: 50%;
			background-color:#cfbebe;
		} 
		<!--Added by shrutika on 28-06-18 [start] for UI related change in Audit trail-->
        .userNameCss
        {
            color: gray;
            -webkit-font-smoothing: antialiased;
            text-rendering: optimizeLegibility;
            font-weight: 600;
        }
         .chgUserCss
        {
            color: gray;
            -webkit-font-smoothing: antialiased;
            text-rendering: optimizeLegibility;
        }
        <!--Added by shrutika on 28-06-18 [End] for UI related change in Audit trail-->

	</style>
	
	</head>

	<body id='groupDiv' onload="">
		<FORM id="brow" METHOD="POST" ACTION="fwd.jsp" >
			<INPUT type='hidden' name='OBJ_NAME' value='audit_trail'/>
			<INPUT type='hidden' name='PAGE_CONTEXT' value='1'/>
			<INPUT type='hidden' name='OBJ_CONTEXT' value='1'/>
			<INPUT type='hidden' name='EDIT_FLAG' value='A'/>
			<INPUT type='hidden' name='EDIT_TMPLT' value='1'/>
			<INPUT type='hidden' name='DOM_ID' value=''/>
			<INPUT type='hidden' name='DB_ID' value=''/>
			<INPUT type='hidden' name='CONFIRM_ID' value='~'/>
			<INPUT type='hidden' name='COL_NAME' value=''/>
			<INPUT type='hidden' name='ORDER' value='ascending'/>
			<INPUT type='hidden' name='DATATYPE' value='text'/>
			<INPUT type='hidden' name='REFRESH_MODE' value='false'/>

			<xsl:for-each select="/DocumentRoot/group0">
				<xsl:for-each select="./Header0">
					<DIV ID="Tableborder" style="height: 100%;"> <xsl:value-of select="nodata"/>
						<DIV ID="TABLECONTAINER" style="margin:-8px;">
							<TABLE name="main" id="main"  class="tableClass" cellpadding="5px" cellspacing="5px" width="100%" style="height: auto;">
								<xsl:for-each select="./Detail1[attribute/@updateFlag!='D']"> 
								<xsl:sort select="chg_date"/> 
									
									<xsl:variable name="CURVALUE"><xsl:value-of select="chg_id"/> </xsl:variable>	
									<xsl:variable name="rec_ref_id"><xsl:value-of select="ref_id"/> </xsl:variable>	
									<xsl:variable name="rec_obj_name"><xsl:value-of select="obj_name"/> </xsl:variable>	

									<xsl:variable name="CHGUSER"><xsl:value-of select="normalize-space(chg_user)"/></xsl:variable>	
									<xsl:variable name="CHGTERM"><xsl:value-of select="chg_term"/></xsl:variable>	
									<xsl:variable name="action_prfrm"><xsl:value-of select="action_prfrm"/></xsl:variable>

									<xsl:variable name="i" select="position()" />	
									<tr id="attachList{$CURVALUE}">	
										<td style="border:1px solid lightgray;">
											<div class="PanelLabel" name="feed" id="panelList{$CURVALUE}" style = "padding: 0px !important;margin:0px;border-bottom:none;"
												onclick="changeRecord('{$CURVALUE}', '{$rec_ref_id}', '{$rec_obj_name}');" >	
												<table style="border-collapse: collapse;width:100%" cellpadding="0" cellspacing="0" >
													<tr>
														<td style = "padding: 3px 5px 3px 5px">
															<HTML>
																<TABLE style = "width:100%;padding-right: 5px;word-break:break-all" cellpadding="0" cellspacing="0">
																	<TR>
																		<TD width="50%">
																			<span class='mainfeedStyle chgUserCss' style="font-size: 14px;">
																				<xsl:value-of select='descr'/>&#160;
																			</span>
																		</TD>
																		<TD width="50%">
																			<span class='mainfeedStyle userNameCss' style="font-size: 12px;float:right">
																				<xsl:if test="$action_prfrm = 'E' or $action_prfrm = 'e' ">
																					Edited
																				</xsl:if>
																				<xsl:if test="$action_prfrm = 'A' or $action_prfrm = 'a'">
																					Added
																				</xsl:if>
																				<xsl:if test="$action_prfrm = 'C' or $action_prfrm = 'c'">
																					Copied
																				</xsl:if>
																				<xsl:if test="$action_prfrm = 'DELETE_ATTACHMENT'">
																					Delete Attachment
																				</xsl:if>
																				
																				<xsl:if test="$action_prfrm = 'UPLOAD_ATTACHMENT'">
																					Add Attachment
																				</xsl:if>
																				<xsl:if test="$action_prfrm = 'ADD_TAG'">
																					Add Tag
																				</xsl:if>
																				<xsl:if test="$action_prfrm = 'DELETE_TAG'">
																					Delete Tag
																				</xsl:if>
																				<xsl:if test="($action_prfrm != 'E') and ($action_prfrm != 'A') and ($action_prfrm != 'C') and ($action_prfrm != 'DELETE_ATTACHMENT') and ($action_prfrm != 'UPLOAD_ATTACHMENT') and ($action_prfrm != 'ADD_TAG') and ($action_prfrm != 'DELETE_TAG') and ($action_prfrm != 'a') and ($action_prfrm != 'c') and ($action_prfrm != 'e')">
																					<xsl:value-of select='action_prfrm'/>&#160;
																				</xsl:if>
																			</span>
																		</TD>
																	</TR>                                   
																	<TR>
																		<TD width="50%">
																			<span class='mainfeedStyle' style="font-size: 11px;color:gray">
																				&#160;&#160;<xsl:value-of select='ref_id'/>&#160;
																			</span>
																		</TD>
																		<TD width="50%">
																			<span class='mainfeedStyle chgUserCss' style="font-size: 11px;color:gray;float:right">
																				<xsl:choose> 
																				<xsl:when test="($chg_date ='27/12/93 11:11:11')">
																				
																				</xsl:when>
																				
																				<xsl:otherwise>
																				 <xsl:value-of select='chg_date'/>
																				</xsl:otherwise>																				
																				</xsl:choose>
																			</span>
																		</TD>
																	</TR>
																									
																	<TR>
																		<TD width="50%">
																			<span class='mainfeedStyle' style="font-size: 11px;color:gray">
																			IP Address&#160;&#160;<xsl:value-of select='chg_ip'/>&#160;
																			</span>
																		</TD>
																		<TD width="50%">
																			<span class='mainfeedStyle' style="font-size: 11px;color:gray;float:right">
																				Terminal&#160;&#160;<xsl:value-of select='chg_term'/>&#160;
																			</span>
																		</TD>
																	</TR>
																	
																</TABLE>
															</HTML>
														</td>
													</tr>
												</table>
											</div>
										</td>
									</tr>
								</xsl:for-each>
							</TABLE>
						</DIV>
					</DIV>
				</xsl:for-each>
			</xsl:for-each>
		</FORM>
	</body>
</html>
</xsl:template>
</xsl:stylesheet>

