package com.TelegramBot;

import java.util.ArrayList;
import java.util.List;

import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButton;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardRow;

import com.vdurmont.emoji.EmojiParser;

public class TelegramEmojiBot extends TelegramLongPollingBot
{
	
	  private String smile_emoji = EmojiParser.parseToUnicode(":smiley: some text");
	    private String share_number_emoji = EmojiParser.parseToUnicode(":phone: share your number");
	    private String money_emoji = EmojiParser.parseToUnicode(":moneybag:");

	
	
	@Override
	public void onUpdateReceived(Update update) {
		
	long chatId =update.getMessage().getChatId();
	SendMessage message = new SendMessage();
	message.setChatId(chatId);
	 // We check if the update has a message and the message has text
    if (update.hasMessage() && update.getMessage().hasText())
    {
    	if(update.getMessage().getText().equals("/start"));
    	{
    		String message_text = "Welcome to our bot! "+ smile_emoji;
    		message.setText(message_text);
    		
    	}
    	else if (update.getMessage().getText().equals(smile_emoji))
    	{
    		
    		message.setText("Some text as response");
    	}
//    	else if (update.getMessage().getText().equals(smile_emoji)) {
//            message.setText("some text as response " + money_emoji);
//        }
    	
    }
	
	}

	@Override
	public String getBotToken() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getBotUsername() {
		// TODO Auto-generated method stub
		return null;
	}

	public void sendMessage(SendMessage sendMessage)
	{
		ReplyKeyboardMarkup replyKeyboardMarkup = new ReplyKeyboardMarkup();
		sendMessage.setReplyMarkup(replyKeyboardMarkup);
		replyKeyboardMarkup.setSelective(true);
		replyKeyboardMarkup.setSelective(true);
		replyKeyboardMarkup.setOneTimeKeyboard(false);
		
		List<KeyboardRow> keyboard = new ArrayList<KeyboardRow>();
		KeyboardRow keyboardFirstRow = new KeyboardRow();
		keyboardFirstRow.add(smile_emoji);
		keyboardFirstRow.add(smile_emoji);
		KeyboardRow keyboardSecondRow = new KeyboardRow();
		KeyboardButton shareNumBtn = new KeyboardButton(share_number_emoji);
		shareNumBtn.setRequestContact(true);
		shareNumBtn.setRequestLocation(false);
		keyboardSecondRow.add(shareNumBtn);
		keyboard.add(keyboardFirstRow);
		keyboard.add(keyboardSecondRow);
		replyKeyboardMarkup.setKeyboard(keyboard);
		
		
		
	}
	
}
