/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.RetainerContractConfLocal;
import ibase.webitm.ejb.fin.adv.RetainerContractConfRemote;
import ibase.webitm.ejb.mfg.InvDemSuppTraceBean;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.ejb.Stateless;
import org.w3c.dom.Document;

@Stateless
public class RetainerContractConf
extends ActionHandlerEJB
implements RetainerContractConfLocal,
RetainerContractConfRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();
    CommonConstants commonConstants = new CommonConstants();
    DistCommon discommon = new DistCommon();
    FinCommon finCommon = new FinCommon();
    ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();

    @Override
    public String confirm(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String retString = "";
        Connection conn = null;
        try {
            retString = this.confirm(tranID, xtraParams, forcedFlag, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString:::::" + retString));
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in [RetainerContractConf] confirm " + e.getMessage()));
            throw new ITMException(e);
        }
        return retString;
    }

    public String confirm(String tranID, String xtraParams, String forcedFlag, String userInfoStr) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Inside retain contract  Confirm ...");
        String retString = "";
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        try {
            UserInfoBean userInfo = new UserInfoBean(userInfoStr);
            String transDB = userInfo.getTransDB();
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("#### TransDB connection in : " + transDB));
            conn = transDB != null && transDB.trim().length() > 0 ? connDriver.getConnectDB(transDB) : connDriver.getConnectDB("DriverITM");
            conn.setAutoCommit(false);
            connDriver = null;
            retString = this.confirm(tranID, xtraParams, forcedFlag, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString:::::" + retString));
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in [RetainerContractConf] confirm " + e.getMessage()));
            throw new ITMException(e);
        }
        return retString;
    }

    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)" ========= Inside RetainerContractConf confirm ============= ");
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" =========  tranId ============= " + tranId));
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("xtraParams ::::::::::::: " + xtraParams));
        String errString = "";
        boolean isLocalConn = false;
        String contractId = "";
        try {
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                isLocalConn = true;
            }
            contractId = tranId;
            errString = this.gbfPostLogic(contractId, xtraParams, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString[" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                conn.rollback();
                String string = errString;
                return string;
            }
            try {
                conn.commit();
                errString = this.itmDBAccess.getErrorString("", "CONFSUCESS", "", "", conn);
            }
            catch (Exception e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ex) {
                        e.printStackTrace();
                        throw new ITMException(e);
                    }
                }
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(">>>>>>>>>>>>>In finaly errString:" + errString));
                if (errString != null && errString.trim().length() > 0) {
                    if (isLocalConn) {
                        conn.rollback();
                        conn.close();
                        conn = null;
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Transaction rollback... ");
                } else if (isLocalConn) {
                    conn.commit();
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"@@@@ Transaction commit... ");
                    conn.close();
                    conn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    public String gbfPostLogic(String tranId, String xtraParams, Connection conn) throws Exception {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"----------- Inside gbfPostLogic retainer contract confirm =----------------");
        Statement pstmt = null;
        Statement pstmt1 = null;
        ResultSet rs = null;
        Object rs1 = null;
        String errString = "";
        String sql = "";
        Object demandSupplyMap = null;
        InvDemSuppTraceBean invDemSupTrcBean = null;
        boolean lb_ord_flag = false;
        boolean ordFlag = true;
        boolean isLocalConn = false;
        Object today = null;
        Object date = null;
        Timestamp sysDate = null;
        String status = "";
        String contractId = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
            invDemSupTrcBean = new InvDemSuppTraceBean();
            Calendar currentDate = Calendar.getInstance();
            String sysDateStr = sdf.format(currentDate.getTime());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Now the date is :=>  " + sysDateStr + "]"));
            sysDate = Timestamp.valueOf(String.valueOf(this.genericUtility.getValidDateString(sysDateStr, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat())) + " 00:00:00.0");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Now the sysDate is :=>  " + sysDate + "]"));
            contractId = tranId;
            sql = " Select  status  from retainer_contract where contract_id = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, contractId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                status = this.checkNullAndTrim(rs.getString("status"));
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if ("X".equalsIgnoreCase(status)) {
                String string = errString = this.itmDBAccess.getErrorString("", "VTCANC2", "", "", conn);
                return string;
            }
            if ("E".equalsIgnoreCase(status)) {
                String string = errString = this.itmDBAccess.getErrorString("", "VTEXP1", "", "", conn);
                return string;
            }
            if ("A".equalsIgnoreCase(status)) {
                String string = errString = this.itmDBAccess.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            if ((" ".equalsIgnoreCase(status) || "O".equalsIgnoreCase(status)) && (errString = this.retrieveRetainerContract(tranId, xtraParams, conn)) != null && errString.trim().length() > 0) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString[" + errString + "]"));
                String string = errString;
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                    pstmt1 = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("return errString confirm retainer contract =========>> " + errString));
        return errString;
    }

    public String retrieveRetainerContract(String tranId, String xtraParams, Connection conn) throws Exception {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"----------- Inside retrieveRetainerContract method ----------------");
        Statement pstmt = null;
        Statement pstmt1 = null;
        ResultSet rs = null;
        String errString = "";
        String sql = "";
        Timestamp currDate = null;
        Timestamp sysDate = null;
        int updCnt = 0;
        String status = "";
        double amt = 0.0;
        double amount = 0.0;
        double AmountDet = 0.0;
        String contractId = "";
        String amtType = "";
        String amtTypedet = "";
        HashMap detMap = new HashMap();
        HashMap<String, String> HdrMap = new HashMap<String, String>();
        ArrayList<HashMap> detailList = new ArrayList<HashMap>();
        int detCount = 0;
        int cnt = 0;
        String ediOption = "";
        String dataStr = "";
        contractId = tranId;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
            Calendar currentDate = Calendar.getInstance();
            String sysDateStr = sdf.format(currentDate.getTime());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Now the date is :=>  " + sysDateStr + "]"));
            sysDate = Timestamp.valueOf(String.valueOf(this.genericUtility.getValidDateString(sysDateStr, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat())) + " 00:00:00.0");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Now the sysDate is :=>  " + sysDate + "]"));
            currDate = new Timestamp(System.currentTimeMillis());
            String currDateStr = sdf.format(currDate);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Now the date is currDateStr :=>  " + currDateStr + "]"));
            sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) || "mysql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "Select amount, status  from retainer_contract where contract_id = ? for update" : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "Select amount, status  from retainer_contract (updlock) where contract_id = ?" : "Select amount, status  from retainer_contract where contract_id = ? for update nowait");
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, contractId);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                String string = errString = this.itmDBAccess.getErrorString("", "VTLCKERR", "", "", conn);
                return string;
            }
            amt = rs.getDouble("amount");
            status = this.checkNullAndTrim(rs.getString("status"));
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if ("X".equalsIgnoreCase(status)) {
                String string = errString = this.itmDBAccess.getErrorString("", "VTCANC2", "", "", conn);
                return string;
            }
            if ("E".equalsIgnoreCase(status)) {
                String string = errString = this.itmDBAccess.getErrorString("", "VTEXP1", "", "", conn);
                return string;
            }
            if ("A".equalsIgnoreCase(status)) {
                String string = errString = this.itmDBAccess.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            if (" ".equalsIgnoreCase(status) || " O".equalsIgnoreCase(status)) {
                sql = " Select line_no ,amt_type,amount  from retainer_contractdet where contract_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, contractId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    detMap = new HashMap();
                    detMap.put("line_no", rs.getString("line_no"));
                    amtType = detMap.put("amt_type", rs.getString("amt_type"));
                    amount = detMap.put("amount", rs.getDouble("amount"));
                    detailList.add(detMap);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                detCount = detailList.size();
                sql = " Select count (distinct amt_type) as count  from retainer_contractdet where contract_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, contractId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    cnt = rs.getInt(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (cnt > 1) {
                    String string = errString = this.itmDBAccess.getErrorString("", "VTRCONT1", "", "", conn);
                    return string;
                }
                int x = 0;
                while (x < detCount) {
                    detMap = (HashMap)detailList.get(x);
                    amtTypedet = (String)detMap.get("amt_type");
                    AmountDet = (Double)detMap.get("amount");
                    amount += AmountDet;
                    amtType = amtTypedet;
                    ++x;
                }
            }
            if ("P".equalsIgnoreCase(amtType) && amount != 100.0) {
                String string = errString = this.itmDBAccess.getErrorString("", "VTRCONT2", "", "", conn);
                return string;
            }
            if ("F".equalsIgnoreCase(amtType) && amount != amt) {
                String string = errString = this.itmDBAccess.getErrorString("", "VTPOST2", "", "", conn);
                return string;
            }
            try {
                sql = " update retainer_contract set status= 'A'  where contract_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, contractId);
                updCnt = pstmt.executeUpdate();
                pstmt.close();
                pstmt = null;
                if (updCnt > 0) {
                    conn.commit();
                } else {
                    conn.rollback();
                }
                sql = "SELECT EDI_OPTION FROM TRANSETUP WHERE TRAN_WINDOW = 'w_retainer_contract' ";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next() && (ediOption = rs.getString("EDI_OPTION")) == null) {
                    ediOption = "";
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (ediOption == null || "0".equalsIgnoreCase(ediOption)) {
                    HdrMap.put("status", "A");
                    if ("2".equalsIgnoreCase(ediOption)) {
                        CreateRCPXML createRCPXML = new CreateRCPXML("w_retainer_contract", "tran_id");
                        dataStr = createRCPXML.getTranXML(contractId, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr =[ " + dataStr + "]"));
                        Document ediDataDom = this.genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_retainer_contract", "2", xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (retString != null && "SUCCESS".equalsIgnoreCase(retString)) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from edi 2 batchload in retrieveIndentClose = [" + retString + "]"));
                        }
                    } else {
                        CreateRCPXML createRCPXML = new CreateRCPXML("w_retainer_contract", "tran_id");
                        dataStr = createRCPXML.getTranXML(contractId, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr =[ " + dataStr + "]"));
                        Document ediDataDom = this.genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_retainer_contract", ediOption, xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (retString != null && "SUCCESS".equalsIgnoreCase(retString)) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from batchload in retrieveIndentClose = [" + retString + "]"));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                    pstmt1 = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("return errString retainer contract confirm =========>> " + errString));
        return errString;
    }

    private String checkNullAndTrim(String inputVal) {
        inputVal = inputVal == null ? "" : inputVal.trim();
        return inputVal;
    }

    public String errorType(Connection conn, String errorCode) throws ITMException {
        String msgType = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =  ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, errorCode);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    msgType = rs.getString("MSG_TYPE");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ITMException(ex);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return msgType;
    }
}

