/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.MiscPayConfirm;
import ibase.webitm.ejb.fin.adv.RecPayTrfConf;
import ibase.webitm.ejb.fin.adv.RecvRefundConfLocal;
import ibase.webitm.ejb.fin.adv.RecvRefundConfRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InitialContext;

public class RecvRefundConf
extends ActionHandlerEJB
implements RecvRefundConfLocal,
RecvRefundConfRemote {
    FinCommon finCommon = new FinCommon();
    DistCommon distCommon = new DistCommon();
    E12GenericUtility genericUtility = new E12GenericUtility();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

    @Override
    public String confirm(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"----------------confirmed method (Refund Credit Balance confirm)----through button-----");
        String retString = "";
        Connection conn = null;
        try {
            retString = this.confirm(tranID, xtraParams, forcedFlag, conn);
        }
        catch (Exception exception) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in [Refund Credit Balance Confirmation] confirm " + exception.getMessage()));
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        return retString;
    }

    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"----------------confirmed method (Distribution Issue confirm)---- with Connection-----");
        String sql = "";
        String confirm = "";
        String loginCode = "";
        String errString = "";
        Timestamp tranDate = null;
        HashMap<String, Object> hdrEditMap = new HashMap<String, Object>();
        HashMap<String, Object> dtlEditMap = null;
        ArrayList dtlEditList = new ArrayList();
        Statement pstmt = null;
        ResultSet rs = null;
        boolean isLocalconn = false;
        try {
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                isLocalconn = true;
            }
            SimpleDateFormat appdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
            tranDate = new Timestamp(System.currentTimeMillis());
            loginCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            sql = CommonConstants.DB_NAME.equalsIgnoreCase("DB2") ? " select confirmed from RECV_REFUND_HDR  where tran_id = ? for update " : (CommonConstants.DB_NAME.equalsIgnoreCase("MSSQL") ? " select confirmed from RECV_REFUND_HDR  (updlock)  where tran_id = ? " : " select confirmed from RECV_REFUND_HDR  where tran_id = ? for update nowait ");
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTLCKERR", "", "", conn);
                return string;
            }
            confirm = rs.getString("confirmed");
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (confirm != null && "Y".equalsIgnoreCase(confirm)) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            sql = "select * from RECV_REFUND_HDR where tran_id = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                hdrEditMap.put("tran_id", rs.getString("tran_id"));
                hdrEditMap.put("tran_date", rs.getTimestamp("tran_date"));
                hdrEditMap.put("cust_code", rs.getString("cust_code"));
                hdrEditMap.put("tran_type", rs.getString("tran_type"));
                hdrEditMap.put("pay_mode ", rs.getString("pay_mode"));
                hdrEditMap.put("bank_code", rs.getString("bank_code"));
                hdrEditMap.put("ref_no", this.checkNull(rs.getString("ref_no")));
                hdrEditMap.put("ref_date", rs.getTimestamp("ref_date"));
                hdrEditMap.put("remarks", rs.getString("remarks"));
                hdrEditMap.put("net_amt", rs.getDouble("net_amt"));
                hdrEditMap.put("curr_code", rs.getString("curr_code"));
                hdrEditMap.put("exch_rate", rs.getDouble("exch_rate"));
                hdrEditMap.put("fin_entity", rs.getString("fin_entity"));
                hdrEditMap.put("acct_code__bal", rs.getString("acct_code__bal"));
                hdrEditMap.put("cctr_code__bal", rs.getString("cctr_code__bal"));
                hdrEditMap.put("tran_id__trf", rs.getString("tran_id__trf"));
                hdrEditMap.put("tran_id__pay", rs.getString("tran_id__pay"));
                hdrEditMap.put("site_code", rs.getString("site_code"));
                hdrEditMap.put("confirmed", rs.getString("confirmed"));
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            sql = "select * from RECV_REFUND_DET where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                dtlEditMap = new HashMap<String, Object>();
                dtlEditMap.put("tran_id", rs.getString("tran_id"));
                dtlEditMap.put("line_no", rs.getInt("line_no"));
                dtlEditMap.put("ref_ser", rs.getString("ref_ser"));
                dtlEditMap.put("ref_no", rs.getString("ref_no"));
                dtlEditMap.put("acct_code", rs.getString("acct_code"));
                dtlEditMap.put("cctr_code", rs.getString("cctr_code"));
                dtlEditMap.put("tot_amt", rs.getDouble("tot_amt"));
                dtlEditMap.put("adj_amt", rs.getDouble("adj_amt"));
                dtlEditMap.put("bal_amt", rs.getDouble("bal_amt"));
                dtlEditMap.put("trf_amt", rs.getDouble("trf_amt"));
                dtlEditList.add(dtlEditMap);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            errString = this.recToPayTrasfer(hdrEditMap, dtlEditList, xtraParams, forcedFlag, conn);
            System.out.println("recToPayTrasfer errString :::: [" + errString + "]");
            if (errString.indexOf("VTCONSUCF") == -1) {
                System.out.println("returning error after recToPayTrasfer method call");
                String string = errString;
                return string;
            }
            try {
                errString = this.payToPmntTransfer(hdrEditMap, xtraParams, forcedFlag, conn);
                System.out.println("payToPmntTransfer errString :::: [" + errString + "]");
                if (errString != null && errString.trim().length() > 0 && errString.indexOf("CONFSUCCES") > -1) {
                    sql = "UPDATE RECV_REFUND_HDR SET CONFIRMED = 'Y',CONF_DATE = ?, EMP_CODE__APRV = ? WHERE TRAN_ID = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setTimestamp(1, tranDate);
                    pstmt.setString(2, loginCode);
                    pstmt.setString(3, tranId);
                    pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                    errString = this.itmDBAccessEJB.getErrorString("", "CONFSUCC", "", "", conn);
                }
            }
            catch (Exception e) {
                try {
                    if (isLocalconn) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception ::" + e.getMessage()));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (errString != null && errString.trim().length() > 0 && isLocalconn) {
                    if (errString.indexOf("CONFSUCC") > -1) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Receivable Credit Refund Transaction commited.............from BalTransferConf");
                        conn.commit();
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollbacking......................................");
                        conn.rollback();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollback......................................");
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                        conn = null;
                    }
                }
            }
            catch (Exception ef) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)ef.getMessage());
                ef.printStackTrace();
                throw new ITMException(ef);
            }
        }
        return errString;
    }

    public String recToPayTrasfer(HashMap hdrEditMap, ArrayList dtlEditList, String xtraParams, String forcedFlag, Connection conn) throws SQLException, ITMException, RemoteException, Exception {
        String errString = "";
        String sql = "";
        String status = "";
        String siteCode = "";
        String RecPayTrfTranId = "";
        String tranId = "";
        int lineNo = 0;
        StringBuffer xmlBuff = null;
        Timestamp statDate = null;
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap dtlEditMap = new HashMap();
        try {
            int endIndex;
            SimpleDateFormat appdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
            if (xmlBuff == null) {
                xmlBuff = new StringBuffer();
            }
            xmlBuff.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
            xmlBuff.append("<DocumentRoot>");
            xmlBuff.append("<description>").append("Datawindow Root").append("</description>");
            xmlBuff.append("<group0>");
            xmlBuff.append("<description>").append("Group0 description").append("</description>");
            xmlBuff.append("<Header0>");
            xmlBuff.append("<objName><![CDATA[").append("rec_pay_trf").append("]]></objName>");
            xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
            xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
            xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
            xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
            xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
            xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
            xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
            xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
            xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
            xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
            xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
            xmlBuff.append("<description>").append("Header0 members").append("</description>");
            xmlBuff.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"rec_pay_trf\" objContext=\"1\">");
            xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
            xmlBuff.append("<tran_id/>");
            xmlBuff.append("<tran_date><![CDATA[" + appdf.format((Timestamp)hdrEditMap.get("tran_date")).toString().trim() + "]]></tran_date>");
            xmlBuff.append("<site_code><![CDATA[" + hdrEditMap.get("site_code").toString() + "]]></site_code>");
            xmlBuff.append("<trf_type><![CDATA[1]]></trf_type>");
            xmlBuff.append("<sundry_type><![CDATA[C]]></sundry_type>");
            xmlBuff.append("<sundry_code><![CDATA[" + hdrEditMap.get("cust_code").toString() + "]]></sundry_code>");
            xmlBuff.append("</Detail1>");
            int i = 0;
            while (i < dtlEditList.size()) {
                dtlEditMap = (HashMap)dtlEditList.get(i);
                sql = "SELECT STATUS,STAT_DATE FROM RECEIVABLES WHERE TRAN_SER = ? AND REF_NO = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, dtlEditMap.get("ref_ser").toString());
                pstmt.setString(2, dtlEditMap.get("ref_no").toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    status = rs.getString("STATUS");
                    statDate = rs.getTimestamp("STAT_DATE");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                xmlBuff.append("<Detail2 dbID=''  domID=\"1\" objName=\"rec_pay_trf\" objContext=\"2\">");
                xmlBuff.append("<attribute pkNames=\"\" selected=\"N\" updateFlag=\"A\" status=\"N\" />");
                xmlBuff.append("<tran_id/>");
                xmlBuff.append("<line_no><![CDATA[" + ++lineNo + "]]></line_no>");
                xmlBuff.append("<tran_ser><![CDATA[" + dtlEditMap.get("ref_ser").toString() + "]]></tran_ser>");
                xmlBuff.append("<ref_no><![CDATA[" + dtlEditMap.get("ref_no").toString() + "]]></ref_no>");
                xmlBuff.append("<tot_amt><![CDATA[" + (Double)dtlEditMap.get("tot_amt") + "]]></tot_amt>");
                xmlBuff.append("<adj_amt><![CDATA[" + (Double)dtlEditMap.get("adj_amt") + "]]></adj_amt>");
                xmlBuff.append("<trf_amt><![CDATA[" + (Double)dtlEditMap.get("trf_amt") + "]]></trf_amt>");
                xmlBuff.append("<cur_status><![CDATA[" + status + "]]></cur_status>");
                if (statDate != null) {
                    xmlBuff.append("<stat_date><![CDATA[" + appdf.format(statDate).toString().trim() + "]]></stat_date>");
                }
                xmlBuff.append("</Detail2>");
                ++i;
            }
            xmlBuff.append("</Header0>");
            xmlBuff.append("</group0>");
            xmlBuff.append("</DocumentRoot>");
            siteCode = hdrEditMap.get("site_code").toString();
            errString = this.saveData(xtraParams, siteCode, xmlBuff.toString(), conn);
            if (errString.indexOf("Success") == -1) {
                String string = errString;
                return string;
            }
            String[] arrayForTranId = errString.split("<TranID>");
            RecPayTrfTranId = arrayForTranId[1].substring(0, endIndex = arrayForTranId[1].indexOf("</TranID>"));
            if (RecPayTrfTranId != null && RecPayTrfTranId.trim().length() > 0) {
                System.out.println("tran_id [" + RecPayTrfTranId + "]");
                errString = null;
            }
            RecPayTrfConf recPayTrfConf = new RecPayTrfConf();
            errString = recPayTrfConf.confirm(RecPayTrfTranId, xtraParams, forcedFlag, conn);
            recPayTrfConf = null;
            if (errString.indexOf("VTCONSUCF") == -1) {
                String string = errString;
                return string;
            }
            try {
                tranId = hdrEditMap.get("tran_id").toString();
                sql = "update RECV_REFUND_HDR set tran_id__trf = ? where tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, RecPayTrfTranId);
                pstmt.setString(2, tranId);
                int updCnt = pstmt.executeUpdate();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Count value after updating RECV_REFUND_HDR - tran_id__trf...." + updCnt));
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                System.out.println("recToPayTrasfer Exception ::" + e.getMessage() + ":");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException localSQLException3) {
                System.out.println("Connection not Closed....");
            }
        }
        return errString;
    }

    public String payToPmntTransfer(HashMap RecvRefundHdrMap, String xtraParams, String forcedFlag, Connection conn) throws SQLException, ITMException, RemoteException, Exception {
        String errString = "";
        String sql = "";
        String sql1 = "";
        String tranIdJv = "";
        String tranId = "";
        String tranType = "";
        String chqNo = "";
        String siteCode = "";
        String custCode = "";
        String loginCode = "";
        String bankCode = "";
        String currCode = "";
        String finEntity = "";
        String acctCodeBal = "";
        String cctrCodeBal = "";
        String acctCodeCf = "";
        String cctrCodeCf = "";
        String acctCodeBc = "";
        String cctrCodeBc = "";
        String chqName = "";
        String stanCode = "";
        String refSer = "";
        String refNo = "";
        String acctCode = "";
        String cctrCode = "";
        String sundryType = "";
        String sundryCode = "";
        String rcpMode = "";
        double totAmt = 0.0;
        double payAmt = 0.0;
        double sumDetPayAmt = 0.0;
        double exchRate = 0.0;
        double netAmtBc = 0.0;
        double exchRatePay = 0.0;
        int lineCtr = 0;
        int updCount = 0;
        int updateCnt = 0;
        int updCnt = 0;
        Timestamp tranDate = null;
        Timestamp refDate = null;
        Timestamp refDatePay = null;
        Timestamp dueDate = null;
        Statement pstmt = null;
        Statement pstmtHdr = null;
        Statement pstmtDet = null;
        ResultSet rs = null;
        try {
            loginCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            tranId = RecvRefundHdrMap.get("tran_id").toString();
            tranType = RecvRefundHdrMap.get("tran_type").toString();
            bankCode = RecvRefundHdrMap.get("bank_code").toString();
            chqNo = this.checkNull(RecvRefundHdrMap.get("ref_no").toString());
            System.out.print("chqNo>>>>>>>>>>>>>>" + chqNo);
            siteCode = RecvRefundHdrMap.get("site_code").toString();
            custCode = RecvRefundHdrMap.get("cust_code").toString();
            currCode = RecvRefundHdrMap.get("curr_code").toString();
            finEntity = RecvRefundHdrMap.get("fin_entity").toString();
            acctCodeBal = RecvRefundHdrMap.get("acct_code__bal").toString();
            cctrCodeBal = RecvRefundHdrMap.get("cctr_code__bal").toString();
            tranDate = (Timestamp)RecvRefundHdrMap.get("tran_date");
            refDate = (Timestamp)RecvRefundHdrMap.get("ref_date");
            sql = "select ACCT_CODE__BAL,CCTR_CODE__BAL,ACCT_CODE__CF,CCTR_CODE__CF,ACCT_CODE__BC,CCTR_CODE__BC,ACCT_CODE__CF_AP,CCTR_CODE__CF_AP,ACCT_CODE__CF_AR,CCTR_CODE__CF_AR from bank where bank_code = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bankCode);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                acctCodeCf = rs.getString("ACCT_CODE__CF");
                cctrCodeCf = rs.getString("CCTR_CODE__CF");
                acctCodeBc = rs.getString("ACCT_CODE__BC");
                cctrCodeBc = rs.getString("CCTR_CODE__BC");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            sql = "select acct_code__ar as acct_code,cctr_code__ar as cctr_code,CHQ_NAME,stan_code from customer where cust_code = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, custCode);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                chqName = this.checkNull(rs.getString("CHQ_NAME"));
                stanCode = rs.getString("stan_code");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            tranIdJv = this.generateTranId("w_misc_pay", "M-PAY", siteCode, conn);
            if (tranIdJv.indexOf("ERROR") > -1) {
                String string = tranIdJv;
                return string;
            }
            sql = "select rcp_mode from customer where cust_code = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, custCode);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                rcpMode = rs.getString("rcp_mode");
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("rcp mode in customer [" + rcpMode + " ]"));
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            sql = "insert into misc_payment ( TRAN_ID, TRAN_TYPE, SUNDRY_CODE, PAY_MODE, BANK_CODE, REF_NO, REF_DATE, REMARKS, NET_AMT, CURR_CODE, EXCH_RATE, NET_AMT__BC, SITE_CODE, FIN_ENTITY, ACCT_CODE__BAL, CCTR_CODE__BAL, AUTO_PAID, CHG_DATE, CHG_USER, CHG_TERM, TRAN_DATE, SUNDRY_TYPE, CONFIRMED, CONF_DATE, STATUS, STAT_DATE, ACCT_CODE__CF, CCTR_CODE__CF, DIFF_AMT__EXCH, EMP_CODE__APRV, BANK_CHARGES, ACCT_CODE__BC, CCTR_CODE__BC, CURR_CODE__BC, EXCH_RATE__BC, AUTO_PAY, CHQ_NAME, ANAL_CODE, RND_OFF, RND_TO, RND_AMT, EFF_DATE, ADD_DATE, ADD_TERM, ADD_USER\t)  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            pstmtHdr = conn.prepareStatement(sql);
            pstmtHdr.setString(1, tranIdJv);
            pstmtHdr.setString(2, tranType);
            pstmtHdr.setString(3, custCode);
            pstmtHdr.setString(4, rcpMode);
            pstmtHdr.setString(5, bankCode);
            pstmtHdr.setString(6, chqNo);
            pstmtHdr.setTimestamp(7, refDate);
            pstmtHdr.setString(8, "Auto Payment JV against " + tranId);
            pstmtHdr.setDouble(9, 0.0);
            pstmtHdr.setString(10, currCode);
            pstmtHdr.setDouble(11, 1.0);
            pstmtHdr.setDouble(12, 0.0);
            pstmtHdr.setString(13, siteCode);
            pstmtHdr.setString(14, finEntity);
            pstmtHdr.setString(15, acctCodeBal);
            pstmtHdr.setString(16, cctrCodeBal);
            pstmtHdr.setString(17, "Y");
            pstmtHdr.setTimestamp(18, new Timestamp(System.currentTimeMillis()));
            pstmtHdr.setString(19, loginCode);
            pstmtHdr.setString(20, loginCode);
            pstmtHdr.setTimestamp(21, tranDate);
            pstmtHdr.setString(22, "C");
            pstmtHdr.setString(23, "N");
            pstmtHdr.setNull(24, 93);
            pstmtHdr.setNull(25, 12);
            pstmtHdr.setTimestamp(26, new Timestamp(System.currentTimeMillis()));
            pstmtHdr.setString(27, acctCodeCf);
            pstmtHdr.setString(28, cctrCodeCf);
            pstmtHdr.setDouble(29, 0.0);
            pstmtHdr.setNull(30, 12);
            pstmtHdr.setDouble(31, 0.0);
            pstmtHdr.setString(32, acctCodeBc);
            pstmtHdr.setString(33, cctrCodeBc);
            pstmtHdr.setString(34, currCode);
            pstmtHdr.setDouble(35, 1.0);
            pstmtHdr.setString(36, "Y");
            pstmtHdr.setString(37, chqName);
            pstmtHdr.setString(38, "   ");
            pstmtHdr.setString(39, "N");
            pstmtHdr.setDouble(40, 0.0);
            pstmtHdr.setDouble(41, 0.0);
            pstmtHdr.setTimestamp(42, new Timestamp(System.currentTimeMillis()));
            pstmtHdr.setTimestamp(43, new Timestamp(System.currentTimeMillis()));
            pstmtHdr.setString(44, loginCode);
            pstmtHdr.setString(45, loginCode);
            updCount = pstmtHdr.executeUpdate();
            pstmtHdr.close();
            pstmtHdr = null;
            if (updCount > 0) {
                sql1 = "insert into misc_paydet ( TRAN_ID, LINE_NO, TRAN_SER, VOUCH_NO, VOUCH_DATE, NET_AMT, PAY_AMT, CURR_CODE, EXCH_RATE__VOUCH, DIFF_AMT__EXCH, ACCT_CODE__AP, CCTR_CODE__AP, SUNDRY_TYPE, SUNDRY_CODE, BANK_CHARGES, STAN_CODE, NET_PAY_AMT, TAX_AMT, DISCOUNT, DISCOUNT_AMT, ACCT_CODE__DISC, CCTR_CODE__DISC, EXCH_RATE__PAY, EXCH_RATE, DUE_DATE )  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                pstmtDet = conn.prepareStatement(sql1);
                sql = "select tran_ser,ref_no,ref_date,tot_amt,tot_amt - adj_amt pay_amt,curr_code,acct_code,cctr_code,sundry_code,sundry_type,exch_rate,due_date from misc_payables where tran_ser = 'RCPPAY' and ref_no in (select ref_no from RECV_REFUND_DET where tran_id = ?) ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    refSer = rs.getString("tran_ser");
                    refNo = rs.getString("ref_no");
                    refDatePay = rs.getTimestamp("ref_date");
                    totAmt = rs.getDouble("tot_amt");
                    payAmt = rs.getDouble("pay_amt");
                    currCode = rs.getString("curr_code");
                    acctCode = rs.getString("acct_code");
                    cctrCode = rs.getString("cctr_code");
                    sundryType = rs.getString("sundry_type");
                    sundryCode = rs.getString("sundry_code");
                    exchRatePay = rs.getDouble("exch_rate");
                    dueDate = rs.getTimestamp("due_date");
                    pstmtDet.setString(1, tranIdJv);
                    pstmtDet.setInt(2, ++lineCtr);
                    pstmtDet.setString(3, refSer);
                    pstmtDet.setString(4, refNo);
                    pstmtDet.setTimestamp(5, refDatePay);
                    pstmtDet.setDouble(6, totAmt);
                    pstmtDet.setDouble(7, payAmt);
                    pstmtDet.setString(8, currCode);
                    pstmtDet.setDouble(9, 1.0);
                    pstmtDet.setDouble(10, 0.0);
                    pstmtDet.setString(11, acctCode);
                    pstmtDet.setString(12, cctrCode);
                    pstmtDet.setString(13, sundryType);
                    pstmtDet.setString(14, sundryCode);
                    pstmtDet.setDouble(15, 0.0);
                    pstmtDet.setString(16, stanCode);
                    pstmtDet.setDouble(17, payAmt);
                    pstmtDet.setDouble(18, 0.0);
                    pstmtDet.setDouble(19, 0.0);
                    pstmtDet.setDouble(20, 0.0);
                    pstmtDet.setString(21, acctCode);
                    pstmtDet.setString(22, cctrCode);
                    pstmtDet.setDouble(23, exchRatePay);
                    pstmtDet.setDouble(24, 1.0);
                    pstmtDet.setTimestamp(25, dueDate);
                    pstmtDet.addBatch();
                    pstmtDet.clearParameters();
                }
                int[] updcount = pstmtDet.executeBatch();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Payment detail count [" + updcount.length + "]"));
                pstmtDet.close();
                pstmtDet = null;
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            sql = "select sum(pay_amt) as SUM_DET_PAY__AMT from misc_paydet where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranIdJv);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                sumDetPayAmt = rs.getDouble("SUM_DET_PAY__AMT");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("sumDetNetAmt[" + sumDetPayAmt + "] , TRAN_ID[" + tranIdJv + "]"));
            sql = "select EXCH_RATE from misc_payment where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranIdJv);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                exchRate = rs.getDouble("EXCH_RATE");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            netAmtBc = sumDetPayAmt * exchRate;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("netAmtBc[" + netAmtBc + "], exchRate[" + exchRate + "], TRAN_ID[" + tranIdJv + "]"));
            sql = "UPDATE misc_payment SET NET_AMT = ?, NET_AMT__BC = ? WHERE TRAN_ID = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setDouble(1, sumDetPayAmt);
            pstmt.setDouble(2, netAmtBc);
            pstmt.setString(3, tranIdJv);
            updateCnt = pstmt.executeUpdate();
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("UPDATE misc_payment count[" + updateCnt + "]"));
            pstmt.close();
            pstmt = null;
            errString = new MiscPayConfirm().confirm(tranIdJv, xtraParams, forcedFlag, conn);
            if (errString.indexOf("CONFSUCCES") == -1) {
                String string = errString;
                return string;
            }
            try {
                sql = "update RECV_REFUND_HDR set tran_id__pay = ? where tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranIdJv);
                pstmt.setString(2, tranId);
                updCnt = pstmt.executeUpdate();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Count value after updating RECV_REFUND_HDR - tran_id__pay...." + updCnt));
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                System.out.println("recToPayTrasfer Exception ::" + e.getMessage() + ":");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmtHdr != null) {
                    pstmtHdr.close();
                    pstmtHdr = null;
                }
                if (pstmtDet != null) {
                    pstmtDet.close();
                    pstmtDet = null;
                }
            }
            catch (SQLException localSQLException3) {
                System.out.println("Connection not Closed....");
            }
        }
        return errString;
    }

    private String saveData(String xtraParams, String siteCode, String xmlString, Connection conn) throws ITMException {
        System.out.println("saving data...........");
        InitialContext ctx = null;
        String retString = null;
        String userId = "";
        MasterStatefulLocal masterStateful = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        UserInfoBean userInfoBean = new UserInfoBean();
        try {
            userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            System.out.println("userId" + userId + "]");
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
            masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
            System.out.println("-----------masterStateful------- " + masterStateful);
            String[] authencate = new String[]{userId, ""};
            System.out.println("xmlString to masterstateful [" + xmlString + "]");
            userInfoBean.setEmpCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
            userInfoBean.setRemoteHost(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
            userInfoBean.setSiteCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
            userInfoBean.setLoginCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
            userInfoBean.setEntityCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
            retString = masterStateful.processRequest(authencate, siteCode, true, xmlString, true, conn);
        }
        catch (ITMException itme) {
            System.out.println("ITMException :CreateDistOrder :saveData :==>");
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception :CreateDistOrder :saveData :==>");
            throw new ITMException(e);
        }
        return retString;
    }

    public String generateTranId(String windowName, String tranSer, String siteCode, Connection conn) throws ITMException {
        Statement pstmt = null;
        ResultSet rs = null;
        String selSql = "";
        String tranId = "";
        String keyString = "";
        String xmlValues = "";
        Timestamp currDate = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            try {
                SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
                currDate = new Timestamp(System.currentTimeMillis());
                String currDateStr = sdfAppl.format(currDate);
                selSql = "SELECT KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
                pstmt = conn.prepareStatement(selSql);
                pstmt.setString(1, windowName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    keyString = rs.getString("KEY_STRING");
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                } else {
                    selSql = "SELECT KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW = 'GENERAL' ";
                    pstmt = conn.prepareStatement(selSql);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        keyString = rs.getString("KEY_STRING");
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                    }
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("keyString :" + keyString));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranSer :" + tranSer));
                xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
                xmlValues = String.valueOf(xmlValues) + "<Header></Header>";
                xmlValues = String.valueOf(xmlValues) + "<Detail1>";
                xmlValues = String.valueOf(xmlValues) + "<tran_id></tran_id>";
                xmlValues = String.valueOf(xmlValues) + "<site_code>" + siteCode + "</site_code>";
                xmlValues = String.valueOf(xmlValues) + "<tran_date>" + currDateStr + "</tran_date>";
                xmlValues = String.valueOf(xmlValues) + "</Detail1></Root>";
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("xmlValues  :[" + xmlValues + "]"));
                TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
                tranId = tg.generateTranSeqID(tranSer, "tran_id", keyString, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranId NEWLY WT SITECODE & DATE :" + tranId));
            }
            catch (SQLException ex) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :generateTranId:" + selSql + ex.getMessage() + ":"));
                ex.printStackTrace();
                throw new ITMException((Exception)ex);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :generateTranId:" + e.getMessage() + ":"));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                genericUtility = null;
            }
            catch (Exception exception) {}
        }
        return tranId;
    }

    private String checkNull(String input) {
        if (input == null || "null".equals(input)) {
            input = "";
        }
        return input;
    }
}

