/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class ReceivablesTraceDetails
extends ValidatorEJB {
    Connection conn = null;
    ArrayList traceData = null;
    HashMap recvDetails = null;
    PreparedStatement pstmt = null;
    ResultSet rs = null;
    Timestamp refDate = null;
    Timestamp statDate = null;
    SimpleDateFormat formatter = null;
    E12GenericUtility genericUtility = new E12GenericUtility();

    public ReceivablesTraceDetails(UserInfoBean infoBean) {
        this.setUserInfo(infoBean);
    }

    public ArrayList<HashMap> recvTraceDetails(String tranSer, String refNo, UserInfoBean infoBean) throws ITMException {
        String sql = "";
        String errString = "";
        String newrefDate = "";
        String newStatDate = "";
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Tran ser: [" + tranSer + "]\n Ref No :[" + refNo + "]"));
        try {
            try {
                this.formatter = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
                this.conn = this.getConnection();
                this.traceData = new ArrayList();
                CallableStatement callStat = this.conn.prepareCall("{CALL DP_RECV_TRACE_REFNO(?,?)}");
                callStat.setString(1, tranSer);
                callStat.setString(2, refNo);
                callStat.executeUpdate();
                callStat.close();
                String tranSerNo = "";
                tranSerNo = "R-DIS".equalsIgnoreCase(tranSer) ? "rt.ref_ser__adj = ? and rt.ref_no__adj = ? order by rt.tran_id " : "rt.ref_ser = ? and rt.ref_no = ? order by rt.tran_id ";
                sql = "select rt.ref_ser ref_ser , rt.ref_no ref_no, rt.ref_date ref_date, rt.status_date status_date, r.tot_amt tot_amt, rt.adj_amt adj_amt, rt.ref_ser__adj ref_ser__adj, rt.ref_no__adj ref_no__adj, rt.amt_before amt_before, rt.amt_after amt_after, rt.site_code site_code, s.descr descr from receivables_trace rt , site s , receivables r where rt.site_code = s.site_code and r.tran_ser = rt.ref_ser and r.ref_no = rt.ref_no and " + tranSerNo;
                this.pstmt = this.conn.prepareStatement(sql);
                this.pstmt.setString(1, tranSer);
                this.pstmt.setString(2, refNo);
                this.rs = this.pstmt.executeQuery();
                while (this.rs.next()) {
                    this.recvDetails = new HashMap();
                    this.refDate = this.rs.getTimestamp("ref_date");
                    this.statDate = this.rs.getTimestamp("status_date");
                    if (this.refDate != null && this.statDate != null) {
                        newrefDate = this.formatter.format(this.refDate);
                        newStatDate = this.formatter.format(this.statDate);
                    }
                    this.recvDetails.put("tranSer", this.checkNullAndTrim(this.rs.getString("ref_ser")));
                    this.recvDetails.put("refNo", this.checkNullAndTrim(this.rs.getString("ref_no")));
                    this.recvDetails.put("refDate", newrefDate);
                    this.recvDetails.put("totAmt", this.checkNullAndTrim(this.rs.getString("tot_amt")));
                    this.recvDetails.put("adjAmt", this.checkNullAndTrim(this.rs.getString("adj_amt")));
                    this.recvDetails.put("refSerAdj", this.checkNullAndTrim(this.rs.getString("ref_ser__adj")));
                    this.recvDetails.put("refNoAdj", this.checkNullAndTrim(this.rs.getString("ref_no__adj")));
                    this.recvDetails.put("amtBefore", this.checkNullAndTrim(this.rs.getString("amt_before")));
                    this.recvDetails.put("amtAfter", this.checkNullAndTrim(this.rs.getString("amt_after")));
                    this.recvDetails.put("statusDate", newStatDate);
                    this.recvDetails.put("siteCode", this.checkNullAndTrim(this.rs.getString("site_code")));
                    this.recvDetails.put("siteDescr", this.checkNullAndTrim(this.rs.getString("descr")));
                    this.traceData.add(this.recvDetails);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Trace Data::[" + this.traceData + "]"));
                }
                this.rs.close();
                this.rs = null;
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                errString = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    if (this.rs != null) {
                        this.rs.close();
                        this.rs = null;
                    }
                    if (this.pstmt != null) {
                        this.pstmt.close();
                        this.pstmt = null;
                    }
                    this.conn.close();
                }
                this.conn = null;
            }
            catch (Exception d) {
                d.printStackTrace();
                throw new ITMException(d);
            }
        }
        return this.traceData;
    }

    public String checkNullAndTrim(String input) {
        if (input == null) {
            input = "";
            return "";
        }
        return input.trim();
    }
}

