/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.CRemittanceConf;
import ibase.webitm.ejb.fin.CremittanceTrPostSave;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.CalculateCommission;
import ibase.webitm.ejb.fin.adv.ReceiptAdvConfLocal;
import ibase.webitm.ejb.fin.adv.ReceiptAdvConfRemote;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.ejb.Stateless;

@Stateless
public class ReceiptAdvConf
extends ActionHandlerEJB
implements ReceiptAdvConfLocal,
ReceiptAdvConfRemote {
    FinCommon Fcommon = new FinCommon();
    CRemittanceConf cremittanceConf = new CRemittanceConf();
    CremittanceTrPostSave postSave = new CremittanceTrPostSave();

    @Override
    public String confirm(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String retString = "";
        boolean isConn = false;
        Connection conn = null;
        boolean isPreview = false;
        try {
            retString = this.confirm(tranID, xtraParams, forcedFlag, conn, isPreview);
            if (retString != null && retString.length() > 0 && retString.indexOf("<error>") > -1) {
                return retString;
            }
            if (retString != null && retString.length() > 0 && retString.indexOf("VTCICONF3") < 0) {
                retString = this.getErrorXmlString(this.Fcommon, retString, tranID);
            }
        }
        catch (Exception exception) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in [InvHoldConfEJB] getCurrdateAppFormat " + exception.getMessage()));
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        return retString;
    }

    @Override
    public String confirm(String tranID, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        String retString = "";
        boolean isConn = false;
        boolean isPreview = false;
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Receipt confirm tranID[" + tranID + "]"));
            retString = this.confirm(tranID, xtraParams, forcedFlag, conn, isPreview);
            if (retString != null && retString.length() > 0 && retString.indexOf("<error>") > -1) {
                return retString;
            }
            if (retString != null && retString.length() > 0 && retString.indexOf("VTCICONF3") < 0) {
                retString = this.getErrorXmlString(this.Fcommon, retString, tranID);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        return retString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn, boolean isPreview) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"confirm called........");
        String sql = "";
        String confirm = "";
        String siteCode = "";
        String errString = "";
        String tranSer = "";
        String loginEmpCode = "";
        String runMode = "";
        Statement pstmt = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        ValidatorEJB validatorEJB = null;
        boolean connStatus = false;
        String chgUser = "";
        String tranType = "";
        double chqAmount = 0.0;
        double netAmt = 0.0;
        double taxAmt = 0.0;
        try {
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                connStatus = true;
            }
            finCommon = new FinCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            validatorEJB = new ValidatorEJB();
            loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            runMode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "runMode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Printing loginEmpCode---1-----" + loginEmpCode + "--"));
            sql = "select confirmed ,site_code,chg_user  from receipt where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                confirm = rs.getString("confirmed") == null ? "N" : rs.getString("confirmed");
                siteCode = rs.getString("site_code") == null ? " " : rs.getString("site_code");
                chgUser = rs.getString("chg_user") == null ? " " : rs.getString("chg_user");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (chgUser == null || chgUser.trim().length() == 0) {
                chgUser = "SYSTEM";
            }
            if ("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                sql = "select emp_code from users where code=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, chgUser);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    loginEmpCode = rs.getString(1);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Printing loginEmpCode---2-----" + loginEmpCode + "--"));
            }
            if (isPreview) {
                errString = this.gbfRetrieveReceipt(tranId, siteCode, xtraParams, conn, isPreview);
                return errString;
            }
            if (confirm == null || "N".equalsIgnoreCase(confirm) || "Y".equalsIgnoreCase(confirm) && "B".equalsIgnoreCase(runMode)) {
                errString = this.gbfRetrieveReceipt(tranId, siteCode, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("err String from gdfRetrieveMiscRcp =" + errString));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                if (errString != null && errString.trim().length() != 0) {
                    String string = errString;
                    return string;
                }
                if ("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                    loginEmpCode = "E03952";
                }
                sql = "select tran_type, chq_amt, net_amt,tax_amt from receipt where tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    tranType = rs.getString("tran_type");
                    chqAmount = rs.getDouble("chq_amt");
                    netAmt = rs.getDouble("net_amt");
                    taxAmt = rs.getDouble("tax_amt");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (tranType != null && tranType.trim().length() > 0 && !"J".equalsIgnoreCase(tranType.trim())) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tran_type:[" + tranType + "] cheque Amount[" + chqAmount + " ] net AMT [" + netAmt + " ]tax amount---[" + taxAmt));
                    if (taxAmt > 0.0) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("inside if tax_amt---1:[--" + taxAmt));
                        if (chqAmount == 0.0 || netAmt > chqAmount + taxAmt) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tax_amt---2:[--" + taxAmt));
                            errString = itmDBAccessEJB.getErrorString("", "VTRCHQAMT", "", "", conn);
                        }
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("inside else tax_amt---3:[--" + taxAmt));
                        if (chqAmount == 0.0 || netAmt > chqAmount) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tax_amt---4:[--" + taxAmt));
                            errString = itmDBAccessEJB.getErrorString("", "VTRCHQAMT", "", "", conn);
                        }
                    }
                }
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                sql = "update receipt set confirmed = 'Y', conf_date = ?,emp_code__aprv = ? where tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setDate(1, new Date(new java.util.Date().getTime()));
                pstmt.setString(2, loginEmpCode);
                pstmt.setString(3, tranId);
                int updateCoount = pstmt.executeUpdate();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + updateCoount));
                pstmt.close();
                pstmt = null;
                if (updateCoount > 0) {
                    errString = itmDBAccessEJB.getErrorString("", "VTCICONF3", "", "", conn);
                }
            } else {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                String string = errString = itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"115 err String from confirm method.....");
            return errString;
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    if (connStatus) {
                        conn.rollback();
                    }
                }
                catch (SQLException ex) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            try {
                if (errString != null && errString.trim().length() > 0 && conn != null && !conn.isClosed() && connStatus) {
                    if (errString.indexOf("VTCICONF3") > -1) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    conn.close();
                    conn = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
    }

    private String gbfRetrieveReceipt(String tranId, String siteCode, String xtraParams, Connection conn) throws RemoteException, ITMException {
        String errString = this.gbfRetrieveReceipt(tranId, siteCode, xtraParams, conn, false);
        return errString;
    }

    /*
     * Loose catch block
     */
    private String gbfRetrieveReceipt(String tranId, String siteCode, String xtraParams, Connection conn, boolean isPreview) throws RemoteException, ITMException {
        String errString;
        block113: {
            double amtNoBankEffect;
            int detListSize;
            HashMap detMap;
            double detAmount;
            double amountMap;
            FinCommon finCommon;
            ResultSet rs1;
            ResultSet rs;
            PreparedStatement pstmt1;
            Statement pstmt;
            ArrayList<HashMap> ADetList;
            ArrayList<HashMap> DetList;
            ArrayList<HashMap> RcpDetList;
            boolean isEpcCurrSame;
            ArrayList<HashMap> EpcAdjList;
            boolean isError;
            HashMap EpcAdjMap;
            HashMap ADetMap;
            HashMap RcpDetMap;
            HashMap<String, Object> DetMap;
            HashMap<String, Object> RcpHdrMap;
            int findIndex;
            int maxline;
            int i;
            double billDiscountAmt;
            double othAmt;
            double chq;
            double taxAmt;
            double totBc;
            double amtRev;
            double amtRevrsed;
            double amtProv;
            double badDebtAmt;
            double diffAmtExch;
            double hexchRate;
            double totEpcBc;
            double totEpc;
            double amount;
            double hExchRate;
            double tFin;
            double total;
            double totbdDiff;
            double exch;
            double exchRate;
            double advAmt;
            double finChg;
            double rcpAmt;
            String effectParty;
            String empCode;
            String analCode;
            String cctrCodeCr;
            String acctCodeCr;
            String cctrCodeDr;
            String acctCodeDr;
            String refSer;
            String finEntity;
            String hcurrCode;
            String sundryType;
            String currCode;
            String cctrCode;
            String acctCode;
            String scode;
            String stype;
            String cctr;
            String acct;
            String lineNoRef;
            String partyDocRef;
            String rcpClubPost;
            String billDisc;
            String refNo;
            String refser;
            String acctFins;
            String acctFin;
            String bdFluctuationCf;
            String cctrFins;
            String cctrFin;
            String sql;
            String sundryCode;
            block112: {
                E12GenericUtility genericUtility;
                java.util.Date date;
                Timestamp today;
                ITMDBAccessEJB itmDBAccessEJB;
                Timestamp tranDate;
                String ledgPostConf;
                block111: {
                    String rcpType;
                    block110: {
                        block109: {
                            block108: {
                                block107: {
                                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gdf Retrieve Receipt Called...........");
                                    errString = "";
                                    sundryCode = "";
                                    sql = "";
                                    cctrFin = "";
                                    cctrFins = "";
                                    rcpType = "";
                                    bdFluctuationCf = "";
                                    ledgPostConf = "";
                                    acctFin = "";
                                    acctFins = "";
                                    refser = "";
                                    refNo = "";
                                    String acctCodeAr = "";
                                    String cctrCodeAr = "";
                                    billDisc = "";
                                    String custCode = "";
                                    rcpClubPost = "";
                                    partyDocRef = "";
                                    lineNoRef = "";
                                    acct = "";
                                    cctr = "";
                                    stype = "";
                                    scode = "";
                                    acctCode = "";
                                    cctrCode = "";
                                    currCode = "";
                                    sundryType = "";
                                    hcurrCode = "";
                                    finEntity = "";
                                    String hcustCode = "";
                                    refSer = "";
                                    acctCodeDr = "";
                                    cctrCodeDr = "";
                                    acctCodeCr = "";
                                    cctrCodeCr = "";
                                    String rcpepcAdj = "";
                                    analCode = "";
                                    empCode = "";
                                    effectParty = "N";
                                    boolean count = false;
                                    double netAmount = 0.0;
                                    double exchRateRcv = 0.0;
                                    rcpAmt = 0.0;
                                    finChg = 0.0;
                                    double totalAmt = 0.0;
                                    advAmt = 0.0;
                                    double finTotal = 0.0;
                                    exchRate = 0.0;
                                    exch = 0.0;
                                    totbdDiff = 0.0;
                                    total = 0.0;
                                    tFin = 0.0;
                                    hExchRate = 0.0;
                                    amount = 0.0;
                                    totEpc = 0.0;
                                    totEpcBc = 0.0;
                                    hexchRate = 0.0;
                                    diffAmtExch = 0.0;
                                    badDebtAmt = 0.0;
                                    amtProv = 0.0;
                                    amtRevrsed = 0.0;
                                    amtRev = 0.0;
                                    double badAmt = 0.0;
                                    totBc = 0.0;
                                    taxAmt = 0.0;
                                    chq = 0.0;
                                    othAmt = 0.0;
                                    billDiscountAmt = 0.0;
                                    i = 0;
                                    boolean cnt = false;
                                    maxline = 0;
                                    boolean cnt1 = false;
                                    findIndex = -1;
                                    tranDate = null;
                                    RcpHdrMap = null;
                                    DetMap = null;
                                    RcpDetMap = null;
                                    ADetMap = null;
                                    EpcAdjMap = null;
                                    isError = false;
                                    String retString = "";
                                    EpcAdjList = new ArrayList<HashMap>();
                                    isEpcCurrSame = false;
                                    RcpDetList = new ArrayList<HashMap>();
                                    DetList = new ArrayList<HashMap>();
                                    ADetList = new ArrayList<HashMap>();
                                    ArrayList miscRcpDetList = new ArrayList();
                                    pstmt = null;
                                    pstmt1 = null;
                                    rs = null;
                                    rs1 = null;
                                    itmDBAccessEJB = null;
                                    finCommon = null;
                                    DistCommon disCommon = null;
                                    amountMap = 0.0;
                                    detAmount = 0.0;
                                    detMap = null;
                                    detListSize = 0;
                                    amtNoBankEffect = 0.0;
                                    today = null;
                                    date = null;
                                    genericUtility = new E12GenericUtility();
                                    finCommon = new FinCommon();
                                    disCommon = new DistCommon();
                                    cctrFin = finCommon.getFinparams("999999", "ACCT_FINCHG", conn);
                                    if (cctrFin != null && !"NULLFOUND".equalsIgnoreCase(cctrFin)) {
                                        if (cctrFin.indexOf(";") > -1) {
                                            acctFin = cctrFin.substring(0, cctrFin.indexOf(";"));
                                            cctrFin = cctrFin.substring(cctrFin.indexOf(";") + 1);
                                        } else {
                                            acctFin = cctrFin;
                                            cctrFin = "    ";
                                        }
                                        break block107;
                                    }
                                    String string = errString = itmDBAccessEJB.getErrorString("", "VTFINPARM ", "", "", conn);
                                    try {
                                        rs.close();
                                        rs = null;
                                        pstmt.close();
                                        pstmt = null;
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                    return string;
                                }
                                cctrFins = finCommon.getFinparams("999999", "ACCT_FINCHG_AR", conn);
                                if (cctrFins != null && !"NULLFOUND".equalsIgnoreCase(cctrFins)) {
                                    if (cctrFins.indexOf(";") > -1) {
                                        acctFins = cctrFins.substring(0, cctrFins.indexOf(";"));
                                        cctrFins = cctrFins.substring(cctrFins.indexOf(";") + 1);
                                    } else {
                                        acctFins = cctrFins;
                                        cctrFins = "    ";
                                    }
                                    break block108;
                                }
                                String string = errString = itmDBAccessEJB.getErrorString("", "VTFINPARM ", "", "", conn);
                                try {
                                    rs.close();
                                    rs = null;
                                    pstmt.close();
                                    pstmt = null;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                return string;
                            }
                            bdFluctuationCf = finCommon.getFinparams("999999", "BD_FLUCTUATION_CF", conn);
                            if (!"NULLFOUND".equalsIgnoreCase(bdFluctuationCf)) break block109;
                            String string = errString = itmDBAccessEJB.getErrorString("", "VTFINPARM ", "", "", conn);
                            try {
                                rs.close();
                                rs = null;
                                pstmt.close();
                                pstmt = null;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            return string;
                        }
                        rcpClubPost = finCommon.getFinparams("999999", "RCP_CLUB_POST", conn);
                        if (!"NULLFOUND".equalsIgnoreCase(rcpClubPost)) break block110;
                        String string = errString = itmDBAccessEJB.getErrorString("", "VTFINPARM ", "", "", conn);
                        try {
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return string;
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("rcpClubPost>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + rcpClubPost));
                    itmDBAccessEJB = new ITMDBAccessEJB();
                    sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT tran_id, adv_amt, rcp_type FROM receipt  WHERE tran_id = ? for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT tran_id, adv_amt, rcp_type FROM receipt (updlock) WHERE tran_id = ? " : " SELECT tran_id, adv_amt, rcp_type FROM receipt WHERE tran_id =  ? for update nowait");
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        tranId = rs.getString("tran_id") == null ? " " : rs.getString("tran_id");
                        advAmt = rs.getDouble("adv_amt");
                        rcpType = rs.getString("rcp_type") == null ? " " : rs.getString("rcp_type");
                    }
                    pstmt.close();
                    pstmt = null;
                    rs.close();
                    rs = null;
                    if (!(advAmt < 0.0)) break block111;
                    String string = errString = itmDBAccessEJB.getErrorString("", "VTRCPADV2", "", "", conn);
                    try {
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return string;
                }
                today = new Timestamp(System.currentTimeMillis());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
                date = simpleDateFormat.parse(today.toString());
                today = Timestamp.valueOf(String.valueOf(simpleDateFormat.format(date).toString()) + " 00:00:00.0");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Date : [ " + date + " ] today : [ " + today + " ] "));
                sql = "select tran_id, tran_date, cust_code, tran_type, rcp_mode, bank_code, ref_no, ref_date, remarks, net_amt, curr_code, exch_rate, net_amt__bc, fin_entity, acct_code__ar, cctr_code__ar, acct_code__bal, cctr_code__bal, site_code, confirmed, adv_amt ,acct_code__cf, cctr_code__cf,eff_date, chq_amt,remarks, proj_code, entry_batch_no,bill_amt , diff_amt__exch, net_amt__bc,  anal_code, bill_disc_amt, oth_amt, efundadj_amt, acct_code__adv, cctr_code__adv ,tax_amt,item_ser from  receipt  where tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    RcpHdrMap = new HashMap<String, Object>();
                    RcpHdrMap.put("tran_date", rs.getDate("tran_date"));
                    RcpHdrMap.put("tran_id", rs.getString("tran_id"));
                    RcpHdrMap.put("cust_code", rs.getString("cust_code"));
                    RcpHdrMap.put("tran_type", rs.getString("tran_type"));
                    RcpHdrMap.put("rcp_mode", rs.getString("rcp_mode"));
                    RcpHdrMap.put("bank_code", rs.getString("bank_code"));
                    RcpHdrMap.put("ref_no", rs.getString("ref_no"));
                    RcpHdrMap.put("ref_date", rs.getDate("ref_date"));
                    RcpHdrMap.put("remarks", rs.getString("remarks"));
                    RcpHdrMap.put("net_amt", rs.getDouble("net_amt"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("net amt in reterive from receipt:[" + RcpHdrMap.get("net_amt")));
                    RcpHdrMap.put("exch_rate", rs.getDouble("exch_rate"));
                    RcpHdrMap.put("curr_code", rs.getString("curr_code"));
                    RcpHdrMap.put("net_amt__bc", rs.getDouble("net_amt__bc"));
                    RcpHdrMap.put("fin_entity", rs.getString("fin_entity"));
                    RcpHdrMap.put("acct_code__ar", rs.getString("acct_code__ar"));
                    RcpHdrMap.put("cctr_code__ar", rs.getString("cctr_code__ar") == null ? " " : rs.getString("cctr_code__ar"));
                    RcpHdrMap.put("acct_code__bal", rs.getString("acct_code__bal"));
                    RcpHdrMap.put("cctr_code__bal", rs.getString("cctr_code__bal") == null ? " " : rs.getString("cctr_code__bal"));
                    RcpHdrMap.put("site_code", rs.getString("site_code"));
                    RcpHdrMap.put("confirmed", rs.getString("confirmed"));
                    RcpHdrMap.put("adv_amt", rs.getDouble("adv_amt"));
                    RcpHdrMap.put("acct_code__cf", rs.getString("acct_code__cf"));
                    RcpHdrMap.put("cctr_code__cf", rs.getString("cctr_code__cf") == null ? " " : rs.getString("cctr_code__cf"));
                    RcpHdrMap.put("eff_date", rs.getDate("eff_date"));
                    RcpHdrMap.put("chq_amt", rs.getDouble("chq_amt"));
                    RcpHdrMap.put("remarks", rs.getString("remarks"));
                    RcpHdrMap.put("proj_code", rs.getString("proj_code"));
                    RcpHdrMap.put("entry_batch_no", rs.getString("entry_batch_no"));
                    RcpHdrMap.put("bill_amt", rs.getDouble("bill_amt"));
                    RcpHdrMap.put("diff_amt__exch", rs.getDouble("diff_amt__exch"));
                    RcpHdrMap.put("anal_code", rs.getString("anal_code"));
                    RcpHdrMap.put("bill_disc_amt", rs.getDouble("bill_disc_amt"));
                    RcpHdrMap.put("oth_amt", rs.getDouble("oth_amt"));
                    RcpHdrMap.put("efundadj_amt", rs.getDouble("efundadj_amt"));
                    RcpHdrMap.put("acct_code__adv", rs.getString("acct_code__adv"));
                    RcpHdrMap.put("cctr_code__adv", rs.getString("cctr_code__adv") == null ? " " : rs.getString("cctr_code__adv"));
                    RcpHdrMap.put("tax_amt", rs.getDouble("tax_amt"));
                    RcpHdrMap.put("item_ser", rs.getString("item_ser"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" Header Map..........1" + RcpHdrMap));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)RcpHdrMap.toString());
                }
                pstmt.close();
                pstmt = null;
                rs.close();
                rs = null;
                sql = " select ledg_post_conf from transetup where upper(tran_window) = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, "W_RECEIPT_ADV");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    ledgPostConf = rs.getString("ledg_post_conf");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (ledgPostConf != null && "Y".equalsIgnoreCase(ledgPostConf)) {
                    if (((java.util.Date)RcpHdrMap.get("tran_date")).compareTo(today) != 0) {
                        tranDate = today;
                    }
                    sql = "update receipt set tran_date  =? where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setTimestamp(1, today);
                    pstmt.setString(2, tranId);
                    int updateCoount = pstmt.executeUpdate();
                    if (updateCoount > 0) {
                        RcpHdrMap.put("tran_date", today);
                    }
                    pstmt.close();
                    pstmt = null;
                }
                if (((java.util.Date)RcpHdrMap.get("eff_date")).compareTo(today) <= 0) break block112;
                String string = errString = itmDBAccessEJB.getErrorString("", "VTRCPDT1", "", "", conn);
                try {
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return string;
            }
            try {
                try {
                    sql = "select sundry_type,sundry_code,acct_code,cctr_code,emp_code, anal_code,curr_code ,exch_rate,amount,party_doc_ref,case when effect_party is null then 'N' else effect_party end as effect_party,case when eff_bank is null then 'N' else eff_bank end as eff_bank from rcpacct where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        DetMap = new HashMap<String, Object>();
                        DetMap.put("sundry_type", rs.getString("sundry_type"));
                        DetMap.put("sundry_code", rs.getString("sundry_code"));
                        DetMap.put("acct_code", rs.getString("acct_code"));
                        DetMap.put("cctr_code", rs.getString("cctr_code"));
                        DetMap.put("emp_code", rs.getString("emp_code"));
                        DetMap.put("anal_code", rs.getString("anal_code"));
                        DetMap.put("curr_code", rs.getString("curr_code"));
                        DetMap.put("exch_rate", rs.getDouble("exch_rate"));
                        DetMap.put("amount", rs.getDouble("amount"));
                        DetMap.put("party_doc_ref", rs.getString("party_doc_ref"));
                        DetMap.put("effect_party", rs.getString("effect_party"));
                        DetMap.put("eff_bank", rs.getString("eff_bank"));
                        DetList.add(DetMap);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)" receipt Acct Map..........");
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList initial2 [" + DetList.toString() + "]"));
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    detListSize = DetList.size();
                    sql = "select ref_ser,ref_no,adj_amt,acct_code,cctr_code,exch_rate__vouch from rcpadv where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ADetMap = new HashMap();
                        ADetMap.put("ref_ser", rs.getString("ref_ser"));
                        ADetMap.put("ref_no", rs.getString("ref_no"));
                        ADetMap.put("adj_amt", rs.getDouble("adj_amt"));
                        ADetMap.put("sundry_type", "C");
                        sql = "select cust_code from receivables where tran_ser=? and ref_no=?";
                        pstmt1 = conn.prepareStatement(sql);
                        pstmt1.setString(1, rs.getString("ref_ser"));
                        pstmt1.setString(2, rs.getString("ref_no"));
                        rs1 = pstmt1.executeQuery();
                        if (rs1.next()) {
                            ADetMap.put("sundry_code", rs1.getString("cust_code"));
                        }
                        rs1.close();
                        rs1 = null;
                        pstmt1.close();
                        pstmt1 = null;
                        ADetMap.put("acct_code", rs.getString("acct_code"));
                        ADetMap.put("cctr_code", rs.getString("cctr_code"));
                        ADetMap.put("exch_rate__vouch", rs.getDouble("exch_rate__vouch"));
                        ADetList.add(ADetMap);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"receipt Adv Map..........");
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)ADetMap.toString());
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    sql = "select ref_ser, ref_no,curr_code,exch_rate,amount,acct_code,cctr_code,sundry_type,sundry_code from rcpepc_adj where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        EpcAdjMap = new HashMap();
                        EpcAdjMap.put("ref_ser", rs.getString("ref_ser"));
                        EpcAdjMap.put("ref_no", rs.getString("ref_no"));
                        EpcAdjMap.put("curr_code", rs.getString("curr_code"));
                        EpcAdjMap.put("exch_rate", rs.getString("exch_rate"));
                        EpcAdjMap.put("amount", rs.getString("amount"));
                        EpcAdjMap.put("acct_code", rs.getString("acct_code"));
                        EpcAdjMap.put("cctr_code", rs.getString("cctr_code"));
                        EpcAdjMap.put("sundry_type", rs.getString("sundry_type"));
                        EpcAdjMap.put("sundry_code", rs.getString("sundry_code"));
                        EpcAdjList.add(EpcAdjMap);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" Rcpepc Adj Map..........3" + EpcAdjList));
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)EpcAdjList.toString());
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    sql = "select line_no__ref,ref_ser,ref_no,acct_code__ar,cctr_code__ar,exch_rate__rcv,rcp_amt,fin_chg,cust_code,bad_debt_amt,bill_disc_amt,exch_rate from rcpdet where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        RcpDetMap = new HashMap();
                        RcpDetMap.put("line_no__ref", rs.getString("line_no__ref"));
                        RcpDetMap.put("ref_ser", rs.getString("ref_ser"));
                        RcpDetMap.put("ref_no", rs.getString("ref_no"));
                        RcpDetMap.put("acct_code__ar", rs.getString("acct_code__ar"));
                        RcpDetMap.put("cctr_code__ar", rs.getString("cctr_code__ar") == null ? " " : rs.getString("cctr_code__ar"));
                        RcpDetMap.put("exch_rate__rcv", rs.getDouble("exch_rate__rcv"));
                        RcpDetMap.put("exch_rate", rs.getDouble("exch_rate"));
                        RcpDetMap.put("rcp_amt", rs.getDouble("rcp_amt"));
                        RcpDetMap.put("fin_chg", rs.getDouble("fin_chg"));
                        RcpDetMap.put("cust_code", rs.getString("cust_code"));
                        RcpDetMap.put("bad_debt_amt", rs.getDouble("bad_debt_amt"));
                        RcpDetMap.put("bill_disc_amt", rs.getDouble("bill_disc_amt"));
                        RcpDetList.add(RcpDetMap);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Manoharan 05-Mar-2021  RcpDetList [" + RcpDetList.toString() + "]"));
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" [" + RcpDetMap.toString() + "]"));
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Manoharan 22-Mar-2021  RcpDetList [" + RcpDetList.toString() + "]"));
                    i = 0;
                    while (i < RcpDetList.size()) {
                        RcpDetMap = (HashMap)RcpDetList.get(i);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Manoharan 22-Mar-2021  RcpDetMap [" + RcpDetMap.toString() + "]"));
                        if (!((String)RcpDetMap.get("ref_ser")).equals("M-INV")) {
                            tFin += Double.parseDouble("" + RcpDetMap.get("fin_chg"));
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LINE NO 541" + (total += Double.parseDouble("" + RcpDetMap.get("rcp_amt")) * Double.parseDouble("" + RcpDetMap.get("exch_rate")) / Double.parseDouble("" + RcpHdrMap.get("exch_rate")))));
                            if (rcpClubPost.equals("Y") && DetList.size() > 0) {
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("manohar why detail list contains acct_code__ar instead of acct_code [" + DetList + "] acct_code__ar [" + RcpDetMap.get("acct_code__ar") + "]"));
                                findIndex = this.findExistingIndex(DetList, (String)RcpDetMap.get("acct_code__ar"), (String)RcpDetMap.get("cctr_code__ar"), Double.parseDouble("" + RcpDetMap.get("exch_rate__rcv")), (String)RcpDetMap.get("cust_code"));
                            } else {
                                findIndex = -1;
                            }
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("findIndex>>>>>>>>>>>>>>>>>>>>>>>>>>>>773" + findIndex));
                            if (findIndex > -1) {
                                detMap = (HashMap)DetList.get(findIndex);
                                amountMap = Double.parseDouble("" + detMap.get("amount"));
                                detAmount = Double.parseDouble("" + RcpDetMap.get("rcp_amt"));
                                detMap.put("amount", amountMap + detAmount);
                                DetList.set(findIndex, detMap);
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("amount>>>>>>>>>>>>>>>>>>>>>>>>>>>>781" + (amountMap + detAmount)));
                            } else {
                                detMap = new HashMap();
                                detMap.put("sundry_type", "C");
                                detMap.put("sundry_code", (String)RcpDetMap.get("cust_code"));
                                detMap.put("acct_code", (String)RcpDetMap.get("acct_code__ar"));
                                detMap.put("cctr_code", (String)RcpDetMap.get("cctr_code__ar"));
                                detMap.put("emp_code", null);
                                detMap.put("anal_code", null);
                                detMap.put("exch_rate", Double.parseDouble("" + RcpDetMap.get("exch_rate__rcv")));
                                detMap.put("amount", Double.parseDouble("" + RcpDetMap.get("rcp_amt")));
                                partyDocRef = finCommon.gfGetPartyDocRef((String)RcpDetMap.get("ref_ser"), (String)RcpDetMap.get("ref_no"), conn);
                                detMap.put("party_doc_ref", partyDocRef);
                                detMap.put("effect_party", "Y");
                                detMap.put("eff_bank", "Y");
                                DetList.add(detMap);
                            }
                        }
                        ++i;
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList*****************************811******************" + DetList.toString()));
                    total = 0.0;
                    i = 0;
                    while (i < RcpDetList.size()) {
                        RcpDetMap = (HashMap)RcpDetList.get(i);
                        refSer = (String)RcpDetMap.get("ref_ser");
                        refNo = (String)RcpDetMap.get("ref_no");
                        hExchRate = Double.parseDouble("" + RcpDetMap.get("exch_rate"));
                        lineNoRef = (String)RcpDetMap.get("line_no__ref");
                        if (refSer.trim().equalsIgnoreCase("S-INV") || refSer.startsWith("R-IBC")) {
                            sql = "select receivables.bill_disc from receivables where tran_ser = ? and ref_no = ? and line_no__ref = ?";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, refSer);
                            pstmt.setString(2, refNo);
                            pstmt.setString(3, lineNoRef);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                billDisc = rs.getString(1) == null ? "N" : rs.getString(1);
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        if (billDisc.equalsIgnoreCase("Y")) {
                            sql = "SELECT export_fund.acct_code__ar, export_fund.cctr_code__ar, export_fund.exch_rate, sundry_type,sundry_code  FROM \texport_fund,    export_fundet   WHERE ( export_fund.tran_id = export_fundet.tran_id ) and  \t( export_fund.confirmed \t= 'Y') and( ( export_fundet.ref_ser \t= ? ) and   ( export_fundet.ref_no \t\t= ? ) )";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, refSer);
                            pstmt.setString(2, refNo);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                acct = rs.getString(1);
                                cctr = rs.getString(2) == null ? "" : rs.getString(2);
                                exch = rs.getDouble(3);
                                stype = rs.getString(4);
                                scode = rs.getString(5);
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                            rcpAmt = Double.parseDouble("" + RcpDetMap.get("bill_disc_amt"));
                            totbdDiff = totbdDiff + rcpAmt * hExchRate - rcpAmt * exch;
                            rcpAmt = -1.0 * Double.parseDouble("" + RcpDetMap.get("bill_disc_amt"));
                            finChg = -1.0 * Double.parseDouble("" + RcpDetMap.get("fin_chg"));
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("total in 666" + (total += rcpAmt)));
                            tFin += finChg;
                            if (rcpAmt != 0.0) {
                                findIndex = rcpClubPost.equals("Y") ? this.findExistingIndex(DetList, acct, cctr, exch, scode) : -1;
                                if (findIndex > -1) {
                                    detMap = (HashMap)DetList.get(findIndex);
                                    amountMap = Double.parseDouble("" + detMap.get("amount"));
                                    detMap.put("amount", amountMap + rcpAmt);
                                    DetList.set(findIndex, detMap);
                                } else {
                                    detMap = new HashMap();
                                    detMap.put("sundry_type", stype);
                                    detMap.put("sundry_code", scode);
                                    detMap.put("acct_code", acct);
                                    detMap.put("cctr_code", cctr);
                                    detMap.put("emp_code", null);
                                    detMap.put("anal_code", null);
                                    detMap.put("exch_rate", exch);
                                    detMap.put("amount", rcpAmt);
                                    detMap.put("party_doc_ref", null);
                                    detMap.put("effect_party", "N");
                                    detMap.put("eff_bank", "Y");
                                    DetList.add(detMap);
                                }
                            }
                        }
                        ++i;
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList*****************984******************************" + DetList.toString()));
                    i = 0;
                    while (i < ADetList.size()) {
                        ADetMap = (HashMap)ADetList.get(i);
                        acct = (String)ADetMap.get("acct_code");
                        cctr = (String)ADetMap.get("cctr_code");
                        exch = Double.parseDouble("" + ADetMap.get("exch_rate__vouch"));
                        amount = Double.parseDouble("" + ADetMap.get("adj_amt"));
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LINE NO 743" + (total += amount)));
                        findIndex = rcpClubPost.equals("Y") ? this.findExistingIndex(DetList, acct, cctr, exch) : -1;
                        if (findIndex > -1) {
                            detMap = (HashMap)DetList.get(findIndex);
                            amountMap = Double.parseDouble("" + detMap.get("amount"));
                            detMap.put("amount", amountMap + amount);
                            DetList.set(findIndex, detMap);
                        } else {
                            detMap = new HashMap();
                            detMap.put("sundry_type", "C");
                            detMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
                            detMap.put("acct_code", acct);
                            detMap.put("cctr_code", cctr);
                            detMap.put("emp_code", null);
                            detMap.put("anal_code", null);
                            detMap.put("exch_rate", exch);
                            detMap.put("amount", amount);
                            detMap.put("party_doc_ref", null);
                            detMap.put("effect_party", "Y");
                            detMap.put("eff_bank", "Y");
                            DetList.add(detMap);
                        }
                        ++i;
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList****************************1102*******************" + DetList.toString()));
                    if (tFin != 0.0) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LINE NO 812" + (total += tFin)));
                        acct = acctFin == null ? "" : acctFin;
                        cctr = cctrFin;
                        exch = Double.parseDouble("" + RcpHdrMap.get("exch_rate"));
                        detMap = new HashMap();
                        detMap.put("sundry_type", "O");
                        detMap.put("sundry_code", null);
                        detMap.put("acct_code", acct);
                        detMap.put("cctr_code", cctr);
                        detMap.put("emp_code", null);
                        detMap.put("anal_code", null);
                        detMap.put("exch_rate", exch);
                        detMap.put("amount", tFin);
                        detMap.put("party_doc_ref", null);
                        detMap.put("effect_party", "N");
                        detMap.put("eff_bank", "Y");
                        DetList.add(detMap);
                        detMap = new HashMap();
                        detMap.put("sundry_type", "C");
                        detMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
                        detMap.put("acct_code", acctFins);
                        detMap.put("cctr_code", cctrFins);
                        detMap.put("emp_code", null);
                        detMap.put("anal_code", null);
                        detMap.put("exch_rate", exch);
                        detMap.put("amount", tFin);
                        detMap.put("party_doc_ref", null);
                        detMap.put("effect_party", "Y");
                        detMap.put("eff_bank", "Y");
                        DetList.add(detMap);
                        detMap = new HashMap();
                        detMap.put("sundry_type", "C");
                        detMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
                        detMap.put("acct_code", acctFins);
                        detMap.put("cctr_code", cctrFins);
                        detMap.put("emp_code", null);
                        detMap.put("anal_code", null);
                        detMap.put("exch_rate", exch);
                        detMap.put("amount", -1.0 * tFin);
                        detMap.put("party_doc_ref", null);
                        detMap.put("effect_party", "Y");
                        detMap.put("eff_bank", "Y");
                        DetList.add(detMap);
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList**************************1231*********************" + DetList.toString()));
                    advAmt = Double.parseDouble("" + RcpHdrMap.get("adv_amt"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ADVAMT*********" + advAmt));
                    if (advAmt != 0.0) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LINE NO 874" + (total += advAmt)));
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("total in adv" + total));
                        acct = (String)RcpHdrMap.get("acct_code__adv") == null ? "" : (String)RcpHdrMap.get("acct_code__adv");
                        cctr = (String)RcpHdrMap.get("cctr_code__adv") == null ? " " : (String)RcpHdrMap.get("cctr_code__adv");
                        exch = Double.parseDouble("" + RcpHdrMap.get("exch_rate"));
                        if (rcpClubPost.equals("Y")) {
                            findIndex = this.findExistingIndex(DetList, acct, cctr, exch);
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("FINDINDEX>>>>>>>1243>>>>>" + findIndex));
                        } else {
                            findIndex = -1;
                        }
                        sql = "select sum(amount*exch_rate/?) from rcpacct where tran_id=? and eff_bank='N'";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setDouble(1, exch);
                        pstmt.setString(2, tranId);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            amtNoBankEffect = rs.getDouble(1);
                        }
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("total in adv" + amtNoBankEffect));
                        if (findIndex > -1) {
                            detMap = (HashMap)DetList.get(findIndex);
                            amountMap = Double.parseDouble("" + detMap.get("amount"));
                            detMap.put("amount", amountMap + advAmt);
                            DetList.set(findIndex, detMap);
                        } else {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Into Else part of findIndex > -1>>>>");
                            detMap = new HashMap();
                            detMap.put("sundry_type", "C");
                            detMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
                            detMap.put("acct_code", acct);
                            detMap.put("cctr_code", cctr);
                            detMap.put("emp_code", null);
                            detMap.put("anal_code", null);
                            detMap.put("exch_rate", exch);
                            detMap.put("amount", advAmt - amtNoBankEffect);
                            detMap.put("party_doc_ref", null);
                            detMap.put("effect_party", "Y");
                            detMap.put("eff_bank", "Y");
                            DetList.add(detMap);
                        }
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("1273---DetList.toString()----" + DetList.toString()));
                    }
                    i = 0;
                    while (i < EpcAdjList.size()) {
                        EpcAdjMap = (HashMap)EpcAdjList.get(i);
                        currCode = (String)EpcAdjMap.get("curr_code");
                        acctCode = (String)EpcAdjMap.get("acct_code");
                        cctrCode = (String)EpcAdjMap.get("cctr_code") == null ? " " : (String)EpcAdjMap.get("cctr_code");
                        exchRate = Double.parseDouble("" + EpcAdjMap.get("exch_rate"));
                        amount = Double.parseDouble("" + EpcAdjMap.get("amount"));
                        sundryType = (String)EpcAdjMap.get("sundry_type");
                        sundryCode = (String)EpcAdjMap.get("sundry_code");
                        hcurrCode = (String)RcpHdrMap.get("curr_code");
                        totEpc += amount;
                        if (!currCode.trim().equalsIgnoreCase(hcurrCode.trim())) {
                            isEpcCurrSame = false;
                            totEpcBc += exchRate * amount;
                        } else {
                            isEpcCurrSame = true;
                            totEpcBc += hexchRate * amount;
                        }
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("epccurrsame value:::" + isEpcCurrSame));
                        findIndex = rcpClubPost.equals("Y") ? this.findExistingIndex(DetList, acctCode, cctrCode, exchRate) : -1;
                        if (findIndex > -1) {
                            detMap = (HashMap)DetList.get(findIndex);
                            amountMap = Double.parseDouble("" + detMap.get("amount"));
                            detMap.put("amount", amountMap + amount);
                            DetList.set(findIndex, detMap);
                        } else {
                            detMap = new HashMap();
                            detMap.put("sundry_type", sundryType);
                            detMap.put("sundry_code", sundryCode);
                            detMap.put("acct_code", acctCode);
                            detMap.put("cctr_code", cctrCode);
                            detMap.put("emp_code", null);
                            detMap.put("anal_code", null);
                            detMap.put("exch_rate", exchRate);
                            detMap.put("amount", amount);
                            detMap.put("party_doc_ref", null);
                            detMap.put("effect_party", "N");
                            detMap.put("eff_bank", "Y");
                            DetList.add(detMap);
                        }
                        ++i;
                    }
                    finEntity = (String)RcpHdrMap.get("fin_entity");
                    sql = "select curr_code from finent  where fin_entity = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, finEntity);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        currCode = rs.getString("curr_code");
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    acct = (String)RcpHdrMap.get("acct_code__ar");
                    cctr = (String)RcpHdrMap.get("cctr_code__ar");
                    stype = "C";
                    exchRate = 1.0;
                    amount = diffAmtExch;
                    sql = "SELECT diff_amt__exch FROM RCPADVBKING_ADJ where tran_id  = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        diffAmtExch = rs.getDouble("diff_amt__exch");
                        findIndex = rcpClubPost.equals("Y") ? this.findExistingIndex(DetList, acct, cctr, exchRate) : -1;
                        if (findIndex > -1) {
                            detMap = (HashMap)DetList.get(findIndex);
                            amountMap = Double.parseDouble("" + detMap.get("amount"));
                            detMap.put("amount", amountMap + diffAmtExch);
                            DetList.set(findIndex, detMap);
                            continue;
                        }
                        detMap = new HashMap();
                        detMap.put("sundry_type", stype);
                        detMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
                        detMap.put("acct_code", acct);
                        detMap.put("cctr_code", cctr);
                        detMap.put("emp_code", null);
                        detMap.put("anal_code", null);
                        detMap.put("exch_rate", exchRate);
                        detMap.put("amount", diffAmtExch);
                        detMap.put("party_doc_ref", null);
                        detMap.put("effect_party", "N");
                        detMap.put("eff_bank", "Y");
                        DetList.add(detMap);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    double totBad = 0.0;
                    i = 0;
                    while (i < RcpDetList.size()) {
                        RcpDetMap = (HashMap)RcpDetList.get(i);
                        refSer = (String)RcpDetMap.get("ref_ser");
                        refNo = (String)RcpDetMap.get("ref_no");
                        rcpAmt = Double.parseDouble("" + RcpDetMap.get("rcp_amt"));
                        badDebtAmt = Double.parseDouble("" + RcpDetMap.get("bad_debt_amt"));
                        lineNoRef = (String)RcpDetMap.get("line_no__ref");
                        sql = "select case when bad_debt_amt is null then 0 else bad_debt_amt end, exch_rate from receivables where tran_ser = ? and ref_no = ? and line_no__ref = ?";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, refSer);
                        pstmt.setString(2, refNo);
                        pstmt.setString(3, lineNoRef);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            badDebtAmt = rs.getDouble(1);
                            exchRate = rs.getDouble("exch_rate");
                        }
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("badDebtAmt>>>>>>1642>>>>>>>" + badDebtAmt + " lineNoRef---[" + lineNoRef));
                        if (badDebtAmt > 0.0) {
                            sql = "select tran_id, acct_code__dr,cctr_code__dr, acct_code__cr, cctr_code__cr, amt_prov, case when amt_revrsed is null then 0 else amt_revrsed end from bad_debts_prov where tran_ser = ? and ref_no = ? and amt_prov <> 0 order by tran_date";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, refSer);
                            pstmt.setString(2, refNo);
                            pstmt.setString(3, lineNoRef);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                tranId = rs.getString("tran_id");
                                acctCode = rs.getString("acct_code__dr");
                                cctrCodeDr = rs.getString("cctr_code__dr") == null ? " " : rs.getString("cctr_code__dr");
                                acctCodeCr = rs.getString("acct_code__cr");
                                cctrCodeCr = rs.getString("cctr_code__cr") == null ? " " : rs.getString("cctr_code__cr");
                                amtProv = rs.getDouble("amt_prov");
                                amtRevrsed = rs.getDouble("amt_revrsed");
                                amtRev = Math.min(badDebtAmt, amtProv);
                                totBad += amtRev;
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LINE NO 1164" + total));
                                findIndex = rcpClubPost.equals("Y") ? this.findExistingIndex(DetList, acctCodeDr, cctrCodeDr, exchRate) : -1;
                                if (findIndex > -1) {
                                    detMap = (HashMap)DetList.get(findIndex);
                                    amountMap = Double.parseDouble("" + detMap.get("amount"));
                                    detMap.put("amount", amountMap + amtRev * -1.0);
                                    DetList.set(findIndex, detMap);
                                } else {
                                    detMap = new HashMap();
                                    detMap.put("sundry_type", "O");
                                    detMap.put("sundry_code", null);
                                    detMap.put("acct_code", acctCodeDr);
                                    detMap.put("cctr_code", cctrCodeDr);
                                    detMap.put("emp_code", null);
                                    detMap.put("anal_code", null);
                                    detMap.put("exch_rate", exchRate);
                                    detMap.put("amount", amtRev * -1.0);
                                    detMap.put("party_doc_ref", null);
                                    detMap.put("effect_party", "N");
                                    detMap.put("eff_bank", "Y");
                                    DetList.add(detMap);
                                }
                                findIndex = rcpClubPost.equals("Y") ? this.findExistingIndex(DetList, acctCodeCr, cctrCodeCr, exchRate) : -1;
                                if (findIndex > -1) {
                                    detMap = (HashMap)DetList.get(findIndex);
                                    amountMap = Double.parseDouble("" + detMap.get("amount"));
                                    detMap.put("amount", amountMap + amtRev);
                                    DetList.set(findIndex, detMap);
                                } else {
                                    detMap = new HashMap();
                                    detMap.put("sundry_type", "O");
                                    detMap.put("sundry_code", "");
                                    detMap.put("acct_code", acctCodeCr);
                                    detMap.put("cctr_code", cctrCodeCr);
                                    detMap.put("emp_code", "");
                                    detMap.put("anal_code", "");
                                    detMap.put("exch_rate", exchRate);
                                    detMap.put("amount", amtRev);
                                    detMap.put("party_doc_ref", "");
                                    detMap.put("effect_party", "N");
                                    detMap.put("eff_bank", "Y");
                                    DetList.add(detMap);
                                }
                                if (!isPreview) {
                                    sql = "update bad_debts_prov set amt_prov = amt_prov - ?, amt_revrsed = amt_revrsed + ?  where tran_id = ?";
                                    pstmt1 = conn.prepareStatement(sql);
                                    pstmt1.setDouble(1, amtRev);
                                    pstmt1.setDouble(2, amtRev);
                                    pstmt1.setString(3, tranId);
                                    pstmt1.executeUpdate();
                                    pstmt1.close();
                                    pstmt1 = null;
                                }
                                if ((badDebtAmt -= amtRev) == 0.0) break;
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        if (!isPreview) {
                            double totAmt = 0.0;
                            double adjAmtRcv = 0.0;
                            double badDebtAmtRcv = 0.0;
                            Object receivablesMap = null;
                            refSer = (String)RcpDetMap.get("ref_ser");
                            refNo = (String)RcpDetMap.get("ref_no");
                            lineNoRef = (String)RcpDetMap.get("line_no__ref");
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ref ser in det-[-" + refSer + "] refno---[" + refNo + " ]lineNoRef [" + lineNoRef));
                            sql = "select tot_amt, adj_amt, bad_debt_amt from receivables where TRAN_SER = ? AND REF_NO = ? and line_no__ref = ?";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, refSer);
                            pstmt.setString(2, refNo);
                            pstmt.setString(3, lineNoRef);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                totAmt = rs.getDouble("tot_amt");
                                adjAmtRcv = rs.getDouble("adj_amt");
                                badDebtAmtRcv = rs.getDouble("bad_debt_amt");
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                            sql = " update receivables set bad_debt_amt = bad_debt_amt - ? where  tran_ser = ? and ref_no = ?  and   line_no__ref = ?";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setDouble(1, totBad);
                            pstmt.setString(2, refser);
                            pstmt.setString(3, refNo);
                            pstmt.setString(4, lineNoRef);
                            pstmt.executeUpdate();
                            pstmt.close();
                            pstmt = null;
                            totBad = 0.0;
                        }
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("aaaaaaaaaaaa" + total));
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("BBBBBBBBBBB" + total));
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("CCCCCCCCCCCC" + total));
                        ++i;
                    }
                    exchRate = Double.parseDouble("" + RcpHdrMap.get("exch_rate"));
                    total = Double.parseDouble("" + RcpHdrMap.get("net_amt"));
                    totBc = Double.parseDouble("" + RcpHdrMap.get("net_amt__bc"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Final total [" + total + "] totBc [" + totBc + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("net_amt AND net_amt__bc 1 [" + total + "] tot bc[" + totBc));
                    if (bdFluctuationCf.equalsIgnoreCase("N")) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("bdFluctuationCf [" + bdFluctuationCf + "] totBc [" + (totBc += totbdDiff) + "]"));
                    }
                    if (isEpcCurrSame) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("total [" + total + "] totEpc [" + totEpc + "] totEpcBc [" + totEpcBc + "]isEpcCurrSame" + isEpcCurrSame));
                        totBc += totEpcBc;
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("total 222 [" + (total += totEpc) + "] totEpc [" + totEpc + "] totEpcBc [" + totEpcBc + "]isEpcCurrSame" + isEpcCurrSame));
                    } else {
                        totBc += totEpcBc;
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("total22321 [" + total + "] totEpc [" + totEpc + "] totEpcBc [" + totEpcBc + "]isEpcCurrSame" + isEpcCurrSame));
                    }
                    chq = Double.parseDouble("" + RcpHdrMap.get("chq_amt"));
                    taxAmt = Double.parseDouble("" + RcpHdrMap.get("tax_amt"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("before amount added with efund +++" + chq));
                    if (isEpcCurrSame) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("chq amt-->" + (chq += Double.parseDouble("" + RcpHdrMap.get("efundadj_amt")))));
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("chq and  [" + chq + "] total [" + total + "] diff [" + Math.abs(chq - total) + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("chq and  [" + chq + "] total [" + total + "] diff [" + Math.abs(chq - (total - taxAmt)) + "]"));
                    othAmt = Double.parseDouble("" + RcpHdrMap.get("oth_amt"));
                    billDiscountAmt = Double.parseDouble("" + RcpHdrMap.get("bill_disc_amt"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("bill discount amount and  [" + billDiscountAmt + "]  total::>>[" + total + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("manohar 04-dec-2019 net_amt  [" + total + "] net_amt__bc [" + totBc + "]"));
                    if (Double.parseDouble("" + RcpHdrMap.get("net_amt")) != 0.0 && Double.parseDouble("" + RcpHdrMap.get("chq_amt")) != 0.0) {
                        if (total > 0.0) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("chq and  [" + (chq -= billDiscountAmt) + "] total [" + total + "] other_amount ]" + othAmt + " ] diff [" + Math.abs(chq + (total - taxAmt) + othAmt) + "]"));
                        } else {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("chq and  [" + (chq -= billDiscountAmt) + "] total [" + total + "] other_amount ]" + othAmt + " ] diff [" + Math.abs(chq + (total - taxAmt) + othAmt) + "]"));
                        }
                    }
                    RcpHdrMap.put("net_amt", total);
                    RcpHdrMap.put("net_amt__bc", totBc);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("net_amt  [" + total + "] net_amt__bc [" + totBc + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("manohar 04-dec-2019 size  [" + DetList.size() + "] list [" + DetList.toString() + "]"));
                    sql = "select max(line_no) from rcpacct where  tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        maxline = rs.getInt(1);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Max Line>>>" + maxline));
                    if (!isPreview) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" >>>>>>>>>>>>>" + isPreview));
                        sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
                        pstmt = conn.prepareStatement(sql);
                        i = detListSize;
                        while (i < DetList.size()) {
                            ++maxline;
                            detMap = (HashMap)DetList.get(i);
                            sundryType = (String)detMap.get("sundry_type");
                            sundryCode = (String)detMap.get("sundry_code");
                            acctCode = (String)detMap.get("acct_code");
                            cctrCode = (String)detMap.get("cctr_code");
                            empCode = (String)detMap.get("emp_code");
                            analCode = (String)detMap.get("anal_code");
                            effectParty = (String)detMap.get("effect_party");
                            if (effectParty == null || "null".equals(effectParty)) {
                                effectParty = "N";
                            }
                            if (sundryType == null || "O".equals(sundryType)) {
                                effectParty = "N";
                            }
                            if (!(sundryType == null || "null".equals(sundryType) || "O".equals(sundryType) || sundryCode == null || "null".equals(sundryCode) || sundryCode.trim().length() <= 0)) {
                                effectParty = "Y";
                            }
                            exchRate = Double.parseDouble("" + detMap.get("exch_rate"));
                            amount = Double.parseDouble("" + detMap.get("amount"));
                            pstmt.setString(1, tranId);
                            pstmt.setInt(2, maxline);
                            pstmt.setString(3, acctCode);
                            pstmt.setString(4, cctrCode == null ? "" : cctrCode);
                            pstmt.setDouble(5, exchRate);
                            pstmt.setDouble(6, amount);
                            pstmt.setString(7, empCode);
                            pstmt.setString(8, analCode);
                            pstmt.setString(9, effectParty);
                            pstmt.setString(10, sundryType);
                            pstmt.setString(11, sundryCode);
                            pstmt.addBatch();
                            pstmt.clearParameters();
                            ++i;
                        }
                        if (DetList.size() > 0) {
                            pstmt.executeBatch();
                        }
                        pstmt.close();
                        pstmt = null;
                    }
                    if (errString == null || errString.trim().length() == 0) {
                        errString = this.gbfPostReceipt(tranId, xtraParams, RcpHdrMap, DetList, RcpDetList, ADetList, EpcAdjList, amtNoBankEffect, conn, isPreview);
                    }
                    break block113;
                }
                catch (BatchUpdateException buex) {
                    isError = true;
                    errString = "ERROR";
                    try {
                        conn.rollback();
                        int[] updateCounts = buex.getUpdateCounts();
                        i = 0;
                        while (i < updateCounts.length) {
                            System.err.println("  Statement " + i + ":" + updateCounts[i]);
                            ++i;
                        }
                        System.err.println(" Message: " + buex.getMessage());
                        System.err.println(" SQLSTATE: " + buex.getSQLState());
                        System.err.println(" Error code: " + buex.getErrorCode());
                        SQLException ex = buex.getNextException();
                        while (ex != null) {
                            System.err.println("SQL exception:");
                            System.err.println(" Message: " + ex.getMessage());
                            System.err.println(" SQLSTATE: " + ex.getSQLState());
                            System.err.println(" Error code: " + ex.getErrorCode());
                            ex = ex.getNextException();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                throw new ITMException((Exception)buex);
                catch (Exception e) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return errString;
    }

    private int findExistingIndex(ArrayList detList, String acctCode, String cctrCode, double exchRate) throws RemoteException, ITMException {
        int findIndex = -1;
        HashMap detMap = null;
        String acctCodeMap = null;
        String cctrCodeMap = null;
        double exchRateMap = 0.0;
        try {
            int ctr = 0;
            while (ctr < detList.size()) {
                detMap = (HashMap)detList.get(ctr);
                acctCodeMap = this.checkNull((String)detMap.get("acct_code"));
                cctrCodeMap = this.checkNull((String)detMap.get("cctr_code"));
                exchRateMap = Double.parseDouble("" + detMap.get("exch_rate"));
                if (acctCodeMap.trim().equalsIgnoreCase(acctCode.trim()) && cctrCodeMap.trim().equalsIgnoreCase(cctrCode.trim()) && exchRateMap == exchRate) {
                    findIndex = ctr;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return findIndex;
    }

    private int findExistingIndex(ArrayList detList, String acctCodeR, String cctrCodeR, double exchRateR, String sundryCodeR) throws RemoteException, ITMException {
        int findIndex = -1;
        HashMap detMap = null;
        String acctCodeMap = null;
        String cctrCodeMap = null;
        String sundryCodeMap = null;
        double exchRateMap = 0.0;
        try {
            int ctr = 0;
            while (ctr < detList.size()) {
                detMap = (HashMap)detList.get(ctr);
                acctCodeMap = this.checkNull((String)detMap.get("acct_code"));
                cctrCodeMap = this.checkNull((String)detMap.get("cctr_code"));
                exchRateMap = Double.parseDouble("" + detMap.get("exch_rate"));
                sundryCodeMap = this.checkNull((String)detMap.get("sundry_code"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Sundry code136 >>>>>>>>>>> : " + sundryCodeMap));
                if (acctCodeMap.trim().equalsIgnoreCase(acctCodeR.trim()) && cctrCodeMap.trim().equalsIgnoreCase(cctrCodeR.trim()) && exchRateMap == exchRateR && sundryCodeMap.trim().equalsIgnoreCase(sundryCodeR.trim())) {
                    findIndex = ctr;
                    break;
                }
                ++ctr;
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Detail Mapp11111>>>>>>>>>>> : " + detList));
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return findIndex;
    }

    private String gbfPostReceipt(String tranId, String xtraParams, HashMap RcpHdrMap, ArrayList DDetList, ArrayList RcpDetList, ArrayList ADetList, ArrayList EpcAdjList, double amtNoBankEffect, Connection conn, boolean isPreview) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfPostReceipt Called..........");
        String errString = "";
        String ledgPostConf = "";
        String sql = "";
        String refNo = "";
        String commCalcOnOff = "";
        String confDrcrOpt = "";
        String confJvOpt = "";
        Object DetMap = null;
        ArrayList DetList = new ArrayList();
        double netAmount = 0.0;
        double amount = 0.0;
        double amountadvbking = 0.0;
        double debit = 0.0;
        double credit = 0.0;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        Object pstmt2 = null;
        Object rs2 = null;
        ResultSet rs = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        FinCommon finCommon = null;
        Object disCommon = null;
        int maxline = 0;
        String acctCode = "";
        String cctrCode = "";
        double exchRate = 0.0;
        String effectParty = "";
        String effectbank = "";
        String curr_code = "";
        double taxAmount = 0.0;
        try {
            itmDBAccessEJB = new ITMDBAccessEJB();
            finCommon = new FinCommon();
            errString = this.gbfPostRcphdr(tranId, xtraParams, RcpHdrMap, DDetList, amtNoBankEffect, conn, isPreview);
            if (errString != null && errString.trim().length() > 0) {
                return errString;
            }
            errString = this.gbfPostRcpdet(tranId, xtraParams, RcpHdrMap, DDetList, RcpDetList, ADetList, EpcAdjList, conn, isPreview);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString while posting rcpdet......................" + errString));
            if (errString != null && errString.trim().length() > 0) {
                return errString;
            }
            sql = "select max(line_no) from rcpacct where  tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxline = rs.getInt(1);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Max Line:--" + maxline));
            sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,AMOUNT,EXCH_RATE,EFFECT_PARTY,AMOUNT__BC,EFF_BANK,CURR_CODE) values (?,?,?,?,?,?,?,?,?,?)";
            pstmt1 = conn.prepareStatement(sql);
            sql = " select ACCT_CODE,CCTR_CODE, case when sum(tax_amt) is null then 0 else sum(tax_amt) end as taxAmt  from taxtran where tran_code= ? and  tran_id\t= ? and tax_amt <> 0 and effect <> 'N' group by acct_code,cctr_code";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, "RCP");
            pstmt.setString(2, tranId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ++maxline;
                amount = rs.getDouble("taxAmt");
                acctCode = rs.getString("acct_code");
                cctrCode = rs.getString("cctr_code");
                effectParty = "N";
                effectbank = "Y";
                exchRate = Double.parseDouble("" + RcpHdrMap.get("exch_rate"));
                curr_code = (String)RcpHdrMap.get("curr_code");
                pstmt1.setString(1, tranId);
                pstmt1.setInt(2, maxline);
                pstmt1.setString(3, acctCode);
                pstmt1.setString(4, cctrCode == null ? "" : cctrCode);
                pstmt1.setDouble(5, amount);
                pstmt1.setDouble(6, exchRate);
                pstmt1.setString(7, effectParty);
                pstmt1.setDouble(8, amount);
                pstmt1.setString(9, effectbank);
                pstmt1.setString(10, curr_code);
                pstmt1.addBatch();
                pstmt1.clearParameters();
            }
            pstmt1.executeBatch();
            rs.close();
            rs = null;
            pstmt1.close();
            pstmt1 = null;
            pstmt.close();
            pstmt = null;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("netAmountBc+taxAmt amount --------->" + netAmount));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("netAmountBc+taxAmt amount --------->" + amount));
            if (!isPreview) {
                sql = "SELECT ref_no , amount FROM  rcpadvbking_adj  WHERE  tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    refNo = rs.getString(1);
                    amount = rs.getDouble(2);
                    if (amount < 0.0) {
                        amount = -amount;
                    }
                    if (amount > 0.0) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("advbking amount=[" + amount + "]"));
                        sql = "update advbking set bal_amt = (case when bal_amt is null then 0 else bal_amt end -?)  where tran_id = ?";
                        pstmt1 = conn.prepareStatement(sql);
                        pstmt1.setDouble(1, amount);
                        pstmt1.setString(2, refNo);
                        pstmt1.executeUpdate();
                        pstmt1.close();
                        pstmt1 = null;
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"balamount in advbking=[");
                    }
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                sql = "SELECT ref_no , amount FROM  rcpepc_adj  WHERE rcpepc_adj.tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    refNo = rs.getString(1);
                    amount = rs.getDouble(2);
                    if (amount < 0.0) {
                        amount = -amount;
                    }
                    if (amount > 0.0) {
                        sql = "update advbking set bal_amt = bal_amt - ? where tran_id  = ?";
                        pstmt1 = conn.prepareStatement(sql);
                        pstmt1.setDouble(1, amountadvbking);
                        pstmt1.setString(2, refNo);
                        pstmt1.executeUpdate();
                        pstmt1.close();
                        pstmt1 = null;
                    }
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (errString == null || errString.trim().length() == 0) {
                    errString = finCommon.checkGlTranDrCr("RCP", tranId, conn);
                }
                if (errString != null && errString.trim().length() > 0) {
                    return errString;
                }
                commCalcOnOff = finCommon.getFinparams("999999", "COMM_CALC_ON_OFF", conn);
                if (commCalcOnOff.equalsIgnoreCase("Y")) {
                    confDrcrOpt = finCommon.getFinparams("999999", "COMM_DRCR_CONF", conn);
                    confJvOpt = finCommon.getFinparams("999999", "COMM_JV_CONF", conn);
                    CalculateCommission calCommission = new CalculateCommission();
                    errString = calCommission.CalCommission("", "R", tranId, confDrcrOpt, confJvOpt, xtraParams, conn);
                    return errString;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    private String gbfPostRcphdr(String tranId, String xtraParams, HashMap RcpHdrMap, ArrayList RcpDetList, double amtNoBankEffect, Connection conn, boolean isPreview) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfPostRcphdr called........");
        String errString = "";
        String currCode = "";
        String siteCode = "";
        String siteCodeFor = "";
        String finEntity = "";
        String acctCode = "";
        String cctrCode = "";
        String acctCodePay = "";
        String cctrCodePay = "";
        String acctCodeAr = "";
        String cctrCodeAr = "";
        String projectCode = "";
        String analCode = "";
        String bankCode = "";
        String remarks = "";
        String sundryType = "";
        String sundryCode = "";
        String sundryTypeFor = "";
        String sundryCodeFor = "";
        String contactCode = "";
        String empCode = "";
        String refNO = "";
        String rcpMode = "";
        String batchNo = "";
        String tranType = "";
        String confirm = "";
        String loginEmpCode = "";
        String winName = "";
        String editOption = "";
        String confirmed = "";
        String sql = "";
        String errorType = "";
        String bdFluctuationCf = "";
        String acctCodeBal = "";
        String cctrCodeBal = "";
        String basecurrCode = "";
        String projCode = "";
        String custCode = "";
        String salesPers = "";
        String refSer = "";
        String refNo = "";
        String acctCodeCf = "";
        String payslip = "";
        boolean isInBaseCurr = false;
        boolean count = false;
        int cnt1 = 0;
        int cnt = 0;
        double exchRate = 0.0;
        double netAmount = 0.0;
        double amount = 0.0;
        double advAmt = 0.0;
        double netAmt = 0.0;
        double chqAmt = 0.0;
        double debit = 0.0;
        double credit = 0.0;
        double totAmt = 0.0;
        double ediOption = 0.0;
        double netAmountBc = 0.0;
        double taxAmt = 0.0;
        double allocAmt = 0.0;
        int allocCount = 0;
        String tranIdRcp = "";
        String lineNoRef = "";
        double rcpAmt = 0.0;
        HashMap RcpDetMap = null;
        ArrayList<HashMap> RcpDetailList = new ArrayList<HashMap>();
        Object rs1 = null;
        Object rs2 = null;
        Vector getdetAcct = new Vector();
        HashMap validReasonCd = new HashMap();
        Object discountDate = null;
        Object pstmt1 = null;
        Object pstmt2 = null;
        Object sqlUpdate = null;
        Object sql2 = null;
        String miscCrTranId = "";
        String miscDrTranId = "";
        String refSerDet = "";
        String refNoDet = "";
        String refNoCust = "";
        boolean lineNo = false;
        boolean rowCnt = false;
        double rcpAmtDet = 0.0;
        Double diff = 0.0;
        double outstandAmt = 0.0;
        String crTerm = "";
        String forcedFlag = "";
        String tranIdRcpForm = "";
        java.util.Date effDate = null;
        java.util.Date tranDate = null;
        java.util.Date refDate = null;
        HashMap detListMap = null;
        HashMap<String, Object> glTraceMap = null;
        HashMap<String, Object> sundryBalMap = null;
        HashMap<String, Object> bankTranLogMap = null;
        HashMap<String, Object> receivablesMap = null;
        Object epcadjMap = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        ValidatorEJB validatorEJB = new ValidatorEJB();
        ITMDBAccessEJB itmDBAccessEJB = null;
        String chgTermstr = "";
        try {
            finCommon = new FinCommon();
            loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            chgTermstr = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
            Date today = new Date(new java.util.Date().getTime());
            itmDBAccessEJB = new ITMDBAccessEJB();
            bdFluctuationCf = finCommon.getFinparams("999999", "BD_FLUCTUATION_CF", conn);
            if (bdFluctuationCf.equalsIgnoreCase("NULLFOUND")) {
                errString = itmDBAccessEJB.getErrorString("", "VTFINPARM", "", "", conn);
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("net_amt AND net_amt__bc 1" + RcpHdrMap.get("net_amt") + RcpHdrMap.get("net_amt__bc")));
            tranId = (String)RcpHdrMap.get("tran_id");
            tranType = (String)RcpHdrMap.get("tran_type");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" RECECEIVABLE  jv map ---> net_amt[" + RcpHdrMap));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" RECECEIVABLE  jv ---> net_amt[" + RcpHdrMap.get("net_amt") + "] chq_amount [" + RcpHdrMap.get("chq_amt") + " ] adv amount [" + RcpHdrMap.get("adv_amt") + "] tran_type [" + tranType + " ]"));
            if ("J".equalsIgnoreCase(tranType.trim()) && (Double.parseDouble("" + RcpHdrMap.get("adv_amt")) != 0.0 || Double.parseDouble("" + RcpHdrMap.get("chq_amt")) != 0.0 || Double.parseDouble("" + RcpHdrMap.get("net_amt")) != 0.0)) {
                errString = itmDBAccessEJB.getErrorString("", "VTRCPJVAMT", "", "", conn);
                return errString;
            }
            if (Double.parseDouble("" + RcpHdrMap.get("bill_amt")) == 0.0 && Double.parseDouble("" + RcpHdrMap.get("adv_amt")) == 0.0 && Double.parseDouble("" + RcpHdrMap.get("net_amt")) != 0.0) {
                errString = itmDBAccessEJB.getErrorString("", "VTRCPT11", "", "", conn);
                return errString;
            }
            tranId = (String)RcpHdrMap.get("tran_id");
            sql = " SELECT count(*) FROM rcpepc_adj,receipt  WHERE ( rcpepc_adj.tran_id = receipt.tran_id ) and   ( rcpepc_adj.curr_code <> receipt.curr_code ) and   ( ( receipt.tran_id = ? ) ) ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                cnt = rs.getInt(1);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            sql = " SELECT count(*) FROM rcpacct,receipt  WHERE ( rcpacct.tran_id = receipt.tran_id ) and  ( rcpacct.curr_code <> receipt.curr_code ) and  ( ( receipt.tran_id = ? ) )";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                cnt1 = rs.getInt(1);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (Double.parseDouble("" + RcpHdrMap.get("efundadj_amt")) != 0.0 && cnt > 0) {
                isInBaseCurr = true;
            }
            if (Double.parseDouble("" + RcpHdrMap.get("oth_amt")) != 0.0 && cnt1 > 0) {
                isInBaseCurr = true;
            }
            if (Double.parseDouble("" + RcpHdrMap.get("bill_disc_amt")) != 0.0 && bdFluctuationCf.equalsIgnoreCase("N")) {
                isInBaseCurr = true;
            }
            finEntity = (String)RcpHdrMap.get("fin_entity");
            sql = "SELECT finent.curr_code  FROM finent WHERE finent.fin_entity = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, finEntity);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                basecurrCode = rs.getString(1);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            analCode = (String)RcpHdrMap.get("anal_code");
            tranDate = (java.util.Date)RcpHdrMap.get("tran_date");
            refDate = (java.util.Date)RcpHdrMap.get("ref_date");
            effDate = (java.util.Date)RcpHdrMap.get("eff_date");
            remarks = (String)RcpHdrMap.get("remarks");
            finEntity = (String)RcpHdrMap.get("fin_entity");
            siteCode = (String)RcpHdrMap.get("site_code");
            bankCode = (String)RcpHdrMap.get("bank_code");
            acctCodeBal = (String)RcpHdrMap.get("acct_code__bal");
            cctrCodeBal = (String)RcpHdrMap.get("cctr_code__bal");
            netAmt = Double.parseDouble("" + RcpHdrMap.get("net_amt"));
            currCode = (String)RcpHdrMap.get("curr_code");
            exchRate = Double.parseDouble("" + RcpHdrMap.get("exch_rate"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("exchange_rate in diff hdr" + exchRate));
            projCode = (String)RcpHdrMap.get("proj_code");
            projCode = (String)RcpHdrMap.get("proj_code");
            refNO = (String)RcpHdrMap.get("ref_no");
            chqAmt = Double.parseDouble("" + RcpHdrMap.get("chq_amt"));
            custCode = (String)RcpHdrMap.get("cust_code");
            netAmountBc = Double.parseDouble("" + RcpHdrMap.get("net_amt__bc"));
            acctCodeCf = (String)RcpHdrMap.get("acct_code__cf");
            rcpMode = (String)RcpHdrMap.get("rcp_mode");
            acctCode = (String)RcpHdrMap.get("acct_code__adv");
            cctrCode = (String)RcpHdrMap.get("cctr_code__adv");
            sql = " select case when sum(tax_amt) is null then 0 else sum(tax_amt) end as taxAmt  from taxtran where tran_code= ? and  tran_id\t= ? and tax_amt <> 0 and effect <> 'N' ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, "RCP");
            pstmt.setString(2, tranId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                taxAmt += rs.getDouble("taxAmt");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("netAmountBc+taxAmt amount --------->" + netAmountBc));
            int ctr = 0;
            while (ctr < RcpDetList.size()) {
                detListMap = new HashMap();
                detListMap = (HashMap)RcpDetList.get(ctr);
                cctrCodeAr = (String)detListMap.get("cctr_code__ar");
                ++ctr;
            }
            glTraceMap = new HashMap<String, Object>();
            glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
            glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
            glTraceMap.put("fin_entity", finEntity);
            glTraceMap.put("site_code", siteCode);
            glTraceMap.put("sundry_type", "B");
            glTraceMap.put("sundry_code", bankCode);
            glTraceMap.put("acct_code", acctCodeBal);
            glTraceMap.put("cctr_code", cctrCodeBal);
            glTraceMap.put("emp_code", "");
            glTraceMap.put("anal_code", "");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("AMOUTTTTTTTTTTTTTTT" + (Double)RcpHdrMap.get("net_amt") + netAmountBc));
            if (isInBaseCurr) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"IN TRUE!!!!!!!!!!!!!!!!!");
                glTraceMap.put("curr_code", basecurrCode);
                glTraceMap.put("exch_rate", 1.0);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("NET AMOUNT BC..[" + RcpHdrMap.get("net_amt__bc")));
                if (netAmountBc < 0.0) {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", -1.0 * netAmountBc);
                } else {
                    glTraceMap.put("dr_amt", netAmountBc);
                    glTraceMap.put("cr_amt", 0.0);
                }
            } else {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"IN FALSE!!!!!!!!!!!!!!!!!");
                glTraceMap.put("curr_code", currCode);
                glTraceMap.put("exch_rate", exchRate);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("NET AMOUNT BC..[" + RcpHdrMap.get("net_amt")));
                if (netAmt < 0.0) {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", -1.0 * netAmt);
                } else {
                    glTraceMap.put("dr_amt", netAmt);
                    glTraceMap.put("cr_amt", 0.0);
                }
            }
            glTraceMap.put("ref_type", "F");
            glTraceMap.put("ref_ser", "RCP");
            glTraceMap.put("ref_id", tranId);
            glTraceMap.put("remarks", remarks);
            glTraceMap.put("proj_code", projectCode);
            glTraceMap.put("chg_date", new Timestamp(tranDate.getTime()));
            glTraceMap.put("chg_user", loginEmpCode);
            glTraceMap.put("chg_term", chgTermstr);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("1766 glTraceUpdate Called........isPreview value......" + isPreview));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("the vslue for CR AMT**********************" + glTraceMap.get("cr_amt")));
            errString = finCommon.glTraceUpdate(glTraceMap, conn, isPreview);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>" + errString));
            if (errString != null && errString.trim().length() > 0) {
                return errString;
            }
            debit += Double.parseDouble("" + glTraceMap.get("dr_amt")) * Double.parseDouble("" + glTraceMap.get("exch_rate"));
            credit += Double.parseDouble("" + glTraceMap.get("cr_amt")) * Double.parseDouble("" + glTraceMap.get("exch_rate"));
            sundryBalMap = new HashMap<String, Object>();
            sundryBalMap.put("tran_date", new Timestamp(tranDate.getTime()));
            sundryBalMap.put("eff_date", new Timestamp(effDate.getTime()));
            sundryBalMap.put("fin_entity", finEntity);
            sundryBalMap.put("site_code", siteCode);
            sundryBalMap.put("sundry_type", "B");
            sundryBalMap.put("sundry_code", bankCode);
            sundryBalMap.put("acct_code", acctCodeBal);
            sundryBalMap.put("cctr_code", cctrCodeBal);
            if (isInBaseCurr) {
                sundryBalMap.put("curr_code", basecurrCode);
                sundryBalMap.put("exch_rate", 1.0);
                StringBuilder stringBuilder = new StringBuilder();
                if (Double.parseDouble(stringBuilder.append(RcpHdrMap.get("net_amt__bc")).toString()) < 0.0) {
                    sundryBalMap.put("dr_amt", 0.0);
                    sundryBalMap.put("cr_amt", -1.0 * netAmountBc);
                } else {
                    sundryBalMap.put("dr_amt", netAmountBc);
                    sundryBalMap.put("cr_amt", 0.0);
                }
            } else {
                sundryBalMap.put("curr_code", currCode);
                sundryBalMap.put("exch_rate", exchRate);
                StringBuilder stringBuilder = new StringBuilder();
                if (Double.parseDouble(stringBuilder.append(RcpHdrMap.get("net_amt")).toString()) < 0.0) {
                    sundryBalMap.put("dr_amt", 0.0);
                    sundryBalMap.put("cr_amt", -1.0 * netAmt);
                } else {
                    sundryBalMap.put("dr_amt", netAmt);
                    sundryBalMap.put("cr_amt", 0.0);
                }
            }
            sundryBalMap.put("adv_amt", 0.0);
            sundryBalMap.put("contact_code", "");
            if (chqAmt != 0.0 || advAmt > 0.0) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"In 1826 SUNDRY-BAL !!!!!!!!!!!!!!!!!!!!!!!!!!");
                if (!isPreview) {
                    errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                }
            }
            if (errString != null && errString.trim().length() > 0) {
                return errString;
            }
            if (chqAmt != 0.0 && !isPreview) {
                bankTranLogMap = new HashMap<String, Object>();
                bankTranLogMap.put("tran_date", new Timestamp(tranDate.getTime()));
                bankTranLogMap.put("tran_ser", "RCP");
                bankTranLogMap.put("tran_no", tranId);
                bankTranLogMap.put("bank_code", bankCode);
                bankTranLogMap.put("ref_no", refNO);
                bankTranLogMap.put("ref_date", new Timestamp(refDate.getTime()));
                bankTranLogMap.put("ref_mode", rcpMode);
                if (isInBaseCurr) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("in base curr===>" + isInBaseCurr));
                    bankTranLogMap.put("curr_code", basecurrCode);
                    bankTranLogMap.put("exch_rate", 1.0);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (Double.parseDouble(stringBuilder.append(RcpHdrMap.get("net_amt__bc")).toString()) < 0.0) {
                        bankTranLogMap.put("amount", -1.0 * Double.parseDouble("" + RcpHdrMap.get("net_amt__bc")));
                        bankTranLogMap.put("tran_type", "P");
                    } else {
                        bankTranLogMap.put("amount", Double.parseDouble("" + RcpHdrMap.get("net_amt__bc")));
                        bankTranLogMap.put("tran_type", "R");
                    }
                } else {
                    bankTranLogMap.put("curr_code", currCode);
                    bankTranLogMap.put("exch_rate", exchRate);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (Double.parseDouble(stringBuilder.append(RcpHdrMap.get("net_amt")).toString()) < 0.0) {
                        bankTranLogMap.put("amount", -1.0 * netAmt);
                        bankTranLogMap.put("tran_type", "P");
                    } else {
                        bankTranLogMap.put("amount", netAmt);
                        bankTranLogMap.put("tran_type", "R");
                    }
                }
                bankTranLogMap.put("site_code", siteCode);
                bankTranLogMap.put("acct_code", acctCodeBal);
                bankTranLogMap.put("cctr_code", cctrCodeBal);
                bankTranLogMap.put("sundry_type", "C");
                bankTranLogMap.put("sundry_code", custCode);
                bankTranLogMap.put("remarks", remarks);
                bankTranLogMap.put("due_date", new Timestamp(tranDate.getTime()));
                bankTranLogMap.put("entry_batch_no", (String)RcpHdrMap.get("entry_batch_no"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"545 bankTranLogUpdateeUpdate Called..............");
                errString = finCommon.bankTranLogUpdate(bankTranLogMap, xtraParams, conn);
                if (errString != null && errString.trim().length() > 0) {
                    return errString;
                }
            }
            if (Double.parseDouble("" + RcpHdrMap.get("diff_amt__exch")) != 0.0) {
                glTraceMap = new HashMap();
                glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                glTraceMap.put("fin_entity", finEntity);
                glTraceMap.put("site_code", siteCode);
                glTraceMap.put("sundry_type", "O");
                glTraceMap.put("sundry_code", "");
                glTraceMap.put("acct_code", (String)RcpHdrMap.get("acct_code__cf"));
                if (acctCodeCf == null || acctCodeCf.trim().length() == 0) {
                    if (RcpDetList.size() >= 1) {
                        glTraceMap.put("cctr_code", cctrCodeAr);
                    }
                } else {
                    glTraceMap.put("cctr_code", (String)RcpHdrMap.get("cctr_code__cf"));
                }
                glTraceMap.put("emp_code", "");
                glTraceMap.put("anal_code", "");
                glTraceMap.put("curr_code", basecurrCode);
                glTraceMap.put("exch_rate", 1.0);
                StringBuilder stringBuilder = new StringBuilder();
                if (Double.parseDouble(stringBuilder.append(RcpHdrMap.get("diff_amt__exch")).toString()) > 0.0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("inside true-- difference amount in gltrace" + RcpHdrMap.get("diff_amt__exch")));
                    glTraceMap.put("dr_amt", Double.parseDouble("" + RcpHdrMap.get("diff_amt__exch")));
                    glTraceMap.put("cr_amt", 0);
                    cnt1 = 1;
                } else {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("inside false--- difference amount in gltrace" + RcpHdrMap.get("diff_amt__exch")));
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", -1.0 * Double.parseDouble("" + RcpHdrMap.get("diff_amt__exch")));
                    cnt1 = 2;
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "RCP");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                glTraceMap.put("proj_code", projectCode);
                glTraceMap.put("chg_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("chg_user", loginEmpCode);
                glTraceMap.put("chg_term", chgTermstr);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"1938 glTraceUpdate Called..............");
                errString = finCommon.glTraceUpdate(glTraceMap, conn, isPreview);
                if (errString != null && errString.trim().length() > 0) {
                    return errString;
                }
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("exchange rate---in difference amount---" + glTraceMap.get("exch_rate")));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("credit difference>>[" + (credit += Double.parseDouble("" + glTraceMap.get("cr_amt")) * Double.parseDouble("" + glTraceMap.get("exch_rate"))) + "] debit >>>[" + (debit += Double.parseDouble("" + glTraceMap.get("dr_amt")) * Double.parseDouble("" + glTraceMap.get("exch_rate"))) + "]"));
            StringBuilder stringBuilder = new StringBuilder();
            if (Double.parseDouble(stringBuilder.append(RcpHdrMap.get("adv_amt")).toString()) > 0.0 && !isPreview) {
                sql = "select sales_pers  from customer where cust_code  = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, custCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    salesPers = rs.getString(1);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                receivablesMap = new HashMap<String, Object>();
                receivablesMap.put("tran_ser", "R-ADV");
                receivablesMap.put("tran_date", new Timestamp(tranDate.getTime()));
                receivablesMap.put("fin_entity", finEntity);
                receivablesMap.put("site_code", siteCode);
                receivablesMap.put("ref_no", tranId);
                receivablesMap.put("sale_order", (String)RcpHdrMap.get("sale_order"));
                receivablesMap.put("ref_date", new Timestamp(tranDate.getTime()));
                receivablesMap.put("due_date", new Timestamp(tranDate.getTime()));
                receivablesMap.put("curr_code", currCode);
                receivablesMap.put("exch_rate", exchRate);
                receivablesMap.put("cust_code", custCode);
                receivablesMap.put("acct_code", acctCode);
                receivablesMap.put("cctr_code", cctrCode);
                receivablesMap.put("eff_date", new Timestamp(effDate.getTime()));
                receivablesMap.put("tax_amt", 0);
                receivablesMap.put("discount", 0);
                receivablesMap.put("tot_amt", -1.0 * (Double.parseDouble("" + RcpHdrMap.get("adv_amt")) - amtNoBankEffect));
                receivablesMap.put("auto_rcp", "N");
                receivablesMap.put("bank_code", (String)RcpHdrMap.get("bank_code") == null ? "" : (String)RcpHdrMap.get("bank_code"));
                receivablesMap.put("ref_type", "F");
                receivablesMap.put("cr_term", null);
                receivablesMap.put("sales_pers", salesPers);
                receivablesMap.put("item_ser", (String)RcpHdrMap.get("item_ser") == null ? "" : (String)RcpHdrMap.get("item_ser"));
                receivablesMap.put("fin_scheme", (String)RcpHdrMap.get("fin_scheme"));
                receivablesMap.put("sales_pers__1", null);
                receivablesMap.put("sales_pers__2", null);
                receivablesMap.put("line_no__ref", null);
                receivablesMap.put("mrp_value", "0");
                receivablesMap.put("gp_no", null);
                receivablesMap.put("gp_date", null);
                receivablesMap.put("cust_ref_no", null);
                receivablesMap.put("cust_ref_date", null);
                receivablesMap.put("cust_ref_amt", "");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("In 3352 receivablesMap [" + receivablesMap + "]allocAmt[" + allocAmt + "]"));
                errString = finCommon.gbfReceivablesUpd(receivablesMap, conn);
                if (errString != null && errString.trim().length() > 0) {
                    return errString;
                }
                allocCount = 0;
                sql = "select count(*) as cnt from receipt_form where tran_id__rcp = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    allocCount = rs.getInt("cnt");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("3373@ Count is [" + allocCount + "]"));
                if (allocCount > 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("3348@ inside if condition Count is [" + allocCount + "]"));
                    receivablesMap.put("tran_id", tranId);
                    receivablesMap.put("ref_ser_adj", "RCP");
                    receivablesMap.put("adj_amt", 0);
                    receivablesMap.put("xtraParams", xtraParams);
                    sql = "select tran_id from receipt_form where tran_id__rcp = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        tranIdRcp = rs.getString("tran_id");
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Remittance Form TranId [" + tranIdRcp + "]"));
                    double detTotAmt = 0.0;
                    sql = "select sum(rcp_amt) from rcpdet_form where tran_id = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranIdRcp);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        detTotAmt = rs.getDouble(1);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Remittance Form detTotAmt:: [" + detTotAmt + "]"));
                    receivablesMap.put("alloc_amt", -1.0 * detTotAmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("3355@ receivablesMap [" + receivablesMap + "]allocAmt[" + allocAmt + "]"));
                    errString = finCommon.AllocAmountUpdate(receivablesMap, conn);
                    if (errString != null && errString.trim().length() > 0) {
                        return errString;
                    }
                    sql = "select line_no__ref,ref_ser,ref_no,rcp_amt,tran_id from rcpdet_form where tran_id = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranIdRcp);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        RcpDetMap = new HashMap();
                        RcpDetMap.put("line_no__ref", rs.getString("line_no__ref"));
                        RcpDetMap.put("ref_ser", rs.getString("ref_ser"));
                        RcpDetMap.put("ref_no", rs.getString("ref_no"));
                        RcpDetMap.put("rcp_amt", rs.getDouble("rcp_amt"));
                        RcpDetMap.put("tran_id", rs.getString("tran_id"));
                        RcpDetailList.add(RcpDetMap);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("RcpDetailList [" + RcpDetailList.toString() + "]RcpDetMap[" + RcpDetMap + "]"));
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    int ctr2 = 0;
                    while (ctr2 < RcpDetailList.size()) {
                        RcpDetMap = new HashMap();
                        RcpDetMap = (HashMap)RcpDetailList.get(ctr2);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("RcpDetailList ctr [" + ctr2 + "] RcpDetMap [" + RcpDetMap.toString() + "]"));
                        amount = Double.parseDouble("" + RcpDetMap.get("rcp_amt"));
                        tranId = (String)RcpDetMap.get("tran_id");
                        refSer = (String)RcpDetMap.get("ref_ser");
                        refNo = (String)RcpDetMap.get("ref_no");
                        lineNoRef = (String)RcpDetMap.get("line_no__ref");
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("amount[" + amount + "]tranId[" + tranId + "]refSer[" + refSer + "]refNo[" + refNo + "]lineNoRef[" + lineNoRef + "]"));
                        HashMap<String, Object> allocAmtUpdateMap = null;
                        allocAmtUpdateMap = new HashMap<String, Object>();
                        allocAmtUpdateMap.put("tran_ser", refSer);
                        allocAmtUpdateMap.put("ref_no", refNo);
                        allocAmtUpdateMap.put("tran_id", tranId);
                        allocAmtUpdateMap.put("line_no__ref", lineNoRef);
                        allocAmtUpdateMap.put("ref_ser_adj", "RCP");
                        allocAmtUpdateMap.put("xtraParams", xtraParams);
                        allocAmtUpdateMap.put("adj_amt", 0);
                        allocAmtUpdateMap.put("alloc_amt", amount);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("In 3437 allocAmtUpdatemap [" + allocAmtUpdateMap + "]"));
                        errString = finCommon.AllocAmountUpdate(allocAmtUpdateMap, conn);
                        if (errString != null && errString.trim().length() > 0) {
                            return errString;
                        }
                        ++ctr2;
                    }
                }
                sundryBalMap = new HashMap();
                sundryBalMap.put("tran_date", new Timestamp(tranDate.getTime()));
                sundryBalMap.put("eff_date", new Timestamp(effDate.getTime()));
                sundryBalMap.put("fin_entity", finEntity);
                sundryBalMap.put("site_code", siteCode);
                sundryBalMap.put("sundry_type", "B");
                sundryBalMap.put("sundry_code", bankCode);
                sundryBalMap.put("acct_code", (String)RcpHdrMap.get("acct_code__adv"));
                sundryBalMap.put("cctr_code", (String)RcpHdrMap.get("cctr_code__adv"));
                sundryBalMap.put("curr_code", currCode);
                sundryBalMap.put("exch_rate", exchRate);
                sundryBalMap.put("dr_amt", 0.0);
                sundryBalMap.put("cr_amt", 0.0);
                sundryBalMap.put("adv_amt", Double.parseDouble("" + RcpHdrMap.get("adv_amt")));
                contactCode = finCommon.getContactCode(sundryType, sundryCode, conn);
                sundryBalMap.put("contact_code", contactCode);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("In 2021 sundryBalMap [" + sundryBalMap + "]"));
                errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                if (errString != null && errString.trim().length() > 0) {
                    return errString;
                }
                String string = payslip = (String)RcpHdrMap.get("entry_batch_no") == null ? "" : (String)RcpHdrMap.get("entry_batch_no");
                if (payslip.trim().length() > 0) {
                    sql = " select count(1) from receipt_pay_in_slip where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        cnt = rs.getInt(1);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    if (cnt <= 0) {
                        sql = "insert into receipt_pay_in_slip ( tran_id, entry_batch_no ) values (?, ?)";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, tranId);
                        pstmt.setString(2, payslip);
                        rs = pstmt.executeQuery();
                        pstmt.close();
                        pstmt = null;
                    }
                }
                confirmed = (String)RcpHdrMap.get("confirmed");
                sql = "select edi_option from transetup where tran_window = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, "w_receipt_adv");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    ediOption = rs.getInt(1);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (ediOption > 0.0) {
                    RcpHdrMap.put("confirmed", "Y");
                    RcpHdrMap.put("conf_date", today);
                    RcpHdrMap.put("emp_code__aprv", loginEmpCode);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    private String gbfPostRcpdet(String tranId, String xtraParams, HashMap RcpHdrMap, ArrayList DetList, ArrayList RcpDetList, ArrayList ADetList, ArrayList EpcAdjList, Connection conn, boolean isPreview) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("gbfPostRcpdet called.............." + RcpDetList));
        String errString = "";
        String currCode = "";
        String siteCode = "";
        String siteCodeFor = "";
        String finEntity = "";
        String acctCode = "";
        String cctrCode = "";
        String recoAcctCode = "";
        String recoCctrCode = "";
        String taxAcctCode = "";
        String taxCctrCode = "";
        String acctCode1 = "";
        String cctrCode1 = "";
        String acctCodeAr = "";
        String cctrCodeAr = "";
        String projectCode = "";
        String analCode = "";
        String bankCode = "";
        String remarks = "";
        String sundryType = "";
        String contactCode = "";
        String sundryCode = "";
        String sundryTypeFor = "";
        String sundryCodeFor = "";
        String tranType = "";
        String empCode = "";
        String refNO = "";
        String rcpMode = "";
        String batchNo = "";
        String confirm = "";
        String loginEmpCode = "";
        String winName = "";
        String editOption = "";
        String sql = "";
        String hcurrCode = "";
        String errorType = "";
        String payslip = "";
        String partyDocRef = "";
        String refSer = "";
        String refNo = "";
        String salesPers = "";
        String status = "";
        String lineNoRef = "";
        boolean count = false;
        boolean lineNo = false;
        double exchRate = 0.0;
        double hexchRate = 0.0;
        double netAmount = 0.0;
        double amount = 0.0;
        double taxAmount = 0.0;
        double recoAmount = 0.0;
        double debit = 0.0;
        double credit = 0.0;
        double totAmt = 0.0;
        double advAmt = 0.0;
        double adjAmt = 0.0;
        double rcpAmt = 0.0;
        double advAdj = 0.0;
        double recoverAmt = 0.0;
        double allocAmt = 0.0;
        java.util.Date effDate = null;
        java.util.Date tranDate = null;
        Object refDate = null;
        HashMap DetMap = null;
        HashMap RcpDetMap = null;
        HashMap ADetMap = null;
        HashMap EpcAdjMap = null;
        HashMap<String, Object> glTraceMap = null;
        HashMap<String, Object> sundryBalMap = null;
        Object bankTranLogMap = null;
        Object detListMap = null;
        Object recofiltMap = null;
        Object recodataMap = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        DistCommon distCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        ValidatorEJB validatorEJB = new ValidatorEJB();
        double nobankEffectAmt = 0.0;
        double exchRateHdr = 0.0;
        String chgTermstr = "";
        String tranIDHdr = "";
        PreparedStatement pstmtRcp = null;
        Object pstmtAdj = null;
        ResultSet rsRcp = null;
        Object rsAdj = null;
        String rcpNoAdj = "";
        Object rcpDetMap = null;
        Object rcpDetailList = null;
        double rcpAmtRF = 0.0;
        String tranIdRF = "";
        String refSerRF = "";
        String refNoRF = "";
        String lineNoRefRF = "";
        boolean jvAgainstRF = false;
        Object rs1 = null;
        Object rs2 = null;
        Vector getdetAcct = new Vector();
        HashMap validReasonCd = new HashMap();
        Object discountDate = null;
        Object pstmt1 = null;
        Object pstmt2 = null;
        Object sqlUpdate = null;
        Object sql2 = null;
        String miscCrTranId = "";
        String miscDrTranId = "";
        String refSerDet = "";
        String refNoDet = "";
        String refNoCust = "";
        boolean rowCnt = false;
        double rcpAmtDet = 0.0;
        Double diff = 0.0;
        double outstandAmt = 0.0;
        String crTerm = "";
        String forcedFlag = "";
        String tranIdRcp = "";
        String tranIdRcpForm = "";
        double chqAmt = 0.0;
        double balAmt = 0.0;
        try {
            finCommon = new FinCommon();
            distCommon = new DistCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            chgTermstr = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
            tranDate = (java.util.Date)RcpHdrMap.get("tran_date");
            effDate = (java.util.Date)RcpHdrMap.get("eff_date");
            finEntity = (String)RcpHdrMap.get("fin_entity");
            siteCode = (String)RcpHdrMap.get("site_code");
            siteCodeFor = (String)RcpHdrMap.get("site_code__for");
            projectCode = (String)RcpHdrMap.get("proj_code");
            hcurrCode = (String)RcpHdrMap.get("curr_code");
            hexchRate = Double.parseDouble("" + RcpHdrMap.get("exch_rate"));
            remarks = (String)RcpHdrMap.get("remarks");
            tranIDHdr = (String)RcpHdrMap.get("tran_id");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList SIZE [" + DetList.size() + "] DetList [" + DetList + "]"));
            int ctr = 0;
            while (ctr < DetList.size()) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of times " + ctr));
                DetMap = (HashMap)DetList.get(ctr);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" DetMap ctr [" + ctr + "] [" + DetMap + "]"));
                sundryType = (String)DetMap.get("sundry_type") == null ? "O" : (String)DetMap.get("sundry_type");
                sundryCode = (String)DetMap.get("sundry_code") == null ? "" : (String)DetMap.get("sundry_code");
                glTraceMap = new HashMap<String, Object>();
                glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                glTraceMap.put("fin_entity", finEntity);
                glTraceMap.put("site_code", siteCode);
                glTraceMap.put("sundry_type", (String)DetMap.get("sundry_type") == null ? "O" : (String)DetMap.get("sundry_type"));
                glTraceMap.put("sundry_code", (String)DetMap.get("sundry_code") == null ? "" : (String)DetMap.get("sundry_code"));
                glTraceMap.put("acct_code", (String)DetMap.get("acct_code"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("818 account chek =" + acctCode + "  " + sundryType + "   " + sundryCode));
                glTraceMap.put("cctr_code", (String)DetMap.get("cctr_code") == null ? " " : (String)DetMap.get("cctr_code"));
                glTraceMap.put("emp_code", (String)DetMap.get("emp_code"));
                glTraceMap.put("anal_code", (String)DetMap.get("anal_code"));
                glTraceMap.put("curr_code", (String)DetMap.get("curr_code") == null ? hcurrCode : (String)DetMap.get("curr_code"));
                glTraceMap.put("proj_code", projectCode);
                glTraceMap.put("exch_rate", Double.parseDouble("" + DetMap.get("exch_rate")));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("818 exchrate =" + acctCode + "  " + sundryType + "   " + sundryCode + "  exchrate sundry bal" + DetMap.get("exch_rate")));
                amount = Double.parseDouble("" + DetMap.get("amount"));
                if (amount > 0.0) {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", amount);
                } else {
                    glTraceMap.put("dr_amt", -1.0 * amount);
                    glTraceMap.put("cr_amt", 0.0);
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "RCP");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                glTraceMap.put("party_doc_ref", partyDocRef);
                glTraceMap.put("chg_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("chg_user", loginEmpCode);
                glTraceMap.put("chg_term", chgTermstr);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("848 glTraceUpdate Called..ctr [" + ctr + "] glTraceMap [" + glTraceMap + "]"));
                errString = finCommon.glTraceUpdate(glTraceMap, conn, isPreview);
                if (errString != null && errString.trim().length() > 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ERROR IN GLTRACE ........... errString [" + errString + "]"));
                    return errString;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dr in receivables " + (debit += Double.parseDouble("" + glTraceMap.get("dr_amt")) * Double.parseDouble("" + glTraceMap.get("exch_rate"))) + " credit " + (credit += Double.parseDouble("" + glTraceMap.get("cr_amt")) * Double.parseDouble("" + glTraceMap.get("exch_rate")))));
                if ((String)glTraceMap.get("sundry_type") != null && !((String)glTraceMap.get("sundry_type")).trim().equalsIgnoreCase("O") && !isPreview) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"COMES INTO CONDITION ...........");
                    sundryBalMap = new HashMap();
                    sundryBalMap.put("tran_date", new Timestamp(tranDate.getTime()));
                    sundryBalMap.put("eff_date", new Timestamp(effDate.getTime()));
                    sundryBalMap.put("fin_entity", finEntity);
                    sundryBalMap.put("site_code", siteCode);
                    sundryBalMap.put("sundry_type", (String)glTraceMap.get("sundry_type"));
                    sundryBalMap.put("sundry_code", sundryCode);
                    sundryBalMap.put("acct_code", (String)DetMap.get("acct_code"));
                    sundryBalMap.put("cctr_code", (String)DetMap.get("cctr_code") == null ? " " : (String)DetMap.get("cctr_code"));
                    sundryBalMap.put("curr_code", (String)DetMap.get("curr_code") == null ? hcurrCode : (String)DetMap.get("curr_code"));
                    sundryBalMap.put("exch_rate", Double.parseDouble("" + DetMap.get("exch_rate")));
                    amount = Double.parseDouble("" + DetMap.get("amount"));
                    if (amount > 0.0) {
                        sundryBalMap.put("dr_amt", 0.0);
                        sundryBalMap.put("cr_amt", amount);
                    } else {
                        sundryBalMap.put("dr_amt", -1.0 * amount);
                        sundryBalMap.put("cr_amt", 0.0);
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dr in sundry " + amount));
                    sundryBalMap.put("adv_amt", 0.0);
                    contactCode = finCommon.getContactCode(sundryType, sundryCode, conn);
                    sundryBalMap.put("contact_code", contactCode);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"2366 sundryBaleUpdate Called..............");
                    errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                    if (errString != null && errString.trim().length() > 0) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("error is sundryBaleUpdate ..........." + errString));
                        return errString;
                    }
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"last ...........3316");
                ++ctr;
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ isPreview :- [" + isPreview + "]"));
            if (!isPreview) {
                HashMap<String, Object> receivablesMap;
                int cnt;
                String sqlRcp = "select count(*) from receipt_form where  tran_id__adj = ?";
                pstmtRcp = conn.prepareStatement(sqlRcp);
                pstmtRcp.setString(1, tranIDHdr);
                rsRcp = pstmtRcp.executeQuery();
                if (rsRcp.next() && (cnt = rsRcp.getInt(1)) > 0) {
                    jvAgainstRF = true;
                }
                rsRcp.close();
                rsRcp = null;
                pstmtRcp.close();
                pstmtRcp = null;
                String tranIdRcpRF = "";
                String rfTranId = "";
                String rcpDetRefNo = "";
                String rcpDetRefSer = "";
                if (jvAgainstRF) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("inside if jvAgainstRF:::" + jvAgainstRF));
                    sqlRcp = "select tran_id__rcp, tran_id from receipt_form where tran_id__adj = ?";
                    pstmtRcp = conn.prepareStatement(sqlRcp);
                    pstmtRcp.setString(1, tranId);
                    rsRcp = pstmtRcp.executeQuery();
                    if (rsRcp.next()) {
                        tranIdRcpRF = rsRcp.getString(1);
                        rfTranId = rsRcp.getString(2);
                    }
                    rsRcp.close();
                    rsRcp = null;
                    pstmtRcp.close();
                    pstmtRcp = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("inside tranIdRcpRF:::[" + tranIdRcpRF + "] rfTranId::[" + rfTranId + "]"));
                double allocAmtAdv = 0.0;
                sqlRcp = "select alloc_amt from receivables where tran_ser = 'R-ADV' and ref_no = ?";
                pstmtRcp = conn.prepareStatement(sqlRcp);
                pstmtRcp.setString(1, tranIdRcpRF);
                rsRcp = pstmtRcp.executeQuery();
                if (rsRcp.next()) {
                    allocAmtAdv = rsRcp.getDouble(1);
                }
                rsRcp.close();
                rsRcp = null;
                pstmtRcp.close();
                pstmtRcp = null;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("inside allocAmtAdv:::[" + allocAmtAdv));
                sqlRcp = "select ref_no, ref_ser from rcpdet_form where tran_id  = ? and adj_opt_flg = 'A'";
                pstmtRcp = conn.prepareStatement(sqlRcp);
                pstmtRcp.setString(1, rfTranId);
                rsRcp = pstmtRcp.executeQuery();
                if (rsRcp.next()) {
                    rcpDetRefNo = this.checkNull(rsRcp.getString(1));
                    rcpDetRefSer = this.checkNull(rsRcp.getString(2));
                }
                rsRcp.close();
                rsRcp = null;
                pstmtRcp.close();
                pstmtRcp = null;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("inside rcpDetRefNo:::[" + rcpDetRefNo + "] rcpDetRefSer::[" + rcpDetRefSer + "]"));
                int ctr2 = 0;
                while (ctr2 < RcpDetList.size()) {
                    RcpDetMap = new HashMap();
                    RcpDetMap = (HashMap)RcpDetList.get(ctr2);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Manoharan 22-Mar-2021 ctr:: [" + ctr2 + "] RcpDetMap [" + RcpDetMap.toString() + "]"));
                    amount = Double.parseDouble("" + RcpDetMap.get("rcp_amt"));
                    refSer = (String)RcpDetMap.get("ref_ser");
                    refNo = (String)RcpDetMap.get("ref_no");
                    lineNoRef = (String)RcpDetMap.get("line_no__ref");
                    receivablesMap = null;
                    receivablesMap = new HashMap();
                    receivablesMap.put("tran_ser", refSer);
                    receivablesMap.put("ref_no", refNo);
                    receivablesMap.put("tran_id", tranIDHdr);
                    receivablesMap.put("line_no__ref", lineNoRef);
                    receivablesMap.put("adj_amt", amount);
                    receivablesMap.put("ref_ser_adj", "RCP");
                    receivablesMap.put("xtraParams", xtraParams);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::RcpDetMap:: refSer::" + refSer + "---refNo::" + refNo + "---lineNoRef::" + lineNoRef));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::RcpDetMap:: tranId[" + tranId + "]alloc_amt[" + amount + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::RcpDetMap(Call)::" + ctr2 + ":: rcpAmt::" + amount));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::receivablesMap [" + receivablesMap.toString() + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::refNoHdr::" + tranIDHdr));
                    errString = this.Fcommon.ReceivablesUpdate(receivablesMap, conn);
                    if (errString != null && errString.trim().length() > 0) {
                        return errString;
                    }
                    if (!(refNo.trim().equals(rcpDetRefNo.trim()) && refSer.trim().equals(rcpDetRefSer.trim()) || !jvAgainstRF)) {
                        if (refNo.trim().equals(tranIdRcpRF.trim()) && refSer.trim().equals("R-ADV")) {
                            receivablesMap.put("alloc_amt", allocAmtAdv * -1.0);
                        } else {
                            receivablesMap.put("alloc_amt", amount * -1.0);
                        }
                        errString = this.Fcommon.AllocAmountUpdate(receivablesMap, conn);
                        if (errString != null && errString.trim().length() > 0) {
                            return errString;
                        }
                    }
                    ++ctr2;
                }
                ctr2 = 0;
                while (ctr2 < ADetList.size()) {
                    ADetMap = new HashMap();
                    ADetMap = (HashMap)ADetList.get(ctr2);
                    receivablesMap = null;
                    receivablesMap = new HashMap<String, Object>();
                    refSer = (String)ADetMap.get("ref_ser");
                    refNo = (String)ADetMap.get("ref_no");
                    advAdj = Double.parseDouble("" + ADetMap.get("adj_amt"));
                    receivablesMap.put("line_no__ref", "1");
                    receivablesMap.put("tran_ser", refSer);
                    receivablesMap.put("ref_no", refNo);
                    receivablesMap.put("tran_id", tranIDHdr);
                    receivablesMap.put("adj_amt", advAdj);
                    receivablesMap.put("ref_ser_adj", "RCP");
                    receivablesMap.put("xtraParams", xtraParams);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::refNoHdr::" + tranIDHdr));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::refNoHdr::" + tranIDHdr));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Manoharan 22-Mar-2021  3 receivablesMap [" + receivablesMap.toString() + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::ADetMap:: refSer::" + refSer + "---refNo::" + refNo + "---lineNoRef::" + lineNoRef));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::ADetMap(call)::" + ctr2 + ":: advAdj::" + advAdj));
                    errString = this.Fcommon.ReceivablesUpdate(receivablesMap, conn);
                    if (errString != null && errString.trim().length() > 0) {
                        return errString;
                    }
                    sundryBalMap = new HashMap<String, Object>();
                    sundryBalMap.put("tran_date", new Timestamp(tranDate.getTime()));
                    sundryBalMap.put("eff_date", new Timestamp(effDate.getTime()));
                    sundryBalMap.put("fin_entity", finEntity);
                    sundryBalMap.put("site_code", siteCode);
                    sundryBalMap.put("sundry_type", "C");
                    sundryBalMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
                    sundryBalMap.put("acct_code", (String)ADetMap.get("acct_code"));
                    sundryBalMap.put("cctr_code", (String)ADetMap.get("cctr_code"));
                    sundryBalMap.put("curr_code", hcurrCode);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("884 sundryBaleUpdate Called.............." + ADetMap.get("exch_rate__vouch")));
                    sundryBalMap.put("exch_rate", Double.parseDouble("" + ADetMap.get("exch_rate__vouch")));
                    sundryBalMap.put("dr_amt", 0.0);
                    sundryBalMap.put("cr_amt", 0.0);
                    sundryBalMap.put("adv_amt", Double.parseDouble("" + ADetMap.get("adj_amt")));
                    contactCode = finCommon.getContactCode((String)sundryBalMap.get("sundry_type"), (String)sundryBalMap.get("sundry_code"), conn);
                    sundryBalMap.put("contact_code", contactCode);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"884 sundryBaleUpdate Called..............");
                    errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                    if (errString != null && errString.trim().length() > 0) {
                        return errString;
                    }
                    ++ctr2;
                }
                ctr2 = 0;
                while (ctr2 < EpcAdjList.size()) {
                    EpcAdjMap = new HashMap();
                    EpcAdjMap = (HashMap)EpcAdjList.get(ctr2);
                    refSer = (String)EpcAdjMap.get("ref_ser");
                    refNo = (String)EpcAdjMap.get("ref_no");
                    amount = Double.parseDouble("" + EpcAdjMap.get("amount"));
                    itmDBAccessEJB = new ITMDBAccessEJB();
                    sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT  tot_amt, adj_amt FROM misc_payables  WHERE tran_ser = ?  and ref_no = ?  for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT  tot_amt, adj_amt FROM misc_payables (updlock) where tran_ser = ? and  ref_no = ?  " : " SELECT  tot_amt, adj_amt FROM misc_payables WHERE tran_ser = ?  and ref_no = ?  for update nowait");
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, "E-FUND");
                    pstmt.setString(2, refNo);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        totAmt = this.getReqDecimal(rs.getDouble("tot_amt"), 3);
                        adjAmt = this.getReqDecimal(rs.getDouble("adj_amt"), 3);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("05/04/14 manoharan 3 adjAmt [ " + adjAmt + "] amount [" + amount + "] Math.abs(amount - adjAmt) [" + Math.abs(amount - adjAmt) + "] Math.abs(amount) [" + Math.abs(amount) + "]"));
                    double tempAmt = this.getReqDecimal(Math.abs(amount - adjAmt), 3);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::@V@ TempAmt :- [" + tempAmt + "]"));
                    if (this.getReqDecimal(tempAmt, 2) < this.getReqDecimal(Math.abs(amount), 2)) {
                        errString = itmDBAccessEJB.getErrorString("", "VTBAL1", "", "", conn);
                        return errString;
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ReceiptAdvConf::@V@ adjAmt :- [" + (adjAmt += amount * -1.0) + "]"));
                    status = totAmt == adjAmt ? "A" : "P";
                    sql = "update misc_payables set adj_amt = ?  where tran_ser = ? and ref_no = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setDouble(1, adjAmt);
                    pstmt.setString(2, "E-FUND");
                    pstmt.setString(3, refNo);
                    pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                    sql = "update export_fund set bal_amt = (case when bal_amt is null then 0 else bal_amt end-?),amount__epcadj=?  where tran_id = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setDouble(1, amount * -1.0);
                    pstmt.setDouble(2, adjAmt);
                    pstmt.setString(3, refNo);
                    pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                    ++ctr2;
                }
                errString = this.taxPost(tranId, xtraParams, RcpHdrMap, conn);
                if (errString != null && errString.trim().length() > 0) {
                    return errString;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    /*
     * Exception decompiling
     */
    private String taxPost(String tranId, String xtraParams, HashMap RcpHdrMap, Connection conn) throws RemoteException, ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public double getReqDecimal(double actVal, int prec) {
        DecimalFormat decFormat;
        String fmtStr = "#################0";
        Object strValue = null;
        double retVal = 0.0;
        if (prec > 0) {
            fmtStr = String.valueOf(fmtStr) + "." + "000000000".substring(0, prec);
        }
        if (Math.abs(retVal = Double.parseDouble((decFormat = new DecimalFormat(fmtStr)).format(actVal))) == 0.0) {
            retVal = 0.0;
        }
        return retVal;
    }

    private String getErrorXmlString(FinCommon Fcommon, String errString, String tranId) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString.indexOf(\"<error\"): " + errString.indexOf("<error")));
        if (errString.indexOf("<error") < 1) {
            Object[] errorCodeMsg = errString.split("\t");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errorCodeMsg: " + Arrays.toString(errorCodeMsg) + " Length: " + errorCodeMsg.length));
            errString = Fcommon.getErrorXML((String)errorCodeMsg[1], (String)errorCodeMsg[0], (String)errorCodeMsg[0], String.valueOf(tranId) + " failed");
        }
        return errString;
    }

    private String checkNull(String input) {
        if (input == null) {
            input = "";
        }
        return input;
    }
}

