/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.RecPayTrfConfLocal;
import ibase.webitm.ejb.fin.adv.RecPayTrfConfRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.ejb.Stateless;

@Stateless
public class RecPayTrfConf
extends ActionHandlerEJB
implements RecPayTrfConfLocal,
RecPayTrfConfRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();

    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String errString = "";
        Connection conn = null;
        try {
            errString = this.confirm(tranId, xtraParams, forcedFlag, conn);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in confirm() ==>" + e.getMessage()));
            errString = this.genericUtility.createErrorString(e);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString in cofirm() ==>" + errString));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        String confirm = "";
        String siteCode = "";
        String trfType = "";
        String errString = "";
        FinCommon finCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        boolean isLocalConn = false;
        try {
            finCommon = new FinCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                isLocalConn = true;
            }
            sql = " select confirmed,site_code,trf_type from rec_pay_trf  where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                confirm = rs.getString("confirmed");
                siteCode = rs.getString("site_code");
                trfType = rs.getString("trf_type");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (confirm != null && "Y".equalsIgnoreCase(confirm)) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                String string = errString = itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            errString = "0".equalsIgnoreCase(trfType) ? this.payRecTrfConfirm(tranId, xtraParams, forcedFlag, conn) : this.recPayTrfConfirm(tranId, xtraParams, forcedFlag, conn);
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            try {
                errString = new ITMDBAccessEJB().getErrorString("", "VTCONSUCF", "", "", conn);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception ::" + e.getMessage()));
                errString = this.genericUtility.createErrorString(e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Exception while rollbacking222.......");
                }
                throw new ITMException(e);
            }
        }
        finally {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY RecPayTrfConf confirm @#......>>[" + isLocalConn + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY RecPayTrfConf confirm errString@#......>>[" + errString + "]"));
            try {
                if (errString != null && errString.trim().length() > 0) {
                    if (errString.indexOf("VTCONSUCF") > -1) {
                        if (isLocalConn) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Transaction commited111.............from RecPayTrfConf");
                            conn.commit();
                        }
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollbacking......................................");
                        conn.rollback();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollback......................................");
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (isLocalConn) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    /*
     * Exception decompiling
     */
    private String payRecTrfConfirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[WHILELOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String recPayTrfConfirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[WHILELOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String generateTranId(String windowName, String tranSer, String siteCode, Connection conn) throws ITMException {
        Statement pstmt = null;
        ResultSet rs = null;
        String selSql = "";
        String tranId = "";
        String keyString = "";
        String xmlValues = "";
        Timestamp currDate = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            try {
                SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
                currDate = new Timestamp(System.currentTimeMillis());
                String currDateStr = sdfAppl.format(currDate);
                selSql = "SELECT KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
                pstmt = conn.prepareStatement(selSql);
                pstmt.setString(1, windowName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    keyString = rs.getString("KEY_STRING");
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                } else {
                    selSql = "SELECT KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW = 'GENERAL' ";
                    pstmt = conn.prepareStatement(selSql);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        keyString = rs.getString("KEY_STRING");
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                    }
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("keyString :" + keyString));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranSer :" + tranSer));
                xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
                xmlValues = String.valueOf(xmlValues) + "<Header></Header>";
                xmlValues = String.valueOf(xmlValues) + "<Detail1>";
                xmlValues = String.valueOf(xmlValues) + "<tran_id></tran_id>";
                xmlValues = String.valueOf(xmlValues) + "<site_code>" + siteCode + "</site_code>";
                xmlValues = String.valueOf(xmlValues) + "<tran_date>" + currDateStr + "</tran_date>";
                xmlValues = String.valueOf(xmlValues) + "</Detail1></Root>";
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("xmlValues  :[" + xmlValues + "]"));
                TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
                tranId = tg.generateTranSeqID(tranSer, "tran_id", keyString, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranId NEWLY WT SITECODE & DATE :" + tranId));
            }
            catch (SQLException ex) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :generateTranId:" + selSql + ex.getMessage() + ":"));
                ex.printStackTrace();
                throw new ITMException((Exception)ex);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :generateTranId:" + e.getMessage() + ":"));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                genericUtility = null;
            }
            catch (Exception exception) {}
        }
        return tranId;
    }

    public String checkNullAndTrim(String inputVal) {
        inputVal = inputVal == null ? "" : inputVal.trim();
        return inputVal;
    }
}

