/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.PayIbcaConfLocal;
import ibase.webitm.ejb.fin.adv.PayIbcaConfRemote;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import org.w3c.dom.Document;

@Stateless
public class RcvIbcaConf
extends ActionHandlerEJB
implements PayIbcaConfLocal,
PayIbcaConfRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();
    FinCommon finCommon = new FinCommon();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
    String gs_run_mode = "";

    @Override
    public String confirm(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String retString = "";
        Connection conn = null;
        try {
            retString = this.confirm(tranID, xtraParams, forcedFlag, conn);
        }
        catch (Exception ex) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in [RcvIbcaConf Main]" + ex.getMessage()));
            throw new ITMException(ex);
        }
        return retString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        String sql = "";
        String confirm = "";
        String siteCode = "";
        String errString = "";
        String loginEmpCode = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean connStatus = false;
        String chgUser = "";
        Timestamp today = null;
        try {
            if (conn == null) {
                conn = this.getConnection();
                connStatus = true;
            }
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            this.gs_run_mode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "runMode");
            sql = " select confirmed,site_code__from as site_code,chg_user from rcp_ibca where tran_id = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                confirm = rs.getString("confirmed") == null ? "N" : rs.getString("confirmed");
                siteCode = rs.getString("site_code") == null ? " " : rs.getString("site_code");
                String string = chgUser = rs.getString("chg_user") == null ? " " : rs.getString("chg_user");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            if (chgUser == null || chgUser.trim().length() == 0) {
                chgUser = "SYSTEM";
            }
            if ("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                sql = " select emp_code from users where code=? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, chgUser);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    loginEmpCode = rs.getString(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            if (confirm != null && "N".equalsIgnoreCase(confirm)) {
                errString = this.retreiveRibca(tranId, siteCode, xtraParams, conn);
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                if (errString != null && errString.trim().length() != 0) {
                    String string = errString;
                    return string;
                }
                if ("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                    loginEmpCode = "E03952";
                }
                today = new Timestamp(System.currentTimeMillis());
                sql = " update rcp_ibca set confirmed = 'Y', conf_date = ?, emp_code__aprv = ? where tran_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setTimestamp(1, today);
                pstmt.setString(2, loginEmpCode);
                pstmt.setString(3, tranId);
                int updateCoount = pstmt.executeUpdate();
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (updateCoount > 0) {
                    errString = this.itmDBAccessEJB.getErrorString("", "VTCICONF3", "", "", conn);
                }
            } else {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed and can not be edited");
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Error String from confirm method.....[" + errString + "]"));
            return errString;
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception inside RcvIbcaConf Confirm==>" + e.getMessage()));
            if (conn != null) {
                try {
                    if (connStatus) {
                        conn.rollback();
                    }
                }
                catch (SQLException ex) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            block43: {
                try {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Inside finally connStatus [" + connStatus + "]"));
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn == null || conn.isClosed() || !connStatus) break block43;
                    if (errString.indexOf("VTCICONF3") > -1) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Inside comitting.....");
                        conn.commit();
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Inside rollbacking.....");
                        conn.rollback();
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public String retreiveRibca(String ibcaID, String siteCode, String xtraParams, Connection conn) throws ITMException {
        retString = "";
        sql = "";
        pstmt = null;
        rs = null;
        tranIDList = new ArrayList<String>();
        cntHdr = 0;
        tranIDRcpIBCA = "";
        winName = "";
        ledgPostConf = "";
        tranDate = null;
        today = null;
        hdrMap = null;
        detMap = null;
        detailList = new ArrayList<HashMap<K, V>>();
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Inside gbf_retrieve_ribca...ibcaID[" + ibcaID + "] siteCode[" + siteCode + "]"));
            today = new Timestamp(System.currentTimeMillis());
            sql = " select tran_id from rcp_ibca where tran_id >= ? and tran_id <= ? and site_code__from = ?  and upper(confirmed) <> 'Y' ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, ibcaID);
            pstmt.setString(2, ibcaID);
            pstmt.setString(3, siteCode);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ++cntHdr;
                tranIDList.add(rs.getString("tran_id"));
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            i = 0;
            while (i < tranIDList.size()) {
                block36: {
                    tranIDRcpIBCA = (String)tranIDList.get(i);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranIDRcpIBCA--->[" + tranIDRcpIBCA + "]"));
                    sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) != false ? " select tran_id from rcp_ibca where tran_id = ? for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) != false ? " select tran_id from rcp_ibca (updlock) where tran_id = ? " : " select tran_id from rcp_ibca where tran_id = ? for update nowait ");
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranIDRcpIBCA);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        v0 = tranIDRcpIBCA = rs.getString("tran_id") == null ? " " : rs.getString("tran_id");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    sql = " select tran_id,tran_date,eff_date,site_code__from,fin_entity__from,site_code__to,fin_entity__to,  amount,curr_code,confirmed,exch_rate,conf_date,emp_code__aprv,acct_code__ifr,cctr_code__ifr,acct_code__ito,cctr_code__ito,  chg_date,chg_user,chg_term,add_date,add_user,add_term,amount__bc,tran_type,tran_ser,tran_id__iss,link_type,remarks,  parent__tran_id,rev__tran,sundry_type,sundry_code  from rcp_ibca WHERE tran_id = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranIDRcpIBCA);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        hdrMap = new HashMap<String, Object>();
                        hdrMap.put("tran_id", rs.getString("tran_id"));
                        hdrMap.put("tran_date", rs.getTimestamp("tran_date"));
                        hdrMap.put("eff_date", rs.getTimestamp("eff_date"));
                        hdrMap.put("site_code__from", rs.getString("site_code__from"));
                        hdrMap.put("fin_entity__from", rs.getString("fin_entity__from"));
                        hdrMap.put("site_code__to", rs.getString("site_code__to"));
                        hdrMap.put("fin_entity__to", rs.getString("fin_entity__to"));
                        hdrMap.put("amount", rs.getDouble("amount"));
                        hdrMap.put("curr_code", rs.getString("curr_code"));
                        hdrMap.put("confirmed", rs.getString("confirmed"));
                        hdrMap.put("exch_rate", rs.getString("exch_rate"));
                        hdrMap.put("conf_date", rs.getTimestamp("conf_date"));
                        hdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
                        hdrMap.put("acct_code__ifr", rs.getString("acct_code__ifr"));
                        hdrMap.put("cctr_code__ifr", rs.getString("cctr_code__ifr"));
                        hdrMap.put("acct_code__ito", rs.getString("acct_code__ito"));
                        hdrMap.put("cctr_code__ito", rs.getString("cctr_code__ito"));
                        hdrMap.put("amount__bc", rs.getDouble("amount__bc"));
                        hdrMap.put("tran_type", rs.getString("tran_type"));
                        hdrMap.put("tran_ser", rs.getString("tran_ser"));
                        hdrMap.put("tran_id__iss", rs.getString("tran_id__iss"));
                        hdrMap.put("link_type", rs.getString("link_type"));
                        hdrMap.put("remarks", rs.getString("remarks"));
                        hdrMap.put("parent__tran_id", rs.getString("parent__tran_id"));
                        hdrMap.put("rev__tran", rs.getString("rev__tran"));
                        hdrMap.put("sundry_type", rs.getString("sundry_type"));
                        hdrMap.put("sundry_code", rs.getString("sundry_code"));
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IBCA header tranSer----[" + rs.getString("tran_ser") + "]"));
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    sql = " select tran_id,ref_ser,ref_no,ref_date,curr_code,exch_rate,cust_code,acct_code,cctr_code,due_date,tot_amt,discount,tax_amt, auto_rcp,bank_code,recd,ref_type,cr_term,sales_pers,item_ser,sales_pers__1,sales_pers__2,ref_ser__org,line_no__ref,gp_no, gp_date,cust_ref_no,cust_ref_date,cust_ref_amt,discount_dt  from rcp_ibca_det where tran_id = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranIDRcpIBCA);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        detMap = new HashMap<String, Object>();
                        detMap.put("tran_id", rs.getString("tran_id"));
                        detMap.put("ref_ser", rs.getString("ref_ser"));
                        detMap.put("ref_no", rs.getString("ref_no"));
                        detMap.put("ref_date", rs.getTimestamp("ref_date"));
                        detMap.put("curr_code", rs.getString("curr_code"));
                        detMap.put("exch_rate", rs.getDouble("exch_rate"));
                        detMap.put("cust_code", rs.getString("cust_code"));
                        detMap.put("acct_code", rs.getString("acct_code"));
                        detMap.put("cctr_code", rs.getString("cctr_code"));
                        detMap.put("due_date", rs.getTimestamp("due_date"));
                        detMap.put("tot_amt", rs.getDouble("tot_amt"));
                        detMap.put("discount", rs.getDouble("discount"));
                        detMap.put("tax_amt", rs.getDouble("tax_amt"));
                        detMap.put("auto_rcp", rs.getString("auto_rcp"));
                        detMap.put("bank_code", rs.getString("bank_code"));
                        detMap.put("recd", rs.getString("recd"));
                        detMap.put("cr_term", rs.getString("cr_term"));
                        detMap.put("sales_pers", rs.getString("sales_pers"));
                        detMap.put("item_ser", rs.getString("item_ser"));
                        detMap.put("sales_pers__1", rs.getString("sales_pers__1"));
                        detMap.put("sales_pers__2", rs.getString("sales_pers__2"));
                        detMap.put("ref_ser__org", rs.getString("ref_ser__org"));
                        detMap.put("line_no__ref", rs.getString("line_no__ref"));
                        detMap.put("gp_no", rs.getString("gp_no"));
                        detMap.put("gp_date", rs.getTimestamp("gp_date"));
                        detMap.put("cust_ref_no", rs.getString("cust_ref_no"));
                        detMap.put("cust_ref_date", rs.getTimestamp("cust_ref_date"));
                        detMap.put("cust_ref_amt", rs.getString("cust_ref_amt"));
                        detMap.put("discount_dt", rs.getString("discount_dt"));
                        detMap.put("ref_type", rs.getString("ref_type"));
                        detailList.add(detMap);
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (hdrMap.size() <= 0) break block36;
                    if ("I".equals(this.gs_run_mode)) {
                        tranDate = (Timestamp)hdrMap.get("tran_date");
                        winName = "W_RCP_IBCA";
                        sql = " select ledg_post_conf from transetup where upper(tran_window) = ? ";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, winName);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            ledgPostConf = rs.getString("ledg_post_conf");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if ("Y".equals(ledgPostConf)) {
                            if (tranDate != today) {
                                tranDate = today;
                                sql = " update rcp_ibca set tran_date = ? where tran_id   = ? ";
                                pstmt = conn.prepareStatement(sql);
                                pstmt.setTimestamp(1, tranDate);
                                pstmt.setString(2, tranIDRcpIBCA);
                                pstmt.executeUpdate();
                                if (pstmt != null) {
                                    pstmt.close();
                                    pstmt = null;
                                }
                            }
                            hdrMap.put("tran_date", tranDate);
                        }
                    }
                    retString = this.gbf_post_ribca(hdrMap, detailList, xtraParams, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After gbf_post_ribca---->[" + retString + "]"));
                    if (retString != null && retString.trim().length() > 0) {
                        var21_21 = retString;
                        return var21_21;
                    }
                    ** GOTO lbl232
                }
                try {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Unable to retreive header data");
lbl232:
                    // 2 sources

                    ++i;
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Expcetion inside gbf_retrieve_ribca ==>" + e.getMessage()));
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retString;
    }

    public String gbf_post_ribca(Map hdrMap, List detailList, String xtraParams, Connection conn) throws ITMException {
        String retString;
        block37: {
            retString = "";
            String sql = "";
            Statement pstmt = null;
            ResultSet rs = null;
            ArrayList tranIDList = new ArrayList();
            boolean cntHdr = false;
            int ediOption = 0;
            String tranIDRcpIBCA = "";
            String winName = "";
            String ledgPostConf = "";
            Timestamp tranDate = null;
            Object today = null;
            String tranId = "";
            String tranSer = "";
            String loginEmpCode = "";
            String dataStr = "";
            String confirmed = "";
            String postOnline = "";
            Map expHdr = null;
            List expDetList = null;
            try {
                CreateRCPXML createRCPXML;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Inside gbf_post_ribca...");
                loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
                sql = " select edi_option from transetup where tran_window = 'w_rcp_ibca' ";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    ediOption = rs.getInt("edi_option");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (hdrMap.size() <= 0 || detailList.size() <= 0) break block37;
                tranId = (String)hdrMap.get("tran_id");
                tranSer = this.checkNullAndTrim((String)hdrMap.get("tran_ser"));
                expHdr = hdrMap;
                expDetList = detailList;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranSer [" + tranSer.toUpperCase() + "]"));
                if ("I".equals(tranSer)) {
                    retString = this.postRibcaHdrIssue(expHdr, xtraParams, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postRibcaHdrIssue [" + retString + "]"));
                    if (retString.trim().length() == 0) {
                        retString = this.postRibcaDetIssue(expHdr, expDetList, xtraParams, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postRibcaDetIssue [" + retString + "]"));
                        if (retString.trim().length() == 0 && ("E".equals(hdrMap.get("link_type")) || "2".equals(ediOption))) {
                            if (ediOption > 0) {
                                hdrMap.put("confirmed", "Y");
                                hdrMap.put("conf_date", today);
                                hdrMap.put("emp_code__aprv", loginEmpCode);
                            }
                            if (ediOption == 2) {
                                createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
                                dataStr = createRCPXML.getTranXML(tranId, conn);
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr =[ " + dataStr + "]"));
                                Document ediDataDom = this.genericUtility.parseString(dataStr);
                                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca", "2", xtraParams, conn);
                                createRCPXML = null;
                                e12CreateBatchLoad = null;
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]"));
                                if (retString != null && retString.indexOf("SUCCESS") != -1) {
                                    retString = "";
                                }
                            } else {
                                createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
                                dataStr = createRCPXML.getTranXML(tranId, conn);
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr =[ " + dataStr + "]"));
                                Document ediDataDom = this.genericUtility.parseString(dataStr);
                                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca", "0", xtraParams, conn);
                                createRCPXML = null;
                                e12CreateBatchLoad = null;
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]"));
                                if (retString != null && retString.indexOf("SUCCESS") != -1) {
                                    retString = "";
                                }
                            }
                        }
                    }
                } else if ("R".equals(tranSer)) {
                    retString = this.postRibcaHdrRcp(expHdr, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postRibcaHdrRcp [" + retString + "]"));
                    if (retString.trim().length() == 0 && ("E".equals(hdrMap.get("link_type")) || ediOption > 0)) {
                        if (ediOption > 0) {
                            hdrMap.put("confirmed", "Y");
                            hdrMap.put("conf_date", today);
                            hdrMap.put("emp_code__aprv", loginEmpCode);
                        }
                        if (ediOption == 2) {
                            createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
                            dataStr = createRCPXML.getTranXML(tranId, conn);
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr =[ " + dataStr + "]"));
                            Document ediDataDom = this.genericUtility.parseString(dataStr);
                            E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                            retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca", "2", xtraParams, conn);
                            createRCPXML = null;
                            e12CreateBatchLoad = null;
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]"));
                            if (retString != null && retString.indexOf("SUCCESS") != -1) {
                                retString = "";
                            }
                        } else {
                            createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
                            dataStr = createRCPXML.getTranXML(tranId, conn);
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr =[ " + dataStr + "]"));
                            Document ediDataDom = this.genericUtility.parseString(dataStr);
                            E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                            retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca", "2", xtraParams, conn);
                            createRCPXML = null;
                            e12CreateBatchLoad = null;
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]"));
                            if (retString != null && retString.indexOf("SUCCESS") != -1) {
                                retString = "";
                            }
                        }
                    }
                }
                if (retString != null && retString.trim().length() > 0) {
                    String string = retString;
                    return string;
                }
                try {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Before POST_ON_LINE.....");
                    postOnline = this.checkNullAndTrim(this.finCommon.getFinparams("999999", "POST_ON_LINE", conn));
                    if ("Y".equals(postOnline)) {
                        retString = this.finCommon.checkGlTranDrCr("R-IBCA", tranId, conn);
                    }
                    if (retString.trim().length() == 0) {
                        confirmed = (String)hdrMap.get("confirmed");
                        sql = " update rcp_ibca set confirmed = 'Y', conf_date = ?, emp_code__aprv = ? where tran_id = ? ";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setTimestamp(1, tranDate);
                        pstmt.setString(2, loginEmpCode);
                        pstmt.setString(3, tranId);
                        pstmt.executeUpdate();
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Expcetion inside gbf_post_ribca ==>" + e.getMessage()));
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return retString;
    }

    public String postRibcaHdrIssue(Map hdrMap, String xtraParams, Connection conn) throws ITMException {
        String retString = "";
        String sql = "";
        Statement pstmt = null;
        ResultSet rs = null;
        String linkType = "";
        HashMap<String, Object> glTraceMap = null;
        String tranId = "";
        Object receivablesMap = null;
        try {
            linkType = (String)hdrMap.get("link_type");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Inside gbf_post_ribca_hdr_iss-----LinkType[" + linkType + "]"));
            if (!"R".equals(linkType) && !"C".equals(linkType)) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Inside if.....");
                glTraceMap = new HashMap<String, Object>();
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "R-IBCA");
                glTraceMap.put("ref_id", hdrMap.get("tran_id"));
                glTraceMap.put("tran_date", hdrMap.get("tran_date"));
                glTraceMap.put("eff_date", hdrMap.get("eff_date"));
                glTraceMap.put("fin_entity", hdrMap.get("fin_entity__from"));
                glTraceMap.put("site_code", hdrMap.get("site_code__from"));
                glTraceMap.put("sundry_type", "O");
                glTraceMap.put("sundry_code", " ");
                glTraceMap.put("acct_code", hdrMap.get("acct_code__ifr"));
                glTraceMap.put("cctr_code", hdrMap.get("cctr_code__ifr"));
                glTraceMap.put("emp_code", "");
                glTraceMap.put("anal_code", "");
                glTraceMap.put("curr_code", hdrMap.get("curr_code"));
                glTraceMap.put("exch_rate", hdrMap.get("exch_rate"));
                if ((Double)hdrMap.get("amount") > 0.0) {
                    glTraceMap.put("dr_amt", hdrMap.get("amount"));
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("cr_amt", 0.0 - (Double)hdrMap.get("amount"));
                    glTraceMap.put("dr_amt", 0.0);
                }
                glTraceMap.put("remarks", hdrMap.get("remarks"));
                retString = this.finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After glTraceUpdate gbf_post_ribca_hdr_iss---->[" + retString + "]"));
                if (retString != null && retString.trim().length() > 0) {
                    String string = retString;
                    return string;
                }
            }
            if ("A".equals(linkType = linkType.trim())) {
                retString = this.postRibcaHdrRcp(hdrMap, conn);
            } else if ("P".equals(linkType)) {
                tranId = (String)glTraceMap.get("ref_id");
                retString = this.createRibca(tranId, tranId, xtraParams, conn);
            } else if ("R".equals(linkType)) {
                retString = this.postRibcaHdrRcp(hdrMap, conn);
            } else if ("C".equals(linkType)) {
                retString = this.postRibcaHdrRcp(hdrMap, conn);
            }
            if (retString != null && retString.trim().length() > 0) {
                String string = retString;
                return string;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Expcetion inside gbf_post_ribca_hdr_iss ==>" + e.getMessage()));
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retString;
    }

    public String postRibcaDetIssue(Map hdrMap, List expDetList, String xtraParams, Connection conn) throws ITMException {
        String retString = "";
        String sql = "";
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap<String, Object> glTraceMap = null;
        String linkType = "";
        String tranId = "";
        String tranType = "";
        String siteCodeFrom = "";
        String refNo = "";
        String refSer = "";
        String lineNoref = "";
        String siteCode = "";
        String remarks = "";
        String status = "";
        String finEntity = "";
        Timestamp tranDate = null;
        Timestamp effDate = null;
        Timestamp today = null;
        double amount = 0.0;
        double totAmount = 0.0;
        double adjAmount = 0.0;
        double totalAmount = 0.0;
        HashMap<String, Object> sundryMap = null;
        UtilMethods utl = new UtilMethods();
        String errCode = "";
        String errString = "";
        HashMap<String, Object> receivablesMap = null;
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Inside gbf_post_ribca_det_iss-----expDetList Size[" + expDetList.size() + "]"));
            today = new Timestamp(System.currentTimeMillis());
            linkType = (String)hdrMap.get("link_type");
            tranId = (String)hdrMap.get("tran_id");
            tranType = (String)hdrMap.get("tran_type");
            tranDate = (Timestamp)hdrMap.get("tran_date");
            effDate = (Timestamp)hdrMap.get("eff_date");
            finEntity = (String)hdrMap.get("fin_entity__from");
            siteCode = (String)hdrMap.get("site_code__from");
            int i = 0;
            while (i < expDetList.size()) {
                HashMap detMap = (HashMap)expDetList.get(i);
                amount = (Double)detMap.get("tot_amt");
                refNo = (String)detMap.get("ref_no");
                refSer = (String)detMap.get("ref_ser");
                lineNoref = (String)detMap.get("line_no__ref");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@@postRibcaDetIssue Link Type[" + linkType + "]"));
                if (!"R".equals(linkType) && !"C".equals(linkType)) {
                    glTraceMap = new HashMap<String, Object>();
                    glTraceMap.put("ref_id", tranId);
                    glTraceMap.put("ref_type", "F");
                    glTraceMap.put("ref_ser", "R-IBCA");
                    glTraceMap.put("tran_date", tranDate);
                    glTraceMap.put("eff_date", effDate);
                    glTraceMap.put("fin_entity", finEntity);
                    glTraceMap.put("site_code", siteCode);
                    glTraceMap.put("sundry_type", "C");
                    glTraceMap.put("sundry_code", detMap.get("cust_code"));
                    glTraceMap.put("acct_code", detMap.get("acct_code"));
                    glTraceMap.put("cctr_code", detMap.get("cctr_code"));
                    glTraceMap.put("emp_code", "");
                    glTraceMap.put("anal_code", "");
                    glTraceMap.put("curr_code", detMap.get("curr_code"));
                    glTraceMap.put("exch_rate", (Double)detMap.get("exch_rate"));
                    if (amount > 0.0) {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", amount);
                    } else {
                        glTraceMap.put("dr_amt", 0.0 - amount);
                        glTraceMap.put("cr_amt", 0.0);
                    }
                    remarks = ((String)hdrMap.get("remarks")).trim();
                    if (remarks == null || remarks.length() <= 0) {
                        retString = errString = this.itmDBAccessEJB.getErrorString("", "VTRMKCMPUL", "", "", conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Remarks is not entered");
                        String string = retString;
                        return string;
                    }
                    if (remarks.length() > 40) {
                        remarks = remarks.substring(0, 40);
                    }
                    remarks = String.valueOf(remarks) + ' ' + refSer.trim() + ':' + refNo.trim();
                    glTraceMap.put("remarks", detMap.get("remarks"));
                    glTraceMap.put("party_doc_ref", this.finCommon.gfGetPartyDocRef(refSer, tranId, conn));
                    sundryMap = new HashMap<String, Object>();
                    sundryMap.put("tran_date", tranDate);
                    sundryMap.put("eff_date", effDate);
                    sundryMap.put("fin_entity", finEntity);
                    sundryMap.put("site_code", siteCode);
                    sundryMap.put("sundry_type", "C");
                    sundryMap.put("sundry_code", glTraceMap.get("sundry_code"));
                    sundryMap.put("acct_code", glTraceMap.get("acct_code"));
                    sundryMap.put("cctr_code", glTraceMap.get("cctr_code"));
                    sundryMap.put("curr_code", glTraceMap.get("curr_code"));
                    sundryMap.put("exch_rate", (Double)glTraceMap.get("exch_rate"));
                    sundryMap.put("dr_amt", (Double)glTraceMap.get("dr_amt"));
                    sundryMap.put("cr_amt", (Double)glTraceMap.get("cr_amt"));
                    sundryMap.put("adv_amt", 0.0);
                    retString = this.finCommon.gbf_sundrybal_upd(sundryMap, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postRibcaDetIssue gbf_sundrybal_upd retString[" + retString + "]"));
                    if (retString.trim().length() == 0) {
                        retString = this.finCommon.glTraceUpdate(glTraceMap, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postRibcaDetIssue glTraceUpdate retString[" + retString + "]"));
                    }
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"After postRibcaDetIssue linkType !R && !C");
                sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? " SELECT tot_amt, adj_amt FROM receivables WHERE tran_ser = ? and ref_no = ? and line_no__ref = ? for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? " SELECT tot_amt, adj_amt FROM receivables (updlock) WHERE tran_ser = ? and ref_no = ? and line_no__ref = ? for update " : " SELECT tot_amt, adj_amt FROM receivables WHERE tran_ser = ? and ref_no = ? and line_no__ref = ? for update nowait ");
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, refSer);
                pstmt.setString(2, refNo);
                pstmt.setString(3, lineNoref);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    totAmount = rs.getDouble("tot_amt");
                    adjAmount = rs.getDouble("adj_amt");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("postRibcaDetIssue----totAmount[" + totAmount + "] adjAmount[" + adjAmount + "] amount[" + amount + "]"));
                totalAmount = Double.parseDouble(utl.getReqDecString(totAmount - adjAmount, 3));
                if (Math.abs(totalAmount) < Math.abs(amount) || Math.abs(totalAmount) == 0.0) {
                    String string = retString = this.itmDBAccessEJB.getErrorString("", "VTBAL1", "", "", conn);
                    return string;
                }
                receivablesMap = new HashMap<String, Object>();
                receivablesMap.put("tran_ser", refSer);
                receivablesMap.put("ref_no", refNo);
                receivablesMap.put("line_no__ref", lineNoref);
                receivablesMap.put("adj_amt", amount);
                receivablesMap.put("tran_id", refNo);
                receivablesMap.put("ref_ser_adj", "R-IBCA");
                receivablesMap.put("tran_date", tranDate);
                receivablesMap.put("xtraParams", xtraParams);
                BaseLogger.log((String)"3", null, null, (Object)("InvoiceCancelEJB:: refNo==>" + refNo));
                BaseLogger.log((String)"3", null, null, (Object)("InvoiceCancelEJB:: refSer==>" + refSer));
                BaseLogger.log((String)"3", null, null, (Object)("InvoiceCancelEJB:: amount==>" + amount));
                BaseLogger.log((String)"3", null, null, (Object)("InvoiceCancelEJB:: tranId==>" + refNo));
                BaseLogger.log((String)"3", null, null, (Object)"InvoiceCancelEJB:: refSerHdr==>R-IBCA");
                BaseLogger.log((String)"3", null, null, (Object)("InvoiceCancelEJB:: tranDate==>" + tranDate));
                retString = this.finCommon.ReceivablesUpdate(receivablesMap, conn);
                ++i;
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("postRibcaDetIssue retString[" + retString + "]"));
            if (retString != null && retString.trim().length() > 0) {
                String string = retString;
                return string;
            }
            try {
                if ("A".equals(linkType)) {
                    retString = this.postRibcaDetRcp(hdrMap, expDetList, xtraParams, conn);
                } else if ("R".equals(linkType)) {
                    retString = this.postRibcaDetRcp(hdrMap, expDetList, xtraParams, conn);
                } else if ("C".equals(linkType)) {
                    retString = this.postRibcaDetRcp(hdrMap, expDetList, xtraParams, conn);
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Expcetion inside gbf_post_ribca_det_iss ==>" + e.getMessage()));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retString;
    }

    /*
     * Exception decompiling
     */
    public String createRibca(String tranIdFr, String tranIdTo, String xtraParams, Connection conn) throws ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String postRibcaHdrRcp(Map hdrMap, Connection conn) throws ITMException {
        String retString = "";
        String sql = "";
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap<String, Object> glTraceMap = null;
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Inside gbf_post_ribca_hdr_rcp...");
            glTraceMap = new HashMap<String, Object>();
            glTraceMap.put("ref_type", "F");
            glTraceMap.put("ref_ser", "R-IBCA");
            glTraceMap.put("ref_id", hdrMap.get("tran_id"));
            glTraceMap.put("tran_date", hdrMap.get("tran_date"));
            glTraceMap.put("eff_date", hdrMap.get("eff_date"));
            glTraceMap.put("fin_entity", hdrMap.get("fin_entity__to"));
            glTraceMap.put("site_code", hdrMap.get("site_code__to"));
            glTraceMap.put("sundry_type", "O");
            glTraceMap.put("sundry_code", " ");
            glTraceMap.put("acct_code", hdrMap.get("acct_code__ito"));
            glTraceMap.put("cctr_code", hdrMap.get("cctr_code__ito"));
            glTraceMap.put("anal_code", "");
            glTraceMap.put("emp_code", "");
            glTraceMap.put("curr_code", hdrMap.get("curr_code"));
            glTraceMap.put("exch_rate", hdrMap.get("exch_rate"));
            if ((Double)hdrMap.get("amount") > 0.0) {
                glTraceMap.put("dr_amt", "0");
                glTraceMap.put("cr_amt", hdrMap.get("amount"));
            } else {
                glTraceMap.put("dr_amt", 0.0 - (Double)hdrMap.get("amount"));
                glTraceMap.put("cr_amt", "0");
            }
            glTraceMap.put("remarks", hdrMap.get("remarks"));
            retString = this.finCommon.glTraceUpdate(glTraceMap, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After glTraceUpdate gbf_post_ribca_hdr_rcp---->[" + retString + "]"));
            if (retString != null && retString.trim().length() > 0) {
                String string = retString;
                return string;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Expcetion inside gbf_post_ribca_hdr_rcp ==>" + e.getMessage()));
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retString;
    }

    public String postRibcaDetRcp(Map hdrMap, List expDetList, String xtraParams, Connection conn) throws ITMException {
        String retString = "";
        String sql = "";
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap<String, Object> glTraceMap = null;
        String finEntityTo = "";
        String tranId = "";
        String tranType = "";
        String siteCodeTo = "";
        String remarks = "";
        String refSer = "";
        String refNo = "";
        Timestamp tranDate = null;
        Timestamp effDate = null;
        int count = 0;
        HashMap detMap = null;
        HashMap<String, Object> sundryBalMap = null;
        HashMap<String, Object> recvbleMap = null;
        double amount = 0.0;
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Inside gbf_post_ribca_det_rcp...");
            tranId = (String)hdrMap.get("tran_id");
            tranType = (String)hdrMap.get("tran_type");
            tranDate = (Timestamp)hdrMap.get("tran_date");
            effDate = (Timestamp)hdrMap.get("eff_date");
            finEntityTo = (String)hdrMap.get("fin_entity__to");
            siteCodeTo = (String)hdrMap.get("site_code__to");
            int i = 0;
            while (i < expDetList.size()) {
                detMap = (HashMap)expDetList.get(i);
                glTraceMap = new HashMap<String, Object>();
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "R-IBCA");
                glTraceMap.put("tran_date", tranDate);
                glTraceMap.put("eff_date", effDate);
                glTraceMap.put("fin_entity", finEntityTo);
                glTraceMap.put("site_code", siteCodeTo);
                glTraceMap.put("sundry_type", "C");
                glTraceMap.put("sundry_code", (String)detMap.get("cust_code"));
                glTraceMap.put("acct_code", (String)detMap.get("acct_code"));
                glTraceMap.put("cctr_code", (String)detMap.get("cctr_code"));
                glTraceMap.put("emp_code", "");
                glTraceMap.put("anal_code", "");
                glTraceMap.put("curr_code", (String)detMap.get("curr_code"));
                glTraceMap.put("exch_rate", (Double)detMap.get("exch_rate"));
                amount = (Double)detMap.get("tot_amt");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@@tot_amt [" + amount + "]"));
                if (amount > 0.0) {
                    glTraceMap.put("dr_amt", amount);
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", 0.0 - amount);
                }
                refSer = (String)detMap.get("ref_no");
                refNo = (String)detMap.get("ref_ser");
                remarks = ((String)hdrMap.get("remarks")).trim();
                if (remarks.length() > 40) {
                    remarks = remarks.substring(0, 40);
                }
                remarks = String.valueOf(remarks) + ' ' + refSer.trim() + ':' + refNo.trim();
                glTraceMap.put("remarks", detMap.get("remarks"));
                glTraceMap.put("party_doc_ref", this.finCommon.gfGetPartyDocRef(refSer, refNo, conn));
                sundryBalMap = new HashMap<String, Object>();
                sundryBalMap.put("tran_date", tranDate);
                sundryBalMap.put("eff_date", effDate);
                sundryBalMap.put("fin_entity", finEntityTo);
                sundryBalMap.put("site_code", siteCodeTo);
                sundryBalMap.put("sundry_type", "C");
                sundryBalMap.put("sundry_code", (String)glTraceMap.get("sundry_code"));
                sundryBalMap.put("acct_code", (String)glTraceMap.get("acct_code"));
                sundryBalMap.put("cctr_code", (String)glTraceMap.get("cctr_code"));
                sundryBalMap.put("curr_code", (String)glTraceMap.get("curr_code"));
                sundryBalMap.put("exch_rate", (Double)glTraceMap.get("exch_rate"));
                sundryBalMap.put("dr_amt", (Double)glTraceMap.get("dr_amt"));
                sundryBalMap.put("cr_amt", (Double)glTraceMap.get("cr_amt"));
                sundryBalMap.put("adv_amt", 0.0);
                refNo = (String)detMap.get("ref_no");
                sql = " select count(*) from receivables where tran_ser like 'R-IBC%' and ref_no = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, refNo);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                refSer = count == 0 ? "R-IBCA" : "R-IBC" + count;
                recvbleMap = new HashMap<String, Object>();
                recvbleMap.put("tran_ser", refSer);
                recvbleMap.put("tran_date", tranDate);
                recvbleMap.put("eff_date", effDate);
                recvbleMap.put("fin_entity", finEntityTo);
                recvbleMap.put("site_code", siteCodeTo);
                recvbleMap.put("ref_no", detMap.get("ref_no"));
                recvbleMap.put("ref_date", detMap.get("ref_date"));
                recvbleMap.put("due_date", detMap.get("due_date"));
                recvbleMap.put("curr_code", (String)glTraceMap.get("curr_code"));
                recvbleMap.put("exch_rate", (Double)glTraceMap.get("exch_rate"));
                recvbleMap.put("cust_code", (String)detMap.get("cust_code"));
                recvbleMap.put("acct_code", (String)glTraceMap.get("acct_code"));
                recvbleMap.put("cctr_code", (String)glTraceMap.get("cctr_code"));
                recvbleMap.put("tax_amt", (Double)detMap.get("tax_amt"));
                recvbleMap.put("discount", (Double)detMap.get("discount"));
                recvbleMap.put("tot_amt", (Double)detMap.get("tot_amt"));
                recvbleMap.put("auto_rcp", (String)detMap.get("auto_rcp"));
                recvbleMap.put("bank_code", (String)detMap.get("bank_code"));
                recvbleMap.put("ref_type", (String)detMap.get("ref_type"));
                recvbleMap.put("cr_term", (String)detMap.get("cr_term"));
                recvbleMap.put("item_ser", (String)detMap.get("item_ser"));
                recvbleMap.put("sales_pers", (String)detMap.get("sales_pers"));
                recvbleMap.put("ref_ser__org", (String)detMap.get("ref_ser__org"));
                recvbleMap.put("gp_no", (String)detMap.get("gp_no"));
                recvbleMap.put("gp_date", (Timestamp)detMap.get("gp_date"));
                recvbleMap.put("cust_ref_no", (String)detMap.get("cust_ref_no"));
                SimpleDateFormat sdfAppl = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
                String cust_ref_date = "";
                if (detMap.get("cust_ref_date") != null) {
                    cust_ref_date = sdfAppl.format(detMap.get("cust_ref_date"));
                }
                BaseLogger.log((String)"3", null, null, (Object)("detMap.custRefDate:::[" + detMap.get("cust_ref_date") + "]"));
                BaseLogger.log((String)"3", null, null, (Object)("custRefDate::[" + cust_ref_date + "]"));
                recvbleMap.put("cust_ref_date", cust_ref_date.toString());
                recvbleMap.put("cust_ref_amt", (String)detMap.get("cust_ref_amt"));
                recvbleMap.put("discount_date", (String)detMap.get("discount_dt"));
                recvbleMap.put("mrp_value", 0.0);
                retString = this.finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postRibcaDetRcp gbf_sundrybal_upd retStrng[" + retString + "]"));
                if (retString.trim().length() == 0) {
                    retString = this.finCommon.glTraceUpdate(glTraceMap, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postRibcaDetRcp glTraceUpdate retStrng[" + retString + "]"));
                    if (retString.trim().length() == 0) {
                        retString = this.finCommon.gbfReceivablesUpd(recvbleMap, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postRibcaDetRcp gbfReceivablesUpd retStrng[" + retString + "]"));
                        if (retString != null && retString.trim().length() > 0) {
                            String string = retString;
                            return string;
                        }
                    }
                }
                try {
                    ++i;
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Expcetion inside gbf_post_ribca_det_rcp ==>" + e.getMessage()));
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retString;
    }

    public String checkNullAndTrim(String inputVal) {
        inputVal = inputVal == null ? "" : inputVal.trim();
        return inputVal;
    }
}

