/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.PdcReceivedConfLocal;
import ibase.webitm.ejb.fin.adv.PdcReceivedConfRemote;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;

public class PdcReceivedConf
extends ActionHandlerEJB
implements PdcReceivedConfLocal,
PdcReceivedConfRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();

    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String errString = "";
        Connection conn = null;
        try {
            errString = this.confirm(tranId, xtraParams, forcedFlag, conn);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in confirm() ==>" + e.getMessage()));
            errString = this.genericUtility.createErrorString(e);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString in cofirm() ==>" + errString));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        String errString = "";
        String loginEmpCode = "";
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"confirm called........@@@");
        String sql = "";
        String status = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        ITMDBAccessEJB itmDBAccessEJB = null;
        ValidatorEJB validatorEJB = null;
        boolean connStatus = false;
        boolean isValTran = false;
        try {
            if (conn == null) {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                conn = this.getConnection();
                conn.setAutoCommit(false);
                connDriver = null;
                connStatus = true;
            }
            finCommon = new FinCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            validatorEJB = new ValidatorEJB();
            sql = "select status from pdc_received where  tran_id=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                String string = errString = itmDBAccessEJB.getErrorString("", "VTLCKERR", "", "", conn);
                return string;
            }
            isValTran = true;
            status = rs.getString("status") == null ? " " : rs.getString("status");
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (!isValTran) {
                String string = errString = itmDBAccessEJB.getErrorString("", "VTMCONF20", "", "", conn);
                return string;
            }
            if ("E".equalsIgnoreCase(status)) {
                errString = this.gbfRetrievePdcReceived(tranId, xtraParams, conn);
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
            } else {
                if ("C".equalsIgnoreCase(status)) {
                    String string = errString = itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                    return string;
                }
                if ("P".equalsIgnoreCase(status)) {
                    String string = errString = itmDBAccessEJB.getErrorString("", "VTPROC", "", "", conn);
                    return string;
                }
                if ("X".equalsIgnoreCase(status)) {
                    String string = errString = itmDBAccessEJB.getErrorString("", "VTCANC02", "", "", conn);
                    return string;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception ::" + e.getMessage()));
            errString = genericUtility.createErrorString(e);
            e.printStackTrace();
            try {
                conn.rollback();
            }
            catch (Exception e1) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Exception while rollbacking222.......");
            }
            throw new ITMException(e);
        }
        finally {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY PdcGivenConf confirm MATHOD333@#......>>[" + connStatus + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY PdcGivenConf confirm errString@#......>>[" + errString + "]"));
            try {
                if (errString != null && errString.trim().length() > 0) {
                    if (errString.indexOf("VTCICONF3") > -1) {
                        if (connStatus) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Transaction commited111.............from PdcGivenConf");
                            conn.commit();
                        }
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollbacking......................................");
                        conn.rollback();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollback......................................");
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connStatus) {
                    conn.close();
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String gbfRetrievePdcReceived(String tranId, String xtraParams, Connection conn) throws RemoteException, ITMException {
        String errCode = "";
        String loginEmpCode = "";
        String sql = "";
        String status = "";
        String acctCodeAdv = "";
        String cctrCodeAdv = "";
        String lsRefSer = "";
        String lsRefNo = "";
        double advAmt = 0.0;
        double amount = 0.0;
        double lcAmount = 0.0;
        double lcOldamount = 0.0;
        double lcTotamt = 0.0;
        double lcAdjamt = 0.0;
        double lcOldamountAdj = 0.0;
        Statement pstmt = null;
        ResultSet rs = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        itmDBAccessEJB = new ITMDBAccessEJB();
        E12GenericUtility genericUtility = new E12GenericUtility();
        FinCommon finCommon = null;
        HashMap DetMap = null;
        ArrayList<HashMap> DetList = new ArrayList<HashMap>();
        ValidatorEJB validatorEJB = null;
        try {
            validatorEJB = new ValidatorEJB();
            finCommon = new FinCommon();
            loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            sql = "select status, adv_amt, amount, acct_code__adv, cctr_code__adv from pdc_received where tran_id=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                status = rs.getString("status") == null ? " " : rs.getString("status");
                advAmt = rs.getDouble("adv_amt");
                amount = rs.getDouble("amount");
                acctCodeAdv = rs.getString("acct_code__adv") == null ? " " : rs.getString("acct_code__adv");
                cctrCodeAdv = rs.getString("cctr_code__adv") == null ? " " : rs.getString("cctr_code__adv");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if ("E".equalsIgnoreCase(status)) {
                if (advAmt < 0.0) {
                    String string = errCode = itmDBAccessEJB.getErrorString("", "VTRCPADV1", "", "", conn);
                    return string;
                }
                if (amount <= 0.0) {
                    String string = errCode = itmDBAccessEJB.getErrorString("", "VMAMT", "", "", conn);
                    return string;
                }
                if (advAmt > 0.0) {
                    if (acctCodeAdv == null || acctCodeAdv.trim().length() == 0) {
                        String string = errCode = itmDBAccessEJB.getErrorString("", "VTACCADV1", "", "", conn);
                        return string;
                    }
                    if (cctrCodeAdv == null || cctrCodeAdv.trim().length() == 0) {
                        String string = errCode = itmDBAccessEJB.getErrorString("", "VTCCTADV1", "", "", conn);
                        return string;
                    }
                }
                sql = "SELECT TRAN_ID,REF_SER,REF_NO,DUE_DATE,CURR_CODE,EXCH_RATE,AMOUNT,AMOUNT__BC,ACCT_CODE,CCTR_CODE,REF_DATE,LINE_NO FROM PDC_RECDET WHERE tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    DetMap = new HashMap();
                    DetMap.put("TRAN_ID", tranId);
                    DetMap.put("REF_SER", rs.getString("REF_SER"));
                    DetMap.put("REF_NO", rs.getString("REF_NO"));
                    DetMap.put("DUE_DATE", rs.getTimestamp("DUE_DATE"));
                    DetMap.put("CURR_CODE", rs.getString("CURR_CODE"));
                    DetMap.put("EXCH_RATE", rs.getDouble("EXCH_RATE"));
                    DetMap.put("AMOUNT", rs.getDouble("AMOUNT"));
                    DetMap.put("AMOUNT__BC", rs.getDouble("AMOUNT__BC"));
                    DetMap.put("ACCT_CODE", rs.getString("ACCT_CODE"));
                    DetMap.put("CCTR_CODE", rs.getString("CCTR_CODE"));
                    DetMap.put("LINE_NO", rs.getDouble("LINE_NO"));
                    DetList.add(DetMap);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetMap....." + DetMap));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList....." + DetList));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList....." + DetList.size()));
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                int i = 0;
                while (i < DetList.size()) {
                    DetMap = (HashMap)DetList.get(i);
                    lsRefSer = (String)DetMap.get("REF_SER");
                    lsRefNo = (String)DetMap.get("REF_NO");
                    lcAmount = Double.parseDouble("" + DetMap.get("AMOUNT"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lsRefSer.....@" + lsRefSer + "..lsRefNo....." + lsRefNo + "..lcAmount...." + lcAmount));
                    sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) || "mysql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "select pdc_amount,tot_amt,adj_amt, pdc_amount_adj from receivables where tran_ser = ? and ref_no =? and line_no__ref = 1 for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "select pdc_amount,tot_amt,adj_amt, pdc_amount_adj from receivables (updlock) where tran_ser = ? and ref_no =? and line_no__ref = 1" : " select pdc_amount,tot_amt,adj_amt, pdc_amount_adj from receivables where tran_ser = ? and ref_no =? and line_no__ref = 1 for update nowait");
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, lsRefSer);
                    pstmt.setString(2, lsRefNo);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        rs.close();
                        pstmt.close();
                        String string = errCode = itmDBAccessEJB.getErrorString("", "VTLCKERR", "", "", conn);
                        return string;
                    }
                    lcOldamount = rs.getDouble("pdc_amount");
                    lcTotamt = rs.getDouble("tot_amt");
                    lcAdjamt = rs.getDouble("adj_amt");
                    lcOldamountAdj = rs.getDouble("pdc_amount_adj");
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lcOldamount......" + lcOldamount + "...lcTotamt....." + lcTotamt + "...lcAdjamt...." + lcAdjamt + "..lcOldamountAdj..." + lcOldamountAdj));
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    if (finCommon.getRequiredDecimal(lcAmount, 2) > finCommon.getRequiredDecimal(lcTotamt - lcAdjamt - lcOldamount + lcOldamountAdj, 2)) {
                        String string = errCode = itmDBAccessEJB.getErrorString("", "VTAMT", "", "", conn);
                        return string;
                    }
                    sql = "update receivables set pdc_amount = ? + ? where tran_ser = ? and ref_no =? and line_no__ref = 1";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setDouble(1, lcOldamount);
                    pstmt.setDouble(2, lcAmount);
                    pstmt.setString(3, lsRefSer);
                    pstmt.setString(4, lsRefNo);
                    int upd = pstmt.executeUpdate();
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + upd));
                    pstmt.close();
                    pstmt = null;
                    ++i;
                }
                sql = "update pdc_received set status='C' ,status_date= ?,emp_code__aprv=? where tran_id=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(2, loginEmpCode);
                pstmt.setString(3, tranId);
                int upd = pstmt.executeUpdate();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + upd));
                pstmt.close();
                pstmt = null;
                if (upd > 0) {
                    errCode = itmDBAccessEJB.getErrorString("", "VTCICONF3", "", "", conn);
                }
            }
            if ("C".equalsIgnoreCase(status)) {
                String string = errCode = itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            if ("P".equalsIgnoreCase(status)) {
                String string = errCode = itmDBAccessEJB.getErrorString("", "VTPROC", "", "", conn);
                return string;
            }
            if ("X".equalsIgnoreCase(status)) {
                String string = errCode = itmDBAccessEJB.getErrorString("", "VTCANC02", "", "", conn);
                return string;
            }
        }
        catch (SQLException e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :PdcReceivedConf :gbfRetrievePdcReceived :SQLException :==>\n" + e.getMessage()));
            errCode = genericUtility.createErrorString((Exception)e);
            throw new ITMException((Exception)e);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :PdcReceivedConf :gbfRetrievePdcReceived :==>" + e.getMessage()));
            errCode = genericUtility.createErrorString(e);
            throw new ITMException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errCode;
    }
}

