/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.ejb.Stateless;
import org.w3c.dom.Document;

@Stateless
public class PaymentExpenseConf
extends ActionHandlerEJB {
    FinCommon finCommon = new FinCommon();
    UtilMethods utilMethod = new UtilMethods();
    ValidatorEJB validatorEJB = new ValidatorEJB();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
    DistCommon distCommon = new DistCommon();
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String errString = "";
        Connection conn = null;
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(">>>>>>tranId[" + tranId + "]"));
            errString = this.confirm(tranId, xtraParams, forcedFlag, conn);
        }
        catch (Exception e) {
            errString = this.genericUtility.createErrorString(e);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString in confirm() ==>[" + errString + "]"));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Direct Payments confirm called........@@@@");
        String sql = "";
        String confirm = "";
        String siteCode = "";
        String errString = "";
        String loginEmpCode = "";
        Statement pstmt = null;
        ResultSet rs = null;
        boolean connStatus = false;
        Boolean isValTran = false;
        String chgUser = "";
        String directPayPaid = "";
        double netAmt = 0.0;
        double netAmtPaid = 0.0;
        try {
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                connStatus = true;
            }
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            siteCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("96@ siteCode --[" + siteCode + "]loginEmpCode[" + loginEmpCode + "]tran id [" + tranId + "]"));
            directPayPaid = this.checkNull(this.finCommon.getFinparams("999999", "DIRECT_PAY_PAID", conn));
            if ("NULLFOUND".equalsIgnoreCase(directPayPaid)) {
                directPayPaid = "N";
            }
            sql = "select confirmed, net_amt, net_amt__paid, site_code from payment_exp where tran_id = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                isValTran = true;
                confirm = rs.getString("confirmed") == null ? "N" : rs.getString("confirmed");
                netAmt = rs.getDouble("net_amt");
                netAmtPaid = rs.getDouble("net_amt__paid");
                siteCode = this.checkNull(rs.getString("site_code"));
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            if (!isValTran.booleanValue()) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTMCONF20", "", "", conn);
                return string;
            }
            if (netAmt != netAmtPaid && "P".equalsIgnoreCase(confirm)) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTPAYDIFF", "", "", conn);
                return string;
            }
            if ("Y".equalsIgnoreCase(directPayPaid) && "P".equalsIgnoreCase(confirm) || "N".equalsIgnoreCase(directPayPaid) && "N".equalsIgnoreCase(confirm)) {
                errString = this.gbfRetrieveExpPay(tranId, siteCode, xtraParams, conn);
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
            } else {
                if ("Y".equalsIgnoreCase(directPayPaid) && "N".equalsIgnoreCase(confirm)) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"testing>>>>VTPAID1>>>>>");
                    String string = errString = this.itmDBAccessEJB.getErrorString("", "VTPAID1", "", "", conn);
                    return string;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Error String from main confirm method.....[" + errString + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception ::[" + e.getMessage() + "]"));
                errString = this.genericUtility.createErrorString(e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Exception while rollbacking in catch confirm method");
                }
                throw new ITMException(e);
            }
        }
        finally {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY PaymentExpenseconf confirm connStatus[" + connStatus + "]errString[" + errString + "]"));
            try {
                if (errString != null && errString.trim().length() > 0) {
                    if (errString.indexOf("VTCICONF3") > -1) {
                        if (connStatus) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Transaction commited111.............from PaymentExpenseconf");
                            conn.commit();
                        }
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollbacking......................................");
                        conn.rollback();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollback......................................");
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connStatus) {
                    conn.close();
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : [" + e + "]"));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String gbfRetrieveExpPay(String tranId, String siteCode, String xtraParams, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfRetrieveExpPay() method called>>>>>");
        Statement pstmt = null;
        Statement pstmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        Timestamp today = null;
        Timestamp tranDate = null;
        HashMap<String, Object> HdrMap = null;
        HashMap<String, Object> DetMap = null;
        ArrayList DetList = new ArrayList();
        String loginEmpCode = "";
        double netAmtHdr = 0.0;
        double netAmtSumDet = 0.0;
        String bankCode = "";
        String ignoreChkLimit = "";
        String tranIDPayExp = "";
        String sql = "";
        String errString = "";
        ArrayList<String> tranIDList = new ArrayList<String>();
        try {
            loginEmpCode = this.validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            today = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
            tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today)) + " 00:00:00.000");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("loginEmpCode[" + loginEmpCode + "]today[" + today + "]tranDate[" + tranDate + "]siteCode[" + siteCode + "]tranId[" + tranId + "]"));
            if (loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "EMPAPRV", "", "", conn);
                return string;
            }
            sql = "SELECT tran_id FROM payment_exp where tran_id >= ? and tran_id <= ? and  site_code =  ? and (confirmed = 'N' or confirmed = 'P') ORDER BY tran_id ASC ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            pstmt.setString(2, tranId);
            pstmt.setString(3, siteCode);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                tranIDPayExp = rs.getString("tran_id");
                tranIDList.add(tranIDPayExp);
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("275@ tranIDList[" + tranIDList.toString() + "]"));
            int i = 0;
            while (i < tranIDList.size()) {
                tranIDPayExp = (String)tranIDList.get(i);
                sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? " select tran_id, net_amt, bank_code, site_code, tran_date from payment_exp where tran_id = ? for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "select tran_id, net_amt, bank_code, site_code, tran_date from payment_exp (updlock) where tran_id = ? " : " select tran_id, net_amt, bank_code, site_code, tran_date from payment_exp where tran_id = ? for update nowait ");
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranIDPayExp);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    tranIDPayExp = rs.getString("tran_id") == null ? " " : rs.getString("tran_id");
                    netAmtHdr = rs.getDouble("net_amt");
                    bankCode = this.checkNull(rs.getString("bank_code"));
                    siteCode = this.checkNull(rs.getString("site_code"));
                    tranDate = rs.getTimestamp("tran_date");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("314@ tranIDPayExp [" + tranIDPayExp + "] netAmtHdr [" + netAmtHdr + "]bankCode[" + bankCode + "]siteCode[" + siteCode + "]tranDate[" + tranDate + "]"));
                sql = "select sum(net_amt) from paydet_exp where tran_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranIDPayExp);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    netAmtSumDet = rs.getDouble(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("334@ netAmtSumDet [" + netAmtSumDet + "]"));
                if (netAmtHdr != netAmtSumDet) {
                    String string = errString = this.itmDBAccessEJB.getErrorString("", "VTPOST2", "", "", conn);
                    return string;
                }
                ignoreChkLimit = this.finCommon.getFinparams("999999", "IGNORE_WARNINGS", conn);
                if (ignoreChkLimit == null || ignoreChkLimit.trim().length() == 0 || "NULLFOUND".equalsIgnoreCase(ignoreChkLimit)) {
                    ignoreChkLimit = "N";
                }
                if ("N".equalsIgnoreCase(ignoreChkLimit)) {
                    errString = this.finCommon.gbfBalChk(bankCode, siteCode, tranDate, netAmtHdr, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("350@ errString after calling gbfBalChk()[" + errString + "]"));
                    if (errString != null && errString.trim().length() > 0) {
                        String string = errString;
                        return string;
                    }
                }
                sql = " Select tran_id, tran_date, tran_type, eff_date, sundry_type, sundry_code, site_code, fin_entity, pay_mode, ref_no, ref_date, bank_code, dlv_mode, dlv_ref, curr_code, net_amt,  net_amt__bc, acct_code__bal, cctr_code__bal, proj_code, confirmed, conf_date, remarks, emp_code__aprv, chg_date, chg_user, chg_term, exch_rate, net_amt__paid, chq_name,  purc_order, tax_amt, amount, tax_date, add_date, add_user, add_term, wf_status FROM payment_exp WHERE  tran_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranIDPayExp);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    HdrMap = new HashMap<String, Object>();
                    HdrMap.put("tran_id", tranId);
                    HdrMap.put("tran_date", rs.getTimestamp("tran_date"));
                    HdrMap.put("tran_type", rs.getString("tran_type"));
                    HdrMap.put("eff_date", rs.getTimestamp("eff_date"));
                    HdrMap.put("sundry_type", rs.getString("sundry_type"));
                    HdrMap.put("sundry_code", rs.getString("sundry_code"));
                    HdrMap.put("site_code", rs.getString("site_code"));
                    HdrMap.put("fin_entity", rs.getString("fin_entity"));
                    HdrMap.put("pay_mode", rs.getString("pay_mode"));
                    HdrMap.put("ref_no", rs.getString("ref_no"));
                    HdrMap.put("ref_date", rs.getTimestamp("ref_date"));
                    HdrMap.put("bank_code", rs.getString("bank_code"));
                    HdrMap.put("dlv_mode", rs.getString("dlv_mode"));
                    HdrMap.put("dlv_ref", rs.getString("dlv_ref"));
                    HdrMap.put("curr_code", rs.getString("curr_code"));
                    HdrMap.put("net_amt", rs.getDouble("net_amt"));
                    HdrMap.put("net_amt__bc", rs.getDouble("net_amt__bc"));
                    HdrMap.put("acct_code__bal", rs.getString("acct_code__bal"));
                    HdrMap.put("cctr_code__bal", rs.getString("cctr_code__bal"));
                    HdrMap.put("proj_code", rs.getString("proj_code"));
                    HdrMap.put("confirmed", rs.getString("confirmed"));
                    HdrMap.put("conf_date", rs.getTimestamp("conf_date"));
                    HdrMap.put("remarks", rs.getString("remarks"));
                    HdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
                    HdrMap.put("exch_rate", rs.getDouble("exch_rate"));
                    HdrMap.put("net_amt__paid", rs.getDouble("net_amt__paid"));
                    HdrMap.put("chq_name", rs.getString("chq_name"));
                    HdrMap.put("purc_order", rs.getString("purc_order"));
                    HdrMap.put("tax_amt", rs.getDouble("tax_amt"));
                    HdrMap.put("amount", rs.getDouble("amount"));
                    HdrMap.put("tax_date", rs.getTimestamp("tax_date"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" Header Map..........[" + HdrMap.toString() + "]"));
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                tranId = (String)HdrMap.get("tran_id");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("409@ tranId[" + tranId + "]"));
                sql = " SELECT PAYDET_EXP.TRAN_ID, PAYDET_EXP.LINE_NO, PAYDET_EXP.ACCT_CODE, PAYDET_EXP.CCTR_CODE, PAYDET_EXP.AMOUNT, PAYDET_EXP.REMARKS, PAYDET_EXP.EMP_CODE, PAYDET_EXP.ANAL_CODE, PAYDET_EXP.TAX_CLASS, PAYDET_EXP.TAX_CHAP,  PAYDET_EXP.TAX_ENV, PAYDET_EXP.TAX_AMT, PAYDET_EXP.NET_AMT, PAYDET_EXP.PROJ_CODE  FROM PAYDET_EXP, ACCOUNTS ACCOUNTS_A, COSTCTR COSTCTR_A, ANALYSIS ANALYSIS_A, PAYMENT_EXP, ANALYSIS ANALYSIS_B, ACCOUNTS ACCOUNTS_B, COSTCTR COSTCTR_B  WHERE  paydet_exp.cctr_code = costctr_a.cctr_code (+) and  paydet_exp.anal_code = analysis_a.anal_code (+) and  payment_exp.anal_code = analysis_b.anal_code (+) and  payment_exp.cctr_code__bal = costctr_b.cctr_code (+) and  PAYDET_EXP.ACCT_CODE = ACCOUNTS_A.ACCT_CODE and   PAYMENT_EXP.TRAN_ID = PAYDET_EXP.TRAN_ID and  PAYMENT_EXP.ACCT_CODE__BAL = ACCOUNTS_B.ACCT_CODE and  PAYDET_EXP.TRAN_ID = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    DetMap = new HashMap<String, Object>();
                    DetMap.put("tran_id", rs.getString("TRAN_ID"));
                    DetMap.put("line_no", rs.getString("LINE_NO"));
                    DetMap.put("acct_code", rs.getString("ACCT_CODE"));
                    DetMap.put("cctr_code", rs.getString("CCTR_CODE"));
                    DetMap.put("amount", rs.getDouble("AMOUNT"));
                    DetMap.put("remarks", rs.getString("REMARKS"));
                    DetMap.put("emp_code", rs.getString("EMP_CODE"));
                    DetMap.put("anal_code", rs.getString("ANAL_CODE"));
                    DetMap.put("tax_class", rs.getString("TAX_CLASS"));
                    DetMap.put("tax_chap", rs.getString("TAX_CHAP"));
                    DetMap.put("tax_env", rs.getString("TAX_ENV"));
                    DetMap.put("tax_amt", rs.getDouble("TAX_AMT"));
                    DetMap.put("net_amt", rs.getDouble("NET_AMT"));
                    DetMap.put("proj_code", rs.getString("PROJ_CODE"));
                    DetList.add(DetMap);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("450@ DetMap.toString()[" + DetMap.toString() + "]"));
                errString = this.gbfPostExpPay(tranId, HdrMap, DetList, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString after gbfPostExpPay called[" + errString + "]"));
                ++i;
            }
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in catch :gbfRetrieveExpPay :==>" + e.getMessage() + "]"));
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                    pstmt1 = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in finally catch>>>>>" + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String gbfPostExpPay(String tranId, HashMap HdrMap, ArrayList DetList, String xtraParams, Connection conn) throws RemoteException, ITMException {
        Statement pstmt = null;
        ResultSet rs = null;
        boolean upd = false;
        Date toDay = new Date();
        Timestamp tranDate = null;
        SimpleDateFormat sdf = null;
        String loginEmpCode = "";
        String confirmed = "";
        String chgUser = "";
        String chgTerm = "";
        String userid = "";
        String errString = "";
        String sql = "";
        String postOnline = "";
        String loginSiteCode = "";
        String currDateStr = "";
        try {
            sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
            chgUser = this.checkNullAndTrim(this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
            chgTerm = this.checkNullAndTrim(this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            loginSiteCode = this.checkNullAndTrim(this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
            tranDate = new Timestamp(System.currentTimeMillis());
            currDateStr = sdf.format(tranDate);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("521@ tranId[" + tranId + "]chgUser[" + chgUser + "]chgTerm[" + chgTerm + "]loginEmpCode[" + loginEmpCode + "]" + "loginSiteCode[" + loginSiteCode + "]currDateStr[" + currDateStr + "]"));
            if (chgTerm == null || chgTerm.trim().length() == 0) {
                chgTerm = "SYSTEM";
            }
            errString = this.gbfPostExpPayhdr(tranId, HdrMap, DetList, xtraParams, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString after calling gbfPostExpPayhdr ::[ " + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            errString = this.gbfPostExpPaydet(tranId, HdrMap, DetList, xtraParams, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString after calling gbfPostExpPaydet ::[ " + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            postOnline = this.checkNullAndTrim(this.finCommon.getFinparams("999999", "POST_ON_LINE", conn));
            if ("Y".equalsIgnoreCase(postOnline)) {
                errString = this.finCommon.checkGlTranDrCr("E-PAY", tranId, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString after calling checkGlTranDrCr ::[ " + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
            }
            if (!"Y".equalsIgnoreCase(confirmed = (String)HdrMap.get("confirmed"))) {
                sql = "update payment_exp set confirmed = 'Y', conf_date = ?, emp_code__aprv = ? where tran_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setTimestamp(1, tranDate);
                pstmt.setString(2, loginEmpCode);
                pstmt.setString(3, tranId);
                int updcnt = pstmt.executeUpdate();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@606 no of row update = [ " + updcnt + "]"));
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (updcnt > 0) {
                    errString = this.itmDBAccessEJB.getErrorString("", "VTCICONF3", "", "", conn);
                }
            } else {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Error String from gbfPostExpPay method.....[" + errString + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :PaymentExpenseConf :gbfPostExpPay:==>[" + e.getMessage() + "]"));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : [" + e + "]"));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String gbfPostExpPayhdr(String tranId, HashMap HdrMap, ArrayList detailList, String xtraParams, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"654>>>>Inside gbfPostExpPayhdr ");
        HashMap<String, Object> glTraceMap = null;
        HashMap<String, Object> sundryBalMap = null;
        HashMap<String, Object> bankTranMap = null;
        Statement pstmt = null;
        Statement pstmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        String errString = "";
        String loginEmpCode = "";
        String finEntity = "";
        String siteCode = "";
        String tranSer = "";
        String suppCode = "";
        String acctCode = "";
        String cctrCode = "";
        String analCode = "";
        String currCode = "";
        String remarks = "";
        String drcrFlag = "";
        String sql = "";
        String bankCode = "";
        String projCode = "";
        String keystr = "";
        String xmlString = "";
        String partyDocPref = "";
        String refSer = "";
        String refNo = "";
        String confirmed = "";
        Object effDate = null;
        Object refDate = null;
        Timestamp tranDate = null;
        Timestamp today = null;
        String dataStr = "";
        int ediOption = 0;
        double netAmount = 0.0;
        double exchRate = 0.0;
        try {
            today = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
            tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today)) + " 00:00:00.000");
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("639@ tranId[" + tranId + "]loginEmpCode[" + loginEmpCode + "]tranDate[" + tranDate + "]"));
            glTraceMap = new HashMap<String, Object>();
            glTraceMap.put("tran_date", (Timestamp)HdrMap.get("tran_date"));
            glTraceMap.put("eff_date", (Timestamp)HdrMap.get("eff_date"));
            glTraceMap.put("fin_entity", HdrMap.get("fin_entity"));
            glTraceMap.put("site_code", HdrMap.get("site_code"));
            glTraceMap.put("sundry_type", Character.valueOf('B'));
            glTraceMap.put("sundry_code", HdrMap.get("bank_code"));
            glTraceMap.put("acct_code", HdrMap.get("acct_code__bal"));
            glTraceMap.put("cctr_code", HdrMap.get("cctr_code__bal"));
            glTraceMap.put("emp_code", "");
            glTraceMap.put("anal_code", "");
            glTraceMap.put("curr_code", HdrMap.get("curr_code"));
            glTraceMap.put("exch_rate", HdrMap.get("exch_rate"));
            String string = HdrMap.get("net_amt") == null ? "0.00" : HdrMap.get("net_amt").toString();
            if (Double.valueOf(string) > 0.0) {
                glTraceMap.put("dr_amt", 0.0);
                glTraceMap.put("cr_amt", HdrMap.get("net_amt"));
            } else {
                glTraceMap.put("dr_amt", 0.0 - (Double)HdrMap.get("net_amt"));
                glTraceMap.put("cr_amt", 0.0);
            }
            glTraceMap.put("ref_type", "F");
            glTraceMap.put("ref_ser", "E-PAY");
            glTraceMap.put("ref_id", HdrMap.get("tran_id"));
            glTraceMap.put("remarks", HdrMap.get("remarks"));
            glTraceMap.put("proj_code", HdrMap.get("proj_code"));
            refSer = (String)glTraceMap.get("ref_ser");
            refNo = (String)glTraceMap.get("ref_id");
            partyDocPref = this.finCommon.gfGetPartyDocRef(refSer, refNo, conn);
            glTraceMap.put("party_doc_ref", partyDocPref);
            errString = this.finCommon.glTraceUpdate(glTraceMap, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("734@ errString after glTraceUpdate called [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string2 = errString;
                return string2;
            }
            sundryBalMap = new HashMap<String, Object>();
            sundryBalMap.put("tran_date", (Timestamp)HdrMap.get("tran_date"));
            sundryBalMap.put("eff_date", (Timestamp)HdrMap.get("eff_date"));
            sundryBalMap.put("fin_entity", HdrMap.get("fin_entity"));
            sundryBalMap.put("site_code", HdrMap.get("site_code"));
            sundryBalMap.put("sundry_type", "B");
            sundryBalMap.put("sundry_code", HdrMap.get("bank_code"));
            sundryBalMap.put("acct_code", HdrMap.get("acct_code__bal"));
            sundryBalMap.put("cctr_code", HdrMap.get("cctr_code__bal"));
            sundryBalMap.put("curr_code", HdrMap.get("curr_code"));
            sundryBalMap.put("exch_rate", Double.parseDouble("" + HdrMap.get("exch_rate")));
            String string3 = HdrMap.get("net_amt") == null ? "0.00" : HdrMap.get("net_amt").toString();
            if (Double.valueOf(string3) > 0.0) {
                sundryBalMap.put("dr_amt", 0.0);
                sundryBalMap.put("cr_amt", HdrMap.get("net_amt"));
            } else {
                sundryBalMap.put("dr_amt", 0.0 - (Double)HdrMap.get("net_amt"));
                sundryBalMap.put("cr_amt", 0.0);
            }
            sundryBalMap.put("adv_amt", 0.0);
            sundryBalMap.put("contact_code", " ");
            errString = this.finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("766@ errString after gbf_sundrybal_upd called [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string4 = errString;
                return string4;
            }
            bankTranMap = new HashMap<String, Object>();
            bankTranMap.put("tran_date", (Timestamp)HdrMap.get("tran_date"));
            bankTranMap.put("tran_ser", "E-PAY");
            bankTranMap.put("tran_no", HdrMap.get("tran_id"));
            bankTranMap.put("bank_code", HdrMap.get("bank_code"));
            bankTranMap.put("ref_no", HdrMap.get("ref_no"));
            bankTranMap.put("ref_date", (Timestamp)HdrMap.get("ref_date"));
            bankTranMap.put("ref_mode", HdrMap.get("pay_mode"));
            String string5 = HdrMap.get("net_amt") == null ? "0.00" : HdrMap.get("net_amt").toString();
            if (Double.valueOf(string5) > 0.0) {
                bankTranMap.put("amount", HdrMap.get("net_amt"));
                bankTranMap.put("tran_type", "P");
            } else {
                bankTranMap.put("amount", 0.0 - (Double)HdrMap.get("net_amt"));
                bankTranMap.put("tran_type", "R");
            }
            bankTranMap.put("site_code", HdrMap.get("site_code"));
            bankTranMap.put("acct_code", HdrMap.get("acct_code__bal"));
            bankTranMap.put("cctr_code", HdrMap.get("cctr_code__bal"));
            bankTranMap.put("sundry_type", HdrMap.get("sundry_type"));
            bankTranMap.put("sundry_code", HdrMap.get("sundry_code"));
            bankTranMap.put("remarks", HdrMap.get("remarks"));
            bankTranMap.put("due_date", (Timestamp)HdrMap.get("tran_date"));
            bankTranMap.put("exch_rate", Double.parseDouble("" + HdrMap.get("exch_rate")));
            errString = this.finCommon.bankTranLogUpdate(bankTranMap, xtraParams, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("746@ errString after calling bankTranLogUpdate [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string6 = errString;
                return string6;
            }
            try {
                sql = " select edi_option from transetup where tran_window = 'w_payment_exp' ";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    ediOption = rs.getInt("edi_option");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ ediOption :-[" + ediOption + "]"));
                if (ediOption > 0) {
                    if (ediOption == 2) {
                        CreateRCPXML createRCPXML = new CreateRCPXML("w_payment_exp", "tran_id");
                        dataStr = createRCPXML.getTranXML(tranId, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr [" + dataStr + "]"));
                        Document ediDataDom = this.genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_payment_exp", "0", xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (errString != null && "SUCCESS".equals(errString)) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from batchload  [" + errString + "]"));
                        }
                    } else {
                        CreateRCPXML createRCPXML = new CreateRCPXML("w_payment_exp", "tran_id");
                        dataStr = createRCPXML.getTranXML(tranId, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr@ [" + dataStr + "]"));
                        Document ediDataDom = this.genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_payment_exp", "0", xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (errString != null && "SUCCESS".equals(errString)) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@@retString from batchload = [" + errString + "]"));
                        } else {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from batchload else [" + errString + "]"));
                        }
                    }
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("854@ [" + errString + "]"));
            }
            catch (Exception e) {
                System.out.println("Exception inside PaymentExpenseConf :gbfPostExpPayhdr==>" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                    pstmt1 = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : [" + e + "]"));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    /*
     * Exception decompiling
     */
    private String gbfPostExpPaydet(String tranId, HashMap HdrMap, ArrayList DetList, String xtraParams, Connection conn) throws RemoteException, ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[DOLOOP]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String[] string2StringArray(String str1, String delimeter) {
        StringTokenizer st = new StringTokenizer(str1, delimeter);
        int count = st.countTokens();
        String[] arry1 = new String[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            arry1[i] = st.nextToken();
            System.out.print("Token " + i + " :[" + arry1[i] + "]");
            ++i;
        }
        return arry1;
    }

    private String checkNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public String checkNullAndTrim(String inputVal) {
        inputVal = inputVal == null ? "" : inputVal.trim();
        return inputVal;
    }
}

