/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class PayableTraceDetails
extends ValidatorEJB {
    Connection conn = null;
    ArrayList traceData = null;
    HashMap payDetails = null;
    PreparedStatement pstmt = null;
    ResultSet rs = null;
    Timestamp refDate = null;
    Timestamp statDate = null;
    SimpleDateFormat formatter = null;
    E12GenericUtility genericUtility = new E12GenericUtility();

    public PayableTraceDetails(UserInfoBean infoBean) {
        this.setUserInfo(infoBean);
    }

    public ArrayList<HashMap> payTraceDetails(String tranSer, String refNo, UserInfoBean infoBean) throws ITMException {
        String sql = "";
        String errString = "";
        String newrefDate = "";
        String newStatDate = "";
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Tran ser: [" + tranSer + "]\n Ref No :[" + refNo + "]"));
        try {
            try {
                this.formatter = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
                this.conn = this.getConnection();
                this.traceData = new ArrayList();
                CallableStatement callStat = this.conn.prepareCall("{CALL DP_MPAY_TRACE_REFNO(?,?)}");
                callStat.setString(1, tranSer);
                callStat.setString(2, refNo);
                callStat.executeUpdate();
                sql = "select p.ref_ser ref_ser , p.ref_no ref_no, p.ref_date ref_date, p.status_date status_date, m.tot_amt tot_amt, p.adj_amt adj_amt, p.ref_ser__adj ref_ser__adj, p.ref_no__adj ref_no__adj, p.amt_before amt_before, p.amt_after amt_after, p.site_code site_code, s.descr descr, p.sundry_code sundry_code, DDF_GET_SUNDRY_NAME(p.sundry_code,p.syndry_type) as sundry_name from PAYABLES_TRACE p , site s , misc_payables m where p.site_code = s.site_code and m.tran_ser = p.ref_ser and m.ref_no = p.ref_no and p.ref_ser = ? and p.ref_no = ? order by p.tran_id";
                this.pstmt = this.conn.prepareStatement(sql);
                this.pstmt.setString(1, tranSer);
                this.pstmt.setString(2, refNo);
                this.rs = this.pstmt.executeQuery();
                while (this.rs.next()) {
                    this.payDetails = new HashMap();
                    this.refDate = this.rs.getTimestamp("ref_date");
                    this.statDate = this.rs.getTimestamp("status_date");
                    if (this.refDate != null && this.statDate != null) {
                        newrefDate = this.formatter.format(this.refDate);
                        newStatDate = this.formatter.format(this.statDate);
                    }
                    this.payDetails.put("tranSer", this.checkNullAndTrim(this.rs.getString("ref_ser")));
                    this.payDetails.put("refNo", this.checkNullAndTrim(this.rs.getString("ref_no")));
                    this.payDetails.put("refDate", newrefDate);
                    this.payDetails.put("totAmt", this.checkNullAndTrim(this.rs.getString("tot_amt")));
                    this.payDetails.put("adjAmt", this.checkNullAndTrim(this.rs.getString("adj_amt")));
                    this.payDetails.put("refSerAdj", this.checkNullAndTrim(this.rs.getString("ref_ser__adj")));
                    this.payDetails.put("refNoAdj", this.checkNullAndTrim(this.rs.getString("ref_no__adj")));
                    this.payDetails.put("amtBefore", this.checkNullAndTrim(this.rs.getString("amt_before")));
                    this.payDetails.put("amtAfter", this.checkNullAndTrim(this.rs.getString("amt_after")));
                    this.payDetails.put("statusDate", newStatDate);
                    this.payDetails.put("siteCode", this.checkNullAndTrim(this.rs.getString("site_code")));
                    this.payDetails.put("siteDescr", this.checkNullAndTrim(this.rs.getString("descr")));
                    this.payDetails.put("sundryName", this.checkNullAndTrim(this.rs.getString("sundry_name")));
                    this.payDetails.put("sundryCode", this.checkNullAndTrim(this.rs.getString("sundry_code")));
                    this.traceData.add(this.payDetails);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Trace Data::[" + this.traceData + "]"));
                }
                this.rs.close();
                this.rs = null;
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                errString = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    if (this.rs != null) {
                        this.rs.close();
                        this.rs = null;
                    }
                    if (this.pstmt != null) {
                        this.pstmt.close();
                        this.pstmt = null;
                    }
                    this.conn.close();
                }
                this.conn = null;
            }
            catch (Exception d) {
                d.printStackTrace();
                throw new ITMException(d);
            }
        }
        return this.traceData;
    }

    public String checkNullAndTrim(String input) {
        if (input == null) {
            input = "";
            return "";
        }
        return input.trim();
    }
}

