/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.PayIbcaConfLocal;
import ibase.webitm.ejb.fin.adv.PayIbcaConfRemote;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.Stateless;

@Stateless
public class PayIbcaConf
extends ActionHandlerEJB
implements PayIbcaConfLocal,
PayIbcaConfRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();
    FinCommon finCommon = new FinCommon();
    String tranId1 = "";

    @Override
    public String confirm(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String retString = "";
        boolean isConn = false;
        Connection conn = null;
        try {
            retString = this.confirm(tranID, xtraParams, forcedFlag, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString in PayIbcaConf::: [" + retString + "]"));
        }
        catch (Exception exception) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in [PayIbcaConf] confirm " + exception.getMessage()));
            throw new ITMException(exception);
        }
        return retString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"confirm called........");
        String sql = "";
        String confirm = "";
        String siteCode = "";
        String errString = "";
        String tranSer = "";
        String loginEmpCode = "";
        Statement pstmt = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tran id = " + tranId));
        this.tranId1 = tranId;
        boolean connStatus = false;
        String chgUser = "";
        Object tranDate = null;
        Timestamp today = null;
        try {
            if (conn == null) {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                conn = this.getConnection();
                conn.setAutoCommit(false);
                connDriver = null;
                connStatus = true;
            }
            finCommon = new FinCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Printing loginEmpCode---1-----" + loginEmpCode + "--"));
            sql = "select confirmed ,site_code__from as site_code,chg_user  from pay_ibca where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                confirm = rs.getString("confirmed") == null ? "N" : rs.getString("confirmed");
                siteCode = rs.getString("site_code") == null ? " " : rs.getString("site_code");
                chgUser = rs.getString("chg_user") == null ? " " : rs.getString("chg_user");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (chgUser == null || chgUser.trim().length() == 0) {
                chgUser = "SYSTEM";
            }
            if ("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                sql = "select emp_code from users where code=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, chgUser);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    loginEmpCode = rs.getString(1);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Printing loginEmpCode---2-----" + loginEmpCode + "--"));
            }
            if (confirm != null && confirm.equalsIgnoreCase("N")) {
                errString = this.gbfRetrievePibca(tranId, siteCode, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("err String from gdfRetrieveMiscRcp =" + errString));
                if (errString != null && errString.trim().length() > 0 && errString.indexOf("VTCICONF3") < 0) {
                    String string = errString;
                    return string;
                }
                if (errString != null && errString.trim().length() != 0 && errString.indexOf("VTCICONF3") <= -1) {
                    String string = errString;
                    return string;
                }
                if ("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                    loginEmpCode = "E03952";
                }
                today = new Timestamp(System.currentTimeMillis());
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("loginEmpCode--3-" + loginEmpCode));
                sql = "update pay_ibca set confirmed = 'Y', conf_date = ?,emp_code__aprv = ? where tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setTimestamp(1, today);
                pstmt.setString(2, loginEmpCode);
                pstmt.setString(3, tranId);
                int updateCoount = pstmt.executeUpdate();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + updateCoount));
                pstmt.close();
                pstmt = null;
                if (updateCoount > 0) {
                    errString = itmDBAccessEJB.getErrorString("", "VTCICONF3", "", "", conn);
                }
            } else {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                String string = errString = itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Error String from confirm method.....[" + errString + "]"));
            return errString;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("connStatus:: [" + connStatus + "]"));
                if (conn != null && !conn.isClosed() && connStatus) {
                    if (errString.indexOf("VTCICONF3") > -1) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    conn.close();
                    conn = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
    }

    private String gbfRetrievePibca(String tranId, String site, String xtraParams, Connection conn) throws ITMException {
        String errCode = "";
        String keyFld = "";
        String expHdr = "";
        String expDet = "";
        String winName = "";
        String ledgPostconf = "";
        String ledgPostConf = "";
        String sql = "";
        String sql1 = "";
        String winname = "";
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        HashMap<String, Object> HdrMap = null;
        HashMap<String, Object> DetMap = null;
        ArrayList DetList = new ArrayList();
        ITMDBAccessEJB itmDBAccessEJB = null;
        itmDBAccessEJB = new ITMDBAccessEJB();
        boolean cntrHdr = false;
        boolean cntr = false;
        boolean insertedRow = false;
        boolean rows = false;
        Timestamp tranDate = null;
        Timestamp today = null;
        try {
            sql = "select   tran_id,tran_date,eff_date,site_code__from, fin_entity__from, site_code__to,fin_entity__to,amount,  curr_code,confirmed,conf_date,emp_code__aprv,acct_code__ifr,cctr_code__ifr,acct_code__ito,cctr_code__ito,amount__bc,tran_type,tran_ser,tran_id__iss,exch_rate,link_type from PAY_IBCA where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                HdrMap = new HashMap<String, Object>();
                HdrMap.put("tran_date", rs.getTimestamp("tran_date"));
                HdrMap.put("tran_id", rs.getString("tran_id"));
                HdrMap.put("eff_date", rs.getTimestamp("eff_date"));
                HdrMap.put("site_code__from", rs.getString("site_code__from"));
                HdrMap.put("fin_entity__from", rs.getString("fin_entity__from"));
                HdrMap.put("site_code__to", rs.getString("site_code__to"));
                HdrMap.put("fin_entity__to", rs.getString("fin_entity__to"));
                HdrMap.put("amount", rs.getDouble("amount"));
                HdrMap.put("curr_code", rs.getString("curr_code"));
                HdrMap.put("confirmed", rs.getString("confirmed"));
                HdrMap.put("conf_date", rs.getTimestamp("conf_date"));
                HdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
                HdrMap.put("acct_code__ifr", rs.getString("acct_code__ifr"));
                HdrMap.put("cctr_code__ifr", rs.getString("cctr_code__ifr"));
                HdrMap.put("acct_code__ito", rs.getString("acct_code__ito"));
                HdrMap.put("cctr_code__ito", rs.getString("cctr_code__ito") == null ? "" : rs.getString("cctr_code__ito"));
                HdrMap.put("amount__bc", rs.getDouble("amount__bc"));
                HdrMap.put("tran_type", rs.getString("tran_type"));
                HdrMap.put("tran_ser", rs.getString("tran_ser"));
                HdrMap.put("tran_id__iss", rs.getString("tran_id__iss"));
                HdrMap.put("exch_rate", rs.getDouble("exch_rate"));
                HdrMap.put("link_type", rs.getString("link_type"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)" Header Map..........");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)HdrMap.toString());
            }
            pstmt.close();
            pstmt = null;
            rs.close();
            rs = null;
            sql = " select  tran_id,ref_ser, ref_no, ref_date,curr_code,acct_code,cctr_code,due_date,tot_amt,  discount,  tax_amt,auto_pay,bank_code,ref_type,cr_term,bill_no,bill_date,sundry_type,sundry_code,pay_mode,exch_rate,entry_batch_no,purc_order,supp_bill_amt,adv_amt,tds_amt from PAY_IBCA_DET where tran_id = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DetMap = new HashMap<String, Object>();
                DetMap.put("tran_id", rs.getString("tran_id"));
                DetMap.put("ref_ser", rs.getString("ref_ser"));
                DetMap.put("ref_no", rs.getString("ref_no"));
                DetMap.put("ref_date", rs.getTimestamp("ref_date"));
                DetMap.put("curr_code", rs.getString("curr_code"));
                DetMap.put("acct_code", rs.getString("acct_code"));
                DetMap.put("cctr_code", rs.getString("cctr_code"));
                DetMap.put("due_date", rs.getTimestamp("due_date"));
                DetMap.put("tot_amt", rs.getDouble("tot_amt"));
                DetMap.put("discount", rs.getDouble("discount"));
                DetMap.put("tax_amt", rs.getDouble("tax_amt"));
                DetMap.put("auto_pay", rs.getString("auto_pay"));
                DetMap.put("bank_code", rs.getString("bank_code"));
                DetMap.put("ref_type", rs.getString("ref_type"));
                DetMap.put("cr_term", rs.getString("cr_term"));
                DetMap.put("bill_no", rs.getString("bill_no"));
                DetMap.put("bill_date", rs.getTimestamp("bill_date"));
                DetMap.put("sundry_type", rs.getString("sundry_type"));
                DetMap.put("sundry_code", rs.getString("sundry_code"));
                DetMap.put("pay_mode", rs.getString("pay_mode"));
                DetMap.put("exch_rate", rs.getDouble("exch_rate"));
                DetMap.put("entry_batch_no", rs.getString("entry_batch_no"));
                DetMap.put("purc_order", rs.getString("purc_order"));
                DetMap.put("supp_bill_amt", rs.getDouble("supp_bill_amt"));
                DetMap.put("adv_amt", rs.getDouble("adv_amt"));
                DetMap.put("tds_amt", rs.getDouble("tds_amt"));
                DetList.add(DetMap);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)" DetMap  Map..........");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)DetMap.toString());
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            sql1 = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT tran_id FROM pay_ibca  WHERE tran_id = ? for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT tran_id FROM pay_ibca (updlock) WHERE tran_id = ? " : " SELECT tran_id , tran_date FROM pay_ibca WHERE tran_id =  ? for update nowait");
            pstmt1 = conn.prepareStatement(sql1);
            pstmt1.setString(1, tranId);
            rs1 = pstmt1.executeQuery();
            if (rs1.next()) {
                keyFld = rs1.getString("tran_id") == null ? " " : rs1.getString("tran_id");
                tranDate = rs1.getTimestamp("tran_date");
            }
            rs1.close();
            rs1 = null;
            pstmt1.close();
            pstmt1 = null;
            today = new Timestamp(System.currentTimeMillis());
            winname = "W_RCP_IBCA";
            sql = "select ledg_post_conf from transetup where upper(tran_window) = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, "W_PAY_IBCA");
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ledgPostConf = rs.getString(1);
            } else {
                errCode = itmDBAccessEJB.getErrorString("", "VTSEQ ", "", "", conn);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if ("Y".equalsIgnoreCase(ledgPostConf)) {
                SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
                tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today)) + " 00:00:00.000");
                sql = " update rcp_ibca set tran_date = ? where tran_id   = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setTimestamp(1, tranDate);
                pstmt.setString(2, tranId);
                pstmt.executeUpdate();
                pstmt.close();
                pstmt = null;
            }
            errCode = this.gbfPostPibca(HdrMap, DetList, xtraParams, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("err String from gbfPostPibca =" + errCode));
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String gbfPostPibca(HashMap HdrMap, ArrayList DetList, String xtraParams, Connection conn) throws ITMException {
        String errCode = "";
        String keyFld = "";
        String expHdr = "";
        String expDet = "";
        String winName = "";
        String ledgPostconf = "";
        String sql = "";
        String winname = "";
        String loginEmpCode = "";
        String tranSer = "";
        String linkType = "";
        ITMDBAccessEJB itmDBAccessEJB = null;
        itmDBAccessEJB = new ITMDBAccessEJB();
        String tranId = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean cntrHdr = false;
        boolean cntr = false;
        boolean insertedRow = false;
        boolean rows = false;
        int ediOption = 0;
        try {
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            Timestamp today = new Timestamp(System.currentTimeMillis());
            sql = "select edi_option from transetup where tran_window = 'w_pay_ibca'";
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ediOption = rs.getInt(1);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            tranSer = (String)HdrMap.get("tran_ser");
            if ("I".equalsIgnoreCase(tranSer)) {
                errCode = this.gbfPostPibcaHdrIss(HdrMap, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("err String from gbfPostPibcaHdrIss =" + errCode));
                if (errCode != null) {
                    if (errCode.trim().length() != 0) return errCode;
                }
                errCode = this.gbfPostPibcaDetIss(HdrMap, DetList, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("err String from gbfPostPibcaDetIss =" + errCode));
                if (errCode != null) {
                    if (errCode.trim().length() != 0) return errCode;
                }
                if ("E".equalsIgnoreCase(linkType)) {
                    sql = "update receipt set confirmed = 'Y', conf_date = ?,emp_code__aprv = ? where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setDate(1, new Date(new java.util.Date().getTime()));
                    pstmt.setString(2, loginEmpCode);
                    pstmt.setString(3, (String)HdrMap.get("tran_id"));
                    int updateCoount = pstmt.executeUpdate();
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + updateCoount));
                    pstmt.close();
                    pstmt = null;
                    if (updateCoount > 0) {
                        return itmDBAccessEJB.getErrorString("", "VTCICONF3 ", "", "", conn);
                    }
                }
            } else if ("R".equalsIgnoreCase(tranSer)) {
                errCode = this.gbfPostPibcaHdrRcp(HdrMap, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("err String from gbfPostPibcaHdrRcp =" + errCode));
                if (errCode != null) {
                    if (errCode.trim().length() != 0) return errCode;
                }
                errCode = this.gbfPostPibcaDetRcp(HdrMap, DetList, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("err String from gbfPostPibcaDetRcp =" + errCode));
                if (errCode != null) {
                    if (errCode.trim().length() != 0) return errCode;
                }
                if ("E".equals(linkType) || ediOption > 0) {
                    sql = "update receipt set confirmed = 'Y', conf_date = ?,emp_code__aprv = ? where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setDate(1, new Date(new java.util.Date().getTime()));
                    pstmt.setString(2, loginEmpCode);
                    pstmt.setString(3, (String)HdrMap.get("tran_id"));
                    int updateCoount = pstmt.executeUpdate();
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + updateCoount));
                    pstmt.close();
                    pstmt = null;
                    if (updateCoount > 0) {
                        return itmDBAccessEJB.getErrorString("", "VTCICONF3 ", "", "", conn);
                    }
                }
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tran_id From Confirm::" + this.tranId1));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Before POST_ON_LINE.....");
            String postOnline = this.checkNullAndTrim(this.finCommon.getFinparams("999999", "POST_ON_LINE", conn));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Before checkGlTranDrCr::postOnline[" + postOnline + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("before checkGlTranDrCr::tranId[" + this.tranId1 + "]"));
            if ("Y".equals(postOnline)) {
                errCode = this.finCommon.checkGlTranDrCr("P-IBCA", this.tranId1, conn);
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After checkGlTranDrCr::errCode[" + errCode + "]"));
            if (errCode != null) {
                if (errCode.trim().length() != 0) return errCode;
            }
            sql = "update pay_ibca set confirmed = ?, conf_date = ?, emp_code__aprv = ? where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, "Y");
            pstmt.setTimestamp(2, today);
            pstmt.setString(3, loginEmpCode);
            pstmt.setString(4, (String)HdrMap.get("tran_id"));
            pstmt.executeUpdate();
            pstmt.close();
            return errCode;
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private String gbfPostPibcaHdrIss(HashMap MapHrd, String xtraParams, Connection conn) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfPostPibcaHdrIss called........");
        String errString = "";
        String linkType = "";
        String currCode = "";
        String siteCode = "";
        String siteCodeFor = "";
        String finEntity = "";
        String acctCode = "";
        String cctrCode = "";
        String acctCodePay = "";
        String cctrCodePay = "";
        String acctCodeAr = "";
        String cctrCodeAr = "";
        String projectCode = "";
        String analCode = "";
        String bankCode = "";
        String remarks = "";
        String sundryType = "";
        String sundryCode = "";
        String sundryTypeFor = "";
        String sundryCodeFor = "";
        String contactCode = "";
        String empCode = "";
        String refNO = "";
        String rcpMode = "";
        String batchNo = "";
        String tranType = "";
        String confirm = "";
        String loginEmpCode = "";
        String winName = "";
        String editOption = "";
        String confirmed = "";
        String sql = "";
        String errorType = "";
        String bdFluctuationCf = "";
        String acctCodeBal = "";
        String cctrCodeBal = "";
        String basecurrCode = "";
        String projCode = "";
        String custCode = "";
        String salesPers = "";
        String refSer = "";
        String refNo = "";
        String acctCodeCf = "";
        String payslip = "";
        String tranId = "";
        boolean isInBaseCurr = false;
        boolean count = false;
        boolean cnt1 = false;
        boolean cnt = false;
        double exchRate = 0.0;
        double netAmount = 0.0;
        double amount = 0.0;
        double advAmt = 0.0;
        double netAmt = 0.0;
        double chqAmt = 0.0;
        double debit = 0.0;
        double credit = 0.0;
        double totAmt = 0.0;
        double ediOption = 0.0;
        double netAmountBc = 0.0;
        Timestamp effDate = null;
        Timestamp tranDate = null;
        Timestamp refDate = null;
        Object detListMap = null;
        HashMap<String, String> glTraceMap = null;
        Object sundryBalMap = null;
        Object bankTranLogMap = null;
        Object receivablesMap = null;
        Object epcadjMap = null;
        Object pstmt = null;
        Object rs = null;
        FinCommon finCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        try {
            finCommon = new FinCommon();
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            itmDBAccessEJB = new ITMDBAccessEJB();
            linkType = (String)MapHrd.get("link_type");
            tranId = (String)MapHrd.get("tran_id");
            if (!linkType.equalsIgnoreCase("R") && !linkType.equalsIgnoreCase("C")) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Inside iF linktype");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Printing HASHMAP MAPHRD" + MapHrd));
                tranDate = (Timestamp)MapHrd.get("tran_date");
                refDate = (Timestamp)MapHrd.get("ref_date");
                effDate = (Timestamp)MapHrd.get("eff_date");
                remarks = (String)MapHrd.get("remarks");
                finEntity = (String)MapHrd.get("fin_entity__from");
                siteCode = (String)MapHrd.get("site_code__from");
                bankCode = (String)MapHrd.get("bank_code");
                acctCode = (String)MapHrd.get("acct_code__ifr");
                cctrCode = (String)MapHrd.get("cctr_code__ifr");
                currCode = (String)MapHrd.get("curr_code");
                exchRate = (Double)MapHrd.get("exch_rate");
                glTraceMap = new HashMap<String, String>();
                glTraceMap.put("tran_date", (String)((Object)tranDate));
                glTraceMap.put("eff_date", (String)((Object)effDate));
                glTraceMap.put("fin_entity", finEntity);
                glTraceMap.put("site_code", siteCode);
                glTraceMap.put("sundry_type", "O");
                glTraceMap.put("sundry_code", "");
                glTraceMap.put("acct_code", acctCode);
                glTraceMap.put("cctr_code", cctrCode);
                glTraceMap.put("emp_code", "");
                glTraceMap.put("anal_code", "");
                glTraceMap.put("curr_code", currCode);
                glTraceMap.put("exch_rate", (String)((Object)Double.valueOf(exchRate)));
                if ((Double)MapHrd.get("amount") > 0.0) {
                    glTraceMap.put("dr_amt", (String)((Object)Double.valueOf(0.0)));
                    glTraceMap.put("cr_amt", (String)((Object)((Double)MapHrd.get("amount"))));
                } else {
                    glTraceMap.put("dr_amt", (String)((Object)Double.valueOf(0.0 - (Double)MapHrd.get("amount"))));
                    glTraceMap.put("cr_amt", (String)((Object)Double.valueOf(0.0)));
                }
            }
            glTraceMap.put("ref_type", "F");
            glTraceMap.put("ref_ser", "P-IBCA");
            glTraceMap.put("ref_id", tranId);
            glTraceMap.put("remarks", remarks);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("HASHMAP glTraceUpdate" + glTraceMap));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"1766 glTraceUpdate Called..............");
            errString = finCommon.glTraceUpdate((HashMap)glTraceMap, conn);
            if (errString != null && errString.trim().length() > 0) {
                return errString;
            }
            if (linkType.equalsIgnoreCase("A")) {
                errString = this.gbfPostPibcaHdrRcp(MapHrd, xtraParams, conn);
            } else if (linkType.equalsIgnoreCase("P")) {
                errString = this.gbfCreatePibca(tranId, tranId, xtraParams, conn);
            } else if (linkType.equalsIgnoreCase("R")) {
                errString = this.gbfPostPibcaHdrRcp(MapHrd, xtraParams, conn);
            } else if (linkType.equalsIgnoreCase("C")) {
                errString = this.gbfPostPibcaHdrRcp(MapHrd, xtraParams, conn);
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    private String gbfCreatePibca(String tranIdFr, String tranIdTo, String xtraParams, Connection conn) throws ITMException {
        String errString = "";
        String keyString = "";
        String linkType = "";
        String thisWin = "";
        String ibcaConf = "N";
        String siteCodeFrom = "";
        String siteCodeTo = "";
        String finEntFrom = "";
        String finEntTo = "";
        ArrayList<String> tranIdList = null;
        int count = 0;
        String tranType = "";
        String newTranId = "";
        String chgUser = "";
        String chgTerm = "";
        String sql = "";
        PreparedStatement pstmt = null;
        PreparedStatement pstmtHdr = null;
        PreparedStatement pstmtDet = null;
        ResultSet rs = null;
        Object rs1 = null;
        Timestamp tranDate = null;
        try {
            chgUser = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
            chgTerm = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("<----USER_ID[" + chgUser));
            sql = "insert into pay_ibca (tran_id, tran_ser,tran_id__iss,tran_type, tran_date, eff_date,  site_code__from, fin_entity__from, site_code__to, fin_entity__to, acct_code__ifr,  cctr_code__ifr, acct_code__ito, cctr_code__ito, amount, curr_code, link_type, confirmed,  amount__bc, chg_date, chg_user, chg_term, add_date, add_user, add_term, remarks, sundry_type, sundry_code )  values (?, ?,?,?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
            pstmtHdr = conn.prepareStatement(sql);
            sql = "insert into pay_ibca_det ( tran_id, ref_ser, ref_no, ref_date, curr_code, acct_code, cctr_code,  due_date, tot_amt, discount, tax_amt, auto_pay, bank_code, ref_type, cr_term, bill_no, bill_date,  sundry_type, sundry_code, pay_mode, exch_rate, entry_batch_no, purc_order, supp_bill_amt,  adv_amt, tds_amt, ref_ser__org )  values (tran_id, ref_ser, ref_no, ref_date, curr_code, acct_code, cctr_code,  due_date, tot_amt, discount, tax_amt, auto_pay, bank_code, ref_type, cr_term, bill_no, bill_date,  sundry_type, sundry_code, pay_mode, exch_rate, entry_batch_no, purc_order, supp_bill_amt,  adv_amt, tds_amt, ref_ser__org )";
            pstmtDet = conn.prepareStatement(sql);
            errString = "";
            sql = "select key_string from transetup where tran_window = 'w_pay_ibca'";
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                keyString = rs.getString(1);
            } else {
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                sql = "select key_string from transetup where upper(tran_window) = 'GENERAL'";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    keyString = rs.getString(1);
                }
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            tranIdList = new ArrayList<String>();
            sql = "select tran_id from pay_ibca where tran_id >= ? and tran_id <= ? and upper(confirmed) <> 'Y'";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranIdFr);
            pstmt.setString(2, tranIdTo);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                tranIdList.add(rs.getString(1));
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            int hdrCtr = 0;
            while (hdrCtr < tranIdList.size()) {
                sql = " SELECT tran_id, tran_ser, tran_id__iss, tran_type, tran_date, eff_date, site_code__from, fin_entity__from,  site_code__to, fin_entity__to, acct_code__ifr, cctr_code__ifr, acct_code__ito, cctr_code__ito, amount,  curr_code, link_type, confirmed, conf_date, emp_code__aprv, amount__bc, exch_rate, remarks, sundry_type, sundry_code  FROM pay_ibca   WHERE  tran_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, (String)tranIdList.get(hdrCtr));
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Timestamp today = new Timestamp(System.currentTimeMillis());
                    SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
                    tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today)) + " 00:00:00.000");
                    sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
                    String xmlValues = "";
                    xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
                    xmlValues = String.valueOf(xmlValues) + "<Header></Header>";
                    xmlValues = String.valueOf(xmlValues) + "<Detail1>";
                    xmlValues = String.valueOf(xmlValues) + "<tran_id/>";
                    xmlValues = String.valueOf(xmlValues) + "<site_code__from>" + rs.getString("site_code__from") + "</site_code__from>";
                    xmlValues = String.valueOf(xmlValues) + "<site_code__to>" + rs.getString("site_code__to") + "</site_code__to>";
                    xmlValues = String.valueOf(xmlValues) + "<tran_date>" + sdf.format(tranDate) + "</tran_date>";
                    xmlValues = String.valueOf(xmlValues) + "<tran_ser>R</tran_ser>";
                    xmlValues = String.valueOf(xmlValues) + "<link_type>R</link_type>";
                    xmlValues = String.valueOf(xmlValues) + "</Detail1></Root>";
                    TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
                    newTranId = tg.generateTranSeqID("P-IBCA", "tran_id", keyString, conn);
                    tranType = rs.getString("tran_ser");
                    linkType = rs.getString("link_type");
                    siteCodeFrom = rs.getString("site_code__from");
                    siteCodeTo = rs.getString("site_code__to");
                    finEntFrom = rs.getString("fin_entity__from");
                    finEntTo = rs.getString("fin_entity__to");
                    pstmtHdr.clearParameters();
                    pstmtHdr.setString(1, newTranId);
                    pstmtHdr.setString(2, "R");
                    pstmtHdr.setString(3, (String)tranIdList.get(hdrCtr));
                    pstmtHdr.setString(4, rs.getString("tran_type"));
                    pstmtHdr.setTimestamp(5, tranDate);
                    pstmtHdr.setTimestamp(6, rs.getTimestamp("eff_date"));
                    pstmtHdr.setString(7, rs.getString("site_code__from"));
                    pstmtHdr.setString(8, rs.getString("fin_entity__from"));
                    pstmtHdr.setString(9, rs.getString("site_code__to"));
                    pstmtHdr.setString(10, rs.getString("fin_entity__to"));
                    pstmtHdr.setString(11, rs.getString("acct_code__ifr"));
                    pstmtHdr.setString(12, rs.getString("cctr_code__ifr"));
                    pstmtHdr.setString(13, rs.getString("acct_code__ito"));
                    pstmtHdr.setString(14, rs.getString("cctr_code__ito"));
                    pstmtHdr.setDouble(15, rs.getDouble("amount"));
                    pstmtHdr.setString(16, rs.getString("curr_code"));
                    pstmtHdr.setString(17, rs.getString("link_type"));
                    pstmtHdr.setString(18, rs.getString("confirmed"));
                    pstmtHdr.setDouble(19, rs.getDouble("amount__bc"));
                    pstmtHdr.setTimestamp(20, today);
                    pstmtHdr.setString(21, chgUser);
                    pstmtHdr.setString(22, chgTerm);
                    pstmtHdr.setTimestamp(23, today);
                    pstmtHdr.setString(24, chgUser);
                    pstmtHdr.setString(25, chgTerm);
                    pstmtHdr.setString(26, rs.getString("remarks"));
                    pstmtHdr.setString(27, rs.getString("sundry_type"));
                    pstmtHdr.setString(28, rs.getString("sundry_code"));
                    count = pstmtHdr.executeUpdate();
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                sql = " SELECT ref_ser, ref_no, ref_date, curr_code, acct_code, cctr_code, due_date, tot_amt,  discount, tax_amt, auto_pay, bank_code, ref_type, cr_term, bill_no, bill_date, sundry_type,  sundry_code, pay_mode, exch_rate, entry_batch_no, purc_order, supp_bill_amt, adv_amt, tds_amt, ref_ser__org  FROM pay_ibca_det   WHERE  tran_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, (String)tranIdList.get(hdrCtr));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    pstmtDet.clearParameters();
                    pstmtDet.setString(1, newTranId);
                    pstmtDet.setString(2, rs.getString("ref_ser"));
                    pstmtDet.setString(3, rs.getString("ref_no"));
                    pstmtDet.setTimestamp(4, rs.getTimestamp("ref_date"));
                    pstmtDet.setString(5, rs.getString("curr_code"));
                    pstmtDet.setString(6, rs.getString("acct_code"));
                    pstmtDet.setString(7, rs.getString("cctr_code"));
                    pstmtDet.setTimestamp(8, rs.getTimestamp("due_date"));
                    pstmtDet.setDouble(9, rs.getDouble("tot_amt"));
                    pstmtDet.setDouble(10, rs.getDouble("discount"));
                    pstmtDet.setDouble(11, rs.getDouble("tax_amt"));
                    pstmtDet.setString(12, rs.getString("auto_pay"));
                    pstmtDet.setString(13, rs.getString("bank_code"));
                    pstmtDet.setString(14, rs.getString("ref_type"));
                    pstmtDet.setString(15, rs.getString("cr_term"));
                    pstmtDet.setString(16, rs.getString("bill_no"));
                    pstmtDet.setTimestamp(17, rs.getTimestamp("bill_date"));
                    pstmtDet.setString(18, rs.getString("sundry_type"));
                    pstmtDet.setString(19, rs.getString("sundry_code"));
                    pstmtDet.setString(20, rs.getString("pay_mode"));
                    pstmtDet.setDouble(21, rs.getDouble("exch_rate"));
                    pstmtDet.setString(22, rs.getString("entry_batch_no"));
                    pstmtDet.setString(23, rs.getString("purc_order"));
                    pstmtDet.setDouble(24, rs.getDouble("supp_bill_amt"));
                    pstmtDet.setDouble(25, rs.getDouble("adv_amt"));
                    pstmtDet.setDouble(26, rs.getDouble("tds_amt"));
                    pstmtDet.setString(27, rs.getString("ref_ser__org"));
                    pstmtDet.addBatch();
                    pstmtDet.clearParameters();
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                pstmtDet.executeBatch();
                sql = " select \tcase when auto_confirm is null then 'N' else auto_confirm end  from IBCA_PAY_CTRL  where  site_code__from   = ?  and    site_code__to     = ?  and    fin_entity__from  = ? \tand    fin_entity__to    = ?  and    link_type         = 'P' ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, siteCodeFrom);
                pstmt.setString(2, siteCodeTo);
                pstmt.setString(3, finEntFrom);
                pstmt.setString(4, finEntTo);
                rs = pstmt.executeQuery();
                ibcaConf = rs.next() ? rs.getString(1) : "N";
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if ("Y".equals(ibcaConf) && (errString = this.confirm(newTranId, xtraParams, "N", conn)).indexOf("VTCICONF3") > -1) {
                    errString = "";
                }
                ++hdrCtr;
            }
            pstmtDet.close();
            pstmtDet = null;
            pstmtHdr.close();
            pstmtHdr = null;
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    private String gbfPostPibcaDetIss(HashMap MapHrd, ArrayList MapDet, String xtraParams, Connection conn) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfPostPibcaDetIss called..............");
        String errString = "";
        String currCode = "";
        String siteCode = "";
        String siteCodeFor = "";
        String finEntity = "";
        String acctCode = "";
        String cctrCode = "";
        String recoAcctCode = "";
        String recoCctrCode = "";
        String taxAcctCode = "";
        String taxCctrCode = "";
        String acctCode1 = "";
        String cctrCode1 = "";
        String acctCodeAr = "";
        String cctrCodeAr = "";
        String projectCode = "";
        String analCode = "";
        String bankCode = "";
        String remarks = "";
        String sundryType = "";
        String contactCode = "";
        String sundryCode = "";
        String sundryTypeFor = "";
        String sundryCodeFor = "";
        String tranType = "";
        String empCode = "";
        String refNO = "";
        String rcpMode = "";
        String batchNo = "";
        String confirm = "";
        String loginEmpCode = "";
        String winName = "";
        String editOption = "";
        String sql = "";
        String hcurrCode = "";
        String errorType = "";
        String payslip = "";
        String partyDocRef = "";
        String refSer = "";
        String refNo = "";
        String salesPers = "";
        String status = "";
        String lineNoPef = "";
        String link = "";
        String finlink = "";
        String code = "";
        String tranId = "";
        boolean count = false;
        boolean lineNo = false;
        int cnt = 0;
        double exchRate = 0.0;
        double hexchRate = 0.0;
        double netAmount = 0.0;
        double amount = 0.0;
        double taxAmount = 0.0;
        double recoAmount = 0.0;
        double debit = 0.0;
        double credit = 0.0;
        double totAmt = 0.0;
        double advAmt = 0.0;
        double adjAmt = 0.0;
        double advAdj = 0.0;
        double recoverAmt = 0.0;
        double totAmount = 0.0;
        Timestamp effDate = null;
        Timestamp tranDate = null;
        Object refDate = null;
        Timestamp frDate = null;
        HashMap DetMap = null;
        HashMap RcpDetMap = null;
        Object ADetMap = null;
        Object EpcAdjMap = null;
        HashMap<String, Object> glTraceMap = null;
        HashMap<String, Object> sundryBalMap = null;
        Object bankTranLogMap = null;
        Object detListMap = null;
        Object recofiltMap = null;
        Object recodataMap = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        DistCommon distCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        UtilMethods utl = new UtilMethods();
        Timestamp dateInterest = null;
        try {
            finCommon = new FinCommon();
            distCommon = new DistCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            finlink = finCommon.getFinparams("999999", "ADM_FIN_LINK", conn);
            tranDate = (Timestamp)MapHrd.get("tran_date");
            effDate = (Timestamp)MapHrd.get("eff_date");
            finEntity = (String)MapHrd.get("fin_entity__from");
            siteCode = (String)MapHrd.get("site_code__from");
            tranId = (String)MapHrd.get("tran_id");
            hcurrCode = (String)MapHrd.get("curr_code");
            hexchRate = (Double)MapHrd.get("exch_rate");
            remarks = (String)MapHrd.get("remarks");
            link = (String)MapHrd.get("link_type");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Link_type" + link));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList SIZE " + MapDet.size()));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList SIZE " + MapDet));
            int ctr = 0;
            while (ctr < MapDet.size()) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of times " + ctr));
                DetMap = new HashMap();
                DetMap = (HashMap)MapDet.get(ctr);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetMap SIZE " + DetMap));
                glTraceMap = new HashMap<String, Object>();
                glTraceMap.put("tran_date", tranDate);
                glTraceMap.put("eff_date", effDate);
                glTraceMap.put("fin_entity", finEntity);
                glTraceMap.put("site_code", siteCode);
                glTraceMap.put("sundry_type", (String)DetMap.get("sundry_type") == null ? "O" : (String)DetMap.get("sundry_type"));
                glTraceMap.put("sundry_code", (String)DetMap.get("sundry_code") == null ? "" : (String)DetMap.get("sundry_code"));
                glTraceMap.put("acct_code", (String)DetMap.get("acct_code"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("818 account chek =" + acctCode + "  " + sundryType + "   " + sundryCode));
                glTraceMap.put("cctr_code", (String)DetMap.get("cctr_code") == null ? "" : (String)DetMap.get("cctr_code"));
                glTraceMap.put("emp_code", "");
                glTraceMap.put("anal_code", "");
                glTraceMap.put("curr_code", (String)DetMap.get("curr_code") == null ? hcurrCode : (String)DetMap.get("curr_code"));
                glTraceMap.put("proj_code", projectCode);
                glTraceMap.put("exch_rate", (Double)DetMap.get("exch_rate"));
                amount = (Double)DetMap.get("tot_amt");
                if (amount > 0.0) {
                    glTraceMap.put("dr_amt", amount);
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", 0.0 - amount);
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "P-IBCA");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                glTraceMap.put("party_doc_ref", partyDocRef);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"848 glTraceUpdate Called..............");
                errString = finCommon.glTraceUpdate(glTraceMap, conn);
                if (errString != null && errString.trim().length() > 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"ERROR IN GLTRACE ...........");
                    return errString;
                }
                sundryBalMap = new HashMap<String, Object>();
                sundryBalMap.put("tran_date", tranDate);
                sundryBalMap.put("eff_date", effDate);
                sundryBalMap.put("fin_entity", finEntity);
                sundryBalMap.put("site_code", siteCode);
                sundryBalMap.put("sundry_type", (String)DetMap.get("sundry_type"));
                sundryBalMap.put("sundry_code", (String)DetMap.get("sundry_code"));
                sundryBalMap.put("acct_code", (String)DetMap.get("acct_code"));
                sundryBalMap.put("cctr_code", (String)DetMap.get("cctr_code") == null ? "" : (String)DetMap.get("cctr_code"));
                sundryBalMap.put("curr_code", (String)DetMap.get("curr_code") == null ? hcurrCode : (String)DetMap.get("curr_code"));
                sundryBalMap.put("exch_rate", (Double)DetMap.get("exch_rate"));
                amount = (Double)DetMap.get("tot_amt");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("SundryBalMAP amount" + amount));
                if (amount > 0.0) {
                    sundryBalMap.put("dr_amt", amount);
                    sundryBalMap.put("cr_amt", 0.0);
                } else {
                    sundryBalMap.put("dr_amt", 0.0);
                    sundryBalMap.put("cr_amt", 0.0 - amount);
                }
                sundryBalMap.put("adv_amt", 0.0);
                contactCode = finCommon.getContactCode(sundryType, sundryCode, conn);
                sundryBalMap.put("contact_code", contactCode);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"2366 sundryBaleUpdate Called..............");
                errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                if (errString != null && errString.trim().length() > 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("error is sundryBaleUpdate ..........." + errString));
                    return errString;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"last ...........");
                RcpDetMap = new HashMap();
                RcpDetMap = (HashMap)MapDet.get(ctr);
                refSer = (String)RcpDetMap.get("ref_ser");
                refNo = (String)RcpDetMap.get("ref_no");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Ref_Ser" + refSer + "ref_no" + refNo));
                amount = (Double)RcpDetMap.get("tot_amt");
                itmDBAccessEJB = new ITMDBAccessEJB();
                sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT tot_amt, adj_amt FROM misc_payables  WHERE tran_ser = ?  and ref_no = ?  for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT tot_amt, adj_amt FROM misc_payables (updlock) where tran_ser = ?  and ref_no = ?  " : " SELECT tot_amt, adj_amt FROM misc_payables WHERE tran_ser = ?  and ref_no = ?  for update nowait");
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, refSer);
                pstmt.setString(2, refNo);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    totAmt = rs.getDouble("tot_amt");
                    adjAmt = rs.getDouble("adj_amt");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After adjAmt[" + adjAmt + "]totAmt[" + totAmt + "]amount[" + amount + "]"));
                totAmount = Double.parseDouble(utl.getReqDecString(totAmt - adjAmt, 3));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("totAMt [" + totAmount));
                if (Math.abs(totAmount) < Math.abs(amount)) {
                    errString = itmDBAccessEJB.getErrorString("", "VTBAL1", "", "", conn);
                    return errString;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After adjAmt[" + (adjAmt += amount) + "]totAmt[" + totAmt + "]amount[" + amount + "]"));
                status = totAmt == adjAmt ? "A" : "P";
                sql = "update misc_payables set adj_amt = ?, status = ?,status_date = ? where tran_ser = ? and ref_no = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setDouble(1, adjAmt);
                pstmt.setString(2, status);
                pstmt.setDate(3, new Date(new java.util.Date().getTime()));
                pstmt.setString(4, refSer);
                pstmt.setString(5, refNo);
                pstmt.executeUpdate();
                pstmt.close();
                pstmt = null;
                ++ctr;
            }
            if ("P-VOUC".equals(refSer) && "Y".equals(finlink)) {
                sql = "select tran_type, ref_no  from payr_voucher where tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, refNo);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    tranType = rs.getString(1);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if ("LN".equalsIgnoreCase(tranType)) {
                    sql = "select date__interest  from loans where loan_no = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, refNo);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        dateInterest = rs.getTimestamp(1);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    if (dateInterest == null) {
                        sql = "select code, fr_date, to_date from period  where ? between fr_date and to_date";
                        pstmt.setTimestamp(1, tranDate);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            code = rs.getString(1);
                            frDate = rs.getTimestamp(2);
                        }
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        sql = "select count(*)  from payroll where prd_code = ? and emp_code = ?";
                        pstmt.setString(1, code);
                        pstmt.setString(2, (String)DetMap.get("sundry_code"));
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            cnt = rs.getInt(1);
                        }
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        if (cnt > 0) {
                            sql = "select code  from period where fr_date = ?";
                            pstmt.setTimestamp(1, frDate);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                code = rs.getString(1);
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        sql = "update loans set start_reco where loan_no = ?";
                        pstmt.setTimestamp(1, frDate);
                        pstmt.setString(2, refNo);
                        pstmt.executeUpdate();
                        pstmt.close();
                        pstmt = null;
                        sql = " update loans set date__interest = ?, start_dedn = 'Y'where loan_no = ? ";
                        pstmt.setTimestamp(1, tranDate);
                        pstmt.setString(2, refNo);
                        pstmt.executeUpdate();
                        pstmt.close();
                        pstmt = null;
                    }
                }
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Before calling gbfPostPibcaDetRcp::link[" + link + "]"));
            if ("A".equalsIgnoreCase(link)) {
                errString = this.gbfPostPibcaDetRcp(MapHrd, MapDet, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("calling gbfPostPibcaDetRcp::errString[" + errString + "]"));
                return errString;
            }
            if ("R".equalsIgnoreCase(link)) {
                errString = this.gbfPostPibcaDetRcp(MapHrd, MapDet, xtraParams, conn);
                return errString;
            }
            if ("C".equalsIgnoreCase(link)) {
                errString = this.gbfPostPibcaDetRcp(MapHrd, MapDet, xtraParams, conn);
                return errString;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    private String gbfPostPibcaHdrRcp(HashMap MapHrd, String xtraParams, Connection conn) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfPostPibcaHdrRcp called........");
        String errString = "";
        String linkType = "";
        String currCode = "";
        String siteCode = "";
        String siteCodeFor = "";
        String finEntity = "";
        String acctCode = "";
        String cctrCode = "";
        String acctCodePay = "";
        String cctrCodePay = "";
        String acctCodeAr = "";
        String cctrCodeAr = "";
        String projectCode = "";
        String analCode = "";
        String bankCode = "";
        String remarks = "";
        String sundryType = "";
        String sundryCode = "";
        String sundryTypeFor = "";
        String sundryCodeFor = "";
        String contactCode = "";
        String empCode = "";
        String refNO = "";
        String rcpMode = "";
        String batchNo = "";
        String tranType = "";
        String confirm = "";
        String loginEmpCode = "";
        String winName = "";
        String editOption = "";
        String confirmed = "";
        String sql = "";
        String errorType = "";
        String bdFluctuationCf = "";
        String acctCodeBal = "";
        String cctrCodeBal = "";
        String basecurrCode = "";
        String projCode = "";
        String custCode = "";
        String salesPers = "";
        String refSer = "";
        String refNo = "";
        String acctCodeCf = "";
        String payslip = "";
        String tranId = "";
        boolean isInBaseCurr = false;
        boolean count = false;
        boolean cnt1 = false;
        boolean cnt = false;
        double exchRate = 0.0;
        double netAmount = 0.0;
        double amount = 0.0;
        double advAmt = 0.0;
        double netAmt = 0.0;
        double chqAmt = 0.0;
        double debit = 0.0;
        double credit = 0.0;
        double totAmt = 0.0;
        double ediOption = 0.0;
        double netAmountBc = 0.0;
        Timestamp effDate = null;
        Timestamp tranDate = null;
        Timestamp refDate = null;
        Object detListMap = null;
        HashMap<String, String> glTraceMap = null;
        Object sundryBalMap = null;
        Object bankTranLogMap = null;
        Object receivablesMap = null;
        Object epcadjMap = null;
        Object pstmt = null;
        Object rs = null;
        FinCommon finCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        try {
            finCommon = new FinCommon();
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            Date today = new Date(new java.util.Date().getTime());
            itmDBAccessEJB = new ITMDBAccessEJB();
            linkType = (String)MapHrd.get("link_type");
            tranId = (String)MapHrd.get("tran_id");
            if (!linkType.equalsIgnoreCase("R") && !linkType.equalsIgnoreCase("C")) {
                tranDate = (Timestamp)MapHrd.get("tran_date");
                refDate = (Timestamp)MapHrd.get("ref_date");
                effDate = (Timestamp)MapHrd.get("eff_date");
                remarks = (String)MapHrd.get("remarks");
                finEntity = (String)MapHrd.get("fin_entity__to");
                siteCode = (String)MapHrd.get("site_code__to");
                bankCode = (String)MapHrd.get("bank_code");
                acctCode = (String)MapHrd.get("acct_code__ito");
                cctrCode = (String)MapHrd.get("cctr_code__ito");
                currCode = (String)MapHrd.get("curr_code");
                exchRate = (Double)MapHrd.get("exch_rate");
                glTraceMap = new HashMap<String, String>();
                glTraceMap.put("tran_date", (String)((Object)tranDate));
                glTraceMap.put("eff_date", (String)((Object)effDate));
                glTraceMap.put("fin_entity", finEntity);
                glTraceMap.put("site_code", siteCode);
                glTraceMap.put("sundry_type", "O");
                glTraceMap.put("sundry_code", "");
                glTraceMap.put("acct_code", acctCode);
                glTraceMap.put("cctr_code", cctrCode);
                glTraceMap.put("emp_code", "");
                glTraceMap.put("anal_code", "");
                glTraceMap.put("curr_code", currCode);
                glTraceMap.put("exch_rate", (String)((Object)Double.valueOf(exchRate)));
                if ((Double)MapHrd.get("amount") > 0.0) {
                    glTraceMap.put("dr_amt", (String)((Object)((Double)MapHrd.get("amount"))));
                    glTraceMap.put("cr_amt", (String)((Object)Double.valueOf(0.0)));
                } else {
                    glTraceMap.put("dr_amt", (String)((Object)Double.valueOf(0.0)));
                    glTraceMap.put("cr_amt", (String)((Object)Double.valueOf(0.0 - (Double)MapHrd.get("amount"))));
                }
            }
            glTraceMap.put("ref_type", "F");
            glTraceMap.put("ref_ser", "P-IBCA");
            glTraceMap.put("ref_id", tranId);
            glTraceMap.put("remarks", remarks);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@@1563 tranId::[" + tranId + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"1766 glTraceUpdate Called..............");
            errString = finCommon.glTraceUpdate((HashMap)glTraceMap, conn);
            if (errString != null && errString.trim().length() > 0) {
                return errString;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    private String gbfPostPibcaDetRcp(HashMap HdrMap, ArrayList DetList, String xtraParams, Connection conn) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfPostPibcaDetRcp called..............");
        String errString = "";
        String currCode = "";
        String siteCode = "";
        String siteCodeFor = "";
        String finEntity = "";
        String acctCode = "";
        String cctrCode = "";
        String recoAcctCode = "";
        String recoCctrCode = "";
        String taxAcctCode = "";
        String taxCctrCode = "";
        String acctCode1 = "";
        String cctrCode1 = "";
        String acctCodeAr = "";
        String cctrCodeAr = "";
        String projectCode = "";
        String analCode = "";
        String bankCode = "";
        String remarks = "";
        String sundryType = "";
        String contactCode = "";
        String sundryCode = "";
        String sundryTypeFor = "";
        String sundryCodeFor = "";
        String tranType = "";
        String empCode = "";
        String refNO = "";
        String rcpMode = "";
        String batchNo = "";
        String confirm = "";
        String loginEmpCode = "";
        String winName = "";
        String editOption = "";
        String sql = "";
        String hcurrCode = "";
        String errorType = "";
        String payslip = "";
        String partyDocRef = "";
        String refSer = "";
        String refNo = "";
        String salesPers = "";
        String status = "";
        String lineNoPef = "";
        String tranId = "";
        boolean count = false;
        boolean lineNo = false;
        double exchRate = 0.0;
        double hexchRate = 0.0;
        double netAmount = 0.0;
        double amount = 0.0;
        double taxAmount = 0.0;
        double recoAmount = 0.0;
        double debit = 0.0;
        double credit = 0.0;
        double totAmt = 0.0;
        double advAmt = 0.0;
        double adjAmt = 0.0;
        double advAdj = 0.0;
        double recoverAmt = 0.0;
        double holdAmt = 0.0;
        Timestamp effDate = null;
        Timestamp tranDate = null;
        Timestamp refDate = null;
        Timestamp billDate = null;
        Timestamp dueDate = null;
        HashMap DetMap = null;
        HashMap<String, Object> miscPayMap = null;
        HashMap<String, Object> glTraceMap = null;
        HashMap<String, Object> sundryBalMap = null;
        Object bankTranLogMap = null;
        Object detListMap = null;
        Object recofiltMap = null;
        Object recodataMap = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        DistCommon distCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        try {
            finCommon = new FinCommon();
            distCommon = new DistCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            tranId = (String)HdrMap.get("tran_id");
            tranDate = (Timestamp)HdrMap.get("tran_date");
            effDate = (Timestamp)HdrMap.get("eff_date");
            finEntity = (String)HdrMap.get("fin_entity__to");
            siteCode = (String)HdrMap.get("site_code__to");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Sitecode=========" + siteCode));
            siteCodeFor = (String)HdrMap.get("site_code__for");
            projectCode = (String)HdrMap.get("proj_code");
            hcurrCode = (String)HdrMap.get("curr_code");
            hexchRate = (Double)HdrMap.get("exch_rate");
            remarks = (String)HdrMap.get("remarks");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList SIZE " + DetList.size()));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList SIZE " + DetList));
            int ctr = 0;
            while (ctr < DetList.size()) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of times " + ctr));
                DetMap = new HashMap();
                DetMap = (HashMap)DetList.get(ctr);
                refDate = (Timestamp)HdrMap.get("ref_date");
                billDate = (Timestamp)HdrMap.get("bill_date");
                dueDate = (Timestamp)HdrMap.get("due_date");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetMap SIZE " + DetMap));
                glTraceMap = new HashMap<String, Object>();
                glTraceMap.put("tran_date", tranDate);
                glTraceMap.put("eff_date", effDate);
                glTraceMap.put("fin_entity", finEntity);
                glTraceMap.put("site_code", siteCode);
                glTraceMap.put("sundry_type", (String)DetMap.get("sundry_type") == null ? "O" : (String)DetMap.get("sundry_type"));
                glTraceMap.put("sundry_code", (String)DetMap.get("sundry_code") == null ? "" : (String)DetMap.get("sundry_code"));
                glTraceMap.put("acct_code", (String)DetMap.get("acct_code"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("818 account chek =" + acctCode + "  " + sundryType + "   " + sundryCode));
                glTraceMap.put("cctr_code", (String)DetMap.get("cctr_code") == null ? "" : (String)DetMap.get("cctr_code"));
                glTraceMap.put("emp_code", (String)DetMap.get("emp_code"));
                glTraceMap.put("anal_code", (String)DetMap.get("anal_code"));
                glTraceMap.put("curr_code", (String)DetMap.get("curr_code") == null ? hcurrCode : (String)DetMap.get("curr_code"));
                glTraceMap.put("proj_code", projectCode);
                glTraceMap.put("exch_rate", (Double)DetMap.get("exch_rate"));
                amount = (Double)DetMap.get("tot_amt");
                if (amount > 0.0) {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", amount);
                } else {
                    glTraceMap.put("dr_amt", 0.0 - amount);
                    glTraceMap.put("cr_amt", 0.0);
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "P-IBCA");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"848 glTraceUpdate Called..............");
                errString = finCommon.glTraceUpdate(glTraceMap, conn);
                if (errString != null && errString.trim().length() > 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"ERROR IN GLTRACE ...........");
                    return errString;
                }
                sundryBalMap = new HashMap<String, Object>();
                sundryBalMap.put("tran_date", tranDate);
                sundryBalMap.put("eff_date", effDate);
                sundryBalMap.put("fin_entity", finEntity);
                sundryBalMap.put("site_code", siteCode);
                sundryBalMap.put("sundry_type", (String)DetMap.get("sundry_type"));
                sundryBalMap.put("sundry_code", (String)DetMap.get("sundry_code"));
                sundryBalMap.put("acct_code", (String)DetMap.get("acct_code"));
                sundryBalMap.put("cctr_code", (String)DetMap.get("cctr_code") == null ? "" : (String)DetMap.get("cctr_code"));
                sundryBalMap.put("curr_code", (String)DetMap.get("curr_code"));
                sundryBalMap.put("exch_rate", (Double)DetMap.get("exch_rate"));
                amount = (Double)DetMap.get("tot_amt");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Sundrybalcramt" + amount));
                if (amount > 0.0) {
                    sundryBalMap.put("dr_amt", 0.0);
                    sundryBalMap.put("cr_amt", amount);
                } else {
                    sundryBalMap.put("dr_amt", 0.0 - amount);
                    sundryBalMap.put("cr_amt", 0.0);
                }
                sundryBalMap.put("adv_amt", 0.0);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"2366 sundryBaleUpdate Called..............");
                errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                if (errString != null && errString.trim().length() > 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("error is sundryBaleUpdate ..........." + errString));
                    return errString;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Inside gbfPostPibcaDetFcp::Ref_Ser [" + (String)DetMap.get("ref_ser") + "] :: Ref_No [" + (String)DetMap.get("ref_no") + "]"));
                String ref_No = (String)DetMap.get("ref_no");
                String ref_Ser = "";
                int ll_cnt = 0;
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("ref_No::[" + ref_No + "]"));
                sql = "select count(*) as ll_cnt from misc_payables where tran_ser  like 'P-IBC%'AND REF_NO = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, ref_No);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    ll_cnt = rs.getInt("ll_cnt");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                ref_Ser = ll_cnt == 0 ? "P-IBCA" : "P-IBC" + ll_cnt;
                miscPayMap = new HashMap<String, Object>();
                miscPayMap.put("tran_date", tranDate);
                miscPayMap.put("tran_ser", ref_Ser);
                miscPayMap.put("ref_no", (String)DetMap.get("ref_no"));
                miscPayMap.put("ref_date", (Timestamp)DetMap.get("ref_date"));
                miscPayMap.put("bill_no", (String)DetMap.get("bill_no"));
                miscPayMap.put("bill_date", (Timestamp)DetMap.get("bill_date"));
                miscPayMap.put("sundry_type", (String)DetMap.get("sundry_type") == null ? "O" : (String)DetMap.get("sundry_type"));
                miscPayMap.put("sundry_code", (String)DetMap.get("sundry_code") == null ? "O" : (String)DetMap.get("sundry_code"));
                miscPayMap.put("acct_code", (String)DetMap.get("acct_code"));
                miscPayMap.put("cctr_code", (String)DetMap.get("cctr_code") == null ? "" : (String)DetMap.get("cctr_code"));
                miscPayMap.put("curr_code", (String)DetMap.get("curr_code"));
                miscPayMap.put("exch_rate", (Double)DetMap.get("exch_rate"));
                miscPayMap.put("due_date", (Timestamp)DetMap.get("due_date"));
                miscPayMap.put("site_code", siteCode);
                miscPayMap.put("fin_entity", finEntity);
                miscPayMap.put("tot_amt", (Double)DetMap.get("tot_amt"));
                miscPayMap.put("bank_code", (String)DetMap.get("bank_code"));
                miscPayMap.put("auto_pay", (String)DetMap.get("auto_pay"));
                miscPayMap.put("pay_mode", (String)DetMap.get("pay_mode"));
                miscPayMap.put("paid", "N");
                miscPayMap.put("adv_amt", (Double)DetMap.get("adv_amt"));
                miscPayMap.put("tds_amt", DetMap.get("tds_amt").toString());
                miscPayMap.put("supp_bill_amt", DetMap.get("supp_bill_amt").toString());
                miscPayMap.put("entry_batch_no", (String)DetMap.get("entry_batch_no"));
                miscPayMap.put("purc_order", (String)DetMap.get("purc_order"));
                miscPayMap.put("ref_ser__org", (String)DetMap.get("ref_ser"));
                miscPayMap.put("paid", "N");
                miscPayMap.put("hold_amt", holdAmt);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("miscPayMap::[" + miscPayMap + "]"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"884 sundryBaleUpdate Called..............");
                errString = finCommon.gbfMiscPayUpd(miscPayMap, conn);
                if (errString != null && errString.trim().length() > 0) {
                    return errString;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    public double getReqDecimal(double actVal, int prec) throws ITMException {
        String fmtStr = "############0";
        Object strValue = null;
        double retVal = 0.0;
        try {
            DecimalFormat decFormat;
            if (prec > 0) {
                fmtStr = String.valueOf(fmtStr) + "." + "000000000".substring(0, prec);
            }
            if (Math.abs(retVal = Double.parseDouble((decFormat = new DecimalFormat(fmtStr)).format(actVal))) == 0.0) {
                retVal = 0.0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return retVal;
    }

    public String checkNullAndTrim(String inputVal) {
        inputVal = inputVal == null ? "" : inputVal.trim();
        return inputVal;
    }
}

