/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.fin.adv.MiscPayablesHldLocal;
import ibase.webitm.ejb.fin.adv.MiscPayablesHldRemote;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.ejb.Stateless;

@Stateless
public class MiscPayablesHld
extends ActionHandlerEJB
implements MiscPayablesHldLocal,
MiscPayablesHldRemote {
    @Override
    public String actionHandler() throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String actionHandler(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"MiscPayablesHld:actionHandler called");
        String retString = null;
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Transaction ID To Hold :: " + tranID));
            retString = this.actionHold(tranID, xtraParams);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :MiscPayablesHld :actionHandler:" + e.getMessage() + ":"));
            throw new ITMException(e);
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("returning from MiscPayablesHld actionHandler" + retString));
        return retString;
    }

    private String actionHold(String tranID, String xtraParams) throws ITMException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String errCode = "";
        String errString = "";
        String sql = "";
        String updSql = "";
        int rows = 0;
        float totAmt = 0.0f;
        float adjAmt = 0.0f;
        float holdAmt = 0.0f;
        float balAmt = 0.0f;
        boolean flag = false;
        try {
            try {
                conn = this.getConnection();
                ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
                sql = "SELECT TOT_AMT,ADJ_AMT,CASE WHEN HOLD_AMT IS NULL THEN 0 ELSE HOLD_AMT END HOLD_AMT FROM MISC_PAYABLES WHERE TRAN_ID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, tranID);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    totAmt = rs.getFloat("TOT_AMT");
                    adjAmt = rs.getFloat("ADJ_AMT");
                    holdAmt = rs.getFloat("HOLD_AMT");
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
                balAmt = totAmt - adjAmt;
                if (balAmt == 0.0f) {
                    errCode = "VTBAL2";
                } else if (holdAmt == 0.0f) {
                    updSql = "UPDATE MISC_PAYABLES SET HOLD_AMT = TOT_AMT - ADJ_AMT WHERE TRAN_ID = ?";
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Updating SQL :: " + updSql));
                    stmt = conn.prepareStatement(updSql);
                    stmt.setString(1, tranID);
                    rows = stmt.executeUpdate();
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("rows----[" + rows + "]"));
                    stmt.close();
                    stmt = null;
                } else {
                    errCode = "VTHOLD4";
                }
                if ((errCode == null || errCode.trim().length() == 0) && rows > 0) {
                    errCode = "VTHOLD2";
                    conn.commit();
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"\n <==== Transaction Updated Successfully ====>");
                } else {
                    flag = true;
                }
                if (errCode != null && errCode.trim().length() > 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("MiscPayablesHld:errCode:" + errCode));
                    errString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :MiscPayablesHld :" + e.getMessage() + ":"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (flag) {
                        conn.rollback();
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception d) {
                d.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in MiscPayablesHld:actionHold()" + d.getMessage()));
                throw new ITMException(d);
            }
        }
        return errString;
    }
}

