/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.PostSuppPay;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.Stateless;
import org.w3c.dom.Document;

@Stateless
public class MiscPayConfirm
extends ActionHandlerEJB {
    E12GenericUtility genericUtility = new E12GenericUtility();
    FinCommon finCommon = new FinCommon();
    DistCommon distCommon = new DistCommon();
    AdmCommon admCommon = new AdmCommon();
    CommonConstants commonConstants = new CommonConstants();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
    UtilMethods utilMethods = new UtilMethods();

    public String confirm(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("In confirm tranID[" + tranID + "]"));
        String retString = "";
        Connection conn = null;
        try {
            retString = this.confirm(tranID, xtraParams, forcedFlag, conn);
        }
        catch (Exception exception) {
            retString = "ERROR";
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in [MiscPayConfirm] " + exception.getMessage()));
        }
        return retString;
    }

    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"MiscPayConfirm confirm method Called..........");
        Statement pstmt = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        String sql = "";
        String confirmed = "";
        String bankCode = "";
        String siteCode = "";
        String refNo = "";
        String payMode = "";
        String sundryType = "";
        String sundryCode = "";
        String lsWfStatus = "";
        String winName = "";
        String ledgPostConf = "";
        String payModRefval = "";
        String supPayMode = "";
        String sundryTypeDet = "";
        String stanCode = "";
        String sundryCodeDet = "";
        String vouchNo = "";
        String tranSer = "";
        String lsStanCode = "";
        String bankCodeAcct = "";
        String ifscCode = "";
        String errString = "";
        String bnkServStanReq = "";
        double netAmt = 0.0;
        double payDetamt = 0.0;
        double payAmt = 0.0;
        double totAmt = 0.0;
        double adjAmt = 0.0;
        double holdAmt = 0.0;
        Timestamp tranDate = null;
        Timestamp toDayDate = null;
        int llCntSundryBankDet = 0;
        int llCount = 0;
        int count = 0;
        boolean isLocalConn = false;
        boolean lbPayMode = false;
        ArrayList<String> payModRefvalList = null;
        try {
            if (conn == null) {
                conn = this.getConnection();
                isLocalConn = true;
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("xtraParams[" + xtraParams + "]tranId[" + tranId + "]"));
            sql = "select confirmed, bank_code, site_code, tran_date, net_amt ,ref_no ,pay_mode,sundry_type,sundry_code, case when wf_status is null then 'O' else wf_status end as ls_wf_status from misc_payment where tran_id =?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                confirmed = this.checkNull(rs.getString("confirmed"));
                bankCode = this.checkNull(rs.getString("bank_code"));
                siteCode = this.checkNull(rs.getString("site_code"));
                tranDate = rs.getTimestamp("tran_date");
                netAmt = rs.getDouble("net_amt");
                refNo = this.checkNull(rs.getString("ref_no"));
                payMode = this.checkNull(rs.getString("pay_mode"));
                sundryType = this.checkNull(rs.getString("sundry_type"));
                sundryCode = this.checkNull(rs.getString("sundry_code"));
                lsWfStatus = this.checkNull(rs.getString("ls_wf_status"));
            }
            this.closeRsPstmt(rs, (PreparedStatement)pstmt);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("110@ confirmed[" + confirmed + "]bankCode[" + bankCode + "]siteCode[" + siteCode + "]tranDate[" + tranDate + "]netAmt[" + netAmt + "]" + "refNo[" + refNo + "]payMode[" + payMode + "]sundryType[" + sundryType + "]sundryCode[" + sundryCode + "]lsWfStatus[" + lsWfStatus + "]"));
            if (confirmed != null && "N".equalsIgnoreCase(confirmed)) {
                winName = "W_MISC_PAY";
                Date toDay = new Date();
                toDayDate = new Timestamp(toDay.getTime());
                sql = "select ledg_post_conf from transetup where upper(tran_window) = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, winName);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    errString = this.itmDBAccessEJB.getErrorString("", "VTSEQ", "", "", conn);
                    this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                    String string = errString;
                    return string;
                }
                ledgPostConf = this.checkNull(rs.getString("ledg_post_conf"));
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                if ("Y".equalsIgnoreCase(ledgPostConf) && tranDate != toDayDate) {
                    tranDate = toDayDate;
                    sql = "update misc_payment set tran_date = ? where tran_id =?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setTimestamp(1, tranDate);
                    pstmt.setString(2, tranId);
                    int updCnt = pstmt.executeUpdate();
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ updCnt :- [" + updCnt + "]tranDate[" + tranDate + "]tranId[" + tranId + "]"));
                }
                if ((payModRefval = this.finCommon.getFinparams("999999", "PAY_MOD_REFVAL", conn)) != null && payModRefval.trim().length() > 0 && "NULLFOUND".equalsIgnoreCase(payModRefval) && (payModRefvalList = new ArrayList<String>(Arrays.asList(payModRefval.split(",")))).contains(payMode)) {
                    lbPayMode = true;
                }
                if ("O".equalsIgnoreCase(lsWfStatus) && "N".equalsIgnoreCase(confirmed)) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("168@ lbPayMode[" + lbPayMode + "]"));
                    if (lbPayMode) {
                        if ("N".equalsIgnoreCase(payMode)) {
                            llCntSundryBankDet = this.gbfCheckSundrybankDet(sundryType, sundryCode, bankCode, conn);
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("175@ llCntSundryBankDet[" + llCntSundryBankDet + "]"));
                            if (llCntSundryBankDet <= 0) {
                                String string = errString = this.itmDBAccessEJB.getErrorString("", "VMSBDNODEF", "", "", conn);
                                return string;
                            }
                            llCntSundryBankDet = this.gbfCheckSundrybankDet(sundryType, sundryCode, "", conn);
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("182@ llCntSundryBankDet[" + llCntSundryBankDet + "]"));
                            if (llCntSundryBankDet > 1) {
                                String string = errString = this.itmDBAccessEJB.getErrorString("", "VMSBDMLDEF", "", "", conn);
                                return string;
                            }
                        }
                        if (refNo != null && refNo.trim().length() > 0) {
                            String string = errString = this.itmDBAccessEJB.getErrorString("", "VTREFNTALW", "", "", conn);
                            return string;
                        }
                    }
                    if (refNo != null && refNo.trim().length() > 0 && "Q".equalsIgnoreCase(payMode.trim())) {
                        sql = "select count(*) as ll_count from misc_payment where tran_id <> ? and ref_no = ? and bank_code = ?";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, tranId);
                        pstmt.setString(2, refNo);
                        pstmt.setString(3, bankCode);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            llCount = rs.getInt("ll_count");
                        }
                        this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("llCount[" + llCount + "]"));
                        if (llCount > 0) {
                            String string = errString = this.itmDBAccessEJB.getErrorString("", "VTDUPRNO", "", "", conn);
                            return string;
                        }
                    }
                    if ("S".equalsIgnoreCase(sundryType)) {
                        sql = "select pay_mode from SUPPLIER where supp_code=?";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, sundryCode);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            supPayMode = this.checkNull(rs.getString("pay_mode"));
                        }
                        this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                        if ("N".equalsIgnoreCase(supPayMode) && !supPayMode.equalsIgnoreCase(payMode)) {
                            String string = errString = this.itmDBAccessEJB.getErrorString("", "VTPYMDDIFF", "", "", conn);
                            return string;
                        }
                    }
                    sql = "select sundry_type,stan_code,sundry_code,vouch_no,tran_ser,pay_amt from misc_paydet where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs2 = pstmt.executeQuery();
                    while (rs2.next()) {
                        sundryTypeDet = this.checkNull(rs2.getString("sundry_type"));
                        stanCode = this.checkNull(rs2.getString("stan_code"));
                        sundryCodeDet = this.checkNull(rs2.getString("sundry_code"));
                        vouchNo = this.checkNull(rs2.getString("vouch_no"));
                        tranSer = this.checkNull(rs2.getString("tran_ser"));
                        payDetamt = rs2.getDouble("pay_amt");
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("252@sundryTypeDet[" + sundryTypeDet + "]stanCode[" + stanCode + "]sundryCodeDet[" + sundryCodeDet + "]vouchNo[" + vouchNo + "]tranSer[" + tranSer + "]payDetamt[" + payDetamt + "]"));
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("258@ lbPayMode[" + lbPayMode + "]"));
                        if (lbPayMode) {
                            sql = "select sum(case when b.pay_amt is null then 0 else b.pay_amt end) as lc_pay_amt from misc_payment a,misc_paydet b where a.tran_id=b.tran_id and wf_status='S' AND CONFIRMED='N' and b.tran_id <> ? and b.VOUCH_NO = ? and b.tran_ser = ? ";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, tranId);
                            pstmt.setString(2, vouchNo);
                            pstmt.setString(3, tranSer);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                payAmt = rs.getDouble("lc_pay_amt");
                            }
                            this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("267@ payAmt[" + payAmt + "]"));
                            if (String.valueOf(payAmt) == null) {
                                payAmt = 48.0;
                            }
                            sql = "SELECT tot_amt , adj_amt ,hold_amt from misc_payables where tran_ser = ?  and ref_no = ?";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, tranSer);
                            pstmt.setString(2, vouchNo);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                totAmt = rs.getDouble("tot_amt");
                                adjAmt = rs.getDouble("adj_amt");
                                holdAmt = rs.getDouble("hold_amt");
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("284@ totAmt[" + totAmt + "]adjAmt[" + adjAmt + "]holdAmt[" + holdAmt + "]"));
                                if (!(totAmt - adjAmt - holdAmt - payAmt < payDetamt)) continue;
                                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTBAL1", "", "", conn);
                                return string;
                            }
                            this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                            if ("W".equalsIgnoreCase(payMode) || "N".equalsIgnoreCase(payMode)) {
                                sql = "select stan_code from misc_paydet where tran_id =?";
                                pstmt = conn.prepareStatement(sql);
                                pstmt.setString(1, tranId);
                                rs = pstmt.executeQuery();
                                while (rs.next()) {
                                    lsStanCode = this.checkNull(rs.getString("stan_code"));
                                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lsStanCode[" + lsStanCode + "]stanCode[" + stanCode + "]"));
                                    if (stanCode.trim().equalsIgnoreCase(lsStanCode.trim())) continue;
                                    String string = errString = this.itmDBAccessEJB.getErrorString("", "VTSTNCDDPL", "", "", conn);
                                    return string;
                                }
                                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                            }
                        }
                        if (!"T".equalsIgnoreCase(payMode) || !"E".equalsIgnoreCase(sundryTypeDet)) continue;
                        sql = "select bnk_serv_stan_req from bank where bank_code = ? ";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, bankCode);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            bnkServStanReq = this.checkNull(rs.getString("bnk_serv_stan_req"));
                        }
                        this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("bnkServStanReq[" + bnkServStanReq + "]"));
                        if (bnkServStanReq == null || bnkServStanReq.trim().length() == 0) {
                            bnkServStanReq = "Y";
                        }
                        if ("Y".equalsIgnoreCase(bnkServStanReq) && stanCode.trim().length() > 0) {
                            sql = "select count(1) as ll_count from bank_stan_serv where bank_code = ? and stan_code = ?";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, bankCode);
                            pstmt.setString(2, stanCode);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                count = rs.getInt("ll_count");
                            }
                            this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("count[" + count + "]"));
                            if (count == 0) {
                                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTINBNKSTN", "", "", conn);
                                return string;
                            }
                        }
                        sql = "select bank_acct,ifsc from employee where emp_code = ?";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, sundryCodeDet);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            bankCodeAcct = this.checkNull(rs.getString("bank_acct"));
                            ifscCode = this.checkNull(rs.getString("ifsc"));
                        }
                        this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("bankCodeAcct[" + bankCodeAcct + "]ifscCode[" + ifscCode + "]"));
                    }
                    this.closeRsPstmt(rs2, (PreparedStatement)pstmt);
                }
                if ((errString = this.gbfRetrieveMiscPay(tranId, siteCode, conn, xtraParams)) != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
            } else {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ errString in confirm:- [" + errString + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception inside MiscPayConfirm==>" + e.getMessage()));
                errString = this.genericUtility.createErrorString(e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"@V@ Exception while rollbacking222.......");
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (errString != null && errString.trim().length() > 0) {
                    if (errString.indexOf("CONFSUCCES") > -1) {
                        if (isLocalConn) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"@V@ Transaction commited111.............from MiscPayConfirm");
                            conn.commit();
                            conn.close();
                        }
                    } else if (isLocalConn) {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"@V@ CONNECTION Rollbacking..........MiscPayConfirm");
                        conn.rollback();
                        conn.close();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"@V@ CONNECTION Rollback...........MiscPayConfirm");
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (isLocalConn) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in confirm finally >>>>> " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String gbfRetrieveMiscPay(String tranId, String siteCode, Connection conn, String xtraParams) throws RemoteException, ITMException {
        String errString;
        block33: {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfRetrieveMiscPay Called...........");
            errString = "";
            String sql = "";
            String bankCode = "";
            String payType = "";
            String ignoreWarnings = "";
            String tranIDMiscPay = "";
            Timestamp tranDate = null;
            double netAmt = 0.0;
            double totAmt = 0.0;
            Statement pstmt = null;
            ResultSet rs = null;
            HashMap<String, Object> mPayHdrMap = new HashMap<String, Object>();
            Timestamp today = null;
            HashMap<String, Object> ldsHdrSuppPay = new HashMap<String, Object>();
            HashMap<String, Object> mPayDetMap = null;
            HashMap<String, Object> ldsDetSuppPayMap = null;
            ArrayList<String> tranIDList = new ArrayList<String>();
            ArrayList<HashMap> mPayDetList = new ArrayList<HashMap>();
            ArrayList<HashMap> ldsDetSuppPayList = new ArrayList<HashMap>();
            ArrayList ldsHdrSuppPayList = new ArrayList();
            try {
                PostSuppPay postsupppay = new PostSuppPay();
                today = new Timestamp(System.currentTimeMillis());
                SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
                tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today)) + " 00:00:00.000");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("479@ tranId[" + tranId + "]tranDate[" + tranDate + "]"));
                sql = " select tran_id from misc_payment where tran_id \t>= ? and tran_id <= ? and  site_code =  ? and confirmed = 'N' order by tran_id asc ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                pstmt.setString(2, tranId);
                pstmt.setString(3, siteCode);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    tranIDMiscPay = rs.getString("tran_id");
                    tranIDList.add(tranIDMiscPay);
                }
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("494@ tranIDList[" + tranIDList.toString() + "]"));
                int i = 0;
                while (i < tranIDList.size()) {
                    tranIDMiscPay = (String)tranIDList.get(i);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("499@tranIDMiscPay [" + tranIDMiscPay + "]"));
                    sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) || "mysql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "select tran_id, bank_code, net_amt, site_code, tran_date, pay_type from misc_payment where tran_id = ? for update" : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "select tran_id, bank_code, net_amt, site_code, tran_date, pay_type from misc_payment (updlock) where tran_id = ?" : "select tran_id, bank_code, net_amt, site_code, tran_date, pay_type from misc_payment where tran_id = ? for update nowait");
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranIDMiscPay);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        tranIDMiscPay = this.checkNull(rs.getString("tran_id"));
                        bankCode = this.checkNull(rs.getString("bank_code"));
                        netAmt = rs.getDouble("net_amt");
                        siteCode = this.checkNull(rs.getString("site_code"));
                        tranDate = rs.getTimestamp("tran_date");
                        payType = this.checkNull(rs.getString("pay_type"));
                    }
                    this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("526@ bankCode [" + bankCode + "] netAmt [" + netAmt + "]siteCode" + siteCode + "]tranDate[" + tranDate + "]payType[" + payType + "]"));
                    sql = "select sum(pay_amt) as lc_totamt from misc_paydet where tran_id =?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranIDMiscPay);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        totAmt = rs.getDouble("lc_totamt");
                    }
                    this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("537@ totAmt [" + totAmt + "]"));
                    if (totAmt < 0.0) {
                        String string = errString = this.itmDBAccessEJB.getErrorString("", "VTAMTMIS1", "", "", conn);
                        return string;
                    }
                    ignoreWarnings = this.finCommon.getFinparams("999999", "IGNORE_WARNINGS", conn);
                    if (ignoreWarnings == null || ignoreWarnings.trim().length() == 0 || "NULLFOUND".equalsIgnoreCase(ignoreWarnings.trim())) {
                        ignoreWarnings = "N";
                    }
                    if (ignoreWarnings.equalsIgnoreCase("N") && (errString = this.finCommon.gbfBalChk(bankCode, siteCode, tranDate, netAmt, conn)) != null && errString.trim().length() > 0) {
                        String string = errString;
                        return string;
                    }
                    if ("P".equalsIgnoreCase(payType)) {
                        sql = "SELECT MISC_PAYMENT.TRAN_ID,MISC_PAYMENT.TRAN_TYPE,MISC_PAYMENT.TRAN_DATE,MISC_PAYMENT.SUNDRY_TYPE,MISC_PAYMENT.SUNDRY_CODE,MISC_PAYMENT.SITE_CODE, MISC_PAYMENT.FIN_ENTITY,MISC_PAYMENT.PAY_MODE,MISC_PAYMENT.BANK_CODE,  MISC_PAYMENT.REF_NO,MISC_PAYMENT.REF_DATE,MISC_PAYMENT.NET_AMT,  MISC_PAYMENT.CURR_CODE,MISC_PAYMENT.NET_AMT__BC,MISC_PAYMENT.AUTO_PAID,  MISC_PAYMENT.ACCT_CODE__BAL,MISC_PAYMENT.CCTR_CODE__BAL,  MISC_PAYMENT.BANK_CHARGES,MISC_PAYMENT.CURR_CODE__BC,  MISC_PAYMENT.ACCT_CODE__BC,MISC_PAYMENT.CCTR_CODE__BC, MISC_PAYMENT.ACCT_CODE__CF,MISC_PAYMENT.CCTR_CODE__CF, MISC_PAYMENT.DIFF_AMT__EXCH,MISC_PAYMENT.REMARKS,MISC_PAYMENT.CONFIRMED, MISC_PAYMENT.CONF_DATE,MISC_PAYMENT.EMP_CODE__APRV,MISC_PAYMENT.CHG_DATE, MISC_PAYMENT.CHG_USER,MISC_PAYMENT.CHG_TERM,BANK.BANK_NAME,A.DESCR, ACCOUNTS.DESCR,MISC_PAYMENT.EXCH_RATE,MISC_PAYMENT.EXCH_RATE__BC, MISC_PAYMENT.CHQ_NAME, 0 as balance, FN_GETBANKTRANID(MISC_PAYMENT.SITE_CODE,'M-PAY',MISC_PAYMENT.TRAN_ID) as banktran_log_tran_id, MISC_PAYMENT.TAX_CHAP,MISC_PAYMENT.TAX_CLASS,  MISC_PAYMENT.TAX_ENV,MISC_PAYMENT.TAX_AMT,MISC_PAYMENT.TAX_DATE,MISC_PAYMENT.EFF_DATE,  FN_SUNDRY_NAME(misc_payment.sundry_type,misc_payment.sundry_code,'') as sundry_name, MISC_PAYMENT.SITE_CODE__BILL,B.DESCR,MISC_PAYMENT.PAY_TYPE  FROM MISC_PAYMENT,BANK,SITE A,ACCOUNTS,SITE B  WHERE ( MISC_PAYMENT.BANK_CODE = BANK.BANK_CODE )  AND  ( MISC_PAYMENT.SITE_CODE = A.SITE_CODE )  AND  ( MISC_PAYMENT.SITE_CODE__BILL = B.SITE_CODE (+) )  AND ( MISC_PAYMENT.ACCT_CODE__BAL = ACCOUNTS.ACCT_CODE ) and  ( ( misc_payment.tran_id = ? ) )  ";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, tranIDMiscPay);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            ldsHdrSuppPay = new HashMap();
                            ldsHdrSuppPay.put("tran_id", this.checkNull(rs.getString("tran_id")));
                            ldsHdrSuppPay.put("tran_type", this.checkNull(rs.getString("tran_type")));
                            ldsHdrSuppPay.put("tran_date", rs.getTimestamp("tran_date"));
                            ldsHdrSuppPay.put("sundry_type", this.checkNull(rs.getString("sundry_type")));
                            ldsHdrSuppPay.put("sundry_code", this.checkNull(rs.getString("sundry_code")));
                            ldsHdrSuppPay.put("site_code", this.checkNull(rs.getString("site_code")));
                            ldsHdrSuppPay.put("fin_entity", this.checkNull(rs.getString("fin_entity")));
                            ldsHdrSuppPay.put("pay_mode", this.checkNull(rs.getString("pay_mode")));
                            ldsHdrSuppPay.put("bank_code", this.checkNull(rs.getString("bank_code")));
                            ldsHdrSuppPay.put("ref_no", this.checkNull(rs.getString("ref_no")));
                            ldsHdrSuppPay.put("ref_date", rs.getTimestamp("ref_date"));
                            ldsHdrSuppPay.put("bank_charges", rs.getDouble("bank_charges"));
                            ldsHdrSuppPay.put("curr_code__bc", this.checkNull(rs.getString("curr_code__bc")));
                            ldsHdrSuppPay.put("net_amt", rs.getDouble("net_amt"));
                            ldsHdrSuppPay.put("curr_code", this.checkNull(rs.getString("curr_code")));
                            ldsHdrSuppPay.put("net_amt__bc", rs.getDouble("net_amt__bc"));
                            ldsHdrSuppPay.put("auto_paid", this.checkNull(rs.getString("auto_paid")));
                            ldsHdrSuppPay.put("acct_code__bal", this.checkNull(rs.getString("acct_code__bal")));
                            ldsHdrSuppPay.put("cctr_code__bal", this.checkNull(rs.getString("cctr_code__bal")));
                            ldsHdrSuppPay.put("acct_code__bc", this.checkNull(rs.getString("acct_code__bc")));
                            ldsHdrSuppPay.put("cctr_code__bc", this.checkNull(rs.getString("cctr_code__bc")));
                            ldsHdrSuppPay.put("acct_code__cf", this.checkNull(rs.getString("acct_code__cf")));
                            ldsHdrSuppPay.put("cctr_code__cf", this.checkNull(rs.getString("cctr_code__cf")));
                            ldsHdrSuppPay.put("diff_amt__exch", rs.getDouble("diff_amt__exch"));
                            ldsHdrSuppPay.put("remarks", this.checkNull(rs.getString("remarks")));
                            ldsHdrSuppPay.put("confirmed", this.checkNull(rs.getString("confirmed")));
                            ldsHdrSuppPay.put("conf_date", rs.getTimestamp("conf_date"));
                            ldsHdrSuppPay.put("emp_code__aprv", this.checkNull(rs.getString("emp_code__aprv")));
                            ldsHdrSuppPay.put("bank_name", this.checkNull(rs.getString("bank_name")));
                            ldsHdrSuppPay.put("exch_rate", rs.getDouble("exch_rate"));
                            ldsHdrSuppPay.put("exch_rate__bc", rs.getDouble("exch_rate__bc"));
                            ldsHdrSuppPay.put("chq_name", this.checkNull(rs.getString("chq_name")));
                            ldsHdrSuppPay.put("balance", rs.getDouble("balance"));
                            ldsHdrSuppPay.put("banktran_log_tran_id", this.checkNull(rs.getString("banktran_log_tran_id")));
                            ldsHdrSuppPay.put("tax_chap", this.checkNull(rs.getString("tax_chap")));
                            ldsHdrSuppPay.put("tax_class", this.checkNull(rs.getString("tax_class")));
                            ldsHdrSuppPay.put("tax_env", this.checkNull(rs.getString("tax_env")));
                            ldsHdrSuppPay.put("tax_amt", rs.getDouble("tax_amt"));
                            ldsHdrSuppPay.put("tax_date", rs.getTimestamp("tax_date"));
                            ldsHdrSuppPay.put("eff_date", rs.getTimestamp("eff_date"));
                            ldsHdrSuppPay.put("sundry_name", this.checkNull(rs.getString("sundry_name")));
                            ldsHdrSuppPay.put("site_code__bill", this.checkNull(rs.getString("site_code__bill")));
                            ldsHdrSuppPay.put("pay_type", this.checkNull(rs.getString("pay_type")));
                        }
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        tranId = (String)ldsHdrSuppPay.get("tran_id");
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ ldsHdrSuppPay[" + ldsHdrSuppPay.toString() + "]tranId[" + tranId + "]"));
                        sql = "select  MISC_PAYDET.tran_id,MISC_PAYDET.tran_ser,MISC_PAYDET.vouch_no,MISC_PAYDET.vouch_date,MISC_PAYDET.net_amt,MISC_PAYDET.pay_amt,MISC_PAYDET.curr_code,MISC_PAYDET.diff_amt__exch,MISC_PAYDET.acct_code__ap,MISC_PAYDET.cctr_code__ap,MISC_PAYDET.sundry_type,MISC_PAYDET.sundry_code,MISC_PAYDET.bank_charges,MISC_PAYDET.exch_rate__vouch,MISC_PAYDET.stan_code,MISC_PAYDET.tax_chap,MISC_PAYDET.tax_class,MISC_PAYDET.tax_env,MISC_PAYDET.net_pay_amt,MISC_PAYDET.tax_amt,MISC_PAYDET.line_no,MISC_PAYABLES.bill_no,MISC_PAYABLES.bill_date,MISC_PAYABLES.due_date,MISC_PAYDET.exch_rate,MISC_PAYMENT.site_code__bill from misc_paydet,accounts,misc_payables,MISC_PAYMENT WHERE ( MISC_PAYDET.ACCT_CODE__AP = ACCOUNTS.ACCT_CODE (+))AND ( MISC_PAYABLES.TRAN_SER = MISC_PAYDET.TRAN_SER ) AND (  MISC_PAYABLES.REF_NO = MISC_PAYDET.VOUCH_NO ) and (misc_paydet.tran_id  = MISC_PAYMENT.tran_id)AND  ( misc_paydet.tran_id = ? ) ";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, tranId);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            ldsDetSuppPayMap = new HashMap<String, Object>();
                            ldsDetSuppPayMap.put("tran_id", this.checkNull(rs.getString("tran_id")));
                            ldsDetSuppPayMap.put("tran_ser", this.checkNull(rs.getString("tran_ser")));
                            ldsDetSuppPayMap.put("vouch_no", this.checkNull(rs.getString("vouch_no")));
                            ldsDetSuppPayMap.put("vouch_date", rs.getTimestamp("vouch_date"));
                            ldsDetSuppPayMap.put("net_amt", rs.getDouble("net_amt"));
                            ldsDetSuppPayMap.put("pay_amt", rs.getDouble("pay_amt"));
                            ldsDetSuppPayMap.put("curr_code", rs.getString("curr_code"));
                            ldsDetSuppPayMap.put("diff_amt__exch", rs.getDouble("diff_amt__exch"));
                            ldsDetSuppPayMap.put("acct_code__ap", this.checkNull(rs.getString("acct_code__ap")));
                            ldsDetSuppPayMap.put("cctr_code__ap", this.checkNull(rs.getString("cctr_code__ap")));
                            ldsDetSuppPayMap.put("sundry_type", this.checkNull(rs.getString("sundry_type")));
                            ldsDetSuppPayMap.put("sundry_code", this.checkNull(rs.getString("sundry_code")));
                            ldsDetSuppPayMap.put("bank_charges", this.checkNull(rs.getString("bank_charges")));
                            ldsDetSuppPayMap.put("exch_rate__vouch", rs.getDouble("exch_rate__vouch"));
                            ldsDetSuppPayMap.put("stan_code", this.checkNull(rs.getString("stan_code")));
                            ldsDetSuppPayMap.put("tax_chap", this.checkNull(rs.getString("tax_chap")));
                            ldsDetSuppPayMap.put("tax_class", this.checkNull(rs.getString("tax_class")));
                            ldsDetSuppPayMap.put("tax_env", this.checkNull(rs.getString("tax_env")));
                            ldsDetSuppPayMap.put("net_pay_amt", rs.getDouble("net_pay_amt"));
                            ldsDetSuppPayMap.put("tax_amt", rs.getDouble("tax_amt"));
                            ldsDetSuppPayMap.put("line_no", rs.getInt("line_no"));
                            ldsDetSuppPayMap.put("bill_no", this.checkNull(rs.getString("bill_no")));
                            ldsDetSuppPayMap.put("bill_date", rs.getTimestamp("bill_date"));
                            ldsDetSuppPayMap.put("due_date", rs.getTimestamp("due_date"));
                            ldsDetSuppPayMap.put("exch_rate", rs.getDouble("exch_rate"));
                            ldsDetSuppPayMap.put("site_code__bill", this.checkNull(rs.getString("site_code__bill")));
                            ldsDetSuppPayList.add(ldsDetSuppPayMap);
                        }
                        this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ ldsDetSuppPayList.size :- [" + ldsDetSuppPayList.toString() + "]"));
                        errString = postsupppay.gbfPostSuppPay(tranId, ldsHdrSuppPay, ldsDetSuppPayList, xtraParams, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ errString 701:- [" + errString + "]"));
                    } else {
                        sql = "SELECT  misc_payment.tran_id ,misc_payment.tran_type ,misc_payment.tran_date ,misc_payment.sundry_type ,misc_payment.sundry_code ,misc_payment.site_code ,misc_payment.fin_entity ,misc_payment.pay_mode ,misc_payment.bank_code ,misc_payment.ref_no ,misc_payment.ref_date ,misc_payment.net_amt ,misc_payment.curr_code ,misc_payment.net_amt__bc ,misc_payment.auto_paid ,misc_payment.acct_code__bal ,misc_payment.cctr_code__bal ,misc_payment.bank_charges ,misc_payment.curr_code__bc ,misc_payment.acct_code__bc ,misc_payment.cctr_code__bc ,misc_payment.acct_code__cf ,misc_payment.cctr_code__cf ,misc_payment.diff_amt__exch ,misc_payment.remarks ,misc_payment.confirmed ,misc_payment.conf_date ,misc_payment.emp_code__aprv ,misc_payment.chg_date ,misc_payment.chg_user ,misc_payment.chg_term ,bank.bank_name ,site.descr ,accounts.descr ,misc_payment.exch_rate ,misc_payment.exch_rate__bc ,misc_payment.chq_name ,0 as balance,FN_GETBANKTRANID(MISC_PAYMENT.SITE_CODE,'M-PAY',MISC_PAYMENT.TRAN_ID) as banktran_log_tran_id,misc_payment.tax_chap ,misc_payment.tax_class ,misc_payment.tax_env ,misc_payment.tax_amt ,misc_payment.tax_date ,FN_SUNDRY_NAME(misc_payment.sundry_type,misc_payment.sundry_code,'') as sundry_name,misc_payment.eff_date ,misc_payment.parent__tran_id ,net_amt__bc +  (bank_charges * exch_rate__bc) as chq_amt,misc_payment.discount_amt ,misc_payment.amt_option ,misc_payment.wf_status ,misc_payment.osbc_by ,misc_payment.bank_code__ben ,misc_payment.emp_code__submit ,misc_payment.submit_date ,misc_payment.no_comments ,misc_payment.no_attachments ,misc_payment.add_date ,misc_payment.add_user ,misc_payment.add_term,misc_payment.wf_status FROM misc_payment ,bank ,site ,accounts WHERE ( misc_payment.bank_code = bank.bank_code ) and ( misc_payment.site_code = site.site_code ) and ( misc_payment.acct_code__bal = accounts.acct_code ) and ( ( misc_payment.tran_id = ? ) )   ";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, tranIDMiscPay);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            mPayHdrMap = new HashMap();
                            mPayHdrMap.put("tran_id", this.checkNull(rs.getString("tran_id")));
                            mPayHdrMap.put("tran_type", this.checkNull(rs.getString("tran_type")));
                            mPayHdrMap.put("tran_date", rs.getTimestamp("tran_date"));
                            mPayHdrMap.put("sundry_type", this.checkNull(rs.getString("sundry_type")));
                            mPayHdrMap.put("sundry_code", this.checkNull(rs.getString("sundry_code")));
                            mPayHdrMap.put("site_code", this.checkNull(rs.getString("site_code")));
                            mPayHdrMap.put("fin_entity", this.checkNull(rs.getString("fin_entity")));
                            mPayHdrMap.put("pay_mode", this.checkNull(rs.getString("pay_mode")));
                            mPayHdrMap.put("bank_code", this.checkNull(rs.getString("bank_code")));
                            mPayHdrMap.put("ref_no", this.checkNull(rs.getString("ref_no")));
                            mPayHdrMap.put("ref_date", rs.getTimestamp("ref_date"));
                            mPayHdrMap.put("net_amt", rs.getDouble("net_amt"));
                            mPayHdrMap.put("curr_code", this.checkNull(rs.getString("curr_code")));
                            mPayHdrMap.put("net_amt__bc", rs.getDouble("net_amt__bc"));
                            mPayHdrMap.put("auto_paid", this.checkNull(rs.getString("auto_paid")));
                            mPayHdrMap.put("acct_code__bal", this.checkNull(rs.getString("acct_code__bal")));
                            mPayHdrMap.put("cctr_code__bal", rs.getString("cctr_code__bal"));
                            mPayHdrMap.put("bank_charges", rs.getDouble("bank_charges"));
                            mPayHdrMap.put("curr_code__bc", this.checkNull(rs.getString("curr_code__bc")));
                            mPayHdrMap.put("acct_code__bc", this.checkNull(rs.getString("acct_code__bc")));
                            mPayHdrMap.put("cctr_code__bc", this.checkNull(rs.getString("cctr_code__bc")));
                            mPayHdrMap.put("acct_code__cf", this.checkNull(rs.getString("acct_code__cf")));
                            mPayHdrMap.put("cctr_code__cf", this.checkNull(rs.getString("cctr_code__cf")));
                            mPayHdrMap.put("diff_amt__exch", rs.getDouble("diff_amt__exch"));
                            mPayHdrMap.put("remarks", this.checkNull(rs.getString("remarks")));
                            mPayHdrMap.put("confirmed", this.checkNull(rs.getString("confirmed")));
                            mPayHdrMap.put("conf_date", rs.getTimestamp("conf_date"));
                            mPayHdrMap.put("emp_code__aprv", this.checkNull(rs.getString("emp_code__aprv")));
                            mPayHdrMap.put("chg_date", rs.getTimestamp("chg_date"));
                            mPayHdrMap.put("chg_user", this.checkNull(rs.getString("chg_user")));
                            mPayHdrMap.put("chg_term", this.checkNull(rs.getString("chg_term")));
                            mPayHdrMap.put("exch_rate", rs.getDouble("exch_rate"));
                            mPayHdrMap.put("exch_rate__bc", rs.getDouble("exch_rate__bc"));
                            mPayHdrMap.put("chq_name", this.checkNull(rs.getString("chq_name")));
                            mPayHdrMap.put("tax_chap", this.checkNull(rs.getString("tax_chap")));
                            mPayHdrMap.put("tax_class", this.checkNull(rs.getString("tax_class")));
                            mPayHdrMap.put("tax_env", this.checkNull(rs.getString("tax_env")));
                            mPayHdrMap.put("tax_amt", rs.getDouble("tax_amt"));
                            mPayHdrMap.put("tax_date", rs.getTimestamp("tax_date"));
                            mPayHdrMap.put("eff_date", rs.getTimestamp("eff_date"));
                            mPayHdrMap.put("parent__tran_id", this.checkNull(rs.getString("parent__tran_id")));
                            mPayHdrMap.put("emp_code__submit", this.checkNull(rs.getString("emp_code__submit")));
                            mPayHdrMap.put("submit_date", rs.getTimestamp("submit_date"));
                            mPayHdrMap.put("no_comments", this.checkNull(rs.getString("no_comments")));
                            mPayHdrMap.put("no_attachments", this.checkNull(rs.getString("no_attachments")));
                            mPayHdrMap.put("add_date", rs.getTimestamp("add_date"));
                            mPayHdrMap.put("add_user", this.checkNull(rs.getString("add_user")));
                            mPayHdrMap.put("add_term", this.checkNull(rs.getString("add_term")));
                            mPayHdrMap.put("wf_status", this.checkNull(rs.getString("wf_status")));
                        }
                        this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                        tranId = (String)mPayHdrMap.get("tran_id");
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ mPayHdrMap.size :- [" + mPayHdrMap.toString() + "]tranId[" + tranId + "]"));
                        sql = "SELECT  misc_paydet.tran_id ,misc_paydet.tran_ser ,misc_paydet.vouch_no ,misc_paydet.vouch_date ,misc_paydet.net_amt ,misc_paydet.pay_amt ,misc_paydet.curr_code ,misc_paydet.diff_amt__exch ,misc_paydet.acct_code__ap ,misc_paydet.cctr_code__ap ,accounts.descr ,misc_paydet.sundry_type ,misc_paydet.sundry_code ,misc_paydet.instr_no ,misc_paydet.instr_date ,misc_paydet.bank_charges ,misc_paydet.exch_rate__vouch ,misc_paydet.drawn_at ,misc_paydet.stan_code ,misc_paydet.tax_chap ,misc_paydet.tax_class ,misc_paydet.tax_env ,misc_paydet.net_pay_amt ,misc_paydet.tax_amt ,misc_paydet.line_no ,misc_payables.bill_no ,misc_payables.bill_date ,misc_paydet.discount ,misc_paydet.discount_amt ,misc_paydet.acct_code__disc ,misc_paydet.cctr_code__disc ,misc_paydet.exch_rate FROM misc_paydet  misc_paydet,accounts  accounts,misc_payables  misc_payables WHERE ( misc_payables.tran_ser = misc_paydet.tran_ser ) and ( misc_payables.ref_no = misc_paydet.vouch_no ) and ( misc_paydet.acct_code__ap=accounts.acct_code(+)) and ( ( misc_paydet.tran_id = ? ) )   ";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, tranId);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            mPayDetMap = new HashMap<String, Object>();
                            mPayDetMap.put("tran_id", this.checkNull(rs.getString("tran_id")));
                            mPayDetMap.put("tran_ser", this.checkNull(rs.getString("tran_ser")));
                            mPayDetMap.put("vouch_no", rs.getString("vouch_no"));
                            mPayDetMap.put("vouch_date", rs.getTimestamp("vouch_date"));
                            mPayDetMap.put("net_amt", rs.getDouble("net_amt"));
                            mPayDetMap.put("pay_amt", rs.getDouble("pay_amt"));
                            mPayDetMap.put("curr_code", this.checkNull(rs.getString("curr_code")));
                            mPayDetMap.put("diff_amt__exch", rs.getDouble("diff_amt__exch"));
                            mPayDetMap.put("acct_code__ap", this.checkNull(rs.getString("acct_code__ap")));
                            mPayDetMap.put("cctr_code__ap", this.checkNull(rs.getString("cctr_code__ap")));
                            mPayDetMap.put("sundry_type", this.checkNull(rs.getString("sundry_type")));
                            mPayDetMap.put("sundry_code", this.checkNull(rs.getString("sundry_code")));
                            mPayDetMap.put("instr_no", this.checkNull(rs.getString("instr_no")));
                            mPayDetMap.put("instr_date", rs.getTimestamp("instr_date"));
                            mPayDetMap.put("bank_charges", rs.getDouble("bank_charges"));
                            mPayDetMap.put("exch_rate__vouch", rs.getDouble("exch_rate__vouch"));
                            mPayDetMap.put("drawn_at", this.checkNull(rs.getString("drawn_at")));
                            mPayDetMap.put("stan_code", this.checkNull(rs.getString("stan_code")));
                            mPayDetMap.put("tax_chap", this.checkNull(rs.getString("tax_chap")));
                            mPayDetMap.put("tax_class", this.checkNull(rs.getString("tax_class")));
                            mPayDetMap.put("tax_env", this.checkNull(rs.getString("tax_env")));
                            mPayDetMap.put("net_pay_amt", rs.getDouble("net_pay_amt"));
                            mPayDetMap.put("tax_amt", rs.getDouble("tax_amt"));
                            mPayDetMap.put("line_no", rs.getInt("line_no"));
                            mPayDetMap.put("bill_no", this.checkNull(rs.getString("bill_no")));
                            mPayDetMap.put("bill_date", rs.getTimestamp("bill_date"));
                            mPayDetMap.put("discount", rs.getDouble("discount"));
                            mPayDetMap.put("bill_no", this.checkNull(rs.getString("bill_no")));
                            mPayDetMap.put("bill_date", rs.getTimestamp("bill_date"));
                            mPayDetMap.put("discount", rs.getDouble("discount"));
                            mPayDetList.add(mPayDetMap);
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ mPayDetList 838:-[" + mPayDetList.toString() + "]"));
                        }
                        this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                        errString = this.gbfPostMiscPay(tranId, mPayHdrMap, mPayDetList, conn, xtraParams);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ errString return afteer gbfPostMiscPay 843:- [" + errString + "]"));
                    }
                    ++i;
                }
                if (errString == null || errString.trim().length() == 0) {
                    errString = this.itmDBAccessEJB.getErrorString("", "CONFSUCCES", "", "", conn);
                    break block33;
                }
                String string = errString;
                return string;
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in catch gbfRetrieveMiscPay==>" + e.getMessage()));
                e.printStackTrace();
                throw new ITMException(e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return errString;
    }

    private String gbfPostMiscPay(String tranId, HashMap mPayHdrMap, ArrayList<HashMap> mPayDetList, Connection conn, String xtraParams) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfPostMiscPay called >>>>>>");
        String retString = "";
        String sql = "";
        String sql1 = "";
        Statement pstmt = null;
        Object pstmt1 = null;
        ResultSet rs = null;
        Object rs1 = null;
        String errorCode = "";
        String custCode = "";
        String siteCode = "";
        String remarks = "";
        String tranSer = "";
        String loginSiteCode = "";
        String wfStatus = "";
        String confirmed = "";
        String todayDate = "";
        String postOnline = "";
        String currDateStr = "";
        String loginEmpCode = "";
        Timestamp tranDate = null;
        Object today = null;
        Object custRefDate = null;
        Object gpDate = null;
        String currCode = "";
        String acctCode = "";
        String cctrCode = "";
        String autoRcp = "";
        String bankCode = "";
        String recd = "";
        String refType = "";
        String crTerm = "";
        String itemSer = "";
        String salesPers = "";
        String salesPers1 = "";
        String salesPers2 = "";
        String custRefNo = "";
        String gpNo = "";
        String chgUser = "";
        String chgTerm = "";
        String invoiceID = "";
        double exchRate = 0.0;
        double discount = 0.0;
        double taxAmount = 0.0;
        double custRefAmount = 0.0;
        double amountBc = 0.0;
        double cnt = 0.0;
        boolean llRows = false;
        SimpleDateFormat sdf = null;
        HashMap hdrMap = new HashMap();
        try {
            tranDate = new Timestamp(System.currentTimeMillis());
            sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
            currDateStr = sdf.format(tranDate);
            chgUser = this.checkNullAndTrim(this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
            chgTerm = this.checkNullAndTrim(this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postMiscPayHdr---->[" + retString + "]tranId[" + tranId + "]"));
            if (chgTerm == null && chgTerm.trim().length() == 0) {
                chgTerm = "SYSTEM";
            }
            retString = this.gbfPostMiscPayhdr(tranId, mPayHdrMap, mPayDetList, conn, xtraParams);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postMiscPayHdr---->[" + retString + "]"));
            if (retString != null && retString.trim().length() > 0) {
                String string = retString;
                return string;
            }
            retString = this.gbfPostMiscPaydet(tranId, mPayHdrMap, mPayDetList, conn, xtraParams);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("After postMiscPayDet---->[" + retString + "]"));
            if (retString != null && retString.trim().length() > 0) {
                String string = retString;
                return string;
            }
            postOnline = this.checkNullAndTrim(this.finCommon.getFinparams("999999", "POST_ON_LINE", conn));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("PostOnline[" + postOnline + "]"));
            if ("Y".equals(postOnline)) {
                retString = this.finCommon.checkGlTranDrCr("M-PAY", tranId, conn);
            }
            if (retString != null && retString.trim().length() > 0) {
                String string = retString;
                return string;
            }
            try {
                confirmed = (String)mPayHdrMap.get("confirmed");
                if (!"Y".equalsIgnoreCase(confirmed)) {
                    sql = "update misc_payment set confirmed = 'Y', conf_date = ? ,emp_code__aprv = ?  where tran_id = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setTimestamp(1, tranDate);
                    pstmt.setString(2, loginEmpCode);
                    pstmt.setString(3, tranId);
                    pstmt.executeUpdate();
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    wfStatus = (String)mPayHdrMap.get("wf_status");
                    if ((retString == null || retString.trim().length() == 0) && "S".equalsIgnoreCase(wfStatus)) {
                        sql = "update misc_payment set wf_status = 'C' where tran_id = ? ";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, tranId);
                        pstmt.executeUpdate();
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception inside gbfPostMiscPay==>" + e.getMessage()));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retString;
    }

    private String gbfPostMiscPayhdr(String tranId, HashMap mPayHdrMap, ArrayList<HashMap> mPayDetList, Connection conn, String xtraParams) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfPostMiscPayhdr Called............");
        String errString = "";
        String sql = "";
        String payMode = "";
        String stanCode = "";
        String stancd = "";
        String tranType = "";
        String acctCodeDisc = "";
        String cctrCodeDisc = "";
        String cctrCodeCf = "";
        String confirmed = "";
        String loginEmpCode = "";
        String lsWfStatus = "";
        String dataStr = "";
        Statement pstmt = null;
        ResultSet rs = null;
        double hexchRate = 0.0;
        double exchRate = 0.0;
        double payAmt = 0.0;
        double taxAmt = 0.0;
        double discountAmt = 0.0;
        double netAmt = 0.0;
        double totNetAmt = 0.0;
        double netAmtBc = 0.0;
        double lcAmt = 0.0;
        double lcBnkchg = 0.0;
        double lcDiscAmt = 0.0;
        HashMap mPayDetMap = null;
        HashMap<String, Object> lstrGltrace = new HashMap<String, Object>();
        HashMap lstrSundrybal = new HashMap();
        HashMap lstrBanktranlog = new HashMap();
        boolean lbBchg = false;
        int lsEdiOption = 0;
        int count = 0;
        Timestamp tranDate = null;
        Timestamp today = null;
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ xtraParams :- [" + xtraParams + "]"));
            hexchRate = Double.valueOf(mPayHdrMap.get("exch_rate") == null ? "0.00" : mPayHdrMap.get("exch_rate").toString());
            today = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
            tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today)) + " 00:00:00.000");
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@@ hexchRate[" + hexchRate + "]tranId[" + tranId + "]loginEmpCode[" + loginEmpCode + "]tranDate[" + tranDate + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("mPayDetList[" + mPayDetList.toString() + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("mPayHdrMap[" + mPayHdrMap.toString() + "]"));
            int ctr = 0;
            while (ctr < mPayDetList.size()) {
                mPayDetMap = new HashMap();
                mPayDetMap = mPayDetList.get(ctr);
                exchRate = Double.valueOf(mPayDetMap.get("exch_rate") == null ? "0.00" : mPayDetMap.get("exch_rate").toString());
                if (String.valueOf(exchRate) == null || exchRate == 0.0) {
                    exchRate = hexchRate;
                }
                payAmt = Double.valueOf(mPayDetMap.get("pay_amt") == null ? "0.00" : mPayDetMap.get("pay_amt").toString());
                taxAmt = Double.valueOf(mPayDetMap.get("tax_amt") == null ? "0.00" : mPayDetMap.get("tax_amt").toString());
                discountAmt = Double.valueOf(mPayDetMap.get("discount_amt") == null ? "0.00" : mPayDetMap.get("discount_amt").toString());
                netAmt = (payAmt + taxAmt - discountAmt) * (exchRate / hexchRate);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@@exchRate[" + exchRate + "]payAmt[" + payAmt + "]taxAmt[" + taxAmt + "]discountAmt[" + discountAmt + "]netAmt[" + netAmt + "]totNetAmt[" + (totNetAmt += netAmt) + "]"));
                ++ctr;
            }
            payMode = mPayHdrMap.get("pay_mode") == null ? "" : mPayHdrMap.get("pay_mode").toString();
            sql = "select count(*) as cnt from misc_paydet where tran_id =? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt("cnt");
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Detail count[" + count + "]"));
            this.closeRsPstmt(rs, (PreparedStatement)pstmt);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@payMode[" + payMode + "]stanCode[" + stanCode + "]"));
            netAmtBc = totNetAmt * hexchRate;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("netAmtBc[" + netAmtBc + "]"));
            sql = "update misc_payment set net_amt = ?,net_amt__bc = ? where tran_id =?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setDouble(1, totNetAmt);
            pstmt.setDouble(2, netAmtBc);
            pstmt.setString(3, tranId);
            int updCnt = pstmt.executeUpdate();
            this.closeRsPstmt(rs, (PreparedStatement)pstmt);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ updCnt misc_payment :- [" + updCnt + "]"));
            lstrGltrace.put("cr_amt", totNetAmt);
            if (totNetAmt < 0.0) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTAMT1", "", "", conn);
                return string;
            }
            tranType = mPayHdrMap.get("tran_type").toString();
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranType[" + tranType + "]"));
            if ("J".equalsIgnoreCase(tranType.trim()) && totNetAmt > 0.0) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTPAYJVAMT", "", "", conn);
                return string;
            }
            lstrGltrace.put("tran_date", mPayHdrMap.get("tran_date"));
            lstrGltrace.put("eff_date", mPayHdrMap.get("ref_date"));
            lstrGltrace.put("fin_entity", mPayHdrMap.get("fin_entity"));
            lstrGltrace.put("site_code", mPayHdrMap.get("site_code"));
            lstrGltrace.put("sundry_type", Character.valueOf('B'));
            lstrGltrace.put("sundry_code", mPayHdrMap.get("bank_code"));
            lstrGltrace.put("acct_code", mPayHdrMap.get("acct_code__bal"));
            lstrGltrace.put("cctr_code", mPayHdrMap.get("cctr_code__bal"));
            lstrGltrace.put("emp_code", "");
            lstrGltrace.put("anal_code", "");
            lstrGltrace.put("curr_code", mPayHdrMap.get("curr_code"));
            lstrGltrace.put("exch_rate", mPayHdrMap.get("exch_rate"));
            lstrGltrace.put("dr_amt", 0.0);
            String string = mPayHdrMap.get("bank_charges") == null ? "0.00" : mPayHdrMap.get("bank_charges").toString();
            if (Double.valueOf(string) > 0.0) {
                sql = "select sum(case when net_pay_amt is null then 0 else net_pay_amt end) as lc_amt, sum(case when bank_charges is null then 0 else bank_charges end) as lc_bnkchg from misc_paydet where tran_id =?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    lcAmt = rs.getDouble("lc_amt");
                    lcBnkchg = rs.getDouble("lc_bnkchg");
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lcAmt[" + lcAmt + "]lcBnkchg[" + lcBnkchg + "]"));
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                if (mPayHdrMap.get("curr_code").toString().equalsIgnoreCase(mPayHdrMap.get("curr_code__bc").toString())) {
                    lstrGltrace.put("cr_amt", lcAmt + lcBnkchg);
                } else {
                    lstrGltrace.put("cr_amt", lcAmt);
                    lbBchg = true;
                }
            } else {
                lstrGltrace.put("cr_amt", totNetAmt);
            }
            lstrGltrace.put("ref_type", "F");
            lstrGltrace.put("ref_ser", "M-PAY");
            lstrGltrace.put("ref_id", mPayHdrMap.get("tran_id"));
            lstrGltrace.put("remarks", mPayHdrMap.get("remarks"));
            errString = this.finCommon.glTraceUpdate(lstrGltrace, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@1198 errString after glTraceUpdate [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string2 = errString;
                return string2;
            }
            String string3 = mPayHdrMap.get("discount_amt") == null ? "0.00" : mPayHdrMap.get("discount_amt").toString();
            if (Double.valueOf(string3) > 0.0) {
                sql = "select sum(case when discount_amt is null then 0 else discount_amt end) as lc_disc_amt, acct_code__disc,cctr_code__disc from misc_paydet where tran_id = ? group by acct_code__disc,cctr_code__disc";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    lcDiscAmt = rs.getDouble("lc_disc_amt");
                    acctCodeDisc = rs.getString("acct_code__disc");
                    cctrCodeDisc = rs.getString("cctr_code__disc");
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("1218@ lcDiscAmt[" + lcDiscAmt + "]acctCodeDisc[" + acctCodeDisc + "]cctrCodeDisc[" + cctrCodeDisc + "]"));
                    if (lcDiscAmt == 0.0) continue;
                    lstrGltrace.put("acct_code", acctCodeDisc);
                    lstrGltrace.put("cctr_code", cctrCodeDisc);
                    lstrGltrace.put("dr_amt", 0.0);
                    lstrGltrace.put("cr_amt", lcDiscAmt);
                    lstrGltrace.put("sundry_type", "O");
                    errString = this.finCommon.glTraceUpdate(lstrGltrace, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@1227 errString after glTraceUpdate [" + errString + "]"));
                    if (errString == null || errString.trim().length() <= 0) continue;
                    String string4 = errString;
                    return string4;
                }
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
            }
            String string5 = mPayHdrMap.get("bank_charges") == null ? "0.00" : mPayHdrMap.get("bank_charges").toString();
            if (Double.valueOf(string5) > 0.0) {
                lstrGltrace.put("tran_date", mPayHdrMap.get("tran_date"));
                lstrGltrace.put("eff_date", mPayHdrMap.get("ref_date"));
                lstrGltrace.put("fin_entity", mPayHdrMap.get("fin_entity"));
                lstrGltrace.put("site_code", mPayHdrMap.get("site_code"));
                lstrGltrace.put("sundry_type", "O");
                lstrGltrace.put("sundry_code", " ");
                lstrGltrace.put("acct_code", mPayHdrMap.get("acct_code__bc"));
                lstrGltrace.put("cctr_code", mPayHdrMap.get("cctr_code__bc"));
                lstrGltrace.put("emp_code", "");
                lstrGltrace.put("anal_code", "");
                lstrGltrace.put("curr_code", mPayHdrMap.get("curr_code__bc"));
                lstrGltrace.put("exch_rate", mPayHdrMap.get("exch_rate__bc"));
                lstrGltrace.put("dr_amt", mPayHdrMap.get("bank_charges"));
                lstrGltrace.put("cr_amt", 0.0);
                lstrGltrace.put("ref_type", "F");
                lstrGltrace.put("ref_ser", "M-PAY");
                lstrGltrace.put("ref_id", mPayHdrMap.get("tran_id"));
                lstrGltrace.put("remarks", mPayHdrMap.get("remarks"));
                errString = this.finCommon.glTraceUpdate(lstrGltrace, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@1260 errString after glTraceUpdate:- [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string6 = errString;
                    return string6;
                }
            }
            if (Double.valueOf(mPayHdrMap.get("diff_amt__exch") == null ? "0.00" : mPayHdrMap.get("diff_amt__exch").toString()) != 0.0) {
                lstrGltrace.put("tran_date", mPayHdrMap.get("tran_date"));
                lstrGltrace.put("eff_date", mPayHdrMap.get("ref_date"));
                lstrGltrace.put("fin_entity", mPayHdrMap.get("fin_entity"));
                lstrGltrace.put("site_code", mPayHdrMap.get("site_code"));
                lstrGltrace.put("sundry_type", "O");
                lstrGltrace.put("sundry_code", " ");
                lstrGltrace.put("acct_code", mPayHdrMap.get("acct_code__cf"));
                cctrCodeCf = mPayHdrMap.get("cctr_code__cf").toString();
                if (cctrCodeCf == null || cctrCodeCf.trim().length() <= 0) {
                    cctrCodeCf = mPayDetMap.get("cctr_code__ap").toString();
                }
                lstrGltrace.put("cctr_code", cctrCodeCf);
                lstrGltrace.put("emp_code", "");
                lstrGltrace.put("anal_code", "");
                lstrGltrace.put("curr_code", mPayHdrMap.get("curr_code"));
                lstrGltrace.put("exch_rate", 1);
                String string7 = mPayHdrMap.get("diff_amt__exch") == null ? "0.00" : mPayHdrMap.get("diff_amt__exch").toString();
                if (Double.valueOf(string7) > 0.0) {
                    lstrGltrace.put("dr_amt", 0.0);
                    lstrGltrace.put("cr_amt", mPayHdrMap.get("diff_amt__exch"));
                } else {
                    lstrGltrace.put("dr_amt", 0.0 - Double.valueOf(mPayHdrMap.get("diff_amt__exch") == null ? "0.00" : mPayHdrMap.get("diff_amt__exch").toString()));
                    lstrGltrace.put("cr_amt", 0.0);
                }
                lstrGltrace.put("ref_type", "F");
                lstrGltrace.put("ref_ser", "M-PAY");
                lstrGltrace.put("ref_id", mPayHdrMap.get("tran_id"));
                lstrGltrace.put("remarks", mPayHdrMap.get("remarks"));
                errString = this.finCommon.glTraceUpdate(lstrGltrace, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@1305 errString after glTraceUpdate [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string8 = errString;
                    return string8;
                }
            }
            lstrSundrybal.put("tran_date", mPayHdrMap.get("tran_date"));
            lstrSundrybal.put("eff_date", mPayHdrMap.get("ref_date"));
            lstrSundrybal.put("fin_entity", mPayHdrMap.get("fin_entity"));
            lstrSundrybal.put("site_code", mPayHdrMap.get("site_code"));
            lstrSundrybal.put("sundry_type", "B");
            lstrSundrybal.put("sundry_code", mPayHdrMap.get("bank_code"));
            lstrSundrybal.put("acct_code", mPayHdrMap.get("acct_code__bal"));
            lstrSundrybal.put("cctr_code", mPayHdrMap.get("cctr_code__bal"));
            lstrSundrybal.put("curr_code", mPayHdrMap.get("curr_code"));
            lstrSundrybal.put("exch_rate", mPayHdrMap.get("exch_rate"));
            lstrSundrybal.put("dr_amt", 0.0);
            String string9 = mPayHdrMap.get("bank_charges") == null ? "0.00" : mPayHdrMap.get("bank_charges").toString();
            if (Double.valueOf(string9) > 0.0 && mPayHdrMap.get("curr_code").toString().equalsIgnoreCase(mPayHdrMap.get("curr_code__bc").toString())) {
                lstrSundrybal.put("cr_amt", totNetAmt + Double.valueOf(mPayHdrMap.get("bank_charges") == null ? "0.00" : mPayHdrMap.get("bank_charges").toString()));
            } else {
                lstrSundrybal.put("cr_amt", totNetAmt);
            }
            lstrSundrybal.put("adv_amt", 0.0);
            lstrSundrybal.put("contact_code", " ");
            errString = this.finCommon.gbf_sundrybal_upd(lstrSundrybal, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@1337 errString after gbf_sundrybal_upd called [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string10 = errString;
                return string10;
            }
            lstrBanktranlog.put("tran_date", mPayHdrMap.get("tran_date"));
            lstrBanktranlog.put("tran_ser", "M-PAY");
            lstrBanktranlog.put("tran_no", mPayHdrMap.get("tran_id"));
            lstrBanktranlog.put("bank_code", mPayHdrMap.get("bank_code"));
            lstrBanktranlog.put("ref_no", mPayHdrMap.get("ref_no"));
            lstrBanktranlog.put("ref_date", mPayHdrMap.get("ref_date"));
            lstrBanktranlog.put("ref_mode", mPayHdrMap.get("pay_mode"));
            String string11 = mPayHdrMap.get("bank_charges") == null ? "0.00" : mPayHdrMap.get("bank_charges").toString();
            if (Double.valueOf(string11) > 0.0) {
                if (mPayHdrMap.get("curr_code").toString().equalsIgnoreCase(mPayHdrMap.get("curr_code__bc").toString())) {
                    lstrBanktranlog.put("amount", totNetAmt + Double.valueOf(mPayHdrMap.get("bank_charges") == null ? "0.00" : mPayHdrMap.get("bank_charges").toString()));
                } else {
                    lstrBanktranlog.put("amount", totNetAmt);
                }
            } else {
                lstrBanktranlog.put("amount", totNetAmt);
            }
            lstrBanktranlog.put("tran_type", "P");
            lstrBanktranlog.put("site_code", mPayHdrMap.get("site_code"));
            lstrBanktranlog.put("acct_code", mPayHdrMap.get("acct_code__bal"));
            lstrBanktranlog.put("cctr_code", mPayHdrMap.get("cctr_code__bal"));
            lstrBanktranlog.put("sundry_type", mPayHdrMap.get("sundry_type"));
            lstrBanktranlog.put("sundry_code", mPayHdrMap.get("sundry_code"));
            lstrBanktranlog.put("remarks", mPayHdrMap.get("remarks"));
            lstrBanktranlog.put("due_date", mPayHdrMap.get("tran_date"));
            lstrBanktranlog.put("exch_rate", mPayHdrMap.get("exch_rate"));
            errString = this.finCommon.bankTranLogUpdate(lstrBanktranlog, xtraParams, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("1377@V@ errString after bankTranLogUpdate called [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string12 = errString;
                return string12;
            }
            if (lbBchg) {
                lstrGltrace.put("tran_date", mPayHdrMap.get("tran_date"));
                lstrGltrace.put("eff_date", mPayHdrMap.get("ref_date"));
                lstrGltrace.put("fin_entity", mPayHdrMap.get("fin_entity"));
                lstrGltrace.put("site_code", mPayHdrMap.get("site_code"));
                lstrGltrace.put("sundry_type", "B");
                lstrGltrace.put("sundry_code", mPayHdrMap.get("bank_code"));
                lstrGltrace.put("acct_code", mPayHdrMap.get("acct_code__bal"));
                lstrGltrace.put("cctr_code", mPayHdrMap.get("cctr_code__bal"));
                lstrGltrace.put("emp_code", "");
                lstrGltrace.put("anal_code", "");
                lstrGltrace.put("curr_code", mPayHdrMap.get("curr_code__bc"));
                lstrGltrace.put("exch_rate", mPayHdrMap.get("exch_rate__bc"));
                lstrGltrace.put("dr_amt", 0.0);
                lstrGltrace.put("cr_amt", mPayHdrMap.get("bank_charges"));
                lstrGltrace.put("ref_type", "F");
                lstrGltrace.put("ref_ser", "M-PAY");
                lstrGltrace.put("ref_id", mPayHdrMap.get("tran_id"));
                lstrGltrace.put("remarks", mPayHdrMap.get("remarks"));
                errString = this.finCommon.glTraceUpdate(lstrGltrace, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@1409 errString after glTraceUpdate called [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string13 = errString;
                    return string13;
                }
                lstrSundrybal.put("tran_date", mPayHdrMap.get("tran_date"));
                lstrSundrybal.put("eff_date", mPayHdrMap.get("ref_date"));
                lstrSundrybal.put("fin_entity", mPayHdrMap.get("fin_entity"));
                lstrSundrybal.put("site_code", mPayHdrMap.get("site_code"));
                lstrSundrybal.put("sundry_type", "B");
                lstrSundrybal.put("sundry_code", mPayHdrMap.get("bank_code"));
                lstrSundrybal.put("acct_code", mPayHdrMap.get("acct_code__bal"));
                lstrSundrybal.put("cctr_code", mPayHdrMap.get("cctr_code__bal"));
                lstrSundrybal.put("curr_code", mPayHdrMap.get("curr_code__bc"));
                lstrSundrybal.put("exch_rate", mPayHdrMap.get("exch_rate__bc"));
                lstrSundrybal.put("dr_amt", 0.0);
                lstrSundrybal.put("cr_amt", mPayHdrMap.get("bank_charges"));
                lstrSundrybal.put("adv_amt", 0.0);
                lstrSundrybal.put("contact_code", " ");
                errString = this.finCommon.gbf_sundrybal_upd(lstrSundrybal, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ 1432 errString after gbf_sundrybal_upd called [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string14 = errString;
                    return string14;
                }
                lstrBanktranlog.put("tran_date", mPayHdrMap.get("tran_date"));
                lstrBanktranlog.put("tran_ser", "M-PAY");
                lstrBanktranlog.put("tran_no", mPayHdrMap.get("tran_id"));
                lstrBanktranlog.put("bank_code", mPayHdrMap.get("bank_code"));
                lstrBanktranlog.put("ref_no", "");
                lstrBanktranlog.put("ref_date", mPayHdrMap.get("ref_date"));
                lstrBanktranlog.put("ref_mode", mPayHdrMap.get("pay_mode"));
                lstrBanktranlog.put("amount", mPayHdrMap.get("bank_charges"));
                lstrBanktranlog.put("tran_type", "P");
                lstrBanktranlog.put("site_code", mPayHdrMap.get("site_code"));
                lstrBanktranlog.put("acct_code", mPayHdrMap.get("acct_code__bal"));
                lstrBanktranlog.put("cctr_code", mPayHdrMap.get("cctr_code__bal"));
                lstrBanktranlog.put("sundry_type", mPayHdrMap.get("sundry_type"));
                lstrBanktranlog.put("sundry_code", mPayHdrMap.get("sundry_code"));
                lstrBanktranlog.put("remarks", mPayHdrMap.get("remarks"));
                lstrBanktranlog.put("due_date", mPayHdrMap.get("tran_date"));
                lstrBanktranlog.put("exch_rate", mPayHdrMap.get("exch_rate__bc"));
                errString = this.finCommon.bankTranLogUpdate(lstrBanktranlog, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@1458 errString after bankTranLogUpdate called [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string15 = errString;
                    return string15;
                }
            }
            try {
                sql = "select edi_option from transetup where tran_window = 'w_misc_pay'";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    lsEdiOption = rs.getInt("edi_option");
                }
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@V@ lsEdiOption :-[" + lsEdiOption + "]"));
                if (lsEdiOption > 0) {
                    mPayHdrMap.put("confirmed", "Y");
                    mPayHdrMap.put("conf_date", tranDate);
                    mPayHdrMap.put("emp_code__aprv", loginEmpCode);
                    if (lsEdiOption == 2) {
                        CreateRCPXML createRCPXML = new CreateRCPXML("w_misc_pay", "tran_id");
                        dataStr = createRCPXML.getTranXML(tranId, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr 1273=[ " + dataStr + "]"));
                        Document ediDataDom = this.genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_misc_pay", "0", xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (errString != null && "SUCCESS".equals(errString)) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from batchload = [" + errString + "]"));
                        }
                    } else {
                        CreateRCPXML createRCPXML = new CreateRCPXML("w_misc_pay", "tran_id");
                        dataStr = createRCPXML.getTranXML(tranId, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr 1273=[ " + dataStr + "]"));
                        Document ediDataDom = this.genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_misc_pay", "0", xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (errString != null && "SUCCESS".equals(errString)) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from batchload = [" + errString + "]"));
                        } else {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from batchload 1447[" + errString + "]"));
                        }
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception inside gbfPostMiscPayHdr==>" + e.getMessage()));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return errString;
    }

    /*
     * Exception decompiling
     */
    private String gbfPostMiscPaydet(String tranId, HashMap mPayHdrMap, ArrayList<HashMap> mPayDetList, Connection conn, String xtraParams) throws ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [57[DOLOOP]], but top level block is 31[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String gbfCheckBankLimit(String bankCode, String siteCode, Timestamp tranDate, Double acAmount, Connection conn) throws ITMException {
        boolean returnCnt = false;
        String sql = "";
        String errString = "";
        String acctPeriod = "";
        double drAmtBase = 0.0;
        double crAmtBase = 0.0;
        double balanceAmount = 0.0;
        double crLimit = 0.0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int cnt = 0;
        try {
            sql = "select acct_prd from period where ? between fr_date and to_date ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setTimestamp(1, tranDate);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                acctPeriod = this.checkNull(rs.getString("acct_prd"));
                ++cnt;
            }
            this.closeRsPstmt(rs, pstmt);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("acctPeriod[" + acctPeriod + "]"));
            if (cnt == 0) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VMPRD1", "", "", conn);
                return string;
            }
            sql = "select sum(case when dr_amt__base is null then 0 else dr_amt__base end ) as dr_amt__base , sum(case when cr_amt__base is null then 0 else cr_amt__base end) as cr_amt__base  from sundrybal where acct_prd = ? and prd_code = 'zzzzzz' and site_code = ?  and sundry_type = 'B' and sundry_code = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, acctPeriod);
            pstmt.setString(2, siteCode);
            pstmt.setString(3, bankCode);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                drAmtBase = rs.getDouble("dr_amt__base");
                crAmtBase = rs.getDouble("cr_amt__base");
            }
            this.closeRsPstmt(rs, pstmt);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("drAmtBase[" + drAmtBase + "]crAmtBase[" + crAmtBase + "]"));
            if (String.valueOf(drAmtBase) == null) {
                drAmtBase = 0.0;
            }
            if (String.valueOf(crAmtBase) == null) {
                crAmtBase = 0.0;
            }
            balanceAmount = drAmtBase - crAmtBase;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("balanceAmount[" + balanceAmount + "]"));
            cnt = 0;
            sql = "select cr_limit from bank where bank_code = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bankCode);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                crLimit = rs.getDouble("cr_limit");
                ++cnt;
            }
            this.closeRsPstmt(rs, pstmt);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("crLimit[" + crLimit + "]"));
            if (cnt == 0) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VMBANK0", "", "", conn);
                return string;
            }
            try {
                if (String.valueOf(crLimit) == null) {
                    crLimit = 0.0;
                }
                if (errString != null && errString.trim().length() > 0 && ((crLimit = 0.0 - crLimit) < 0.0 && crLimit > balanceAmount - acAmount || crLimit == 0.0 && balanceAmount - acAmount < 0.0)) {
                    errString = this.itmDBAccessEJB.getErrorString("", "VTBKLMIT", "", "", conn);
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception inside gbfCheckBankLimit==>" + e.getMessage()));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return errString;
    }

    private int gbfCheckSundrybankDet(String sundryType, String sundryCode, String bankCode, Connection conn) throws ITMException {
        int returnCnt = 0;
        String sql = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfCheckSundrybankDet called >>>>>");
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("sundryType[" + sundryType + "]sundryCode[" + sundryCode + "]bankCode[" + bankCode + "]"));
            if ("S".equalsIgnoreCase(sundryType)) {
                if (bankCode == null && bankCode.trim().length() == 0) {
                    sql = "select count(1) as ll_count from supplier_bank where supp_code =? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2321@ returnCnt[" + returnCnt + "]"));
                } else {
                    sql = "select count(1) as ll_count from supplier_bank where supp_code =? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2333@ returnCnt[" + returnCnt + "]"));
                }
            } else if ("C".equalsIgnoreCase(sundryType)) {
                if (bankCode == null && bankCode.trim().length() == 0) {
                    sql = "select count(1) as ll_count from customer_bank where cust_code =? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2346@ returnCnt[" + returnCnt + "]"));
                } else {
                    sql = "select count(1) as ll_count from customer_bank where cust_code =? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2358@ returnCnt[" + returnCnt + "]"));
                }
            } else if ("T".equalsIgnoreCase(sundryType)) {
                if (bankCode == null && bankCode.trim().length() == 0) {
                    sql = "select count(1) as ll_count from transporter_bank where tran_code = ? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2371@ returnCnt[" + returnCnt + "]"));
                } else {
                    sql = "select count(1) as ll_count from transporter_bank where tran_code = ? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2383@ returnCnt[" + returnCnt + "]"));
                }
            } else if ("L".equalsIgnoreCase(sundryType)) {
                if (bankCode == null && bankCode.trim().length() == 0) {
                    sql = "select count(1) as ll_count from loanparty_bank where party_code = ? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2396@ returnCnt[" + returnCnt + "]"));
                } else {
                    sql = "select count(1) as ll_count from loanparty_bank where party_code = ? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2408@ returnCnt[" + returnCnt + "]"));
                }
            } else if ("P".equalsIgnoreCase(sundryType)) {
                if (bankCode == null && bankCode.trim().length() == 0) {
                    sql = "select count(1) as ll_count from sales_pers_bank where sales_pers = ? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2421@ returnCnt[" + returnCnt + "]"));
                } else {
                    sql = "select count(1) as ll_count from sales_pers_bank where sales_pers = ? and ACTIVE_YN = 'Y' and CONFIRMED = 'Y'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        returnCnt = rs.getInt("ll_count");
                    }
                    this.closeRsPstmt(rs, pstmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("2433@ returnCnt[" + returnCnt + "]"));
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception inside gbfCheckSundrybankDet==>" + e.getMessage()));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return returnCnt;
    }

    private void closeRsPstmt(ResultSet rs, PreparedStatement pstmt) throws ITMException {
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ITMException((Exception)e);
        }
    }

    private String getLineNewNo(String lineNo) {
        lineNo = lineNo.trim();
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lineNo" + lineNo));
        String lenStr = "   " + lineNo;
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lenStr" + lenStr));
        String lineNoNew = lenStr.substring(lenStr.length() - 3, lenStr.length());
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lineNonew[" + lineNoNew + "]"));
        return lineNoNew;
    }

    private String checkNull(String input) {
        if (input == null) {
            input = "";
        }
        return input;
    }

    public String checkNullAndTrim(String inputVal) {
        inputVal = inputVal == null ? "" : inputVal.trim();
        return inputVal;
    }
}

