/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.ejb.Stateless;
import org.w3c.dom.Document;

@Stateless
public class MiscPayCancConf
extends ActionHandlerEJB {
    FinCommon finCommon = new FinCommon();
    UtilMethods utilMethod = new UtilMethods();
    ValidatorEJB validatorEJB = new ValidatorEJB();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
    DistCommon distCommon = new DistCommon();
    E12GenericUtility genericUtility = new E12GenericUtility();
    String userId = "";

    public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("In confirm tranID[" + tranId + "]"));
        String errString = "";
        Connection conn = null;
        try {
            errString = this.confirm(tranId, xtraParams, forcedFlag, conn);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in confirm() ==>" + e.getMessage()));
            errString = this.genericUtility.createErrorString(e);
            BaseLogger.log((String)"3", null, null, (Object)("errString in confirm() ==>" + errString));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"72@ MiscPayCancConfirm method Called..........");
        String sql = "";
        String confirmed = "";
        String siteCode = "";
        String errString = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean connStatus = false;
        Boolean isValTran = false;
        String loginEmpCode = "";
        try {
            if (conn == null) {
                conn = this.getConnection();
                connStatus = true;
            }
            sql = "select confirmed ,site_code  from misc_payment_canc where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                isValTran = true;
                confirmed = rs.getString("confirmed") == null ? "N" : rs.getString("confirmed");
                siteCode = this.checkNull(rs.getString("site_code"));
            }
            BaseLogger.log((String)"3", null, null, (Object)("confirmed--[" + confirmed + "]siteCode--[" + siteCode + "]"));
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (!isValTran.booleanValue()) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTMCONF20", "", "", conn);
                return string;
            }
            if (confirmed != null && "N".equalsIgnoreCase(confirmed)) {
                errString = this.gbfRetrieveMPayCanc(tranId, siteCode, xtraParams, conn);
                BaseLogger.log((String)"3", null, null, (Object)("Error aftr calling gbfRetrieveMPayCanc in confirm [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
            } else {
                BaseLogger.log((String)"3", null, null, (Object)"The Selected transaction is already confirmed");
                String string = errString = this.itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            try {
                BaseLogger.log((String)"3", null, null, (Object)("Error String from MiscPayCancConf confirm method.....[" + errString + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception ::[" + e.getMessage() + "]"));
                errString = this.genericUtility.createErrorString(e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Exception while rollbacking in catch MiscPayCancConf confirm method");
                }
                throw new ITMException(e);
            }
        }
        finally {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY MiscPayCancConf confirm connStatus[" + connStatus + "]errString[" + errString + "]"));
            try {
                if (errString != null && errString.trim().length() > 0) {
                    if (errString.indexOf("VTCICONF3") > -1) {
                        if (connStatus) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Transaction commited111.............from MiscPayCancConf");
                            conn.commit();
                        }
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollbacking.......");
                        conn.rollback();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollback...........");
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connStatus) {
                    conn.close();
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in MiscPayCanc confirm finally >>>>> " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    public String gbfRetrieveMPayCanc(String tranId, String siteCode, String xtraParams, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfRetrieveMPayCanc() method called>>>>>");
        String errString = "";
        String retString = "";
        String loginEmpCode = "";
        String keyFld = "";
        String tranIdMiscPay = "";
        String paymentNo = "";
        double netHdr = 0.0;
        String lsRefSer = "";
        String lsRefNo = "";
        String currCode = "";
        String acctCodeAp = "";
        String cctrCodeAp = "";
        String sundryType = "";
        String sundryCode = "";
        String instrNo = "";
        String drawnAt = "";
        String taxClass = "";
        String taxChap = "";
        String taxEnv = "";
        String lineNo = "";
        Timestamp vouchDate = null;
        Timestamp instrDate = null;
        double payAmt = 0.0;
        double NetAmt = 0.0;
        double exchRateVouch = 0.0;
        double diffAmtExch = 0.0;
        double taxAmt = 0.0;
        double discountAmt = 0.0;
        double lcTotdiscountAmt = 0.0;
        double lcTotpay = 0.0;
        double lcTotdiff = 0.0;
        double lcTotTax = 0.0;
        double lcTotpayBc = 0.0;
        double lcExchRate = 0.0;
        String sql = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Timestamp today = null;
        Timestamp tranDate = null;
        String sql1 = "";
        Object pstmt1 = null;
        Object rs1 = null;
        String sql2 = "";
        PreparedStatement pstmt2 = null;
        ResultSet rs2 = null;
        int count = 0;
        boolean cnt = false;
        ArrayList tranIdArray = new ArrayList();
        HashMap<String, Object> HdrMap = null;
        HashMap<String, Object> DetMap = null;
        ArrayList DetList = new ArrayList();
        ArrayList<String> tranIDList = new ArrayList<String>();
        ArrayList paymentNoList = new ArrayList();
        try {
            loginEmpCode = this.checkNull(this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
            today = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
            tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today)) + " 00:00:00.000");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("242@ tranId[" + tranId + "]tranDate[" + tranDate + "]"));
            if (loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "EMPAPRV", "", "", conn);
                return string;
            }
            sql1 = "SELECT tran_id FROM misc_payment_canc WHERE tran_id \t  >= ? AND  tran_id \t  <= ? AND  site_code\t= ? AND confirmed \t= 'N' ORDER BY tran_id ASC ";
            pstmt = conn.prepareStatement(sql1);
            pstmt.setString(1, tranId);
            pstmt.setString(2, tranId);
            pstmt.setString(3, siteCode);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                tranIdMiscPay = rs.getString("tran_id");
                tranIDList.add(tranIdMiscPay);
            }
            this.closeRsPstmt(rs, (PreparedStatement)pstmt);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("262@ tranIDList[" + tranIDList.toString() + "]"));
            int i = 0;
            while (i < tranIDList.size()) {
                tranIdMiscPay = (String)tranIDList.get(i);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("267@tranIDMiscPay [" + tranIdMiscPay + "]"));
                sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) || "mysql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "select tran_id from misc_payment_canc where tran_id = ? for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "select tran_id from misc_payment_canc (updlock) where tran_id = ?" : "select tran_id from misc_payment_canc where tran_id = ? for update nowait");
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranIdMiscPay);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    tranIdMiscPay = rs.getString("tran_id") == null ? " " : rs.getString("tran_id");
                }
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("289@ tranIdMiscPay[" + tranIdMiscPay + "]"));
                sql = " select tran_id, tran_date,tran_type,eff_date,payment_no,sundry_type,sundry_code,pay_mode,bank_code,ref_no,ref_date, net_amt,curr_code,net_amt__bc,site_code,fin_entity,acct_code__bal,cctr_code__bal,acct_code__cf,cctr_code__cf, diff_amt__exch,bank_charges,acct_code__bc,cctr_code__bc,curr_code__bc,remarks,confirmed,conf_date,emp_code__aprv,chg_date, chg_user,chg_term,exch_rate,exch_rate__bc,tax_class,tax_chap,tax_env,tax_amt,discount_amt,add_date,add_user,add_term from misc_payment_canc where tran_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranIdMiscPay);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    HdrMap = new HashMap<String, Object>();
                    HdrMap.put("tran_id", rs.getString("tran_id"));
                    HdrMap.put("tran_date", rs.getTimestamp("tran_date"));
                    HdrMap.put("tran_type", rs.getString("tran_type"));
                    HdrMap.put("eff_date", rs.getTimestamp("eff_date"));
                    HdrMap.put("payment_no", rs.getString("payment_no"));
                    HdrMap.put("sundry_type", rs.getString("sundry_type"));
                    HdrMap.put("sundry_code", rs.getString("sundry_code"));
                    HdrMap.put("pay_mode", rs.getString("pay_mode"));
                    HdrMap.put("bank_code", rs.getString("bank_code"));
                    HdrMap.put("ref_no", rs.getString("ref_no"));
                    HdrMap.put("ref_date", rs.getTimestamp("ref_date"));
                    HdrMap.put("net_amt", rs.getDouble("net_amt"));
                    HdrMap.put("curr_code", rs.getString("curr_code"));
                    HdrMap.put("net_amt__bc", rs.getDouble("net_amt__bc"));
                    HdrMap.put("site_code", rs.getString("site_code"));
                    HdrMap.put("fin_entity", rs.getString("fin_entity"));
                    HdrMap.put("acct_code__bal", rs.getString("acct_code__bal"));
                    HdrMap.put("cctr_code__bal", rs.getString("cctr_code__bal"));
                    HdrMap.put("acct_code__cf", rs.getString("acct_code__cf"));
                    HdrMap.put("cctr_code__cf", rs.getString("cctr_code__cf"));
                    HdrMap.put("diff_amt__exch", rs.getDouble("diff_amt__exch"));
                    HdrMap.put("bank_charges", rs.getDouble("bank_charges"));
                    HdrMap.put("acct_code__bc", rs.getString("acct_code__bc"));
                    HdrMap.put("cctr_code__bc", rs.getString("cctr_code__bc"));
                    HdrMap.put("curr_code__bc", rs.getString("curr_code__bc"));
                    HdrMap.put("remarks", rs.getString("remarks"));
                    HdrMap.put("confirmed", rs.getString("confirmed"));
                    HdrMap.put("conf_date", rs.getTimestamp("conf_date"));
                    HdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
                    HdrMap.put("chg_date", rs.getTimestamp("chg_date"));
                    HdrMap.put("chg_user", rs.getString("chg_user"));
                    HdrMap.put("chg_term", rs.getString("chg_term"));
                    HdrMap.put("exch_rate", rs.getDouble("exch_rate"));
                    HdrMap.put("exch_rate__bc", rs.getDouble("exch_rate__bc"));
                    HdrMap.put("tax_class", rs.getString("tax_class"));
                    HdrMap.put("tax_chap", rs.getString("tax_chap"));
                    HdrMap.put("tax_env", rs.getString("tax_env"));
                    HdrMap.put("tax_amt", rs.getDouble("tax_amt"));
                    HdrMap.put("discount_amt", rs.getDouble("discount_amt"));
                    HdrMap.put("add_date", rs.getTimestamp("add_date"));
                    HdrMap.put("add_user", rs.getString("add_user"));
                    HdrMap.put("add_term", rs.getString("add_term"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("345@ Header Map..........[" + HdrMap.toString() + "]"));
                }
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                tranId = (String)HdrMap.get("tran_id");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("350@ tranId[" + tranId + "]"));
                sql = "select tran_id,tran_ser,vouch_no,vouch_date,net_amt,pay_amt,curr_code,acct_code__ap,cctr_code__ap,sundry_type,sundry_code,instr_no, instr_date,diff_amt__exch,exch_rate__vouch,drawn_at,tax_class,tax_chap,tax_env,tax_amt,net_pay_amt,line_no,discount_amt from misc_payment_cancdet where tran_id =?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    DetMap = new HashMap<String, Object>();
                    DetMap.put("tran_id", rs.getString("tran_id"));
                    DetMap.put("tran_ser", rs.getString("tran_ser"));
                    DetMap.put("vouch_no", rs.getString("vouch_no"));
                    DetMap.put("vouch_date", rs.getTimestamp("vouch_date"));
                    DetMap.put("net_amt", rs.getDouble("net_amt"));
                    DetMap.put("pay_amt", rs.getDouble("pay_amt"));
                    DetMap.put("curr_code", rs.getString("curr_code"));
                    DetMap.put("acct_code__ap", rs.getString("acct_code__ap"));
                    DetMap.put("cctr_code__ap", rs.getString("cctr_code__ap"));
                    DetMap.put("sundry_type", rs.getString("sundry_type"));
                    DetMap.put("sundry_code", rs.getString("sundry_code"));
                    DetMap.put("instr_no", rs.getString("instr_no"));
                    DetMap.put("instr_date", rs.getTimestamp("instr_date"));
                    DetMap.put("diff_amt__exch", rs.getDouble("diff_amt__exch"));
                    DetMap.put("exch_rate__vouch", rs.getDouble("exch_rate__vouch"));
                    DetMap.put("drawn_at", rs.getString("drawn_at"));
                    DetMap.put("tax_chap", rs.getString("tax_chap"));
                    DetMap.put("tax_class", rs.getString("tax_class"));
                    DetMap.put("tax_env", rs.getString("tax_env"));
                    DetMap.put("tax_env", this.checkNull(rs.getString("tax_env")));
                    DetMap.put("net_pay_amt", rs.getDouble("net_pay_amt"));
                    DetMap.put("tax_amt", rs.getDouble("tax_amt"));
                    DetMap.put("line_no", rs.getString("line_no"));
                    DetMap.put("discount_amt", rs.getDouble("discount_amt"));
                    DetList.add(DetMap);
                }
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("389@ DetList[" + DetList.toString() + "]"));
                if (DetList.size() == 0) {
                    sql = " select payment_no from misc_payment_canc where tran_id =?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    BaseLogger.log((String)"3", null, null, (Object)("tranId--[" + tranId + "]"));
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        paymentNo = rs.getString("payment_no");
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("402@ paymentNo[" + paymentNo + "]"));
                    this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                    sql2 = " SELECT tran_ser,vouch_no,vouch_date,net_amt, pay_amt,curr_code,diff_amt__exch,acct_code__ap,cctr_code__ap, sundry_type,sundry_code,instr_no,instr_date,exch_rate__vouch,drawn_at, tax_chap,tax_class,tax_env,tax_amt,line_no,discount_amt  FROM misc_paydet where tran_id = ?";
                    pstmt2 = conn.prepareStatement(sql2);
                    pstmt2.setString(1, paymentNo);
                    rs2 = pstmt2.executeQuery();
                    while (rs2.next()) {
                        lsRefSer = rs2.getString("tran_ser");
                        lsRefNo = rs2.getString("vouch_no");
                        vouchDate = rs2.getTimestamp("vouch_date");
                        payAmt = rs2.getDouble("pay_amt");
                        NetAmt = rs2.getDouble("net_amt");
                        currCode = rs2.getString("curr_code");
                        exchRateVouch = rs2.getDouble("exch_rate__vouch");
                        diffAmtExch = rs2.getDouble("diff_amt__exch");
                        acctCodeAp = rs2.getString("acct_code__ap");
                        cctrCodeAp = rs2.getString("cctr_code__ap");
                        sundryType = rs2.getString("sundry_type");
                        sundryCode = rs2.getString("sundry_code");
                        instrNo = rs2.getString("instr_no");
                        instrDate = rs2.getTimestamp("instr_date");
                        drawnAt = rs2.getString("drawn_at");
                        taxClass = rs2.getString("tax_class");
                        taxChap = rs2.getString("tax_chap");
                        taxEnv = rs2.getString("tax_env");
                        taxAmt = rs2.getDouble("tax_amt");
                        lineNo = rs2.getString("line_no");
                        discountAmt = rs2.getDouble("discount_amt");
                        sql = " insert into misc_payment_cancdet (tran_id,tran_ser,vouch_no,vouch_date,pay_amt,net_amt,curr_code,exch_rate__vouch,  diff_amt__exch,acct_code__ap,cctr_code__ap,sundry_type,sundry_code,instr_no,instr_date,drawn_at, tax_class,tax_chap,tax_env,tax_amt,line_no,discount_amt )values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                        BaseLogger.log((String)"3", null, null, (Object)("510@ sql [" + sql + "]"));
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, tranId);
                        pstmt.setString(2, lsRefSer);
                        pstmt.setString(3, lsRefNo);
                        pstmt.setTimestamp(4, vouchDate);
                        pstmt.setDouble(5, payAmt);
                        pstmt.setDouble(6, NetAmt);
                        pstmt.setString(7, currCode);
                        pstmt.setDouble(8, exchRateVouch);
                        pstmt.setDouble(9, diffAmtExch);
                        pstmt.setString(10, acctCodeAp);
                        pstmt.setString(11, cctrCodeAp);
                        pstmt.setString(12, sundryType);
                        pstmt.setString(13, sundryCode);
                        pstmt.setString(14, instrNo);
                        pstmt.setTimestamp(15, instrDate);
                        pstmt.setString(16, drawnAt);
                        pstmt.setString(17, taxClass);
                        pstmt.setString(18, taxChap);
                        pstmt.setString(19, taxEnv);
                        pstmt.setDouble(20, taxAmt);
                        pstmt.setString(21, lineNo);
                        pstmt.setDouble(22, discountAmt);
                        pstmt.executeUpdate();
                        pstmt.close();
                        pstmt = null;
                        sql = "select count(*) from misc_payment_canc, misc_payment_cancdet  where misc_payment_canc.tran_id = misc_payment_cancdet.tran_id and payment_no =? and vouch_no =? and misc_payment_canc.tran_id <> ?";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, paymentNo);
                        pstmt.setString(2, lsRefNo);
                        pstmt.setString(3, tranId);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            count = rs.getInt(1);
                        }
                        BaseLogger.log((String)"3", null, null, (Object)("493@ count[ " + count + "]"));
                        this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                        if (count > 0) {
                            String string = retString = this.itmDBAccessEJB.getErrorString("", "VTPAYM8", "", "", conn);
                            return string;
                        }
                        DetMap = new HashMap();
                        DetMap.put("tran_id", tranId);
                        DetMap.put("tran_ser", lsRefSer);
                        DetMap.put("vouch_no", lsRefNo);
                        DetMap.put("vouch_date", vouchDate);
                        DetMap.put("pay_amt", payAmt);
                        DetMap.put("net_amt", NetAmt);
                        DetMap.put("curr_code", currCode);
                        DetMap.put("exch_rate__vouch", exchRateVouch);
                        DetMap.put("diff_amt__exch", diffAmtExch);
                        DetMap.put("acct_code__ap", acctCodeAp);
                        DetMap.put("cctr_code__ap", cctrCodeAp);
                        DetMap.put("sundry_type", sundryType);
                        DetMap.put("sundry_code", sundryCode);
                        DetMap.put("instr_no", instrNo);
                        DetMap.put("instr_date", instrDate);
                        DetMap.put("drawn_at", drawnAt);
                        DetMap.put("tax_class", taxClass);
                        DetMap.put("tax_chap", taxChap);
                        DetMap.put("tax_env", taxEnv);
                        DetMap.put("tax_amt", taxAmt);
                        DetMap.put("line_no", lineNo);
                        DetMap.put("discount_amt", discountAmt);
                        DetList.add(DetMap);
                        BaseLogger.log((String)"3", null, null, (Object)("525@ discountAmt [" + discountAmt + "]payAmt [" + payAmt + "]diffAmtExch[" + diffAmtExch + "]taxAmt[" + taxAmt + "]DetList[" + DetList + "]"));
                        BaseLogger.log((String)"3", null, null, (Object)("530@ lcTotdiscountAmt [" + (lcTotdiscountAmt += discountAmt) + "]lcTotpay [" + (lcTotpay += payAmt) + "]lcTotdiff[" + (lcTotdiff += diffAmtExch) + "]lcTotTax[" + (lcTotTax += taxAmt) + "]"));
                        if (errString == null || errString.trim().length() <= 0) continue;
                        conn.rollback();
                        String string = errString;
                        return string;
                    }
                    this.closeRsPstmt(rs2, pstmt2);
                    lcExchRate = Double.valueOf(HdrMap.get("exch_rate") == null ? "0.00" : HdrMap.get("exch_rate").toString());
                    lcTotpayBc = lcTotpay * lcExchRate;
                    BaseLogger.log((String)"3", null, null, (Object)("541@ lcExchRate [" + lcExchRate + "]lcTotpay [" + lcTotpay + "]lcTotpayBc[" + lcTotpayBc + "]discountAmt[" + discountAmt + "]" + "payAmt[" + payAmt + "]diffAmtExch[" + diffAmtExch + "]taxAmt[" + taxAmt + "]tranId[" + tranId + "]lcTotdiff[" + lcTotdiff + "]lcTotTax[" + lcTotTax + "]"));
                    if (Double.parseDouble(HdrMap.get("net_amt").toString()) == 0.0) {
                        sql = "update misc_payment_canc set net_amt = ?, net_amt__bc =?,diff_amt__exch =?,tax_amt =? where tran_id =?";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setDouble(1, lcTotpay);
                        pstmt.setDouble(2, lcTotpayBc);
                        pstmt.setDouble(3, lcTotdiff);
                        pstmt.setDouble(4, lcTotTax);
                        pstmt.setString(5, tranId);
                        int updCnt = pstmt.executeUpdate();
                        BaseLogger.log((String)"3", null, null, (Object)("no of row update = " + updCnt));
                        this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                        HdrMap.put("discount_amt", lcTotdiscountAmt);
                        HdrMap.put("net_amt", lcTotpay);
                        HdrMap.put("net_amt__bc", lcTotpayBc);
                    }
                }
                ++i;
            }
            retString = this.gbfPostMpayCanc(tranId, HdrMap, DetList, xtraParams, conn);
            BaseLogger.log((String)"3", null, null, (Object)("526@ retString after calling gbfRetrieveMiscPayCanc [" + retString + "]"));
            if (retString != null && retString.trim().length() > 0) {
                String string = retString;
                return string;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in catch gbfRetrieveMiscPayCanc==>[" + e.getMessage() + "]"));
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return errString;
    }

    public String gbfPostMpayCanc(String tranId, HashMap hdrMap, ArrayList DetList, String xtraParams, Connection conn) throws RemoteException, ITMException, SQLException {
        String retString = "";
        String postOnline = "";
        String confirmed = "";
        String sql = "";
        String loginEmpCode = "";
        String transer = "MPCANC";
        String termId = "";
        Date toDay = new Date();
        Timestamp tranDate = null;
        SimpleDateFormat sdf = null;
        String chgUser = "";
        String chgTerm = "";
        String userid = "";
        String loginSiteCode = "";
        String currDateStr = "";
        Object today = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Object detailMap = null;
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"MiscPayCancConf gbfPostMpayCanc called >>>>>");
            sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
            chgUser = this.checkNullAndTrim(this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
            chgTerm = this.checkNullAndTrim(this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            loginSiteCode = this.checkNullAndTrim(this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
            tranDate = new Timestamp(System.currentTimeMillis());
            currDateStr = sdf.format(tranDate);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("591@ tranId[" + tranId + "]chgUser[" + chgUser + "]chgTerm[" + chgTerm + "]loginEmpCode[" + loginEmpCode + "]" + "loginSiteCode[" + loginSiteCode + "]currDateStr[" + currDateStr + "]"));
            if (chgTerm == null || chgTerm.trim().length() == 0) {
                chgTerm = "SYSTEM";
            }
            retString = this.gbfPostMpayCanchdr(tranId, hdrMap, DetList, xtraParams, conn);
            BaseLogger.log((String)"3", null, null, (Object)("612@ retString from gbfPostMpayCanchdr [" + retString + "]"));
            if (retString != null && retString.trim().length() > 0) {
                String string = retString;
                return string;
            }
            retString = this.gbfPostMpayCancDet(tranId, hdrMap, DetList, xtraParams, conn);
            BaseLogger.log((String)"3", null, null, (Object)("619@ retString from gbfPostMpayCancDet [" + retString + "]"));
            if (retString != null && retString.trim().length() > 0) {
                String string = retString;
                return string;
            }
            postOnline = this.checkNullAndTrim(this.finCommon.getFinparams("999999", "POST_ON_LINE", conn));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("628@ PostOnline[" + postOnline + "]"));
            if ("Y".equals(postOnline)) {
                retString = this.finCommon.checkGlTranDrCr("MPCANC", tranId, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("632@ errString after calling checkGlTranDrCr ::[ " + retString + "]"));
                if (retString != null && retString.trim().length() > 0) {
                    String string = retString;
                    return string;
                }
            }
            try {
                confirmed = (String)hdrMap.get("confirmed");
                BaseLogger.log((String)"3", null, null, (Object)("640@ confirmed[" + confirmed + "]"));
                if (!"Y".equalsIgnoreCase(confirmed)) {
                    sql = "update misc_payment_canc set confirmed = 'Y',conf_date = ?,emp_code__aprv = ? where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setTimestamp(1, tranDate);
                    pstmt.setString(2, loginEmpCode);
                    pstmt.setString(3, tranId);
                    int updcnt = pstmt.executeUpdate();
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("@648 no of row update = [ " + updcnt + "]"));
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (updcnt > 0) {
                        retString = this.itmDBAccessEJB.getErrorString("", "VTCICONF3", "", "", conn);
                    }
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Error String from gbfPostMpayCanc method.....[" + retString + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :MiscPayCancConf :gbfPostMpayCanc:==>[" + e.getMessage() + "]"));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : [" + e.getMessage() + "]"));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return retString;
    }

    public String gbfPostMpayCanchdr(String tranId, HashMap HdrMap, ArrayList DetList, String xtraParams, Connection conn) throws RemoteException, ITMException {
        String errString = "";
        String loginEmpCode = "";
        String finEntity = "";
        String siteCode = "";
        String tranSer = "";
        String suppCode = "";
        String acctCode = "";
        String cctrCode = "";
        String analCode = "";
        String currCode = "";
        String remarks = "";
        String drcrFlag = "";
        String sql = "";
        String lsdrcrFlag = "";
        String lsrefNo = "";
        String lstranSer = "";
        String lsdocFlag = "";
        String lsvouchNo = "";
        String vtranId = "";
        String keystr = "";
        String xmlString = "";
        String mpadjTranid = "";
        String lstranId = "";
        String confirmed = "";
        String bankCode = "";
        String currCodeBc = "";
        String paymentNo = "";
        String lsAcctCodeDisc = "";
        String lsCctrCodeDisc = "";
        String dataStr = "";
        Timestamp tranDate = null;
        Timestamp effDate = null;
        double exchRate = 0.0;
        double amount = 0.0;
        int lsEdiOption = 0;
        double bankCharges = 0.0;
        double netAmt = 0.0;
        double lcDiscamt = 0.0;
        double lcNetAmt = 0.0;
        HashMap<String, Object> glTraceMap = null;
        HashMap sundryBalMap = null;
        HashMap lstrBanktranlog = null;
        Statement pstmt = null;
        Statement pstmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        Timestamp today = null;
        try {
            today = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
            tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today)) + " 00:00:00.000");
            loginEmpCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("720@ tranId[" + tranId + "]loginEmpCode[" + loginEmpCode + "]tranDate[" + tranDate + "]"));
            tranDate = (Timestamp)HdrMap.get("tran_date");
            effDate = (Timestamp)HdrMap.get("eff_date");
            finEntity = (String)HdrMap.get("fin_entity");
            siteCode = (String)HdrMap.get("site_code");
            suppCode = (String)HdrMap.get("supp_code");
            bankCode = (String)HdrMap.get("bank_code");
            acctCode = (String)HdrMap.get("acct_code__bal");
            cctrCode = (String)HdrMap.get("cctr_code__bal");
            analCode = (String)HdrMap.get("anal_code");
            currCode = (String)HdrMap.get("curr_code");
            currCodeBc = (String)HdrMap.get("curr_code__bc");
            exchRate = Double.parseDouble("" + HdrMap.get("exch_rate"));
            amount = Double.valueOf(HdrMap.get("amount") == null ? "0.00" : HdrMap.get("amount").toString());
            tranSer = (String)HdrMap.get("tran_ser");
            tranId = (String)HdrMap.get("tran_id");
            remarks = (String)HdrMap.get("remarks");
            glTraceMap = new HashMap<String, Object>();
            glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
            glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
            glTraceMap.put("fin_entity", finEntity);
            glTraceMap.put("site_code", siteCode);
            glTraceMap.put("sundry_type", "B");
            glTraceMap.put("sundry_code", bankCode);
            glTraceMap.put("acct_code", acctCode);
            glTraceMap.put("cctr_code", cctrCode);
            glTraceMap.put("emp_code", "");
            glTraceMap.put("anal_code", "");
            glTraceMap.put("curr_code", currCode);
            glTraceMap.put("exch_rate", exchRate);
            netAmt = Double.valueOf(HdrMap.get("net_amt") == null ? "0.00" : HdrMap.get("net_amt").toString());
            bankCharges = Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString());
            drcrFlag = (String)HdrMap.get("drcr_flag");
            BaseLogger.log((String)"3", null, null, (Object)("755@ gltrace drcrFlag [" + drcrFlag + "]amount[" + amount + "]"));
            if (currCodeBc.trim().equalsIgnoreCase(currCode.trim()) && bankCharges != 0.0) {
                glTraceMap.put("dr_amt", netAmt - bankCharges);
            } else {
                glTraceMap.put("dr_amt", netAmt);
            }
            glTraceMap.put("cr_amt", 0.0);
            glTraceMap.put("ref_type", "F");
            glTraceMap.put("ref_ser", "MPCANC");
            glTraceMap.put("ref_id", tranId);
            glTraceMap.put("remarks", remarks);
            BaseLogger.log((String)"3", null, null, (Object)("glTraceUpdate Called glTraceMap[" + glTraceMap.toString() + "]"));
            errString = this.finCommon.glTraceUpdate(glTraceMap, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("771@ errString after glTraceUpdate called [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            lcDiscamt = Double.valueOf(HdrMap.get("discount_amt") == null ? "0.00" : HdrMap.get("discount_amt").toString());
            if (lcDiscamt > 0.0) {
                paymentNo = (String)HdrMap.get("payment_no");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("781@ lcDiscamt[" + lcDiscamt + "]paymentNo[" + paymentNo + "]"));
                sql = "select acct_code__disc,cctr_code__disc from misc_paydet where tran_id =? and discount_amt > 0 ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, paymentNo);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    lsAcctCodeDisc = rs.getString("acct_code__disc");
                    lsCctrCodeDisc = rs.getString("cctr_code__disc");
                }
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                glTraceMap.put("acct_code", lsAcctCodeDisc);
                glTraceMap.put("cctr_code", lsCctrCodeDisc);
                glTraceMap.put("sundry_code", "");
                glTraceMap.put("dr_amt", lcDiscamt);
                glTraceMap.put("cr_amt", 0.0);
                glTraceMap.put("sundry_type", "O");
                errString = this.finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("799@ errString after glTraceUpdate called [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
            }
            sundryBalMap = new HashMap();
            sundryBalMap.put("tran_date", HdrMap.get("tran_date"));
            sundryBalMap.put("eff_date", HdrMap.get("eff_date"));
            sundryBalMap.put("fin_entity", HdrMap.get("fin_entity"));
            sundryBalMap.put("site_code", HdrMap.get("site_code"));
            sundryBalMap.put("sundry_type", "B");
            sundryBalMap.put("sundry_code", HdrMap.get("bank_code"));
            sundryBalMap.put("acct_code", acctCode);
            sundryBalMap.put("cctr_code", cctrCode);
            sundryBalMap.put("curr_code", HdrMap.get("curr_code"));
            sundryBalMap.put("exch_rate", HdrMap.get("exch_rate"));
            if (currCodeBc.trim().equalsIgnoreCase(currCode.trim()) && bankCharges != 0.0) {
                sundryBalMap.put("dr_amt", netAmt - bankCharges);
            } else {
                sundryBalMap.put("dr_amt", HdrMap.get("net_amt"));
            }
            sundryBalMap.put("cr_amt", 0.0);
            sundryBalMap.put("adv_amt", 0.0);
            sundryBalMap.put("contact_code", " ");
            errString = this.finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("832@ errString after gbf_sundrybal_upd:- [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                BaseLogger.log((String)"3", null, null, (Object)("error is sundryBaleUpdate ..........." + errString));
                String string = errString;
                return string;
            }
            lstrBanktranlog = new HashMap();
            lstrBanktranlog.put("tran_date", HdrMap.get("tran_date"));
            lstrBanktranlog.put("tran_ser", "MPCANC");
            lstrBanktranlog.put("tran_no", HdrMap.get("tran_id"));
            lstrBanktranlog.put("bank_code", HdrMap.get("bank_code"));
            lstrBanktranlog.put("ref_no", HdrMap.get("ref_no"));
            lstrBanktranlog.put("ref_date", HdrMap.get("ref_date"));
            lstrBanktranlog.put("ref_mode", HdrMap.get("pay_mode"));
            lcNetAmt = Double.valueOf(HdrMap.get("net_amt") == null ? "0.00" : HdrMap.get("net_amt").toString());
            if (HdrMap.get("curr_code__bc").toString().equalsIgnoreCase(HdrMap.get("curr_code").toString()) && Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString()) != 0.0) {
                lstrBanktranlog.put("amount", lcNetAmt - Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString()));
            } else {
                lstrBanktranlog.put("amount", lcNetAmt);
            }
            lstrBanktranlog.put("tran_type", "R");
            lstrBanktranlog.put("site_code", HdrMap.get("site_code"));
            lstrBanktranlog.put("acct_code", acctCode);
            lstrBanktranlog.put("cctr_code", cctrCode);
            lstrBanktranlog.put("sundry_type", HdrMap.get("sundry_type"));
            lstrBanktranlog.put("sundry_code", HdrMap.get("sundry_code"));
            lstrBanktranlog.put("remarks", HdrMap.get("remarks"));
            lstrBanktranlog.put("due_date", HdrMap.get("tran_date"));
            lstrBanktranlog.put("exch_rate", HdrMap.get("exch_rate"));
            errString = this.finCommon.bankTranLogUpdate(lstrBanktranlog, xtraParams, conn);
            BaseLogger.log((String)"3", null, null, (Object)("869@ errString bankTranLogUpdate [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            if (Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString()) != 0.0) {
                glTraceMap = new HashMap();
                glTraceMap.put("tran_date", HdrMap.get("tran_date"));
                glTraceMap.put("eff_date", HdrMap.get("eff_date"));
                glTraceMap.put("fin_entity", HdrMap.get("fin_entity"));
                glTraceMap.put("site_code", HdrMap.get("site_code"));
                glTraceMap.put("sundry_type", "O");
                glTraceMap.put("sundry_code", " ");
                glTraceMap.put("acct_code", HdrMap.get("acct_code__bc"));
                glTraceMap.put("cctr_code", HdrMap.get("cctr_code__bc"));
                glTraceMap.put("emp_code", "");
                glTraceMap.put("anal_code", "");
                glTraceMap.put("curr_code", HdrMap.get("curr_code__bc"));
                glTraceMap.put("exch_rate", HdrMap.get("exch_rate__bc"));
                bankCharges = Double.parseDouble(" " + HdrMap.get("bank_charges"));
                String string = HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString();
                if (Double.valueOf(string) > 0.0) {
                    glTraceMap.put("dr_amt", Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString()));
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", 0.0 - Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString()));
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "MPCANC");
                glTraceMap.put("ref_id", HdrMap.get("tran_id"));
                glTraceMap.put("remarks", HdrMap.get("remarks"));
                errString = this.finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", null, null, (Object)("907@ errString after calling glTraceUpdate:- [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string2 = errString;
                    return string2;
                }
                if (!currCodeBc.trim().equalsIgnoreCase(HdrMap.get("curr_code").toString())) {
                    lstrBanktranlog = new HashMap();
                    lstrBanktranlog.put("tran_date", HdrMap.get("tran_date"));
                    lstrBanktranlog.put("tran_ser", "MPCANC");
                    lstrBanktranlog.put("tran_no", HdrMap.get("tran_id"));
                    lstrBanktranlog.put("bank_code", HdrMap.get("bank_code"));
                    lstrBanktranlog.put("ref_no", "");
                    lstrBanktranlog.put("ref_date", HdrMap.get("ref_date"));
                    lstrBanktranlog.put("ref_mode", HdrMap.get("pay_mode"));
                    String string3 = HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString();
                    if (Double.valueOf(string3) > 0.0) {
                        lstrBanktranlog.put("amount", Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString()));
                        lstrBanktranlog.put("tran_type", "P");
                    } else {
                        lstrBanktranlog.put("amount", 0.0 - Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString()));
                        lstrBanktranlog.put("tran_type", "R");
                    }
                    lstrBanktranlog.put("site_code", HdrMap.get("site_code"));
                    lstrBanktranlog.put("acct_code", acctCode);
                    lstrBanktranlog.put("cctr_code", cctrCode);
                    lstrBanktranlog.put("sundry_type", HdrMap.get("sundry_type"));
                    lstrBanktranlog.put("sundry_code", HdrMap.get("sundry_code"));
                    lstrBanktranlog.put("remarks", HdrMap.get("remarks"));
                    lstrBanktranlog.put("due_date", HdrMap.get("tran_date"));
                    lstrBanktranlog.put("exch_rate", HdrMap.get("exch_rate__bc"));
                    errString = this.finCommon.bankTranLogUpdate(lstrBanktranlog, xtraParams, conn);
                    BaseLogger.log((String)"3", null, null, (Object)("944@ errString bankTranLogUpdate:- [" + errString + "]"));
                    if (errString != null && errString.trim().length() > 0) {
                        String string4 = errString;
                        return string4;
                    }
                    glTraceMap = new HashMap();
                    glTraceMap.put("tran_date", HdrMap.get("tran_date"));
                    glTraceMap.put("eff_date", HdrMap.get("eff_date"));
                    glTraceMap.put("fin_entity", HdrMap.get("fin_entity"));
                    glTraceMap.put("site_code", HdrMap.get("site_code"));
                    glTraceMap.put("sundry_type", "B");
                    glTraceMap.put("sundry_code", HdrMap.get("bank_code"));
                    glTraceMap.put("acct_code", acctCode);
                    glTraceMap.put("cctr_code", cctrCode);
                    glTraceMap.put("emp_code", "");
                    glTraceMap.put("anal_code", "");
                    glTraceMap.put("curr_code", HdrMap.get("curr_code__bc"));
                    glTraceMap.put("exch_rate", HdrMap.get("exch_rate__bc"));
                    String string5 = HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString();
                    if (Double.valueOf(string5) > 0.0) {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", HdrMap.get("bank_charges"));
                    } else {
                        glTraceMap.put("dr_amt", 0.0 - Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString()));
                        glTraceMap.put("cr_amt", 0.0);
                    }
                    glTraceMap.put("ref_type", "F");
                    glTraceMap.put("ref_ser", "MPCANC");
                    glTraceMap.put("ref_id", HdrMap.get("tran_id"));
                    glTraceMap.put("remarks", HdrMap.get("remarks"));
                    errString = this.finCommon.glTraceUpdate(glTraceMap, conn);
                    BaseLogger.log((String)"3", null, null, (Object)("979@ errString glTraceUpdate:- [" + errString + "]"));
                    if (errString != null && errString.trim().length() > 0) {
                        String string6 = errString;
                        return string6;
                    }
                    sundryBalMap = new HashMap();
                    sundryBalMap.put("tran_date", HdrMap.get("tran_date"));
                    sundryBalMap.put("eff_date", HdrMap.get("eff_date"));
                    sundryBalMap.put("fin_entity", HdrMap.get("fin_entity"));
                    sundryBalMap.put("site_code", HdrMap.get("site_code"));
                    sundryBalMap.put("sundry_type", "B");
                    sundryBalMap.put("sundry_code", HdrMap.get("bank_code"));
                    sundryBalMap.put("acct_code", acctCode);
                    sundryBalMap.put("cctr_code", cctrCode);
                    sundryBalMap.put("curr_code", HdrMap.get("curr_code__bc"));
                    sundryBalMap.put("exch_rate", HdrMap.get("exch_rate__bc"));
                    String string7 = HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString();
                    if (Double.valueOf(string7) > 0.0) {
                        sundryBalMap.put("dr_amt", 0.0);
                        sundryBalMap.put("cr_amt", HdrMap.get("bank_charges"));
                    } else {
                        sundryBalMap.put("dr_amt", 0.0 - Double.valueOf(HdrMap.get("bank_charges") == null ? "0.00" : HdrMap.get("bank_charges").toString()));
                        sundryBalMap.put("cr_amt", 0.0);
                    }
                    sundryBalMap.put("adv_amt", 0.0);
                    sundryBalMap.put("contact_code", " ");
                    errString = this.finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                    BaseLogger.log((String)"3", null, null, (Object)("1009@ errString gbf_sundrybal_upd:- [" + errString + "]"));
                    if (errString != null && errString.trim().length() > 0) {
                        String string8 = errString;
                        return string8;
                    }
                }
            }
            if (Double.valueOf(HdrMap.get("diff_amt__exch") == null ? "0.00" : HdrMap.get("diff_amt__exch").toString()) != 0.0) {
                glTraceMap = new HashMap();
                glTraceMap.put("tran_date", HdrMap.get("tran_date"));
                glTraceMap.put("eff_date", HdrMap.get("eff_date"));
                glTraceMap.put("fin_entity", HdrMap.get("fin_entity"));
                glTraceMap.put("site_code", HdrMap.get("site_code"));
                glTraceMap.put("sundry_type", "O");
                glTraceMap.put("sundry_code", " ");
                glTraceMap.put("acct_code", HdrMap.get("acct_code__cf"));
                glTraceMap.put("cctr_code", HdrMap.get("cctr_code__cf"));
                glTraceMap.put("emp_code", "");
                glTraceMap.put("anal_code", "");
                glTraceMap.put("curr_code", HdrMap.get("curr_code"));
                glTraceMap.put("exch_rate", 1);
                String string = HdrMap.get("diff_amt__exch") == null ? "0.00" : HdrMap.get("diff_amt__exch").toString();
                if (Double.valueOf(string) > 0.0) {
                    glTraceMap.put("dr_amt", Double.valueOf(HdrMap.get("diff_amt__exch") == null ? "0.00" : HdrMap.get("diff_amt__exch").toString()));
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", 0.0 - Double.valueOf(HdrMap.get("diff_amt__exch") == null ? "0.00" : HdrMap.get("diff_amt__exch").toString()));
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "MPCANC");
                glTraceMap.put("ref_id", HdrMap.get("tran_id"));
                glTraceMap.put("remarks", HdrMap.get("remarks"));
                errString = this.finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", null, null, (Object)("1048@ errString glTraceUpdate [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string9 = errString;
                    return string9;
                }
            }
            try {
                sql = "select edi_option from transetup where tran_window = 'w_misc_pay_canc'";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    lsEdiOption = rs.getInt("edi_option");
                }
                this.closeRsPstmt(rs, (PreparedStatement)pstmt);
                BaseLogger.log((String)"3", null, null, (Object)("@V@ lsEdiOption :-[" + lsEdiOption + "]"));
                if (lsEdiOption > 0) {
                    glTraceMap.put("confirmed", "Y");
                    glTraceMap.put("conf_date", today);
                    glTraceMap.put("emp_code__aprv", loginEmpCode);
                    if (lsEdiOption == 2) {
                        CreateRCPXML createRCPXML = new CreateRCPXML("w_misc_pay_canc", "tran_id");
                        dataStr = createRCPXML.getTranXML(tranId, conn);
                        BaseLogger.log((String)"3", null, null, (Object)("dataStr 1273=[ " + dataStr + "]"));
                        Document ediDataDom = this.genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_misc_pay_canc", "0", xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (errString != null && "SUCCESS".equals(errString)) {
                            BaseLogger.log((String)"3", null, null, (Object)("1123@ retString from batchload [" + errString + "]"));
                        }
                    } else {
                        CreateRCPXML createRCPXML = new CreateRCPXML("w_misc_pay_canc", "tran_id");
                        dataStr = createRCPXML.getTranXML(tranId, conn);
                        BaseLogger.log((String)"3", null, null, (Object)("1130@ dataStr [ " + dataStr + "]"));
                        Document ediDataDom = this.genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_misc_pay_canc", "0", xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (errString != null && "SUCCESS".equals(errString)) {
                            BaseLogger.log((String)"3", null, null, (Object)("1140@ retString from batchload [" + errString + "]"));
                        } else {
                            BaseLogger.log((String)"3", null, null, (Object)("1144@ retString from batchload [" + errString + "]"));
                        }
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception :MiscPayCancConf :gbfPostMiscPayCanchdr :==>" + e.getMessage()));
                errString = this.genericUtility.createErrorString(e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                    pstmt1 = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    /*
     * Exception decompiling
     */
    public String gbfPostMpayCancDet(String tranId, HashMap HdrMap, ArrayList DetList, String xtraParams, Connection conn) throws RemoteException, ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[DOLOOP]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeRsPstmt(ResultSet rs, PreparedStatement pstmt) throws ITMException {
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ITMException((Exception)e);
        }
    }

    private void closeResource(ResultSet rs, PreparedStatement pstmt) throws ITMException {
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in MiscPayCanConf][closeResource]--[" + e.getMessage() + "]"));
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private String[] string2StringArray(String str1, String delimeter) {
        StringTokenizer st = new StringTokenizer(str1, delimeter);
        int count = st.countTokens();
        String[] arry1 = new String[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            arry1[i] = st.nextToken();
            System.out.print("Token " + i + " :[" + arry1[i] + "]");
            ++i;
        }
        BaseLogger.log((String)"3", null, null, (Object)"");
        return arry1;
    }

    private String getMsg(String trace, String Code, Connection conn) throws ITMException, Exception {
        String mainStr = "";
        try {
            ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
            String errString = "";
            errString = itmDBAccessEJB.getErrorString("", Code, "", "", conn);
            String begPart = errString.substring(0, errString.indexOf("<message>") + 9);
            String begDesc = errString.substring(0, errString.indexOf("<description>") + 13);
            String endDesc = errString.substring(errString.indexOf("</description>"));
            mainStr = String.valueOf(begPart) + trace + " </message><description>";
            mainStr = String.valueOf(mainStr) + endDesc;
            begPart = null;
            itmDBAccessEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return mainStr;
    }

    private String checkNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public String checkNullAndTrim(String inputVal) {
        inputVal = inputVal == null ? "" : inputVal.trim();
        return inputVal;
    }
}

