/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.adv.MiscPayActLocal;
import ibase.webitm.ejb.fin.adv.MiscPayActRemote;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class MiscPayAct
extends ActionHandlerEJB
implements MiscPayActLocal,
MiscPayActRemote {
    DecimalFormat decimalFormat = null;

    @Override
    public String actionHandler() throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String actionHandler(String actionType, String xmlString, String objContext, String xtraParams) throws RemoteException, ITMException {
        Document dom = null;
        String resString = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            if (actionType.equalsIgnoreCase("Voucher")) {
                if (xmlString != null && xmlString.trim().length() != 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("XML String :" + xmlString));
                    dom = genericUtility.parseString(xmlString);
                }
                resString = this.actionVoucher(dom, objContext, xtraParams);
            }
            if (actionType.equalsIgnoreCase("AllRec")) {
                if (xmlString != null && xmlString.trim().length() != 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("XML String :" + xmlString));
                    dom = genericUtility.parseString(xmlString);
                }
                resString = this.actionAllRecords(dom, objContext, xtraParams);
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :MiscPay :actionHandler(String xmlString):" + e.getMessage() + ":"));
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("returning from actionVoucher actionHandler" + resString));
        return resString;
    }

    public String actionHandlerTransform(String actionType, String xmlString, String xmlString1, String objContext, String xtraParams, String selDataStr) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"actionHandlerTransform is calling.............");
        Document dom = null;
        Document dom1 = null;
        Document selDataDom = null;
        String retString = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            if (xmlString != null && xmlString.trim().length() != 0) {
                dom = genericUtility.parseString(xmlString);
            }
            if (xmlString1 != null && xmlString1.trim().length() != 0) {
                dom1 = genericUtility.parseString(xmlString1);
            }
            if (selDataStr != null && selDataStr.length() > 0) {
                selDataDom = genericUtility.parseString(selDataStr);
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("!!!!actionType:" + actionType + ":"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("!!!!xmlString :" + xmlString + "\n xmlString1 :" + xmlString1));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("!!!!!selDataStr :" + selDataStr));
            if (actionType.equalsIgnoreCase("Voucher")) {
                retString = this.voucherTransform(dom, dom1, objContext, xtraParams, selDataDom);
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :actionVoucher :actionHandlerTransform(String xmlString):" + e.getMessage() + ":"));
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("returning String from actionVoucher : actionHandlerTransform" + retString));
        return retString;
    }

    private String actionVoucher(Document dom, String objContext, String xtraParams) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"\n  in actionVoucher............");
        String siteCode = "";
        String currCode = "";
        String sundryCode = "";
        String sundryType = "";
        StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
        String sql1 = "";
        String sql2 = "";
        String sql3 = "";
        String sql4 = "";
        String errCode = "";
        String str1 = "";
        String str2 = "";
        String grpCode = "";
        String errString = "";
        String tranID = "";
        int rowCnt = 0;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String paymentType = null;
        Object vouchDate = null;
        Object tranDate = null;
        Object billDate = null;
        String vouchDate1 = "";
        String tranDate1 = "";
        String billDate1 = "";
        String pendingQtyStr = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        ConnDriver connDriver = new ConnDriver();
        ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
        try {
            this.decimalFormat = new DecimalFormat("#.###");
            conn = this.getConnection();
            paymentType = genericUtility.getColumnValue("pay_type", dom);
            tranID = genericUtility.getColumnValue("tran_id", dom);
            siteCode = "P".equalsIgnoreCase(paymentType) ? genericUtility.getColumnValue("site_code__bill", dom) : genericUtility.getColumnValue("site_code", dom);
            currCode = genericUtility.getColumnValue("curr_code", dom);
            sundryCode = genericUtility.getColumnValue("sundry_code", dom);
            sundryType = genericUtility.getColumnValue("sundry_type", dom);
            char sundryType1 = sundryType.charAt(0);
            sql1 = "SELECT COUNT(*) AS ROWCNT FROM MISC_PAYABLES WHERE SITE_CODE = '" + siteCode + "'" + " AND CURR_CODE = '" + currCode + "'" + " AND SUNDRY_TYPE = '" + sundryType + "'" + "AND SUNDRY_CODE = '" + sundryCode + "'" + " AND (TOT_AMT - ADJ_AMT - (case when PDC_AMOUNT is null then 0 else PDC_AMOUNT end) ) <> 0";
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("sql1 :=" + sql1));
            pstmt = conn.prepareStatement(sql1);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                rowCnt = rs.getInt("ROWCNT");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (rowCnt == 0) {
                errCode = "VTNOPAYBL";
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errCode :" + errCode));
                errString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
                conn.close();
                conn = null;
                String string = errString;
                return string;
            }
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("sundryType check in switch case " + sundryType1));
                switch (sundryType1) {
                    case 'E': {
                        str1 = "AND MISC_PAYABLES.SUNDRY_CODE  = '" + sundryCode + "'";
                        break;
                    }
                    case 'C': {
                        sql2 = "SELECT GROUP_CODE FROM CUSTOMER WHERE CUST_CODE = '" + sundryCode + "'";
                        pstmt = conn.prepareStatement(sql2);
                        rs1 = pstmt.executeQuery();
                        if (rs1.next()) {
                            grpCode = rs1.getString(1);
                        }
                        rs1.close();
                        rs1 = null;
                        pstmt.close();
                        pstmt = null;
                        str1 = "AND MISC_PAYABLES.SUNDRY_CODE IN (SELECT CUST_CODE FROM CUSTOMER WHERE GROUP_CODE = '" + grpCode + "')";
                        break;
                    }
                    case 'R': {
                        sql2 = "SELECT GROUP_CODE FROM CUSTOMER WHERE CUST_CODE = (SELECT CUST_CODE FROM STRG_CUSTOMER WHERE SC_CODE = '" + sundryCode + "')";
                        pstmt = conn.prepareStatement(sql2);
                        rs1 = pstmt.executeQuery();
                        if (rs1.next()) {
                            grpCode = rs1.getString(1);
                        }
                        rs1.close();
                        rs1 = null;
                        pstmt.close();
                        pstmt = null;
                        str1 = "AND MISC_PAYABLES.SUNDRY_CODE IN (SELECT CUST_CODE FROM CUSTOMER WHERE GROUP_CODE = '" + grpCode + "')";
                        break;
                    }
                    case 'S': {
                        sql2 = " SELECT GROUP_CODE FROM SUPPLIER WHERE SUPP_CODE ='" + sundryCode + "'";
                        pstmt = conn.prepareStatement(sql2);
                        rs1 = pstmt.executeQuery();
                        if (rs1.next()) {
                            grpCode = rs1.getString(1);
                        }
                        rs1.close();
                        rs1 = null;
                        pstmt.close();
                        pstmt = null;
                        str1 = "AND MISC_PAYABLES.SUNDRY_CODE IN (SELECT SUPP_CODE FROM SUPPLIER WHERE GROUP_CODE ='" + grpCode + "')";
                        break;
                    }
                    case 'B': {
                        sql2 = "SELECT GROUP_CODE FROM BANK WHERE BANK_CODE ='" + sundryCode + "'";
                        pstmt = conn.prepareStatement(sql2);
                        rs1 = pstmt.executeQuery();
                        if (rs1.next()) {
                            grpCode = rs1.getString(1);
                        }
                        rs1.close();
                        rs1 = null;
                        pstmt.close();
                        pstmt = null;
                        str1 = "AND MISC_PAYABLES.SUNDRY_CODE IN (SELECT BANK_CODE FROM BANK WHERE GROUP_CODE ='" + grpCode + "')";
                        break;
                    }
                    case 'P': {
                        sql2 = "SELECT GROUP_CODE FROM SALES_PERS WHERE SALES_PERS ='" + sundryCode + "'";
                        pstmt = conn.prepareStatement(sql2);
                        rs1 = pstmt.executeQuery();
                        if (rs1.next()) {
                            grpCode = rs1.getString(1);
                        }
                        rs1.close();
                        rs1 = null;
                        pstmt.close();
                        pstmt = null;
                        str1 = "AND MISC_PAYABLES.SUNDRY_CODE IN (SELECT SALES_PERS FROM SALES_PERS WHERE GROUP_CODE ='" + grpCode + "')";
                        break;
                    }
                    case 'T': {
                        sql2 = "SELECT GROUP_CODE FROM TRANSPORTER WHERE TRAN_CODE ='" + sundryCode + "'";
                        pstmt = conn.prepareStatement(sql2);
                        rs1 = pstmt.executeQuery();
                        if (rs1.next()) {
                            grpCode = rs1.getString(1);
                        }
                        rs1.close();
                        rs1 = null;
                        pstmt.close();
                        pstmt = null;
                        str1 = "AND MISC_PAYABLES.SUNDRY_CODE IN (SELECT TRAN_CODE FROM TRANSPORTER WHERE GROUP_CODE ='" + grpCode + "')";
                        break;
                    }
                    case 'L': {
                        sql2 = "SELECT GROUP_CODE FROM LOANPARTY WHERE PARTY_CODE ='" + sundryCode + "'";
                        pstmt = conn.prepareStatement(sql2);
                        rs1 = pstmt.executeQuery();
                        if (rs1.next()) {
                            grpCode = rs1.getString(1);
                        }
                        rs1.close();
                        rs1 = null;
                        pstmt.close();
                        pstmt = null;
                        str1 = "AND MISC_PAYABLES.SUNDRY_CODE IN (SELECT PARTY_CODE FROM LOANPARTY WHERE GROUP_CODE ='" + grpCode + "')";
                        break;
                    }
                    case 'X': {
                        str1 = "AND MISC_PAYABLES.SUNDRY_CODE = '" + sundryCode + "'";
                    }
                }
                sql3 = "SELECT MISC_PAYABLES.TRAN_ID, MISC_PAYABLES.TRAN_SER, MISC_PAYABLES.TRAN_DATE, MISC_PAYABLES.BILL_NO, MISC_PAYABLES.BILL_DATE, MISC_PAYABLES.CURR_CODE, MISC_PAYABLES.SUNDRY_CODE, MISC_PAYABLES.TOT_AMT, MISC_PAYABLES.ADJ_AMT, MISC_PAYABLES.SUNDRY_TYPE, MISC_PAYABLES.REF_NO, MISC_PAYABLES.REF_DATE, MISC_PAYABLES.DUE_DATE FROM MISC_PAYABLES WHERE MISC_PAYABLES.CURR_CODE = '" + currCode + "' " + "AND MISC_PAYABLES.SITE_CODE = '" + siteCode + "' " + "AND MISC_PAYABLES.SUNDRY_TYPE = '" + sundryType + "' " + "AND (MISC_PAYABLES.TOT_AMT - MISC_PAYABLES.ADJ_AMT - (case when MISC_PAYABLES.PDC_AMOUNT is null then 0 else MISC_PAYABLES.PDC_AMOUNT end) ) <> 0 ";
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("str1:=" + str1));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("sql3:=" + sql3));
                sql4 = sql3.concat(str1);
                sql4 = String.valueOf(sql4) + " ORDER BY BILL_DATE , BILL_NO ";
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("sql4:=" + sql4));
                SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
                pstmt = conn.prepareStatement(sql4);
                rs2 = pstmt.executeQuery();
                while (rs2.next()) {
                    double peindingQty = rs2.getDouble(8) - rs2.getDouble(9);
                    pendingQtyStr = this.decimalFormat.format(peindingQty);
                    valueXmlString.append("<Detail>\r\n");
                    valueXmlString.append("<tran_id>").append("<![CDATA[").append(rs2.getString(1) == null ? "" : rs2.getString(1).trim()).append("]]>").append("</tran_id>\r\n");
                    valueXmlString.append("<ref_no>").append("<![CDATA[").append(rs2.getString(11) == null ? "" : rs2.getString(11).trim()).append("]]>").append("</ref_no>\r\n");
                    valueXmlString.append("<tran_ser>").append("<![CDATA[").append(rs2.getString(2) == null ? "" : rs2.getString(2).trim()).append("]]>").append("</tran_ser>\r\n");
                    valueXmlString.append("<tran_date>").append("<![CDATA[").append(rs2.getDate(12) == null ? "" : sdf.format(rs2.getDate(12))).append("]]>").append("</tran_date>\r\n");
                    valueXmlString.append("<sundry_type>").append("<![CDATA[").append(rs2.getString(10) == null ? "" : rs2.getString(10).trim()).append("]]>").append("</sundry_type>\r\n");
                    valueXmlString.append("<sundry_code>").append("<![CDATA[").append(rs2.getString(7) == null ? "" : rs2.getString(7).trim()).append("]]>").append("</sundry_code>\r\n");
                    valueXmlString.append("<tot_amt>").append("<![CDATA[").append(rs2.getString(8) == null ? "" : rs2.getString(8).trim()).append("]]>").append("</tot_amt>\r\n");
                    valueXmlString.append("<pending_amt>").append("<![CDATA[").append(pendingQtyStr).append("]]>").append("</pending_amt>\r\n");
                    valueXmlString.append("<bill_no>").append("<![CDATA[").append(rs2.getString(4) == null ? " " : rs2.getString(4).trim()).append("]]>").append("</bill_no>\r\n");
                    valueXmlString.append("<tran_id__payable>").append("<![CDATA[").append(rs2.getString(1).trim()).append("]]>").append("</tran_id__payable>\r\n");
                    valueXmlString.append("<due_date>").append("<![CDATA[").append(rs2.getDate(13) == null ? "" : sdf.format(rs2.getDate(13))).append("]]>").append("</due_date>\r\n");
                    valueXmlString.append("<bill_date>").append("<![CDATA[").append(rs2.getDate(5) == null ? "" : sdf.format(rs2.getDate(5))).append("]]>").append("</bill_date>\r\n");
                    valueXmlString.append("<curr_code>").append("<![CDATA[").append(rs2.getString(6) == null ? "" : rs2.getString(6).trim()).append("]]>").append("</curr_code>\r\n");
                    valueXmlString.append("<vouch_no>").append("<![CDATA[").append(rs2.getString(11) == null ? "" : rs2.getString(11).trim()).append("]]>").append("</vouch_no>\r\n");
                    valueXmlString.append("<vouch_date>").append("<![CDATA[").append(rs2.getDate(12) == null ? "" : sdf.format(rs2.getDate(12))).append("]]>").append("</vouch_date>\r\n");
                    valueXmlString.append("</Detail>\r\n");
                }
                rs2.close();
                rs2 = null;
                pstmt.close();
                pstmt = null;
                valueXmlString.append("</Root>\r\n");
            }
            catch (SQLException e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : MiscPay : actionVoucher " + e.getMessage()));
                throw new ITMException((Exception)e);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : MiscPay : actionVoucher :(Document dom)" + e.getMessage()));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("valueXmlString.toString() " + valueXmlString.toString()));
        return valueXmlString.toString();
    }

    private String actionAllRecords(Document dom, String objContext, String xtraParams) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"\n######!!!!!!!! In actionAllRecords..............");
        String tranId = "";
        String sql = "";
        StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String errCode = "";
        String errString = "";
        String detCnt = "0";
        ConnDriver connDriver = new ConnDriver();
        E12GenericUtility genericUtility = new E12GenericUtility();
        ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("actionAllRecords detCnt [" + detCnt + "]"));
            if (detCnt.equals("0")) {
                conn = this.getConnection();
                tranId = String.valueOf(genericUtility.getColumnValue("vouch_no", dom)) + "%";
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("actionAllRecords tranId [" + tranId + "]"));
                sql = "SELECT REF_NO FROM MISC_PAYABLES WHERE REF_NO LIKE '" + tranId + "'" + " AND CASE WHEN TOT_AMT IS NULL THEN 0 ELSE TOT_AMT END - CASE WHEN ADJ_AMT IS NULL THEN 0 ELSE ADJ_AMT END <> 0 AND CASE WHEN HOLD_AMT IS NULL THEN 0 ELSE HOLD_AMT END = 0";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    valueXmlString.append("<Detail>\r\n");
                    valueXmlString.append("<vouch_no>").append("<![CDATA[").append(rs.getString(1) == null ? "" : rs.getString(1).trim()).append("]]>").append("</vouch_no>\r\n");
                    valueXmlString.append("</Detail>\r\n");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                valueXmlString.append("</Root>\r\n");
            } else {
                errCode = "VTDETCNT";
            }
            if (!errCode.equals("")) {
                errString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
                conn.close();
                conn = null;
                String string = errString;
                return string;
            }
        }
        catch (SQLException e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : MiscPay : actionAllRecords " + e.getMessage()));
            throw new ITMException((Exception)e);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : MiscPay : actionHandler :(Document dom)" + e.getMessage()));
            throw new ITMException(e);
        }
        finally {
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Closing Connection........");
                conn.close();
                conn = null;
            }
            catch (SQLException sQLException) {}
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("valueXmlString.toString() :" + valueXmlString.toString()));
        return valueXmlString.toString();
    }

    private String voucherTransform(Document dom, Document dom1, String objContext, String xtraParams, Document selDataDom) throws ITMException {
        StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Node currDetail = null;
        String sundryType = "";
        String sundryCode = "";
        String refNo = "";
        String currCode = "";
        String acctCode = "";
        String sql = "";
        String cctrCode = "";
        String transSer = "";
        String taxChap = "";
        String taxClass = "";
        String taxEnv = "";
        Date refDate = null;
        double exchRate = 0.0;
        double netAmt = 0.0;
        double payAmt = 0.0;
        ConnDriver connDriver = new ConnDriver();
        DistCommon disCommon = new DistCommon();
        String tranIdHrd = "";
        String payMode = "";
        String bankCode = "";
        String tranDate = "";
        String payableAt = "";
        String stanCode = "";
        String payAmtStr = "";
        double hdrExchRate = 0.0;
        double chngRate = 0.0;
        double totalPaid = 0.0;
        String taxClassHdr = "";
        String taxChapHdr = "";
        String taxEnvHdr = "";
        String tranId = "";
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                this.decimalFormat = new DecimalFormat("#.###");
                conn = this.getConnection();
                NodeList detailList = selDataDom.getElementsByTagName("Detail");
                int noOfDetails = detailList.getLength();
                int ctr = 0;
                while (ctr < noOfDetails) {
                    currDetail = detailList.item(ctr);
                    tranId = genericUtility.getColumnValueFromNode("tran_id", currDetail);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranId :" + tranId));
                    sql = "SELECT SUNDRY_TYPE, SUNDRY_CODE, REF_NO, REF_DATE, CURR_CODE, EXCH_RATE, ACCT_CODE, CCTR_CODE, (TOT_AMT - ADJ_AMT - (case when PDC_AMOUNT is null then 0 else PDC_AMOUNT end) ), (TOT_AMT - ADJ_AMT - (case when PDC_AMOUNT is null then 0 else PDC_AMOUNT end) ), TRAN_SER  FROM MISC_PAYABLES WHERE TRAN_ID = ?";
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("sql :" + sql));
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        sundryType = rs.getString(1);
                        sundryCode = rs.getString(2);
                        refNo = rs.getString(3);
                        refDate = rs.getDate(4);
                        currCode = rs.getString(5);
                        exchRate = rs.getDouble(6);
                        acctCode = rs.getString(7);
                        cctrCode = rs.getString(8);
                        netAmt = rs.getDouble(9);
                        payAmt = rs.getDouble(10);
                        transSer = rs.getString(11);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    payAmtStr = this.decimalFormat.format(payAmt);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Amount Paid In Decimal Format @n!k 608 payamt:[" + payAmt + "] " + "\n After converting Decimal Fromat:[" + payAmtStr + "]"));
                    hdrExchRate = Double.parseDouble(genericUtility.getColumnValue("exch_rate", dom1));
                    tranIdHrd = genericUtility.getColumnValue("tran_id", dom1);
                    SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
                    valueXmlString.append("<Detail>");
                    valueXmlString.append("<tran_id isSrvCallOnChg='0'>").append("<![CDATA[").append(tranIdHrd).append("]]>").append("</tran_id>\r\n");
                    valueXmlString.append("<tran_ser isSrvCallOnChg='0'>").append("<![CDATA[").append(transSer).append("]]>").append("</tran_ser>\r\n");
                    valueXmlString.append("<vouch_no isSrvCallOnChg='1'>").append("<![CDATA[").append(refNo == null ? "" : refNo.trim()).append("]]>").append("</vouch_no>\r\n");
                    valueXmlString.append("<vouch_date isSrvCallOnChg='0'>").append("<![CDATA[").append(refDate == null ? "" : sdf.format(refDate)).append("]]>").append("</vouch_date>\r\n");
                    valueXmlString.append("<sundry_type isSrvCallOnChg='0'>").append("<![CDATA[").append(sundryType).append("]]>").append("</sundry_type>\r\n");
                    valueXmlString.append("<sundry_code isSrvCallOnChg='0'>").append("<![CDATA[").append(sundryCode).append("]]>").append("</sundry_code>\r\n");
                    valueXmlString.append("<vouch_date isSrvCallOnChg='0'>").append("<![CDATA[").append(refDate == null ? "" : sdf.format(refDate)).append("]]>").append("</vouch_date>\r\n");
                    valueXmlString.append("<curr_code isSrvCallOnChg='0'>").append("<![CDATA[").append(currCode).append("]]>").append("</curr_code>\r\n");
                    valueXmlString.append("<exch_rate__vouch isSrvCallOnChg='0'>").append("<![CDATA[").append(exchRate).append("]]>").append("</exch_rate__vouch>\r\n");
                    valueXmlString.append("<acct_code__ap isSrvCallOnChg='0'>").append("<![CDATA[").append(acctCode).append("]]>").append("</acct_code__ap>\r\n");
                    valueXmlString.append("<cctr_code__ap isSrvCallOnChg='0'>").append("<![CDATA[").append(cctrCode).append("]]>").append("</cctr_code__ap>\r\n");
                    valueXmlString.append("<net_amt isSrvCallOnChg='0'>").append("<![CDATA[").append(netAmt).append("]]>").append("</net_amt>\r\n");
                    valueXmlString.append("<net_pay_amt isSrvCallOnChg='0'>").append("<![CDATA[").append(netAmt).append("]]>").append("</net_pay_amt>\r\n");
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Amount Paid @nik 631 :[" + payAmtStr + "]"));
                    valueXmlString.append("<pay_amt isSrvCallOnChg='0'>").append("<![CDATA[").append(payAmtStr).append("]]>").append("</pay_amt>\r\n");
                    double currDiffrence = payAmt * exchRate - payAmt * hdrExchRate;
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("currDiffrence :" + currDiffrence));
                    valueXmlString.append("<diff_amt__exch isSrvCallOnChg='0'>").append("<![CDATA[").append(currDiffrence).append("]]>").append("</diff_amt__exch>\r\n");
                    payMode = genericUtility.getColumnValue("pay_mode", dom1);
                    String payamt = genericUtility.getColumnValue("pay_amt", selDataDom);
                    if (payamt != null && payamt.trim().length() > 0) {
                        payAmt = Double.parseDouble(payamt);
                    }
                    bankCode = genericUtility.getColumnValue("bank_code", dom1);
                    tranDate = genericUtility.getColumnValue("tran_date", dom1);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("payAmt  :" + payAmt + " \n bankCode :" + bankCode + " \ntranDate:" + tranDate));
                    chngRate = this.bankChargesCalc(bankCode, payMode, tranDate, payAmt);
                    valueXmlString.append("<bank_charges isSrvCallOnChg='0'>").append("<![CDATA[").append(chngRate).append("]]>").append("</bank_charges>\r\n");
                    if (payMode.equals("D") || payMode.equals("P")) {
                        payableAt = this.payableAt(sundryType, sundryCode, bankCode);
                        valueXmlString.append("<drawn_at isSrvCallOnChg='0'>").append("<![CDATA[").append(payableAt).append("]]>").append("</drawn_at>\r\n");
                    }
                    stanCode = this.stanDrawn(sundryType, sundryCode);
                    valueXmlString.append("<stan_code isSrvCallOnChg='0'>").append("<![CDATA[").append(stanCode).append("]]>").append("</stan_code>\r\n");
                    taxClassHdr = genericUtility.getColumnValue("tax_class", dom1);
                    taxChapHdr = genericUtility.getColumnValue("tax_chap", dom1);
                    taxEnvHdr = genericUtility.getColumnValue("tax_env", dom1);
                    String itemCode = "";
                    String itemSer = "M-PAY";
                    String code = "";
                    String siteCode = "";
                    String stationFr = "";
                    String stationTo = "";
                    code = genericUtility.getColumnValue("sundry_code", dom1);
                    if (!(taxClassHdr != null && taxClassHdr.trim().length() != 0 || taxChapHdr != null && taxChapHdr.trim().length() != 0 || taxEnvHdr != null && taxEnvHdr.trim().length() != 0)) {
                        if (taxChap == null || taxChap.trim().length() == 0) {
                            if (taxChapHdr == null || taxChapHdr.trim().length() == 0) {
                                taxChap = disCommon.getTaxChap(itemCode, itemSer, "S", code, siteCode, conn);
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("taxChap :" + taxChap));
                                valueXmlString.append("<tax_chap isSrvCallOnChg='0'>").append("<![CDATA[").append(taxChap).append("]]>").append("</tax_chap>\r\n");
                            } else {
                                valueXmlString.append("<tax_chap isSrvCallOnChg='0'>").append("<![CDATA[").append(taxChapHdr).append("]]>").append("</tax_chap>\r\n");
                            }
                        }
                        if (taxClass == null || taxClass.trim().length() == 0) {
                            if (taxClassHdr == null || taxClassHdr.trim().length() == 0) {
                                taxClass = disCommon.getTaxClass("S", code, itemCode, siteCode, conn);
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("taxClass :" + taxClass));
                                valueXmlString.append("<tax_class isSrvCallOnChg='0'>").append("<![CDATA[").append(taxClass).append("]]>").append("</tax_class>\r\n");
                            } else {
                                valueXmlString.append("<tax_class isSrvCallOnChg='0'>").append("<![CDATA[").append(taxClassHdr).append("]]>").append("</tax_class>\r\n");
                            }
                        }
                        if (taxEnv == null || taxEnv.trim().length() == 0) {
                            if (taxEnvHdr == null || taxEnvHdr.trim().length() == 0) {
                                taxChap = this.checkNull(genericUtility.getColumnValue("tax_chap", selDataDom));
                                taxClass = this.checkNull(genericUtility.getColumnValue("tax_class", selDataDom));
                                stationFr = genericUtility.getColumnValue("stan_code", selDataDom);
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("stationFr :" + stationFr));
                                sql = "SELECT STAN_CODE FROM SITE WHERE SITE_CODE = ?";
                                pstmt = conn.prepareStatement(sql);
                                pstmt.setString(1, siteCode);
                                rs = pstmt.executeQuery();
                                if (rs.next()) {
                                    stationTo = rs.getString(1);
                                }
                                rs.close();
                                rs = null;
                                pstmt.close();
                                pstmt = null;
                                taxEnv = disCommon.getTaxEnv(stationFr, stationTo, taxChap, taxClass, siteCode, conn);
                                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("taxEnv :" + taxEnv));
                                valueXmlString.append("<tax_env isSrvCallOnChg='0'>").append("<![CDATA[").append(taxEnv).append("]]>").append("</tax_env>\r\n");
                            } else {
                                valueXmlString.append("<tax_env isSrvCallOnChg='0'>").append("<![CDATA[").append(taxEnvHdr).append("]]>").append("</tax_env>\r\n");
                            }
                        }
                    } else {
                        if (taxChap == null || taxChap.trim().length() == 0) {
                            valueXmlString.append("<tax_chap isSrvCallOnChg='0'>").append("<![CDATA[").append(taxChapHdr).append("]]>").append("</tax_chap>\r\n");
                        }
                        if (taxClass == null || taxClass.trim().length() == 0) {
                            valueXmlString.append("<tax_class isSrvCallOnChg='0'>").append("<![CDATA[").append(taxClassHdr).append("]]>").append("</tax_class>\r\n");
                        }
                        if (taxEnv == null || taxEnv.trim().length() == 0) {
                            valueXmlString.append("<tax_env isSrvCallOnChg='0'>").append("<![CDATA[").append(taxEnvHdr).append("]]>").append("</tax_env>\r\n");
                        }
                    }
                    valueXmlString.append("</Detail>");
                    ++ctr;
                }
                valueXmlString.append("</Root>");
            }
            catch (ITMException itme) {
                throw itme;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Closing Connection.....");
                conn.close();
                conn = null;
            }
            catch (Exception exception) {}
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("valueXmlString from voucherTransFer():" + valueXmlString.toString()));
        return valueXmlString.toString();
    }

    public String checkNull(String inputVal) {
        if (inputVal == null || inputVal.trim().length() == 0) {
            inputVal = "";
        }
        return inputVal;
    }

    private String payableAt(String sundryType, String sundryCode, String bankCode) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        String sql = "";
        String payableAt = "";
        String stanCode = "";
        String bankRef = "";
        ConnDriver connDriver = new ConnDriver();
        ResultSet rs = null;
        try {
            try {
                conn = this.getConnection();
                char sundryType1 = sundryType.charAt(0);
                switch (sundryType1) {
                    case 'E': {
                        sql = "SELECT DD_PAYABLE_BANK, STAN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
                        break;
                    }
                    case 'S': {
                        sql = "SELECT BANK_REF, STAN_CODE FROM SUPPLIER WHERE SUPP_CODE = ?";
                        break;
                    }
                    case 'C': {
                        sql = "SELECT BANK_NAME, STAN_CODE FROM CUSTOMER WHERE CUST_CODE = ?";
                        break;
                    }
                    case 'P': 
                    case 'T': {
                        sql = "SELECT PAYABLE_REF, STAN_CODE FROM TRANSPORTER WHERE TRAN_CODE = ?";
                        break;
                    }
                    case 'X': {
                        sql = "SELECT BANK_REF, STAN_CODE FROM TAX_AUTHORITY WHERE TAUTH_CODE = ?";
                    }
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("sql :" + sql));
                if (sql != null) {
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        payableAt = rs.getString(1);
                        stanCode = rs.getString(2);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("payableAt :" + payableAt));
                if (payableAt == null || payableAt.trim().length() > 0) {
                    sql = "SELECT DRAWN_AT, BANK_REF FROM BANK_STAN_SERV WHERE BANK_CODE = ?\tAND STAN_CODE = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, bankCode);
                    pstmt.setString(2, stanCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        payableAt = rs.getString(1);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("payableAt  :" + payableAt));
                        bankRef = rs.getString(2);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("bankRef :" + bankRef));
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    if (bankRef != null) {
                        payableAt = String.valueOf(payableAt == null ? "" : String.valueOf(payableAt.trim()) + ", ") + bankRef.trim();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("payableAt  :" + payableAt));
                    }
                }
            }
            catch (SQLException sqx) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("The sqlException occure in MiscPayActEJB :" + sqx));
                throw new ITMException((Exception)sqx);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("The Exception occure in MiscPayActEJB :" + e));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Closing Connection.....");
                conn.close();
                conn = null;
            }
            catch (Exception exception) {}
        }
        return payableAt;
    }

    private String stanDrawn(String sundryType, String sundryCode) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        Statement pstmt1 = null;
        String sql = "";
        String empCode = "";
        String stanCode = "";
        ConnDriver connDriver = new ConnDriver();
        ResultSet rs = null;
        ResultSet rs1 = null;
        try {
            try {
                conn = this.getConnection();
                char sundryType1 = sundryType.charAt(0);
                switch (sundryType1) {
                    case 'E': {
                        sql = "SELECT STAN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
                        break;
                    }
                    case 'S': {
                        sql = "SELECT STAN_CODE FROM SUPPLIER WHERE SUPP_CODE = ?";
                        break;
                    }
                    case 'C': {
                        sql = "SELECT STAN_CODE FROM CUSTOMER WHERE CUST_CODE = ?";
                        break;
                    }
                    case 'P': {
                        sql = "SELECT EMP_CODE FROM SALES_PERS WHERE SALES_PERS = ? ";
                        pstmt1 = conn.prepareStatement(sql);
                        pstmt1.setString(1, sundryCode);
                        rs1 = pstmt1.executeQuery();
                        rs1 = pstmt1.executeQuery();
                        if (rs1.next()) {
                            empCode = rs1.getString(1);
                        }
                        rs1.close();
                        rs1 = null;
                        pstmt1.close();
                        pstmt1 = null;
                        if (empCode == null && empCode.trim().length() <= 0) break;
                        sql = "SELECT STAN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
                        sundryCode = empCode;
                        break;
                    }
                    case 'T': {
                        sql = "SELECT STAN_CODE FROM TRANSPORTER WHERE TRAN_CODE = ?";
                        break;
                    }
                    case 'L': {
                        sql = "SELECT STAN_CODE FROM LOANPARTY WHERE PARTY_CODE = ?";
                        break;
                    }
                    case 'X': {
                        sql = "SELECT STAN_CODE FROM TAX_AUTHORITY WHERE TAUTH_CODE = ?";
                    }
                }
                if (sql != null) {
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, sundryCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        stanCode = rs.getString(1);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("stanCode :" + stanCode));
            }
            catch (SQLException sqx) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("The sqlException occure in MiscPayActEJB :" + sqx));
                throw new ITMException((Exception)sqx);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("The Exception occure in MiscPayActEJB :" + e));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                    pstmt1 = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Closing Connection.....");
                conn.close();
                conn = null;
            }
            catch (Exception exception) {}
        }
        return stanCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double bankChargesCalc(String bankCode, String payMode, String tranDate, double payAmt) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("bankCode :" + bankCode + " \n payMode :" + payMode + " \n tranDate :" + tranDate + " \n payAmt :" + payAmt));
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        String cumulative = "";
        String round = "";
        String changeType = "";
        double bankCharges = 0.0;
        double roundTo = 0.0;
        double minAmt = 0.0;
        double maxAmt = 0.0;
        double charges = 0.0;
        ConnDriver connDriver = new ConnDriver();
        ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            conn = this.getConnection();
            sql = "SELECT BANK_CHARGES, CUMULATIVE, ROUND, ROUND_TO, CHARGE_TYPE FROM BANK_CHARGES WHERE BANK_CODE = ? AND PAY_MODE = ? AND EFF_DATE <= ? AND EXP_DATE >= ? AND MIN_AMT <= ? AND MAX_AMT >= ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bankCode);
            pstmt.setString(2, payMode);
            pstmt.setTimestamp(3, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
            pstmt.setTimestamp(4, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
            pstmt.setDouble(5, payAmt);
            pstmt.setDouble(6, payAmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                bankCharges = rs.getDouble(1);
                cumulative = rs.getString(2);
                round = rs.getString(3);
                roundTo = rs.getDouble(4);
                changeType = rs.getString(5);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("bankCharges :" + bankCharges + " cumulative :" + cumulative + " round :" + round + " roundTo:" + roundTo + " changeType :" + changeType));
            if (changeType.equals("P")) {
                bankCharges = payAmt * (bankCharges / 100.0);
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("bankCharges :" + bankCharges));
            if (cumulative == null || cumulative.trim().length() == 0 || cumulative.equals("N")) {
                bankCharges = 0.0;
                sql = "SELECT MIN_AMT, MAX_AMT, CHARGE_TYPE, BANK_CHARGES FROM BANK_CHARGES WHERE BANK_CODE = ? AND PAY_MODE = ? AND EFF_DATE <= ? AND EXP_DATE >= ? AND (MIN_AMT < ? OR ( MIN_AMT < ? AND MAX_AMT > ?)) AND CUMULATIVE = 'Y' ORDER BY MIN_AMT ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, bankCode);
                pstmt.setString(2, payMode);
                pstmt.setTimestamp(3, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                pstmt.setTimestamp(4, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                pstmt.setDouble(5, payAmt);
                pstmt.setDouble(6, payAmt);
                pstmt.setDouble(7, payAmt);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    minAmt = rs.getDouble(1);
                    maxAmt = rs.getDouble(2);
                    changeType = rs.getString(3);
                    charges = rs.getDouble(4);
                    if (charges == 0.0) continue;
                    if (changeType.equals("F")) {
                        bankCharges += charges;
                        continue;
                    }
                    if (!changeType.equals("P")) {
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        return 0.0;
                    }
                    if (payAmt > maxAmt) {
                        bankCharges += charges * ((maxAmt - minAmt) / 100.0);
                        continue;
                    }
                    bankCharges += charges * ((payAmt - minAmt) / 100.0);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            if (bankCharges == 0.0) {
                return 0.0;
            }
            char round1 = round.charAt(0);
            bankCharges = itmDBAccessEJB.getRndamt(bankCharges, round1, roundTo);
            return bankCharges;
        }
        catch (SQLException sqx) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("The sqlException occure in MiscPayActEJB :" + sqx));
            throw new ITMException((Exception)sqx);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("The Exception occure in MiscPayActEJB :" + e));
            throw new ITMException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Closing Connection.....");
                conn.close();
                conn = null;
            }
            catch (Exception exception) {}
        }
    }
}

