/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.LoanConfLocal;
import ibase.webitm.ejb.fin.adv.LoanConfRemote;
import ibase.webitm.ejb.fin.adv.MiscRcpConf;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

@Stateless
public class LoanConf
extends ActionHandlerEJB
implements LoanConfLocal,
LoanConfRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();

    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String errString = "";
        Connection conn = null;
        try {
            errString = this.confirm(tranId, xtraParams, forcedFlag, conn);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in confirm() ==>" + e.getMessage()));
            errString = this.genericUtility.createErrorString(e);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString in cofirm() ==>" + errString));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        String confirm = "";
        String siteCode = "";
        String errString = "";
        FinCommon finCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        boolean isLocalConn = false;
        try {
            finCommon = new FinCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                isLocalConn = true;
            }
            sql = " select confirmed,site_code from loan_hdr  where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                confirm = rs.getString("confirmed");
                siteCode = rs.getString("site_code");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (confirm != null && "Y".equalsIgnoreCase(confirm)) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                String string = errString = itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            errString = this.loanConfirm(tranId, xtraParams, forcedFlag, conn);
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            try {
                errString = new ITMDBAccessEJB().getErrorString("", "VTCONSUCF", "", "", conn);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception ::" + e.getMessage()));
                errString = this.genericUtility.createErrorString(e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Exception while rollbacking222.......");
                }
                throw new ITMException(e);
            }
        }
        finally {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY loanConfirm confirm @#......>>[" + isLocalConn + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY loanConfirm confirm errString@#......>>[" + errString + "]"));
            try {
                if (errString != null && errString.trim().length() > 0) {
                    if (errString.indexOf("VTCONSUCF") > -1) {
                        if (isLocalConn) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Transaction commited111.............from loanConfirm");
                            conn.commit();
                        }
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollbacking......................................");
                        conn.rollback();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollback......................................");
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (isLocalConn) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String loanConfirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        Statement pstmt = null;
        PreparedStatement pstmt1 = null;
        Statement pstmtInner = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rsInner = null;
        String sql = "";
        String sqlInsert = "";
        String sqlInner = "";
        String loginEmpCode = "";
        Object itmDBAccessEJB = null;
        FinCommon Fcommon = new FinCommon();
        DistCommon Dcommon = new DistCommon();
        MiscRcpConf miscRcpConf = new MiscRcpConf();
        Timestamp tranDate = null;
        Object effDate = null;
        Object billDate = null;
        Object dueDate = null;
        Object resiDate = null;
        Object relieveDate = null;
        HashMap<String, Object> loanDetMap = null;
        ArrayList loanDetList = new ArrayList();
        double taxAmt = 0.0;
        double rndTo = 0.0;
        double totAmt = 0.0;
        double netAmt = 0.0;
        double advAmt = 0.0;
        double netAmtBc = 0.0;
        double diffAmtExch = 0.0;
        double suppBillAmt = 0.0;
        double exchRate = 0.0;
        double rndAmt = 0.0;
        double billAmt = 0.0;
        String siteCodehdr = "";
        String loanType = "";
        String tranType = "";
        String loanPartyhdr = "";
        String bankCode = "";
        String acctCodePay = "";
        String cctrCodePay = "";
        String securityTerm = "";
        String othRef = "";
        String remarks = null;
        String currCode = "";
        String finEnt = "";
        String lineNoDet = "";
        String refSerDet = "";
        String AcctCodeDet = "";
        String cctrCodeDet = "";
        String currCodeDet = "";
        String refNoDet = "";
        String sundryCodeDet = "";
        String sundryTypeDet = "";
        String acctCodeBal = "";
        String cctrCodeBal = "";
        String loanTenureUnit = "";
        String acctCodeCF = "";
        String cctrCodeCF = "";
        String basecurrCode = "";
        String errString = "";
        Timestamp sanctionDt = null;
        Timestamp disburseDt = null;
        Timestamp tranDatehdr = null;
        String tranIdRcp = "";
        Double loanAmthdr = 0.0;
        Double marginAmt = 0.0;
        Double marginAmtDet = 0.0;
        Double loanAmtBcHdr = 0.0;
        Double amountPaid = 0.0;
        Double exchRateDet = 0.0;
        Double TotdetAmt = 0.0;
        Double amountBC = 0.0;
        boolean lineInt = false;
        boolean cnt = false;
        int loanTenure = 0;
        boolean detailExist = false;
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(new E12GenericUtility().getApplDateFormat());
            tranDate = new Timestamp(System.currentTimeMillis());
            sql = "  SELECT TRAN_DATE,   SITE_CODE,  LOAN_TYPE,  TRAN_TYPE,  LOAN_PARTY,  BANK_CODE,SANTION_DATE,  DISBURS_DATE,  ACCT_CODE__PAY,  CCTR_CODE__PAY,  LOAN_AMOUNT,  CURR_CODE,  EXCH_RATE,LOAN_AMT__BC,  LOAN_TENURE,  LOAN_TENUE_UNIT,  REPAY_DAYS,  INT_RATE,  MORATORIUM_PRD,SECURITY_TERM,  OTH_REF,  REMARKS ,ACCT_CODE__CF , CCTR_CODE__CF , DIFF_AMT__EXCH  FROM LOAN_HDR  WHERE tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                tranDatehdr = rs.getTimestamp("TRAN_DATE");
                siteCodehdr = rs.getString("SITE_CODE");
                loanType = rs.getString("LOAN_TYPE");
                tranType = rs.getString("TRAN_TYPE");
                loanPartyhdr = rs.getString("LOAN_PARTY");
                bankCode = rs.getString("BANK_CODE");
                sanctionDt = rs.getTimestamp("SANTION_DATE");
                disburseDt = rs.getTimestamp("DISBURS_DATE");
                acctCodePay = rs.getString("ACCT_CODE__PAY");
                cctrCodePay = rs.getString("CCTR_CODE__PAY");
                loanAmthdr = rs.getDouble("LOAN_AMOUNT");
                loanAmtBcHdr = rs.getDouble("LOAN_AMT__BC");
                currCode = rs.getString("CURR_CODE");
                exchRate = rs.getDouble("EXCH_RATE");
                securityTerm = rs.getString("SECURITY_TERM");
                othRef = rs.getString("OTH_REF");
                remarks = rs.getString("REMARKS");
                loanTenure = rs.getInt("LOAN_TENUE_UNIT");
                loanTenureUnit = rs.getString("LOAN_TENURE");
                acctCodeCF = rs.getString("ACCT_CODE__CF");
                cctrCodeCF = rs.getString("CCTR_CODE__CF");
                diffAmtExch = rs.getDouble("DIFF_AMT__EXCH");
            }
            pstmt.close();
            pstmt = null;
            rs.close();
            rs = null;
            sql = "SELECT L.TRAN_ID,L.LINE_NO, L.REF_SER,  L.REF_NO, L.ACCT_CODE,L.CCTR_CODE,L.AMOUNT_PAID,L.AMOUNT__BC,L.CURR_CODE,L.EXCH_RATE    FROM LOAN_DET L WHERE L.tran_id = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                detailExist = true;
                lineNoDet = rs.getString("LINE_NO");
                refSerDet = rs.getString("REF_SER");
                refNoDet = rs.getString("REF_NO");
                AcctCodeDet = rs.getString("ACCT_CODE");
                cctrCodeDet = rs.getString("CCTR_CODE");
                amountPaid = rs.getDouble("AMOUNT_PAID");
                amountBC = rs.getDouble("AMOUNT__BC");
                currCodeDet = rs.getString("CURR_CODE");
                exchRateDet = rs.getDouble("EXCH_RATE");
                String sql2 = "select SUNDRY_CODE,SUNDRY_TYPE,CURR_CODE,EXCH_RATE from misc_payables where ref_no = ? ";
                pstmt1 = conn.prepareStatement(sql2);
                pstmt1.setString(1, refNoDet);
                rs1 = pstmt1.executeQuery();
                if (rs1.next()) {
                    sundryCodeDet = rs1.getString("SUNDRY_CODE");
                    sundryTypeDet = rs1.getString("SUNDRY_TYPE");
                }
                rs1.close();
                rs1 = null;
                pstmt1.close();
                pstmt1 = null;
                loanDetMap = new HashMap<String, Object>();
                loanDetMap.put("LINE_NO", lineNoDet);
                loanDetMap.put("REF_SER", refSerDet);
                loanDetMap.put("REF_NO", refNoDet);
                loanDetMap.put("ACCT_CODE", AcctCodeDet);
                loanDetMap.put("CCTR_CODE", cctrCodeDet);
                loanDetMap.put("AMOUNT_PAID", amountPaid);
                loanDetMap.put("SUNDRY_CODE", sundryCodeDet);
                loanDetMap.put("CURR_CODE", currCodeDet);
                loanDetMap.put("EXCH_RATE", exchRateDet);
                loanDetMap.put("SUNDRY_TYPE", sundryTypeDet);
                loanDetMap.put("AMOUNT__BC", amountBC);
                loanDetList.add(loanDetMap);
            }
            pstmt.close();
            pstmt = null;
            rs.close();
            rs = null;
            sql = "Select fin_entity from site where site_code = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, siteCodehdr);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                finEnt = rs.getString(1);
            }
            pstmt.close();
            pstmt = null;
            rs.close();
            rs = null;
            sql = "SELECT finent.curr_code  FROM finent WHERE finent.fin_entity = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, finEnt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                basecurrCode = rs.getString(1);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            HashMap<String, Object> sundryBalUpd = new HashMap<String, Object>();
            HashMap<String, Object> miscPayUpd = new HashMap<String, Object>();
            HashMap<String, Object> glTraceUpd = new HashMap<String, Object>();
            HashMap<String, Object> glTraceMap = new HashMap<String, Object>();
            if ("2".equalsIgnoreCase(loanType)) {
                for (HashMap hashMap : loanDetList) {
                    TotdetAmt = TotdetAmt + (Double)hashMap.get("AMOUNT_PAID");
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("TOT amtdet" + TotdetAmt));
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("HDRAMT[" + loanAmthdr + "] DETAMT[" + TotdetAmt + "]"));
                int n = Double.compare(loanAmthdr, TotdetAmt);
                if (n > 0 || n < 0) {
                    String string = errString = new ITMDBAccessEJB().getErrorString("", "VTAMTMIS", "", "", conn);
                    return string;
                }
            }
            String string = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Login Code" + string));
            if ("0".equalsIgnoreCase(loanType) || "1".equalsIgnoreCase(loanType)) {
                int endIndex;
                sql = "select acct_code__bal, cctr_code__bal from bank where bank_code = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, bankCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    acctCodeBal = rs.getString("acct_code__bal");
                    cctrCodeBal = rs.getString("cctr_code__bal");
                }
                pstmt.close();
                pstmt = null;
                rs.close();
                rs = null;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
                stringBuffer.append("<DocumentRoot>");
                stringBuffer.append("<description>").append("Datawindow Root").append("</description>");
                stringBuffer.append("<group0>");
                stringBuffer.append("<description>").append("Group0 description").append("</description>");
                stringBuffer.append("<Header0>");
                stringBuffer.append("<objName><![CDATA[").append("misc_rcp").append("]]></objName>");
                stringBuffer.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
                stringBuffer.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
                stringBuffer.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
                stringBuffer.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
                stringBuffer.append("<action><![CDATA[").append("SAVE").append("]]></action>");
                stringBuffer.append("<elementName><![CDATA[").append("").append("]]></elementName>");
                stringBuffer.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
                stringBuffer.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
                stringBuffer.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
                stringBuffer.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
                stringBuffer.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
                stringBuffer.append("<description>").append("Header0 members").append("</description>");
                stringBuffer.append("<Detail1 dbID=\"\" domID='1' objName=\"misc_rcp\" objContext=\"1\">");
                stringBuffer.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
                stringBuffer.append("<tran_id/>");
                stringBuffer.append("<tran_date><![CDATA[" + sdf.format(tranDatehdr) + "]]></tran_date>");
                stringBuffer.append("<eff_date><![CDATA[" + sdf.format(tranDatehdr) + "]]></eff_date>");
                stringBuffer.append("<site_code><![CDATA[" + siteCodehdr + "]]></site_code>");
                stringBuffer.append("<fin_entity><![CDATA[" + finEnt + "]]></fin_entity>");
                stringBuffer.append("<acct_code__bal><![CDATA[" + acctCodeBal + "]]></acct_code__bal>");
                stringBuffer.append("<cctr_code__bal><![CDATA[" + cctrCodeBal + "]]></cctr_code__bal>");
                stringBuffer.append("<sundry_code><![CDATA[" + loanPartyhdr + "]]></sundry_code>");
                stringBuffer.append("<sundry_type><![CDATA[L]]></sundry_type>");
                stringBuffer.append("<tran_type><![CDATA[]]></tran_type>");
                stringBuffer.append("<bank_code><![CDATA[" + bankCode + "]]></bank_code>");
                stringBuffer.append("<net_amt><![CDATA[" + loanAmthdr + "]]></net_amt>");
                stringBuffer.append("<curr_code><![CDATA[" + currCode + "]]></curr_code>");
                stringBuffer.append("<exch_rate><![CDATA[" + exchRate + "]]></exch_rate>");
                stringBuffer.append("<net_amt__bc><![CDATA[" + loanAmtBcHdr + "]]></net_amt__bc>");
                stringBuffer.append("<sundry_type><![CDATA[L]]></sundry_type>");
                stringBuffer.append("</Detail1>");
                stringBuffer.append("<Detail2 dbID=\"\" domID='1' objName=\"misc_rcp\" objContext=\"2\">");
                stringBuffer.append("<attribute pkNames=\"\" selected=\"N\" updateFlag=\"A\" status=\"N\" />");
                stringBuffer.append("<tran_id/>");
                stringBuffer.append("<line_no>1</line_no>");
                stringBuffer.append("<acct_code><![CDATA[" + acctCodePay + "]]></acct_code>");
                stringBuffer.append("<sundry_code><![CDATA[" + loanPartyhdr + "]]></sundry_code>");
                stringBuffer.append("<sundry_type><![CDATA[L]]></sundry_type>");
                stringBuffer.append("<cctr_code><![CDATA[" + cctrCodePay + "]]></cctr_code>");
                stringBuffer.append("<amount><![CDATA[" + loanAmthdr + "]]></amount>");
                stringBuffer.append("</Detail2>");
                stringBuffer.append("</Header0>");
                stringBuffer.append("</group0>");
                stringBuffer.append("</DocumentRoot>");
                errString = this.saveData(xtraParams, siteCodehdr, stringBuffer.toString(), conn);
                if (errString.indexOf("Success") == -1) {
                    String string2 = errString;
                    return string2;
                }
                String[] arrayForTranId = errString.split("<TranID>");
                tranIdRcp = arrayForTranId[1].substring(0, endIndex = arrayForTranId[1].indexOf("</TranID>"));
                if (tranIdRcp != null && tranIdRcp.trim().length() > 0) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tran_id [" + tranIdRcp + "]"));
                    errString = null;
                }
                if ((errString = miscRcpConf.confirm(tranIdRcp, tranIdRcp, xtraParams, forcedFlag, conn)).indexOf("VTSUCC1") == -1) {
                    String string3 = errString;
                    return string3;
                }
                miscPayUpd.put("tran_ser", "LN-VCH");
                miscPayUpd.put("ref_no", tranId);
                miscPayUpd.put("tran_date", tranDate);
                miscPayUpd.put("bill_no", " ");
                miscPayUpd.put("curr_code", currCode);
                miscPayUpd.put("exch_rate", exchRate);
                miscPayUpd.put("sundry_type", "L");
                miscPayUpd.put("sundry_code", loanPartyhdr);
                miscPayUpd.put("acct_code", acctCodePay);
                miscPayUpd.put("cctr_code", cctrCodePay);
                miscPayUpd.put("due_date", this.getDueDate(tranDatehdr, loanTenureUnit, loanTenure));
                miscPayUpd.put("site_code", siteCodehdr);
                miscPayUpd.put("tot_amt", loanAmthdr);
                miscPayUpd.put("bank_code", bankCode);
                miscPayUpd.put("auto_pay", "N");
                miscPayUpd.put("pay_mode", "T");
                miscPayUpd.put("paid", "N");
                miscPayUpd.put("fin_entity", finEnt);
                miscPayUpd.put("adv_amt", 0);
                miscPayUpd.put("hold_amt", 0);
                errString = Fcommon.gbfMiscPayUpd(miscPayUpd, conn);
                if (errString != null && errString.trim().length() > 0) {
                    String string4 = errString;
                    return string4;
                }
            } else {
                for (HashMap hashMap : loanDetList) {
                    sql = "Update misc_payables set adj_amt = ?, status = 'A' where ref_no = ? and tran_ser= ?  ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setDouble(1, (Double)hashMap.get("AMOUNT_PAID"));
                    pstmt.setString(2, hashMap.get("REF_NO").toString());
                    pstmt.setString(3, hashMap.get("REF_SER").toString());
                    pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                    miscPayUpd.put("tran_ser", "LN-VC1");
                    miscPayUpd.put("tran_date", tranDatehdr);
                    miscPayUpd.put("ref_no", tranId);
                    miscPayUpd.put("bill_no", " ");
                    miscPayUpd.put("curr_code", hashMap.get("CURR_CODE"));
                    miscPayUpd.put("exch_rate", hashMap.get("EXCH_RATE"));
                    miscPayUpd.put("sundry_type", hashMap.get("SUNDRY_TYPE"));
                    miscPayUpd.put("sundry_code", hashMap.get("SUNDRY_CODE"));
                    miscPayUpd.put("acct_code", hashMap.get("ACCT_CODE"));
                    miscPayUpd.put("cctr_code", hashMap.get("CCTR_CODE"));
                    miscPayUpd.put("due_date", this.getDueDate(tranDatehdr, loanTenureUnit, loanTenure));
                    miscPayUpd.put("site_code", siteCodehdr);
                    miscPayUpd.put("tot_amt", -((Double)hashMap.get("AMOUNT_PAID")).doubleValue());
                    miscPayUpd.put("fin_entity", finEnt);
                    miscPayUpd.put("bank_code", bankCode);
                    miscPayUpd.put("auto_pay", "N");
                    miscPayUpd.put("pay_mode", "T");
                    miscPayUpd.put("paid", "N");
                    miscPayUpd.put("adj_amt", -((Double)hashMap.get("AMOUNT_PAID")).doubleValue());
                    miscPayUpd.put("hold_amt", 0);
                    miscPayUpd.put("adv_amt", 0);
                    errString = this.gbfMiscPayUpd(miscPayUpd, conn);
                    if (errString != null && errString.trim().length() > 0) {
                        String string5 = errString;
                        return string5;
                    }
                    glTraceUpd.put("tran_date", tranDatehdr);
                    glTraceUpd.put("eff_date", tranDatehdr);
                    glTraceUpd.put("fin_entity", finEnt);
                    glTraceUpd.put("site_code", siteCodehdr);
                    glTraceUpd.put("sundry_type", hashMap.get("SUNDRY_TYPE"));
                    glTraceUpd.put("sundry_code", hashMap.get("SUNDRY_CODE"));
                    glTraceUpd.put("acct_code", hashMap.get("ACCT_CODE"));
                    glTraceUpd.put("cctr_code", hashMap.get("CCTR_CODE"));
                    glTraceUpd.put("curr_code", hashMap.get("CURR_CODE"));
                    glTraceUpd.put("exch_rate", hashMap.get("EXCH_RATE"));
                    glTraceUpd.put("dr_amt", hashMap.get("AMOUNT_PAID"));
                    glTraceUpd.put("cr_amt", 0.0);
                    glTraceUpd.put("ref_ser", "LN-VCH");
                    glTraceUpd.put("ref_id", tranId);
                    errString = Fcommon.glTraceUpdate(glTraceUpd, conn);
                    if (errString != null && errString.trim().length() > 0) {
                        String string6 = errString;
                        return string6;
                    }
                    sundryBalUpd.put("tran_date", tranDatehdr);
                    sundryBalUpd.put("fin_entity", finEnt);
                    sundryBalUpd.put("site_code", siteCodehdr);
                    sundryBalUpd.put("sundry_type", hashMap.get("SUNDRY_TYPE"));
                    sundryBalUpd.put("sundry_code", hashMap.get("SUNDRY_CODE"));
                    sundryBalUpd.put("acct_code", hashMap.get("ACCT_CODE"));
                    sundryBalUpd.put("cctr_code", hashMap.get("CCTR_CODE"));
                    sundryBalUpd.put("curr_code", hashMap.get("CURR_CODE"));
                    sundryBalUpd.put("exch_rate", hashMap.get("EXCH_RATE"));
                    sundryBalUpd.put("dr_amt", hashMap.get("AMOUNT_PAID"));
                    sundryBalUpd.put("cr_amt", 0.0);
                    sundryBalUpd.put("adv_amt", 0.0);
                    errString = Fcommon.gbf_sundrybal_upd(sundryBalUpd, conn);
                    if (errString == null || errString.trim().length() <= 0) continue;
                    String string7 = errString;
                    return string7;
                }
                miscPayUpd.put("tran_ser", "LN-VCH");
                miscPayUpd.put("tran_date", tranDatehdr);
                miscPayUpd.put("ref_no", tranId);
                miscPayUpd.put("bill_no", " ");
                miscPayUpd.put("curr_code", currCode);
                miscPayUpd.put("exch_rate", exchRate);
                miscPayUpd.put("sundry_type", "L");
                miscPayUpd.put("sundry_code", loanPartyhdr);
                miscPayUpd.put("acct_code", acctCodePay);
                miscPayUpd.put("cctr_code", cctrCodePay);
                miscPayUpd.put("due_date", this.getDueDate(tranDatehdr, loanTenureUnit, loanTenure));
                miscPayUpd.put("site_code", siteCodehdr);
                miscPayUpd.put("tot_amt", loanAmthdr);
                miscPayUpd.put("bank_code", bankCode);
                miscPayUpd.put("auto_pay", "N");
                miscPayUpd.put("pay_mode", "T");
                miscPayUpd.put("paid", "N");
                miscPayUpd.put("adv_amt", 0);
                miscPayUpd.put("fin_entity", finEnt);
                miscPayUpd.put("hold_amt", 0);
                errString = Fcommon.gbfMiscPayUpd(miscPayUpd, conn);
                if (errString != null && errString.trim().length() > 0) {
                    String string8 = errString;
                    return string8;
                }
                glTraceUpd.put("tran_date", tranDatehdr);
                glTraceUpd.put("eff_date", tranDatehdr);
                glTraceUpd.put("fin_entity", finEnt);
                glTraceUpd.put("site_code", siteCodehdr);
                glTraceUpd.put("sundry_type", "L");
                glTraceUpd.put("sundry_code", loanPartyhdr);
                glTraceUpd.put("acct_code", acctCodePay);
                glTraceUpd.put("cctr_code", cctrCodePay);
                glTraceUpd.put("curr_code", currCode);
                glTraceUpd.put("exch_rate", exchRate);
                glTraceUpd.put("dr_amt", 0.0);
                glTraceUpd.put("cr_amt", loanAmthdr);
                glTraceUpd.put("ref_id", tranId);
                glTraceUpd.put("ref_ser", "LN-VCH");
                errString = Fcommon.glTraceUpdate(glTraceUpd, conn);
                if (errString != null && errString.trim().length() > 0) {
                    String string9 = errString;
                    return string9;
                }
                if (diffAmtExch != 0.0) {
                    glTraceMap.put("tran_date", tranDatehdr);
                    glTraceMap.put("eff_date", tranDatehdr);
                    glTraceMap.put("fin_entity", finEnt);
                    glTraceMap.put("site_code", siteCodehdr);
                    glTraceMap.put("sundry_type", "O");
                    glTraceMap.put("sundry_code", loanPartyhdr);
                    glTraceMap.put("acct_code", acctCodeCF);
                    if (acctCodeCF == null || acctCodeCF.trim().length() == 0) {
                        glTraceMap.put("cctr_code", cctrCodePay);
                    } else {
                        glTraceMap.put("cctr_code", cctrCodeCF);
                    }
                    glTraceMap.put("emp_code", "");
                    glTraceMap.put("anal_code", "");
                    glTraceMap.put("curr_code", basecurrCode);
                    glTraceMap.put("exch_rate", 1.0);
                    if (diffAmtExch > 0.0) {
                        glTraceMap.put("dr_amt", diffAmtExch);
                        glTraceMap.put("cr_amt", 0);
                    } else {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", -1.0 * diffAmtExch);
                    }
                    glTraceMap.put("ref_ser", "LN-VCH");
                    glTraceMap.put("ref_id", tranId);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"1938 glTraceUpdate Called..............");
                    errString = Fcommon.glTraceUpdate(glTraceMap, conn);
                    if (errString != null && errString.trim().length() > 0) {
                        String string10 = errString;
                        return string10;
                    }
                }
                sundryBalUpd.put("tran_date", tranDatehdr);
                sundryBalUpd.put("fin_entity", finEnt);
                sundryBalUpd.put("site_code", siteCodehdr);
                sundryBalUpd.put("sundry_type", "L");
                sundryBalUpd.put("sundry_code", loanPartyhdr);
                sundryBalUpd.put("acct_code", acctCodePay);
                sundryBalUpd.put("cctr_code", cctrCodePay);
                sundryBalUpd.put("curr_code", currCode);
                sundryBalUpd.put("exch_rate", exchRate);
                sundryBalUpd.put("dr_amt", 0.0);
                sundryBalUpd.put("cr_amt", loanAmthdr);
                sundryBalUpd.put("adv_amt", 0.0);
                errString = Fcommon.gbf_sundrybal_upd(sundryBalUpd, conn);
                if (errString != null && errString.trim().length() > 0) {
                    String string11 = errString;
                    return string11;
                }
            }
            try {
                if (errString == null || errString.trim().length() == 0) {
                    sql = "Update loan_hdr set confirmed = 'Y',conf_date = ?, emp_code__aprv = ? where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setTimestamp(1, tranDate);
                    pstmt.setString(2, string);
                    pstmt.setString(3, tranId);
                    pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                try {
                    conn.rollback();
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"connection rollback");
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :loanConfirm :loanConfirmmethod :==>" + e.getMessage()));
                errString = this.genericUtility.createErrorString(e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rsInner != null) {
                    rsInner.close();
                    rsInner = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmtInner != null) {
                    pstmtInner.close();
                    pstmtInner = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String saveData(String xtraParams, String siteCode, String xmlString, Connection conn) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"saving data...........");
        InitialContext ctx = null;
        String retString = null;
        String userId = "";
        MasterStatefulLocal masterStateful = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        UserInfoBean userInfoBean = new UserInfoBean();
        try {
            userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("userId" + userId + "]"));
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
            masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("-----------masterStateful------- " + masterStateful));
            String[] authencate = new String[]{userId, ""};
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("xmlString to masterstateful [" + xmlString + "]"));
            userInfoBean.setEmpCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
            userInfoBean.setRemoteHost(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
            userInfoBean.setSiteCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
            userInfoBean.setLoginCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
            userInfoBean.setEntityCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
            retString = masterStateful.processRequest(authencate, siteCode, true, xmlString, true, conn);
        }
        catch (ITMException itme) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"ITMException :CreateDistOrder :saveData :==>");
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Exception :CreateDistOrder :saveData :==>");
            throw new ITMException(e);
        }
        return retString;
    }

    public String confirmReceipt(String businessObj, String tranIdFr, String xtraParams, String forcedFlag, Connection conn) throws ITMException {
        String methodName = "";
        String compName = "";
        String retString = "";
        String serviceCode = "";
        String serviceURI = "";
        String actionURI = "";
        String sql = "";
        Statement pStmt = null;
        ResultSet rs = null;
        boolean cnt = false;
        try {
            try {
                methodName = "gbf_post";
                actionURI = "http://NvoServiceurl.org/" + methodName;
                forcedFlag = "";
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("forcedFlag Method[" + forcedFlag + "]"));
                sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
                pStmt = conn.prepareStatement(sql);
                pStmt.setString(1, businessObj);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    serviceCode = rs.getString("SERVICE_CODE");
                    compName = rs.getString("COMP_NAME");
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
                pStmt = conn.prepareStatement(sql);
                pStmt.setString(1, serviceCode);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    serviceURI = rs.getString("SERVICE_URI");
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("SERVICE_URI[" + serviceURI + "]"));
                Service service = new Service();
                Call call = (Call)service.createCall();
                call.setTargetEndpointAddress(new URL(serviceURI));
                call.setOperationName(new QName("http://NvoServiceurl.org", methodName));
                call.setUseSOAPAction(true);
                call.setSOAPActionURI(actionURI);
                Object[] aobj = new Object[4];
                call.addParameter(new QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter(new QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter(new QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter(new QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);
                aobj[0] = new String(compName);
                aobj[1] = new String(tranIdFr);
                aobj[2] = new String(xtraParams);
                aobj[3] = new String(forcedFlag);
                call.setReturnType(XMLType.XSD_STRING);
                retString = (String)call.invoke(aobj);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Return string from NVO is:==>[" + retString + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
        }
        return retString;
    }

    public Timestamp getDueDate(Timestamp today, String tenureUnit, int tenure) throws ITMException {
        Timestamp dueDate = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)dateFormat.format(today));
            Calendar c = Calendar.getInstance();
            c.setTime(today);
            if ("0".equalsIgnoreCase(tenureUnit.trim())) {
                c.add(5, tenure);
            } else if ("1".equalsIgnoreCase(tenureUnit.trim())) {
                c.add(2, tenure);
            } else {
                c.add(1, tenure);
            }
            Date d1 = c.getTime();
            dueDate = new Timestamp(d1.getTime());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)dateFormat.format(dueDate));
        }
        catch (Exception e) {
            e.getMessage();
            e.printStackTrace();
            throw new ITMException(e);
        }
        return dueDate;
    }

    public String gbfMiscPayUpd(HashMap miscPayMap, Connection conn) throws ITMException {
        Statement pstmt = null;
        Statement pstmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        String sql = "";
        String sql1 = "";
        String errString = "";
        ITMDBAccessEJB itmDBAccessEJB = null;
        FinCommon Fcommon = new FinCommon();
        Timestamp tranDate = null;
        Timestamp refDate = null;
        Timestamp billDate = null;
        Timestamp dueDate = null;
        String tranSer = null;
        String refNo = null;
        String billNo = null;
        String currCode = null;
        String sundryType = null;
        String sundryCode = null;
        String acctCode = null;
        String cctrCode = null;
        String siteCode = null;
        String finEntity = null;
        String bankCode = null;
        String autoPay = null;
        String payMode = null;
        String paid = null;
        String batch = null;
        String keyStr = null;
        String thisWin = null;
        String payblsTranID = null;
        String refSerOrg = null;
        String suppAmt = null;
        String tdsStr = null;
        double exchRate = 0.0;
        double totAmt = 0.0;
        double advAmt = 0.0;
        double holdAmt = 0.0;
        double suppBillAmt = 0.0;
        double tdsAmt = 0.0;
        double adjAmt = 0.0;
        SimpleDateFormat sdf = null;
        try {
            block30: {
                sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
                itmDBAccessEJB = new ITMDBAccessEJB();
                tranSer = miscPayMap.get("tran_ser") == null ? "" : miscPayMap.get("tran_ser").toString();
                tranDate = (Timestamp)miscPayMap.get("tran_date");
                refNo = miscPayMap.get("ref_no") == null ? "" : miscPayMap.get("ref_no").toString();
                refDate = (Timestamp)miscPayMap.get("ref_date");
                billNo = miscPayMap.get("bill_no") == null ? "" : miscPayMap.get("bill_no").toString();
                billDate = (Timestamp)miscPayMap.get("bill_date");
                currCode = miscPayMap.get("curr_code") == null ? "" : miscPayMap.get("curr_code").toString();
                exchRate = Double.parseDouble(miscPayMap.get("exch_rate").toString());
                sundryType = miscPayMap.get("sundry_type") == null ? "" : miscPayMap.get("sundry_type").toString();
                sundryCode = miscPayMap.get("sundry_code") == null ? "" : miscPayMap.get("sundry_code").toString();
                acctCode = miscPayMap.get("acct_code") == null ? "" : miscPayMap.get("acct_code").toString();
                cctrCode = miscPayMap.get("cctr_code") == null ? "" : miscPayMap.get("cctr_code").toString();
                dueDate = (Timestamp)miscPayMap.get("due_date");
                siteCode = miscPayMap.get("site_code") == null ? "" : miscPayMap.get("site_code").toString();
                finEntity = miscPayMap.get("fin_entity") == null ? "" : miscPayMap.get("fin_entity").toString();
                totAmt = Double.parseDouble(miscPayMap.get("tot_amt").toString());
                adjAmt = Double.parseDouble(miscPayMap.get("adj_amt").toString());
                bankCode = miscPayMap.get("bank_code") == null ? "" : miscPayMap.get("bank_code").toString();
                autoPay = miscPayMap.get("auto_pay") == null ? "" : miscPayMap.get("auto_pay").toString();
                payMode = miscPayMap.get("pay_mode") == null ? "" : miscPayMap.get("pay_mode").toString();
                paid = miscPayMap.get("paid") == null ? "" : miscPayMap.get("paid").toString();
                advAmt = Double.parseDouble(miscPayMap.get("adv_amt").toString());
                batch = miscPayMap.get("entry_batch_no") == null ? "" : miscPayMap.get("entry_batch_no").toString();
                holdAmt = Double.parseDouble(miscPayMap.get("hold_amt").toString());
                suppAmt = (String)miscPayMap.get("supp_bill_amt");
                tdsStr = (String)miscPayMap.get("tds_amt");
                suppBillAmt = suppAmt == null || suppAmt.trim().length() == 0 ? 0.0 : Double.parseDouble(suppAmt);
                tdsAmt = tdsStr == null || tdsStr.trim().length() == 0 ? 0.0 : Double.parseDouble(tdsStr);
                String string = refSerOrg = miscPayMap.get("ref_ser__org") == null ? "" : miscPayMap.get("ref_ser__org").toString();
                if (batch == null || batch.trim().length() == 0) {
                    batch = " ";
                }
                if (cctrCode == null || cctrCode.trim().length() == 0) {
                    cctrCode = " ";
                }
                thisWin = "T_PAYABLES";
                sql = " select key_string from transetup where upper(tran_window) = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, thisWin);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    keyStr = rs.getString(1);
                } else {
                    thisWin = "GENERAL";
                    sql1 = " select key_string  from transetup where upper(tran_window) = ? ";
                    pstmt1 = conn.prepareStatement(sql1);
                    pstmt1.setString(1, thisWin);
                    rs1 = pstmt1.executeQuery();
                    if (rs1.next()) {
                        keyStr = rs1.getString(1);
                    }
                    rs1.close();
                    rs1 = null;
                    pstmt1.close();
                    pstmt1 = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("keyStr :::" + keyStr));
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                String xmlString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>\r\n</header><Detail1><item_ser></item_ser>\r\n<site_code>" + siteCode + "</site_code>\r\n<tran_date>" + sdf.format(new Date(tranDate.getTime())) + "</tran_date></Detail1></Root>";
                TransIDGenerator tg = new TransIDGenerator(xmlString, "SYSTEM", CommonConstants.DB_NAME);
                payblsTranID = tg.generateTranSeqID("PAYL", "tran_id", keyStr, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Transaction Id Generated for Payables :" + payblsTranID));
                try {
                    sql = "INSERT INTO MISC_PAYABLES (TRAN_ID,TRAN_SER,TRAN_DATE,REF_NO,REF_DATE,CURR_CODE,EXCH_RATE,SUNDRY_TYPE,SUNDRY_CODE,ACCT_CODE,CCTR_CODE,DUE_DATE,FIN_ENTITY,SITE_CODE,BILL_NO,BILL_DATE,TOT_AMT,ADJ_AMT,STATUS,STATUS_DATE,BANK_CODE,AUTO_PAY,PAY_MODE,PAID,ADV_AMT,HOLD_AMT,PURC_ORDER,ENTRY_BATCH_NO,TDS_AMT,SUPP_BILL_AMT,REF_SER__ORG) VALUES ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, payblsTranID.trim());
                    pstmt.setString(2, tranSer.trim());
                    pstmt.setTimestamp(3, tranDate);
                    pstmt.setString(4, refNo.trim());
                    pstmt.setTimestamp(5, refDate);
                    pstmt.setString(6, currCode.trim());
                    pstmt.setDouble(7, exchRate);
                    pstmt.setString(8, sundryType.trim());
                    pstmt.setString(9, sundryCode.trim());
                    pstmt.setString(10, acctCode.trim());
                    pstmt.setString(11, cctrCode);
                    pstmt.setTimestamp(12, dueDate);
                    pstmt.setString(13, finEntity.trim());
                    pstmt.setString(14, siteCode.trim());
                    pstmt.setString(15, billNo);
                    pstmt.setTimestamp(16, billDate);
                    pstmt.setDouble(17, totAmt);
                    pstmt.setDouble(18, adjAmt);
                    pstmt.setString(19, "A");
                    pstmt.setTimestamp(20, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(21, bankCode.trim());
                    pstmt.setString(22, autoPay.trim());
                    pstmt.setString(23, payMode);
                    pstmt.setString(24, paid);
                    pstmt.setDouble(25, advAmt);
                    pstmt.setDouble(26, holdAmt);
                    pstmt.setString(27, (String)miscPayMap.get("purc_order"));
                    pstmt.setString(28, batch);
                    pstmt.setDouble(29, tdsAmt);
                    pstmt.setDouble(30, suppBillAmt);
                    pstmt.setString(31, refSerOrg);
                    int count = pstmt.executeUpdate();
                    if (count >= 1) break block30;
                    String string2 = errString = itmDBAccessEJB.getErrorString("", "VMMISCPAY", "", "", conn);
                    return string2;
                }
                catch (SQLException se) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("SQLException []:gbfMiscPayUpd()[Excuting Query Failed]" + sql + se.getMessage()));
                    se.printStackTrace();
                    String string3 = errString = Fcommon.getErrorMessage(se, "");
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (rs1 != null) {
                            rs1.close();
                            rs1 = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (pstmt1 != null) {
                            pstmt1.close();
                            pstmt1 = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return string3;
                }
            }
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in checkGlTranDrCr [FinCommon]" + e));
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                    pstmt1 = null;
                }
            }
            catch (Exception exception) {}
        }
        return errString;
    }
}

