/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.FundTransferConfLocal;
import ibase.webitm.ejb.fin.adv.FundTransferConfRemote;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.ejb.Stateless;
import org.w3c.dom.Document;

@Stateless
public class FundTransferConf
extends ActionHandlerEJB
implements FundTransferConfLocal,
FundTransferConfRemote {
    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        boolean isConn = false;
        Connection conn = null;
        boolean isPreview = false;
        E12GenericUtility genericUtility = new E12GenericUtility();
        String errString = "";
        try {
            errString = this.confirm(tranId, xtraParams, forcedFlag, conn);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in confirm() ==>" + e.getMessage()));
            errString = genericUtility.createErrorString(e);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString in cofirm() ==>" + errString));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        String retString = "";
        boolean isConn = false;
        boolean isPreview = false;
        boolean isLocalConn = false;
        String sql = "";
        String confirm = "";
        String siteCodeFrom = "";
        String errString = "";
        boolean isError = false;
        Statement pstmt = null;
        ResultSet rs = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        ITMDBAccessEJB itmDBAccessEJB = null;
        ValidatorEJB validatorEJB = null;
        boolean connStatus = false;
        String loginEmpCode = "";
        try {
            itmDBAccessEJB = new ITMDBAccessEJB();
            validatorEJB = new ValidatorEJB();
            loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Printing loginEmpCode---1-----" + loginEmpCode + "--"));
            if (conn == null) {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                conn = this.getConnection();
                conn.setAutoCommit(false);
                connDriver = null;
                connStatus = true;
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 1.3 monika 20-May-2021  retstring tranmId [" + tranId + "]"));
            sql = CommonConstants.DB_NAME.equalsIgnoreCase("DB2") ? " select status,site_code__from  from fundtransfer  where tran_id = ? for update " : (CommonConstants.DB_NAME.equalsIgnoreCase("MSSQL") ? " select status,site_code__from from fundtransfer   (updlock)  where tran_id = ? " : " select status,site_code__from from fundtransfer   where tran_id = ? for update nowait ");
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                confirm = rs.getString("status");
                siteCodeFrom = rs.getString("site_code__from");
                isError = true;
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (!isError) {
                errString = itmDBAccessEJB.getErrorString("", "VTLCKERR", "", "", conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 1.3 monika 20-May-2021  else  errString retstring confirm [" + errString + "]"));
                String string = errString;
                return string;
            }
            if (confirm != null && "E".equalsIgnoreCase(confirm)) {
                errString = this.gbfRetrieveFundtransfer(tranId, siteCodeFrom, xtraParams, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 1.4 monika 20-May-2021  else  errString retstring confirm [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                sql = "update fundtransfer set status = ?, status_date = ?, emp_code__aprv = ?,tran_id__ref=? where tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, "C");
                pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(3, loginEmpCode);
                pstmt.setString(4, tranId);
                pstmt.setString(5, tranId);
                int updCnt = pstmt.executeUpdate();
                if (updCnt <= 0) {
                    String string = errString = itmDBAccessEJB.getErrorString("", "DS000NR", "", "", conn);
                    return string;
                }
                errString = itmDBAccessEJB.getErrorString("", "VTCICONF3", "", "", conn);
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            } else if (confirm != null && "C".equalsIgnoreCase(confirm)) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                errString = itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 1.5 monika 20-May-2021  else  errString retstring confirm [" + errString + "]"));
                String string = errString;
                return string;
            }
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Error String from confirm method.....[" + errString + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception ::" + e.getMessage()));
                errString = genericUtility.createErrorString(e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Exception while rollbacking222.......");
                }
                throw new ITMException(e);
            }
        }
        finally {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY MiscValConf confirm MATHOD333@#......>>[" + connStatus + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY MiscValConf confirm errString@#......>>[" + errString + "]"));
            try {
                if (errString != null && errString.trim().length() > 0) {
                    if (errString.indexOf("VTCICONF3") > -1) {
                        if (connStatus) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Transaction commited111.............from DrCrPayConf");
                            conn.commit();
                        }
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollbacking......................................");
                        conn.rollback();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollback......................................");
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connStatus) {
                    conn.close();
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    public String gbfRetrieveFundtransfer(String tranId, String siteCodeFrom, String xtraParams, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfRetrieveFundtransfer called........");
        String sql = "";
        String confirm = "";
        String siteCode = "";
        String errString = "";
        String loginEmpCode = "";
        Statement pstmt = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        Object validatorEJB = null;
        boolean isError = false;
        boolean isLocalConn = false;
        String chgUser = "";
        String tranType = "";
        double chqAmount = 0.0;
        double netAmt = 0.0;
        double taxAmt = 0.0;
        Timestamp today = null;
        String userId = "";
        HashMap<String, Object> fundtranferHdrMap = null;
        ArrayList fundtranferHdrList = new ArrayList();
        E12GenericUtility genericUtility = null;
        try {
            finCommon = new FinCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            genericUtility = new E12GenericUtility();
            today = new Timestamp(System.currentTimeMillis());
            userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            today = new Timestamp(System.currentTimeMillis());
            if (loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                String string = errString = itmDBAccessEJB.getErrorString("", "EMPAPRV", userId, "", conn);
                return string;
            }
            sql = CommonConstants.DB_NAME.equalsIgnoreCase("DB2") ? "select tran_id from fundtransfer  where tran_id = ? and  status = 'E' ORDER BY tran_id ASC for update " : (CommonConstants.DB_NAME.equalsIgnoreCase("MSSQL") ? "select tran_id from fundtransfer  (updlock)  where  tran_id = ? and  status = 'E' ORDER BY tran_id ASC" : "select tran_id from  fundtransfer   where tran_id = ?  and  status = 'E' ORDER BY tran_id ASC for update nowait ");
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                String string = errString = itmDBAccessEJB.getErrorString("", "VTLCKERR", "", "", conn);
                return string;
            }
            tranId = rs.getString("tran_id");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranId --[" + tranId));
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            sql = " select tran_id, tran_date,tran_type,eff_date,bank_code__from,bank_code__to,fin_entity__from,fin_entity__to,xfr_mode,ref_no, ref_date,amount,curr_code, exch_rate, acct_code__from,  acct_code__to, cctr_code__from,cctr_code__to,bank_charges,acct_code__bc,cctr_code__bc,curr_code__bc,exch_rate__bc,ac_no__from,ac_no__to,status,status_date,remarks,  anal_code, ie_xfr ,acct_code__iep, cctr_code__iep,acct_code__ier,cctr_code__ier, chg_date,chg_user,chg_term, tran_id__ref, emp_code,add_date,add_user,add_term ,  emp_code__aprv, site_Code__from,  site_code__to, link_type, chq_name, entry_batch_no, cons_yn, tran_id__cons ,tax_amt,tax_class,tax_chap,tax_env,net_amt,tran_id__dish,tran_mode,tran_id__rcp from  fundtransfer  where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                fundtranferHdrMap = new HashMap<String, Object>();
                fundtranferHdrMap.put("tran_id", rs.getString("tran_id"));
                fundtranferHdrMap.put("tran_date", rs.getTimestamp("tran_date"));
                fundtranferHdrMap.put("tran_type", rs.getString("tran_type"));
                fundtranferHdrMap.put("eff_date", rs.getTimestamp("eff_date"));
                fundtranferHdrMap.put("bank_code__from", rs.getString("bank_code__from"));
                fundtranferHdrMap.put("bank_code__to", rs.getString("bank_code__to"));
                fundtranferHdrMap.put("fin_entity__from", rs.getString("fin_entity__from"));
                fundtranferHdrMap.put("fin_entity__to", rs.getString("fin_entity__to"));
                fundtranferHdrMap.put("xfr_mode", rs.getString("xfr_mode"));
                fundtranferHdrMap.put("ref_no", rs.getString("ref_no"));
                fundtranferHdrMap.put("ref_date", rs.getTimestamp("ref_date"));
                fundtranferHdrMap.put("amount", rs.getDouble("amount"));
                fundtranferHdrMap.put("curr_code", rs.getString("curr_code"));
                fundtranferHdrMap.put("exch_rate", rs.getDouble("exch_rate"));
                fundtranferHdrMap.put("acct_code__from", rs.getString("acct_code__from"));
                fundtranferHdrMap.put("acct_code__to", rs.getString("acct_code__to"));
                fundtranferHdrMap.put("cctr_code__from", rs.getString("cctr_code__from"));
                fundtranferHdrMap.put("cctr_code__to", rs.getString("cctr_code__to"));
                fundtranferHdrMap.put("bank_charges", rs.getDouble("bank_charges"));
                fundtranferHdrMap.put("acct_code__bc", rs.getString("acct_code__bc"));
                fundtranferHdrMap.put("cctr_code__bc", rs.getString("cctr_code__bc"));
                fundtranferHdrMap.put("curr_code__bc", rs.getString("curr_code__bc"));
                fundtranferHdrMap.put("exch_rate__bc", rs.getDouble("exch_rate__bc"));
                fundtranferHdrMap.put("ac_no__from", rs.getString("ac_no__from"));
                fundtranferHdrMap.put("ac_no__to", rs.getString("ac_no__to"));
                fundtranferHdrMap.put("status", rs.getString("status"));
                fundtranferHdrMap.put("status_date", rs.getTimestamp("status_date"));
                fundtranferHdrMap.put("remarks", rs.getString("remarks"));
                fundtranferHdrMap.put("anal_code", rs.getString("anal_code"));
                fundtranferHdrMap.put("ie_xfr", rs.getString("ie_xfr"));
                fundtranferHdrMap.put("acct_code__iep", rs.getString("acct_code__iep"));
                fundtranferHdrMap.put("cctr_code__iep", rs.getString("cctr_code__iep"));
                fundtranferHdrMap.put("acct_code__ier", rs.getString("acct_code__ier"));
                fundtranferHdrMap.put("cctr_code__ier", rs.getString("cctr_code__ier"));
                fundtranferHdrMap.put("chg_date", rs.getTimestamp("chg_date"));
                fundtranferHdrMap.put("chg_user", rs.getString("chg_user"));
                fundtranferHdrMap.put("chg_term", rs.getString("chg_term"));
                fundtranferHdrMap.put("tran_id__ref", rs.getString("tran_id__ref"));
                fundtranferHdrMap.put("emp_code", rs.getString("emp_code"));
                fundtranferHdrMap.put("chg_date", rs.getTimestamp("add_date"));
                fundtranferHdrMap.put("chg_user", rs.getString("add_user"));
                fundtranferHdrMap.put("chg_term", rs.getString("add_term"));
                fundtranferHdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
                fundtranferHdrMap.put("site_code__from", rs.getString("site_code__from"));
                fundtranferHdrMap.put("site_code__to", rs.getString("site_code__to"));
                fundtranferHdrMap.put("link_type", rs.getString("link_type"));
                fundtranferHdrMap.put("chq_name", rs.getString("chq_name"));
                fundtranferHdrMap.put("entry_batch_no", rs.getString("entry_batch_no"));
                fundtranferHdrMap.put("cons_yn", rs.getString("cons_yn"));
                fundtranferHdrMap.put("tran_id__cons", rs.getString("tran_id__cons"));
                fundtranferHdrMap.put("tax_amt", rs.getDouble("tax_amt"));
                fundtranferHdrMap.put("tax_class", rs.getString("tax_class"));
                fundtranferHdrMap.put("tax_chap", rs.getString("tax_chap"));
                fundtranferHdrMap.put("tax_env", rs.getString("tax_env"));
                fundtranferHdrMap.put("net_amt", rs.getDouble("net_amt"));
                fundtranferHdrMap.put("tran_id__dish", rs.getString("tran_id__dish"));
                fundtranferHdrMap.put("tran_mode", rs.getString("tran_mode"));
                fundtranferHdrMap.put("cons_yn", rs.getString("cons_yn"));
                fundtranferHdrMap.put("tran_id__rcp", rs.getString("tran_id__rcp"));
                fundtranferHdrList.add(fundtranferHdrMap);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 1 monika 20-May-2021  fundtranferHdrMap [" + fundtranferHdrMap.toString() + "]"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)fundtranferHdrMap.toString());
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 2 monika 20-May-2021  fundtranferHdrList [" + fundtranferHdrList.toString() + "]"));
            errString = this.gbfPostFundtransfer(tranId, fundtranferHdrMap, xtraParams, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 3 monika 20-May-2021  gbfPostFundtransfer [" + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            try {
                pstmt.close();
                pstmt = null;
                rs.close();
                rs = null;
            }
            catch (Exception e) {
                errString = "ERROR";
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String gbfPostFundtransfer(String tranId, HashMap fundtranferHdrMap, String xtraParams, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"gbfPostFundtransfer called........");
        String errString = "";
        String currCode = "";
        String siteCode = "";
        String finEntity = "";
        String remarks = "";
        String empCode = "";
        String refNO = "";
        String rcpMode = "";
        String batchNo = "";
        String tranType = "";
        String confirm = "";
        String loginEmpCode = "";
        String winName = "";
        String editOption = "";
        String confirmed = "";
        String sql = "";
        String errorType = "";
        String acctCodeBal = "";
        String cctrCodeBal = "";
        String refSer = "";
        String refNo = "";
        String finEntityFrom = "";
        String finEntityTo = "";
        String siteCodeFrom = "";
        String siteCodeTo = "";
        String bankCodeFrom = "";
        String bankCodeTo = "";
        String xfrMode = "";
        String acctCodeFrom = "";
        String acctCodeTo = "";
        String cctrCodeFrom = "";
        String cctrCodeTo = "";
        String acctCodeBc = "";
        String cctrCodeBc = "";
        String currCodeBc = "";
        String acNoFrom = "";
        String acNoTo = "";
        String status = "";
        String iexfr = "";
        String chgTermstr = "";
        String acctcodeiep = "";
        String cctrcodeiep = "";
        String acctcodeier = "";
        String cctrcodeier = "";
        String tranIdHdr = "";
        String tranMode = "";
        String linkType = "";
        String consYN = "";
        String analCode = "";
        String tranidRef = "";
        String tranIdDish = "";
        String empCodeAprv = "";
        String taxcctrCode = "";
        String taxacctCode = "";
        String taxRecoAcct = "";
        String taxRecoCctr = "";
        String retString = "";
        String acctCodeReco = "";
        String cctrCodeReco = "";
        String postOnline = "";
        String tranIdCol = "";
        String keyString = "";
        String loginSite = "";
        String xmlValues = "";
        String dataStr = "";
        String userId = "";
        String currDateStr = "";
        String chgUser = "";
        String chgTerm = "";
        String addUser = "";
        String addTerm = "";
        String tranIdRcp = "";
        String entryBatchNo = "";
        String ibcaConf = "";
        String ediOption = "";
        String termId = "";
        String newtranId = "";
        String xmlString = "";
        SimpleDateFormat sdf = null;
        boolean count = false;
        boolean cnt1 = false;
        boolean cnt = false;
        double exchRate = 0.0;
        double netAmount = 0.0;
        double amount = 0.0;
        double advAmt = 0.0;
        double netAmt = 0.0;
        double chqAmt = 0.0;
        double debit = 0.0;
        double credit = 0.0;
        double totAmt = 0.0;
        double netAmountBc = 0.0;
        double taxAmt = 0.0;
        double bankCharges = 0.0;
        double exchRateBc = 0.0;
        double banktranLogAmt = 0.0;
        double recoAmount = 0.0;
        double taxamount = 0.0;
        Timestamp effDate = null;
        Timestamp tranDate = null;
        Timestamp refDate = null;
        Timestamp statusDate = null;
        Object addDate = null;
        Object chgDate = null;
        Timestamp today = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        ValidatorEJB validatorEJB = new ValidatorEJB();
        ITMDBAccessEJB itmDBAccessEJB = null;
        boolean oppEff = false;
        boolean sameSite = false;
        boolean bcFlag = false;
        HashMap<String, Object> glTraceMap = null;
        HashMap<String, Object> sundryBalMap = null;
        HashMap<String, Object> bankTranLogMap = null;
        Statement pstmt = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        java.util.Date toDay = new java.util.Date();
        Timestamp tDay = null;
        try {
            String[] ary;
            String[] tokens;
            sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
            finCommon = new FinCommon();
            loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            chgTermstr = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
            today = new Timestamp(System.currentTimeMillis());
            itmDBAccessEJB = new ITMDBAccessEJB();
            userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
            chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("print fundtranferHdrMap in post method [" + fundtranferHdrMap.toString() + "]"));
            linkType = (String)fundtranferHdrMap.get("link_type");
            tranidRef = (String)fundtranferHdrMap.get("tran_id__ref");
            tranId = (String)fundtranferHdrMap.get("tran_id");
            taxAmt = Double.parseDouble(" " + fundtranferHdrMap.get("tax_amt"));
            amount = Double.parseDouble(" " + fundtranferHdrMap.get("amount"));
            netAmt = amount + taxAmt;
            tranType = (String)fundtranferHdrMap.get("tran_type");
            analCode = (String)fundtranferHdrMap.get("anal_code");
            tranDate = (Timestamp)fundtranferHdrMap.get("tran_date");
            refDate = (Timestamp)fundtranferHdrMap.get("ref_date");
            effDate = (Timestamp)fundtranferHdrMap.get("eff_date");
            remarks = (String)fundtranferHdrMap.get("remarks");
            finEntityFrom = (String)fundtranferHdrMap.get("fin_entity__from");
            finEntityTo = (String)fundtranferHdrMap.get("fin_entity__to");
            siteCodeFrom = (String)fundtranferHdrMap.get("site_code__from");
            siteCodeTo = (String)fundtranferHdrMap.get("site_code__to");
            bankCodeFrom = (String)fundtranferHdrMap.get("bank_code__from");
            bankCodeTo = (String)fundtranferHdrMap.get("bank_code__to");
            xfrMode = (String)fundtranferHdrMap.get("xfr_mode");
            refNO = (String)fundtranferHdrMap.get("ref_no");
            acctCodeFrom = (String)fundtranferHdrMap.get("acct_code__from");
            acctCodeTo = (String)fundtranferHdrMap.get("acct_code__to");
            cctrCodeFrom = (String)fundtranferHdrMap.get("cctr_code__from");
            cctrCodeTo = (String)fundtranferHdrMap.get("cctr_code__to");
            acctCodeBc = (String)fundtranferHdrMap.get("acct_code__bc");
            cctrCodeBc = (String)fundtranferHdrMap.get("cctr_code__bc");
            currCodeBc = (String)fundtranferHdrMap.get("curr_code__bc");
            bankCharges = Double.parseDouble(" " + fundtranferHdrMap.get("bank_charges"));
            acNoFrom = (String)fundtranferHdrMap.get("ac_no__from");
            acNoTo = (String)fundtranferHdrMap.get("ac_no__to");
            status = (String)fundtranferHdrMap.get("status");
            remarks = (String)fundtranferHdrMap.get("remarks");
            exchRate = Double.parseDouble(" " + fundtranferHdrMap.get("exch_rate"));
            exchRateBc = Double.parseDouble(" " + fundtranferHdrMap.get("exch_rate__bc"));
            analCode = (String)fundtranferHdrMap.get("anal_code");
            iexfr = (String)fundtranferHdrMap.get("ie_xfr");
            acctcodeiep = (String)fundtranferHdrMap.get("acct_code__iep");
            cctrcodeiep = (String)fundtranferHdrMap.get("cctr_code__iep");
            acctcodeier = (String)fundtranferHdrMap.get("acct_code__ier");
            cctrcodeier = (String)fundtranferHdrMap.get("cctr_code__ier");
            tranidRef = (String)fundtranferHdrMap.get("tran_id__ref");
            empCode = (String)fundtranferHdrMap.get("emp_code");
            empCodeAprv = (String)fundtranferHdrMap.get("emp_code__aprv");
            siteCodeFrom = (String)fundtranferHdrMap.get("site_code__from");
            siteCodeTo = (String)fundtranferHdrMap.get("site_code__to");
            tranIdDish = (String)fundtranferHdrMap.get("tran_id__dish");
            tranMode = (String)fundtranferHdrMap.get("tran_mode");
            consYN = (String)fundtranferHdrMap.get("cons_yn");
            currCode = (String)fundtranferHdrMap.get("curr_code");
            tranIdRcp = (String)fundtranferHdrMap.get("tran_id__rcp");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 4 monika 20-May-2021  acctcodeier [" + acctcodeier + "]"));
            if (!(siteCodeFrom.trim().equals(siteCodeTo.trim()) || acctcodeier != null && acctcodeier.trim().length() != 0)) {
                String string = errString = itmDBAccessEJB.getErrorString("", "VTIERACCT", userId, "", conn);
                return string;
            }
            if (!"R".equalsIgnoreCase(linkType.trim()) && !"C".equalsIgnoreCase(linkType.trim())) {
                glTraceMap = new HashMap<String, Object>();
                glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                glTraceMap.put("fin_entity", finEntityFrom);
                glTraceMap.put("site_code", siteCodeFrom);
                glTraceMap.put("sundry_type", "B");
                glTraceMap.put("sundry_code", bankCodeFrom);
                glTraceMap.put("acct_code", acctCodeFrom);
                glTraceMap.put("cctr_code", cctrCodeFrom);
                glTraceMap.put("emp_code", empCode);
                glTraceMap.put("anal_code", analCode);
                glTraceMap.put("curr_code", currCode);
                glTraceMap.put("exch_rate", exchRate);
                if (netAmt > 0.0) {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", netAmt);
                } else {
                    glTraceMap.put("dr_amt", Math.abs(netAmt));
                    glTraceMap.put("cr_amt", 0.0);
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "F-XFR");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 5 monika 20-May-2021  glTraceMap [" + glTraceMap + "]"));
                errString = finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 6 monika 20-May-2021  glTraceUpdate gltrace111  1 [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 7 monika 20-May-2021  glTraceUpdate [" + errString + "]"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 8 monika 20-May-2021  debit [" + (debit += Double.parseDouble("" + glTraceMap.get("dr_amt")) * Double.parseDouble("" + glTraceMap.get("exch_rate"))) + "]"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 9 monika 20-May-2021  credit [" + (credit += Double.parseDouble("" + glTraceMap.get("cr_amt")) * Double.parseDouble("" + glTraceMap.get("exch_rate"))) + "]"));
                sundryBalMap = new HashMap();
                sundryBalMap.put("tran_date", new Timestamp(tranDate.getTime()));
                sundryBalMap.put("eff_date", new Timestamp(effDate.getTime()));
                sundryBalMap.put("fin_entity", finEntityFrom);
                sundryBalMap.put("site_code", siteCodeFrom);
                sundryBalMap.put("sundry_type", "B");
                sundryBalMap.put("sundry_code", bankCodeFrom);
                sundryBalMap.put("acct_code", acctCodeFrom);
                sundryBalMap.put("cctr_code", cctrCodeFrom);
                sundryBalMap.put("curr_code", currCode);
                sundryBalMap.put("exch_rate", exchRate);
                if (netAmt > 0.0) {
                    sundryBalMap.put("dr_amt", 0.0);
                    sundryBalMap.put("cr_amt", netAmt);
                } else {
                    sundryBalMap.put("dr_amt", Math.abs(netAmt));
                    sundryBalMap.put("cr_amt", 0.0);
                }
                sundryBalMap.put("adv_amt", 0.0);
                sundryBalMap.put("contact_code", "");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 10 monika 20-May-2021  gbf_sundrybal_upd [" + sundryBalMap + "]"));
                errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 11 monika 20-May-2021  gbf_sundrybal_upd [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("consYN before[" + consYN + "]"));
                if (consYN == null || consYN.trim().length() == 0) {
                    consYN = "";
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("consYN  after[" + consYN + "]"));
                if (!"Y".equalsIgnoreCase(consYN.trim())) {
                    bankTranLogMap = new HashMap<String, Object>();
                    bankTranLogMap.put("tran_date", new Timestamp(tranDate.getTime()));
                    bankTranLogMap.put("tran_ser", "F-XFR");
                    bankTranLogMap.put("tran_no", tranId);
                    bankTranLogMap.put("bank_code", bankCodeFrom);
                    bankTranLogMap.put("ref_no", refNO);
                    bankTranLogMap.put("ref_date", new Timestamp(refDate.getTime()));
                    bankTranLogMap.put("ref_mode", xfrMode);
                    bankTranLogMap.put("curr_code", currCode);
                    bankTranLogMap.put("exch_rate", exchRate);
                    banktranLogAmt = amount + taxAmt;
                    if (banktranLogAmt > 0.0) {
                        bankTranLogMap.put("amount", banktranLogAmt);
                        bankTranLogMap.put("tran_type", "P");
                    } else {
                        bankTranLogMap.put("amount", Math.abs(banktranLogAmt));
                        bankTranLogMap.put("tran_type", "R");
                    }
                    if ("P".equalsIgnoreCase(linkType.trim()) || "E".equalsIgnoreCase(linkType.trim())) {
                        if (banktranLogAmt > 0.0) {
                            bankTranLogMap.put("tran_type", "P");
                        } else {
                            bankTranLogMap.put("tran_type", "R");
                        }
                    } else if ("R".equalsIgnoreCase(linkType.trim()) || "C".equalsIgnoreCase(linkType.trim())) {
                        if (banktranLogAmt > 0.0) {
                            bankTranLogMap.put("tran_type", "R");
                        } else {
                            bankTranLogMap.put("tran_type", "P");
                        }
                    }
                    bankTranLogMap.put("site_code", siteCodeFrom);
                    bankTranLogMap.put("acct_code", acctCodeFrom);
                    bankTranLogMap.put("cctr_code", cctrCodeFrom);
                    bankTranLogMap.put("sundry_type", "O");
                    bankTranLogMap.put("sundry_code", " ");
                    bankTranLogMap.put("remarks", remarks);
                    bankTranLogMap.put("due_date", new Timestamp(tranDate.getTime()));
                    bankTranLogMap.put("entry_batch_no", (String)fundtranferHdrMap.get("entry_batch_no"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 12 monika 20-May-2021  bankTranLogMap [" + bankTranLogMap + "]"));
                    errString = finCommon.bankTranLogUpdate(bankTranLogMap, xtraParams, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 13 monika 20-May-2021  bankTranLogUpdate [" + errString + "]"));
                    if (errString != null && errString.trim().length() > 0) {
                        String string = errString;
                        return string;
                    }
                }
            }
            siteCodeFrom = (String)fundtranferHdrMap.get("site_code__from");
            siteCodeTo = (String)fundtranferHdrMap.get("site_code__to");
            if (siteCodeFrom.trim().equalsIgnoreCase(siteCodeTo.trim())) {
                sameSite = true;
                oppEff = true;
            } else {
                sameSite = false;
                oppEff = "A".equalsIgnoreCase(linkType.trim()) ? true : ("P".equalsIgnoreCase(linkType.trim()) ? false : ("R".equalsIgnoreCase(linkType.trim()) ? true : ("E".equalsIgnoreCase(linkType.trim()) ? false : ("N".equalsIgnoreCase(linkType.trim()) ? false : ("C".equalsIgnoreCase(linkType.trim()) ? false : false)))));
            }
            currCodeBc = (String)fundtranferHdrMap.get("curr_code__bc");
            bcFlag = currCodeBc.trim().equalsIgnoreCase(currCode.trim());
            if (sameSite) {
                glTraceMap = new HashMap();
                glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                glTraceMap.put("fin_entity", finEntityTo);
                glTraceMap.put("site_code", siteCodeTo);
                glTraceMap.put("sundry_type", "B");
                glTraceMap.put("sundry_code", bankCodeTo);
                glTraceMap.put("acct_code", acctCodeTo);
                glTraceMap.put("cctr_code", cctrCodeTo);
                glTraceMap.put("emp_code", empCode);
                glTraceMap.put("anal_code", analCode);
                glTraceMap.put("curr_code", currCode);
                glTraceMap.put("exch_rate", exchRate);
                if (!bcFlag) {
                    if (amount > 0.0) {
                        glTraceMap.put("dr_amt", amount);
                        glTraceMap.put("cr_amt", 0.0);
                    } else {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", Math.abs(netAmt));
                    }
                } else if (amount - bankCharges > 0.0) {
                    glTraceMap.put("dr_amt", amount - bankCharges);
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", Math.abs(netAmt));
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "F-XFR");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 14 monika 20-May-2021  glTraceMap [" + glTraceMap + "]site value [" + sameSite));
                errString = finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 15 monika 20-May-2021  glTraceUpdate  gltrace111 2 same site[" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 16 monika 20-May-2021  glTraceMap [" + errString + "]"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 17 monika 20-May-2021  debit [" + debit + "]"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 18 monika 20-May-2021  credit [" + credit + "]"));
                sundryBalMap = new HashMap<String, Object>();
                sundryBalMap.put("tran_date", new Timestamp(tranDate.getTime()));
                sundryBalMap.put("eff_date", new Timestamp(effDate.getTime()));
                sundryBalMap.put("fin_entity", finEntityTo);
                sundryBalMap.put("site_code", siteCodeTo);
                sundryBalMap.put("sundry_type", "B");
                sundryBalMap.put("sundry_code", bankCodeTo);
                sundryBalMap.put("acct_code", acctCodeTo);
                sundryBalMap.put("cctr_code", cctrCodeTo);
                sundryBalMap.put("curr_code", currCode);
                sundryBalMap.put("exch_rate", exchRate);
                if (!bcFlag) {
                    if (amount > 0.0) {
                        sundryBalMap.put("dr_amt", amount);
                        sundryBalMap.put("cr_amt", 0.0);
                    } else {
                        sundryBalMap.put("dr_amt", 0.0);
                        sundryBalMap.put("cr_amt", Math.abs(netAmt));
                    }
                } else if (amount - bankCharges > 0.0) {
                    sundryBalMap.put("dr_amt", amount - bankCharges);
                    sundryBalMap.put("cr_amt", 0.0);
                } else {
                    sundryBalMap.put("dr_amt", 0.0);
                    sundryBalMap.put("cr_amt", Math.abs(amount - bankCharges));
                }
                sundryBalMap.put("adv_amt", 0.0);
                sundryBalMap.put("contact_code", "");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 19 monika 20-May-2021  gbf_sundrybal_upd [" + sundryBalMap + "]"));
                errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 20 monika 20-May-2021  gbf_sundrybal_upd [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                sql = "select acct_code,cctr_code,sum(tax_amt),case when sum(reco_amount) is null then 0 else sum(reco_amount) end from taxtran where tran_code='F-XFR' and tran_id=? and effect <> 'N' group by acct_code, cctr_code";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    glTraceMap = new HashMap();
                    taxacctCode = rs.getString("acct_code");
                    taxcctrCode = rs.getString("cctr_code");
                    taxamount = rs.getDouble("tax_amt");
                    recoAmount = rs.getDouble("reco_amount");
                    if (recoAmount == 0.0) continue;
                    if (taxacctCode != null && taxacctCode.trim().length() > 0) {
                        errString = itmDBAccessEJB.getErrorString("", "VTACTAX", "BASE", "", conn);
                    }
                    glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                    glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                    glTraceMap.put("fin_entity", fundtranferHdrMap.get("fin_entity"));
                    glTraceMap.put("site_code", fundtranferHdrMap.get("site_code"));
                    glTraceMap.put("sundry_type", "O");
                    glTraceMap.put("sundry_code", "");
                    glTraceMap.put("acct_code", taxacctCode);
                    glTraceMap.put("cctr_code", taxcctrCode);
                    if (taxamount > 0.0) {
                        glTraceMap.put("dr_amt", Math.abs(taxamount) - Math.abs(recoAmount));
                        glTraceMap.put("cr_amt", 0.0);
                    } else {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", Math.abs(taxamount) - Math.abs(recoAmount));
                    }
                    if (Math.abs(taxamount) - Math.abs(recoAmount) != 0.0) {
                        errString = finCommon.glTraceUpdate(glTraceMap, conn);
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG  monika 20-May-2021  glTraceUpdate gltrace111 3 tax post  same site[" + errString + "]"));
                    if (errString == null || errString.trim().length() <= 0) continue;
                    String string = errString;
                    return string;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                recoAmount = 0.0;
                taxRecoAcct = finCommon.getAcctDetrTtype(" ", " ", "TAXRECO", tranType, conn);
                if (taxRecoAcct != null && taxRecoAcct.trim().length() > 0) {
                    tokens = taxRecoAcct.split(",");
                    taxRecoAcct = tokens[0];
                }
                if ((taxRecoCctr = finCommon.getAcctDetrTtype(" ", " ", "TAXRECO", tranType, conn)) != null && taxRecoCctr.trim().length() > 0) {
                    ary = taxRecoCctr.split(",");
                    taxRecoAcct = ary[0].toString();
                    taxRecoCctr = ary[1].toString();
                }
                sql = "select acct_code__reco,cctr_code__reco,case when sum(reco_amount) is null then 0 else sum(reco_amount) end from taxtran where tran_code='F-XFR' and tran_id=? and effect <> 'N' group by acct_code__reco, cctr_code__reco";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    acctCodeReco = rs.getString("acct_code__reco");
                    cctrCodeReco = rs.getString("cctr_code__reco");
                    recoAmount = rs.getDouble("reco_amount");
                    if (acctCodeReco == null || acctCodeReco.trim().length() == 0) {
                        String string = errString = itmDBAccessEJB.getErrorString("", "VTACCTRECO", userId, "", conn);
                        return string;
                    }
                    if (cctrCodeReco == null || cctrCodeReco.trim().length() == 0) {
                        cctrCodeReco = "";
                    }
                    glTraceMap.put("sundry_type", "O");
                    glTraceMap.put("sundry_code", "");
                    glTraceMap.put("acct_code", acctCodeReco);
                    glTraceMap.put("cctr_code", cctrCodeReco);
                    if (recoAmount > 0.0) {
                        glTraceMap.put("dr_amt", recoAmount);
                        glTraceMap.put("cr_amt", 0.0);
                    } else {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", Math.abs(recoAmount));
                    }
                    if (recoAmount != 0.0) {
                        errString = finCommon.glTraceUpdate(glTraceMap, conn);
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("glTraceUpdate taxpost errString " + errString));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG  monika 20-May-2021  glTraceUpdate gltrace111 4 tax post recoamount same site gltrace111[" + errString + "]"));
                    if (errString == null || errString.trim().length() <= 0) continue;
                    String string = errString;
                    return string;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                if (!"Y".equalsIgnoreCase(consYN.trim())) {
                    bankTranLogMap = new HashMap();
                    bankTranLogMap.put("tran_date", new Timestamp(tranDate.getTime()));
                    bankTranLogMap.put("tran_ser", "F-XFR");
                    bankTranLogMap.put("tran_no", tranId);
                    bankTranLogMap.put("bank_code", bankCodeTo);
                    bankTranLogMap.put("ref_no", refNO);
                    bankTranLogMap.put("ref_date", new Timestamp(refDate.getTime()));
                    bankTranLogMap.put("ref_mode", xfrMode);
                    bankTranLogMap.put("curr_code", currCode);
                    bankTranLogMap.put("exch_rate", exchRate);
                    banktranLogAmt = amount + taxAmt;
                    if (!bcFlag) {
                        if (banktranLogAmt > 0.0) {
                            bankTranLogMap.put("amount", banktranLogAmt);
                            bankTranLogMap.put("tran_type", "R");
                        } else {
                            bankTranLogMap.put("amount", Math.abs(banktranLogAmt));
                            bankTranLogMap.put("tran_type", "P");
                        }
                    } else if (banktranLogAmt > 0.0) {
                        bankTranLogMap.put("amount", banktranLogAmt - bankCharges);
                        bankTranLogMap.put("tran_type", "R");
                    } else {
                        bankTranLogMap.put("amount", Math.abs(banktranLogAmt - bankCharges));
                        bankTranLogMap.put("tran_type", "P");
                    }
                    if ("P".equalsIgnoreCase(linkType.trim()) || "E".equalsIgnoreCase(linkType.trim())) {
                        if (banktranLogAmt > 0.0) {
                            bankTranLogMap.put("tran_type", "P");
                        } else {
                            bankTranLogMap.put("tran_type", "R");
                        }
                    } else if ("R".equalsIgnoreCase(linkType.trim()) || "C".equalsIgnoreCase(linkType.trim())) {
                        if (banktranLogAmt > 0.0) {
                            bankTranLogMap.put("tran_type", "R");
                        } else {
                            bankTranLogMap.put("tran_type", "P");
                        }
                    }
                    bankTranLogMap.put("site_code", siteCodeTo);
                    bankTranLogMap.put("acct_code", acctCodeTo);
                    bankTranLogMap.put("cctr_code", cctrCodeTo);
                    bankTranLogMap.put("sundry_type", "O");
                    bankTranLogMap.put("sundry_code", " ");
                    bankTranLogMap.put("remarks", remarks);
                    bankTranLogMap.put("due_date", new Timestamp(tranDate.getTime()));
                    bankTranLogMap.put("entry_batch_no", (String)fundtranferHdrMap.get("entry_batch_no"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 21 monika 20-May-2021  bankTranLogMap [" + bankTranLogMap + "]"));
                    errString = finCommon.bankTranLogUpdate(bankTranLogMap, xtraParams, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 22 monika 20-May-2021  bankTranLogUpdate [" + errString + "]"));
                    if (errString != null && errString.trim().length() > 0) {
                        String string = errString;
                        return string;
                    }
                }
            } else if (!"R".equalsIgnoreCase(linkType.trim()) && !"C".equalsIgnoreCase(linkType.trim())) {
                glTraceMap = new HashMap();
                glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                glTraceMap.put("fin_entity", finEntityFrom);
                glTraceMap.put("site_code", siteCodeFrom);
                glTraceMap.put("sundry_type", "O");
                glTraceMap.put("sundry_code", " ");
                glTraceMap.put("acct_code", acctcodeiep);
                glTraceMap.put("cctr_code", cctrcodeiep);
                glTraceMap.put("emp_code", empCode);
                glTraceMap.put("anal_code", analCode);
                glTraceMap.put("curr_code", currCodeBc);
                glTraceMap.put("exch_rate", exchRateBc);
                if (!bcFlag) {
                    if (netAmt > 0.0) {
                        glTraceMap.put("dr_amt", netAmt);
                        glTraceMap.put("cr_amt", 0.0);
                    } else {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", Math.abs(netAmt));
                    }
                } else if (amount - bankCharges > 0.0) {
                    glTraceMap.put("dr_amt", amount - bankCharges);
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", Math.abs(amount - bankCharges));
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "F-XFR");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 23 monika 20-May-2021  glTraceMap [" + glTraceMap + "]"));
                errString = finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 24 monika 20-May-2021 else of same site contion gltrace111 5 [" + errString + "]same site [" + sameSite));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 25 monika 20-May-2021  glTraceMap [" + errString + "]"));
                sql = "select acct_code,cctr_code,sum(tax_amt),case when sum(reco_amount) is null then 0 else sum(reco_amount) end from taxtran where tran_code='F-XFR' and tran_id=? and effect <> 'N' group by acct_code, cctr_code";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    glTraceMap = new HashMap();
                    taxacctCode = rs.getString("acct_code");
                    taxcctrCode = rs.getString("cctr_code");
                    taxamount = rs.getDouble("tax_amt");
                    recoAmount = rs.getDouble("reco_amount");
                    if (taxacctCode != null && taxacctCode.trim().length() > 0) {
                        errString = itmDBAccessEJB.getErrorString("", "VTACTAX", "BASE", "", conn);
                    }
                    glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                    glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                    glTraceMap.put("fin_entity", fundtranferHdrMap.get("fin_entity"));
                    glTraceMap.put("site_code", fundtranferHdrMap.get("site_code"));
                    glTraceMap.put("sundry_type", "O");
                    glTraceMap.put("sundry_code", "");
                    glTraceMap.put("acct_code", taxacctCode);
                    glTraceMap.put("cctr_code", taxcctrCode);
                    if (taxamount > 0.0) {
                        glTraceMap.put("dr_amt", Math.abs(taxamount) - Math.abs(recoAmount));
                        glTraceMap.put("cr_amt", 0.0);
                    } else {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", Math.abs(taxamount) - Math.abs(recoAmount));
                    }
                    if (Math.abs(taxamount) - Math.abs(recoAmount) != 0.0) {
                        errString = finCommon.glTraceUpdate(glTraceMap, conn);
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("monika 20-May-2021  glTraceMap tax posting for different site code gltrace111 6 [" + errString + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("glTraceUpdate taxpost errString " + errString));
                    if (errString == null || errString.trim().length() <= 0) continue;
                    String string = errString;
                    return string;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                recoAmount = 0.0;
                taxRecoAcct = finCommon.getAcctDetrTtype(" ", " ", "TAXRECO", tranType, conn);
                if (taxRecoAcct != null && taxRecoAcct.trim().length() > 0) {
                    tokens = taxRecoAcct.split(",");
                    taxRecoAcct = tokens[0];
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("glTraceUpdate taxRecoAcct [ " + taxRecoAcct + "]"));
                taxRecoCctr = finCommon.getAcctDetrTtype(" ", " ", "TAXRECO", tranType, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("glTraceUpdate taxRecoCctr  [" + taxRecoCctr + " ]"));
                if (taxRecoCctr != null && taxRecoCctr.trim().length() > 0) {
                    ary = taxRecoCctr.split(",");
                    taxRecoAcct = ary[0].toString();
                    taxRecoCctr = ary[1].toString();
                }
                sql = "select acct_code__reco,cctr_code__reco,case when sum(reco_amount) is null then 0 else sum(reco_amount) end from taxtran where tran_code='F-XFR' and tran_id=? and effect <> 'N' group by acct_code__reco, cctr_code__reco";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    acctCodeReco = rs.getString("acct_code__reco");
                    cctrCodeReco = rs.getString("cctr_code__reco");
                    recoAmount = rs.getDouble("reco_amount");
                    if (acctCodeReco == null || acctCodeReco.trim().length() == 0) {
                        String string = errString = itmDBAccessEJB.getErrorString("", "VTACCTRECO", userId, "", conn);
                        return string;
                    }
                    if (cctrCodeReco == null || cctrCodeReco.trim().length() == 0) {
                        cctrCodeReco = "";
                    }
                    glTraceMap.put("sundry_type", "O");
                    glTraceMap.put("sundry_code", "");
                    glTraceMap.put("acct_code", acctCodeReco);
                    glTraceMap.put("cctr_code", cctrCodeReco);
                    if (recoAmount > 0.0) {
                        glTraceMap.put("dr_amt", recoAmount);
                        glTraceMap.put("cr_amt", 0.0);
                    } else {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", Math.abs(recoAmount));
                    }
                    if (recoAmount != 0.0) {
                        errString = finCommon.glTraceUpdate(glTraceMap, conn);
                    }
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("glTraceUpdate taxpost errString " + errString));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("monika 20-May-2021  glTraceMap tax recovery reco amount  posting for different site code gltrace111 7 [" + errString + "]"));
                    if (errString == null || errString.trim().length() <= 0) continue;
                    String string = errString;
                    return string;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
            }
            if (!"R".equalsIgnoreCase(linkType.trim()) && !"C".equalsIgnoreCase(linkType.trim()) && bcFlag && bankCharges != 0.0) {
                glTraceMap = new HashMap();
                glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                glTraceMap.put("fin_entity", finEntityFrom);
                glTraceMap.put("site_code", siteCodeFrom);
                glTraceMap.put("sundry_type", "O");
                glTraceMap.put("sundry_code", " ");
                glTraceMap.put("acct_code", acctCodeBc);
                glTraceMap.put("cctr_code", cctrCodeBc);
                glTraceMap.put("emp_code", empCode);
                glTraceMap.put("anal_code", analCode);
                glTraceMap.put("curr_code", currCodeBc);
                glTraceMap.put("exch_rate", exchRateBc);
                if (bankCharges > 0.0) {
                    glTraceMap.put("dr_amt", bankCharges);
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", Math.abs(bankCharges));
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "F-XFR");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 26 monika 20-May-2021  glTraceMap [" + glTraceMap + "]"));
                errString = finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 27 monika 20-May-2021 bank charges  glTraceUpdate gltrace111 8 [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 28 monika 20-May-2021  glTraceMap [" + errString + "]"));
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 29 monika 20-May-2021  debit [" + debit + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 30 monika 20-May-2021  credit [" + credit + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" !(sameSite) && (oppEff)" + sameSite + "] oppEff [" + oppEff + " ]"));
            if (!sameSite && oppEff) {
                glTraceMap = new HashMap();
                glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                glTraceMap.put("fin_entity", finEntityTo);
                glTraceMap.put("site_code", siteCodeTo);
                glTraceMap.put("sundry_type", "B");
                glTraceMap.put("sundry_code", bankCodeTo);
                glTraceMap.put("acct_code", acctCodeTo);
                glTraceMap.put("cctr_code", cctrCodeTo);
                glTraceMap.put("emp_code", empCode);
                glTraceMap.put("anal_code", analCode);
                glTraceMap.put("curr_code", currCode);
                glTraceMap.put("exch_rate", exchRate);
                if (!bcFlag) {
                    if (amount > 0.0) {
                        glTraceMap.put("dr_amt", amount);
                        glTraceMap.put("cr_amt", 0.0);
                    } else {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", Math.abs(amount));
                    }
                } else if (amount > 0.0) {
                    glTraceMap.put("dr_amt", amount - bankCharges);
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", Math.abs(amount - bankCharges));
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "F-XFR");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 31 monika 20-May-2021  glTraceMap [" + glTraceMap + "]"));
                errString = finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 33 monika 20-May-2021 1 entry for  !(sameSite) && (oppEff) glTraceUpdate  gltrace111 9[" + errString + "] !(sameSite) [" + sameSite + " ] (oppEff) [" + oppEff));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                glTraceMap = new HashMap();
                glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                glTraceMap.put("fin_entity", finEntityTo);
                glTraceMap.put("site_code", siteCodeTo);
                glTraceMap.put("sundry_type", "O");
                glTraceMap.put("sundry_code", " ");
                glTraceMap.put("acct_code", acctcodeier);
                glTraceMap.put("cctr_code", cctrcodeier);
                glTraceMap.put("emp_code", empCode);
                glTraceMap.put("anal_code", analCode);
                glTraceMap.put("curr_code", currCode);
                glTraceMap.put("exch_rate", exchRate);
                if (!bcFlag) {
                    if (amount > 0.0) {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", amount);
                    } else {
                        glTraceMap.put("dr_amt", Math.abs(amount));
                        glTraceMap.put("cr_amt", 0.0);
                    }
                } else if (amount > 0.0) {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", amount - bankCharges);
                } else {
                    glTraceMap.put("cr_amt", 0.0);
                    glTraceMap.put("dr_amt", Math.abs(amount - bankCharges));
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_ser", "F-XFR");
                glTraceMap.put("ref_id", tranId);
                glTraceMap.put("remarks", remarks);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 34 monika 20-May-2021  glTraceMap [" + glTraceMap + "]"));
                errString = finCommon.glTraceUpdate(glTraceMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" LOG 35 monika 20-May-2021 1 entry for  !(sameSite) && (oppEff) glTraceUpdate  gltrace111 10 [" + errString + "] !(sameSite) [" + sameSite + " ] (oppEff) [" + oppEff));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                sundryBalMap = new HashMap();
                sundryBalMap.put("tran_date", new Timestamp(tranDate.getTime()));
                sundryBalMap.put("eff_date", new Timestamp(effDate.getTime()));
                sundryBalMap.put("fin_entity", finEntityTo);
                sundryBalMap.put("site_code", siteCodeTo);
                sundryBalMap.put("sundry_type", "B");
                sundryBalMap.put("sundry_code", bankCodeTo);
                sundryBalMap.put("acct_code", acctCodeTo);
                sundryBalMap.put("cctr_code", cctrCodeTo);
                sundryBalMap.put("curr_code", currCode);
                sundryBalMap.put("exch_rate", exchRate);
                if (!bcFlag) {
                    if (amount > 0.0) {
                        sundryBalMap.put("dr_amt", amount);
                        sundryBalMap.put("cr_amt", 0.0);
                    } else {
                        sundryBalMap.put("dr_amt", 0.0);
                        sundryBalMap.put("cr_amt", Math.abs(amount));
                    }
                } else if (amount - bankCharges > 0.0) {
                    sundryBalMap.put("dr_amt", amount - bankCharges);
                    sundryBalMap.put("cr_amt", 0.0);
                } else {
                    sundryBalMap.put("dr_amt", 0.0);
                    sundryBalMap.put("cr_amt", Math.abs(amount - bankCharges));
                }
                sundryBalMap.put("adv_amt", 0.0);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 36 monika 20-May-2021  gbf_sundrybal_upd [" + sundryBalMap + "]"));
                errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 37 monika 20-May-2021  gbf_sundrybal_upd [" + errString + "]"));
                if (errString != null && errString.trim().length() > 0) {
                    String string = errString;
                    return string;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 38 monika 20-May-2021  gbf_sundrybal_upd [" + errString + "]"));
                if (!"Y".equalsIgnoreCase(consYN)) {
                    bankTranLogMap = new HashMap();
                    bankTranLogMap.put("tran_date", new Timestamp(tranDate.getTime()));
                    bankTranLogMap.put("tran_ser", "F-XFR");
                    bankTranLogMap.put("tran_no", tranId);
                    bankTranLogMap.put("bank_code", bankCodeTo);
                    bankTranLogMap.put("ref_no", refNO);
                    bankTranLogMap.put("ref_date", new Timestamp(refDate.getTime()));
                    bankTranLogMap.put("ref_mode", xfrMode);
                    bankTranLogMap.put("curr_code", currCode);
                    bankTranLogMap.put("exch_rate", exchRate);
                    banktranLogAmt = amount + taxAmt;
                    if (!bcFlag) {
                        if (amount > 0.0) {
                            bankTranLogMap.put("amount", amount);
                            bankTranLogMap.put("tran_type", "R");
                        } else {
                            bankTranLogMap.put("amount", Math.abs(amount));
                            bankTranLogMap.put("tran_type", "P");
                        }
                    } else if (amount > 0.0) {
                        bankTranLogMap.put("amount", amount - bankCharges);
                        bankTranLogMap.put("tran_type", "R");
                    } else {
                        bankTranLogMap.put("amount", Math.abs(amount - bankCharges));
                        bankTranLogMap.put("tran_type", "P");
                    }
                    if ("P".equalsIgnoreCase(linkType.trim()) || "E".equalsIgnoreCase(linkType.trim())) {
                        if (amount > 0.0) {
                            bankTranLogMap.put("tran_type", "P");
                        } else {
                            bankTranLogMap.put("tran_type", "R");
                        }
                    } else if ("R".equalsIgnoreCase(linkType.trim()) || "C".equalsIgnoreCase(linkType.trim())) {
                        if (amount > 0.0) {
                            bankTranLogMap.put("tran_type", "R");
                        } else {
                            bankTranLogMap.put("tran_type", "P");
                        }
                    }
                    bankTranLogMap.put("site_code", siteCodeTo);
                    bankTranLogMap.put("acct_code", acctCodeTo);
                    bankTranLogMap.put("cctr_code", cctrCodeTo);
                    bankTranLogMap.put("sundry_type", "O");
                    bankTranLogMap.put("sundry_code", " ");
                    bankTranLogMap.put("remarks", remarks);
                    bankTranLogMap.put("due_date", new Timestamp(tranDate.getTime()));
                    bankTranLogMap.put("entry_batch_no", (String)fundtranferHdrMap.get("entry_batch_no"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 39 monika 20-May-2021  bankTranLogMap [" + bankTranLogMap + "]"));
                    errString = finCommon.bankTranLogUpdate(bankTranLogMap, xtraParams, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("LOG 40 monika 20-May-2021  bankTranLogUpdate [" + errString + "]"));
                    if (errString != null && errString.trim().length() > 0) {
                        String string = errString;
                        return string;
                    }
                }
            }
            postOnline = finCommon.getFinparams("999999", "POST_ON_LINE", conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("postOnline--[" + postOnline + "]"));
            if ("Y".equalsIgnoreCase(postOnline)) {
                errString = finCommon.checkGlTranDrCr("F-XFR", tranId, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Returning from checkGlTranDrCr--[" + errString + "]"));
            }
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            sql = " select status from fundtransfer  where tran_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                status = rs.getString("status");
            }
            pstmt.close();
            pstmt = null;
            rs.close();
            rs = null;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("The Selected confirmed--> [" + status + " ] linkType [" + linkType + " ]"));
            if (!"C".equalsIgnoreCase(status.trim())) {
                if ("P".equalsIgnoreCase(linkType.trim())) {
                    sql = "select key_string from transetup where upper(tran_window) = 'W_FUNDTRANSFER'";
                    pstmt = conn.prepareStatement(sql);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        keyString = rs.getString(1);
                    } else {
                        sql = "select key_string from transetup where upper(tran_window) = 'GENERAL'";
                        pstmt = conn.prepareStatement(sql);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            keyString = rs.getString(1);
                        }
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("keyString :" + keyString));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranIdCol :" + tranIdCol));
                    tDay = new Timestamp(toDay.getTime());
                    xmlString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>\r\n</header><Detail1>\r\n<tran_date>" + sdf.format(new java.util.Date(tDay.getTime())) + "</tran_date>" + "\r\n<site_code__from>" + siteCodeFrom + "</site_code__from>" + "\r\n<site_code__to>" + siteCodeTo + "</site_code__to>" + "\r\n<emp_code__aprv>" + loginEmpCode + "</emp_code__aprv>" + "\r\n<eff_date>" + sdf.format(new java.util.Date(tDay.getTime())) + "</eff_date>" + "\r\n<tran_type>" + "C" + "</tran_type></Detail1></Root>";
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("xmlString : : : : :" + xmlString));
                    CommonConstants.setIBASEHOME();
                    TransIDGenerator tg = new TransIDGenerator(xmlString, "Base", CommonConstants.DB_NAME);
                    newtranId = tg.generateTranSeqID("F-XFR", "tran_id", keyString, conn);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranId  new--->:" + newtranId));
                    if ("ERROR".equalsIgnoreCase(tranId)) {
                        String string = errString = itmDBAccessEJB.getErrorString("", "VTTRANID", "", "", conn);
                        return string;
                    }
                    if (bcFlag) {
                        amount -= bankCharges;
                    }
                    sql = "insert into fundtransfer (tran_id, tran_date, tran_type, eff_date,bank_code__from, bank_code__to, fin_entity__from, fin_entity__to,site_code__from, site_code__to,  xfr_mode, ref_no, ref_date,amount, curr_code, exch_rate, acct_code__from, acct_code__to,cctr_code__from, cctr_code__to, bank_charges,  acct_code__bc,cctr_code__bc, curr_code__bc, exch_rate__bc,ac_no__from, ac_no__to, status, status_date, remarks,anal_code, ie_xfr,   acct_code__iep, cctr_code__iep,acct_code__ier, cctr_code__ier, tran_id__ref, link_type, emp_code,emp_code__aprv, add_date, add_user,  add_term,chg_date, chg_user, chg_term, entry_batch_no,tax_amt,cons_yn,tran_id__rcp ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, newtranId);
                    pstmt.setTimestamp(2, tranDate);
                    pstmt.setString(3, tranType);
                    pstmt.setTimestamp(4, effDate);
                    pstmt.setString(5, bankCodeFrom);
                    pstmt.setString(6, bankCodeTo);
                    pstmt.setString(7, finEntityFrom);
                    pstmt.setString(8, finEntityTo);
                    pstmt.setString(9, siteCodeFrom);
                    pstmt.setString(10, siteCodeTo);
                    pstmt.setString(11, xfrMode);
                    pstmt.setString(12, refNO);
                    pstmt.setTimestamp(13, refDate);
                    pstmt.setDouble(14, amount);
                    pstmt.setString(15, currCode);
                    pstmt.setDouble(16, exchRate);
                    pstmt.setString(17, acctCodeFrom);
                    pstmt.setString(18, acctCodeTo);
                    pstmt.setString(19, cctrCodeFrom);
                    pstmt.setString(20, cctrCodeTo);
                    pstmt.setDouble(21, bankCharges);
                    pstmt.setString(22, acctCodeBc);
                    pstmt.setString(23, cctrCodeBc);
                    pstmt.setString(24, currCodeBc);
                    pstmt.setDouble(25, exchRateBc);
                    pstmt.setString(26, acNoFrom);
                    pstmt.setString(27, acNoTo);
                    pstmt.setString(28, "E");
                    pstmt.setTimestamp(29, statusDate);
                    pstmt.setString(30, remarks);
                    pstmt.setString(31, analCode);
                    pstmt.setString(32, "Y");
                    pstmt.setString(33, acctcodeiep);
                    pstmt.setString(34, cctrcodeiep);
                    pstmt.setString(35, acctcodeier);
                    pstmt.setString(36, cctrcodeier);
                    pstmt.setString(37, tranId);
                    pstmt.setString(38, "R");
                    pstmt.setString(39, loginEmpCode);
                    pstmt.setString(40, empCodeAprv);
                    pstmt.setDate(41, new Date(new java.util.Date().getTime()));
                    pstmt.setString(42, loginEmpCode);
                    pstmt.setString(43, addTerm);
                    pstmt.setDate(44, new Date(new java.util.Date().getTime()));
                    pstmt.setString(45, chgUser);
                    pstmt.setString(46, chgTerm);
                    pstmt.setString(47, entryBatchNo);
                    pstmt.setDouble(48, 0.0);
                    pstmt.setString(49, consYN);
                    pstmt.setString(50, tranIdRcp);
                    int updCount = pstmt.executeUpdate();
                    if (updCount < 1) {
                        String string = errString = itmDBAccessEJB.getErrorString("", "DS000NR", "", "", conn);
                        return string;
                    }
                    pstmt.close();
                    pstmt = null;
                    sql = "select auto_confirm from fundtransfer_ctrl where site_code__from=? and site_code__to=? and fin_entity__from=? and fin_entity__to=? and link_type='P'";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, siteCodeFrom);
                    pstmt.setString(2, siteCodeTo);
                    pstmt.setString(3, finEntityFrom);
                    pstmt.setString(4, finEntityTo);
                    rs = pstmt.executeQuery();
                    ibcaConf = rs.next() ? rs.getString("auto_confirm") : "N";
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    if ("Y".equalsIgnoreCase(ibcaConf.trim())) {
                        errString = this.gbfRetrieveFundtransfer(newtranId, siteCodeFrom, xtraParams, conn);
                        ibcaConf = "N";
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("err String from gbfRetrieveDrcrPay =" + errString));
                        if (errString != null && errString.trim().length() > 0) {
                            String string = errString;
                            return string;
                        }
                    }
                }
                if (!(rs = (pstmt = conn.prepareStatement(sql = "select edi_option from transetup where tran_window = 'w_fundtransfer'")).executeQuery()).next()) {
                    String string = errString = itmDBAccessEJB.getErrorString("", "VTTRSET1", "", "", conn);
                    return string;
                }
                ediOption = rs.getString("edi_option");
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if ("E".equalsIgnoreCase(linkType.trim()) || Integer.parseInt(ediOption) > 0) {
                    CreateRCPXML createRCPXML;
                    if ("2".equals(ediOption.trim())) {
                        createRCPXML = new CreateRCPXML("w_fundtransfer", "tran_id");
                        dataStr = createRCPXML.getTranXML(newtranId, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr 1273=[ " + dataStr + "]"));
                        Document ediDataDom = genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_fundtransfer", "0", xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (errString != null && "SUCCESS".equals(errString)) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from batchload = [" + errString + "]"));
                        }
                    } else {
                        createRCPXML = new CreateRCPXML("w_fundtransfer", "tran_id");
                        dataStr = createRCPXML.getTranXML(newtranId, conn);
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("dataStr 12731=[ " + dataStr + "]"));
                        Document ediDataDom = genericUtility.parseString(dataStr);
                        E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                        errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_fundtransfer", "0", xtraParams, conn);
                        createRCPXML = null;
                        e12CreateBatchLoad = null;
                        if (errString != null && "SUCCESS".equals(errString)) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from batchload = [" + errString + "]"));
                        } else {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("retString from batchload = 1157[" + errString + "]"));
                        }
                    }
                }
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("finally print esstring at end " + errString + "]"));
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :Fundtransfer :gbfPostFundtransfer :==>" + e.getMessage()));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)e.getMessage());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
            errString = e.getMessage();
            e.printStackTrace();
            throw new ITMException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    public double getReqDecimal(double actVal, int prec) {
        DecimalFormat decFormat;
        String fmtStr = "############0";
        Object strValue = null;
        double retVal = 0.0;
        if (prec > 0) {
            fmtStr = String.valueOf(fmtStr) + "." + "000000000".substring(0, prec);
        }
        if (Math.abs(retVal = Double.parseDouble((decFormat = new DecimalFormat(fmtStr)).format(actVal))) == 0.0) {
            retVal = 0.0;
        }
        return retVal;
    }

    private String[] string2StringArray(String str1, String delimeter) {
        StringTokenizer st = new StringTokenizer(str1, delimeter);
        int count = st.countTokens();
        String[] arry1 = new String[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            arry1[i] = st.nextToken();
            System.out.print("Token " + i + " :[" + arry1[i] + "]");
            ++i;
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"");
        return arry1;
    }

    private static double roundVal(double round, int scale) {
        return (double)Math.round(round * Math.pow(10.0, scale)) / Math.pow(10.0, scale);
    }
}

