/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.DrCrPayConfLocal;
import ibase.webitm.ejb.fin.adv.DrCrPayConfRemote;
import ibase.webitm.ejb.fin.adv.RcvIbcaConf;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.Stateless;

@Stateless
public class DrCrPayConf
extends ActionHandlerEJB
implements DrCrPayConfLocal,
DrCrPayConfRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();

    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String errString = "";
        Connection conn = null;
        try {
            errString = this.confirm(tranId, xtraParams, forcedFlag, conn);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in confirm() ==>" + e.getMessage()));
            errString = this.genericUtility.createErrorString(e);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString in cofirm() ==>" + errString));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    @Override
    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"confirm called........@@@");
        String sql = "";
        String confirm = "";
        String siteCode = "";
        String errString = "";
        String tranSer = "";
        String loginEmpCode = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        FinCommon finCommon = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        ITMDBAccessEJB itmDBAccessEJB = null;
        ValidatorEJB validatorEJB = null;
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tran id = " + tranId));
        boolean connStatus = false;
        Boolean isValTran = false;
        String chgUser = "";
        try {
            if (conn == null) {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                conn = this.getConnection();
                conn.setAutoCommit(false);
                connDriver = null;
                connStatus = true;
            }
            finCommon = new FinCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            validatorEJB = new ValidatorEJB();
            loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Printing loginEmpCode---1-----" + loginEmpCode + "--"));
            sql = "select confirmed from drcr_pay where tran_id = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                isValTran = true;
                confirm = rs.getString("confirmed") == null ? "N" : rs.getString("confirmed");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (!isValTran.booleanValue()) {
                String string = errString = itmDBAccessEJB.getErrorString("", "VTMCONF20", "", "", conn);
                return string;
            }
            if (confirm != null && "Y".equalsIgnoreCase(confirm)) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                String string = errString = itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            errString = this.gbfRetrieveDrcrPay(tranId, xtraParams, conn);
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            try {
                if (errString == null || errString.trim().length() == 0) {
                    sql = "update drcr_pay set confirmed = 'Y', conf_date = ?, emp_code__aprv = ? where tran_id = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(2, loginEmpCode);
                    pstmt.setString(3, tranId);
                    int updcnt = pstmt.executeUpdate();
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + updcnt));
                    pstmt.close();
                    pstmt = null;
                    if (updcnt > 0) {
                        errString = itmDBAccessEJB.getErrorString("", "VTCICONF3", "", "", conn);
                    }
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Error String from confirm method.....[" + errString + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception ::" + e.getMessage()));
                errString = genericUtility.createErrorString(e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Exception while rollbacking222.......");
                }
                throw new ITMException(e);
            }
        }
        finally {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY MiscValConf confirm MATHOD333@#......>>[" + connStatus + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY MiscValConf confirm errString@#......>>[" + errString + "]"));
            try {
                if (errString != null && errString.trim().length() > 0) {
                    if (errString.indexOf("VTCICONF3") > -1) {
                        if (connStatus) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Transaction commited111.............from DrCrPayConf");
                            conn.commit();
                        }
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollbacking......................................");
                        conn.rollback();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"CONNECTION Rollback......................................");
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connStatus) {
                    conn.close();
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String gbfRetrieveDrcrPay(String tranId, String xtraParams, Connection conn) throws RemoteException, ITMException {
        String errCode = "";
        String sql = "";
        String keyFld = "";
        String tranSer = "";
        String winName = "";
        String ledgPostConf = "";
        String lsAcctcode = "";
        String lsCctrcode = "";
        String cctrRnd = "";
        String acctRnd = "";
        int lineNo = 0;
        int findIndex = 0;
        Statement pstmt = null;
        Statement pstmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        Timestamp today = null;
        Timestamp tranDate = null;
        HashMap<String, Object> HdrMap = null;
        HashMap DetMap = null;
        ArrayList<HashMap> DetList = new ArrayList<HashMap>();
        double exchRatehdr = 0.0;
        double amountMap = 0.0;
        double roundAdj = 0.0;
        ITMDBAccessEJB itmDBAccessEJB = null;
        itmDBAccessEJB = new ITMDBAccessEJB();
        E12GenericUtility genericUtility = new E12GenericUtility();
        FinCommon finCommon = null;
        try {
            finCommon = new FinCommon();
            sql = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "select tran_id from drcr_pay where tran_id = ? for update " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "select tran_id from drcr_pay (updlock) where tran_id = ? " : " select tran_id from drcr_pay where tran_id = ? for update nowait ");
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                String string = errCode = itmDBAccessEJB.getErrorString("", "VTLCKERR", "", "", conn);
                return string;
            }
            keyFld = rs.getString("tran_id") == null ? " " : rs.getString("tran_id");
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            today = new Timestamp(System.currentTimeMillis());
            sql = "SELECT tran_id,tran_date,tran_ser,eff_date,vouch_no,supp_code,site_code,fin_entity,anal_code, bill_no,amount,curr_code,exch_rate,cr_term,due_date,acct_code,cctr_code,remarks,confirmed,conf_date,emp_code__aprv,drcr_flag,tran_id__pay,amount__bc,vouch_adj, bill_date,supp_ref_no,supp_ref_date FROM drcr_pay where tran_id = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                HdrMap = new HashMap<String, Object>();
                HdrMap.put("tran_id", tranId);
                HdrMap.put("tran_date", rs.getTimestamp("tran_date"));
                HdrMap.put("tran_ser", rs.getString("tran_ser"));
                HdrMap.put("eff_date", rs.getTimestamp("eff_date"));
                HdrMap.put("vouch_no", rs.getString("vouch_no"));
                HdrMap.put("supp_code", rs.getString("supp_code"));
                HdrMap.put("site_code", rs.getString("site_code"));
                HdrMap.put("fin_entity", rs.getString("fin_entity"));
                HdrMap.put("anal_code", rs.getString("anal_code"));
                HdrMap.put("bill_no", rs.getString("bill_no"));
                HdrMap.put("amount", rs.getDouble("amount"));
                HdrMap.put("curr_code", rs.getString("curr_code"));
                exchRatehdr = rs.getDouble("exch_rate");
                HdrMap.put("exch_rate", exchRatehdr);
                HdrMap.put("cr_term", rs.getString("cr_term"));
                HdrMap.put("due_date", rs.getTimestamp("due_date"));
                HdrMap.put("acct_code", rs.getString("acct_code"));
                HdrMap.put("cctr_code", rs.getString("cctr_code"));
                HdrMap.put("remarks", rs.getString("remarks"));
                HdrMap.put("confirmed", rs.getString("confirmed"));
                HdrMap.put("conf_date", rs.getTimestamp("conf_date"));
                HdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
                HdrMap.put("drcr_flag", rs.getString("drcr_flag"));
                HdrMap.put("tran_id__pay", rs.getString("tran_id__pay"));
                HdrMap.put("amount__bc", rs.getDouble("amount__bc"));
                HdrMap.put("vouch_adj", rs.getString("vouch_adj"));
                HdrMap.put("bill_date", rs.getTimestamp("bill_date"));
                HdrMap.put("supp_ref_no", rs.getString("supp_ref_no"));
                HdrMap.put("supp_ref_date", rs.getTimestamp("supp_ref_date"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)" Header Map..........");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)HdrMap.toString());
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            tranSer = (String)HdrMap.get("tran_ser");
            if ("CRNPAY".equalsIgnoreCase(tranSer)) {
                winName = "W_DRCRPAY_CR";
            } else if ("DRNPAY".equalsIgnoreCase(tranSer)) {
                winName = "W_DRCRPAY_DR";
            }
            sql = "select ledg_post_conf from transetup where upper(tran_window) = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, "W_DRCRINV");
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                String string = errCode = itmDBAccessEJB.getErrorString("", "VTSEQ", "", "", conn);
                return string;
            }
            ledgPostConf = rs.getString(1);
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if ("Y".equalsIgnoreCase(ledgPostConf)) {
                SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
                tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today)) + " 00:00:00.000");
                sql = " update drcr_pay set tran_date = ? where tran_id   = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setTimestamp(1, tranDate);
                pstmt.setString(2, tranId);
                int upd = pstmt.executeUpdate();
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + upd));
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            sql = "select acct_code__reco, cctr_code__reco, line_no, sum(tax_amt) as tax_amt from taxtran where tran_code = ? and tran_id = ? and tax_amt <> 0 and effect <> 'N' group by acct_code__reco, cctr_code__reco, line_no ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, (String)HdrMap.get("tran_ser"));
            pstmt.setString(2, tranId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                lsAcctcode = rs.getString("acct_code__reco");
                lsCctrcode = rs.getString("cctr_code__reco");
                lineNo = Integer.parseInt(rs.getString("line_no").trim());
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lineNo....." + lineNo));
                if (lsAcctcode == null) {
                    sql = "select acct_code from drcr_pdet where tran_id = ? and line_no = ? ";
                    pstmt1 = conn.prepareStatement(sql);
                    pstmt1.setString(1, tranId);
                    pstmt1.setInt(2, lineNo);
                    rs1 = pstmt1.executeQuery();
                    if (rs1.next()) {
                        lsAcctcode = rs1.getString("acct_code");
                    }
                    rs1.close();
                    rs1 = null;
                    pstmt1.close();
                    pstmt1 = null;
                }
                if (lsCctrcode == null) {
                    sql = "select cctr_code from drcr_pdet where tran_id = ? and line_no = ? ";
                    pstmt1 = conn.prepareStatement(sql);
                    pstmt1.setString(1, tranId);
                    pstmt1.setInt(2, lineNo);
                    rs1 = pstmt1.executeQuery();
                    if (rs1.next()) {
                        lsCctrcode = rs1.getString("cctr_code");
                    }
                    rs1.close();
                    rs1 = null;
                    pstmt1.close();
                    pstmt1 = null;
                }
                DetMap = new HashMap();
                DetMap.put("tran_id", (String)HdrMap.get("tran_id"));
                DetMap.put("line_no", "" + ++lineNo);
                DetMap.put("acct_code", lsAcctcode);
                DetMap.put("cctr_code", lsCctrcode);
                DetMap.put("amount", rs.getDouble("tax_amt"));
                DetMap.put("emp_code", "");
                DetMap.put("anal_code", "");
                DetList.add(DetMap);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            sql = "select acct_code, cctr_code, analysis1,analysis2,analysis3,sum(drcr_amt) as drcr_amt from drcr_pdet where tran_id = ? group by acct_code, cctr_code,analysis1,analysis2,analysis3 ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                findIndex = -1;
                findIndex = this.findExistingIndex(DetList, this.checkNull(rs.getString("acct_code")), this.checkNull(rs.getString("cctr_code")), this.checkNull(rs.getString("analysis1")), this.checkNull(rs.getString("analysis2")), this.checkNull(rs.getString("analysis3")));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("  findExistingIndex [" + findIndex + "] Map [" + DetList.toString() + "]"));
                if (findIndex > -1) {
                    DetMap = (HashMap)DetList.get(findIndex);
                    amountMap = Double.parseDouble("" + DetMap.get("amount"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" 16/06/14 findExistingIndex [" + findIndex + "] amountMap [" + amountMap + "] amount [" + rs.getDouble("drcr_amt") + "]"));
                    DetMap.put("amount", amountMap + rs.getDouble("drcr_amt"));
                    DetList.set(findIndex, DetMap);
                } else {
                    DetMap = new HashMap();
                    DetMap.put("tran_id", tranId);
                    DetMap.put("line_no", "" + ++lineNo);
                    DetMap.put("acct_code", rs.getString("acct_code"));
                    DetMap.put("cctr_code", rs.getString("cctr_code"));
                    DetMap.put("amount", rs.getDouble("drcr_amt"));
                    DetMap.put("emp_code", "");
                    DetMap.put("anal_code", "");
                    DetMap.put("analysis1", rs.getString("analysis1"));
                    DetMap.put("analysis2", rs.getString("analysis2"));
                    DetMap.put("analysis3", rs.getString("analysis3"));
                    DetList.add(DetMap);
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)DetMap.toString());
            }
            pstmt.close();
            pstmt = null;
            rs.close();
            rs = null;
            sql = "Insert into drcr_pacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,AMOUNT,EMP_CODE,ANAL_CODE,ANALYSIS1,ANALYSIS2,ANALYSIS3) values (?,?,?,?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql);
            int maxline = 0;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" DetList [" + DetList.toString() + "]"));
            int i = 0;
            while (i < DetList.size()) {
                double tempAmt = Double.parseDouble("" + DetMap.get("amount"));
                if (tempAmt != 0.0) {
                    DetMap = (HashMap)DetList.get(i);
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" Insert in drcr_pacct ctr [" + i + "] Map [" + HdrMap.toString() + "]"));
                    pstmt.setString(1, (String)DetMap.get("tran_id"));
                    pstmt.setInt(2, ++maxline);
                    pstmt.setString(3, (String)DetMap.get("acct_code"));
                    pstmt.setString(4, (String)DetMap.get("cctr_code"));
                    pstmt.setDouble(5, Double.parseDouble("" + DetMap.get("amount")));
                    pstmt.setString(6, (String)DetMap.get("emp_code"));
                    pstmt.setString(7, (String)DetMap.get("anal_code"));
                    pstmt.setString(8, (String)DetMap.get("analysis1"));
                    pstmt.setString(9, (String)DetMap.get("analysis2"));
                    pstmt.setString(10, (String)DetMap.get("analysis3"));
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                ++i;
            }
            if (maxline > 0) {
                pstmt.executeBatch();
            }
            pstmt.close();
            pstmt = null;
            errCode = this.gbfPostDrCrPay(tranId, HdrMap, DetList, xtraParams, conn);
            if (errCode != null && errCode.trim().length() > 0) {
                String string = errCode;
                return string;
            }
        }
        catch (SQLException e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :DrCrPayConf :gbfRetrieveDrcrPay :SQLException :==>\n" + e.getMessage()));
            errCode = genericUtility.createErrorString((Exception)e);
            throw new ITMException((Exception)e);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :DrCrPayConf :gbfRetrieveDrcrPay :==>" + e.getMessage()));
            errCode = genericUtility.createErrorString(e);
            throw new ITMException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                    pstmt1 = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errCode;
    }

    private int findExistingIndex(ArrayList detList, String acctCode, String cctrCode, String analysis1, String analysis2, String analysis3) throws RemoteException, ITMException {
        int findIndex = -1;
        HashMap detMap = null;
        String acctCodeMap = null;
        String cctrCodeMap = null;
        String analysis1Map = null;
        String analysis2Map = null;
        String analysis3Map = null;
        double exchRateMap = 0.0;
        try {
            int ctr = 0;
            while (ctr < detList.size()) {
                detMap = (HashMap)detList.get(ctr);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("acctCode.." + acctCode + "..cctrCode..." + cctrCode + "..analysis1.." + analysis1 + "..analysis2.." + analysis2 + "..analysis3.." + analysis3));
                acctCodeMap = this.checkNull((String)detMap.get("acct_code"));
                cctrCodeMap = this.checkNull((String)detMap.get("cctr_code"));
                analysis1Map = this.checkNull((String)detMap.get("analysis1"));
                analysis2Map = this.checkNull((String)detMap.get("analysis2"));
                analysis3Map = this.checkNull((String)detMap.get("analysis3"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("acctCodeMap.." + acctCodeMap + "..cctrCodeMap..." + cctrCodeMap + "..analysis1Map.." + analysis1Map + "..analysis2Map.." + analysis2Map + "..analysis3Map.." + analysis3Map));
                if (acctCodeMap.trim().equalsIgnoreCase(acctCode.trim()) && cctrCodeMap.trim().equalsIgnoreCase(cctrCode.trim()) && analysis1Map.trim().equalsIgnoreCase(analysis1.trim()) && analysis2Map.trim().equalsIgnoreCase(analysis2.trim()) && analysis3Map.trim().equalsIgnoreCase(analysis3.trim())) {
                    findIndex = ctr;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return findIndex;
    }

    private String gbfPostDrCrPay(String tranId, HashMap HdrMap, ArrayList DetList, String xtraParams, Connection conn) throws RemoteException, ITMException {
        String errCode;
        block69: {
            errCode = "";
            String transer = "";
            String confirmed = "";
            String sql = "";
            String loginEmpCode = "";
            String chgUser = "";
            String remarks = "";
            String suppCode = "";
            String siteCode = "";
            String sitePayment = "";
            String gsRunMode = "I";
            String keystr = "";
            String finEntityFr = "";
            String finEntityTo = "";
            String linkType = "";
            String acctFr = "";
            String cctrFr = "";
            String acctTo = "";
            String cctrTo = "";
            String autoConfirm = "";
            String paymode = "";
            String batch = "";
            String currCode = "";
            String bankCode = "";
            String acctCode = "";
            String cctrCode = "";
            String billNo = "";
            String purcOrder = "";
            String autoPay = "";
            String sundryCode = "";
            String crTerm = "";
            String ibcaId = "";
            String userid = "";
            String termid = "";
            String tranType = "";
            String xmlString = "";
            String refType = "";
            FinCommon finCommon = null;
            ValidatorEJB validatorEJB = null;
            ITMDBAccessEJB itmDBAccessEJB = null;
            Statement pstmt = null;
            ResultSet rs = null;
            double amount = 0.0;
            double exchRate = 0.0;
            double suppAmt = 0.0;
            double advAmt = 0.0;
            double amountBc = 0.0;
            Timestamp billDt = null;
            Timestamp dueDate = null;
            Timestamp tranDate = null;
            Timestamp refDate = null;
            Timestamp today1 = null;
            int upd = 0;
            E12GenericUtility genericUtility = new E12GenericUtility();
            java.util.Date toDay = new java.util.Date();
            Timestamp tDay = null;
            SimpleDateFormat sdf = null;
            try {
                sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
                validatorEJB = new ValidatorEJB();
                itmDBAccessEJB = new ITMDBAccessEJB();
                userid = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
                termid = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
                sql = "select confirmed ,chg_user  from drcr_pay where tran_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    confirmed = rs.getString("confirmed") == null ? "N" : rs.getString("confirmed");
                    chgUser = rs.getString("chg_user") == null ? " " : rs.getString("chg_user");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (chgUser == null || chgUser.trim().length() == 0) {
                    chgUser = "SYSTEM";
                }
                loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Printing loginEmpCode---1-----" + loginEmpCode + "--"));
                if ("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode == null || loginEmpCode.trim().length() == 0) {
                    sql = "select emp_code from users where code=?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, chgUser);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        loginEmpCode = rs.getString(1);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Printing loginEmpCode---2-----" + loginEmpCode + "--"));
                }
                transer = (String)HdrMap.get("tran_ser");
                finCommon = new FinCommon();
                errCode = this.gbfPostDrCrPayhdr(tranId, HdrMap, xtraParams, conn);
                if (errCode != null && errCode.trim().length() > 0) {
                    String string = errCode;
                    return string;
                }
                errCode = this.gbfPostDrCrPaydet(tranId, HdrMap, DetList, xtraParams, conn);
                if (errCode != null && errCode.trim().length() > 0) {
                    String string = errCode;
                    return string;
                }
                errCode = finCommon.checkGlTranDrCr(transer, tranId, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString in checkGlTranDrCr ::" + errCode));
                if (errCode != null && errCode.trim().length() > 0) {
                    String string = errCode;
                    return string;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)(" after checkGlTranDrCr errCode [" + errCode + "]"));
                if (confirmed == null) {
                    confirmed = "N";
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Error String from gbfPostDrCrPay method.....[" + errCode + "]"));
                suppCode = (String)HdrMap.get("supp_code");
                siteCode = (String)HdrMap.get("site_code");
                sql = "select site_code__pay from site_supplier where supp_code = ? and site_code = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, suppCode);
                pstmt.setString(2, siteCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    sitePayment = rs.getString("site_code__pay");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (sitePayment == null || sitePayment.trim().length() == 0) {
                    sql = "select site_code__pay from supplier where supp_code = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, suppCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        sitePayment = rs.getString("site_code__pay");
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
                if (sitePayment == null) {
                    sitePayment = siteCode;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("sitePayment..." + sitePayment + "...siteCode.." + siteCode + "..gsRunMode.." + gsRunMode));
                if (sitePayment.equalsIgnoreCase(siteCode) || !"I".equalsIgnoreCase(gsRunMode)) break block69;
                sql = "select key_string from transetup where upper(tran_window) = 'W_PAY_IBCA'";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    String string = errCode = itmDBAccessEJB.getErrorString("", "VTSEQ", "", "", conn);
                    return string;
                }
                keystr = rs.getString("key_string");
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                sql = "select fin_entity from site where site_code = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, siteCode);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    String string = errCode = itmDBAccessEJB.getErrorString("", "VMSITE", "", "", conn);
                    return string;
                }
                finEntityFr = rs.getString("fin_entity");
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                sql = "select fin_entity from site where site_code = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, sitePayment);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    String string = errCode = itmDBAccessEJB.getErrorString("", "VMSITE", "", "", conn);
                    return string;
                }
                finEntityTo = rs.getString("fin_entity");
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                sql = "select link_type, acct_code__pay, cctr_code__pay, acct_code__rcp, cctr_code__rcp,auto_confirm from ibca_pay_ctrl where site_code__from = ? and site_code__to = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, siteCode);
                pstmt.setString(2, sitePayment);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    String string = errCode = itmDBAccessEJB.getErrorString("", "VTIBCA5", "", "", conn);
                    return string;
                }
                linkType = rs.getString("link_type");
                acctFr = rs.getString("acct_code__pay");
                cctrFr = rs.getString("cctr_code__pay");
                acctTo = rs.getString("acct_code__rcp");
                cctrTo = rs.getString("cctr_code__rcp");
                autoConfirm = rs.getString("auto_confirm");
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                tDay = new Timestamp(toDay.getTime());
                xmlString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>\r\n</header><Detail1><item_ser></item_ser>\r\n<tran_date>" + sdf.format(new java.util.Date(tDay.getTime())) + "</tran_date>" + "\r\n<site_code__from>" + siteCode + "</site_code__from>" + "\r\n<link_type>" + linkType + "</link_type></Detail1></Root>";
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("xmlString : : : : :" + xmlString));
                CommonConstants.setIBASEHOME();
                TransIDGenerator tg = new TransIDGenerator(xmlString, "Base", CommonConstants.DB_NAME);
                ibcaId = tg.generateTranSeqID("P-IBCA", "tran_id", keystr, conn);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Generated Key :: " + ibcaId));
                if (ibcaId.indexOf("ERROR") > -1) {
                    String string = errCode = itmDBAccessEJB.getErrorString("", "VTTRANID", "", "", conn);
                    return string;
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("transer..." + transer + "..tranId..." + tranId));
                sql = "select tot_amt, exch_rate, curr_code, bank_code, acct_code, cctr_code, bill_no, bill_date, supp_bill_amt, purc_order, auto_pay, due_date, adv_amt, tran_date, sundry_code, pay_mode, entry_batch_no, ref_date from misc_payables where tran_ser = ? and ref_no = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, transer);
                pstmt.setString(2, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    amount = rs.getDouble("tot_amt");
                    exchRate = rs.getDouble("exch_rate");
                    currCode = rs.getString("curr_code");
                    bankCode = rs.getString("bank_code");
                    acctCode = rs.getString("acct_code");
                    cctrCode = rs.getString("cctr_code");
                    billNo = rs.getString("bill_no");
                    billDt = rs.getTimestamp("bill_date");
                    suppAmt = rs.getDouble("supp_bill_amt");
                    purcOrder = rs.getString("purc_order");
                    autoPay = rs.getString("auto_pay");
                    dueDate = rs.getTimestamp("due_date");
                    advAmt = rs.getDouble("adv_amt");
                    tranDate = rs.getTimestamp("tran_date");
                    sundryCode = rs.getString("sundry_code");
                    paymode = rs.getString("pay_mode");
                    batch = rs.getString("entry_batch_no");
                    refDate = rs.getTimestamp("ref_date");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (tranDate == null) {
                    today1 = new Timestamp(System.currentTimeMillis());
                    sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
                    tranDate = Timestamp.valueOf(String.valueOf(sdf.format(today1)) + " 00:00:00.000");
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranDate...." + tranDate));
                }
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tranDate....!!" + tranDate));
                sql = "select remarks from misc_voucher where tran_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    remarks = rs.getString("remarks");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (remarks == null || remarks.trim().length() == 0) {
                    remarks = "Auto IBCA of voucher of " + sundryCode;
                }
                amountBc = amount * exchRate;
                crTerm = (String)HdrMap.get("cr_term");
                sql = "insert into pay_ibca (tran_id, tran_date, eff_date, site_code__from, fin_entity__from, \t\t\t\t\tsite_code__to, fin_entity__to, amount, curr_code, exch_rate, confirmed, acct_code__ifr, \t\t\t\t\tcctr_code__ifr, acct_code__ito, cctr_code__ito, chg_date, chg_user, chg_term, amount__bc,\t\t\t\t\ttran_type, tran_ser, link_type, remarks,sundry_type,sundry_code)\t\t\t\tvalues (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, ibcaId);
                pstmt.setTimestamp(2, tranDate);
                pstmt.setTimestamp(3, tranDate);
                pstmt.setString(4, siteCode);
                pstmt.setString(5, finEntityFr);
                pstmt.setString(6, sitePayment);
                pstmt.setString(7, finEntityTo);
                pstmt.setDouble(8, amount);
                pstmt.setString(9, currCode);
                pstmt.setDouble(10, exchRate);
                pstmt.setString(11, "N");
                pstmt.setString(12, acctFr);
                pstmt.setString(13, cctrFr);
                pstmt.setString(14, acctTo);
                pstmt.setString(15, cctrTo);
                pstmt.setDate(16, new Date(new java.util.Date().getTime()));
                pstmt.setString(17, userid);
                pstmt.setString(18, termid);
                pstmt.setDouble(19, amountBc);
                pstmt.setString(20, tranType);
                pstmt.setString(21, "I");
                pstmt.setString(22, linkType);
                pstmt.setString(23, remarks);
                pstmt.setString(24, "S");
                pstmt.setString(25, sundryCode);
                upd = pstmt.executeUpdate();
                if (upd < 1) {
                    String string = errCode = itmDBAccessEJB.getErrorString("", "DS000NR", "", "", conn);
                    return string;
                }
                pstmt.close();
                pstmt = null;
                sql = "insert into pay_ibca_det (tran_id, ref_ser, ref_no, ref_date, curr_code, exch_rate,\t\t\t\t\tsundry_type, sundry_code, acct_code, cctr_code, due_date, tot_amt, discount,\t\t\t\t\ttax_amt, auto_pay, bank_code, ref_type, bill_no, bill_date, pay_mode, entry_batch_no,\t\t\t\t\tpurc_order, supp_bill_amt , adv_amt, tds_amt, cr_term,ref_ser__org)\t\t\t\tvalues (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, ibcaId);
                pstmt.setString(2, transer);
                pstmt.setString(3, tranId);
                pstmt.setTimestamp(4, refDate);
                pstmt.setString(5, currCode);
                pstmt.setDouble(6, exchRate);
                pstmt.setString(7, "S");
                pstmt.setString(8, sundryCode);
                pstmt.setString(9, acctCode);
                pstmt.setString(10, cctrCode);
                pstmt.setTimestamp(11, dueDate);
                pstmt.setDouble(12, amount);
                pstmt.setDouble(13, 0.0);
                pstmt.setDouble(14, 0.0);
                pstmt.setString(15, autoPay);
                pstmt.setString(16, bankCode);
                pstmt.setString(17, refType);
                pstmt.setString(18, billNo);
                pstmt.setTimestamp(19, billDt);
                pstmt.setString(20, paymode);
                pstmt.setString(21, batch);
                pstmt.setString(22, purcOrder);
                pstmt.setDouble(23, suppAmt);
                pstmt.setDouble(24, advAmt);
                pstmt.setDouble(25, 0.0);
                pstmt.setString(26, crTerm);
                pstmt.setString(27, transer);
                upd = pstmt.executeUpdate();
                if (upd < 1) {
                    String string = errCode = itmDBAccessEJB.getErrorString("", "DS000NR", "", "", conn);
                    return string;
                }
                pstmt.close();
                pstmt = null;
                RcvIbcaConf ibcaObj = new RcvIbcaConf();
                errCode = ibcaObj.retreiveRibca(ibcaId, siteCode, xtraParams, conn);
                if (errCode != null && errCode.trim().length() > 0) {
                    String string = errCode;
                    return string;
                }
                try {
                    ibcaObj = null;
                }
                catch (SQLException e) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :MiscValConf :gbfPostMiscVouch :SQLException :==>\n" + e.getMessage()));
                    errCode = genericUtility.createErrorString((Exception)e);
                    throw new ITMException((Exception)e);
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :MiscValConf :gbfPostMiscVouch :==>" + e.getMessage()));
                    errCode = genericUtility.createErrorString(e);
                    throw new ITMException(e);
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
        }
        return errCode;
    }

    /*
     * Unable to fully structure code
     */
    private String gbfPostDrCrPayhdr(String tranId, HashMap HdrMap, String xtraParams, Connection conn) throws RemoteException, ITMException {
        errString = "";
        loginEmpCode = "";
        finEntity = "";
        siteCode = "";
        tranSer = "";
        suppCode = "";
        acctCode = "";
        cctrCode = "";
        analCode = "";
        currCode = "";
        remarks = "";
        drcrFlag = "";
        sql = "";
        lsdrcrFlag = "";
        lsrefNo = "";
        lstranSer = "";
        lsdocFlag = "";
        lsvouchNo = "";
        vtranId = "";
        keystr = "";
        xmlString = "";
        mpadjTranid = "";
        lstranId = "";
        confirmed = "";
        tranDate = null;
        effDate = null;
        exchRate = 0.0;
        amount = 0.0;
        voutotAmt = 0.0;
        adjAmt = 0.0;
        drAmt = 0.0;
        glTraceMap = null;
        sundryBalMap = null;
        miscPayMap = null;
        pstmt = null;
        pstmt1 = null;
        rs = null;
        rs1 = null;
        finCommon = null;
        distCommon = null;
        itmDBAccessEJB = null;
        validatorEJB = new ValidatorEJB();
        genericUtility = new E12GenericUtility();
        try {
            finCommon = new FinCommon();
            distCommon = new DistCommon();
            itmDBAccessEJB = new ITMDBAccessEJB();
            loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            tranDate = (Timestamp)HdrMap.get("tran_date");
            effDate = (Timestamp)HdrMap.get("eff_date");
            finEntity = (String)HdrMap.get("fin_entity");
            siteCode = (String)HdrMap.get("site_code");
            suppCode = (String)HdrMap.get("supp_code");
            acctCode = (String)HdrMap.get("acct_code");
            cctrCode = (String)HdrMap.get("cctr_code");
            analCode = (String)HdrMap.get("anal_code");
            currCode = (String)HdrMap.get("curr_code");
            exchRate = Double.parseDouble("" + HdrMap.get("exch_rate"));
            amount = Double.parseDouble("" + HdrMap.get("amount"));
            tranSer = (String)HdrMap.get("tran_ser");
            tranId = (String)HdrMap.get("tran_id");
            remarks = (String)HdrMap.get("remarks");
            glTraceMap = new HashMap<String, Object>();
            glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
            glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
            glTraceMap.put("fin_entity", finEntity);
            glTraceMap.put("site_code", siteCode);
            glTraceMap.put("sundry_type", "S");
            glTraceMap.put("sundry_code", suppCode);
            glTraceMap.put("acct_code", acctCode);
            glTraceMap.put("cctr_code", cctrCode);
            glTraceMap.put("anal_code", analCode);
            glTraceMap.put("curr_code", currCode);
            glTraceMap.put("exch_rate", exchRate);
            drcrFlag = (String)HdrMap.get("drcr_flag");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("gltrace  drcrFlag [" + drcrFlag + "]amount [" + amount + "]"));
            if ("D".equalsIgnoreCase(drcrFlag)) {
                glTraceMap.put("dr_amt", amount);
                glTraceMap.put("cr_amt", 0.0);
            } else {
                glTraceMap.put("dr_amt", 0.0);
                glTraceMap.put("cr_amt", amount);
            }
            glTraceMap.put("ref_type", "F");
            glTraceMap.put("ref_ser", tranSer);
            glTraceMap.put("ref_id", tranId);
            glTraceMap.put("remarks", remarks);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("glTraceUpdate Called glTraceMap[" + glTraceMap.toString() + "]"));
            errString = finCommon.glTraceUpdate(glTraceMap, conn);
            if (errString != null && errString.trim().length() > 0) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"ERROR IN GLTRACE ...........");
                var62_48 = errString;
                return var62_48;
            }
            sundryBalMap = new HashMap<String, Object>();
            sundryBalMap.put("tran_date", new Timestamp(tranDate.getTime()));
            sundryBalMap.put("eff_date", new Timestamp(effDate.getTime()));
            sundryBalMap.put("fin_entity", finEntity);
            sundryBalMap.put("site_code", siteCode);
            sundryBalMap.put("sundry_type", "S");
            sundryBalMap.put("sundry_code", suppCode);
            sundryBalMap.put("acct_code", (String)HdrMap.get("acct_code"));
            sundryBalMap.put("cctr_code", (String)HdrMap.get("cctr_code") == null ? "" : (String)HdrMap.get("cctr_code"));
            sundryBalMap.put("curr_code", (String)HdrMap.get("curr_code"));
            sundryBalMap.put("exch_rate", Double.parseDouble("" + HdrMap.get("exch_rate")));
            if ("D".equals(drcrFlag)) {
                sundryBalMap.put("dr_amt", amount);
                sundryBalMap.put("cr_amt", 0.0);
            } else {
                sundryBalMap.put("dr_amt", 0.0);
                sundryBalMap.put("cr_amt", amount);
            }
            sundryBalMap.put("adv_amt", 0.0);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"2366 sundryBaleUpdate Called..............");
            errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
            if (errString != null && errString.trim().length() > 0) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("error is sundryBaleUpdate ..........." + errString));
                var62_49 = errString;
                return var62_49;
            }
            miscPayMap = new HashMap<String, Object>();
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("tran_ser...in miscPayMap" + (String)HdrMap.get("tran_ser")));
            miscPayMap.put("tran_ser", (String)HdrMap.get("tran_ser"));
            miscPayMap.put("tran_date", new Timestamp(tranDate.getTime()));
            miscPayMap.put("ref_no", tranId);
            miscPayMap.put("ref_date", new Timestamp(tranDate.getTime()));
            miscPayMap.put("bill_no", (String)HdrMap.get("bill_no"));
            miscPayMap.put("bill_date", (Timestamp)HdrMap.get("bill_date"));
            miscPayMap.put("curr_code", (String)HdrMap.get("curr_code"));
            miscPayMap.put("exch_rate", Double.parseDouble("" + HdrMap.get("exch_rate")));
            miscPayMap.put("sundry_type", "S");
            miscPayMap.put("sundry_code", (String)HdrMap.get("supp_code"));
            miscPayMap.put("acct_code", (String)HdrMap.get("acct_code"));
            miscPayMap.put("cctr_code", (String)HdrMap.get("cctr_code") == null ? "" : (String)HdrMap.get("cctr_code"));
            miscPayMap.put("due_date", (Timestamp)HdrMap.get("due_date"));
            miscPayMap.put("site_code", siteCode);
            miscPayMap.put("fin_entity", finEntity);
            if ("C".equals(drcrFlag)) {
                miscPayMap.put("tot_amt", amount);
            } else {
                miscPayMap.put("tot_amt", 0.0 - amount);
            }
            miscPayMap.put("bank_code", (String)HdrMap.get("bank_code"));
            miscPayMap.put("auto_pay", "Y");
            miscPayMap.put("pay_mode", (String)HdrMap.get("pay_mode"));
            miscPayMap.put("paid", "N");
            miscPayMap.put("adv_amt", 0);
            miscPayMap.put("hold_amt", 0.0);
            miscPayMap.put("supp_bill_amt", "0.0");
            miscPayMap.put("tds_amt", "0.0");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"miscPayMap Called..............");
            errString = finCommon.gbfMiscPayUpd(miscPayMap, conn);
            if (errString != null && errString.trim().length() > 0) {
                var62_50 = errString;
                return var62_50;
            }
            lsdrcrFlag = (String)HdrMap.get("vouch_adj");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lsdrcrFlag..." + lsdrcrFlag));
            if (!"D".equalsIgnoreCase(lsdrcrFlag) && !"C".equalsIgnoreCase(lsdrcrFlag) && !"B".equalsIgnoreCase(lsdrcrFlag)) ** GOTO lbl342
            lsrefNo = (String)miscPayMap.get("ref_no");
            lstranSer = (String)miscPayMap.get("tran_ser");
            lsdocFlag = (String)HdrMap.get("drcr_flag");
            lsvouchNo = (String)HdrMap.get("vouch_no");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("lsrefNo..." + lsrefNo + "..lstranSer..." + lstranSer + "..lsdocFlag.." + lsdocFlag + "..lsvouchNo..." + lsvouchNo));
            if ("D".equalsIgnoreCase(lsdocFlag) && !"D".equalsIgnoreCase(lsdrcrFlag) && !"B".equalsIgnoreCase(lsdrcrFlag) || "C".equalsIgnoreCase(lsdocFlag) && !"C".equalsIgnoreCase(lsdrcrFlag) && !"B".equalsIgnoreCase(lsdrcrFlag)) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"inside break....");
                return "";
            }
            sql = "select tran_id, tot_amt, adj_amt from misc_payables where tran_ser = 'VOUCH' and ref_no = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, lsvouchNo);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                vtranId = rs.getString("tran_id");
                voutotAmt = rs.getDouble("tot_amt");
                adjAmt = rs.getDouble("adj_amt");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("amount....." + amount + "...amount * -1" + amount * -1.0));
            totAmount = Double.parseDouble("" + miscPayMap.get("tot_amt"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("totAmount...." + totAmount));
            drAmt = totAmount * -1.0;
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("drAmt..." + drAmt + "...voutotAmt..." + voutotAmt + "..adjAmt..." + adjAmt));
            status = "U";
            status = Math.abs(drAmt + adjAmt) == Math.abs(voutotAmt) ? "A" : "P";
            if (!(drAmt <= voutotAmt - adjAmt)) ** GOTO lbl342
            sql = "update misc_payables set adj_amt = ? , status_date = ?, status = ? where tran_ser = 'VOUCH' and ref_no = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setDouble(1, adjAmt + drAmt);
            pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(3, status);
            pstmt.setString(4, lsvouchNo);
            updateCoount = pstmt.executeUpdate();
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + updateCoount));
            pstmt.close();
            pstmt = null;
            sql = "update misc_payables set adj_amt = tot_amt,status = 'A' ,status_date = ? where tran_ser = ? and ref_no = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(2, lstranSer);
            pstmt.setString(3, lsrefNo);
            updcnt = pstmt.executeUpdate();
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of row update = " + updcnt));
            pstmt.close();
            pstmt = null;
            sql = "select key_string from transetup where upper(tran_window) = 'T_MISC_PAY_ADJ'";
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                keystr = rs.getString("key_string");
            } else {
                sql = "select key_string from transetup where upper(tran_window) = 'GENERAL'";
                pstmt1 = conn.prepareStatement(sql);
                rs1 = pstmt1.executeQuery();
                if (rs1.next()) {
                    keystr = rs1.getString("key_string");
                }
                rs1.close();
                rs1 = null;
                pstmt1.close();
                pstmt1 = null;
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            sql = "select tran_id from misc_payables where tran_ser = ? and ref_no = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, lstranSer);
            pstmt.setString(2, lsrefNo);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                lstranId = rs.getString("tran_id");
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            xmlString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>\r\n</header><Detail1><item_ser></item_ser>\r\n<tran_date>" + tranDate + "</tran_date>" + "\r\n<site_code__from>" + siteCode + "</site_code__from></Detail1></Root>";
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("xmlString : : : : :" + xmlString));
            CommonConstants.setIBASEHOME();
            tg = new TransIDGenerator(xmlString, "Base", CommonConstants.DB_NAME);
            mpadjTranid = tg.generateTranSeqID("PAYADJ", "tran_id", keystr, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Generated Key :: " + mpadjTranid));
            if (mpadjTranid.indexOf("ERROR") > -1) {
                var62_51 = errString = itmDBAccessEJB.getErrorString("", "VTTRANID", "", "", conn);
                return var62_51;
            }
            sql = "insert into misc_payables_adj (tran_id ,\tref_ser  ,\tref_no   ,tot_amt,\tadj_amt ,\tref_ser_adj,ref_no_adj  ,\tnet_amt ,\ttran_id__pay ) values (?,?,?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, mpadjTranid);
            pstmt.setString(2, lstranSer);
            pstmt.setString(3, lsrefNo);
            pstmt.setDouble(4, drAmt);
            pstmt.setDouble(5, drAmt);
            pstmt.setString(6, "VOUCH");
            pstmt.setString(7, lsvouchNo);
            pstmt.setDouble(8, 0.0);
            pstmt.setString(9, lstranId);
            upd = pstmt.executeUpdate();
            if (upd < 1) {
                var62_52 = errString = itmDBAccessEJB.getErrorString("", "DS000NR", "", "", conn);
                return var62_52;
            }
            pstmt.close();
            pstmt = null;
            xmlString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>\r\n</header><Detail1><item_ser></item_ser>\r\n<tran_date>" + tranDate + "</tran_date>" + "\r\n<site_code__from>" + siteCode + "</site_code__from></Detail1></Root>";
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("xmlString : : : : :" + xmlString));
            CommonConstants.setIBASEHOME();
            mpadjTranid = tg.generateTranSeqID("PAYADJ", "tran_id", keystr, conn);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Generated Key :: " + mpadjTranid));
            if (mpadjTranid.indexOf("ERROR") > -1) {
                var62_53 = errString = itmDBAccessEJB.getErrorString("", "VTTRANID", "", "", conn);
                return var62_53;
            }
            sql = "insert into misc_payables_adj\t\t\t(tran_id ,\tref_ser  ,\tref_no   ,\t\t\ttot_amt,\tadj_amt ,\tref_ser_adj,\t\t\tref_no_adj  ,\tnet_amt ,\ttran_id__pay )\t\t\tvalues ( ?,?,?,?,?,?,?,?,? )";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, mpadjTranid);
            pstmt.setString(2, "VOUCH");
            pstmt.setString(3, lsvouchNo);
            pstmt.setDouble(4, voutotAmt - adjAmt);
            pstmt.setDouble(5, drAmt);
            pstmt.setString(6, "      ");
            pstmt.setString(7, "               ");
            pstmt.setDouble(8, voutotAmt - adjAmt - drAmt);
            pstmt.setString(9, vtranId);
            updct = pstmt.executeUpdate();
            if (updct < 1) {
                var62_54 = errString = itmDBAccessEJB.getErrorString("", "DS000NR", "", "", conn);
                return var62_54;
            }
            try {
                pstmt.close();
                pstmt = null;
lbl342:
                // 3 sources

                confirmed = (String)HdrMap.get("confirmed");
            }
            catch (SQLException e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :DrCrPayConf :gbfPostDrCrPayhdr :SQLException :==>\n" + e.getMessage()));
                errString = genericUtility.createErrorString((Exception)e);
                throw new ITMException((Exception)e);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :DrCrPayConf :gbfPostDrCrPayhdr :==>" + e.getMessage()));
                errString = genericUtility.createErrorString(e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                    pstmt1 = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String gbfPostDrCrPaydet(String tranId, HashMap HdrMap, ArrayList DetList, String xtraParams, Connection conn) throws RemoteException, ITMException {
        String errString = "";
        String loginEmpCode = "";
        String finEntity = "";
        String siteCode = "";
        String currCode = "";
        String refId = "";
        String refSer = "";
        String remarks = "";
        String sundryCode = "";
        String sundryType = "";
        String acctCode = "";
        String cctrCode = "";
        String analCode = "";
        String empCode = "";
        String analysis1 = "";
        String analysis2 = "";
        String analysis3 = "";
        FinCommon finCommon = null;
        ValidatorEJB validatorEJB = new ValidatorEJB();
        ITMDBAccessEJB itmDBAccessEJB = null;
        HashMap<String, Object> glTraceMap = null;
        HashMap DetMap = null;
        java.util.Date tranDate = null;
        java.util.Date effDate = null;
        double exchRate = 0.0;
        double amount = 0.0;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            finCommon = new FinCommon();
            loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            Date today = new Date(new java.util.Date().getTime());
            itmDBAccessEJB = new ITMDBAccessEJB();
            tranDate = (java.util.Date)HdrMap.get("tran_date");
            effDate = (java.util.Date)HdrMap.get("eff_date");
            finEntity = (String)HdrMap.get("fin_entity");
            siteCode = (String)HdrMap.get("site_code");
            currCode = (String)HdrMap.get("curr_code");
            exchRate = Double.parseDouble("" + HdrMap.get("exch_rate"));
            refId = (String)HdrMap.get("tran_id");
            refSer = (String)HdrMap.get("tran_ser");
            remarks = (String)HdrMap.get("remarks");
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList SIZE " + DetList.size()));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetList SIZE [" + DetList.toString() + "]"));
            int ctr = 0;
            while (ctr < DetList.size()) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("no of times " + ctr));
                DetMap = new HashMap();
                DetMap = (HashMap)DetList.get(ctr);
                sundryCode = (String)DetMap.get("sundry_code");
                sundryType = (String)DetMap.get("sundry_type");
                acctCode = (String)DetMap.get("acct_code");
                cctrCode = (String)DetMap.get("cctr_code");
                empCode = (String)DetMap.get("emp_code");
                analCode = (String)DetMap.get("anal_code");
                amount = Double.parseDouble("" + DetMap.get("amount"));
                analysis1 = (String)DetMap.get("analysis1");
                analysis2 = (String)DetMap.get("analysis2");
                analysis3 = (String)DetMap.get("analysis3");
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("DetMap SIZE " + DetMap));
                glTraceMap = new HashMap<String, Object>();
                glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
                glTraceMap.put("eff_date", new Timestamp(effDate.getTime()));
                glTraceMap.put("fin_entity", finEntity);
                glTraceMap.put("site_code", siteCode);
                glTraceMap.put("sundry_type", sundryType);
                glTraceMap.put("sundry_code", sundryCode);
                glTraceMap.put("acct_code", acctCode);
                glTraceMap.put("cctr_code", cctrCode);
                glTraceMap.put("emp_code", empCode);
                glTraceMap.put("anal_code", analCode);
                glTraceMap.put("curr_code", currCode);
                glTraceMap.put("exch_rate", exchRate);
                if ("D".equals(HdrMap.get("drcr_flag"))) {
                    if (amount > 0.0) {
                        glTraceMap.put("dr_amt", 0.0);
                        glTraceMap.put("cr_amt", amount);
                    } else {
                        glTraceMap.put("dr_amt", -1.0 * amount);
                        glTraceMap.put("cr_amt", 0.0);
                    }
                } else if (amount > 0.0) {
                    glTraceMap.put("dr_amt", amount);
                    glTraceMap.put("cr_amt", 0.0);
                } else {
                    glTraceMap.put("dr_amt", 0.0);
                    glTraceMap.put("cr_amt", -1.0 * amount);
                }
                glTraceMap.put("ref_type", "F");
                glTraceMap.put("ref_id", refId);
                glTraceMap.put("ref_ser", refSer);
                glTraceMap.put("remarks", remarks);
                glTraceMap.put("analysis1", analysis1);
                glTraceMap.put("analysis2", analysis2);
                glTraceMap.put("analysis3", analysis3);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("1766 glTraceUpdate Called..drcrflag [" + HdrMap.get("drcr_flag") + "] glTraceMap [" + glTraceMap + "]"));
                errString = finCommon.glTraceUpdate(glTraceMap, conn);
                if (errString != null && errString.trim().length() > 0) {
                    return errString;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception :DrCrPayConf :gbfPostDrCrPaydet :==>" + e.getMessage()));
            errString = genericUtility.createErrorString(e);
            throw new ITMException(e);
        }
        return errString;
    }

    private String checkNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }
}

