/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ActionHandlerLocal;
import ibase.webitm.ejb.ActionHandlerRemote;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.ejb.Stateless;

@Stateless
public class AdvanceAmendmentConf
extends ActionHandlerEJB
implements ActionHandlerLocal,
ActionHandlerRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

    public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String errString = "";
        Connection conn = null;
        try {
            errString = this.confirm(tranId, xtraParams, forcedFlag, conn);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception in confirm() ==>" + e.getMessage()));
            errString = this.genericUtility.createErrorString(e);
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("errString in cofirm() ==>" + errString));
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException {
        Statement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        String confirm = "";
        String vouchNo = "";
        String purcOrder = "";
        String empCodeAprv = "";
        String errString = "";
        Calendar currentDate = Calendar.getInstance();
        Timestamp sysDate = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        boolean isLocalConn = false;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
            String sysDateStr = sdf.format(currentDate.getTime());
            sysDate = Timestamp.valueOf(String.valueOf(this.genericUtility.getValidDateString(sysDateStr, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat())) + " 00:00:00.0");
            empCodeAprv = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            itmDBAccessEJB = new ITMDBAccessEJB();
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                isLocalConn = true;
            }
            sql = CommonConstants.DB_NAME.equalsIgnoreCase("DB2") ? " select confirmed,vouch_no,purc_order from advance_amd where tran_id = ? for update " : (CommonConstants.DB_NAME.equalsIgnoreCase("MSSQL") ? " select confirmed,vouch_no,purc_order from advance_amd (updlock) where tran_id = ? " : " select confirmed,vouch_no,purc_order from advance_amd where tran_id = ? for update nowait ");
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                String string = errString = itmDBAccessEJB.getErrorString("", "VTLCKERR", "", "", conn);
                return string;
            }
            confirm = rs.getString("confirmed");
            vouchNo = rs.getString("vouch_no");
            purcOrder = rs.getString("purc_order");
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (confirm != null && "Y".equalsIgnoreCase(confirm)) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"The Selected transaction is already confirmed");
                String string = errString = itmDBAccessEJB.getErrorString("", "VTMCONF1", "", "", conn);
                return string;
            }
            if (vouchNo != null && purcOrder != null) {
                sql = " update misc_payables set purc_order = ? where ref_no= ? and tran_ser='P-ADV' ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, purcOrder);
                pstmt.setString(2, vouchNo);
                int updCnt = pstmt.executeUpdate();
                BaseLogger.log((String)"3", null, null, (Object)("AdvanceAmendmentConf:: updCnt========[" + updCnt + "]"));
                if (updCnt == 0) {
                    BaseLogger.log((String)"3", null, null, (Object)"AdvanceAmendmentConf:: Update into misc_payables Failed !!");
                    String string = errString = itmDBAccessEJB.getErrorString("", "DS000NR", "", "", conn);
                    return string;
                }
                pstmt.close();
                pstmt = null;
                sql = " update voucher set purc_order = ? where tran_id = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, purcOrder);
                pstmt.setString(2, vouchNo);
                updCnt = pstmt.executeUpdate();
                BaseLogger.log((String)"3", null, null, (Object)("AdvanceAmendmentConf::voucher::updCnt========[" + updCnt + "]"));
                if (updCnt == 0) {
                    BaseLogger.log((String)"3", null, null, (Object)"AdvanceAmendmentConf:: Update into voucher Failed !!");
                    String string = errString = itmDBAccessEJB.getErrorString("", "DS000NR", "", "", conn);
                    return string;
                }
                pstmt.close();
                pstmt = null;
                if (updCnt != 0) {
                    sql = " update advance_amd set CONFIRMED = ?, CONF_DATE = ?, EMP_CODE__APRV = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, "Y");
                    pstmt.setTimestamp(2, sysDate);
                    pstmt.setString(3, empCodeAprv);
                    int rowCnt = pstmt.executeUpdate();
                    BaseLogger.log((String)"3", null, null, (Object)("AdvanceAmendmentConf::voucher::rowCnt========[" + rowCnt + "]"));
                    if (rowCnt == 0) {
                        BaseLogger.log((String)"3", null, null, (Object)"AdvanceAmendmentConf:: Update into advance_amd Failed !!");
                        String string = errString = itmDBAccessEJB.getErrorString("", "DS000NR", "", "", conn);
                        return string;
                    }
                    pstmt.close();
                    pstmt = null;
                }
            }
            if (errString != null && errString.trim().length() > 0) {
                String string = errString;
                return string;
            }
            try {
                errString = new ITMDBAccessEJB().getErrorString("", "VTCONSUCF", "", "", conn);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception ::" + e.getMessage()));
                errString = this.genericUtility.createErrorString(e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Exception while rollbacking222.......");
                }
                throw new ITMException(e);
            }
        }
        finally {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY AdvanceAmendmentConf confirm @#......>>[" + isLocalConn + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("IN fINALLY AdvanceAmendmentConf confirm errString@#......>>[" + errString + "]"));
            try {
                if (errString != null && errString.trim().length() > 0) {
                    if (errString.indexOf("VTCONSUCF") > -1) {
                        if (isLocalConn) {
                            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Transaction commited from AdvanceAmendmentConf::");
                            conn.commit();
                        }
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"AdvanceAmendmentConf::CONNECTION Rollbacking..!!");
                        conn.rollback();
                        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"AdvanceAmendmentConf::CONNECTION Rollbacked..!!");
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (isLocalConn) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("Exception : " + e));
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return errString;
    }
}

