package ibase.webitm.marketing.servlet;

import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletContext;
import java.util.TimerTask;
import java.util.Timer;
import java.util.Calendar;
import ibase.utility.BaseLogger;
import java.util.Map;
import java.util.Hashtable;
import javax.naming.InitialContext;
import ibase.system.config.AppConnectParm;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ServletContextListnerExpMkt implements ServletContextListener {
	public void contextDestroyed(final ServletContextEvent contextEvent) {
		System.out.println("ServletContextListnerExpMkt is now destroyed");
	}

	public void contextInitialized(final ServletContextEvent contextEvent) {
		System.out.println("*** STARTED >> ServletContextListnerExpMkt is initialize ***");
		Map<String, ArrayList<String>> unAllocDocMap = new HashMap<String, ArrayList<String>>();
		System.out.println("@ contextEvent>> " + contextEvent);
		try {
			final AppConnectParm appConnect = new AppConnectParm();
			System.out.println("@ appConnect>> " + appConnect);
			final InitialContext ictx = new InitialContext(appConnect.getProperty());
			System.out.println("@ Amit  ictx for  getProperty " + ictx);
			final UnallocatedMrketingDoc ejbRemote = new UnallocatedMrketingDoc();
			System.out.println(" @ Amit ejbRemote " + ejbRemote);
			unAllocDocMap = (Map<String, ArrayList<String>>) ejbRemote.addDocument();
			System.out.println("@ Amit unAllocDocMap " + unAllocDocMap);
			final String maxDocumentTime = ejbRemote.getDocumentTime();
			System.out.println("@ Amit >>  maxDocumentTime" + maxDocumentTime);
			final ServletContext ctx = contextEvent.getServletContext();
			System.out.println("@ Amit >>  ctx" + ctx);
			ctx.setAttribute("unAllocDocMapMarkt", (Object) unAllocDocMap);
			for (final Map.Entry<String, ArrayList<String>> unalloc : unAllocDocMap.entrySet()) {
				BaseLogger.info((Object) "--------------- In addDocument ---------------");
				BaseLogger.info(
						(Object) (String.valueOf(String.valueOf(unalloc.getValue().toString())) + " : Document added"));
			}
			System.out.println("before  MyTimerTask");
			final MyTimerTask task = new MyTimerTask(ctx, unAllocDocMap, (UnallocatedMrketingDocRemote) ejbRemote,
					maxDocumentTime);
			System.out.println("@ Amit task>> " + task);
			final Calendar calendar = Calendar.getInstance();
			final Date startTime = calendar.getTime();
			final Timer timer = new Timer();
			timer.scheduleAtFixedRate(task, startTime, 600000L);
			ctx.setAttribute("timer", (Object) timer);
			System.out.println("*** ENDED >> ServletContextListnerExpMkt is initialize ***");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	class MyTimerTask extends TimerTask {
		HashMap<String, ArrayList<String>> unAllocDocMap;
		UnallocatedMrketingDocRemote unallocatedDocEJBRemote;
		ServletContext ctx;
		String maxDocumentTime;
		String inProcessDocids;

		MyTimerTask() {
		}

		MyTimerTask(final ServletContext ctx, final Map<String, ArrayList<String>> unAllocDocMap,
				final UnallocatedMrketingDocRemote unallocatedDocEJBRemote, final String maxDocumentTime) {
			System.out.println("Inside  MyTimerTask");
			this.unAllocDocMap = (HashMap<String, ArrayList<String>>) (HashMap) unAllocDocMap;
			this.unallocatedDocEJBRemote = unallocatedDocEJBRemote;
			this.ctx = ctx;
			this.maxDocumentTime = maxDocumentTime;
			this.inProcessDocids = this.inProcessDocids;
		}

		@Override
		public void run() {
			if (this.ctx.getAttribute("inProcessDocIds") != null) {
				this.inProcessDocids = (String) this.ctx.getAttribute("inProcessDocIds");
			}
			System.out.println("inProcessDocids = [" + this.inProcessDocids + "]");
			if (this.inProcessDocids != null && this.inProcessDocids.trim().length() > 2) {
				this.inProcessDocids = this.inProcessDocids.substring(1, this.inProcessDocids.length() - 2);
				this.inProcessDocids = this.inProcessDocids.trim();
			}
			System.out.println("inProcessDocids = [" + this.inProcessDocids + "]");
			this.unAllocDocMap = (HashMap<String, ArrayList<String>>) this.unallocatedDocEJBRemote.appendDocument();
			System.out.println(
					"@ Amit unAllocDocMap inside the HashMap<String, ArrayList<String>>) " + this.unAllocDocMap);
			final Map<String, ArrayList<String>> newUnAllocDocMap = (Map<String, ArrayList<String>>) this.ctx
					.getAttribute("unAllocDocMapMarkt");
			System.out.println("");
			ArrayList<String> newArrayList = new ArrayList<String>();
			String objName = "";
			for (final Map.Entry<String, ArrayList<String>> entry : this.unAllocDocMap.entrySet()) {
				System.out.println(String.valueOf(String.valueOf(entry.getKey())) + " : " + entry.getValue());
				objName = entry.getKey();
				newArrayList = entry.getValue();
				if (newUnAllocDocMap.containsKey(objName)) {
					BaseLogger.info((Object) "--------------- In appendDocument ---------------");
					final ArrayList<String> oldArrayList = newUnAllocDocMap.get(objName);
					for (int i = 0; i < newArrayList.size(); ++i) {
						if (!oldArrayList.contains(newArrayList.get(i))) {
							oldArrayList.add(newArrayList.get(i));
							System.out.println("New element add in list = " + newArrayList.get(i));
							BaseLogger.info((Object) ("[" + newArrayList.get(i) + "] : Document added"));
						}
					}
					newUnAllocDocMap.put(objName, oldArrayList);
				} else {
					newUnAllocDocMap.put(objName, newArrayList);
				}
			}
			for (final Map.Entry<String, ArrayList<String>> entry : newUnAllocDocMap.entrySet()) {
				System.out.println(String.valueOf(String.valueOf(entry.getKey())) + " : " + entry.getValue() + " "
						+ new Date().toString());
			}
			this.ctx.setAttribute("unAllocDocMapMarkt", (Object) newUnAllocDocMap);
			this.maxDocumentTime = this.unallocatedDocEJBRemote.getDocumentTime();
		}
	}
}