<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body onload="formatDate(); checkType();">
<script type="text/javascript" src="/ibase/webitm/js/PeriodStatUpdWiz.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>
<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<script language="Javascript" src="/ibase/webitm/js/date.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.core.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.widget.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.position.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.menu.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.autocomplete.js"></script>
		
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/PeriodStatUpdWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>

<script>
<![CDATA[
	$(document).on("keydown", function (e) {
    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
        e.preventDefault();
    }
    else if(e.which ===13){
    	 e.preventDefault();
    }
});
]]>
</script>

<form name="PeriodStatUpdWizform1" id="PeriodStatUpdWizform1" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" >
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:100%;padding:12px; background-color:white;top:0px;">
		&#160;&#160;<img src="/ibase/images/menuImages/web/plistgen_wiz.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px; height: 20px; width: 20px;"/>
		&#160;Period Status Update
	</div><br></br><br></br>
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:99%;position:absolute;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
                    </td>
                </tr>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
	
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div id="mainPage-input-Container">
			<xsl:for-each select="//Detail1">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:variable name="fin_entity"><xsl:value-of select="fin_entity"/></xsl:variable>
				<xsl:variable name="prd_code__from"><xsl:value-of select="prd_code__from"/></xsl:variable>
				<xsl:variable name="prd_code__to"><xsl:value-of select="prd_code__to"/></xsl:variable>
				
				
				
				<table id="activityTable" border="0" cellSpacing="1" cellPadding="0" style="margin-bottom:25px;">
					
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="left"  >
							Financial Entity :
						</td>
						<td class="td_leftAlign"   >
							<input type="text" class="input_editable" value="{$fin_entity}"  popupFldName="FIN_ENTITY" name="Detail1.{normalize-space($dbID)}.fin_entity" id="Detail1.{normalize-space($dbID)}.fin_entity" onfocus="displayPopUpIcon('popUpIcon3');" onkeyup="getAutoPopupData(this);"  style="width:51%;" tabIndex="40"/>
<a href="javascript:getListOfValues('FIN_ENTITY','Detail1.{normalize-space($dbID)}.fin_entity','','');" id="popUpIcon3"  tabIndex="-1" ><img src="/ibase/webitm/images/pophelp.png"/></a>
						</td>
					</tr>

                    <tr>
						<td class="td_rightAlign" nowrap="true" valign="left"  >
							Period From :
						</td>
						<td class="td_leftAlign"   >
							<input type="text" class="input_editable" value="{$prd_code__from}"  popupFldName="PRD_CODE__FROM" name="Detail1.{normalize-space($dbID)}.prd_code__from" id="Detail1.{normalize-space($dbID)}.prd_code__from" onfocus="displayPopUpIcon('popUpIcon4');" onkeyup="getAutoPopupData(this);"  style="width:51%;" tabIndex="40"/>
<a href="javascript:getListOfValues('PRD_CODE__FROM','Detail1.{normalize-space($dbID)}.prd_code__from','','');" id="popUpIcon4"  tabIndex="-1" ><img src="/ibase/webitm/images/pophelp.png"/></a>
						</td>
					</tr>

                    <tr>
						<td class="td_rightAlign" nowrap="true" valign="left"  >
							Period To :
						</td>
						<td class="td_leftAlign"   >
							<input type="text" class="input_editable" value="{$prd_code__to}"  popupFldName="PRD_CODE__TO" name="Detail1.{normalize-space($dbID)}.prd_code__to" id="Detail1.{normalize-space($dbID)}.prd_code__to" onfocus="displayPopUpIcon('popUpIcon5');" onkeyup="getAutoPopupData(this);"  style="width:51%;" tabIndex="40"/>
<a href="javascript:getListOfValues('PRD_CODE__TO','Detail1.{normalize-space($dbID)}.prd_code__to','','');" id="popUpIcon5"  tabIndex="-1" ><img src="/ibase/webitm/images/pophelp.png"/></a>
						</td>
					</tr>


					
				</table>
			</xsl:for-each>
		</div>
		<div id="btnDiv">
			<input type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden" value="periodStatUpd_wiz" name="OBJ_NAME" />
			<input type="hidden" value="next" name="action" id="action" />
				<input type="reset" style="cursor:hand;margin-left:5px;" value="Reset" class="button" title='Reset' id="reset"/>
			<input type="submit" style="cursor:hand;margin-left:2px;" value="Next" onclick="setActionVal('next');" class="button" title='Next' id="next"/>
		</div>
	</div>
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait work in progress" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
