/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.utility;

import ibase.bi.ejb.session.BusinessAreaEJB;
import ibase.bi.ejb.session.DBAccessEJB;
import ibase.bi.utility.BIException;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserBIInfoBean
implements Serializable {
    private String profileID = null;
    private String user = null;
    private String siteCode = null;
    private int userLevel = -1;
    private ArrayList baIdList = new ArrayList();
    private ArrayList baUserLevList = new ArrayList();

    public UserBIInfoBean(HashMap userInfoMap) throws Exception {
        try {
            this.setProfileID((String)userInfoMap.get("PROFILE_ID"));
            this.setUser((String)userInfoMap.get("USER"));
            this.setSiteCode((String)userInfoMap.get("SITE_CODE"));
            this.setUserLevel(this.getUserLevelFromDB((String)userInfoMap.get("USER")));
            String fileStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + this.getUser() + File.separator + "js" + File.separator + "Schematree.js";
            File file = new File(fileStr);
            if (file.exists()) {
                BaseLogger.log("1", null, null, String.valueOf(file.getName()) + " Exists");
            } else {
                AppConnectParm appConnect = new AppConnectParm("bi");
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                BusinessAreaEJB businessAreaEJB = new BusinessAreaEJB();
                String baInfoXML = businessAreaEJB.getBusinessAreaTreeXML((String)userInfoMap.get("USER"));
                if (baInfoXML != null) {
                    this.populateBaInfo(baInfoXML, (String)userInfoMap.get("USER"));
                }
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private int getUserLevelFromDB(String user) throws Exception {
        int userLevel = -1;
        try {
            AppConnectParm appConnect = new AppConnectParm("bi");
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            userLevel = dbAccessEJB.getUserLevel(user);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return userLevel;
    }

    public String getJSTree(String xmlStr) throws Exception {
        StringBuffer menu = new StringBuffer();
        try {
            BaseLogger.log("3", null, null, "In getJSTree");
            menu.append("var tr; \n if (document.getElementById) {\n");
            menu.append("var tree = new WebFXTree('My Schemas');\n");
            if (xmlStr != null && xmlStr.length() > 0) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                ByteArrayInputStream baIn = new ByteArrayInputStream(xmlStr.getBytes());
                Document doc = db.parse(baIn);
                NodeList ndList = doc.getElementsByTagName("SCHEMA_TREE");
                Node rootNode = ndList.item(0);
                menu.append(this.buildChildNodes(rootNode, "tree"));
            }
            menu.append("}\n");
            menu.append("function loadTree(id)\n {\n");
            menu.append("tr = document.all[id];\n");
            menu.append("tr.insertAdjacentHTML(\"BeforeEnd\",tree);\n");
            menu.append("}\n");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: BusinessAreaEJB: getJSTree: ==>\n" + e);
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return menu.toString();
    }

    public StringBuffer buildChildNodes(Node node, String value) throws Exception {
        StringBuffer newMenu = new StringBuffer();
        try {
            NodeList tempNodeList = node.getChildNodes();
            int tempHierCnt = 1;
            int tempBaCnt = 1;
            int i = 0;
            while (i < tempNodeList.getLength()) {
                String tempVar;
                Node ndHier = tempNodeList.item(i);
                if (ndHier.getNodeName().startsWith("HIERKEY_LEVEL_")) {
                    String itemName = ndHier.getAttributes().getNamedItem("TITLE").getNodeValue();
                    String iconPath = ndHier.getAttributes().getNamedItem("ICON").getNodeValue();
                    String descr = ndHier.getFirstChild().getNodeValue();
                    tempVar = String.valueOf(value) + "_" + tempHierCnt;
                    if (iconPath.equalsIgnoreCase("null")) {
                        iconPath = "/ibase/bi/images/foldericon.png";
                        newMenu.append("var " + tempVar + " = new WebFXTreeItem('" + itemName + "'," + tempVar + ",'','','" + iconPath + "','','" + descr + "');\n");
                    } else {
                        newMenu.append("var " + tempVar + " = new WebFXTreeItem('" + itemName + "'," + tempVar + ",'','','" + iconPath + "','" + iconPath + "','" + descr + "');\n");
                    }
                    newMenu.append(this.buildChildNodes(ndHier, tempVar));
                    newMenu.append(String.valueOf(value) + ".add(" + tempVar + ");\n");
                    ++tempHierCnt;
                }
                if (ndHier.getNodeName().startsWith("BUSINESS_AREA_")) {
                    String schemaName = ndHier.getAttributes().getNamedItem("SCHEMA_NAME").getNodeValue();
                    String itemName = ndHier.getAttributes().getNamedItem("BA_TITLE").getNodeValue();
                    String iconPath = ndHier.getAttributes().getNamedItem("ICON").getNodeValue();
                    tempVar = String.valueOf(value) + "_b" + tempBaCnt;
                    String lev = ndHier.getAttributes().getNamedItem("USR_ACC_LEV").getNodeValue();
                    int baID = Integer.parseInt(ndHier.getAttributes().getNamedItem("BA_ID").getNodeValue());
                    String descr = ndHier.getFirstChild().getNodeValue();
                    this.baIdList.add(new Integer(ndHier.getAttributes().getNamedItem("BA_ID").getNodeValue()));
                    if (!lev.equalsIgnoreCase("null") && lev.length() > 0) {
                        int usrAccLev = Integer.parseInt(lev);
                        this.baUserLevList.add(new Integer(usrAccLev));
                    } else {
                        this.baUserLevList.add(new Integer(this.userLevel));
                    }
                    if (iconPath.equalsIgnoreCase("null")) {
                        iconPath = "/ibase/bi/images/file.png";
                        newMenu.append("var " + tempVar + " = new WebFXTreeItem('" + itemName + "','" + baID + "','showtree.jsp?baID=" + baID + "&baName=" + schemaName + "&edit=false','','" + iconPath + "','','" + descr + "');\n");
                    } else {
                        newMenu.append("var " + tempVar + " = new WebFXTreeItem('" + itemName + "','" + baID + "','showtree.jsp?baID=" + baID + "&baName=" + schemaName + "&edit=false','','" + iconPath + "','" + iconPath + "','" + descr + "');\n");
                    }
                    newMenu.append(String.valueOf(value) + ".add(" + tempVar + ");\n");
                    ++tempBaCnt;
                }
                ++i;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        BaseLogger.log("2", null, null, "baId List " + this.baIdList);
        BaseLogger.log("2", null, null, "baUserLevList " + this.baUserLevList);
        return newMenu;
    }

    public void fileWriter(String xmlFile, String userCode) throws Exception {
        try {
            String dirStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + userCode + File.separator + "js" + File.separator;
            File dir = new File(dirStr);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileWriter fw = new FileWriter(String.valueOf(dirStr) + "Schematree.js");
            fw.write(xmlFile);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void populateBaInfo(String baInfoXML, String userCode) throws Exception {
        try {
            BaseLogger.log("3", null, null, "In populateBaInfo");
            String jsStr = this.getJSTree(baInfoXML);
            this.fileWriter(jsStr, userCode);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public int getUsrLevForBAID(int baId) throws Exception {
        int usrLev = this.userLevel;
        try {
            int index = this.baIdList.indexOf(new Integer(baId));
            if (index != -1) {
                usrLev = (Integer)this.baUserLevList.get(index);
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return usrLev;
    }

    public ArrayList getBAIDList() {
        return this.baIdList;
    }

    public ArrayList getBaUserLevList() {
        return this.baUserLevList;
    }

    private void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public String getProfileID() {
        return this.profileID;
    }

    private void setUserLevel(int userLevel) {
        BaseLogger.log("2", null, null, "Global userLevel :" + userLevel);
        this.userLevel = userLevel;
    }

    public int getUserLevel() {
        return this.userLevel;
    }

    private void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    private void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getSiteCode() {
        return this.siteCode;
    }
}

