/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.dao;

import ibase.hibernate.bean.Brand;
import ibase.hibernate.bean.BrandContents;
import ibase.hibernate.bean.UserPres;
import ibase.hibernate.utility.HibernateUtil;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.Transformers;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserPresDAO {
    public List<UserPres> getAllUsersPresentation(String userId, String tranDB) {
        List<UserPres> userPresList = new ArrayList<UserPres>();
        try {
            BaseLogger.log("3", null, null, "Inside getAllUsersPresentation userId Start: [" + userId + "]");
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getAllUsersPresentation userId: [" + userId + "]");
            org.hibernate.query.Query query = session.createQuery("from UserPres where userId='" + userId + "' and pres_to_date >= sysdate");
            userPresList = query.getResultList();
            for (UserPres userPres : userPresList) {
                JSONObject presAudienceDetails = this.getPresAudienceDetails(userPres, tranDB);
                userPres.setPresAudienceDetails(presAudienceDetails);
            }
            BaseLogger.log("3", null, null, "getAllUsersPresentation to getAllPresntaion of user END ::" + userPresList);
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return userPresList;
    }

    public List<UserPres> getUsersPresentation(String presId, String userId, String tranDB) {
        List<UserPres> userPresList = new ArrayList<UserPres>();
        try {
            BaseLogger.log("3", null, null, "Inside getUsersPresentation presId Start: [" + presId + "]");
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getAllUsersPresentation presId: [" + presId + "]");
            org.hibernate.query.Query query = session.createQuery("from UserPres where presId='" + presId + "' and userId='" + userId + "'");
            userPresList = query.getResultList();
            BaseLogger.log("3", null, null, "getAllUsersPresentation to getAllPresntaion of user END ::" + userPresList);
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return userPresList;
    }

    public void deleteUserPres(String presId, String userId, String tranDB) {
        BaseLogger.log("2", null, null, " updateUserPres IN DAO: PRES ID:[" + presId + "] USER ID:[" + userId + "]");
        List userPresList = new ArrayList();
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getuserPres presId: [" + presId + "] userId: [" + userId + "]");
            org.hibernate.query.Query query = session.createQuery("from UserPres where presId='" + presId + "' and  userId='" + userId + "'");
            userPresList = query.getResultList();
            BaseLogger.log("3", null, null, "deleteUserPres  ::" + userPresList);
            Transaction tx = session.beginTransaction();
            for (UserPres userPresDoc : userPresList) {
                BaseLogger.log("3", null, null, "deleteUserPres of delete  ::");
                session.delete((Object)userPresDoc);
            }
            tx.commit();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    public UserPres addOrUpdateUserPres(JSONObject data, String userId, String tranDB) throws ITMException {
        String presId = data.optString("presId");
        BaseLogger.log("2", null, null, " updateUserPres IN DAO: PRES ID:[" + userId + "] USER ID:[" + userId + "] DATA:[" + data + "]");
        UserPres userPresDoc = null;
        UserPres updatedPres = null;
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getuserPres userId: [" + userId + "]");
            userPresDoc = this.getPresentation(presId, userId, tranDB);
            BaseLogger.log("3", null, null, "userPresDoc in updateStatus ::" + userPresDoc);
            Transaction tx = session.beginTransaction();
            if (userPresDoc == null) {
                userPresDoc = new UserPres();
                presId = this.generatePresID(userId, tranDB);
                userPresDoc.setPresId(presId);
                userPresDoc.setUserId(userId);
                userPresDoc.setAddDate(new Date());
                userPresDoc.setAddUser(userId);
                userPresDoc.setAddTerm(userId);
            }
            userPresDoc.setPresPurpose(data.optString("presPurpose"));
            userPresDoc.setPresAudience(data.optString("presAudience"));
            userPresDoc.setPresDetail(data.optString("presDetail"));
            userPresDoc.setPresNote(data.optString("presNote"));
            userPresDoc.setPresDescr(data.optString("presDescr"));
            userPresDoc.setPresFromDate(this.getDateObj(data.optString("presFromDate")));
            userPresDoc.setPresToDate(this.getDateObj(data.optString("presToDate")));
            userPresDoc.setChgDate(new Date());
            userPresDoc.setChgUser(userId);
            userPresDoc.setChgTerm(userId);
            session.saveOrUpdate((Object)userPresDoc);
            tx.commit();
            session.close();
            updatedPres = this.getPresentation(presId, userId, tranDB);
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException inside addOrUpdateUserPres:");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception inside addOrUpdateUserPres:");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return updatedPres;
    }

    public UserPres getPresentation(String presId, String userId, String tranDB) {
        UserPres userPresDoc = null;
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getPresentation userId: [" + userId + "]");
            org.hibernate.query.Query query = session.createQuery("from UserPres where presId='" + presId + "' and  userId='" + userId + "'");
            List userPresList = query.getResultList();
            BaseLogger.log("3", null, null, "contentList in updateStatus ::" + userPresList);
            if (userPresList.size() > 0) {
                userPresDoc = (UserPres)userPresList.get(0);
                JSONObject presAudienceDetails = this.getPresAudienceDetails(userPresDoc, tranDB);
                userPresDoc.setPresAudienceDetails(presAudienceDetails);
            }
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return userPresDoc;
    }

    public List<Brand> getBrands(String tranDB, String itemSer, String scCodeStr) {
        List<Brand> brandList = new ArrayList<Brand>();
        BaseLogger.log("2", null, null, "scCodeStr [" + scCodeStr + "]");
        try {
            String brandCodeStr;
            org.hibernate.query.Query brandListQuery;
            BaseLogger.log("3", null, null, "Inside getUsersPresentation presId Start: [" + itemSer + "]");
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getBrands itemSer: [" + itemSer + "]");
            NativeQuery query = session.createNativeQuery("select b.brand_code from brand b where b.item_ser = '" + itemSer + "' " + "UNION ALL " + "select b.brand_code " + "from brand b, strg_product sp " + "where b.brand_code = sp.brand_code " + "and sp.sc_code in (" + scCodeStr + ") " + "and sp.brand_code not in (select brand_code from brand where b.item_ser = '" + itemSer + "') " + "and sp.valid_from <= sysdate " + "and sp.valid_to >= sysdate ");
            List brandCodeList = query.getResultList();
            BaseLogger.log("3", null, null, "getAllUsersPresentation to getAllPresntaion of user END ::" + brandCodeList);
            if (brandCodeList.size() > 0 && (brandList = (brandListQuery = session.createQuery("from Brand where brand_code in (" + (brandCodeStr = this.getEnclosedString(brandCodeList)) + ") order by pitch_priority ")).getResultList()) != null) {
                for (Brand brand : brandList) {
                    if (brand.getBrand_code() == null) continue;
                    JSONArray brandContentsArray = new JSONArray();
                    List<BrandContents> brandContents = this.getBrandContents(tranDB, brand.getBrand_code());
                    if (brandContents != null) {
                        BaseLogger.log("3", null, null, "BrandContents : [" + brandContents + "][" + brandContents.size() + "]");
                        for (BrandContents brandContent : brandContents) {
                            brandContentsArray.put((Object)new JSONObject((Object)brandContent));
                        }
                    }
                    BaseLogger.log("3", null, null, "brandContentsArray[" + brandContentsArray + "]");
                    brand.setBrandContents(brandContentsArray);
                    brand.setBrandContentList(brandContents);
                }
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return brandList;
    }

    private List<BrandContents> getBrandContents(String tranDB, String brandCode) {
        List<BrandContents> brandContents = new ArrayList<BrandContents>();
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Query query = session.createQuery(" SELECT dtl.refId as refId, dc.docId as docId, dc.docName as docName, dc.docType as docType,  dc.docPages as docPages, dtl.refSer as refSer, dtl.docTypeAttach as docTypeAttach, dtl.pageInfo as pageInfo  FROM DocContents dc, DocTransLink dtl, ObjAttachConfig oac  where dc.docId = dtl.docId   and dtl.refSer = 'BRAND'  and dtl.refId = '" + brandCode.trim() + "' " + " and dtl.docTypeAttach = oac.doc_type " + " and oac.obj_name = 'product' " + " and oac.doc_purpose = 'P' " + " order by dtl.refId, dtl.docId ").setResultTransformer(Transformers.aliasToBean(BrandContents.class));
            brandContents = query.list();
            if (brandContents != null) {
                BaseLogger.log("3", null, null, "BrandContents : [" + brandContents + "][" + brandContents.size() + "]");
            }
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("3", null, null, "HibernateException :");
            BaseLogger.log("3", null, null, e.getMessage());
        }
        return brandContents;
    }

    private String getEnclosedString(List<String> docIdList) {
        StringBuffer buffer = new StringBuffer();
        int len = 0;
        for (String docId : docIdList) {
            buffer.append("'").append(docId.trim()).append("'");
            if (++len >= docIdList.size()) continue;
            buffer.append(",");
        }
        if (buffer.length() == 0) {
            buffer.append("''");
        }
        BaseLogger.log("2", null, null, "Inside getEnclosedString buffer: [" + buffer + "]");
        return buffer.toString();
    }

    public Date getDateObj(String dateStr) throws ITMException {
        E12GenericUtility e12Utility = new E12GenericUtility();
        Date dateObj = e12Utility.getDateObject(dateStr);
        BaseLogger.log("2", null, null, "Date String :: [" + dateStr + " ] Date Object:" + dateObj);
        return dateObj;
    }

    private String generatePresID(String userId, String tranDB) {
        String presentationID;
        block22: {
            presentationID = "";
            Statement pStmt = null;
            ResultSet rSet = null;
            String refSer = "";
            String tranIdCol = "";
            String keyString = "";
            Connection conn = null;
            try {
                try {
                    ConnDriver mConnDriver = new ConnDriver();
                    conn = mConnDriver.getConnectDB(tranDB);
                    if (conn != null) {
                        String transSql = "SELECT REF_SER,TRAN_ID_COL,KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW  = 'w_user_pres'";
                        pStmt = conn.prepareStatement(transSql);
                        rSet = pStmt.executeQuery();
                        if (rSet.next()) {
                            refSer = rSet.getString("REF_SER") == null ? "" : rSet.getString("REF_SER").trim();
                            keyString = rSet.getString("KEY_STRING") == null ? "" : rSet.getString("KEY_STRING").trim();
                        }
                        BaseLogger.log("3", null, null, "refSer[" + refSer + "]tranIdCol[" + tranIdCol + "]keyString[" + keyString + "]");
                        TransIDGenerator tranIDGenerator = new TransIDGenerator("<Root></Root>", userId, CommonConstants.DB_NAME);
                        presentationID = tranIDGenerator.generateTranSeqID(refSer, tranIdCol, keyString, conn);
                    }
                }
                catch (Exception exp) {
                    BaseLogger.log("0", null, null, "Exception In generatePresID......");
                    exp.printStackTrace();
                    try {
                        if (rSet != null) {
                            rSet.close();
                            rSet.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                            pStmt.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                            conn = null;
                        }
                        break block22;
                    }
                    catch (Exception expRsc) {
                        BaseLogger.log("0", null, null, "Exception In generatePresID...Finally...");
                        expRsc.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rSet != null) {
                        rSet.close();
                        rSet.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt.close();
                    }
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception expRsc) {
                    BaseLogger.log("0", null, null, "Exception In generatePresID...Finally...");
                    expRsc.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rSet != null) {
                    rSet.close();
                    rSet.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt.close();
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception expRsc) {
                BaseLogger.log("0", null, null, "Exception In generatePresID...Finally...");
                expRsc.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "Return presentationID......[" + presentationID + "]");
        return presentationID;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject getPresAudienceDetails(UserPres userPres, String transDB) {
        block15: {
            presAudienceDetails = new JSONObject();
            if (userPres != null) {
                presPurpose = userPres.getPresPurpose();
                presAudience = userPres.getPresAudience();
                tableName = "";
                columnNames = "";
                condition = "";
                var9_10 = presPurpose;
                tmp = -1;
                switch (var9_10.hashCode()) {
                    case 49: {
                        if (!var9_10.equals("1")) break;
                        tmp = 1;
                        break;
                    }
                    case 50: {
                        if (!var9_10.equals("2")) break;
                        tmp = 2;
                        break;
                    }
                    case 51: {
                        if (!var9_10.equals("3")) break;
                        tmp = 3;
                        break;
                    }
                    case 52: {
                        if (!var9_10.equals("4")) break;
                        tmp = 4;
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        tableName = " STRG_CUSTOMER ";
                        columnNames = " SC_CODE, FIRST_NAME || ' ' || LAST_NAME AS SC_NAME ";
                        condition = " WHERE SC_CODE IN (" + this.getEnclosedString(presAudience) + ") ";
                        presAudienceDetails = this.getDBColumnValues(tableName, columnNames, condition, transDB);
                        break;
                    }
                    case 3: {
                        this.getEnclosedString(presAudience);
                        tableName = " STRG_CUST_CLASS ";
                        columnNames = " CLASS_CODE, CLASS_CODE_DESCR ";
                        condition = " WHERE CLASS_CODE IN (" + this.getEnclosedString(presAudience) + ") ";
                        presAudienceDetails = this.getDBColumnValues(tableName, columnNames, condition, transDB);
                        break;
                    }
                    case 4: {
                        tableName = " SPECIALITY ";
                        columnNames = " SPL_CODE, DESCR ";
                        condition = " WHERE SPL_CODE IN (" + this.getEnclosedString(presAudience) + ") ";
                        presAudienceDetails = this.getDBColumnValues(tableName, columnNames, condition, transDB);
                        break;
                    }
                    default: {
                    }
                }
            }
            break block15;
            {
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception In getPresAudienceDetails...");
                    e.printStackTrace();
                }
            }
            break block15;
            {
                ** case 1:
            }
        }
        BaseLogger.log("2", null, null, " presAudienceDetails[" + presAudienceDetails + "]");
        return presAudienceDetails;
    }

    private String getEnclosedString(String commaSepValues) {
        String[] docIdList;
        StringBuffer buffer = new StringBuffer();
        int len = 0;
        String[] stringArray = docIdList = commaSepValues.split(",");
        int n = docIdList.length;
        int n2 = 0;
        while (n2 < n) {
            String docId = stringArray[n2];
            buffer.append("'").append(docId.trim()).append("'");
            if (++len < docIdList.length) {
                buffer.append(",");
            }
            ++n2;
        }
        if (buffer.length() == 0) {
            buffer.append("''");
        }
        BaseLogger.log("0", null, null, "Inside getEnclosedString buffer: [" + buffer + "]");
        return buffer.toString();
    }

    private JSONObject getDBColumnValues(String tableName, String columnsName, String condition, String transDB) throws ITMException {
        String sql = "";
        JSONObject returnValueObj = new JSONObject();
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                if (transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0) {
                    conn = connDriver.getConnectDB(transDB);
                    sql = " SELECT " + columnsName + " FROM " + tableName + " " + condition;
                    pstmt = conn.prepareStatement(sql);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String columnName = rs.getString(1);
                        String columnValue = rs.getString(2);
                        returnValueObj.put(columnName.trim(), (Object)columnValue);
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
            }
            catch (Exception exp) {
                BaseLogger.log("0", null, null, "Excepton in getDBColumnValues -- >" + exp.getMessage());
                exp.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException se) {
                    BaseLogger.log("0", null, null, "Excepton in getDBColumnValues ... Finally-- >");
                    se.printStackTrace();
                    throw new ITMException(se);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                BaseLogger.log("0", null, null, "Excepton in getDBColumnValues ... Finally-- >");
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return returnValueObj;
    }
}

