/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.XSLBuilderLocal;
import ibase.webitm.ejb.XSLBuilderRemote;
import ibase.webitm.utility.DW2XSLGenerator;
import ibase.webitm.utility.I18NLabel;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.w3c.dom.Document;

@Stateless
public class XSLBuilderEJB
implements XSLBuilderRemote,
XSLBuilderLocal {
    @Resource
    private SessionContext cSessionContext;

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    @Override
    public String buildXSLString(String oName, String oContext, String user_lang, String user_country, String pContext, String editFlag, String appCtxPath, HashMap<String, String> propEditorInfoMap, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "Building XSL Str......");
        String xslString = null;
        try {
            BaseLogger.log("3", userInfo, null, "CommonConstants.XSL_VERSION [" + CommonConstants.XSL_VERSION + "]");
            if ("2".equals(CommonConstants.XSL_VERSION)) {
                DW2XSLGenerator xslGen = new DW2XSLGenerator(oName, oContext, pContext, editFlag, userInfo);
                xslString = xslGen.generateXSLString(userInfo);
            } else {
                I18NLabel localizer = new I18NLabel();
                Document metaDataDoc = localizer.setLocaleLabels(oName, oContext, user_lang, user_country, pContext, editFlag, propEditorInfoMap, userInfo);
                BaseLogger.log("3", userInfo, null, "APPLICATION_CONTEXT :" + appCtxPath + "]");
                xslString = localizer.getXSL(editFlag, appCtxPath, this.getObjParamMap(oName, oContext, userInfo), userInfo);
            }
            StringBuffer xslStrinBuff = new StringBuffer(xslString);
            xslString = xslStrinBuff.toString();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: XSLBuilderEJB: buildXSLString:==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: XSLBuilderEJB: buildXSLString:==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }

    private ArrayList getTokenList(String tokenString, String delimiter) throws Exception {
        BaseLogger.log("2", null, null, "[XSLBuilderEJB]Getting arraylist from the string :" + tokenString + ": delimiter :" + delimiter + ":");
        ArrayList<String> returnList = null;
        if (tokenString != null && tokenString.length() > 0 && tokenString != "") {
            returnList = new ArrayList<String>();
            if (delimiter.length() == 1) {
                while (tokenString.indexOf(delimiter) != -1) {
                    int endIndex = tokenString.indexOf(delimiter);
                    returnList.add(tokenString.substring(0, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
                returnList.add(tokenString.substring(0, tokenString.length()));
            } else if (delimiter.length() == 2 && (delimiter.equals("[]") || delimiter.equals("{}") || delimiter.equals("()"))) {
                while (tokenString.indexOf(delimiter.substring(0, 1)) != -1) {
                    int endIndex = tokenString.indexOf(delimiter.substring(1));
                    returnList.add(tokenString.substring(1, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
            }
        }
        return returnList;
    }

    @Override
    public String buildXSLString(String oName, String oContext, String user_lang, String user_country, String pContext, String editFlag, String appCtxPath, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "Building XSL Str2......");
        String xslString = null;
        try {
            BaseLogger.log("3", userInfo, null, "CommonConstants.XSL_VERSION [" + CommonConstants.XSL_VERSION + "]");
            if ("2".equals(CommonConstants.XSL_VERSION)) {
                DW2XSLGenerator xslGen = new DW2XSLGenerator(oName, oContext, pContext, editFlag, userInfo);
                xslString = xslGen.generateXSLString(userInfo);
            } else {
                I18NLabel localizer = new I18NLabel();
                Document metaDataDoc = localizer.setLocaleLabels(oName, oContext, user_lang, user_country, pContext, editFlag, userInfo.getTransDB());
                BaseLogger.log("3", userInfo, null, "APPLICATION_CONTEXT :" + appCtxPath + "]");
                xslString = localizer.getXSL(editFlag, appCtxPath, this.getObjParamMap(oName, oContext, userInfo), userInfo);
            }
            StringBuffer xslStrinBuff = new StringBuffer(xslString);
            xslString = xslStrinBuff.toString();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: XSLBuilderEJB: buildXSLString:==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: XSLBuilderEJB: buildXSLString:==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }

    @Override
    public String buildXSLString(String oName, String oContext, String user_lang, String user_country, String pContext, String editFlag, String appCtxPath, String profileIdRes, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "Building XSL Str4......");
        String xslString = null;
        try {
            BaseLogger.log("3", userInfo, null, "CommonConstants.XSL_VERSION [" + CommonConstants.XSL_VERSION + "]");
            if ("2".equals(CommonConstants.XSL_VERSION)) {
                DW2XSLGenerator xslGen = new DW2XSLGenerator(oName, oContext, pContext, editFlag, userInfo);
                xslString = xslGen.generateXSLString(userInfo);
            } else {
                I18NLabel localizer = new I18NLabel();
                String editor = "";
                if ((profileIdRes = E12GenericUtility.checkNull(profileIdRes)).length() > 0 && profileIdRes.indexOf("~~SEP~~") != -1) {
                    String[] profileIdResNEditor = profileIdRes.split("~~SEP~~");
                    int i = 0;
                    while (i < profileIdResNEditor.length) {
                        if (i == 0) {
                            profileIdRes = E12GenericUtility.checkNull(profileIdResNEditor[i]);
                        } else if (i == 1) {
                            editor = E12GenericUtility.checkNull(profileIdResNEditor[i]);
                        }
                        ++i;
                    }
                }
                HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
                propEditorInfoMap.put("PROFILE_ID_RES", profileIdRes);
                propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
                propEditorInfoMap.put("EDITOR", editor);
                propEditorInfoMap.put("USER_ID", userInfo.getLoginCode());
                Document metaDataDoc = localizer.setLocaleLabels(oName, oContext, user_lang, user_country, pContext, editFlag, propEditorInfoMap, userInfo);
                BaseLogger.log("3", userInfo, null, "APPLICATION_CONTEXT :" + appCtxPath + "]");
                xslString = localizer.getXSL(editFlag, appCtxPath, this.getObjParamMap(oName, oContext, userInfo), userInfo);
            }
            StringBuffer xslStrinBuff = new StringBuffer(xslString);
            xslString = xslStrinBuff.toString();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: XSLBuilderEJB: buildXSLString:==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: XSLBuilderEJB: buildXSLString:==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }

    private HashMap getObjParamMap(String objName, String objContext, UserInfoBean userInfo) throws ITMException {
        HashMap<String, Object> paramMap = null;
        try {
            BaseLogger.log("3", userInfo, null, "[XSLBuilderEJB]Object name set2...............");
            InitialContext initialContext = new InitialContext(new AppConnectParm().getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
            paramMap = new HashMap<String, Object>();
            if (objDetailMap != null) {
                paramMap.put("KEY_FLAG", objDetailMap.get("KEY_FLAG") != null ? (String)objDetailMap.get("KEY_FLAG") : "M");
                ArrayList taxList = this.getTokenList((String)objDetailMap.get("TAX_FORMS"), ",");
                Boolean isTaxApplicable = new Boolean(false);
                if (taxList != null && taxList.contains(objContext)) {
                    isTaxApplicable = new Boolean(true);
                }
                paramMap.put("IS_TAX_APPL", isTaxApplicable);
                paramMap.put("EDIT_TMPLT", objDetailMap.get("EDIT_TMPLT") != null ? new Integer((String)objDetailMap.get("EDIT_TMPLT")) : new Integer("0"));
            }
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :XSLBuilderEJB :setObjDetails :==>" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "[XSLBuilderEJB]Obj name and other initializations done !!!!!!!!!!!!!");
        return paramMap;
    }
}

