/*
 * Decompiled with CFR 0.152.
 */
package ibase.planner.servlet;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class E12CalendarExportToExcelServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        String fileName = null;
        String objName = "";
        String rcpEditorID = "";
        String[] fileString = new String[2];
        try {
            UserInfoBean userInfo = (UserInfoBean)session.getAttribute("USER_INFO");
            if (userInfo == null) {
                BaseLogger.log("3", null, null, "User info is null.....");
                RequestDispatcher rd = request.getRequestDispatcher("/jsp/DirectAccess.jsp?name=REFERER&value=");
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
            if ((objName = request.getParameter("objName")) == null || objName != null && objName.length() == 0) {
                objName = request.getParameter("OBJ_NAME");
            }
            if ((fileName = (rcpEditorID = request.getParameter("RCP_EDITOR_ID")) != null && rcpEditorID.length() > 0 ? String.valueOf(userInfo.getLoginCode()) + "_" + objName + "_" + rcpEditorID : request.getParameter("xmlFileName")).contains(".")) {
                fileString = fileName.split("\\.");
            } else {
                fileString[0] = fileName;
            }
            BaseLogger.log("3", null, null, " fileName [" + fileName + "] objName [" + objName + "]");
            HSSFWorkbook workBook = null;
            if (rcpEditorID == null || rcpEditorID.length() <= 0) {
                workBook = this.exportToExcel(fileName);
            }
            if (fileName != null && fileName != "" && workBook != null) {
                response.setContentType("application/vnd.ms-excel");
                String excelFileName = request.getParameter("downloadFileName");
                response.setHeader("Content-disposition", "filename=" + excelFileName + ".xls");
                ServletOutputStream out1 = response.getOutputStream();
                workBook.write((OutputStream)out1);
                out1.flush();
                out1.close();
                return;
            }
            BaseLogger.log("3", null, null, "No data available to export to excel. \nYou must have data on your list to export, Please search/view to fill the list and export");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HSSFWorkbook exportToExcel(String xmlFileName) {
        ArrayList outerList = new ArrayList();
        ArrayList<String> innerList = new ArrayList<String>();
        ArrayList<String> headerRow = new ArrayList<String>();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            doc = docBuilder.parse(new File(String.valueOf(CommonConstants.RIA_HDR_DATA_XMLFILE) + File.separator + xmlFileName));
            doc.getDocumentElement().normalize();
            BaseLogger.log("3", null, null, " Root element of the doc is :\" " + doc.getDocumentElement().getNodeName() + "\"");
            NodeList listOfDetail = null;
            listOfDetail = doc.getElementsByTagName("item");
            int totalDetail = listOfDetail.getLength();
            BaseLogger.log("3", null, null, "Total no of Detail : " + totalDetail);
            int i = 0;
            while (i < totalDetail) {
                Node firstDetailNode = listOfDetail.item(i);
                if (firstDetailNode.getNodeType() == 1) {
                    Element firstDetailElement = (Element)firstDetailNode;
                    NodeList nodeList = firstDetailElement.getChildNodes();
                    int detailListlength = nodeList.getLength();
                    BaseLogger.log("3", null, null, "detailListlength == " + detailListlength);
                    NodeList childNodeList1 = firstDetailElement.getElementsByTagName("id");
                    Element nodeValueElement1 = (Element)childNodeList1.item(0);
                    NodeList textList1 = nodeValueElement1.getChildNodes();
                    String value1 = textList1.item(0).getNodeValue();
                    if (!value1.equals("sprs_plan_bifur_BASE")) {
                        innerList = null;
                        headerRow = null;
                        innerList = new ArrayList();
                        headerRow = new ArrayList();
                        int j = 1;
                        while (j < detailListlength) {
                            String nodeName;
                            Node detailNodeElement = nodeList.item(j);
                            if (!(detailNodeElement.getNodeType() != 1 || (nodeName = detailNodeElement.getNodeName()).equalsIgnoreCase("bgColorCode") || nodeName.equalsIgnoreCase("bgColor") || nodeName.equalsIgnoreCase("defaultTransMode"))) {
                                headerRow.add(nodeName);
                                NodeList childNodeList = firstDetailElement.getElementsByTagName(nodeName);
                                Element nodeValueElement = (Element)childNodeList.item(0);
                                NodeList textList = nodeValueElement.getChildNodes();
                                if (textList != null && textList.item(0) != null && textList.item(0).getNodeValue() != null) {
                                    if ("eventStartDate".equalsIgnoreCase(nodeName)) {
                                        BaseLogger.log("3", null, null, "Event start date ===========[" + textList.item(0).getNodeValue().trim() + "]");
                                    }
                                    innerList.add(textList.item(0).getNodeValue().trim());
                                } else {
                                    innerList.add("");
                                }
                            }
                            ++j;
                        }
                    }
                    outerList.add(innerList);
                }
                ++i;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        HSSFWorkbook workbook = null;
        HSSFSheet sheet = null;
        try {
            workbook = new HSSFWorkbook();
            sheet = workbook.createSheet("Sample sheet");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Unable to create workbook");
        }
        HSSFCellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        HSSFFont font = sheet.getWorkbook().createFont();
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFont((Font)font);
        int cellNumHeader = 0;
        HSSFRow rowHeader = sheet.createRow(0);
        int i = 0;
        while (i < headerRow.size()) {
            Cell cell = rowHeader.createCell(cellNumHeader++);
            cell.setCellStyle((CellStyle)cellStyle);
            cell.setCellValue((String)headerRow.get(i));
            ++i;
        }
        int colNum = 0;
        int rownum = 1;
        for (List list : outerList) {
            HSSFRow row = sheet.createRow(rownum++);
            int cellnum = 0;
            for (String value : list) {
                Cell cell = row.createCell(cellnum++);
                cell.setCellValue(value);
                sheet.autoSizeColumn(colNum);
                ++colNum;
            }
        }
        return workbook;
    }
}

