/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.E12DataModelComponent;
import ibase.webitm.utility.ITMException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/data_model")
public class DataModelService {
    private UserInfoBean userInfo = null;

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    @GET
    @Path(value="/{dataModelName}")
    @Produces(value={"application/json"})
    public Response getData(@Context HttpServletRequest request, @PathParam(value="dataModelName") String dataModelName) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)("dataModel: [" + dataModelName + "]"));
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        String jsonString = "";
        if (userInfo != null) {
            jsonString = this.callDMDataJson(dataModelName, null, userInfo.toString());
        }
        return Response.status((int)200).entity((Object)jsonString).build();
    }

    @GET
    @Path(value="/{dataModelName}/{fieldValue}")
    @Produces(value={"application/json"})
    public Response getDataByParam(@Context HttpServletRequest request, @PathParam(value="dataModelName") String dataModelName, @PathParam(value="fieldValue") String fieldValue) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)("dataModelName: [" + dataModelName + "] fieldValue[" + fieldValue + "]"));
        String jsonString = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            jsonString = this.callDMDataJson(dataModelName, fieldValue, userInfo.toString());
        }
        return Response.status((int)200).entity((Object)jsonString).build();
    }

    public String callDMDataJson(String dataModelName, String fieldValue, String userInfo) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)"proteus-> getDMDataJson 2835");
        Class<?> classObj = null;
        String returnValue = null;
        Class[] paramSpec = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
        Object[] params = new Object[]{dataModelName, fieldValue, userInfo};
        if (userInfo != null) {
            try {
                classObj = Class.forName("ibase.webitm.ejb.dis.DataModelComponent");
                E12DataModelComponent e12DmCom = (E12DataModelComponent)classObj.newInstance();
                Method metObj = classObj.getMethod("getDMDataJson", paramSpec);
                metObj.setAccessible(true);
                Object retVal = metObj.invoke((Object)e12DmCom, params);
                returnValue = retVal.toString();
                BaseLogger.log((String)"2", null, null, (Object)("returnValue [" + returnValue + "]"));
                e12DmCom = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Exception :EventManagerEJB :callJB :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return returnValue;
    }

    @GET
    @Path(value="/datamodellist")
    @Produces(value={"application/json"})
    public Response getDataModelsList(@Context HttpServletRequest request) {
        BaseLogger.log((String)"3", null, null, (Object)"calling API for getting data models==>");
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            E12DataModelComponent e12DataModelComp = new E12DataModelComponent();
            try {
                String jsonString = e12DataModelComp.prepareDataModeldetail(userInfo.getLoginCode(), userInfo.getProfileId(), "SFA", true, userInfo, "", "", "", "");
                return Response.status((int)200).entity((Object)jsonString).build();
            }
            catch (ITMException e) {
                e.printStackTrace();
                return Response.status((int)500).entity((Object)("Error: " + e.getMessage())).build();
            }
        }
        return Response.status((int)200).entity((Object)"Error: Unauthorized Access").build();
    }

    @GET
    @Path(value="/getJSON/{modelName}")
    @Produces(value={"application/json"})
    public Response getDataModels(@PathParam(value="modelName") String modelName, @Context HttpServletRequest request) {
        BaseLogger.log((String)"3", null, null, (Object)("calling API for getting data models==>" + modelName));
        return Response.status((int)200).entity((Object)this.getDataModels(request, modelName)).build();
    }

    public String getDataModels(HttpServletRequest request, String dataModel) {
        try {
            UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            if (userInfo != null) {
                String format;
                E12DataModelComponent e12DataModelComponent = new E12DataModelComponent();
                String applName = null;
                BaseLogger.log((String)"3", null, null, (Object)("calling API for getting applName==>" + (applName == null)));
                boolean isMobile = false;
                String dataModelName = dataModel;
                String scopeParameters = "";
                String responseFormat = format = "JSON";
                String dataModelToDownload = "";
                BaseLogger.log((String)"3", null, null, (Object)"calling prepareDataModelDetailsJSON for getting data models==>");
                String dataModelValue = e12DataModelComponent.prepareDataModelDetailsJSON(userInfo.getLoginCode(), userInfo.getProfileId(), applName, isMobile, userInfo, dataModelName, scopeParameters, responseFormat, dataModelToDownload);
                return dataModelValue;
            }
            return "Error:Unauthorized Access";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error:" + e.getMessage();
        }
    }
}

