/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.bean.ExtAuthApplicationBean;
import ibase.bean.ExtAuthRespBean;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.DBAccessEJB;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class CryptographyUtil {
    public static String createBase64EncodedJWT(ExtAuthApplicationBean applicationBean, ExtAuthRespBean userBean, String sessionId) {
        String base64EncodedJWT = "";
        try {
            BaseLogger.log("3", null, null, "Inside CryptographyUtil :: createBase64EncodedJWT");
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
            if (applicationBean == null || applicationBean.equals(null)) {
                BaseLogger.log("3", null, null, "CryptographyUtil :: createBase64EncodedJWT :application bean is null");
                BaseLogger.log("3", null, null, "CryptographyUtil :: createBase64EncodedJWT");
                String sharedKey = "a3edd11a09ea4e0ccd09c6cd2828021b";
                BaseLogger.log("3", null, null, "CryptographyUtil :: createBase64EncodedJWT : Sign JWT with secret key");
                byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)sharedKey);
                SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
                JwtBuilder builder = Jwts.builder().setId(userBean.getUserId()).signWith(signatureAlgorithm, (Key)signingKey).claim("region", (Object)E12GenericUtility.checkNull(userBean.getRegion())).claim("designation", (Object)E12GenericUtility.checkNull(userBean.getDesignation())).claim("reportToCode", (Object)E12GenericUtility.checkNull(userBean.getReportToCode())).claim("name", (Object)(String.valueOf(E12GenericUtility.checkNull(userBean.getFirstName())) + " " + E12GenericUtility.checkNull(userBean.getLastName()))).claim("division", (Object)E12GenericUtility.checkNull(userBean.getDivision())).claim("email", (Object)E12GenericUtility.checkNull(userBean.getEmail())).claim("hq", (Object)E12GenericUtility.checkNull(userBean.getHq())).claim("entityType", (Object)E12GenericUtility.checkNull(userBean.getEntityType())).claim("entityCode", (Object)E12GenericUtility.checkNull(userBean.getEntityCode())).claim("enterprise", (Object)E12GenericUtility.checkNull(userBean.getEnterprise())).claim("transDB", (Object)E12GenericUtility.checkNull(userBean.getTransDb())).claim("loginSite", (Object)E12GenericUtility.checkNull(userBean.getLoginSite())).claim("profileId", (Object)E12GenericUtility.checkNull(userBean.getProfileId()));
                long ttlMillis = 15768000000000L;
                long nowMillis = System.currentTimeMillis();
                long expMillis = nowMillis + ttlMillis;
                Date exp = new Date(expMillis);
                builder.setExpiration(exp);
                BaseLogger.log("3", null, null, "Token Expiry Date:" + exp);
                BaseLogger.log("3", null, null, "CryptographyUtil :: createBase64EncodedJWT : Encode JWT with Base 64");
                base64EncodedJWT = DatatypeConverter.printBase64Binary((byte[])builder.compact().getBytes());
            } else {
                BaseLogger.log("3", null, null, "CryptographyUtil :: createBase64EncodedJWT :application bean is NOT null");
                BaseLogger.log("3", null, null, "CryptographyUtil :: createBase64EncodedJWT : Sign JWT with secret key");
                byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)applicationBean.getSharedKey());
                SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
                BaseLogger.log("3", null, null, "CryptographyUtil :: createBase64EncodedJWT : Creating JWT with secret key");
                JwtBuilder builder = Jwts.builder().setId(userBean.getUserId()).signWith(signatureAlgorithm, (Key)signingKey).claim("applicationId", (Object)E12GenericUtility.checkNull(applicationBean.getAppId())).claim("region", (Object)E12GenericUtility.checkNull(userBean.getRegion())).claim("designation", (Object)E12GenericUtility.checkNull(userBean.getDesignation())).claim("reportToCode", (Object)E12GenericUtility.checkNull(userBean.getReportToCode())).claim("name", (Object)(String.valueOf(E12GenericUtility.checkNull(userBean.getFirstName())) + " " + E12GenericUtility.checkNull(userBean.getLastName()))).claim("division", (Object)E12GenericUtility.checkNull(userBean.getDivision())).claim("email", (Object)E12GenericUtility.checkNull(userBean.getEmail())).claim("hq", (Object)E12GenericUtility.checkNull(userBean.getHq())).claim("entityType", (Object)E12GenericUtility.checkNull(userBean.getEntityType())).claim("entityCode", (Object)E12GenericUtility.checkNull(userBean.getEntityCode())).claim("enterprise", (Object)E12GenericUtility.checkNull(userBean.getEnterprise())).claim("transDB", (Object)E12GenericUtility.checkNull(userBean.getTransDb())).claim("loginSite", (Object)E12GenericUtility.checkNull(userBean.getLoginSite())).claim("profileId", (Object)E12GenericUtility.checkNull(userBean.getProfileId()));
                if (E12GenericUtility.checkNull(sessionId).length() > 0) {
                    builder.claim("sessionId", (Object)sessionId);
                }
                String isPermToken = "";
                DBAccessEJB dbAccess = new DBAccessEJB();
                isPermToken = dbAccess.getDBColumnValue("AUTH_APPS", "PERM_TOKEN", "APP_ID  = '" + applicationBean.getAppId() + "'", "Driver");
                BaseLogger.log("3", null, null, "isPermToken :: createBase64EncodedJWT :" + isPermToken);
                long ttlMillis = 0L;
                if (isPermToken.equalsIgnoreCase("Y")) {
                    ttlMillis = 15768000000000L;
                } else {
                    ttlMillis = applicationBean.getTtl() * 864000000L;
                    BaseLogger.log("3", null, null, "applicationBean.getTtl():" + applicationBean.getTtl());
                    BaseLogger.log("3", null, null, "ttlMillis:" + ttlMillis);
                }
                if (ttlMillis >= 0L) {
                    long nowMillis = System.currentTimeMillis();
                    long expMillis = nowMillis + ttlMillis;
                    Date exp = new Date(expMillis);
                    builder.setExpiration(exp);
                    BaseLogger.log("3", null, null, "Token Expiry Date:" + exp);
                }
                BaseLogger.log("3", null, null, "CryptographyUtil :: createBase64EncodedJWT : Encode JWT with Base 64");
                base64EncodedJWT = DatatypeConverter.printBase64Binary((byte[])builder.compact().getBytes());
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in CryptographyUtil :: createBase64EncodedJWT: " + e.getMessage());
        }
        return base64EncodedJWT;
    }

    public static String parseBase64EncodedJWT(String jwt, String key) {
        String result = "";
        try {
            HashMap<String, String> jwtResult = CryptographyUtil.parseBase64EncodedJWTToken(jwt, key);
            BaseLogger.log("3", null, null, "jwtResult : [" + jwtResult + "]");
            if (jwtResult.containsKey("status") && !"success".equalsIgnoreCase(jwtResult.get("status"))) {
                result = jwtResult.get("status");
            } else {
                String userId = jwtResult.get("id");
                String sessionId = jwtResult.get("sessionId");
                result = String.valueOf(userId) + "~" + sessionId;
            }
        }
        catch (Exception e) {
            return "invalid";
        }
        return result;
    }

    public static HashMap<String, String> parseBase64EncodedJWTToken(String jwt, String key) {
        String status = "";
        HashMap<String, String> jwtResult = null;
        try {
            BaseLogger.log("3", null, null, "jwt : [" + jwt + "], key : [" + key + "]");
            if (E12GenericUtility.checkNull(jwt).length() <= 0 && E12GenericUtility.checkNull(key).length() <= 0) {
                status = "invalid";
            }
            jwt = new String(DatatypeConverter.parseBase64Binary((String)jwt));
            Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)key)).parseClaimsJws(jwt).getBody();
            String userId = claims.getId();
            String sessionId = (String)claims.get((Object)"sessionId");
            BaseLogger.log("3", null, null, "sessionId : [" + sessionId + "]" + "userId : [" + userId + "]");
            if (E12GenericUtility.checkNull(sessionId).length() <= 0 && E12GenericUtility.checkNull(userId).length() <= 0) {
                status = "invalid";
            } else {
                jwtResult = new HashMap();
                jwtResult.put("id", userId);
                jwtResult.put("sessionId", sessionId);
                jwtResult.put("applicationId", (String)claims.get((Object)"applicationId"));
                jwtResult.put("region", (String)claims.get((Object)"region"));
                jwtResult.put("designation", (String)claims.get((Object)"designation"));
                jwtResult.put("reportToCode", (String)claims.get((Object)"reportToCode"));
                jwtResult.put("name", (String)claims.get((Object)"name"));
                jwtResult.put("division", (String)claims.get((Object)"division"));
                jwtResult.put("email", (String)claims.get((Object)"email"));
                jwtResult.put("hq", (String)claims.get((Object)"hq"));
                jwtResult.put("userId", userId);
                jwtResult.put("entityType", (String)claims.get((Object)"entityType"));
                jwtResult.put("entityCode", (String)claims.get((Object)"entityCode"));
                jwtResult.put("enterprise", (String)claims.get((Object)"enterprise"));
                jwtResult.put("transDB", (String)claims.get((Object)"transDB"));
                jwtResult.put("loginSite", (String)claims.get((Object)"loginSite"));
                jwtResult.put("profileId", (String)claims.get((Object)"profileId"));
                jwtResult.put("status", "success");
            }
            BaseLogger.log("3", null, null, "jwtResult : [" + jwtResult + "]");
        }
        catch (ExpiredJwtException e) {
            e.printStackTrace();
            status = "expired";
        }
        catch (Exception e) {
            e.printStackTrace();
            status = "invalid";
        }
        status = E12GenericUtility.checkNull(status);
        if (status.length() > 0 && jwtResult == null) {
            jwtResult = new HashMap<String, String>();
            jwtResult.put("status", status);
        }
        return jwtResult;
    }

    public static String getShortLivedJWTToken(String jwt, String key) {
        String result = "";
        try {
            HashMap<String, String> jwtResult = CryptographyUtil.parseBase64EncodedJWTToken(jwt, key);
            if (jwtResult.containsKey("status") && !"success".equalsIgnoreCase(jwtResult.get("status"))) {
                result = jwtResult.get("status");
            } else {
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
                byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)key);
                SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
                BaseLogger.log("3", null, null, "CryptographyUtil :: createBase64EncodedJWT : Creating JWT with secret key");
                JwtBuilder builder = Jwts.builder().setId(jwtResult.get("id")).signWith(signatureAlgorithm, (Key)signingKey).claim("applicationId", (Object)E12GenericUtility.checkNull(jwtResult.get("applicationId"))).claim("region", (Object)E12GenericUtility.checkNull(jwtResult.get("region"))).claim("designation", (Object)E12GenericUtility.checkNull(jwtResult.get("designation"))).claim("reportToCode", (Object)E12GenericUtility.checkNull(jwtResult.get("reportToCode"))).claim("name", (Object)E12GenericUtility.checkNull(jwtResult.get("name"))).claim("division", (Object)E12GenericUtility.checkNull(jwtResult.get("division"))).claim("email", (Object)E12GenericUtility.checkNull(jwtResult.get("email"))).claim("hq", (Object)E12GenericUtility.checkNull(jwtResult.get("hq"))).claim("sessionId", (Object)E12GenericUtility.checkNull(jwtResult.get("sessionId"))).claim("entityType", (Object)E12GenericUtility.checkNull(jwtResult.get("entityType"))).claim("entityCode", (Object)E12GenericUtility.checkNull(jwtResult.get("entityCode"))).claim("enterprise", (Object)E12GenericUtility.checkNull(jwtResult.get("enterprise"))).claim("transDB", (Object)E12GenericUtility.checkNull(jwtResult.get("transDB"))).claim("loginSite", (Object)E12GenericUtility.checkNull(jwtResult.get("loginSite"))).claim("profileId", (Object)E12GenericUtility.checkNull(jwtResult.get("profileId")));
                long ttlMillis = 600000L;
                if (ttlMillis >= 0L) {
                    long nowMillis = System.currentTimeMillis();
                    long expMillis = nowMillis + ttlMillis;
                    Date exp = new Date(expMillis);
                    builder.setExpiration(exp);
                }
                BaseLogger.log("3", null, null, "CryptographyUtil :: getShortLivedJWTToken : Encode JWT with Base 64");
                result = DatatypeConverter.printBase64Binary((byte[])builder.compact().getBytes());
            }
        }
        catch (ExpiredJwtException e) {
            e.printStackTrace();
            result = "expired";
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "invalid";
        }
        return result;
    }
}

