/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.ai.entityid.DocumentProcessTrail;
import ibase.ai.entityid.ItemLookUp;
import ibase.ai.entityid.ItemUOM;
import ibase.bis.utility.BISDictionary;
import ibase.hibernate.dao.DocTypeProcDAO;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webService.RestAPIService;
import ibase.webitm.utility.ITMException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/DataExtractionService")
public class DataExtractionService
extends RestAPIService {
    private UserInfoBean userInfo = null;
    E12GenericUtility e12genericUtility = new E12GenericUtility();

    @POST
    @Path(value="/saveProcessData")
    @Produces(value={"application/json"})
    public Response saveProcessData(String overViewModel, @Context HttpServletRequest request) throws ITMException {
        String result = "";
        try {
            System.out.println("DataExtractionService saveProcessData overViewModel [" + overViewModel + "]");
            JSONObject overViewObj = new JSONObject(overViewModel);
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            DocTypeProcDAO docTypeProcDAO = new DocTypeProcDAO();
            docTypeProcDAO.saveOverviewData(this.userInfo, overViewObj);
            result = "success";
        }
        catch (Exception e) {
            System.out.println("Exception in DataExtractionService.saveProcessData() [" + e.getMessage() + "]");
            result = this.e12genericUtility.createErrorString(e);
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/getTraceLinkData")
    @Produces(value={"application/json"})
    public Response getTraceLinkData(@FormParam(value="processId") String processId, @FormParam(value="docId") String docId, @FormParam(value="proc_mtd") String procMethod, @Context HttpServletRequest request) throws ITMException {
        JSONObject ocrData = new JSONObject();
        String result = "";
        try {
            System.out.println("DataExtractionService getTraceLinkData processId [" + processId + "] docId [" + docId + "] procMethod [" + procMethod + "]");
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            E12GenericUtility e12GenericUtility = new E12GenericUtility();
            DocumentProcessTrail docProcTrail = new DocumentProcessTrail();
            docProcTrail.configureProcTrail(docId, procMethod, processId, this.userInfo);
            result = docProcTrail.getResponseData();
            if ("".equalsIgnoreCase(this.checkNull(result))) {
                result = docProcTrail.getErrorInfo();
            }
            if ("".equalsIgnoreCase(this.checkNull(result))) {
                result = "No data found.";
            }
        }
        catch (Exception e) {
            System.out.println("Exception DataExtractionService.getTraceLinkData [" + e.getMessage() + "]");
            result = this.e12genericUtility.createErrorString(e);
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/updateDictionaryAlias")
    @Produces(value={"application/json"})
    public Response updateDictionaryAlias(@FormParam(value="jsonArray") String jsonArray, @Context HttpServletRequest request) throws ITMException, JSONException {
        String result = "";
        try {
            int count = 0;
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("DataExtractionService updateDictionaryAlias jsonArray===> [" + jsonArray + "]"));
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            JSONArray jsonArr = new JSONArray(jsonArray);
            int i = 0;
            while (i < jsonArr.length()) {
                BISDictionary bisDictionary = new BISDictionary();
                JSONObject tempObject = jsonArr.optJSONObject(i);
                Iterator itr = tempObject.keys();
                while (itr.hasNext()) {
                    String applScope = (String)itr.next();
                    JSONObject bisObject = tempObject.optJSONObject(applScope);
                    String phrase = bisObject.optString("phrase");
                    String resValue = bisObject.optString("resValue");
                    String bisEntityID = bisObject.optString("bisEntityID");
                    JSONObject bisObj = new JSONObject();
                    bisObj.put("PHRASE", (Object)phrase);
                    bisObj.put("RES_VALUE", (Object)resValue);
                    bisObj.put("PHRASE_SCOPE", (Object)"E");
                    bisObj.put("RES_TYPE", (Object)"D");
                    bisObj.put("USER_ID", (Object)this.userInfo.getEnterprise());
                    bisObj.put("BIS_ENTITY_ID", (Object)bisEntityID);
                    bisObj.put("APPL_SCOPE", (Object)applScope);
                    count = bisDictionary.InsertOrUpdateBISDictionary(bisObj, null, this.userInfo);
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("Inside updateDictionaryAlias count===> [" + count + "]"));
                }
                ++i;
            }
            result = count > 0 ? "success" : "failure";
        }
        catch (Exception e) {
            System.out.println("Exception DataExtractionService.updateDictionaryAlias() [" + e.getMessage() + "]");
            result = this.e12genericUtility.createErrorString(e);
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/recalculateUOM")
    @Produces(value={"application/json"})
    public Response recalculateUOM(@FormParam(value="jsonObject") String jsonObject, @Context HttpServletRequest request) throws ITMException, JSONException {
        String result = "";
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("DataExtractionService recalculateUOM jsonObject===> [" + jsonObject + "]"));
            ItemUOM itemUOM = new ItemUOM();
            JSONObject jsonObj = new JSONObject(jsonObject);
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            int count = itemUOM.updateOrInsertUOM(this.userInfo, jsonObj);
            result = "success";
            result = count > 0 ? "success" : "failure";
        }
        catch (Exception e) {
            System.out.println("Exception DataExtractionService.recalculateUOM() [" + e.getMessage() + "]");
            result = this.e12genericUtility.createErrorString(e);
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/updateItemCode")
    @Produces(value={"application/json"})
    public Response updateItemCode(@FormParam(value="jsonObject") String jsonObject, @Context HttpServletRequest request) throws ITMException, JSONException {
        String result = "";
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("DataExtractionService updateItemCode jsonObject===> [" + jsonObject + "]"));
            ItemLookUp itemLookUp = new ItemLookUp();
            JSONObject jsonObj = new JSONObject(jsonObject);
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            int count = itemLookUp.updateItemCode(this.userInfo, jsonObj);
            result = count > 0 ? "success" : "failure";
        }
        catch (Exception e) {
            System.out.println("Exception DataExtractionService.updateItemCode() [" + e.getMessage() + "]");
            result = this.e12genericUtility.createErrorString(e);
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/getProductIdentificationAlias")
    @Produces(value={"application/json"})
    public Response getProductIdentificationAlias(@Context HttpServletRequest request) throws ITMException, JSONException {
        String result = "";
        try {
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            BISDictionary bisDictionary = new BISDictionary();
            JSONObject jsonData = new JSONObject();
            jsonData = bisDictionary.getProductIdentificationAlias(this.userInfo);
            result = jsonData.toString();
        }
        catch (Exception e) {
            System.out.println("Exception DataExtractionService.updateItemCode() [" + e.getMessage() + "]");
            result = this.e12genericUtility.createErrorString(e);
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/getProcMethodList")
    @Produces(value={"application/json"})
    public Response getProcMethodList(String documentType, @Context HttpServletRequest request) throws ITMException {
        String result = "";
        String jsonData = "";
        try {
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            String docType = documentType;
            DocTypeProcDAO docTypeProcDAO = new DocTypeProcDAO();
            jsonData = docTypeProcDAO.getProcMethodList(this.userInfo, docType);
            result = jsonData.toString();
        }
        catch (Exception e) {
            System.out.println("Exception in DataExtractionService.getProcessList() [" + e.getMessage() + "]");
            result = this.e12genericUtility.createErrorString(e);
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/getProcMethodParams")
    @Produces(value={"application/json"})
    public Response getProcMethodParams(String overViewModel, @Context HttpServletRequest request) throws ITMException {
        String result = "";
        JSONObject jsonDataObject = new JSONObject();
        try {
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            JSONObject paramsObject = new JSONObject(overViewModel);
            String documentType = paramsObject.optString("doc_type");
            String procApiName = this.checkNull(paramsObject.optString("proc_mtd"));
            String entType = this.checkNull(paramsObject.optString("ent_type"));
            String entCode = this.checkNull(paramsObject.optString("ent_code"));
            String fileType = this.checkNull(paramsObject.optString("file_type"));
            DocTypeProcDAO docTypeProcDAO = new DocTypeProcDAO();
            jsonDataObject = docTypeProcDAO.getProcessMethodParams(this.userInfo, documentType, procApiName, entCode, entType, fileType);
            paramsObject.put("ai_proc_templ", (Object)jsonDataObject.optString("ai_proc_templ"));
            paramsObject.put("ai_proc_variables", (Object)jsonDataObject.optString("ai_proc_variables"));
            docTypeProcDAO.updateDefaultValue(this.userInfo, paramsObject);
            result = paramsObject.toString();
        }
        catch (Exception e) {
            System.out.println("Exception in DataExtractionService.getProcMethodParams() [" + e.getMessage() + "]");
            result = this.e12genericUtility.createErrorString(e);
        }
        return Response.status((int)200).entity((Object)result).build();
    }
}

