/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.JMSLogger;
import ibase.wrkflw.WorkflowEngineEJB;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class JMSWorklFlowInvoker {
    public void invokeWorkFlow(String jmsData) throws ITMException {
        block26: {
            Connection conn = null;
            String wfprocessInstanceID = "";
            try {
                try {
                    if (jmsData == null) break block26;
                    String[] inputArr = jmsData.split("!~~!");
                    JMSLogger.log("3", null, null, "JMSWorklFlowInvoker.invokeWorkFlow() inputArr size :[" + inputArr.length + "]");
                    String wfObjName = inputArr[0];
                    String wfRefSer = inputArr[1];
                    String wfRefID = inputArr[2];
                    UserInfoBean userInfo = new UserInfoBean(inputArr[3]);
                    boolean isRecAvail = false;
                    boolean isError = false;
                    ConnDriver connDriver = new ConnDriver();
                    String transDB = userInfo.getTransDB();
                    JMSLogger.log("3", userInfo, null, "JMSWorklFlowInvoker.invokeWorkFlow() transDB :[" + transDB + "]");
                    conn = connDriver.getConnectDB(transDB);
                    WorkflowEngineEJB workflowEngineComp = new WorkflowEngineEJB();
                    do {
                        isRecAvail = (wfprocessInstanceID = this.getProcessInstanceID(wfObjName, wfRefSer, wfRefID, conn)) != null && wfprocessInstanceID.trim().length() > 0;
                        try {
                            try {
                                JMSLogger.log("3", userInfo, null, "JMSWorklFlowInvoker.invokeWorkFlow() isRecAvail :[" + isRecAvail + "]");
                                if (isRecAvail) {
                                    workflowEngineComp.performActivity(wfprocessInstanceID, conn, userInfo.toString());
                                    JMSLogger.log("3", userInfo, null, "JMSWorklFlowInvoker.invokeWorkFlow() activity completed");
                                }
                            }
                            catch (Exception ex) {
                                try {
                                    isError = false;
                                    isRecAvail = false;
                                    conn.rollback();
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                try {
                                    if (conn == null || isError) continue;
                                    conn.commit();
                                }
                                catch (Exception ee) {
                                    ee.printStackTrace();
                                }
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (conn != null && !isError) {
                                    conn.commit();
                                }
                            }
                            catch (Exception ee) {
                                ee.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            if (conn == null || isError) continue;
                            conn.commit();
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    } while (isRecAvail);
                }
                catch (ITMException itme) {
                    throw itme;
                }
                catch (Exception e) {
                    throw new ITMException(e);
                }
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    private String getProcessInstanceID(String objName, String refSer, String refID, Connection conn) throws Exception {
        JMSLogger.log("2", null, null, "getProcessInstanceID :: objName ::[" + objName + "], refSer ::[" + refSer + "], refID ::[" + refID + "]");
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String processId = "";
        String instanceId = "";
        String activityId = "";
        String seqID = "";
        String processInstanceID = "";
        int processStatus = 0;
        try {
            try {
                String sql = " SELECT PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, SEQ_ID FROM WF_PRC_STATUS  WHERE PROCESS_STATUS = ? AND OBJ_NAME = ? AND REF_SER = ? AND REF_ID = ?  AND '1' != (CASE WHEN ERR_STATUS IS NULL THEN '0' ELSE ERR_STATUS END) AND WF_ABORT IS NULL ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, processStatus);
                pstmt.setString(2, objName);
                pstmt.setString(3, refSer);
                pstmt.setString(4, refID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    processId = this.checkNull(rs.getString("PROCESS_ID"));
                    instanceId = this.checkNull(rs.getString("INSTANCE_ID"));
                    activityId = this.checkNull(rs.getString("ACTIVITY_ID"));
                    seqID = this.checkNull(rs.getString("SEQ_ID"));
                }
                processInstanceID = processId.length() > 0 && instanceId.length() > 0 && activityId.length() > 0 && seqID.length() > 0 ? String.valueOf(processId) + ":" + instanceId + ":" + activityId + ":" + seqID : "";
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JMSLogger.log("2", null, null, "processInstanceID =[" + processInstanceID + "]");
        return processInstanceID;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

