/*
 * Decompiled with CFR 0.152.
 */
package ibase.communication;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TelegramComm {
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String sendTelegramMessage(UserInfoBean userInfo, String transDomStr, String commDomStr, String formatCode) throws IOException, InterruptedException, ITMException {
        String commXMLStr = this.buildTelegramCommXML(userInfo, transDomStr, commDomStr);
        BaseLogger.log((String)"3", null, null, (Object)("commXMLStr: " + commDomStr));
        StringBuffer retString = new StringBuffer();
        boolean isError = false;
        retString.append("<ROOT>");
        retString.append("<COMMUNICATION_TYPE><![CDATA[Telegram]]></COMMUNICATION_TYPE>");
        String POST_URL = "https://api.telegram.org/";
        String chatId = "";
        String message = "";
        String document = "";
        String messageType = "";
        String telegramToken = "";
        ArrayList<Object> chatID = new ArrayList<String>();
        String commType = "Telegram";
        String commStatus = null;
        String commErrorMsg = null;
        try {
            E12GenericUtility utility = new E12GenericUtility();
            Document dom = utility.parseString(commXMLStr);
            telegramToken = this.getNodeValue(dom, "TOKEN_ID");
            message = this.getNodeValue(dom, "SUBJECT");
            chatId = this.getNodeValue(dom, "CHAT_ID");
            document = this.getNodeValue(dom, "ATTACH_TEXT");
            String bodyText = this.getNodeValue(dom, "BODY_TEXT");
            message = message != null ? String.valueOf(message) + "%0A%0A" + bodyText : bodyText;
            retString.append("<BODY_TEXT><![CDATA[" + message + "]]></BODY_TEXT>");
            if (chatId.indexOf(",") != -1) {
                chatID.add(chatId);
            } else {
                String[] stringArray = chatId.split(",");
                chatID = new ArrayList<String>(Arrays.asList(stringArray));
            }
            retString.append("<ATTACHMENT><![CDATA[" + document + "]]></ATTACHMENT>");
            messageType = "".equals(document) ? "text" : "document";
            for (String string : chatID) {
                int responseCode;
                HttpURLConnection con;
                URL url;
                if (messageType.equalsIgnoreCase("document") && document != null) {
                    POST_URL = String.valueOf(POST_URL) + "bot" + telegramToken + "/" + "sendDocument";
                    try {
                        String inputLine;
                        BaseLogger.log((String)"3", null, null, (Object)("POST_URL= for sending Document [" + POST_URL + "]"));
                        BaseLogger.log((String)"3", null, null, (Object)("POST_URL= for sending Document file path [" + document + "]"));
                        File file = new File(document);
                        if (file.exists()) {
                            BaseLogger.log((String)"3", null, null, (Object)"FIle exit to send");
                        } else {
                            BaseLogger.log((String)"3", null, null, (Object)"FIle not exit to send");
                        }
                        BaseLogger.log((String)"3", null, null, (Object)"Sending new code with boundary-------------");
                        url = new URL(POST_URL);
                        con = (HttpURLConnection)url.openConnection();
                        con.setRequestMethod("POST");
                        con.setRequestProperty("Content-Type", "multipart/form-data; boundary=--------------------------");
                        String boundary = "--------------------------";
                        String formData = "--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"chat_id\"\r\n\r\n" + chatId + "\r\n" + "--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"document\"; filename=\"" + file.getName() + "\"\r\n" + "Content-Type: application/pdf\r\n\r\n";
                        byte[] formDataBytes = formData.getBytes("UTF-8");
                        byte[] fileBytes = new byte[(int)file.length()];
                        FileInputStream fileInputStream = new FileInputStream(file);
                        fileInputStream.read(fileBytes);
                        fileInputStream.close();
                        byte[] endBytes = ("\r\n--" + boundary + "--\r\n").getBytes("UTF-8");
                        byte[] requestBytes = new byte[formDataBytes.length + fileBytes.length + endBytes.length];
                        System.arraycopy(formDataBytes, 0, requestBytes, 0, formDataBytes.length);
                        System.arraycopy(fileBytes, 0, requestBytes, formDataBytes.length, fileBytes.length);
                        System.arraycopy(endBytes, 0, requestBytes, formDataBytes.length + fileBytes.length, endBytes.length);
                        con.setDoOutput(true);
                        OutputStream outputStream = con.getOutputStream();
                        outputStream.write(requestBytes);
                        outputStream.flush();
                        outputStream.close();
                        responseCode = con.getResponseCode();
                        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                        StringBuffer response = new StringBuffer();
                        while ((inputLine = in.readLine()) != null) {
                            response.append(inputLine);
                        }
                        in.close();
                        BaseLogger.log((String)"3", null, null, (Object)("file Send response=" + response.toString()));
                        if (responseCode != 200) {
                            BaseLogger.log((String)"3", null, null, (Object)"SendTelegram :: POST request not worked");
                            isError = true;
                            commErrorMsg = "Post Request Failed";
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log((String)"3", null, null, (Object)("SendTelegram :: POST request not worked" + e));
                        isError = true;
                        commErrorMsg = e.toString();
                        e.printStackTrace();
                        BaseLogger.log((String)"3", null, null, (Object)("error in sending telegram==>" + e.getMessage()));
                    }
                } else {
                    POST_URL = "https://api.telegram.org/bot" + telegramToken + "/sendMessage";
                    String params = "chat_id=" + string + "&text=" + message;
                    BaseLogger.log((String)"3", null, null, (Object)("POST_URL= for sending Text" + POST_URL));
                    try {
                        url = new URL(POST_URL);
                        con = (HttpURLConnection)url.openConnection();
                        con.setRequestMethod("POST");
                        con.setDoOutput(true);
                        OutputStream os = con.getOutputStream();
                        os.write(params.getBytes());
                        os.flush();
                        os.close();
                        responseCode = con.getResponseCode();
                        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                        String inputLine = "";
                        StringBuffer response = new StringBuffer();
                        while ((inputLine = in.readLine()) != null) {
                            response.append(inputLine);
                        }
                        in.close();
                        BaseLogger.log((String)"3", null, null, (Object)("response from telegram" + response.toString()));
                        if (responseCode != 200) {
                            BaseLogger.log((String)"3", null, null, (Object)"SendTelegram :: POST request not worked");
                            isError = true;
                            commErrorMsg = "Post Request Failed";
                        }
                    }
                    catch (Exception e) {
                        isError = true;
                        commErrorMsg = e.toString();
                        e.printStackTrace();
                        BaseLogger.log((String)"3", null, null, (Object)("error in sending telegram==>" + e.getMessage()));
                    }
                }
                BaseLogger.log((String)"3", null, null, (Object)("SendTelegram :: POST URL :: " + POST_URL));
            }
        }
        catch (Exception ex) {
            isError = true;
            commErrorMsg = ex.toString();
            BaseLogger.log((String)"3", null, null, (Object)("SendTelegram Error::" + ex));
        }
        commStatus = isError ? "E" : "S";
        retString.append("<COMM_TYPE><![CDATA[" + commType + "]]></<COMM_TYPE>");
        retString.append("<COMM_STATUS><![CDATA[" + commStatus + "]]></<COMM_STATUS>");
        retString.append("<COMM_ERROR_MESSAGE><![CDATA[" + commErrorMsg + "]]></<COMM_ERROR_MESSAGE>");
        retString.append("<COMM_TO><![CDATA[" + chatId + "]]></<COMM_TO>");
        retString.append("<COMM_SUBJECT><![CDATA[" + null + "]]></<COMM_SUBJECT>");
        retString.append("<COMM_BODY><![CDATA[" + message + "]]></<COMM_BODY>");
        retString.append("<ATTACHMENT><![CDATA[" + null + "]]></<ATTACHMENT>>");
        retString.append("</ROOT>");
        BaseLogger.log((String)"3", null, null, (Object)("SendTelegram: response String: " + retString.toString()));
        return retString.toString();
    }

    private String buildTelegramCommXML(UserInfoBean userInfo, String tranDataStr, String commDataStr) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"Inside buildXMLString ---- ");
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Inside buildXMLString ---- " + tranDataStr));
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Inside buildXMLString ---- " + commDataStr));
        StringBuilder XMLString = new StringBuilder("<Root>");
        try {
            String userCodes;
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"in E12TelegramCom buildXMLString");
            DBAccessEJB dbAccess = new DBAccessEJB();
            String chatId = "";
            Document detailDom = this.genericUtility.parseString(tranDataStr);
            Document commDataDom = this.genericUtility.parseString(commDataStr);
            String sendTo = this.getNodeValue(commDataDom, "SEND_TO");
            String copyTo = this.getNodeValue(commDataDom, "COPY_TO");
            String blindCopy = this.getNodeValue(commDataDom, "BLIND_COPY");
            String message = this.getNodeValue(commDataDom, "BODY_TEXT");
            String subject = this.getNodeValue(commDataDom, "SUBJECT");
            String attachText = this.getNodeValue(commDataDom, "ATTACH_TEXT");
            if (sendTo.contains("<")) {
                String sendToChatId = this.getChatId(sendTo, detailDom, userInfo, dbAccess);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("from chatId  sendTo=" + sendToChatId));
                chatId = sendToChatId;
            } else {
                userCodes = Arrays.asList(sendTo.split(",")).toString().replace("[", "").replace("]", "").replace(" ", "");
                chatId = this.getChatIdFromUserCode(userInfo, dbAccess);
            }
            if (copyTo.contains("<")) {
                String copyToChatId = this.getChatId(copyTo, detailDom, userInfo, dbAccess);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("from chatId  copyTo=" + copyToChatId));
                chatId = String.valueOf(chatId) + "," + copyToChatId;
            } else {
                userCodes = Arrays.asList(copyTo.split(",")).toString().replace("[", "").replace("]", "").replace(" ", "");
                chatId = String.valueOf(chatId) + "," + userCodes;
            }
            if (blindCopy.contains("<")) {
                String blindCopyChatId = this.getChatId(blindCopy, detailDom, userInfo, dbAccess);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("from chatId  blindCopy=" + blindCopyChatId));
                chatId = String.valueOf(chatId) + "," + blindCopyChatId;
            } else {
                userCodes = Arrays.asList(blindCopy.split(",")).toString().replace("[", "").replace("]", "").replace(" ", "");
                chatId = String.valueOf(chatId) + "," + userCodes;
            }
            String[] chatIdArry = chatId.split(",");
            StringBuilder allChatId = new StringBuilder();
            HashSet<String> set = new HashSet<String>();
            String[] stringArray = chatIdArry;
            int n = chatIdArry.length;
            int n2 = 0;
            while (n2 < n) {
                String chId = stringArray[n2];
                if (!chId.equals("")) {
                    if (allChatId.length() == 0) {
                        allChatId.append(chId);
                    } else if (set.add(chId)) {
                        allChatId.append("," + chId);
                    }
                }
                ++n2;
            }
            chatId = allChatId.toString();
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("All Chat Id=" + chatId));
            E12GenericUtility utility = new E12GenericUtility();
            String tblName = "USER_ACC_CHANNEL";
            String tokenId = "";
            String transDB = userInfo.getTransDB();
            transDB = "APPVIS";
            tokenId = dbAccess.getDBColumnValue(tblName, "TOKEN_ID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            message = this.getFormatedMessageBody(message, detailDom);
            subject = this.getFormatedMessageBody(subject, detailDom);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("sendTelegramMessage tokenId=[" + tokenId + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Got Telegram Chat Id=[" + chatId + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Got Telegram Message =[" + message + "]"));
            XMLString.append("<TOKEN_ID><![CDATA[" + tokenId + "]]></TOKEN_ID>");
            XMLString.append("<CHAT_ID><![CDATA[" + chatId + "]]></CHAT_ID>");
            XMLString.append("<BODY_TEXT><![CDATA[" + E12GenericUtility.checkNull((String)message) + "]]></BODY_TEXT>");
            XMLString.append("<SUBJECT><![CDATA[" + E12GenericUtility.checkNull((String)subject) + "]]></SUBJECT>");
            if (attachText != "" && !attachText.equalsIgnoreCase("x")) {
                XMLString.append("<ATTACH_TEXT><![CDATA[" + attachText + "]]></ATTACH_TEXT>");
            }
            XMLString.append("</Root>");
        }
        catch (ITMException itme) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)"Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)"Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw new ITMException(e);
        }
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("BuildXMLString() XMLString=[" + XMLString + "]"));
        return XMLString.toString();
    }

    private String getChatId(String sendToFlds, Document tranDom, UserInfoBean userInfo, DBAccessEJB dbAccess) throws ITMException {
        String userCodes = "";
        String chatId = "";
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String[] userCodeFldArr = sendToFlds.split(",");
        String currentAddrFld = "";
        String currentAddrVal = "";
        String currentAddrFldFull = "";
        String findStr = "<Detail1.";
        String entityType = "";
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            detailNode = detailNodeList.item(0);
            detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
            int pkCntr = 0;
            while (pkCntr < userCodeFldArr.length) {
                currentAddrVal = "";
                currentAddrFldFull = userCodeFldArr[pkCntr];
                if (currentAddrFldFull.startsWith(findStr)) {
                    currentAddrFld = currentAddrFldFull.substring(findStr.length(), currentAddrFldFull.lastIndexOf(">"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)currentAddrFld);
                    currentAddrVal = this.getNodeValue(detailDom, currentAddrFld);
                } else if (currentAddrFldFull.startsWith("{")) {
                    entityType = "";
                    if (currentAddrFldFull.charAt(1) == '(') {
                        entityType = currentAddrFldFull.substring(currentAddrFldFull.indexOf("(") + 1, currentAddrFldFull.indexOf(")"));
                        currentAddrFld = currentAddrFldFull.substring(currentAddrFldFull.indexOf(")") + 1, currentAddrFldFull.indexOf("}"));
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("entityType=" + entityType));
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("currentAddrFld=" + currentAddrFld));
                        currentAddrVal = this.getAddressValue(entityType, currentAddrFld, tranDom, userInfo);
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("currentAddrVal=" + currentAddrVal));
                    }
                } else if (currentAddrFldFull.startsWith("[")) {
                    entityType = "";
                    if (currentAddrFldFull.charAt(1) == '(') {
                        entityType = currentAddrFldFull.substring(currentAddrFldFull.indexOf("(") + 1, currentAddrFldFull.indexOf(")"));
                        currentAddrFld = currentAddrFldFull.substring(currentAddrFldFull.indexOf(")") + 1, currentAddrFldFull.indexOf("]"));
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("entityType=" + entityType));
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("currentAddrFld=" + currentAddrFld));
                        currentAddrVal = this.getAddressValue(entityType, currentAddrFld, tranDom, userInfo);
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("currentAddrVal=" + currentAddrVal));
                    }
                } else {
                    currentAddrVal = currentAddrFldFull;
                }
                if (currentAddrVal != null && currentAddrVal.length() > 0) {
                    userCodes = String.valueOf(userCodes) + currentAddrVal + ",";
                }
                ++pkCntr;
            }
            String[] users = userCodes.split(",");
            String transDB = "APPVIS";
            int userIndex = 0;
            while (userIndex < users.length) {
                if (!users[userIndex].contains("@")) {
                    String chid = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + users[userIndex] + "' AND APP_ID='TLG_APPVIS'", transDB));
                    chatId = chatId.equals("") ? chid : String.valueOf(chatId) + "," + chid;
                }
                ++userIndex;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return chatId;
    }

    private String getFormatedMessageBody(String bodyTextData, Document tranDom) throws ITMException {
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String findStr = "<Detail1.";
        String colFullName = "";
        String colName = "";
        String currColVal = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message tranDome:" + genericUtility.parseString(genericUtility.serializeDom((Node)tranDom))));
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message bodyTextData:" + bodyTextData));
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message findStr string:" + findStr));
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            if (bodyTextData != null) {
                detailNode = detailNodeList.item(0);
                detailDom = genericUtility.parseString(genericUtility.serializeDom(detailNode));
                BaseLogger.log((String)"3", null, null, (Object)("detaildom: " + detailDom));
                while (bodyTextData.indexOf(findStr, nextSearchIndex) != -1) {
                    BaseLogger.log((String)"3", null, null, (Object)nextSearchIndex);
                    currColVal = "";
                    currentIndex = bodyTextData.indexOf(findStr, nextSearchIndex);
                    String firstPart = bodyTextData.substring(0, currentIndex);
                    String lastPart = bodyTextData.substring(currentIndex, bodyTextData.length());
                    colFullName = lastPart.substring(0, lastPart.indexOf(">") + 1);
                    BaseLogger.log((String)"3", null, null, (Object)("Telegram Message colFullName:" + colFullName));
                    colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf(">"));
                    BaseLogger.log((String)"3", null, null, (Object)("telegram Message colName:" + colName));
                    currColVal = this.getNodeValue(detailDom, colName);
                    bodyTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, currColVal.trim());
                    nextSearchIndex = currentIndex + currColVal.length();
                    BaseLogger.log((String)"3", null, null, (Object)("bodyTextData for Telegram message=" + bodyTextData));
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Error in getFormatedMessageBody()=" + e.getMessage()));
            throw new ITMException(e);
        }
        BaseLogger.log((String)"3", null, null, (Object)("getFormatedMessageBody bodyTextData:" + bodyTextData));
        return bodyTextData;
    }

    private String getAddressValue(String entityType, String argName, Document tranDom, UserInfoBean userInfo) throws ITMException {
        String chatId = "";
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String whereFieldValue = "";
        DBAccessEJB dbAccess = new DBAccessEJB();
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            detailNode = detailNodeList.item(0);
            detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("AgrName:" + argName));
            whereFieldValue = this.getNodeValue(detailDom, argName);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("getAddressValue()whereFieldValue =[" + whereFieldValue));
            chatId = dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + whereFieldValue + "', AND APP_ID='TLG_APPVIS'", "APPVIS");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("getAddressValue()chatId =[" + chatId));
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Error in getAddressValue()" + e.getMessage()));
            throw new ITMException(e);
        }
        return chatId;
    }

    private String getChatIdFromUserCode(UserInfoBean userInfo, DBAccessEJB dbAccess) {
        String chatId = "";
        try {
            chatId = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", "APPVIS"));
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("getChatIdFromUserCode() Error=[" + e.getMessage() + "]"));
            return "";
        }
        return chatId;
    }

    private String domToString(Document dom) {
        String xmlStr = "";
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(dom), new StreamResult(stringWriter));
            xmlStr = stringWriter.toString();
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("domToString() Error=[" + e.getMessage() + "]"));
        }
        BaseLogger.log((String)"3", null, null, (Object)("domToString() xmlStr:" + xmlStr));
        return xmlStr;
    }

    private Connection getConnection(UserInfoBean userInfo) throws ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        String transDB = userInfo.getTransDB();
        try {
            connDriver = new ConnDriver();
            if (userInfo != null) {
                transDB = userInfo.getTransDB();
            }
            conn = connDriver.getConnectDB(transDB);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }

    private String getNodeValue(Document dom, String colName) {
        String retValue = "";
        try {
            if (dom.getElementsByTagName(colName).item(0) != null && dom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                retValue = dom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retValue;
    }
}

