/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.Column;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DB2JSONGenerator {
    HashMap colIdNameMap = null;
    ArrayList pkColIdList = null;
    String loginEmployee = null;
    String objName = null;
    String database = "oracle";
    ArrayList pkDetaiList = null;
    HashMap colLogNameTypeMap = null;
    boolean isRCP = false;
    final String COLUMN_SEPARATOR = ":";
    private HashMap<String, String> formWisePkFldNameMap = new HashMap();
    final String OBJ_INFO_SEPARATOR = ";";
    private HashMap<String, String> objFormInfoMap = null;
    ArrayList objFormsDetailList = null;
    int currentRowNum = 0;
    int uptoRowNum = 0;
    ArrayList selectedTables = new ArrayList();
    HashMap rowSecurityInfo = null;

    public HashMap<String, String> getFormWisePkFldNameMap() {
        return this.formWisePkFldNameMap;
    }

    public void setFormWisePkFldNameMap(HashMap<String, String> formWisePkFldNameMap) {
        this.formWisePkFldNameMap = formWisePkFldNameMap;
    }

    public ArrayList getObjFormsDetailList() {
        return this.objFormsDetailList;
    }

    public void setObjFormsDetailList(ArrayList objFormsDetailList) {
        this.objFormsDetailList = objFormsDetailList;
    }

    public int getCurrentRowNum() {
        return this.currentRowNum;
    }

    public void setCurrentRowNum(int currentRowNum) {
        this.currentRowNum = currentRowNum;
    }

    public int getUptoRowNum() {
        return this.uptoRowNum;
    }

    public void setUptoRowNum(int uptoRowNum) {
        this.uptoRowNum = uptoRowNum;
    }

    public DB2JSONGenerator() {
        this.objFormInfoMap = new HashMap();
    }

    public DB2JSONGenerator(String objName) throws Exception {
        try {
            this.objName = objName;
            this.objFormInfoMap = new HashMap();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "[DB2JSONGenerator][DB2JSONGenerator()]Exception:");
            BaseLogger.log("0", null, null, "Exception==>" + e);
            throw new ITMException(e);
        }
    }

    public String createJSON(String objName, String objContext, String pageContext, String qryParam, String qryParamType, String filterString, String userInfoStr) throws Exception {
        BaseLogger.log("0", null, null, "[DB2JSONGenerator] call first");
        String fileName = null;
        Connection myCon = null;
        Statement pstmt = null;
        UserInfoBean userInfo = null;
        ResultSet rs = null;
        try {
            try {
                if (userInfoStr != null && userInfoStr.length() > 0) {
                    userInfo = new UserInfoBean(userInfoStr);
                }
                BaseLogger.log("3", userInfo, null, "In DB2JSONGenerator createJSON 129 this.objName[" + this.objName + "] objName[" + objName + "]");
                this.objName = this.objName != objName ? objName : this.objName;
                BaseLogger.log("3", userInfo, null, "In DB2JSONGenerator createJSON 131 this.objName[" + this.objName + "]");
                String key = String.valueOf(objName) + pageContext + objContext;
                BaseLogger.log("3", userInfo, null, "Key :[" + key + "]");
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                String condition = "TRAN_WINDOW = 'w_" + this.objName + "' ";
                String workFlowOpt = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "WORKFLOW_OPT", condition, userInfo.getTransDB()));
                String workFlowInit = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "WRKFLW_INIT", condition, userInfo.getTransDB()));
                String refSer = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER", condition, userInfo.getTransDB()));
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() refSer@@[" + refSer + "]");
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() workFlowOpt@@[" + workFlowOpt + "]");
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() workFlowInit@@[" + workFlowInit + "]");
                String confirmCol = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "CONFIRM_COL", condition, userInfo.getTransDB()));
                String confirmColVal = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "CONFIRM_VAL", condition, userInfo.getTransDB()));
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() confirmCol@@[" + confirmCol + "]");
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() confirmColVal@@[" + confirmColVal + "]");
                String cancelCol = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "CANCEL_COL", condition, userInfo.getTransDB()));
                String cancelColVal = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "CANCEL_VAL", condition, userInfo.getTransDB()));
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() cancelCol@@[" + cancelCol + "]");
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() cancelColVal@@[" + cancelColVal + "]");
                DWFactory dws = new DWFactory(userInfo);
                DWObject dw = null;
                BaseLogger.log("3", userInfo, null, "this.objFormsDetailList :: " + this.objFormsDetailList);
                if (this.objFormsDetailList != null && this.objFormsDetailList.size() > 0 && !this.objFormsDetailList.isEmpty()) {
                    this.setObjFormInfoMap(this.objFormsDetailList);
                }
                String formName = "";
                if (this.objFormInfoMap != null && !this.objFormInfoMap.isEmpty()) {
                    formName = this.getObjPropValue(objContext, "FORM_NAME");
                }
                dw = formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName) ? dws.getDataWindow(objName, pageContext, objContext, formName) : dws.getDataWindow(objName, pageContext, objContext);
                this.pkColIdList = dw.getKeyList();
                this.colIdNameMap = dw.getColIDLogNameMap();
                BaseLogger.log("3", userInfo, null, "getFormWisePkFldNameMap() - " + this.getFormWisePkFldNameMap());
                String pkFldNames = "";
                if (this.getFormWisePkFldNameMap() != null && this.getFormWisePkFldNameMap().containsKey(objContext)) {
                    pkFldNames = this.getFormWisePkFldNameMap().get(objContext);
                }
                BaseLogger.log("3", userInfo, null, "pkFldNames - [" + pkFldNames + "]");
                this.database = CommonConstants.DB_NAME;
                this.colLogNameTypeMap = dw.getColIDLogNameMap();
                dw = formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName) ? dws.getDataWindow(objName, "1".equals(objContext) || pageContext.length() == 0 ? pageContext : "1", formName) : dws.getDataWindow(objName, "1".equals(objContext) || pageContext.length() == 0 ? pageContext : "1", objContext);
                String basicQry = dw.getQueryString().toUpperCase();
                String finalQuery = this.getUpdateQuery(basicQry, filterString);
                if (this.rowSecurityInfo != null) {
                    finalQuery = this.getRowSecurityQuery(finalQuery);
                }
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator : createJSON : Final Query :\n" + finalQuery);
                fileName = String.valueOf(System.currentTimeMillis());
                File fileObj = new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "jsondatafiles" + File.separator + fileName + ".json");
                if (!fileObj.getParentFile().exists()) {
                    fileObj.getParentFile().mkdirs();
                }
                FileOutputStream fout = new FileOutputStream(fileObj);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fout));
                bw.write("\"DocumentRoot\" : {");
                bw.flush();
                BaseLogger.log("3", userInfo, null, "Executing Query...........");
                long start = System.currentTimeMillis();
                ConnDriver connDriver = new ConnDriver();
                String transDB = "";
                if (userInfo != null) {
                    transDB = userInfo.getTransDB();
                }
                myCon = connDriver.getConnectDB(transDB);
                if (this.objName.equalsIgnoreCase("user_audit_trail") && finalQuery.indexOf("WHERE") != -1) {
                    String[] queryArr = finalQuery.split("WHERE");
                    finalQuery = String.valueOf(queryArr[0]) + " WHERE " + queryArr[1].replace("AUDIT_TRAIL.OBJ_NAME", "'w_'||AUDIT_TRAIL.OBJ_NAME").replace("AUDIT_TRAIL.CHG_DATE", "TO_DATE(AUDIT_TRAIL.CHG_DATE)");
                }
                BaseLogger.log("3", userInfo, null, "finalQuery*** =[" + finalQuery + "]");
                E12GenericUtility genericUtility = new E12GenericUtility();
                pstmt = myCon.prepareStatement(finalQuery);
                qryParamType = qryParamType != null && qryParamType.endsWith(":") ? qryParamType : String.valueOf(qryParamType) + ":";
                String string = qryParam = qryParam != null && qryParam.endsWith(":") ? qryParam : String.valueOf(qryParam) + ":";
                if (qryParam != null && finalQuery.indexOf("?") != -1) {
                    StringTokenizer qryParamTokens = new StringTokenizer(qryParam);
                    int pCount = 1;
                    while (qryParamTokens.hasMoreTokens()) {
                        String testParam = qryParamTokens.nextToken(":");
                        BaseLogger.log("3", userInfo, null, "qryParamType =[" + qryParamType + "], testParam =[" + testParam + "]");
                        if (qryParamType != null && qryParamType.length() > 1) {
                            String testParamType = qryParamType.substring(0, qryParamType.indexOf(":"));
                            BaseLogger.log("3", userInfo, null, "Setting Param value :[" + testParam + "] Type :[" + testParamType + "] position :[" + pCount + "]");
                            if (testParamType.equalsIgnoreCase("DATETIME")) {
                                testParam = this.isRCP ? genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat()) : genericUtility.getValidDateTimeString(testParam, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                                pstmt.setTimestamp(pCount, Timestamp.valueOf(testParam));
                            } else if (testParamType.equalsIgnoreCase("DATE")) {
                                if (this.database.equalsIgnoreCase("Oracle")) {
                                    testParam = this.isRCP ? this.getValidDateString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat()) : this.getValidDateString(testParam, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                                    pstmt.setDate(pCount, Date.valueOf(testParam));
                                } else {
                                    testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getApplDateTimeFormat(), genericUtility.getDBDateFormat());
                                    pstmt.setTimestamp(pCount, Timestamp.valueOf(testParam));
                                }
                            } else if (testParamType.equalsIgnoreCase("DECIMAL")) {
                                pstmt.setDouble(pCount, Double.parseDouble(testParam));
                            } else {
                                pstmt.setString(pCount, testParam);
                            }
                            qryParamType = qryParamType.substring(qryParamType.indexOf(":") + 1);
                        } else {
                            pstmt.setString(pCount, testParam);
                        }
                        ++pCount;
                    }
                }
                BaseLogger.log("3", userInfo, null, "Executing Query :" + finalQuery);
                rs = pstmt.executeQuery();
                BaseLogger.log("3", userInfo, null, "Executed Query in [" + (System.currentTimeMillis() - start) + "ms]");
                int pkSize = this.pkColIdList.size();
                boolean domId = true;
                String tagName = "Detail";
                StringBuffer pkFieldValues = new StringBuffer("");
                StringBuffer pkFieldNames = new StringBuffer("");
                BaseLogger.log("3", userInfo, null, "Building JSON from ResultSet ");
                start = System.currentTimeMillis();
                String dbDataFormat = genericUtility.getDBDateFormat();
                String applDataFormat = genericUtility.getApplDateFormat();
                String dbDataTimeFormat = genericUtility.getDBDateTimeFormat();
                String applDateTimeFormat = genericUtility.getApplDateTimeFormat();
                ArrayList columnObjs = dw.getColumnsList();
                WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitorEJB = new WorkflowProcessInstanceMonitorEJB();
                int count = 0;
                while (rs.next()) {
                    HashMap<String, String> fldValueMap = new HashMap<String, String>();
                    StringBuffer fieldDataBuff = new StringBuffer();
                    StringBuffer detailBuff = new StringBuffer();
                    int j = 1;
                    while (j <= columnObjs.size()) {
                        java.util.Date currDate;
                        String data = null;
                        Column colObj = (Column)columnObjs.get(j - 1);
                        if (colObj != null && colObj.getColType() != null && colObj.getColType().equalsIgnoreCase("DATETIME")) {
                            currDate = rs.getTimestamp(j);
                            data = currDate != null ? genericUtility.getValidDateTimeString(((Timestamp)currDate).toString(), dbDataTimeFormat, applDateTimeFormat) : null;
                        } else if (colObj != null && colObj.getColType() != null && colObj.getColType().equalsIgnoreCase("DATE")) {
                            currDate = rs.getDate(j);
                            data = currDate != null ? genericUtility.getValidDateString(((Date)currDate).toString(), dbDataFormat, applDataFormat) : null;
                        } else if (colObj != null && colObj.getColType() != null && colObj.getColType().equalsIgnoreCase("TIMESTAMP")) {
                            currDate = rs.getTimestamp(j);
                            if (currDate != null) {
                                data = genericUtility.getValidDateTimeString(((Timestamp)currDate).toString(), dbDataFormat, applDataFormat);
                            }
                        } else if (colObj != null && colObj.getColType() != null && colObj.getColType().equalsIgnoreCase("TIME")) {
                            currDate = rs.getTimestamp(j);
                            if (currDate != null) {
                                data = genericUtility.getValidDateTimeString((Timestamp)currDate, genericUtility.getDisplayTimeFormat());
                            }
                        } else {
                            data = rs.getString(j);
                        }
                        if (data == null) {
                            data = "";
                        }
                        if (pkSize != 0 && this.pkColIdList.contains(new Integer(j))) {
                            pkFieldValues.append(String.valueOf(data) + ":");
                            pkFieldNames.append(String.valueOf((String)this.colIdNameMap.get(new Integer(j))) + ":");
                        }
                        if (colObj != null && colObj.getColType() != null && colObj.getColType().equalsIgnoreCase("XMLType")) {
                            fieldDataBuff.append("\"" + (String)this.colIdNameMap.get(new Integer(j)) + "\":\"" + data + "\",\n");
                        } else {
                            fieldDataBuff.append("\"" + (String)this.colIdNameMap.get(new Integer(j)) + "\":\"" + data + "\",\n");
                        }
                        fldValueMap.put((String)this.colIdNameMap.get(new Integer(j)), data);
                        ++j;
                    }
                    if (!(workFlowOpt.length() <= 0 || workFlowInit.length() <= 0 || "0".equals(workFlowOpt) || confirmCol.length() > 0 && confirmColVal.length() > 0 && !confirmColVal.equals(fldValueMap.get(confirmCol)) || cancelCol.length() > 0 && cancelColVal.length() > 0 && !cancelColVal.equals(fldValueMap.get(cancelCol)))) {
                        System.out.println("DB2JSONGenerator.createJSON() in if of getting workflow_status");
                        String refId = pkFieldValues.toString();
                        int lastIndexOfColon = refId.lastIndexOf(":");
                        if (lastIndexOfColon > -1 && lastIndexOfColon == refId.length() - 1) {
                            refId = E12GenericUtility.checkNull(refId.substring(0, lastIndexOfColon));
                        }
                        String workflowStatus = workflowProcessInstanceMonitorEJB.getProcessStatus(workFlowInit, objName, refSer, refId, myCon);
                        fieldDataBuff.append("\"workflow_status\":\" " + workflowStatus + "\",\n");
                    }
                    fieldDataBuff.append("}\n");
                    String pkFieldValue = "";
                    String pkFieldName = "";
                    if (E12GenericUtility.checkNull(pkFldNames).length() > 0) {
                        String[] pkFldNamesArr = pkFldNames.split(":");
                        int i = 0;
                        while (i < pkFldNamesArr.length) {
                            pkFieldValue = String.valueOf(pkFieldValue) + (String)fldValueMap.get(pkFldNamesArr[i]) + ":";
                            pkFieldName = String.valueOf(pkFieldName) + pkFldNamesArr[i] + ":";
                            ++i;
                        }
                        BaseLogger.log("3", userInfo, null, "pkFieldValue - [" + pkFieldValue + "]");
                        pkFieldValues = new StringBuffer("");
                        pkFieldNames = new StringBuffer("");
                        pkFieldValues.append(pkFieldValue);
                        pkFieldNames.append(pkFieldName);
                    }
                    if (pkFieldValues.toString().endsWith(":")) {
                        pkFieldValues = pkFieldValues.deleteCharAt(pkFieldValues.length() - 1);
                    }
                    if (CommonConstants.MAX_BROW_ROW != null && CommonConstants.MAX_BROW_ROW.length() > 0) {
                        if (++count > Integer.parseInt(CommonConstants.MAX_BROW_ROW)) continue;
                        detailBuff.append("\"" + tagName + objContext + "\": {" + "\n");
                        detailBuff.append(fieldDataBuff.toString());
                        bw.write(detailBuff.toString());
                        bw.flush();
                        pkFieldValues = new StringBuffer("");
                        pkFieldNames = new StringBuffer("");
                        continue;
                    }
                    detailBuff.append("\"" + tagName + objContext + "\": {" + "\n");
                    detailBuff.append(fieldDataBuff.toString());
                    bw.write(detailBuff.toString());
                    bw.flush();
                    pkFieldValues = new StringBuffer("");
                    pkFieldNames = new StringBuffer("");
                }
                workflowProcessInstanceMonitorEJB = null;
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                myCon.close();
                myCon = null;
                dw.remove();
                BaseLogger.log("3", userInfo, null, "Json built in [" + (System.currentTimeMillis() - start) + "ms]");
                String moreRecordExists = "";
                if (CommonConstants.MAX_BROW_ROW != null && CommonConstants.MAX_BROW_ROW.length() > 0 && count > Integer.parseInt(CommonConstants.MAX_BROW_ROW)) {
                    moreRecordExists = " Display " + CommonConstants.MAX_BROW_ROW + " out of " + count + " rows ";
                }
                bw.flush();
                this.finalizer();
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DB2JSONGenerator :createJSON ==>\n");
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (myCon != null) {
                    myCon.close();
                    myCon = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return String.valueOf(fileName) + ".json";
    }

    public String createJSON(String objName, String objContext, String pageContext, String qryParam, String qryParamType, String filterString, String userInfoStr, String globalFilterString) throws Exception {
        BaseLogger.log("0", null, null, "[DB2JSONGenerator] call second");
        return this.createJSON(objName, objContext, pageContext, qryParam, qryParamType, filterString, userInfoStr, globalFilterString, true);
    }

    public String createJSON(String objName, String objContext, String pageContext, String qryParam, String qryParamType, String filterString, String userInfoStr, String globalFilterString, boolean isMaxBrowCheck) throws Exception {
        BaseLogger.log("0", null, null, "[DB2JSONGenerator] call third");
        BaseLogger.log("2", null, null, "[DB2JSONGenerator]Creating json file for \n globalFilterString :" + globalFilterString + ": \n objName :" + objName + ": \nobjContext :" + objContext + ": \npageContext :" + pageContext + ": \nqryParam :" + qryParam + ": \nqryParamType :" + qryParamType + ": \nfilterString :" + filterString + ":");
        String fileName = null;
        Connection myCon = null;
        Statement pstmt = null;
        UserInfoBean userInfo = null;
        ResultSet rs = null;
        try {
            try {
                int domId;
                if (userInfoStr != null && userInfoStr.length() > 0) {
                    userInfo = new UserInfoBean(userInfoStr);
                }
                BaseLogger.log("3", userInfo, null, "In DB2JSONGenerator createJSON 682 this.objName[" + this.objName + "] objName[" + objName + "]");
                this.objName = this.objName != objName ? objName : this.objName;
                BaseLogger.log("3", userInfo, null, "In DB2JSONGenerator createJSON 684 this.objName[" + this.objName + "]");
                String key = String.valueOf(objName) + pageContext + objContext;
                BaseLogger.log("3", userInfo, null, "Key :[" + key + "]");
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                String condition = "TRAN_WINDOW = 'w_" + this.objName + "' ";
                String workFlowOpt = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "WORKFLOW_OPT", condition, userInfo.getTransDB()));
                String workFlowInit = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "WRKFLW_INIT", condition, userInfo.getTransDB()));
                String refSer = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER", condition, userInfo.getTransDB()));
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() refSerL::[" + refSer + "]");
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() workFlowOpt::[" + workFlowOpt + "]");
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() workFlowInit::[" + workFlowInit + "]");
                String confirmCol = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "CONFIRM_COL", condition, userInfo.getTransDB()));
                String confirmColVal = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "CONFIRM_VAL", condition, userInfo.getTransDB()));
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() confirmCol@@[" + confirmCol + "]");
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() confirmColVal@@[" + confirmColVal + "]");
                String cancelCol = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "CANCEL_COL", condition, userInfo.getTransDB()));
                String cancelColVal = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "CANCEL_VAL", condition, userInfo.getTransDB()));
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() cancelCol@@[" + cancelCol + "]");
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator.createJSON() cancelColVal@@[" + cancelColVal + "]");
                if (this.objFormsDetailList != null && this.objFormsDetailList.size() > 0 && !this.objFormsDetailList.isEmpty()) {
                    this.setObjFormInfoMap(this.objFormsDetailList);
                }
                String formName = "";
                if (this.objFormInfoMap != null && !this.objFormInfoMap.isEmpty()) {
                    formName = this.getObjPropValue(objContext, "FORM_NAME");
                }
                DWFactory dws = new DWFactory(userInfo);
                DWObject dw = null;
                dw = formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName) ? dws.getDataWindow(objName, pageContext, objContext, formName) : dws.getDataWindow(objName, pageContext, objContext);
                this.pkColIdList = dw.getKeyList();
                this.colIdNameMap = dw.getColIDLogNameMap();
                this.database = CommonConstants.DB_NAME;
                this.colLogNameTypeMap = dw.getColIDLogNameMap();
                BaseLogger.log("3", userInfo, null, "getFormWisePkFldNameMap() - " + this.getFormWisePkFldNameMap());
                String pkFldNames = "";
                if (this.getFormWisePkFldNameMap() != null && this.getFormWisePkFldNameMap().containsKey(objContext)) {
                    pkFldNames = this.getFormWisePkFldNameMap().get(objContext);
                }
                BaseLogger.log("3", userInfo, null, "pkFldNames - [" + pkFldNames + "]");
                dw = formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName) ? dws.getDataWindow(objName, "1".equals(objContext) || pageContext.length() == 0 ? pageContext : "1", formName) : dws.getDataWindow(objName, "1".equals(objContext) || pageContext.length() == 0 ? pageContext : "1", objContext);
                BaseLogger.log("3", userInfo, null, "dw.getTableToBeUpdated() - [" + dw.getTableToBeUpdated() + "]");
                String tableName = E12GenericUtility.checkNull(dw.getTableToBeUpdated()).toUpperCase();
                if (tableName == null || tableName.trim().length() == 0) {
                    DWObject dwObj = null;
                    dwObj = formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName) ? dws.getDataWindow(objName, "2", formName) : dws.getDataWindow(objName, "2", objContext);
                    tableName = E12GenericUtility.checkNull(dwObj.getTableToBeUpdated()).toUpperCase();
                }
                String basicQry = "";
                basicQry = this.uptoRowNum != 0 ? dw.getQueryString(true).toUpperCase() : dw.getQueryString().toUpperCase();
                String finalQuery = this.getUpdateQuery(basicQry, filterString);
                if (this.rowSecurityInfo != null) {
                    finalQuery = this.getRowSecurityQuery(finalQuery);
                }
                ConnDriver con = new ConnDriver();
                String transDB = userInfo.getTransDB();
                myCon = con.getConnectDB(transDB);
                if (this.uptoRowNum != 0) {
                    BaseLogger.log("3", userInfo, null, "DB2JSONGenerator : createJSON : Befour row number appending :\n" + finalQuery);
                    finalQuery = this.getRowNumAppendQuery(finalQuery, this.currentRowNum, this.uptoRowNum, userInfo, tableName, con);
                    domId = this.currentRowNum;
                } else {
                    domId = 1;
                }
                BaseLogger.log("3", userInfo, null, "DB2JSONGenerator : createJSON : Final Query :\n" + finalQuery);
                fileName = String.valueOf(System.currentTimeMillis());
                File fileObj = new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "jsondatafiles" + File.separator + fileName + ".json");
                BaseLogger.log("3", userInfo, null, "Json File Path " + fileObj.getAbsolutePath());
                if (!fileObj.getParentFile().exists()) {
                    fileObj.getParentFile().mkdirs();
                }
                FileOutputStream fout = new FileOutputStream(fileObj);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, userInfo != null ? userInfo.getCharEnc() : CommonConstants.ENCODING));
                bw.write("{\"DocumentRoot\" : {");
                bw.flush();
                BaseLogger.log("3", userInfo, null, "Executing Query...........");
                long start = System.currentTimeMillis();
                E12GenericUtility genericUtility = new E12GenericUtility();
                pstmt = myCon.prepareStatement(finalQuery);
                qryParamType = qryParamType != null && qryParamType.endsWith(":") ? qryParamType : String.valueOf(qryParamType) + ":";
                String string = qryParam = qryParam != null && qryParam.endsWith(":") ? qryParam : String.valueOf(qryParam) + ":";
                if (qryParam != null && finalQuery.indexOf("?") != -1) {
                    StringTokenizer qryParamTokens = new StringTokenizer(qryParam);
                    int pCount = 1;
                    while (qryParamTokens.hasMoreTokens()) {
                        String testParam = qryParamTokens.nextToken(":");
                        if (qryParamType != null) {
                            String testParamType = qryParamType.substring(0, qryParamType.indexOf(":"));
                            if (testParamType.equalsIgnoreCase("DATETIME")) {
                                testParam = this.isRCP ? genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat()) : genericUtility.getValidDateTimeString(testParam, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                                pstmt.setTimestamp(pCount, Timestamp.valueOf(testParam));
                            } else if (testParamType.equalsIgnoreCase("DATE")) {
                                if (this.database.equalsIgnoreCase("Oracle")) {
                                    testParam = this.isRCP ? this.getValidDateString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat()) : this.getValidDateString(testParam, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                                    pstmt.setDate(pCount, Date.valueOf(testParam));
                                } else {
                                    testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getApplDateTimeFormat(), genericUtility.getDBDateFormat());
                                    pstmt.setTimestamp(pCount, Timestamp.valueOf(testParam));
                                }
                            } else if (testParamType.equalsIgnoreCase("DECIMAL")) {
                                pstmt.setDouble(pCount, Double.parseDouble(testParam));
                            } else {
                                pstmt.setString(pCount, testParam);
                            }
                            qryParamType = qryParamType.substring(qryParamType.indexOf(":") + 1);
                        } else {
                            pstmt.setString(pCount, testParam);
                        }
                        ++pCount;
                    }
                }
                BaseLogger.log("3", userInfo, null, "Executing Query :" + finalQuery);
                rs = pstmt.executeQuery();
                BaseLogger.log("3", userInfo, null, "Executed Query in [" + (System.currentTimeMillis() - start) + "ms]");
                int pkSize = this.pkColIdList.size();
                int count = 0;
                String tagName = "Detail";
                StringBuffer pkFieldValues = new StringBuffer("");
                StringBuffer pkFieldNames = new StringBuffer("");
                BaseLogger.log("3", userInfo, null, "Building JSON from ResultSet ");
                start = System.currentTimeMillis();
                String dbDataFormat = genericUtility.getDBDateFormat();
                String applDataFormat = genericUtility.getApplDateFormat();
                String dbDataTimeFormat = genericUtility.getDBDateTimeFormat();
                String applDateTimeFormat = genericUtility.getApplDateTimeFormat();
                ArrayList columnObjs = dw.getColumnsList();
                HashMap<String, List<String>> jsonMap = new HashMap<String, List<String>>();
                WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitorEJB = new WorkflowProcessInstanceMonitorEJB();
                while (rs.next()) {
                    HashMap<String, String> fldValueMap = new HashMap<String, String>();
                    StringBuffer fieldDataBuff = new StringBuffer();
                    StringBuffer detailBuff = new StringBuffer();
                    StringBuffer detailDataBuff = new StringBuffer();
                    boolean isExist = false;
                    int startCount = 0;
                    int columnObjSize = 0;
                    if (this.uptoRowNum != 0 && "mysql".equalsIgnoreCase(con.getDBName())) {
                        startCount = 0;
                        columnObjSize = columnObjs.size();
                    } else {
                        startCount = 1;
                        columnObjSize = columnObjs.size() + 1;
                    }
                    int j = startCount;
                    while (j < columnObjSize) {
                        java.util.Date currDate;
                        String data = null;
                        Column colObj = null;
                        colObj = startCount == 0 ? (Column)columnObjs.get(j) : (Column)columnObjs.get(j - 1);
                        if (this.uptoRowNum != 0) {
                            if (colObj.getColType().equalsIgnoreCase("DATETIME")) {
                                currDate = rs.getTimestamp(j + 1);
                                data = currDate != null ? genericUtility.getValidDateTimeString(((Timestamp)currDate).toString(), dbDataTimeFormat, applDateTimeFormat) : null;
                            } else if (colObj.getColType().equalsIgnoreCase("DATE")) {
                                currDate = rs.getDate(j + 1);
                                data = currDate != null ? genericUtility.getValidDateString(((Date)currDate).toString(), dbDataFormat, applDataFormat) : null;
                            } else if (colObj.getColType().equalsIgnoreCase("TIMESTAMP")) {
                                currDate = rs.getTimestamp(j + 1);
                                if (currDate != null) {
                                    data = genericUtility.getValidDateTimeString(((Timestamp)currDate).toString(), dbDataFormat, applDataFormat);
                                }
                            } else if (colObj.getColType().equalsIgnoreCase("TIME")) {
                                currDate = rs.getTimestamp(j + 1);
                                if (currDate != null) {
                                    data = genericUtility.getValidDateTimeString((Timestamp)currDate, genericUtility.getDisplayTimeFormat());
                                }
                            } else {
                                data = rs.getString(j + 1);
                            }
                        } else if (colObj.getColType().equalsIgnoreCase("DATETIME")) {
                            currDate = rs.getTimestamp(j);
                            data = currDate != null ? genericUtility.getValidDateTimeString(((Timestamp)currDate).toString(), dbDataTimeFormat, applDateTimeFormat) : null;
                        } else if (colObj.getColType().equalsIgnoreCase("DATE")) {
                            currDate = rs.getDate(j);
                            data = currDate != null ? genericUtility.getValidDateString(((Date)currDate).toString(), dbDataFormat, applDataFormat) : null;
                        } else if (colObj.getColType().equalsIgnoreCase("TIMESTAMP")) {
                            currDate = rs.getTimestamp(j);
                            if (currDate != null) {
                                data = genericUtility.getValidDateTimeString(((Timestamp)currDate).toString(), dbDataFormat, applDataFormat);
                            }
                        } else if (colObj.getColType().equalsIgnoreCase("TIME")) {
                            currDate = rs.getTimestamp(j);
                            if (currDate != null) {
                                data = genericUtility.getValidDateTimeString((Timestamp)currDate, genericUtility.getDisplayTimeFormat());
                            }
                        } else {
                            data = rs.getString(j);
                        }
                        if (data == null) {
                            data = "";
                        }
                        if (pkSize != 0) {
                            if (this.uptoRowNum != 0 && "mysql".equalsIgnoreCase(con.getDBName())) {
                                if (this.pkColIdList.contains(new Integer(j + 1))) {
                                    pkFieldValues.append(String.valueOf(data) + ":");
                                    pkFieldNames.append(String.valueOf((String)this.colIdNameMap.get(new Integer(j + 1))) + ":");
                                }
                            } else if (this.pkColIdList.contains(new Integer(j))) {
                                pkFieldValues.append(String.valueOf(data) + ":");
                                pkFieldNames.append(String.valueOf((String)this.colIdNameMap.get(new Integer(j))) + ":");
                            }
                        }
                        if (colObj.getColType().equalsIgnoreCase("XMLType")) {
                            if (this.uptoRowNum != 0 && "mysql".equalsIgnoreCase(con.getDBName())) {
                                fieldDataBuff.append("\"" + (String)this.colIdNameMap.get(new Integer(j + 1)) + "\":\"" + data + "\",\n");
                            } else {
                                fieldDataBuff.append("\"" + (String)this.colIdNameMap.get(new Integer(j)) + "\":\"" + data + "\",\n");
                            }
                        } else if (this.uptoRowNum != 0 && "mysql".equalsIgnoreCase(con.getDBName())) {
                            fieldDataBuff.append("\"" + (String)this.colIdNameMap.get(new Integer(j + 1)) + "\":\"" + data + "\",\n");
                        } else {
                            fieldDataBuff.append("\"" + (String)this.colIdNameMap.get(new Integer(j)) + "\":\"" + data + "\",\n");
                        }
                        data = this.dataTrim(data);
                        detailDataBuff.append(String.valueOf(data) + ":");
                        if (this.uptoRowNum != 0 && "mysql".equalsIgnoreCase(con.getDBName())) {
                            fldValueMap.put((String)this.colIdNameMap.get(new Integer(j + 1)), data);
                        } else {
                            fldValueMap.put((String)this.colIdNameMap.get(new Integer(j)), data);
                        }
                        ++j;
                    }
                    if (!(workFlowOpt.length() <= 0 || workFlowInit.length() <= 0 || "0".equals(workFlowOpt) || confirmCol.length() > 0 && confirmColVal.length() > 0 && !confirmColVal.equals(fldValueMap.get(confirmCol)) || cancelCol.length() > 0 && cancelColVal.length() > 0 && !cancelColVal.equals(fldValueMap.get(cancelCol)))) {
                        System.out.println("DB2JSONGenerator.createJSON() in if of getting workflow_status");
                        String refId = pkFieldValues.toString();
                        int lastIndexOfColon = refId.lastIndexOf(":");
                        if (lastIndexOfColon > -1 && lastIndexOfColon == refId.length() - 1) {
                            refId = E12GenericUtility.checkNull(refId.substring(0, lastIndexOfColon));
                        }
                        String workflowStatus = workflowProcessInstanceMonitorEJB.getProcessStatus(workFlowInit, objName, refSer, refId, myCon);
                        fieldDataBuff.append("workflowStatus: " + workflowStatus + ",\n");
                    }
                    String pkFieldValue = "";
                    String pkFieldName = "";
                    if (E12GenericUtility.checkNull(pkFldNames).length() > 0) {
                        String[] pkFldNamesArr = pkFldNames.split(":");
                        int i = 0;
                        while (i < pkFldNamesArr.length) {
                            pkFieldValue = String.valueOf(pkFieldValue) + (String)fldValueMap.get(pkFldNamesArr[i]) + ":";
                            pkFieldName = String.valueOf(pkFieldName) + pkFldNamesArr[i] + ":";
                            ++i;
                        }
                        BaseLogger.log("3", userInfo, null, "pkFieldValue - [" + pkFieldValue + "]");
                        pkFieldValues = new StringBuffer("");
                        pkFieldNames = new StringBuffer("");
                        pkFieldValues.append(pkFieldValue);
                        pkFieldNames.append(pkFieldName);
                    }
                    if (pkFieldValues.toString().endsWith(":")) {
                        pkFieldValues = pkFieldValues.deleteCharAt(pkFieldValues.length() - 1);
                    }
                    if ((isExist = this.isDataExist(detailDataBuff.toString(), globalFilterString)) || globalFilterString.trim().length() == 0) {
                        if (CommonConstants.MAX_BROW_ROW != null && CommonConstants.MAX_BROW_ROW.length() > 0 && isMaxBrowCheck) {
                            if (++count <= Integer.parseInt(CommonConstants.MAX_BROW_ROW)) {
                                detailBuff.append("\"" + tagName + objContext + "\": {" + "\n");
                                BaseLogger.log("3", userInfo, null, "Detail Tag name for 1st if ===>" + tagName + objContext);
                                detailBuff.append(fieldDataBuff.toString());
                                bw.write(detailBuff.toString());
                                bw.flush();
                                if (jsonMap.containsKey(String.valueOf(tagName) + objContext)) {
                                    ((List)jsonMap.get(String.valueOf(tagName) + objContext)).add(fieldDataBuff.toString());
                                } else {
                                    jsonMap.put(String.valueOf(tagName) + objContext, Arrays.asList(fieldDataBuff.toString()));
                                }
                            }
                        } else {
                            if (detailBuff.indexOf(String.valueOf(tagName) + objContext) == -1) {
                                BaseLogger.log("3", userInfo, null, "Detail Tag Not Exist ===>" + tagName + objContext);
                            } else {
                                BaseLogger.log("3", userInfo, null, "Detail Tag Exist ===>" + tagName + objContext);
                            }
                            detailBuff.append("\"" + tagName + objContext + "\":[ {" + "\n");
                            BaseLogger.log("3", userInfo, null, "Detail Tag name ===>" + tagName + objContext);
                            fieldDataBuff.deleteCharAt(fieldDataBuff.length() - 1);
                            BaseLogger.log("3", userInfo, null, "Detail Data ===>" + fieldDataBuff.toString());
                            BaseLogger.log("3", userInfo, null, "detailBuff===>" + detailBuff.toString());
                            String fieldDataBuffstr = fieldDataBuff.toString();
                            fieldDataBuffstr = fieldDataBuffstr.substring(0, fieldDataBuffstr.length() - 1);
                            BaseLogger.log("3", userInfo, null, "fieldDataBuffstr===>" + fieldDataBuffstr);
                            detailBuff.append(fieldDataBuffstr);
                            detailBuff.append("}]}}\n");
                            BaseLogger.log("3", userInfo, null, "detailBuff with Data===>" + detailBuff.toString());
                            bw.write(detailBuff.toString());
                            bw.flush();
                            if (jsonMap.containsKey(String.valueOf(tagName) + objContext)) {
                                ((List)jsonMap.get(String.valueOf(tagName) + objContext)).add(fieldDataBuff.toString());
                            } else {
                                jsonMap.put(String.valueOf(tagName) + objContext, Arrays.asList(fieldDataBuff.toString()));
                            }
                        }
                    }
                    pkFieldValues = new StringBuffer("");
                    pkFieldNames = new StringBuffer("");
                }
                BaseLogger.log("3", userInfo, null, "Json Mamp===>" + jsonMap);
                workflowProcessInstanceMonitorEJB = null;
                BaseLogger.log("3", userInfo, null, "JSON built in [" + (System.currentTimeMillis() - start) + "ms]");
                String moreRecordExists = "";
                if (CommonConstants.MAX_BROW_ROW != null && CommonConstants.MAX_BROW_ROW.length() > 0 && count > Integer.parseInt(CommonConstants.MAX_BROW_ROW) && isMaxBrowCheck) {
                    moreRecordExists = " Display " + CommonConstants.MAX_BROW_ROW + " out of " + count + " rows ";
                }
                bw.flush();
                rs.close();
                rs = null;
                this.finalizer();
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DB2JSONGenerator :createJSON ==>\n");
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (myCon != null) {
                    myCon.close();
                    myCon = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return String.valueOf(fileName) + ".json";
    }

    private String getUpdateQuery(String sqlQry, String filterString) throws Exception {
        try {
            if (filterString != null && filterString.length() > 0) {
                boolean isWhereClause = true;
                if (sqlQry.toUpperCase().indexOf(" WHERE ") == -1) {
                    sqlQry = String.valueOf(sqlQry) + " WHERE ";
                    isWhereClause = false;
                }
                if (isWhereClause && (filterString.toUpperCase().startsWith("AND ") || filterString.toUpperCase().startsWith("OR "))) {
                    if (sqlQry.contains(" GROUP ")) {
                        String[] st = sqlQry.split("GROUP ");
                        String stringQry = "";
                        String[] stringArray = st;
                        int n = st.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String retval = stringArray[n2];
                            if (retval != null && retval.trim().startsWith("BY ")) {
                                retval = String.valueOf(filterString.toUpperCase()) + " GROUP " + retval;
                            }
                            sqlQry = stringQry = String.valueOf(stringQry) + retval;
                            ++n2;
                        }
                    } else if (sqlQry.contains(" ORDER ")) {
                        String[] st = sqlQry.split("ORDER ");
                        String stringQry = "";
                        String[] stringArray = st;
                        int n = st.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String retval = stringArray[n3];
                            if (retval != null && retval.trim().startsWith("BY ")) {
                                retval = String.valueOf(filterString.toUpperCase()) + " ORDER " + retval;
                            }
                            sqlQry = stringQry = String.valueOf(stringQry) + retval;
                            ++n3;
                        }
                    } else {
                        sqlQry = String.valueOf(sqlQry) + " " + filterString;
                    }
                } else if (!isWhereClause && (filterString.toUpperCase().startsWith("AND ") || filterString.toUpperCase().startsWith("OR "))) {
                    int index = filterString.toUpperCase().startsWith("AND ") ? filterString.toUpperCase().indexOf("AND") + 3 : filterString.toUpperCase().indexOf("OR") + 2;
                    sqlQry = String.valueOf(sqlQry) + filterString.substring(index);
                } else {
                    sqlQry = isWhereClause ? String.valueOf(sqlQry) + " AND " + filterString : String.valueOf(sqlQry) + filterString;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "[DB2JSONGenerator]:getUpdateQuery :Error:" + e.getMessage());
            throw e;
        }
        return sqlQry;
    }

    private String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) throws ITMException {
        java.util.Date date = null;
        String retDateStr = "";
        try {
            if (sourceDateFormat.indexOf("/") != -1) {
                dateStr.replace('/', '-');
            } else if (sourceDateFormat.indexOf(".") != -1) {
                dateStr.replace('.', '-');
            }
            date = new SimpleDateFormat(String.valueOf(sourceDateFormat) + (dateStr.length() > 11 ? " HH:mm:ss" : "")).parse(dateStr);
            SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateFormat);
            retDateStr = sdfOutput.format((Object)date);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DB2JSONGenerator :getValidDateString :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return retDateStr;
    }

    public void finalizer() throws Exception {
    }

    public void setRowSecurityInfo(HashMap rowSecurityInfo) {
        this.rowSecurityInfo = rowSecurityInfo;
    }

    public String getRowSecurityQuery(String query) throws Exception {
        try {
            String orderByPart = null;
            if (query != null && query.contains(" ORDER BY ")) {
                orderByPart = query.substring(query.indexOf("ORDER BY"), query.length());
                query = query.substring(0, query.indexOf("ORDER BY"));
            }
            int fromIndex = query.toUpperCase().indexOf(" FROM ");
            int whereIndex = query.indexOf("WHERE ");
            StringBuffer finalQuery = new StringBuffer();
            String selectPart = query.substring(0, fromIndex);
            BaseLogger.log("3", null, null, "selectPart :[" + selectPart + "]");
            String fromPart = null;
            String wherePart = null;
            String rowSecurityWhere = this.readRowSecurity();
            String joinPredicates = null;
            if (whereIndex != -1) {
                fromPart = query.substring(fromIndex + 5, whereIndex);
                wherePart = query.substring(whereIndex + 5);
            } else {
                fromPart = query.substring(fromIndex + 5);
            }
            fromPart = this.buildFrom(fromPart);
            wherePart = this.buildWhere(wherePart, rowSecurityWhere, joinPredicates);
            finalQuery.append(selectPart);
            finalQuery.append(fromPart);
            if (wherePart != null) {
                finalQuery.append(wherePart);
            }
            if (orderByPart != null) {
                finalQuery.append(" " + orderByPart);
            }
            return finalQuery.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private String readRowSecurity() throws Exception {
        StringBuffer securityBuffer = new StringBuffer();
        if (this.rowSecurityInfo != null) {
            for (String tableName : this.rowSecurityInfo.keySet()) {
                securityBuffer.append(this.rowSecurityInfo.get(tableName) + " AND ");
                if ("ACC_FILT".equals(tableName) || this.selectedTables.contains(tableName.trim())) continue;
                this.selectedTables.add(tableName.trim());
            }
        }
        if (securityBuffer != null && securityBuffer.length() > 0) {
            int index = securityBuffer.toString().lastIndexOf(" AND ");
            if (index != -1) {
                securityBuffer.replace(index, index + 5, " ");
            }
            return "(" + securityBuffer.toString().trim() + ")";
        }
        return null;
    }

    private String buildFrom(String fromPart) throws Exception {
        StringBuffer fromBuffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(fromPart, ",");
        ArrayList<String> existingTables = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken().trim();
            if (currToken.indexOf(" ") != -1) {
                currToken = currToken.substring(0, currToken.indexOf(" "));
            }
            existingTables.add(currToken.toUpperCase());
        }
        int ctr = 0;
        while (ctr < this.selectedTables.size()) {
            String tableName = ((String)this.selectedTables.get(ctr)).toUpperCase();
            String string = tableName = tableName != null ? tableName.trim() : tableName;
            if (!existingTables.contains(tableName)) {
                fromBuffer.append(String.valueOf(tableName) + ",");
            }
            ++ctr;
        }
        if (fromBuffer != null && fromBuffer.length() > 0) {
            int index = fromBuffer.toString().lastIndexOf(44);
            if (index != -1) {
                fromBuffer.replace(index, index + 1, " ");
            }
            return " FROM " + fromPart + "," + fromBuffer.toString();
        }
        return " FROM " + fromPart;
    }

    private String buildWhere(String wherePart, String rowSecurityWhere, String joinPredicates) throws Exception {
        StringBuffer whereBuf = new StringBuffer();
        Object groupPart = null;
        int groupIndex = -1;
        boolean isExist = false;
        if (wherePart != null) {
            isExist = true;
            whereBuf.append(" WHERE ");
            groupIndex = wherePart.indexOf(" GROUP BY ");
            if (groupIndex != -1) {
                whereBuf.append(wherePart.substring(0, groupIndex));
            } else {
                BaseLogger.log("3", null, null, "\n\n\n\t\t GROUP BY  CLAUSE NOT FOUND ..");
                whereBuf.append(wherePart);
            }
        }
        if (rowSecurityWhere != null) {
            if (!isExist) {
                whereBuf.append(" WHERE ");
            } else {
                whereBuf.append(" AND ");
            }
            whereBuf.append(rowSecurityWhere);
        }
        if (joinPredicates != null) {
            if (!isExist) {
                whereBuf.append(" WHERE ");
            } else {
                whereBuf.append(" AND ");
            }
            whereBuf.append(joinPredicates);
        }
        if (groupIndex != -1) {
            whereBuf.append(wherePart.substring(groupIndex));
        }
        return whereBuf.toString();
    }

    private String getDispDateFormat() throws ITMException, Exception {
        String dateFormatStr = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml");
            NodeList nlDateFormat = doc.getElementsByTagName("DISP_DATE_FORMAT");
            Node ndDateFormat = nlDateFormat.item(0);
            dateFormatStr = ndDateFormat.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DB2JSONGenerator :getDispDateFormat :==>\n" + e);
            throw new ITMException(e);
        }
        return dateFormatStr;
    }

    public void setRCP(boolean isRCP) {
        this.isRCP = isRCP;
    }

    public ArrayList getpkDetaiList() {
        return this.pkDetaiList;
    }

    public boolean isDataExist(String data, String filterStr) {
        boolean isExist;
        block9: {
            data = data.toUpperCase();
            filterStr = filterStr.toUpperCase();
            isExist = false;
            try {
                if (filterStr == null || filterStr.length() <= 0) break block9;
                if (filterStr.indexOf("AND") != -1) {
                    String[] andStringArray = filterStr.split(" AND ");
                    int cnt = 0;
                    while (cnt < andStringArray.length) {
                        if (data.indexOf(andStringArray[cnt].trim()) == -1) {
                            isExist = false;
                            break block9;
                        }
                        isExist = true;
                        ++cnt;
                    }
                    break block9;
                }
                if (filterStr.indexOf("OR") != -1) {
                    String[] orStringArray = filterStr.split(" OR ");
                    int cnt = 0;
                    while (cnt < orStringArray.length) {
                        if (data.indexOf(orStringArray[cnt].trim()) != -1) {
                            isExist = true;
                            break block9;
                        }
                        isExist = false;
                        ++cnt;
                    }
                    break block9;
                }
                if (data.indexOf(filterStr.trim()) != -1) {
                    isExist = true;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :DB2JSONGenerator :isDataExist :==>\n" + e);
                e.printStackTrace();
            }
        }
        return isExist;
    }

    private String dataTrim(String data) {
        String trimData = "";
        try {
            if (data != null && data.length() > 0 && data.trim().indexOf(" ") != -1) {
                String[] andStringArray = data.split(" ");
                int cnt = 0;
                while (cnt < andStringArray.length) {
                    if (andStringArray[cnt] != null && andStringArray[cnt].length() > 0) {
                        trimData = String.valueOf(trimData) + " " + andStringArray[cnt].trim();
                    }
                    ++cnt;
                }
            } else {
                trimData = data;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DB2JSONGenerator :dataTrim :==>\n" + e);
            e.printStackTrace();
        }
        return trimData.trim();
    }

    private void printColObj(Column colObj) {
        if (colObj != null) {
            BaseLogger.log("3", null, null, "@printColObj Column ColType[" + colObj.getColType() + "]");
            BaseLogger.log("3", null, null, "@printColObj Column LogicalName[" + colObj.getLogicalName() + "]");
            BaseLogger.log("3", null, null, "@printColObj Column DisplayName[" + colObj.getDisplayName() + "]");
        }
    }

    public TreeMap createDataMap(String objName, String objContext, String pageContext, String qryParam, String qryParamType, String filterString, String recordTagName, String userInfostr) throws Exception {
        TreeMap<String, String> dataMap = new TreeMap<String, String>();
        HashMap<String, Integer> domIdCtrMap = new HashMap<String, Integer>();
        Connection myCon = null;
        this.pkDetaiList = new ArrayList();
        Statement pstmt = null;
        ResultSet rs = null;
        UserInfoBean userInfo = null;
        try {
            try {
                if (userInfostr != null && userInfostr.length() > 0) {
                    userInfo = new UserInfoBean(userInfostr);
                }
                E12GenericUtility genericUtility = new E12GenericUtility();
                BaseLogger.log("3", null, null, "In DB2JSONGenerator createJSON 2115 this.objName[" + this.objName + "] objName[" + objName + "]");
                this.objName = this.objName != objName ? objName : this.objName;
                BaseLogger.log("3", null, null, "In DB2JSONGenerator createJSON 2117 this.objName[" + this.objName + "] objName[" + objName + "]");
                String key = String.valueOf(objName) + pageContext + objContext;
                BaseLogger.log("3", null, null, "Key :[" + key + "]");
                long metadataTime = System.currentTimeMillis();
                DWFactory dws = new DWFactory(userInfo);
                BaseLogger.log("3", null, null, "getFormWisePkFldNameMap() - " + this.getFormWisePkFldNameMap());
                String pkFldNames = "";
                if (this.getFormWisePkFldNameMap() != null && this.getFormWisePkFldNameMap().containsKey(objContext)) {
                    pkFldNames = this.getFormWisePkFldNameMap().get(objContext);
                }
                BaseLogger.log("3", null, null, "pkFldNames - [" + pkFldNames + "]");
                if (this.objFormsDetailList != null && this.objFormsDetailList.size() > 0 && !this.objFormsDetailList.isEmpty()) {
                    this.setObjFormInfoMap(this.objFormsDetailList);
                }
                BaseLogger.log("3", null, null, "createJSON >> this.objFormInfoMap ::" + this.objFormInfoMap);
                String formName = this.getFormName(objContext);
                DWObject dw = dws.getDataWindow(String.valueOf(objName) + ("1".equals(objContext) || pageContext.length() == 0 ? pageContext : "1") + formName);
                String basicQry = dw.getQueryString().toUpperCase();
                metadataTime = System.currentTimeMillis() - metadataTime;
                this.database = CommonConstants.DB_NAME;
                String dbName = CommonConstants.DB_NAME;
                this.pkColIdList = dw.getKeyList();
                ArrayList pkColumnIdList = dw.getKeyList();
                int pkSize = pkColumnIdList.size();
                this.colIdNameMap = dw.getColIDLogNameMap();
                HashMap columnIdNameMap = dw.getColIDLogNameMap();
                int noOfCols = columnIdNameMap.size();
                int domId = 1;
                String dbDataFormat = genericUtility.getDBDateFormat();
                String applDataFormat = genericUtility.getApplDateFormat();
                String finalQuery = this.getUpdateQuery(basicQry, filterString);
                String dispDateFormat = genericUtility.getDispDateFormat();
                String dispDateTimeFormat = genericUtility.getDispDateTimeFormat();
                String applDateTimeFormat = genericUtility.getApplDateTimeFormat();
                String dbDateTimeFormat = genericUtility.getDBDateTimeFormat();
                if (this.rowSecurityInfo != null) {
                    finalQuery = this.getRowSecurityQuery(finalQuery);
                }
                String transDB = userInfo.getTransDB();
                myCon = new ConnDriver().getConnectDB(transDB);
                BaseLogger.log("3", null, null, "Executing Query...........");
                long queryExecutionTime = System.currentTimeMillis();
                pstmt = myCon.prepareStatement(finalQuery);
                qryParamType = qryParamType != null && qryParamType.endsWith(":") ? qryParamType : String.valueOf(qryParamType) + ":";
                String string = qryParam = qryParam != null && qryParam.endsWith(":") ? qryParam : String.valueOf(qryParam) + ":";
                if (qryParam != null && finalQuery.indexOf("?") != -1) {
                    StringTokenizer qryParamTokens = new StringTokenizer(qryParam);
                    int pCount = 1;
                    while (qryParamTokens.hasMoreTokens()) {
                        String testParam = qryParamTokens.nextToken(":");
                        if (qryParamType != null) {
                            String testParamType = "";
                            testParamType = qryParamType.contains(":") ? qryParamType.substring(0, qryParamType.indexOf(":")) : qryParamType;
                            if (testParamType.equalsIgnoreCase("DATETIME")) {
                                testParam = this.isRCP ? genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat()) : genericUtility.getValidDateTimeString(testParam, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                                pstmt.setTimestamp(pCount, Timestamp.valueOf(testParam));
                            } else if (testParamType.equalsIgnoreCase("DATE")) {
                                if (dbName.equalsIgnoreCase("Oracle")) {
                                    testParam = this.isRCP ? this.getValidDateString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat()) : this.getValidDateString(testParam, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                                    pstmt.setDate(pCount, Date.valueOf(testParam));
                                } else {
                                    testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getApplDateTimeFormat(), genericUtility.getDBDateFormat());
                                    pstmt.setTimestamp(pCount, Timestamp.valueOf(testParam));
                                }
                            } else if (testParamType.equalsIgnoreCase("DECIMAL")) {
                                pstmt.setDouble(pCount, Double.parseDouble(testParam));
                            } else {
                                pstmt.setString(pCount, testParam);
                            }
                            qryParamType = qryParamType.substring(qryParamType.indexOf(":") + 1);
                        } else {
                            pstmt.setString(pCount, testParam);
                        }
                        ++pCount;
                    }
                }
                BaseLogger.log("3", null, null, "Executing Query :" + finalQuery);
                rs = pstmt.executeQuery();
                queryExecutionTime = System.currentTimeMillis() - queryExecutionTime;
                ResultSetMetaData rsmdata = rs.getMetaData();
                int noOfColumns = rsmdata.getColumnCount();
                ArrayList<Integer> colTypeList = new ArrayList<Integer>();
                int j = 1;
                while (j <= noOfColumns) {
                    colTypeList.add(new Integer(rsmdata.getColumnType(j)));
                    ++j;
                }
                StringBuffer pkFieldValues = new StringBuffer("");
                StringBuffer pkFieldNames = new StringBuffer("");
                long dataMapBuiltTime = System.currentTimeMillis();
                ArrayList columnObjs = dw.getColumnsList();
                while (rs.next()) {
                    HashMap<String, String> fldValueMap = new HashMap<String, String>();
                    StringBuffer fieldDataBuff = new StringBuffer();
                    StringBuffer detailBuff = new StringBuffer();
                    int j2 = 1;
                    while (j2 <= noOfCols) {
                        java.util.Date currDate;
                        String data = null;
                        Column colObj = (Column)columnObjs.get(j2 - 1);
                        if (colObj.getColType().equalsIgnoreCase("DATETIME")) {
                            currDate = rs.getTimestamp(j2);
                            data = currDate != null ? genericUtility.getValidDateTimeString((Timestamp)currDate, applDateTimeFormat) : null;
                        } else if (colObj.getColType().equalsIgnoreCase("DATE")) {
                            currDate = rs.getDate(j2);
                            data = currDate != null ? genericUtility.getValidDateString(((Date)currDate).toString(), dbDataFormat, applDataFormat) : null;
                        } else if (colObj.getColType().equalsIgnoreCase("TIMESTAMP")) {
                            currDate = rs.getTimestamp(j2);
                            if (currDate != null) {
                                data = currDate != null ? genericUtility.getValidDateTimeString(((Timestamp)currDate).toString(), dbDataFormat, applDataFormat) : null;
                            }
                        } else if (colObj.getColType().equalsIgnoreCase("TIME")) {
                            currDate = rs.getTimestamp(j2);
                            if (currDate != null) {
                                data = currDate != null ? genericUtility.getValidDateTimeString((Timestamp)currDate, genericUtility.getDisplayTimeFormat()) : null;
                            }
                        } else {
                            data = rs.getString(j2);
                        }
                        if (data == null) {
                            data = "";
                        }
                        if (pkSize != 0 && pkColumnIdList.contains(new Integer(j2))) {
                            pkFieldValues.append(String.valueOf(data) + ":");
                            pkFieldNames.append(String.valueOf((String)columnIdNameMap.get(new Integer(j2))) + ":");
                        }
                        if (colObj.getColType().equalsIgnoreCase("JSONType")) {
                            fieldDataBuff.append("<" + (String)columnIdNameMap.get(new Integer(j2)) + ">" + data + "</" + (String)columnIdNameMap.get(new Integer(j2)) + ">" + "\n");
                        } else {
                            fieldDataBuff.append("<" + (String)columnIdNameMap.get(new Integer(j2)) + "><![CDATA[" + data + "]]></" + (String)columnIdNameMap.get(new Integer(j2)) + ">" + "\n");
                        }
                        fldValueMap.put((String)columnIdNameMap.get(new Integer(j2)), data);
                        ++j2;
                    }
                    if (recordTagName.length() > 0) {
                        fieldDataBuff.append("</" + recordTagName + objContext + ">\n");
                    }
                    String pkFieldValue = "";
                    String pkFieldName = "";
                    if (E12GenericUtility.checkNull(pkFldNames).length() > 0) {
                        String[] pkFldNamesArr = pkFldNames.split(":");
                        int i = 0;
                        while (i < pkFldNamesArr.length) {
                            pkFieldValue = String.valueOf(pkFieldValue) + (String)fldValueMap.get(pkFldNamesArr[i]) + ":";
                            pkFieldName = String.valueOf(pkFieldName) + pkFldNamesArr[i] + ":";
                            ++i;
                        }
                        BaseLogger.log("3", null, null, "pkFieldValue - [" + pkFieldValue + "]");
                        pkFieldValues = new StringBuffer("");
                        pkFieldNames = new StringBuffer("");
                        pkFieldValues.append(pkFieldValue);
                        pkFieldNames.append(pkFieldName);
                    }
                    if (pkFieldValues.toString().endsWith(":")) {
                        pkFieldValues = pkFieldValues.deleteCharAt(pkFieldValues.length() - ":".length());
                    }
                    String pkValuesStr = pkFieldValues.toString();
                    Integer domIdCtrObj = (Integer)domIdCtrMap.get(pkValuesStr);
                    int domIdCtr = 0;
                    if (domIdCtrObj != null) {
                        domIdCtr = domIdCtrObj;
                    }
                    domIdCtrMap.put(pkValuesStr, new Integer(domIdCtr + 1));
                    if (recordTagName.length() > 0) {
                        if (objContext != null && "1".equals(objContext)) {
                            String id = String.valueOf(objContext) + ":" + domId + ":" + pkValuesStr;
                            detailBuff.append("<" + recordTagName + objContext + " id='" + id + "' " + "dbID='" + pkValuesStr + "' " + "domID='" + (Integer)domIdCtrMap.get(pkValuesStr) + "' " + "objName='" + objName + "' " + "objContext='" + objContext + "'>\n");
                        } else {
                            detailBuff.append("<" + recordTagName + objContext + " dbID='" + pkValuesStr + "' " + "domID='" + (Integer)domIdCtrMap.get(pkValuesStr) + "' " + "objName='" + objName + "' " + "objContext='" + objContext + "'>\n");
                        }
                    }
                    detailBuff.append("<attribute pkNames='" + pkFieldNames.toString() + "' status='O' updateFlag='N' selected='N' />" + "\n");
                    detailBuff.append(fieldDataBuff.toString());
                    String dataValue = (String)dataMap.get(pkValuesStr);
                    if (dataValue == null) {
                        dataValue = "";
                    }
                    dataMap.put(pkValuesStr, String.valueOf(dataValue) + detailBuff.toString());
                    this.pkDetaiList.add(pkValuesStr);
                    pkFieldValues = new StringBuffer("");
                    pkFieldNames = new StringBuffer("");
                }
                dataMapBuiltTime = System.currentTimeMillis() - dataMapBuiltTime;
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log("3", null, null, "Time log : metadataTime :[" + metadataTime + "] queryExecutionTime :[" + queryExecutionTime + "] dataMapBuiltTime :[" + dataMapBuiltTime + "] Total time :[" + (metadataTime + queryExecutionTime + dataMapBuiltTime) + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :DB2JSONGenerator :createJSON ==>\n");
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (myCon != null) {
                    myCon.close();
                    myCon = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return dataMap;
    }

    private String getObjPropValue(String formNo, String objPropName) {
        String value;
        block11: {
            value = "";
            if (this.objFormInfoMap != null) break block11;
            BaseLogger.log("3", null, null, String.valueOf(objPropName) + "= []");
            return "";
        }
        try {
            String objFromInfo = this.objFormInfoMap.get(formNo);
            if (objFromInfo != null) {
                String[] strArr = objFromInfo.split(";");
                if ("FORM_TYPE".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 0 ? strArr[0] : "";
                } else if ("PARENT_KEY_COL".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 1 ? strArr[1] : "";
                } else if ("SCR_FLAG".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 2 ? strArr[2] : "";
                } else if ("FORM_NAME".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 3 ? strArr[3] : "";
                }
            }
            BaseLogger.log("3", null, null, String.valueOf(objPropName) + "= [" + value + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, String.valueOf(objPropName) + "= [" + value + "]");
        return value;
    }

    private void setObjFormInfoMap(ArrayList dbValues) {
        try {
            int i = 0;
            while (i < dbValues.size()) {
                ArrayList currForm = (ArrayList)dbValues.get(i);
                String title = (String)currForm.get(0);
                String objContext = (String)currForm.get(14);
                String scrType = currForm.get(15) == null ? "" : currForm.get(15);
                String dbFormType = currForm.get(16) == null ? "" : currForm.get(16);
                String formName = currForm.get(32) == null ? "" : currForm.get(32);
                String parentKeyCol = currForm.get(18) == null ? "" : currForm.get(18);
                BaseLogger.log("3", null, null, "objContext =[" + objContext + "], formName =[" + formName + "]");
                this.objFormInfoMap.put(objContext, String.valueOf(dbFormType) + ";" + parentKeyCol + ";" + scrType + ";" + formName);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "DB2JSONGenerator >> setObjFormInfoMap >> this.objFromInfoMap ::" + this.objFormInfoMap);
    }

    private String getRowNumAppendQuery(String query, int fromRowNumber, int upToRowNumber, UserInfoBean userInfo, String tableName, ConnDriver connDriver) {
        StringBuilder queryBuilder = new StringBuilder();
        try {
            HashMap objDetailMap;
            String orderByPart = null;
            if (query != null && query.contains(" ORDER BY ")) {
                orderByPart = query.substring(query.indexOf("ORDER BY"), query.length());
                query = query.substring(0, query.indexOf("ORDER BY"));
            }
            if ("ORACLE".equalsIgnoreCase(connDriver.getDBName())) {
                queryBuilder.append("SELECT outer.* FROM (SELECT ROWNUM rn, inner.* FROM (");
            }
            queryBuilder.append(query);
            String orderByCol = "";
            DBAccessEJB dbAccess = new DBAccessEJB();
            if (userInfo != null && (objDetailMap = dbAccess.getObjDetailMap(this.objName, userInfo)) != null) {
                orderByCol = (String)objDetailMap.get("TRAN_ID_COL");
                if ((orderByCol = E12GenericUtility.checkNull(orderByCol)).length() == 0) {
                    orderByCol = (String)objDetailMap.get("TRAN_DATE_COL");
                    orderByCol = E12GenericUtility.checkNull(orderByCol);
                }
            }
            int whereIndex = -1;
            int orderByIndex = -1;
            if ("MSSQL".equalsIgnoreCase(connDriver.getDBName())) {
                int insertIndex = query.toUpperCase().indexOf("SELECT");
                queryBuilder.insert(insertIndex + 6, " TOP " + upToRowNumber + " ");
                if (orderByPart != null) {
                    queryBuilder.append(" " + orderByPart);
                }
            } else if ("MYSQL".equalsIgnoreCase(connDriver.getDBName())) {
                if (orderByPart != null) {
                    queryBuilder.append(" " + orderByPart);
                }
                queryBuilder.append(" LIMIT " + upToRowNumber);
            } else if ("ORACLE".equalsIgnoreCase(connDriver.getDBName())) {
                if (orderByCol.length() > 0) {
                    if (orderByCol.indexOf(",") != -1) {
                        String orderByStr = " ORDER BY ";
                        String[] orderByColArr = orderByCol.split(",");
                        int i = 0;
                        while (i < orderByColArr.length) {
                            orderByStr = i != orderByColArr.length - 1 ? String.valueOf(orderByStr) + tableName + "." + orderByColArr[i].toUpperCase() + ", " : String.valueOf(orderByStr) + tableName + "." + orderByColArr[i].toUpperCase() + " ";
                            ++i;
                        }
                        queryBuilder.append(String.valueOf(orderByStr) + " DESC ) inner) outer WHERE outer.rn >= " + fromRowNumber + " AND outer.rn <= " + upToRowNumber);
                    } else {
                        queryBuilder.append(" ORDER BY " + tableName + "." + orderByCol.toUpperCase() + " DESC ) inner) outer WHERE outer.rn >= " + fromRowNumber + " AND outer.rn <= " + upToRowNumber);
                    }
                } else {
                    queryBuilder.append(" ORDER BY 1 DESC ) inner) outer WHERE outer.rn >= " + fromRowNumber + " AND outer.rn <= " + upToRowNumber);
                }
            } else if ("DB2".equalsIgnoreCase(connDriver.getDBName())) {
                queryBuilder.append(" FETCH FIRST " + upToRowNumber + " ROWS ONLY");
                if (orderByPart != null) {
                    queryBuilder.append(" " + orderByPart);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception getRowNumAppendQuery [" + e.getMessage() + "]");
        }
        return queryBuilder.toString();
    }

    private String getFormName(String formNo) {
        String formName = this.getObjPropValue(formNo, "FORM_NAME");
        if (formName == null || formName.length() == 0) {
            formName = formNo;
        }
        return formName;
    }

    public String getDBColumnValue(String tableName, String columnName, String condition, Connection mConnection) throws RemoteException, ITMException {
        String columnValue;
        block20: {
            columnValue = "";
            Statement mStmt = null;
            ResultSet rs = null;
            String selectColumns = "";
            try {
                try {
                    String[] columnNameArr;
                    String columnNameAs = "";
                    selectColumns = columnName;
                    if (columnName.indexOf("~AS~") != -1 && (columnNameArr = columnName.split("~AS~")).length > 1) {
                        columnName = columnNameArr[0];
                        columnNameAs = columnNameArr[1];
                        selectColumns = String.valueOf(columnName) + " AS " + columnNameAs;
                    }
                    String mQuery = " SELECT " + selectColumns + " FROM " + tableName + " WHERE " + condition;
                    BaseLogger.log("3", null, null, "mQuery [" + mQuery + "]");
                    mStmt = mConnection.prepareStatement(mQuery);
                    rs = mStmt.executeQuery(mQuery);
                    BaseLogger.log("3", null, null, "columnNameAs::" + columnNameAs);
                    if (columnNameAs.length() > 0) {
                        columnName = columnNameAs;
                    }
                    if (rs.next()) {
                        columnValue = E12GenericUtility.checkNull(rs.getString(columnName.trim()));
                    }
                }
                catch (Exception e) {
                    columnValue = "";
                    BaseLogger.log("0", null, null, "Exception :DB2JSONGenerator :getDBColumnValue() :==>\n" + e.getMessage());
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (mStmt != null) {
                            mStmt.close();
                            mStmt = null;
                        }
                        break block20;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception :DB2JSONGenerator :getDBColumnValue() :==>finally" + e2.getMessage());
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :DB2JSONGenerator :getDBColumnValue() :==>finally" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :DB2JSONGenerator :getDBColumnValue() :==>finally" + e.getMessage());
            }
        }
        BaseLogger.log("2", null, null, "columnValue:[" + columnValue + "]");
        return columnValue;
    }
}

