/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Path(value="/E12CalendarService")
public class E12CalendarService {
    @POST
    @Path(value="/syncCalendarWidget")
    public Response syncCalendarWidgetData(@Context HttpServletRequest request) throws Exception {
        String resulJson = null;
        JSONParser jsonParser = null;
        JSONObject jsonObject = null;
        JSONArray widgetJSONArray = null;
        try {
            String userId = request.getParameter("user_id");
            String widgetData = request.getParameter("calendarSyncData");
            jsonParser = new JSONParser();
            widgetJSONArray = new JSONArray();
            if (widgetData.indexOf("~:") != -1) {
                String[] widgetDataStr = widgetData.split("~:");
                int i = 0;
                while (i < widgetDataStr.length) {
                    String jsonStr = widgetDataStr[i];
                    jsonObject = (JSONObject)jsonParser.parse(jsonStr);
                    String planId = (String)jsonObject.get((Object)"plan_id");
                    String scCode = (String)jsonObject.get((Object)"sc_code");
                    JSONObject jsonDataObj = this.getPlanWidgetData(jsonObject, planId, scCode, "C", "C");
                    widgetJSONArray.add((Object)jsonDataObj);
                    ++i;
                }
            } else {
                jsonObject = (JSONObject)jsonParser.parse(widgetData);
                String planId = (String)jsonObject.get((Object)"plan_id");
                String scCode = (String)jsonObject.get((Object)"sc_code");
                JSONObject jsonDataObj = this.getPlanWidgetData(jsonObject, planId, scCode, "C", "C");
                widgetJSONArray.add((Object)jsonDataObj);
            }
            resulJson = widgetJSONArray.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)200).entity((Object)("Inside syncCalendarWidgetData method Exception is:: " + e.getMessage())).build();
        }
        return Response.status((int)200).entity((Object)resulJson).build();
    }

    private JSONObject getPlanWidgetData(JSONObject scCodeJsonData, String planId, String scCode, String entityType, String locationType) {
        String serNo = null;
        String scName = null;
        String endTime = null;
        String startTime = null;
        JSONObject calendarWidgetJson = null;
        try {
            String fileName = String.valueOf(entityType) + "_" + locationType + ".json";
            String filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + "PTE_ACTIONS" + File.separator;
            File file = new File(String.valueOf(filePath) + fileName);
            if (file.exists()) {
                planId = planId.lastIndexOf("_") != -1 ? planId.substring(planId.lastIndexOf("_") + 1).trim() : planId.trim();
                scName = E12GenericUtility.checkNull((String)((String)scCodeJsonData.get((Object)"sc_name")));
                startTime = E12GenericUtility.checkNull((String)((String)scCodeJsonData.get((Object)"start_time")));
                endTime = E12GenericUtility.checkNull((String)((String)scCodeJsonData.get((Object)"end_time")));
                serNo = E12GenericUtility.checkNull((String)((String)scCodeJsonData.get((Object)"customer_srno")));
                startTime = startTime.length() == 0 ? "00:00:00" : String.valueOf(startTime) + ":00";
                endTime = endTime.length() == 0 ? "00:00:00" : String.valueOf(endTime) + ":00";
                String dateTimeFormat = CommonConstants.APPL_DATETIME_FORMAT;
                SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
                Date startTimeDte = sdf.parse(startTime);
                Date endTimeDte = sdf.parse(endTime);
                long sTimeInLong = startTimeDte.getTime();
                long eTimeInLong = endTimeDte.getTime();
                JSONParser jsonParser = new JSONParser();
                Object actionFileObj = jsonParser.parse((Reader)new FileReader(file));
                JSONObject actJsonObj = (JSONObject)actionFileObj;
                List actionslist = (List)actJsonObj.get((Object)"actions");
                List<String> newActionList = this.updateActionParams(actionslist, scCode);
                String defaultlist = (String)actJsonObj.get((Object)"default");
                String newDefaultlist = this.updateDefaultActionParams(defaultlist, scCode);
                String userImagePath = String.valueOf(CommonConstants.TOMCAT_HOME) + this.getCustomImageURL(scCode, scCode, scName);
                actJsonObj.put((Object)"message", (Object)scName);
                actJsonObj.put((Object)"imgURL", (Object)userImagePath);
                actJsonObj.put((Object)"start_time", (Object)sTimeInLong);
                actJsonObj.put((Object)"end_time", (Object)eTimeInLong);
                actJsonObj.put((Object)"actions", newActionList);
                actJsonObj.put((Object)"default", (Object)newDefaultlist);
                actJsonObj.put((Object)"GEOFENCE_REQUEST_ID", (Object)planId);
                actJsonObj.put((Object)"customer_srno", (Object)serNo);
                calendarWidgetJson = new JSONObject();
                calendarWidgetJson.put((Object)"openTarget", (Object)"P");
                calendarWidgetJson.put((Object)"message", (Object)scName);
                calendarWidgetJson.put((Object)"XMLData", (Object)actJsonObj);
                calendarWidgetJson.put((Object)"category", (Object)"transpush");
            } else {
                BaseLogger.log((String)"3", null, null, (Object)"File Not exist.");
                calendarWidgetJson.put((Object)"ERROR", (Object)"FILE NOT EXIST.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            calendarWidgetJson = new JSONObject();
            calendarWidgetJson.put((Object)"Exception::", (Object)("Exception in getPlanWidgetData:: " + e.getMessage()));
            return calendarWidgetJson;
        }
        return calendarWidgetJson;
    }

    private List<String> updateActionParams(List<String> actionslist, String entityCode) throws BaseException {
        ArrayList<String> newActionList = new ArrayList<String>();
        try {
            for (String string : actionslist) {
                Document dom = new E12GenericUtility().parseString(string);
                NodeList strgCustNode = dom.getElementsByTagName("strg_code");
                if (strgCustNode != null && strgCustNode.item(0) != null) {
                    if (strgCustNode.item(0).getFirstChild() != null) {
                        strgCustNode.item(0).getFirstChild().setNodeValue(entityCode);
                    } else {
                        strgCustNode.item(0).setTextContent(entityCode);
                    }
                }
                newActionList.add(new E12GenericUtility().serializeDom((Node)dom));
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("updateActionParams:actionslist:" + actionslist));
            return actionslist;
        }
        BaseLogger.log((String)"2", null, null, (Object)("updateActionParams:newActionList:" + newActionList));
        return newActionList;
    }

    private String updateDefaultActionParams(String actionXml, String entityCode) throws BaseException {
        String newActionXml = "";
        try {
            Document dom = new E12GenericUtility().parseString(actionXml);
            NodeList strgCustNode = dom.getElementsByTagName("strg_code");
            if (strgCustNode != null && strgCustNode.item(0) != null) {
                if (strgCustNode.item(0).getFirstChild() != null) {
                    strgCustNode.item(0).getFirstChild().setNodeValue(entityCode);
                } else {
                    strgCustNode.item(0).setTextContent(entityCode);
                }
            }
            newActionXml = new E12GenericUtility().serializeDom((Node)dom);
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("updateDefaultActionParams:newActionXml:" + newActionXml));
            return newActionXml;
        }
        BaseLogger.log((String)"2", null, null, (Object)("updateDefaultActionParams:newActionXml:" + newActionXml));
        return newActionXml;
    }

    private String getCustomImageURL(String objName, String fldValue, String altFldValue) throws UnsupportedEncodingException {
        String imageURL = "/ibase/CustomMenuImageServlet?fldValue=" + fldValue + "&ALT_FLD_VALUE=" + altFldValue + "&objName=" + objName;
        BaseLogger.log((String)"2", null, null, (Object)("imageURL getCustomImageURL:" + imageURL));
        return imageURL;
    }
}

