/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.hibernate.bean.Brand;
import ibase.hibernate.bean.BrandContents;
import ibase.hibernate.bean.UserPres;
import ibase.hibernate.dao.UserPresDAO;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/")
public class UserPresService {
    @Context
    HttpServletRequest request;
    private UserPresDAO userPresDAO = new UserPresDAO();

    @GET
    @Path(value="/userpres")
    @Produces(value={"application/json"})
    public Response getAllUsersPresentation() throws JSONException {
        BaseLogger.log((String)"2", null, null, (Object)"Inside getAllUsersPresentation of UserPresnService");
        JSONObject respJsonObject = new JSONObject();
        String tranDB = "DEFAULT";
        try {
            UserInfoBean userInfo = this.getUserInfo();
            if (userInfo != null) {
                String loginCode = userInfo.getLoginCode();
                tranDB = userInfo.getTransDB();
                BaseLogger.log((String)"3", null, null, (Object)"getUserPresentation Strt");
                List userPresList = this.userPresDAO.getAllUsersPresentation(loginCode, tranDB);
                JSONArray userPresArr = new JSONArray();
                for (UserPres pres : userPresList) {
                    JSONObject presJson = new JSONObject((Object)pres);
                    BaseLogger.log((String)"3", null, null, (Object)("Contents List :" + pres.getPresAudienceDetails()));
                    presJson.put("PRES_AUDIENCE_DETAILS", (Object)pres.getPresAudienceDetails());
                    userPresArr.put((Object)presJson);
                }
                respJsonObject.put("result", (Object)"success");
                respJsonObject.put("presentations", (Object)userPresArr);
                BaseLogger.log((String)"3", null, null, (Object)"getUserPresentation END");
            }
        }
        catch (Exception e) {
            respJsonObject.put("result", (Object)"failure");
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @DELETE
    @Path(value="/userpres/{pres_id}")
    @Produces(value={"application/json"})
    public Response deleteUserPresentation(@PathParam(value="pres_id") String pres_id, String userId) throws JSONException {
        BaseLogger.log((String)"2", null, null, (Object)("Inside deleteContent for docId=" + pres_id));
        UserInfoBean userInfo = this.getUserInfo();
        JSONObject respJsonObject = new JSONObject();
        try {
            if (userInfo != null) {
                String tranDB = userInfo.getTransDB();
                String loginCode = userInfo.getLoginCode();
                BaseLogger.log((String)"3", null, null, (Object)"deleteUserPresentation Strt");
                this.userPresDAO.deleteUserPres(pres_id, userId, tranDB);
                BaseLogger.log((String)"3", null, null, (Object)"deleteUserPresentation END");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            respJsonObject.put("result", (Object)"failure");
        }
        BaseLogger.log((String)"2", null, null, (Object)("Final respJsonObject ::" + respJsonObject));
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @POST
    @Path(value="/userpres")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateUserPres(String data) throws JSONException {
        BaseLogger.log((String)"2", null, null, (Object)("Inside updateStatus Method /n[" + data + "]"));
        UserInfoBean userInfo = this.getUserInfo();
        JSONObject presData = new JSONObject(data);
        JSONObject respJsonObject = new JSONObject();
        try {
            if (userInfo != null) {
                String loginCode = userInfo.getLoginCode();
                String tranDB = userInfo.getTransDB();
                UserPres userPres = this.userPresDAO.addOrUpdateUserPres(presData, loginCode, tranDB);
                respJsonObject.put("result", (Object)"success");
                JSONObject userPresJson = new JSONObject((Object)userPres);
                userPresJson.put("PRES_AUDIENCE_DETAILS", (Object)userPres.getPresAudienceDetails());
                respJsonObject.put("presentation", (Object)userPresJson);
            }
        }
        catch (Exception e) {
            respJsonObject.put("result", (Object)"failure");
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @POST
    @Path(value="/user_pres/brands")
    @Produces(value={"application/json"})
    public Response getBrands(String data) throws JSONException {
        JSONObject presDetail = new JSONObject(data);
        BaseLogger.log((String)"3", null, null, (Object)("Inside getAllUsersPresentation of UserPresnService" + data + "]--[" + presDetail));
        JSONObject respJsonObject = new JSONObject();
        String tranDB = "DEFAULT";
        String itemSer = "";
        try {
            UserInfoBean userInfo = (UserInfoBean)this.request.getSession().getAttribute("USER_INFO");
            if (userInfo != null) {
                String loginCode = userInfo.getLoginCode();
                tranDB = userInfo.getTransDB();
                itemSer = userInfo.getItemSer();
                BaseLogger.log((String)"3", null, null, (Object)"getBrands Strt");
                BaseLogger.log((String)"3", null, null, (Object)("getBrands tranDB: " + tranDB + " itemser: " + itemSer + "loginCode-: " + loginCode));
                if (itemSer == null || itemSer == "") {
                    itemSer = this.getItemSer(loginCode);
                }
                BaseLogger.log((String)"3", null, null, (Object)("getBrands itemser-: " + itemSer));
                String scCodeStr = presDetail.optString("AUD_CODES");
                if (scCodeStr.isEmpty() || scCodeStr == null) {
                    scCodeStr = "''";
                }
                List brandList = this.userPresDAO.getBrands(tranDB, itemSer, scCodeStr);
                BaseLogger.log((String)"3", null, null, (Object)("getBrands END" + brandList.toString()));
                JSONArray brandListArr = new JSONArray();
                for (Brand brand : brandList) {
                    JSONObject brandDetailJson = new JSONObject((Object)brand);
                    JSONArray brandContents = brand.getBrandContents();
                    BaseLogger.log((String)"3", null, null, (Object)("Contents List :" + brandContents));
                    brandDetailJson.put("brandContents", (Object)brandContents);
                    brandListArr.put((Object)brandDetailJson);
                }
                BaseLogger.log((String)"3", null, null, (Object)("Final Brand List " + brandListArr));
                respJsonObject.put("result", (Object)"success");
                respJsonObject.put("brands", (Object)brandListArr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log((String)"2", null, null, (Object)("getBrands END" + respJsonObject));
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    private UserInfoBean getUserInfo() {
        UserInfoBean userInfo = null;
        HttpSession session = this.request.getSession();
        Object userObj = session.getAttribute("USER_INFO");
        BaseLogger.log((String)"2", null, null, (Object)(" ContentLibraryService getUserInfo  userObj >>[" + userObj + "]"));
        if (userObj != null) {
            try {
                userInfo = new UserInfoBean(userObj.toString());
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        return userInfo;
    }

    private JSONObject getResponseMessage(String successResponse, String status) {
        JSONObject respMessage = new JSONObject();
        try {
            respMessage.put("message", (Object)successResponse);
            respMessage.put("status", (Object)status);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return respMessage;
    }

    @GET
    @Path(value="/user_pres/brands_index")
    @Produces(value={"application/json"})
    public Response getBrandsIndexDM(@QueryParam(value="USER_INFO") String userInfoStr) throws JSONException {
        JSONObject respJsonObject;
        block14: {
            BaseLogger.log((String)"2", null, null, (Object)"Inside getBrandsIndexDM of UserPresService");
            respJsonObject = new JSONObject();
            String tranDB = "DEFAULT";
            String itemSer = "";
            try {
                UserInfoBean userInfo = null;
                if (userInfoStr != null) {
                    BaseLogger.log((String)"3", null, null, (Object)("userInfoStr :: " + userInfoStr));
                    userInfo = new UserInfoBean(userInfoStr);
                } else {
                    userInfo = this.getUserInfo();
                }
                if (userInfo != null) {
                    tranDB = userInfo.getTransDB();
                    itemSer = userInfo.getItemSer();
                    BaseLogger.log((String)"3", null, null, (Object)"getBrands Start");
                    List brandList = this.userPresDAO.getBrands(tranDB, itemSer, "''");
                    BaseLogger.log((String)"3", null, null, (Object)("getBrands END" + brandList.toString()));
                    JSONArray brandListArr = new JSONArray();
                    for (Brand brand : brandList) {
                        String brandCode = brand.getBrand_code().trim();
                        JSONObject brandDetailJson = new JSONObject();
                        brandDetailJson.put("BRAND_CODE", (Object)brandCode);
                        brandDetailJson.put("DESCRIPTION", (Object)brand.getDescription());
                        brandDetailJson.put("SH_DESCR", (Object)brand.getSh_descr());
                        brandDetailJson.put("TAG_LINE", (Object)brand.getTag_line());
                        String downloadImgUrl = "/ibase/CustomMenuImageServlet?fldValue=" + brandCode + "&ALT_FLD_VALUE=" + brand.getDescription() + "&objName=product&docAttachType=Icon";
                        brandDetailJson.put("DOWNLOAD_IMG_URL", (Object)downloadImgUrl);
                        brandDetailJson.put("IMG_FOLDER", (Object)"product");
                        brandDetailJson.put("IMG_URL", (Object)("/base/cache/downloads/files/product/" + brandCode + ".png"));
                        JSONArray docContents = new JSONArray();
                        List brandContentList = brand.getBrandContentList();
                        BaseLogger.log((String)"3", null, null, (Object)("Contents List :" + brandContentList));
                        for (BrandContents brandContent : brandContentList) {
                            JSONObject docContent = new JSONObject();
                            docContent.put("DOC_ID", (Object)brandContent.getDocId());
                            docContent.put("DOC_NAME", (Object)brandContent.getDocName());
                            docContent.put("DOC_TYPE_ATTACH", (Object)brandContent.getDocTypeAttach());
                            docContent.put("FILE_TYPE_ATTACH", (Object)brandContent.getDocType());
                            docContent.put("FILE_PATH", (Object)("/base/cache/downloads/files/" + brandContent.getDocName()));
                            String pageInfo = brandContent.getPageInfo();
                            BaseLogger.log((String)"3", null, null, (Object)("pageInfo [" + pageInfo + "]"));
                            String selectedPages = " ";
                            if (pageInfo != null && pageInfo.trim().length() > 0) {
                                try {
                                    JSONObject pageInfoObj = new JSONObject(pageInfo);
                                    selectedPages = pageInfoObj.optString("selectedPages");
                                }
                                catch (Exception e) {
                                    BaseLogger.log((String)"", null, null, (Object)("Exception getBrandsIndexDM pageInfo [" + e.getMessage() + "]"));
                                    e.printStackTrace();
                                }
                            }
                            if ("zip".equalsIgnoreCase(brandContent.getDocType()) && selectedPages != null && selectedPages.indexOf(",") > -1) {
                                String[] selectedPageList;
                                String[] stringArray = selectedPageList = selectedPages.split(",");
                                int n = selectedPageList.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String selectedPage = stringArray[n2];
                                    docContent = new JSONObject();
                                    docContent.put("DOC_ID", (Object)brandContent.getDocId());
                                    docContent.put("DOC_NAME", (Object)brandContent.getDocName());
                                    docContent.put("DOC_TYPE_ATTACH", (Object)brandContent.getDocTypeAttach());
                                    docContent.put("FILE_TYPE_ATTACH", (Object)brandContent.getDocType());
                                    docContent.put("FILE_PATH", (Object)("/base/cache/downloads/files/" + brandContent.getDocName()));
                                    docContent.put("PAGE_INFO", (Object)selectedPage);
                                    docContents.put((Object)docContent);
                                    ++n2;
                                }
                                continue;
                            }
                            docContent.put("PAGE_INFO", (Object)selectedPages);
                            docContents.put((Object)docContent);
                        }
                        brandDetailJson.put("DOCS", (Object)docContents);
                        brandListArr.put((Object)brandDetailJson);
                    }
                    if (brandListArr != null && brandListArr.length() > 0) {
                        BaseLogger.log((String)"3", null, null, (Object)("Final Brand List " + brandListArr));
                        JSONObject indexData = new JSONObject();
                        indexData.put("BRANDS", (Object)brandListArr);
                        respJsonObject.put("INDEX", (Object)indexData);
                        respJsonObject.put("result", (Object)this.getResponseMessage("Success", "Success"));
                    } else {
                        respJsonObject.put("result", (Object)this.getResponseMessage("Brands not available.", "Failure"));
                    }
                    break block14;
                }
                respJsonObject.put("result", (Object)this.getResponseMessage("Unauthorised Access Denied.", "Failure"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("Exception : " + e.getMessage()));
                e.printStackTrace();
                respJsonObject.put("result", (Object)this.getResponseMessage("Please try again. " + e.getMessage(), "Failure"));
            }
        }
        BaseLogger.log((String)"2", null, null, (Object)("getBrands END" + respJsonObject));
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    private String getItemSer(String LoginCode) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", null, null, (Object)("Getting item series for LoginCode :" + LoginCode + ":"));
        String itemSer = "";
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            try {
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                query = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '" + LoginCode + "'";
                stmt = conn.prepareStatement(query);
                BaseLogger.log((String)"3", null, null, (Object)("[UserPresService] query :\n" + query));
                rs = stmt.executeQuery();
                while (rs.next()) {
                    itemSer = rs.getString(1);
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception :UserPresService :getItemSer :==>" + e));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :UserPresService :getItemSer :==>" + e);
                throw new ITMException(e);
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)("[UserPresService]ItemSer :" + itemSer));
        return itemSer;
    }
}

