/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.dao;

import ibase.hibernate.utility.HibernateUtil;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class EntityDAO {
    private String siteTranDB = "DEFAULT";
    String sql = "";
    UserInfoBean userInfo;

    public EntityDAO(UserInfoBean userInfo) {
        this.siteTranDB = userInfo.getTransDB();
        this.userInfo = userInfo;
    }

    public List getEntityList(String entityType, String searchParam) {
        ArrayList entityDataList = new ArrayList();
        List entityDataListTmp = new ArrayList();
        Session session = null;
        try {
            try {
                BaseLogger.log("3", null, null, "Inside getEntityList method!!!!");
                session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
                NativeQuery query = session.createSQLQuery(this.getSQLQuery(entityType, searchParam, this.userInfo));
                entityDataListTmp = query.list();
                for (Object[] row : entityDataListTmp) {
                    HashMap<String, String> entity = new HashMap<String, String>();
                    entity.put("CODE", row[0].toString().trim());
                    entity.put("DESCR", row[1].toString());
                    entityDataList.add(entity);
                }
                session.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "HibernateException :" + e);
                BaseLogger.log("0", null, null, e.getMessage());
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
        return entityDataList;
    }

    public String getEntityName(String entityType, String entityCode) {
        List entityDataListTmp = new ArrayList();
        String entityName = "";
        Session session = null;
        try {
            try {
                BaseLogger.log("3", null, null, "Inside getEntityName method!!!!");
                session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
                NativeQuery query = session.createSQLQuery(this.getEntitiyNameSQLQuery(entityType, entityCode));
                entityDataListTmp = query.list();
                for (Object[] row : entityDataListTmp) {
                    entityName = row[1].toString();
                }
                session.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "HibernateException :" + e);
                BaseLogger.log("0", null, null, e.getMessage());
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
        return entityName;
    }

    public String getSQLQuery(String entityType, String searchParam, UserInfoBean userInfo) {
        String sqlStr = "";
        String masterTable = "";
        searchParam = E12GenericUtility.checkNull(searchParam);
        String loginEmpCode = E12GenericUtility.checkNull(userInfo.getEmpCode());
        BaseLogger.log("2", null, null, "loginEmpCode ::: " + loginEmpCode);
        if (entityType.equalsIgnoreCase("C")) {
            masterTable = "STRG_CUSTOMER";
            sqlStr = "SELECT SC.SC_CODE AS CODE, SC.PREFIX ||' ' ||SC.FIRST_NAME ||' ' || SC.LAST_NAME AS name FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.STATUS='Y' AND SS.SALES_PERS = '" + loginEmpCode + "' AND ( UPPER(SC.PREFIX ||' ' ||SC.FIRST_NAME ||' ' || SC.LAST_NAME) like '%" + searchParam.toUpperCase() + "%') ";
        } else if (entityType.equalsIgnoreCase("S")) {
            masterTable = "SUPPLIER";
            sqlStr = "SELECT SUPP_CODE AS CODE, SUPP_NAME AS NAME FROM SUPPLIER where UPPER(SUPP_NAME) like '%" + searchParam.toUpperCase() + "%'";
        } else if (entityType.equalsIgnoreCase("E")) {
            masterTable = "EMPLOYEE";
            sqlStr = "SELECT EMP_CODE AS CODE,EMP_FNAME ||' '|| EMP_LNAME AS NAME FROM EMPLOYEE where ( UPPER(EMP_FNAME ||' '|| EMP_LNAME) like '%" + searchParam.toUpperCase() + "%')";
        } else if (entityType.equalsIgnoreCase("P")) {
            masterTable = "SALES_PERS";
            sqlStr = "SELECT SALES_PERS AS CODE, SP_NAME AS NAME FROM SALES_PERS where UPPER(SP_NAME) like '%" + searchParam.toUpperCase() + "%'";
        }
        sqlStr = String.valueOf(sqlStr) + " AND ROWNUM <= 20";
        return sqlStr;
    }

    public String getEntitiyNameSQLQuery(String entityType, String entityCode) {
        String sqlStr = "";
        String masterTable = "";
        new E12GenericUtility();
        entityCode = E12GenericUtility.checkNull(entityCode);
        if (entityType.equalsIgnoreCase("C")) {
            masterTable = "STRG_CUSTOMER";
            sqlStr = "select SC_CODE as CODE, PREFIX ||' '||FIRST_NAME ||' '|| LAST_NAME AS NAME from STRG_CUSTOMER where SC_CODE = '" + entityCode + "'";
        } else if (entityType.equalsIgnoreCase("S")) {
            masterTable = "SUPPLIER";
            sqlStr = "SELECT SUPP_CODE AS CODE, SUPP_NAME AS NAME FROM SUPPLIER where SUPP_CODE = '" + entityCode + "'";
        } else if (entityType.equalsIgnoreCase("E")) {
            masterTable = "EMPLOYEE";
            sqlStr = "SELECT EMP_CODE AS CODE, EMP_FNAME ||' '|| EMP_LNAME AS NAME FROM EMPLOYEE where EMP_CODE = '" + entityCode + "'";
        } else if (entityType.equalsIgnoreCase("P")) {
            masterTable = "SALES_PERS";
            sqlStr = "SELECT SALES_PERS AS CODE, SP_NAME AS NAME FROM SALES_PERS where SALES_PERS = '" + entityCode + "'";
        }
        return sqlStr;
    }
}

