/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility.wiz;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.wiz.ITMRule;
import ibase.webitm.utility.wiz.Messages;
import java.util.HashMap;

public class ITMValidatorComponent {
    private static ITMValidatorComponent itmValidatorComponent = null;
    private HashMap itmValidatorMap = new HashMap();

    private ITMValidatorComponent() {
    }

    public static ITMValidatorComponent getInstance() throws Exception {
        try {
            if (itmValidatorComponent == null) {
                itmValidatorComponent = new ITMValidatorComponent();
            }
            return itmValidatorComponent;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void addValidationRules(String objName, String formNo, String fieldName, ITMRule itmRuleObj) {
        try {
            this.itmValidatorMap.put(String.valueOf(objName) + formNo + fieldName, itmRuleObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addValidationRules(String formNo, String fieldName, ITMRule itmRuleObj) {
        try {
            this.addValidationRules(CommonConstants.TRANS_INFO_NAME, formNo, fieldName, itmRuleObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String validate(String objName, String formNo, String fieldName, Object value) {
        String responseString = null;
        try {
            ITMRule itmRule = (ITMRule)this.itmValidatorMap.get(String.valueOf(objName) + formNo + fieldName);
            if (itmRule != null && "N".equalsIgnoreCase(itmRule.getBlankOpt())) {
                responseString = value == null || String.valueOf(value).length() <= 0 ? this.createResponse(fieldName, itmRule) : "1";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return responseString;
    }

    public String validate(String formNo, String fieldName, Object value) {
        String responseString = null;
        try {
            responseString = this.validate(CommonConstants.TRANS_INFO_NAME, formNo, fieldName, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return responseString;
    }

    private String createResponse(String fieldName, ITMRule itmRule) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("<Root><Errors>");
            sb.append("<error id=\"" + itmRule.getErrorCode() + "\" type=\"E\" column_name=\"" + fieldName + "\">");
            sb.append("<message> " + itmRule.getMessage() + " </message>");
            sb.append("<description>" + Messages.getString("ITMValidatorComponent_pleaseEnterValue") + "</description>");
            sb.append("<type>E</type>");
            sb.append("<option>Y</option>");
            sb.append("<time/>");
            sb.append("<alarm/>");
            sb.append("<source/>");
            sb.append("<trace>" + Messages.getString("ITMValidatorComponent_error") + fieldName + Messages.getString("ITMValidatorComponent_cannotBeEmpty") + "</trace>");
            sb.append("<redirect>1</redirect>");
            sb.append("</error>");
            sb.append("</Errors></Root>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "ITMValidatorComponent::createResponse::[" + sb.toString() + "]");
        return sb.toString();
    }
}

