/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.I18NMetadataObject;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.LinkControllerEJB;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.ejb.TransactionEmailTempltLocal;
import ibase.webitm.ejb.TransactionEmailTempltRemote;
import ibase.webitm.reports.utility.JasperReportGenerator;
import ibase.webitm.reports.utility.ResourceConstants;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.ejb.Stateless;
import javax.imageio.ImageIO;
import javax.naming.InitialContext;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class TransactionEmailTempltEJB
implements TransactionEmailTempltRemote,
TransactionEmailTempltLocal {
    E12GenericUtility genericUtility = new E12GenericUtility();
    int lastDyanInpCol = 1;
    int lastDyanSubInpCol = 1;

    @Override
    public String getAllTemplatesHTMLData(String objName, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, null, "[TransactionEmailTempltEJB]Getting Email Templates .....");
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        String retHTMLData = "<TABLE id=\"templateTable\" class=\"templateClass\" cellspacing=\"0\" cellpadding=\"0\">";
        try {
            try {
                connection = this.getConnection(userInfo);
                String selectQuery = "SELECT MAIL_DESCR,FORMAT_CODE FROM MAIL_FORMAT WHERE TEMPLATE_PURPOSE = ? AND (STATUS IS NULL OR STATUS = ?) AND WIN_NAME = ?  ORDER BY FORMAT_CODE";
                stmt = connection.prepareStatement(selectQuery);
                stmt.setString(1, "M");
                stmt.setString(2, "Y");
                stmt.setString(3, "w_" + objName);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    retHTMLData = String.valueOf(retHTMLData) + "<TR class=\"templateOpenTr\" id=\"" + rs.getString("FORMAT_CODE").trim() + "\" name=\"" + rs.getString("FORMAT_CODE") + "\" onClick=\"openSelectedTemplate(this,'" + objName + "','" + rs.getString("FORMAT_CODE") + "');\"> " + "<TD class=\"TemplateTd\" > " + "<table class=\"templateDataClass\"> " + "<tr> <td><DIV CLASS=\"templateNameClass\">" + rs.getString("FORMAT_CODE") + " </DIV></td></tr> " + "<tr> <td><DIV CLASS=\"templeteDescrClass\" id=\"temltDescrDiv" + rs.getString("FORMAT_CODE") + "\" >" + rs.getString("MAIL_DESCR") + " </DIV></td></tr> " + "</table>" + "</TD>" + "</TR>";
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                retHTMLData = String.valueOf(retHTMLData) + "</TABLE>";
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :getAllTemplatesHTMLData :==>");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :getAllTemplatesHTMLData :==>");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :TransactionEmailTempltEJB :getAllTemplatesHTMLData :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return retHTMLData;
    }

    @Override
    public String getPopHelpData(String objName, UserInfoBean userInfo, String pContext, String oContext, String fieldName, String jsonTranData) throws ITMException {
        String standardNameForXML = String.valueOf(objName) + pContext + oContext + ".xml";
        String defaultPathForMetadataXML = "";
        String targetFileName = "";
        String xmlString = "";
        Document metadataDoc = null;
        TreeMap<Integer, TreeMap<Integer, I18NMetadataObject>> yTextMap = null;
        HashMap<String, String> labelFormDataMap = new HashMap<String, String>();
        HashMap<String, String> inputFormDataMap = new HashMap<String, String>();
        String fieldText = "";
        String fieldLable = "";
        int cnter = 1;
        String popHelpData = "";
        try {
            BaseLogger.log("3", userInfo, null, "jsonTranData:" + jsonTranData);
            if (jsonTranData == null || jsonTranData.equalsIgnoreCase("null") || jsonTranData.length() <= 0) {
                BaseLogger.log("3", userInfo, null, "TransactionEmailTempltEJB::getPopHelpData::Creating pophelp xml from bin metadata:" + standardNameForXML);
                defaultPathForMetadataXML = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator;
                targetFileName = String.valueOf(defaultPathForMetadataXML) + standardNameForXML;
                xmlString = this.readFile(targetFileName);
                metadataDoc = this.genericUtility.parseString(xmlString);
                yTextMap = this.parseMetadataObjects(metadataDoc);
                for (Integer yCord : yTextMap.keySet()) {
                    TreeMap<Integer, I18NMetadataObject> xTextMap = yTextMap.get(yCord);
                    if (xTextMap == null) continue;
                    for (Integer xCord : xTextMap.keySet()) {
                        I18NMetadataObject xMetadataObj = xTextMap.get(xCord);
                        if ("Text".equalsIgnoreCase(xMetadataObj.getMetaType())) {
                            labelFormDataMap.put(xMetadataObj.getName(), xMetadataObj.getText());
                            continue;
                        }
                        inputFormDataMap.put(xMetadataObj.getName(), xMetadataObj.getName());
                    }
                }
            } else {
                String key;
                JSONObject jsonObject = new JSONObject(jsonTranData);
                Iterator keys = jsonObject.keys();
                if (keys.hasNext() && jsonObject.get(key = (String)keys.next()) instanceof JSONObject) {
                    JSONObject childJson = new JSONObject(jsonObject.get(key).toString());
                    BaseLogger.log("3", userInfo, null, childJson);
                    Iterator childKeys = childJson.keys();
                    while (childKeys.hasNext()) {
                        String childKey = (String)childKeys.next();
                        BaseLogger.log("3", userInfo, null, childKey);
                        if (childKey.endsWith("_t")) {
                            labelFormDataMap.put(childKey, childJson.getString(childKey));
                            continue;
                        }
                        inputFormDataMap.put(childKey, childKey);
                    }
                }
            }
            popHelpData = String.valueOf(popHelpData) + "<DOCUMENTROOT><DESCRIPTION/><METADATA><DEFAULT_COL>1</DEFAULT_COL></METADATA><GROUP0><DESCRIPTION/><HEADER0>";
            for (String key : inputFormDataMap.keySet()) {
                fieldText = "";
                fieldLable = "";
                if (!labelFormDataMap.containsKey(String.valueOf(key) + "_t")) continue;
                fieldLable = (String)labelFormDataMap.get(String.valueOf(key) + "_t");
                if (fieldLable.substring(fieldLable.length() - 1).equals(":")) {
                    fieldLable = fieldLable.substring(0, fieldLable.length() - 1);
                }
                fieldText = (String)inputFormDataMap.get(key);
                popHelpData = String.valueOf(popHelpData) + "<DETAIL id=\"" + cnter + "\"><" + fieldName + " dbType=\"VARCHAR2\"><![CDATA[" + fieldLable + "]]></" + fieldName + ">" + " <Descr dbType=\"VARCHAR2\"><![CDATA[" + fieldText + "]]></Descr></DETAIL>";
                ++cnter;
            }
            popHelpData = String.valueOf(popHelpData) + "<DESCRIPTION/></HEADER0></GROUP0></DOCUMENTROOT>";
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return popHelpData;
    }

    @Override
    public String saveNewEmailTemplate(String objName, UserInfoBean userInfo, String toAddr, String ccAddr, String bccAddr, String subject, String body, String templateName, String templateCode, String attachObjLinks) throws ITMException {
        String retString = "<root><tran_id>";
        BaseLogger.log("2", userInfo, null, "[TransactionEmailTempltEJB][saveNewEmailTemplate]Saving new Email Templates .....");
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        String formatCode = "";
        String errString = "";
        BaseLogger.log("2", userInfo, null, "attachObjLinks in save" + attachObjLinks);
        try {
            connection = this.getConnection(userInfo);
            errString = this.checkTemplateExists(templateCode, connection, userInfo);
            if (errString.length() > 0 || !errString.equalsIgnoreCase("")) {
                String string = errString;
                return string;
            }
            try {
                String sqlQuery = "Insert into MAIL_FORMAT (FORMAT_CODE,FORMAT_TYPE,SEND_TO,COPY_TO,BLIND_COPY,SUBJECT,BODY_TEXT,BODY_COMP,PRIORITY,DELIVERY_REPORT,RETURN_RECEIPT,MAIL_APPLICATION,MAIL_SERVER,MAIL_BOX,MAIL_ID,ATTACH_TYPE,ATTACH_TEXT,WINNAME,WIN_NAME,MAIL_GENERATION,MAIL_DESCR,FN_NAME,COND_METHOD,EMAIL_EXPR,TEMPLATE_PURPOSE,STATUS,USER_ID__OWN) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
                stmt = connection.prepareStatement(sqlQuery);
                formatCode = templateCode;
                stmt.setString(1, formatCode);
                stmt.setString(2, "T");
                stmt.setString(3, toAddr);
                stmt.setString(4, ccAddr);
                stmt.setString(5, bccAddr);
                stmt.setString(6, subject);
                body = this.removeInlineImages(body);
                stmt.setString(7, body);
                stmt.setInt(8, 0);
                stmt.setInt(9, 0);
                stmt.setInt(10, 0);
                stmt.setInt(11, 0);
                stmt.setString(12, "");
                stmt.setString(13, CommonConstants.SMTPHOST);
                stmt.setString(14, null);
                stmt.setString(15, CommonConstants.MAILFROM);
                stmt.setString(16, "D");
                stmt.setString(17, attachObjLinks);
                stmt.setString(18, null);
                stmt.setString(19, "w_" + objName);
                stmt.setString(20, null);
                stmt.setString(21, templateName);
                stmt.setString(22, null);
                stmt.setString(23, null);
                stmt.setString(24, null);
                stmt.setString(25, "M");
                stmt.setString(26, "Y");
                stmt.setString(27, userInfo.getLoginCode());
                stmt.executeUpdate();
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                retString = String.valueOf(retString) + formatCode + "</tran_id></root>";
                connection.commit();
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :saveNewEmailTemplate :==>");
                itme.printStackTrace();
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :saveNewEmailTemplate :==>");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :TransactionEmailTempltEJB :saveNewEmailTemplate :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return retString;
    }

    private String removeInlineImages(String body) {
        String findStr = "<img src=\"";
        String colFullName = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        String currColVal = "";
        while (body.indexOf(findStr, nextSearchIndex) != -1) {
            currColVal = "";
            BaseLogger.log("3", null, null, nextSearchIndex);
            currentIndex = body.indexOf(findStr, nextSearchIndex);
            String firstPart = body.substring(0, currentIndex);
            String lastPart = body.substring(currentIndex, body.length());
            colFullName = lastPart.substring(0, lastPart.indexOf(">") + 1);
            BaseLogger.log("3", null, null, "colFullName:" + colFullName);
            currColVal = "";
            body = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName.replace("+", "\\+"), currColVal);
            nextSearchIndex = currentIndex + currColVal.length();
        }
        return body;
    }

    private String checkTemplateExists(String templateCode, Connection connection, UserInfoBean userInfo) throws ITMException {
        String retString = "";
        try {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sqlQuery = "SELECT FORMAT_CODE,(SELECT DESCR FROM ITM2MENU WHERE WIN_NAME = MAIL_FORMAT.WIN_NAME) FROM MAIL_FORMAT WHERE FORMAT_CODE = ? ";
            stmt = connection.prepareStatement(sqlQuery);
            stmt.setString(1, templateCode);
            rs = stmt.executeQuery();
            if (rs.next()) {
                retString = this.checkNull(rs.getString(2));
                StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='" + userInfo.getCharEnc() + "'?><Errors>");
                retStrBuff.append("<error id='' type='E' column_name='tempateHdrName'>");
                retStrBuff.append("<message><![CDATA[Template code already exists]]></message>");
                if (retString.equalsIgnoreCase("")) {
                    retStrBuff.append("<description><![CDATA[ Template code already exists, Enter different template code ]]></description>");
                } else {
                    retStrBuff.append("<description><![CDATA[ Template code already exists for " + retString + ", Enter different template code ]]></description>");
                }
                retStrBuff.append("<trace><![CDATA[]]></trace>");
                retStrBuff.append("<redirect>1</redirect></error></Errors>");
                retString = retStrBuff.toString();
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :checkTemplateExists :==>");
            throw new ITMException(e);
        }
        return retString;
    }

    @Override
    public String updateEmailTemplate(String objName, UserInfoBean userInfo, String toAddr, String ccAddr, String bccAddr, String subject, String body, String templateCode, String templateName, String attachObjLinks) throws ITMException {
        String retString = "";
        BaseLogger.log("2", userInfo, null, "[TransactionEmailTempltEJB][updateEmailTemplate]Updating Email Templates .....");
        BaseLogger.log("2", userInfo, null, "attachObjLinks in update" + attachObjLinks);
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.getConnection(userInfo);
                String sqlQuery = "UPDATE MAIL_FORMAT SET SEND_TO = ?,COPY_TO = ?,BLIND_COPY = ?,SUBJECT = ?, BODY_TEXT = ?, MAIL_DESCR = ?,ATTACH_TEXT = ?,ATTACH_TYPE = ? WHERE FORMAT_CODE = ?";
                stmt = connection.prepareStatement(sqlQuery);
                stmt.setString(1, toAddr);
                stmt.setString(2, ccAddr);
                stmt.setString(3, bccAddr);
                stmt.setString(4, subject);
                body = this.removeInlineImages(body);
                stmt.setString(5, body);
                stmt.setString(6, templateName);
                stmt.setString(7, attachObjLinks);
                stmt.setString(8, "D");
                stmt.setString(9, templateCode);
                stmt.executeUpdate();
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                connection.commit();
                retString = "SUCCESS";
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :updateEmailTemplate :==>");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :updateEmailTemplate :==>");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :TransactionEmailTempltEJB :updateEmailTemplate :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return retString;
    }

    @Override
    public String deteteSelectedTemplate(String objName, UserInfoBean userInfo, String formatCode) throws ITMException {
        String retstring = "";
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.getConnection(userInfo);
                String sqlQuery = "UPDATE MAIL_FORMAT SET STATUS = ? WHERE FORMAT_CODE = ?";
                stmt = connection.prepareStatement(sqlQuery);
                stmt.setString(1, "N");
                stmt.setString(2, formatCode);
                stmt.executeUpdate();
                connection.commit();
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :deteteSelectedTemplate :==>");
                itme.printStackTrace();
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :deteteSelectedTemplate :==>");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :TransactionEmailTempltEJB :deteteSelectedTemplate :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return retstring;
    }

    @Override
    public String getEmailData(String objName, UserInfoBean userInfo, String toAddr, String ccAddr, String bccAddr, String subject, String body, String tranDataStr, String tranPKNames, String tranPKValues, String attachments) throws ITMException {
        String retXmlData = "";
        try {
            retXmlData = String.valueOf(retXmlData) + "<Document>";
            String[] pkValues = tranPKValues.split(",");
            String tranId = "";
            Document currentPkTranDom = null;
            int pkCount = 0;
            while (pkCount < pkValues.length) {
                currentPkTranDom = this.getCurrentTranDom(pkValues[pkCount], userInfo, objName);
                retXmlData = String.valueOf(retXmlData) + "<EMAILDATA>";
                tranId = pkValues[pkCount];
                if (tranId.substring(tranId.length() - 1).equals(":")) {
                    tranId = tranId.substring(0, tranId.length() - 1);
                }
                retXmlData = String.valueOf(retXmlData) + "<TRAN_ID><![CDATA[" + tranId + "]]></TRAN_ID>";
                retXmlData = String.valueOf(retXmlData) + "<SEND_TO><![CDATA[" + this.getEmailAddress(toAddr, currentPkTranDom, userInfo) + "]]></SEND_TO>";
                retXmlData = String.valueOf(retXmlData) + "<COPY_TO><![CDATA[" + this.getEmailAddress(ccAddr, currentPkTranDom, userInfo) + "]]></COPY_TO>";
                retXmlData = String.valueOf(retXmlData) + "<BLIND_COPY><![CDATA[" + this.getEmailAddress(bccAddr, currentPkTranDom, userInfo) + "]]></BLIND_COPY>";
                retXmlData = String.valueOf(retXmlData) + "<SUBJECT><![CDATA[" + this.getFormatedEmailSub(subject, currentPkTranDom) + "]]></SUBJECT>";
                retXmlData = String.valueOf(retXmlData) + "<BODY_TEXT><![CDATA[" + this.getFormatedEmailBody(body, currentPkTranDom) + "]]></BODY_TEXT>";
                retXmlData = String.valueOf(retXmlData) + "<ATTACHMENTS><![CDATA[" + this.getAttachmentsHtml(attachments, objName, userInfo) + "]]></ATTACHMENTS>";
                retXmlData = String.valueOf(retXmlData) + "</EMAILDATA>";
                ++pkCount;
            }
            retXmlData = String.valueOf(retXmlData) + "</Document>";
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :getEmailData :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :getEmailData :==>");
            throw new ITMException(e);
        }
        return retXmlData;
    }

    @Override
    public String getEmailDataFromJsonData(String objName, UserInfoBean userInfo, String toAddr, String ccAddr, String bccAddr, String subject, String body, String tranDataStr, String tranPKNames, String tranPKValues, String attachments, String jsonTranData) throws ITMException {
        String retXmlData = "";
        try {
            retXmlData = String.valueOf(retXmlData) + "<Document>";
            String tranId = "";
            Document currentPkTranDom = null;
            JSONObject jsonObject = new JSONObject(jsonTranData);
            Iterator keys = jsonObject.keys();
            String jsonToXml = "";
            while (keys.hasNext()) {
                tranId = (String)keys.next();
                if (jsonObject.get(tranId) instanceof JSONObject) {
                    JSONObject childJson = new JSONObject(jsonObject.get(tranId).toString());
                    BaseLogger.log("3", userInfo, null, childJson);
                    jsonToXml = XML.toString((Object)childJson);
                    BaseLogger.log("3", userInfo, null, jsonToXml);
                    currentPkTranDom = this.genericUtility.parseString("<Detail1>" + jsonToXml + "</Detail1>");
                }
                retXmlData = String.valueOf(retXmlData) + "<EMAILDATA>";
                if (tranId.substring(tranId.length() - 1).equals(":")) {
                    tranId = tranId.substring(0, tranId.length() - 1);
                }
                retXmlData = String.valueOf(retXmlData) + "<TRAN_ID><![CDATA[" + tranId + "]]></TRAN_ID>";
                retXmlData = String.valueOf(retXmlData) + "<SEND_TO><![CDATA[" + this.getEmailAddress(toAddr, currentPkTranDom, userInfo) + "]]></SEND_TO>";
                retXmlData = String.valueOf(retXmlData) + "<COPY_TO><![CDATA[" + this.getEmailAddress(ccAddr, currentPkTranDom, userInfo) + "]]></COPY_TO>";
                retXmlData = String.valueOf(retXmlData) + "<BLIND_COPY><![CDATA[" + this.getEmailAddress(bccAddr, currentPkTranDom, userInfo) + "]]></BLIND_COPY>";
                retXmlData = String.valueOf(retXmlData) + "<SUBJECT><![CDATA[" + this.getFormatedEmailSub(subject, currentPkTranDom) + "]]></SUBJECT>";
                retXmlData = String.valueOf(retXmlData) + "<BODY_TEXT><![CDATA[" + this.getFormatedEmailBody(body, currentPkTranDom) + "]]></BODY_TEXT>";
                retXmlData = String.valueOf(retXmlData) + "<ATTACHMENTS><![CDATA[" + this.getAttachmentsHtml(attachments, objName, userInfo) + "]]></ATTACHMENTS>";
                retXmlData = String.valueOf(retXmlData) + "</EMAILDATA>";
            }
            retXmlData = String.valueOf(retXmlData) + "</Document>";
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :getEmailData :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :getEmailData :==>");
            throw new ITMException(e);
        }
        return retXmlData;
    }

    @Override
    public String sendMail(String objName, UserInfoBean userInfo, String toAddr, String ccAddr, String bccAddr, String subject, String body, String tranDataStr, String tranPKNames, String tranPKValues, String attachments, String saveFlag, String templateName, String templateCode, String editFlag) throws ITMException {
        String retXmlData = "";
        String saveStatus = "";
        try {
            if ("true".equalsIgnoreCase(saveFlag) && (saveStatus = "A".equalsIgnoreCase(editFlag) ? this.saveNewEmailTemplate(objName, userInfo, toAddr, ccAddr, bccAddr, subject, body, templateName, templateCode, attachments) : this.updateEmailTemplate(objName, userInfo, toAddr, ccAddr, bccAddr, subject, body, templateCode, templateName, attachments)) != null && saveStatus.indexOf("<Errors>") != -1) {
                return saveStatus;
            }
            String[] pkValues = tranPKValues.split(",");
            String tranId = "";
            Document currentPkTranDom = null;
            String mailData = "<root>";
            int pkCount = 0;
            while (pkCount < pkValues.length) {
                try {
                    E12GenericUtility e12GenericUtility = new E12GenericUtility();
                    currentPkTranDom = E12GenericUtility.checkNull(tranDataStr).length() > 0 ? e12GenericUtility.parseString(tranDataStr) : this.getCurrentTranDom(pkValues[pkCount], userInfo, objName);
                }
                catch (Exception e) {
                    System.out.println("TransactionEmailTempltEJB.sendMail() Exception tranDataStr : [" + tranDataStr + "]");
                    currentPkTranDom = this.getCurrentTranDom(pkValues[pkCount], userInfo, objName);
                }
                mailData = String.valueOf(mailData) + "<EMAILDATA>";
                tranId = pkValues[pkCount];
                if (tranId.substring(tranId.length() - 1).equals(":")) {
                    tranId = tranId.substring(0, tranId.length() - 1);
                }
                mailData = String.valueOf(mailData) + "<TRAN_ID><![CDATA[" + tranId + "]]></TRAN_ID>";
                mailData = String.valueOf(mailData) + "<TO><![CDATA[" + this.getEmailAddress(toAddr, currentPkTranDom, userInfo) + "]]></TO>";
                mailData = String.valueOf(mailData) + "<CC><![CDATA[" + this.getEmailAddress(ccAddr, currentPkTranDom, userInfo) + "]]></CC>";
                mailData = String.valueOf(mailData) + "<BCC><![CDATA[" + this.getEmailAddress(bccAddr, currentPkTranDom, userInfo) + "]]></BCC>";
                mailData = String.valueOf(mailData) + "<SUB><![CDATA[" + this.getFormatedEmailSub(subject, currentPkTranDom) + "]]></SUB>";
                mailData = String.valueOf(mailData) + "<BODY><![CDATA[" + this.getFormatedEmailBody(body, currentPkTranDom) + "]]></BODY>";
                mailData = String.valueOf(mailData) + "<ATTACHMENTS><![CDATA[" + attachments + "]]></ATTACHMENTS>";
                mailData = String.valueOf(mailData) + "</EMAILDATA>";
                ++pkCount;
            }
            mailData = String.valueOf(mailData) + "</root>";
            retXmlData = this.sendMail(objName, userInfo, mailData, "");
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw new ITMException(e);
        }
        return retXmlData;
    }

    public String sendTelegram(String objName, UserInfoBean userInfo, String toAddr, String ccAddr, String bccAddr, String subject, String body, String tranDataStr, String tranPKNames, String tranPKValues, String attachments, String saveFlag, String templateName, String templateCode, String editFlag) throws ITMException {
        BaseLogger.log("3", userInfo, null, "Inside sendTelegram::: TransactionEmailTempltEJB.java");
        String retXmlData = "";
        String saveStatus = "";
        try {
            String[] pkValues = tranPKValues.split(",");
            String tranId = "";
            Document currentPkTranDom = null;
            String mailData = "<root>";
            int pkCount = 0;
            while (pkCount < pkValues.length) {
                try {
                    E12GenericUtility e12GenericUtility = new E12GenericUtility();
                    currentPkTranDom = E12GenericUtility.checkNull(tranDataStr).length() > 0 ? e12GenericUtility.parseString(tranDataStr) : this.getCurrentTranDom(pkValues[pkCount], userInfo, objName);
                }
                catch (Exception e) {
                    System.out.println("TransactionEmailTempltEJB.sendMail() Exception tranDataStr : [" + tranDataStr + "]");
                    currentPkTranDom = this.getCurrentTranDom(pkValues[pkCount], userInfo, objName);
                }
                mailData = String.valueOf(mailData) + "<EMAILDATA>";
                tranId = pkValues[pkCount];
                if (tranId.substring(tranId.length() - 1).equals(":")) {
                    tranId = tranId.substring(0, tranId.length() - 1);
                }
                mailData = String.valueOf(mailData) + "<TRAN_ID><![CDATA[" + tranId + "]]></TRAN_ID>";
                mailData = String.valueOf(mailData) + "<TO><![CDATA[" + this.getEmailAddress(toAddr, currentPkTranDom, userInfo) + "]]></TO>";
                mailData = String.valueOf(mailData) + "<CC><![CDATA[" + this.getEmailAddress(ccAddr, currentPkTranDom, userInfo) + "]]></CC>";
                mailData = String.valueOf(mailData) + "<BCC><![CDATA[" + this.getEmailAddress(bccAddr, currentPkTranDom, userInfo) + "]]></BCC>";
                mailData = String.valueOf(mailData) + "<SUB><![CDATA[" + this.getFormatedEmailSub(subject, currentPkTranDom) + "]]></SUB>";
                mailData = String.valueOf(mailData) + "<BODY><![CDATA[" + this.getFormatedEmailBody(body, currentPkTranDom) + "]]></BODY>";
                mailData = String.valueOf(mailData) + "<ATTACHMENTS><![CDATA[" + attachments + "]]></ATTACHMENTS>";
                mailData = String.valueOf(mailData) + "</EMAILDATA>";
                ++pkCount;
            }
            mailData = String.valueOf(mailData) + "</root>";
            retXmlData = this.sendMail(objName, userInfo, mailData, "");
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw new ITMException(e);
        }
        BaseLogger.log("3", userInfo, null, "retXmlData ::: TransactionEmailTempltEJB.java:::" + retXmlData);
        return retXmlData;
    }

    @Override
    public String sendMailFromJsonData(String objName, UserInfoBean userInfo, String toAddr, String ccAddr, String bccAddr, String subject, String body, String tranDataStr, String tranPKNames, String tranPKValues, String attachments, String saveFlag, String templateName, String templateCode, String editFlag, String jsonTranData) throws ITMException {
        String retXmlData = "";
        String saveStatus = "";
        try {
            if ("true".equalsIgnoreCase(saveFlag) && (saveStatus = "A".equalsIgnoreCase(editFlag) ? this.saveNewEmailTemplate(objName, userInfo, toAddr, ccAddr, bccAddr, subject, body, templateName, templateCode, attachments) : this.updateEmailTemplate(objName, userInfo, toAddr, ccAddr, bccAddr, subject, body, templateCode, templateName, attachments)) != null && saveStatus.indexOf("<Errors>") != -1) {
                return saveStatus;
            }
            String tranId = "";
            Document currentPkTranDom = null;
            String mailData = "<root>";
            JSONObject jsonObject = new JSONObject(jsonTranData);
            Iterator keys = jsonObject.keys();
            String jsonToXml = "";
            while (keys.hasNext()) {
                tranId = (String)keys.next();
                if (jsonObject.get(tranId) instanceof JSONObject) {
                    JSONObject childJson = new JSONObject(jsonObject.get(tranId).toString());
                    BaseLogger.log("3", userInfo, null, childJson);
                    jsonToXml = XML.toString((Object)childJson);
                    BaseLogger.log("3", userInfo, null, jsonToXml);
                    currentPkTranDom = this.genericUtility.parseString("<Detail1>" + jsonToXml + "</Detail1>");
                }
                mailData = String.valueOf(mailData) + "<EMAILDATA>";
                if (tranId.substring(tranId.length() - 1).equals(":")) {
                    tranId = tranId.substring(0, tranId.length() - 1);
                }
                mailData = String.valueOf(mailData) + "<TRAN_ID><![CDATA[" + tranId + "]]></TRAN_ID>";
                mailData = String.valueOf(mailData) + "<TO><![CDATA[" + this.getEmailAddress(toAddr, currentPkTranDom, userInfo) + "]]></TO>";
                mailData = String.valueOf(mailData) + "<CC><![CDATA[" + this.getEmailAddress(ccAddr, currentPkTranDom, userInfo) + "]]></CC>";
                mailData = String.valueOf(mailData) + "<BCC><![CDATA[" + this.getEmailAddress(bccAddr, currentPkTranDom, userInfo) + "]]></BCC>";
                mailData = String.valueOf(mailData) + "<SUB><![CDATA[" + this.getFormatedEmailSub(subject, currentPkTranDom) + "]]></SUB>";
                mailData = String.valueOf(mailData) + "<BODY><![CDATA[" + this.getFormatedEmailBody(body, currentPkTranDom) + "]]></BODY>";
                mailData = String.valueOf(mailData) + "<ATTACHMENTS><![CDATA[" + attachments + "]]></ATTACHMENTS>";
                mailData = String.valueOf(mailData) + "</EMAILDATA>";
            }
            mailData = String.valueOf(mailData) + "</root>";
            retXmlData = this.sendMail(objName, userInfo, mailData, jsonTranData);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw new ITMException(e);
        }
        return retXmlData;
    }

    @Override
    public String sendMail(String objName, UserInfoBean userInfo, String mailData, String jsonTranData) throws ITMException {
        BaseLogger.log("3", userInfo, null, "Inside TransactionEmailTempltEJB :sendMail :==>");
        String retString = "<root>";
        String emailString = "";
        NodeList emailNodeList = null;
        Node emailNode = null;
        Document emailDom = null;
        Document currentPkTranDom = null;
        String to = "";
        String cc = "";
        String bcc = "";
        String sub = "";
        String body = "";
        String mainBody = "";
        String tranId = "";
        String attachObjLink = "";
        String attachmentPath = "";
        String recipients = "";
        String[] attachementArr = null;
        String jsonToXml = "";
        String inlineImages = "";
        ArrayList<String> tempImageNames = null;
        FileInputStream fis = null;
        try {
            try {
                EMail email = new EMail();
                Document allMailDom = this.genericUtility.parseString(mailData);
                emailNodeList = allMailDom.getElementsByTagName("EMAILDATA");
                String imagePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp" + File.separator;
                int emlCntr = 0;
                while (emlCntr < emailNodeList.getLength()) {
                    recipients = "";
                    to = "";
                    cc = "";
                    bcc = "";
                    sub = "";
                    body = "";
                    mainBody = "";
                    tranId = "";
                    attachObjLink = "";
                    attachmentPath = "";
                    jsonToXml = "";
                    inlineImages = "";
                    tempImageNames = new ArrayList<String>();
                    emailString = "<root>";
                    emailNode = emailNodeList.item(emlCntr);
                    emailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(emailNode));
                    if (emailDom.getElementsByTagName("TRAN_ID").item(0) != null && emailDom.getElementsByTagName("TRAN_ID").item(0).getFirstChild() != null) {
                        tranId = this.checkNull(emailDom.getElementsByTagName("TRAN_ID").item(0).getFirstChild().getNodeValue());
                    }
                    if (emailDom.getElementsByTagName("TO").item(0) != null && emailDom.getElementsByTagName("TO").item(0).getFirstChild() != null) {
                        to = this.checkNull(emailDom.getElementsByTagName("TO").item(0).getFirstChild().getNodeValue());
                    }
                    if (emailDom.getElementsByTagName("CC").item(0) != null && emailDom.getElementsByTagName("CC").item(0).getFirstChild() != null) {
                        cc = this.checkNull(emailDom.getElementsByTagName("CC").item(0).getFirstChild().getNodeValue());
                    }
                    if (emailDom.getElementsByTagName("BCC").item(0) != null && emailDom.getElementsByTagName("BCC").item(0).getFirstChild() != null) {
                        bcc = this.checkNull(emailDom.getElementsByTagName("BCC").item(0).getFirstChild().getNodeValue());
                    }
                    if (emailDom.getElementsByTagName("SUB").item(0) != null && emailDom.getElementsByTagName("SUB").item(0).getFirstChild() != null) {
                        sub = this.checkNull(emailDom.getElementsByTagName("SUB").item(0).getFirstChild().getNodeValue());
                    }
                    if (emailDom.getElementsByTagName("BODY").item(0) != null && emailDom.getElementsByTagName("BODY").item(0).getFirstChild() != null) {
                        body = this.checkNull(emailDom.getElementsByTagName("BODY").item(0).getFirstChild().getNodeValue());
                    }
                    if (emailDom.getElementsByTagName("ATTACHMENTS").item(0) != null && emailDom.getElementsByTagName("ATTACHMENTS").item(0).getFirstChild() != null) {
                        attachObjLink = this.checkNull(emailDom.getElementsByTagName("ATTACHMENTS").item(0).getFirstChild().getNodeValue());
                    }
                    if (tranId.substring(tranId.length() - 1).equals(":")) {
                        tranId = tranId.substring(0, tranId.length() - 1);
                    }
                    if (to.length() > 0) {
                        emailString = String.valueOf(emailString) + "<TO_ADD><![CDATA[" + to + "]]></TO_ADD>";
                        recipients = String.valueOf(recipients) + " " + to;
                    }
                    if (cc.length() > 0) {
                        emailString = String.valueOf(emailString) + "<CC_ADD><![CDATA[" + cc + "]]></CC_ADD>";
                        recipients = String.valueOf(recipients) + " " + cc;
                    }
                    if (bcc.length() > 0) {
                        emailString = String.valueOf(emailString) + "<BCC_ADD><![CDATA[" + bcc + "]]></BCC_ADD>";
                        recipients = String.valueOf(recipients) + " " + bcc;
                    }
                    if (sub.length() > 0) {
                        emailString = String.valueOf(emailString) + "<SUBJECT><![CDATA[" + sub + "]]></SUBJECT>";
                    }
                    if (body.length() > 0) {
                        String findStr = "<img src=\"";
                        String colFullName = "";
                        boolean found = false;
                        int currentIndex = 0;
                        int nextSearchIndex = 0;
                        String currColVal = "";
                        int imageCntr = 0;
                        while (body.indexOf(findStr, nextSearchIndex) != -1) {
                            currColVal = "";
                            ++imageCntr;
                            BaseLogger.log("3", userInfo, null, nextSearchIndex);
                            currentIndex = body.indexOf(findStr, nextSearchIndex);
                            String firstPart = body.substring(0, currentIndex);
                            String lastPart = body.substring(currentIndex, body.length());
                            colFullName = lastPart.substring(0, lastPart.indexOf(">") + 1);
                            BaseLogger.log("3", userInfo, null, "colFullName:" + colFullName);
                            String sourceData = colFullName;
                            String encodingPrefix = "base64,";
                            int contentStartIndex = sourceData.indexOf(encodingPrefix) + encodingPrefix.length();
                            byte[] imageData = Base64.decodeBase64((String)sourceData.substring(contentStartIndex));
                            ByteArrayInputStream in = new ByteArrayInputStream(imageData);
                            BufferedImage bImageFromConvert = ImageIO.read(in);
                            BaseLogger.log("3", userInfo, null, "inlineImagePath:" + imagePath);
                            while (new File(String.valueOf(imagePath) + "image" + imageCntr + ".png").exists()) {
                                ++imageCntr;
                            }
                            tempImageNames.add("image" + imageCntr);
                            ImageIO.write((RenderedImage)bImageFromConvert, "png", new File(String.valueOf(imagePath) + "image" + imageCntr + ".png"));
                            inlineImages = String.valueOf(inlineImages) + "<image" + imageCntr + "><![CDATA[" + imagePath + "image" + imageCntr + ".png" + "]]></image" + imageCntr + ">";
                            currColVal = "<img   src=\"cid:image" + imageCntr + "\">";
                            body = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName.replace("+", "\\+"), currColVal);
                            nextSearchIndex = currentIndex + currColVal.length();
                            ((InputStream)in).close();
                        }
                        mainBody = body;
                        BaseLogger.log("3", userInfo, null, "mainBody : " + mainBody);
                    }
                    if (attachObjLink.length() > 0) {
                        if (attachObjLink.substring(attachObjLink.length() - 1).equals(",")) {
                            attachObjLink = attachObjLink.substring(0, attachObjLink.length() - 1);
                            if (jsonTranData == null || jsonTranData.equalsIgnoreCase("null") || jsonTranData.length() <= 0) {
                                currentPkTranDom = this.getCurrentTranDom(tranId, userInfo, objName);
                            } else {
                                JSONObject jsonObject = new JSONObject(jsonTranData);
                                JSONObject childJson = new JSONObject(jsonObject.get(tranId).toString());
                                BaseLogger.log("3", userInfo, null, childJson);
                                jsonToXml = XML.toString((Object)childJson);
                                BaseLogger.log("3", userInfo, null, jsonToXml);
                                currentPkTranDom = this.genericUtility.parseString("<Detail1>" + jsonToXml + "</Detail1>");
                            }
                            attachementArr = attachObjLink.split(",");
                            BaseLogger.log("3", userInfo, null, "attachementArr.. " + attachementArr);
                            int i = 0;
                            while (i < attachementArr.length) {
                                String[] linkParts = attachementArr[i].split("~");
                                String attachLinks = linkParts[0];
                                String attachType = linkParts[1];
                                BaseLogger.log("3", userInfo, null, "attachLinks.1 " + attachType + "attachLinks.2 " + attachLinks);
                                if ("B".equalsIgnoreCase(attachType)) {
                                    BaseLogger.log("3", userInfo, null, "Inside if TransactionEmailTempltEJB attachType = B");
                                    String bodyAttchPath = this.getAttachmentPath(objName, attachLinks, userInfo, currentPkTranDom, tranId, "html");
                                    BaseLogger.log("3", userInfo, null, "bodyAttchPath :" + bodyAttchPath);
                                    String htmlContent = this.readFile(bodyAttchPath);
                                    mainBody = String.valueOf(mainBody) + htmlContent;
                                    BaseLogger.log("3", userInfo, null, "mainBody :" + mainBody);
                                } else {
                                    BaseLogger.log("3", userInfo, null, "Inside else TransactionEmailTempltEJB attachType = B");
                                    attachmentPath = String.valueOf(attachmentPath) + this.getAttachmentPath(objName, attachLinks, userInfo, currentPkTranDom, tranId, "pdf") + ";";
                                    BaseLogger.log("3", userInfo, null, "else Attachment Path:" + attachmentPath);
                                }
                                ++i;
                            }
                            BaseLogger.log("3", userInfo, null, "Attachment Path:" + attachmentPath);
                        }
                        emailString = String.valueOf(emailString) + "<EMAIL_TYPE><![CDATA[page]]></EMAIL_TYPE>";
                        if (attachmentPath != null & attachmentPath.trim().length() > 0) {
                            emailString = String.valueOf(emailString) + "<XML_DATA_FILE><![CDATA[" + attachmentPath + "]]></XML_DATA_FILE>";
                        }
                    }
                    emailString = String.valueOf(emailString) + "<INLINE_IMAGES>" + inlineImages + "</INLINE_IMAGES>";
                    emailString = String.valueOf(emailString) + "<MESSAGE><![CDATA[" + mainBody + "]]></MESSAGE>";
                    emailString = String.valueOf(emailString) + "<MESSAGE_TYPE><![CDATA[text/html]]></MESSAGE_TYPE>";
                    emailString = String.valueOf(emailString) + "</root>";
                    BaseLogger.log("3", userInfo, null, "emailString:" + emailString);
                    retString = String.valueOf(retString) + "<MAIL><TRAN_ID>" + tranId + "</TRAN_ID>";
                    if (to.length() > 0 || cc.length() > 0 || bcc.length() > 0) {
                        String status = "";
                        String failedReason = "";
                        try {
                            status = email.sendMail(emailString, null, userInfo);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            status = "N";
                            failedReason = e.getMessage();
                        }
                        retString = String.valueOf(retString) + "<STATUS>" + status + "</STATUS>";
                        retString = String.valueOf(retString) + "<FAILED_REASON>" + failedReason + "</FAILED_REASON>";
                        if (recipients.substring(recipients.length() - 1).equals(",")) {
                            recipients = recipients.substring(0, recipients.length() - 1);
                        }
                        retString = String.valueOf(retString) + "<RECIPIENTS>" + recipients + "</RECIPIENTS>";
                    } else {
                        retString = String.valueOf(retString) + "<FAILED_REASON><![CDATA[NO_RECIPIENTS]]></FAILED_REASON>";
                        retString = String.valueOf(retString) + "<RECIPIENTS><![CDATA[NO_RECIPIENTS]]></RECIPIENTS>";
                        retString = String.valueOf(retString) + "<STATUS>N</STATUS>";
                    }
                    retString = String.valueOf(retString) + "</MAIL>";
                    for (String fileName : tempImageNames) {
                        if (!new File(String.valueOf(imagePath) + fileName + ".png").exists()) continue;
                        BaseLogger.log("3", userInfo, null, "tempImagePathForDelete:" + imagePath);
                        BaseLogger.log("3", userInfo, null, "tempImageNameForDelete:" + fileName);
                        new File(String.valueOf(imagePath) + fileName + ".png").delete();
                    }
                    ++emlCntr;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        retString = String.valueOf(retString) + "</root>";
        BaseLogger.log("3", userInfo, null, "Inside TransactionEmailTempltEJB :sendMail :==> retString:::" + retString);
        return retString;
    }

    private String getEmailAddress(String emailAddrFlds, Document tranDom, UserInfoBean userInfo) throws ITMException {
        String emailAddress = "";
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String[] emailAddrFldArr = emailAddrFlds.split(",");
        String currentAddrFld = "";
        String currentAddrVal = "";
        String currentAddrFldFull = "";
        String findStr = "<Detail1.";
        String entityType = "";
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            detailNode = detailNodeList.item(0);
            detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
            int pkCntr = 0;
            while (pkCntr < emailAddrFldArr.length) {
                currentAddrVal = "";
                currentAddrFldFull = emailAddrFldArr[pkCntr];
                if (currentAddrFldFull.startsWith(findStr)) {
                    currentAddrFld = currentAddrFldFull.substring(findStr.length(), currentAddrFldFull.lastIndexOf(">"));
                    BaseLogger.log("3", userInfo, null, currentAddrFld);
                    if (detailDom.getElementsByTagName(currentAddrFld).item(0) != null && detailDom.getElementsByTagName(currentAddrFld).item(0).getFirstChild() != null) {
                        currentAddrVal = detailDom.getElementsByTagName(currentAddrFld).item(0).getFirstChild().getNodeValue();
                    }
                } else if (currentAddrFldFull.startsWith("{")) {
                    entityType = "";
                    if (currentAddrFldFull.charAt(1) == '(') {
                        entityType = currentAddrFldFull.substring(currentAddrFldFull.indexOf("(") + 1, currentAddrFldFull.indexOf(")"));
                        currentAddrFld = currentAddrFldFull.substring(currentAddrFldFull.indexOf(")") + 1, currentAddrFldFull.indexOf("}"));
                        currentAddrVal = this.getAddressValue(entityType, currentAddrFld, tranDom, userInfo);
                    }
                } else {
                    currentAddrVal = currentAddrFldFull;
                }
                if (currentAddrVal != null && currentAddrVal.length() > 0) {
                    emailAddress = String.valueOf(emailAddress) + currentAddrVal + ",";
                }
                ++pkCntr;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return emailAddress;
    }

    private String getAddressValue(String entityType, String argName, Document tranDom, UserInfoBean userInfo) throws ITMException {
        String retEmailAddr = "";
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String whereFieldValue = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            if (entityType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                whereFieldName = "CUST_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                whereFieldName = "SUPP_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                whereFieldName = "EMP_CODE";
                selFieldName = "EMAIL_ID_OFF";
            } else if (entityType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                whereFieldName = "SALES_PERS";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("T")) {
                masterTable = "TRANSPORTER";
                whereFieldName = "TRAN_CODE";
                selFieldName = "EMAIL_ADDR";
            }
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            detailNode = detailNodeList.item(0);
            detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
            BaseLogger.log("3", userInfo, null, "genericUtility.serializeDom(detailDom):" + this.genericUtility.serializeDom(detailDom));
            BaseLogger.log("3", userInfo, null, "AgrName:" + argName);
            if (detailDom.getElementsByTagName(argName) != null && detailDom.getElementsByTagName(argName).item(0) != null && detailDom.getElementsByTagName(argName).item(0).getFirstChild() != null) {
                whereFieldValue = detailDom.getElementsByTagName(argName).item(0).getFirstChild().getNodeValue();
            }
            BaseLogger.log("3", userInfo, null, "masterTable:" + masterTable + " \nwhereFieldName:" + whereFieldName + " \nselFieldName" + selFieldName + " \nwhereFieldValue:" + whereFieldValue);
            retEmailAddr = dbAccess.getEmailAddr(selFieldName, masterTable, whereFieldName, whereFieldValue, userInfo);
            dbAccess = null;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retEmailAddr;
    }

    private String getFormatedEmailBody(String bodyTextData, Document tranDom) throws ITMException {
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String findStr = "&lt;Detail1.";
        String colFullName = "";
        String colName = "";
        String currColVal = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            if (bodyTextData != null) {
                detailNode = detailNodeList.item(0);
                detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
                while (bodyTextData.indexOf(findStr, nextSearchIndex) != -1) {
                    BaseLogger.log("3", null, null, nextSearchIndex);
                    currColVal = "";
                    currentIndex = bodyTextData.indexOf(findStr, nextSearchIndex);
                    String firstPart = bodyTextData.substring(0, currentIndex);
                    String lastPart = bodyTextData.substring(currentIndex, bodyTextData.length());
                    colFullName = lastPart.substring(0, lastPart.indexOf("&gt;") + 4);
                    BaseLogger.log("3", null, null, "colFullName:" + colFullName);
                    colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf("&gt;"));
                    BaseLogger.log("3", null, null, "colName:" + colName);
                    if (detailDom.getElementsByTagName(colName).item(0) != null && detailDom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                        currColVal = detailDom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
                    }
                    bodyTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, currColVal);
                    nextSearchIndex = currentIndex + currColVal.length();
                    BaseLogger.log("3", null, null, "bodyTextData" + bodyTextData);
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return bodyTextData;
    }

    private String getFormatedEmailSub(String subTextData, Document tranDom) throws ITMException {
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String findStr = "<Detail1.";
        String colFullName = "";
        String colName = "";
        String currColVal = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            if (subTextData != null) {
                detailNode = detailNodeList.item(0);
                detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
                while (subTextData.indexOf(findStr, nextSearchIndex) != -1) {
                    BaseLogger.log("3", null, null, nextSearchIndex);
                    currColVal = "";
                    currentIndex = subTextData.indexOf(findStr, nextSearchIndex);
                    String firstPart = subTextData.substring(0, currentIndex);
                    String lastPart = subTextData.substring(currentIndex, subTextData.length());
                    colFullName = lastPart.substring(0, lastPart.indexOf(">") + 1);
                    BaseLogger.log("3", null, null, "colFullName:" + colFullName);
                    colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf(">"));
                    BaseLogger.log("3", null, null, "colName:" + colName);
                    if (detailDom.getElementsByTagName(colName).item(0) != null && detailDom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                        currColVal = detailDom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
                    }
                    subTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, currColVal);
                    nextSearchIndex = currentIndex + currColVal.length();
                    BaseLogger.log("3", null, null, "SubTextData" + subTextData);
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return subTextData;
    }

    private Document getCurrentTranDom(String pkValues, UserInfoBean userInfo, String objName) throws ITMException {
        String tranXml = "";
        try {
            MasterDataEJB masterDataEJB = new MasterDataEJB();
            tranXml = masterDataEJB.getXMLFromDBForBrow(objName, "1", "2", pkValues, null, null, userInfo);
            masterDataEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return this.genericUtility.parseString(tranXml);
    }

    @Override
    public String getSelectedEmailXmlData(String objName, UserInfoBean userInfo, String formatCode, String jsonTranData) throws ITMException {
        BaseLogger.log("2", userInfo, null, "[TransactionEmailTempltEJB:getSelectedEmailXmlData]Getting selected Email Template .....");
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        String retXmlData = "<Document>";
        String colNameString = "";
        try {
            try {
                connection = this.getConnection(userInfo);
                String selectQuery = "SELECT FORMAT_CODE, SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, MAIL_DESCR,ATTACH_TEXT,ATTACH_TYPE,USER_ID__OWN FROM MAIL_FORMAT WHERE FORMAT_CODE = ?";
                stmt = connection.prepareStatement(selectQuery);
                stmt.setString(1, formatCode);
                rs = stmt.executeQuery();
                colNameString = this.getPopHelpData(objName, userInfo, "2", "1", "MAILADDR", jsonTranData);
                this.lastDyanInpCol = 1;
                this.lastDyanSubInpCol = 1;
                while (rs.next()) {
                    retXmlData = String.valueOf(retXmlData) + "<FORMAT_CODE><![CDATA[" + this.checkNull(rs.getString("FORMAT_CODE")) + "]]></FORMAT_CODE>";
                    retXmlData = String.valueOf(retXmlData) + "<SEND_TO>" + TransactionEmailTempltEJB.getColumnLableData(this.checkNull(rs.getString("SEND_TO")), colNameString) + "</SEND_TO>";
                    retXmlData = String.valueOf(retXmlData) + "<COPY_TO>" + TransactionEmailTempltEJB.getColumnLableData(this.checkNull(rs.getString("COPY_TO")), colNameString) + "</COPY_TO>";
                    retXmlData = String.valueOf(retXmlData) + "<BLIND_COPY>" + TransactionEmailTempltEJB.getColumnLableData(this.checkNull(rs.getString("BLIND_COPY")), colNameString) + "</BLIND_COPY>";
                    retXmlData = String.valueOf(retXmlData) + "<SUBJECT><![CDATA[" + this.getHtmlSubText(this.checkNull(rs.getString("SUBJECT")), colNameString) + "]]></SUBJECT>";
                    retXmlData = String.valueOf(retXmlData) + "<LAST_DYNAMIC_SUB_CNT><![CDATA[" + this.lastDyanSubInpCol + "]]></LAST_DYNAMIC_SUB_CNT>";
                    retXmlData = String.valueOf(retXmlData) + "<BODY_TEXT><![CDATA[" + this.getHtmlBodyText(this.checkNull(rs.getString("BODY_TEXT")), colNameString) + "]]></BODY_TEXT>";
                    retXmlData = String.valueOf(retXmlData) + "<LAST_DYNAMIC_CNT><![CDATA[" + this.lastDyanInpCol + "]]></LAST_DYNAMIC_CNT>";
                    retXmlData = String.valueOf(retXmlData) + "<MAIL_DESCR><![CDATA[" + this.checkNull(rs.getString("MAIL_DESCR")) + "]]></MAIL_DESCR>";
                    String attachText = this.checkNull(rs.getString("ATTACH_TEXT"));
                    String attchTextNew = "";
                    if (attachText != null && attachText.length() > 0) {
                        if (attachText.contains("~")) {
                            attchTextNew = attachText;
                        } else {
                            if (attachText.substring(attachText.length() - 1).equals(",")) {
                                attachText = attachText.substring(0, attachText.length() - 1);
                            }
                            String[] attacheText = attachText.split(",");
                            int attachCnt = 0;
                            while (attachCnt < attacheText.length) {
                                attchTextNew = String.valueOf(attacheText[attachCnt]) + "~A" + ",";
                                ++attachCnt;
                            }
                        }
                    }
                    retXmlData = String.valueOf(retXmlData) + "<ATTACHMENTS><![CDATA[" + this.getAttachmentsHtml(attchTextNew, objName, userInfo) + "]]></ATTACHMENTS>";
                    retXmlData = userInfo.getUserLevel().equalsIgnoreCase("0") ? String.valueOf(retXmlData) + "<DELETE_ALLOW><![CDATA[Y]]></DELETE_ALLOW>" : (rs.getString("USER_ID__OWN") != null && this.checkNull(rs.getString("USER_ID__OWN")).equalsIgnoreCase(this.checkNull(userInfo.getLoginCode())) ? String.valueOf(retXmlData) + "<DELETE_ALLOW><![CDATA[Y]]></DELETE_ALLOW>" : String.valueOf(retXmlData) + "<DELETE_ALLOW><![CDATA[N]]></DELETE_ALLOW>");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                retXmlData = String.valueOf(retXmlData) + "</Document>";
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :getSelectedEmailXmlData :==>");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :TransactionEmailTempltEJB :getSelectedEmailXmlData :==>");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :TransactionEmailTempltEJB :getAllTemplatesHTMLData :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return retXmlData;
    }

    private String getAttachmentsHtml(String attachText, String objName, UserInfoBean userInfo) throws ITMException {
        String attachments = "";
        int attachIndex = 0;
        BaseLogger.log("2", userInfo, null, "attachText " + attachText);
        if (attachText != null && attachText.length() > 0) {
            if (attachText.substring(attachText.length() - 1).equals(",")) {
                attachText = attachText.substring(0, attachText.length() - 1);
            }
            String[] attacheText = attachText.split(",");
            int attachCnt = 0;
            while (attachCnt < attacheText.length) {
                BaseLogger.log("3", userInfo, null, "attachementArr.. " + attacheText[attachCnt]);
                String[] linkParts = attacheText[attachCnt].split("~");
                String attachCode = linkParts[0];
                String attachType = linkParts[1];
                BaseLogger.log("3", userInfo, null, "attachCode : " + attachCode + " attachType " + attachType);
                if (attacheText[attachCnt].length() > 0) {
                    String linkInfoStr = this.getObjLinks(objName, userInfo, attachCode.split(":")[0]);
                    String linkType = "";
                    String linkTitle = "";
                    String linkFormNo = "";
                    String linkFieldName = "";
                    String reportList = "";
                    Document linkInfoDoc = this.genericUtility.parseString(linkInfoStr);
                    NodeList linksInfoLst = linkInfoDoc.getElementsByTagName("Link");
                    int i = 0;
                    while (i < linksInfoLst.getLength()) {
                        NodeList linkNodeList = linksInfoLst.item(i).getChildNodes();
                        Node formNoAttr = linksInfoLst.item(i).getAttributes().getNamedItem("formNo");
                        Node fieldNameAttr = linksInfoLst.item(i).getAttributes().getNamedItem("fieldName");
                        if (formNoAttr != null) {
                            linkFormNo = formNoAttr.getNodeValue();
                        }
                        if (fieldNameAttr != null) {
                            linkFieldName = fieldNameAttr.getNodeValue();
                        }
                        int j = 0;
                        while (j < linkNodeList.getLength()) {
                            Node linkNode = linkNodeList.item(j);
                            if (linkNode.getNodeName().equalsIgnoreCase("LinkType") && linkNode.getFirstChild() != null) {
                                linkType = linkNode.getFirstChild().getNodeValue();
                            }
                            if (linkNode.getNodeName().equalsIgnoreCase("LinkTitle") && linkNode.getFirstChild() != null) {
                                linkTitle = linkNode.getFirstChild().getNodeValue();
                            }
                            ++j;
                        }
                        if (linkType.equals("5")) {
                            reportList = linkFieldName.equals(attachCode.split(":")[1]) ? String.valueOf(reportList) + "<option selected=\"selected\" value=\"" + linkFormNo + ":" + linkFieldName + "\">" + linkTitle + "</option>" : String.valueOf(reportList) + "<option value=\"" + linkFormNo + ":" + linkFieldName + "\">" + linkTitle + "</option>";
                        }
                        ++i;
                    }
                    attachments = String.valueOf(attachments) + "<div class=\"vR attach\"><span name=\"attachSpanCode\" class=\"vN bfK a3q\"> <div class=\"DD\"> <select onClick=\"event.stopPropagation();\" id=\"attachdoc" + attachIndex + "\" onchange=\"setSelected(this);disableAttachType(this," + attachIndex + ")\" name=\"attachdoc\" class=\"ddf\" style=\"width: 82px;\">  <option  value=\"\">--Select--</option>  " + reportList + " </select> " + "<select onClick=\"event.stopPropagation();\" id=\"attachdoctype" + attachIndex + "\" onchange=\"setSelected(this)\" name=\"attachdoctype\" class=\"ddf\" style=\"width: 82px;\"> ";
                    if ("B".equalsIgnoreCase(attachType)) {
                        attachments = String.valueOf(attachments) + "<option selected=\"selected\"  value=\"B\"> Embed in mail body </option>";
                        attachments = String.valueOf(attachments) + "<option value=\"A\"> Send as attachment</option>";
                    } else {
                        attachments = String.valueOf(attachments) + "<option  value=\"B\"> Embed in mail body </option>";
                        attachments = String.valueOf(attachments) + "<option selected=\"selected\"  value=\"A\"> Send as attachment</option>";
                    }
                    attachments = String.valueOf(attachments) + "</select></div><div class=\"vM\" onClick=\" event.stopPropagation();removeAttachment(this);\"></div></span></div>";
                }
                ++attachIndex;
                ++attachCnt;
            }
        }
        BaseLogger.log("2", userInfo, null, "attachments :" + attachments);
        return attachments;
    }

    private String checkNull(String input) {
        if (input == null) {
            input = "";
        }
        return input.trim();
    }

    private static String getColumnLableData(String colData, String xmlColsData) throws Exception {
        String columnLableData = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        Document xmlColsDom = genericUtility.parseString(xmlColsData);
        Node detailNode = null;
        NodeList detailNodeList = null;
        String[] toAddrArray = null;
        String colName = "";
        Document detailDom = null;
        String entityType = "";
        if (colData != null) {
            toAddrArray = colData.split(",");
            int i = 0;
            while (i < toAddrArray.length) {
                int nodeCnter;
                columnLableData = String.valueOf(columnLableData) + "<ADDRESS_FLD>";
                colName = toAddrArray[i];
                if (colName.indexOf("<Detail1.") != -1) {
                    colName = colName.substring(9, colName.lastIndexOf(">"));
                    detailNodeList = xmlColsDom.getElementsByTagName("DETAIL");
                    nodeCnter = 0;
                    while (nodeCnter < detailNodeList.getLength()) {
                        detailNode = detailNodeList.item(nodeCnter);
                        detailDom = genericUtility.parseString(genericUtility.serializeDom(detailNode));
                        if (colName.equals(detailDom.getElementsByTagName("Descr").item(0).getFirstChild().getNodeValue())) {
                            BaseLogger.log("3", null, null, detailDom.getElementsByTagName("MAILADDR").item(0).getFirstChild().getNodeValue());
                            columnLableData = String.valueOf(columnLableData) + "<COL_LABLE>" + detailDom.getElementsByTagName("MAILADDR").item(0).getFirstChild().getNodeValue() + "</COL_LABLE>";
                            columnLableData = String.valueOf(columnLableData) + "<COL_NAME>" + colName + "</COL_NAME>";
                            break;
                        }
                        ++nodeCnter;
                    }
                } else if (colName.startsWith("{")) {
                    entityType = "";
                    if (colName.charAt(1) == '(') {
                        entityType = colName.substring(colName.indexOf("(") + 1, colName.indexOf(")"));
                        colName = colName.substring(colName.indexOf(")") + 1, colName.indexOf("}"));
                        detailNodeList = xmlColsDom.getElementsByTagName("DETAIL");
                        nodeCnter = 0;
                        while (nodeCnter < detailNodeList.getLength()) {
                            detailNode = detailNodeList.item(nodeCnter);
                            detailDom = genericUtility.parseString(genericUtility.serializeDom(detailNode));
                            if (colName.equals(detailDom.getElementsByTagName("Descr").item(0).getFirstChild().getNodeValue())) {
                                BaseLogger.log("3", null, null, detailDom.getElementsByTagName("MAILADDR").item(0).getFirstChild().getNodeValue());
                                columnLableData = String.valueOf(columnLableData) + "<COL_LABLE>" + detailDom.getElementsByTagName("MAILADDR").item(0).getFirstChild().getNodeValue() + "</COL_LABLE>";
                                columnLableData = String.valueOf(columnLableData) + "<COL_NAME>" + colName + "</COL_NAME>";
                                columnLableData = String.valueOf(columnLableData) + "<ENTIEY_TYPE>" + entityType + "</ENTIEY_TYPE>";
                                break;
                            }
                            ++nodeCnter;
                        }
                    }
                } else {
                    columnLableData = String.valueOf(columnLableData) + "<COL_LABLE>" + colName + "</COL_LABLE>";
                    columnLableData = String.valueOf(columnLableData) + "<COL_NAME></COL_NAME>";
                }
                columnLableData = String.valueOf(columnLableData) + "</ADDRESS_FLD>";
                ++i;
            }
        }
        return columnLableData;
    }

    private String getHtmlBodyText(String bodyTextData, String xmlColsData) throws Exception {
        E12GenericUtility genericUtility = new E12GenericUtility();
        Document xmlColsDom = genericUtility.parseString(xmlColsData);
        Node detailNode = null;
        NodeList detailNodeList = null;
        String colName = "";
        Document detailDom = null;
        int count = 1;
        if (bodyTextData != null) {
            String findStr = "&lt;Detail1.";
            String colFullName = "";
            boolean found = false;
            int currentIndex = 0;
            int nextSearchIndex = 0;
            while (bodyTextData.indexOf(findStr, nextSearchIndex) != -1) {
                BaseLogger.log("3", null, null, nextSearchIndex);
                currentIndex = bodyTextData.indexOf(findStr, nextSearchIndex);
                String firstPart = bodyTextData.substring(0, currentIndex);
                String lastPart = bodyTextData.substring(currentIndex, bodyTextData.length());
                colFullName = lastPart.substring(0, lastPart.indexOf("&gt;") + 4);
                BaseLogger.log("3", null, null, "colFullName:" + colFullName);
                colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf("&gt;"));
                BaseLogger.log("3", null, null, "colName:" + colName);
                detailNodeList = xmlColsDom.getElementsByTagName("DETAIL");
                found = false;
                int nodeCnter = 0;
                while (nodeCnter < detailNodeList.getLength()) {
                    detailNode = detailNodeList.item(nodeCnter);
                    detailDom = genericUtility.parseString(genericUtility.serializeDom(detailNode));
                    if (colName.equals(detailDom.getElementsByTagName("Descr").item(0).getFirstChild().getNodeValue())) {
                        String htmlText = "<span type=\"text\" name= \"dynamicTextBox\" class=\"dynamicTextBox vN\" contenteditable=\"false\" style=\"display:inline-block\" isDiv=\"true\" id=\"bodyDyanInpCol" + count + "\" colTagValueName=\"" + colFullName.replaceFirst("&lt;", "<").replace("&gt;", ">") + "\" readonly onFocus=\"gotFocus(this);\" onBlur=\"blurDynaTextBox(this);\" onkeyup=\"editableSpan(this);\" > [" + detailDom.getElementsByTagName("MAILADDR").item(0).getFirstChild().getNodeValue() + "] </span>";
                        bodyTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, htmlText);
                        nextSearchIndex = currentIndex + htmlText.length();
                        BaseLogger.log("3", null, null, bodyTextData);
                        ++count;
                        found = true;
                        break;
                    }
                    ++nodeCnter;
                }
                if (found) continue;
                String htmlText = "";
                bodyTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, htmlText);
                nextSearchIndex = currentIndex + htmlText.length();
                BaseLogger.log("3", null, null, bodyTextData);
            }
        }
        this.lastDyanInpCol = count;
        return bodyTextData;
    }

    private String getHtmlSubText(String subTextData, String xmlColsData) throws Exception {
        E12GenericUtility genericUtility = new E12GenericUtility();
        Document xmlColsDom = genericUtility.parseString(xmlColsData);
        Node detailNode = null;
        NodeList detailNodeList = null;
        String colName = "";
        Document detailDom = null;
        int count = 1;
        if (subTextData != null) {
            String findStr = "<Detail1.";
            String colFullName = "";
            boolean found = false;
            int currentIndex = 0;
            int nextSearchIndex = 0;
            while (subTextData.indexOf(findStr, nextSearchIndex) != -1) {
                BaseLogger.log("3", null, null, nextSearchIndex);
                currentIndex = subTextData.indexOf(findStr, nextSearchIndex);
                String firstPart = subTextData.substring(0, currentIndex);
                String lastPart = subTextData.substring(currentIndex, subTextData.length());
                colFullName = lastPart.substring(0, lastPart.indexOf(">") + 1);
                BaseLogger.log("3", null, null, "colFullName:" + colFullName);
                colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf(">"));
                BaseLogger.log("3", null, null, "colName:" + colName);
                detailNodeList = xmlColsDom.getElementsByTagName("DETAIL");
                found = false;
                int nodeCnter = 0;
                while (nodeCnter < detailNodeList.getLength()) {
                    detailNode = detailNodeList.item(nodeCnter);
                    detailDom = genericUtility.parseString(genericUtility.serializeDom(detailNode));
                    if (colName.equals(detailDom.getElementsByTagName("Descr").item(0).getFirstChild().getNodeValue())) {
                        String htmlText = "<span type=\"text\" name= \"dynamicSubBox\" class=\"dynamicSubBox vN\" contenteditable=\"false\" style=\"display:inline-block\" isDiv=\"true\" id=\"bodyDyanSubInpCol" + count + "\" colTagValueName=\"" + colFullName + "\" readonly onFocus=\"gotFocus(this);\" onBlur=\"blurDynaTextBox(this);\" onkeyup=\"editableSpan(this);\" > [" + detailDom.getElementsByTagName("MAILADDR").item(0).getFirstChild().getNodeValue() + "] </span>";
                        subTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, htmlText);
                        nextSearchIndex = currentIndex + htmlText.length();
                        BaseLogger.log("3", null, null, subTextData);
                        ++count;
                        found = true;
                        break;
                    }
                    ++nodeCnter;
                }
                if (found) continue;
                String htmlText = "";
                subTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, htmlText);
                nextSearchIndex = currentIndex + htmlText.length();
                BaseLogger.log("3", null, null, subTextData);
            }
        }
        this.lastDyanSubInpCol = count;
        return subTextData;
    }

    public String readFile(String fileName) throws Exception {
        StringBuffer fileContent = new StringBuffer();
        BufferedReader bfr = null;
        try {
            FileInputStream fMainIn = new FileInputStream(fileName);
            bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, CommonConstants.ENCODING));
            String outTempStr = null;
            while ((outTempStr = bfr.readLine()) != null) {
                fileContent.append(outTempStr);
            }
            bfr.close();
            bfr = null;
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :[" + fileName + "]");
                e.printStackTrace();
            }
        }
        return fileContent.toString();
    }

    private TreeMap<Integer, TreeMap<Integer, I18NMetadataObject>> parseMetadataObjects(Document doc) {
        TreeMap<Integer, TreeMap<Integer, I18NMetadataObject>> yTextMap = new TreeMap<Integer, TreeMap<Integer, I18NMetadataObject>>();
        yTextMap = new TreeMap();
        NodeList txtList = doc.getElementsByTagName("TextObject");
        int i = 0;
        while (i < txtList.getLength()) {
            Node eachText = txtList.item(i);
            I18NMetadataObject textObject = this.parseMetaObjectNode(eachText);
            textObject.setMetaType("Text");
            Integer xCordKey = textObject.getIntXCord();
            Integer yCordKey = textObject.getIntYCord();
            textObject.setYCord(yCordKey);
            TreeMap<Integer, I18NMetadataObject> xTxtMap = yTextMap.get(yCordKey);
            if (xTxtMap == null) {
                xTxtMap = new TreeMap();
                xTxtMap.put(xCordKey, textObject);
                yTextMap.put(yCordKey, xTxtMap);
            } else {
                while (true) {
                    if (!xTxtMap.containsKey(xCordKey)) break;
                    xCordKey = xCordKey + 1;
                }
                xTxtMap.put(xCordKey, textObject);
                yTextMap.put(yCordKey, xTxtMap);
            }
            ++i;
        }
        NodeList colList = doc.getElementsByTagName("ColumnObject");
        int i2 = 0;
        while (i2 < colList.getLength()) {
            Node eachText = colList.item(i2);
            I18NMetadataObject colObject = this.parseMetaObjectNode(eachText);
            colObject.setMetaType("Column");
            Integer xCordKey = colObject.getIntXCord();
            Integer yCordKey = colObject.getIntYCord();
            colObject.setYCord(yCordKey);
            TreeMap<Integer, I18NMetadataObject> xTxtMap = yTextMap.get(yCordKey);
            if (xTxtMap == null) {
                xTxtMap = new TreeMap();
                xTxtMap.put(xCordKey, colObject);
                yTextMap.put(yCordKey, xTxtMap);
            } else {
                while (true) {
                    if (!xTxtMap.containsKey(xCordKey)) break;
                    xCordKey = xCordKey + 1;
                }
                xTxtMap.put(xCordKey, colObject);
                yTextMap.put(yCordKey, xTxtMap);
            }
            ++i2;
        }
        return yTextMap;
    }

    private I18NMetadataObject parseMetaObjectNode(Node eachText) {
        I18NMetadataObject metaObj = new I18NMetadataObject();
        NodeList eachTextDetail = eachText.getChildNodes();
        int j = 0;
        while (j < eachTextDetail.getLength()) {
            if (!eachTextDetail.item(j).getNodeName().equalsIgnoreCase("#text") && eachTextDetail.item(j).getFirstChild() != null) {
                Node childNode = eachTextDetail.item(j);
                String sub_nodes_name = childNode.getNodeName();
                if ("name".equalsIgnoreCase(sub_nodes_name)) {
                    String colName = childNode.getFirstChild().getNodeValue();
                    metaObj.setName(colName);
                } else if ("text".equalsIgnoreCase(sub_nodes_name)) {
                    String text = childNode.getFirstChild().getNodeValue();
                    metaObj.setText(text);
                }
            }
            ++j;
        }
        return metaObj;
    }

    private String getTransID(String windowName, Connection conn) throws ITMException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String selSql = "";
        String tranId = "";
        String tranSer = "";
        String keyString = "";
        String keyCol = "";
        String xmlValues = "";
        try {
            try {
                selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
                pstmt = conn.prepareStatement(selSql);
                pstmt.setString(1, windowName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    keyString = rs.getString("KEY_STRING");
                    keyCol = rs.getString("TRAN_ID_COL");
                    tranSer = rs.getString("REF_SER");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log("3", null, null, "keyString :" + keyString);
                BaseLogger.log("3", null, null, "keyCol :" + keyCol);
                BaseLogger.log("3", null, null, "tranSer :" + tranSer);
                xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
                xmlValues = String.valueOf(xmlValues) + "<Header></Header>";
                xmlValues = String.valueOf(xmlValues) + "<Detail1>";
                xmlValues = String.valueOf(xmlValues) + "<tran_id></tran_id>";
                xmlValues = String.valueOf(xmlValues) + "</Detail1></Root>";
                BaseLogger.log("3", null, null, "xmlValues  :[" + xmlValues + "]");
                TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
                tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
                BaseLogger.log("3", null, null, "tranId :" + tranId);
            }
            catch (SQLException ex) {
                BaseLogger.log("0", null, null, "Exception ::" + selSql + ex.getMessage() + ":");
                ex.printStackTrace();
                throw new ITMException(ex);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception ::" + e.getMessage() + ":");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
        }
        return tranId;
    }

    private Connection getConnection(UserInfoBean userInfo) throws ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        String transDB = userInfo.getTransDB();
        try {
            connDriver = new ConnDriver();
            if (userInfo != null) {
                transDB = userInfo.getTransDB();
            }
            conn = connDriver.getConnectDB(transDB);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            BaseLogger.log("3", null, null, "getInitialContext");
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :TransactionEmailTempltEJB :getInitialContext :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionEmailTempltEJB :getInitialContext :==>");
            throw new ITMException(e);
        }
        return ctx;
    }

    @Override
    public String getObjLinks(String objName, UserInfoBean userInfo, String formNo) throws ITMException {
        String linkInfoStr = "";
        try {
            LinkControllerEJB linkControllerEJB = new LinkControllerEJB();
            linkInfoStr = linkControllerEJB.getLinkInfo(objName, formNo, userInfo);
            BaseLogger.log("3", userInfo, null, "linkInfoStr" + linkInfoStr);
            linkControllerEJB = null;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return linkInfoStr;
    }

    private String getAttachmentPath(String objName, String attachObjLink, UserInfoBean userInfo, Document currentPkTranDom, String tranId, String attachType) throws ITMException {
        BaseLogger.log("3", userInfo, null, "Inside getAttachmentPath");
        String attachmentPath = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = this.getConnection(userInfo);
        try {
            try {
                String selSql = "";
                String[] attachFormField = attachObjLink.split(":");
                String formNo = attachFormField[0];
                String formField = attachFormField[1];
                String reportFileName = "";
                Object linkArgsArr = null;
                Object detailNodeList = null;
                Object detailNode = null;
                Object detailDom = null;
                String linkAgrs = "";
                String linkTitle = "";
                selSql = "SELECT TARGET_OBJ_NAME,LINK_ARG,LINK_TITLE FROM OBJ_LINKS WHERE OBJ_NAME = ? AND FORM_NO = ? AND FIELD_NAME = ? AND LINK_TYPE = ?";
                pstmt = conn.prepareStatement(selSql);
                pstmt.setString(1, objName);
                pstmt.setString(2, formNo);
                pstmt.setString(3, formField);
                pstmt.setString(4, "5");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    reportFileName = this.checkNull(rs.getString("TARGET_OBJ_NAME"));
                    linkAgrs = this.checkNull(rs.getString("LINK_ARG"));
                    linkTitle = this.checkNull(rs.getString("LINK_TITLE"));
                }
                String outputFilename = String.valueOf(objName) + "_" + tranId + "_" + linkTitle;
                XSDParser xsdParser = new XSDParser(reportFileName, userInfo);
                BaseLogger.log("3", userInfo, null, "xsdParser:: [" + xsdParser + "]");
                String argXmlString = xsdParser.getArgumentMetaDataString();
                BaseLogger.log("3", userInfo, null, "xsdParser.getArgumentMetaDataString():: [" + argXmlString + "]");
                String reportArgString = this.genReportArgStr(reportFileName, attachType, argXmlString, currentPkTranDom, linkAgrs, userInfo);
                BaseLogger.log("3", userInfo, null, "ReportArgString[" + reportArgString + "]");
                JasperReportGenerator jasperReport = new JasperReportGenerator(userInfo);
                TreeMap argMap = jasperReport.createArgMap(reportArgString);
                BaseLogger.log("3", userInfo, null, "TreeMap:::->" + argMap);
                jasperReport.createReport(reportFileName, argMap, xsdParser, "EmailAttachments", outputFilename);
                BaseLogger.log("3", userInfo, null, "b attachmentPath TransactionEmailTempltEJB:::->" + attachmentPath);
                attachmentPath = String.valueOf(ResourceConstants.REPORTDESTINATION) + File.separator + "EmailAttachments" + File.separator + outputFilename + "." + attachType;
                BaseLogger.log("3", userInfo, null, "a attachmentPath TransactionEmailTempltEJB:::->" + attachmentPath);
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        BaseLogger.log("3", userInfo, null, "attachmentPath TransactionEmailTempltEJB:::->" + attachmentPath);
        return attachmentPath;
    }

    private String genReportArgStr(String reportFileName, String attachType, String xsdString, Document transDom, String linkAgrs, UserInfoBean userInfo) throws Exception {
        StringBuffer reportArgString = new StringBuffer();
        try {
            reportArgString.append("<Arguments>");
            reportArgString.append("<Argument id=\"x_path\" name=\"x_path\"><argType>java.lang.String</argType><value>/DocumentRoot/" + reportFileName + "</value></Argument>");
            reportArgString.append("<Argument id=\"design_source\" name=\"design_source\"><argType>java.lang.String</argType><value>" + reportFileName + ".jrxml</value></Argument>");
            reportArgString.append("<Argument id=\"data_source\" name=\"data_source\"><argType>java.lang.String</argType><value>SQL</value></Argument>");
            reportArgString.append("<Argument id=\"bind_type\" name=\"bind_type\"><argType>java.lang.Integer</argType><value>0</value></Argument>");
            reportArgString.append("<Argument id=\"report_type\" name=\"report_type\"><argType>java.lang.String</argType><value>JASPER</value></Argument>");
            reportArgString.append("<Argument id=\"report_save_type\" name=\"report_save_type\"><argType>java.lang.String</argType><value>" + attachType.toUpperCase() + "</value></Argument>");
            if (xsdString != null && xsdString.length() > 0) {
                HashMap<String, String> formValueMap = this.getFormValueMap(transDom);
                HashMap<String, String> linkArgValueMap = this.getLinkArgValueMap(linkAgrs, formValueMap);
                HashMap<String, String> userInfoMap = this.getUserInfoMap(userInfo);
                Document doc = this.genericUtility.parseString(xsdString);
                NodeList argNodeList = doc.getElementsByTagName("argument");
                if (argNodeList != null) {
                    int argCnt = 0;
                    while (argCnt <= argNodeList.getLength()) {
                        Node argNode = argNodeList.item(argCnt);
                        if (argNode != null) {
                            String argName = "";
                            String argType = "";
                            String argValue = "";
                            Node attribute = null;
                            attribute = argNode.getAttributes().getNamedItem("name");
                            if (attribute != null && attribute.getFirstChild() != null) {
                                argName = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("type")) != null && attribute.getFirstChild() != null) {
                                argType = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("value")) != null && attribute.getFirstChild() != null) {
                                argValue = attribute.getFirstChild().getNodeValue();
                            }
                            if (linkArgValueMap != null && linkArgValueMap.containsKey(argName)) {
                                argValue = linkArgValueMap.get(argName);
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            } else if (userInfoMap != null && userInfoMap.containsKey(argValue.toLowerCase())) {
                                argValue = userInfoMap.get(argValue.toLowerCase());
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            }
                        }
                        ++argCnt;
                    }
                }
            }
            reportArgString.append("</Arguments>");
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :: genReportArgStr : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return reportArgString.toString();
    }

    private HashMap<String, String> getFormValueMap(Document transactionDom) throws Exception {
        HashMap<String, String> formValueMap = new HashMap<String, String>();
        if (transactionDom != null) {
            NodeList detailNodeList = transactionDom.getElementsByTagName("Detail1");
            Node parentNode = detailNodeList.item(0);
            NodeList childNodeList = parentNode.getChildNodes();
            int childNodeCtr = 0;
            while (childNodeCtr < childNodeList.getLength()) {
                Node childNode = childNodeList.item(childNodeCtr);
                if (childNode != null && childNode.getNodeType() == 1) {
                    String nodeName = childNode.getNodeName();
                    String nodeValue = "";
                    if (childNode.getFirstChild() != null) {
                        nodeValue = childNode.getFirstChild().getNodeValue();
                    }
                    formValueMap.put(nodeName, nodeValue);
                }
                ++childNodeCtr;
            }
        }
        return formValueMap;
    }

    private HashMap<String, String> getLinkArgValueMap(String linkAgrs, HashMap<String, String> formValueMap) throws Exception {
        HashMap<String, String> linkArgValueMap = new HashMap<String, String>();
        if (linkAgrs.length() > 0) {
            String[] linkArgsArr = linkAgrs.split(",");
            int argCnt = 0;
            while (argCnt < linkArgsArr.length) {
                String arg = linkArgsArr[argCnt];
                String[] argNameType = arg.split("\\.");
                if (argNameType != null) {
                    String fieldName = argNameType[0];
                    String argName = argNameType[1].split(":")[1];
                    String argValue = fieldName;
                    if (formValueMap != null && formValueMap.containsKey(fieldName)) {
                        argValue = formValueMap.get(fieldName);
                    }
                    linkArgValueMap.put(argName, argValue);
                }
                ++argCnt;
            }
        }
        return linkArgValueMap;
    }

    private HashMap<String, String> getUserInfoMap(UserInfoBean userInfo) {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        try {
            if (userInfo != null) {
                String user = userInfo.getLoginCode();
                String entityCode = userInfo.getEntityCode();
                String profileId = userInfo.getProfileId();
                String empCode = userInfo.getEmpCode();
                String reportTo = userInfo.getReportTo();
                String deptCode = userInfo.getDeptCode();
                String userLev = userInfo.getUserLevel();
                String userType = userInfo.getUserType();
                String loginSite = userInfo.getSiteCode();
                if (entityCode == null) {
                    entityCode = "";
                }
                if (user == null) {
                    user = "";
                }
                userInfoMap.put("login_site", loginSite);
                userInfoMap.put("login_code", user);
                userInfoMap.put("entity_code", entityCode);
                userInfoMap.put("profile_id", profileId);
                userInfoMap.put("report_to", reportTo);
                userInfoMap.put("dept_code", deptCode);
                userInfoMap.put("user_lev", userLev);
                userInfoMap.put("user_type", userType);
                userInfoMap.put("emp_code", empCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userInfoMap;
    }
}

