/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.SignManagerEJB;
import ibase.wrkflw.SignManagerRemote;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class ITMSignatureServlet
extends ITMAuthenticateServlet {
    protected InitialContext ctx = null;
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    public String objName = "";
    public int noOfForms = -1;
    public UserInfoBean userInfo = null;
    SignManagerEJB signManager = null;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String retXml = "";
        Object outputStream = null;
        String responseStr = "";
        try {
            if (Boolean.valueOf(this.authenticate(request)).booleanValue()) {
                HttpSession session = request.getSession();
                BaseLogger.log("3", this.userInfo, null, "\n\nsession.getId()............... :" + session.getId());
                String action = request.getParameter("ACTION");
                String user = request.getParameter("USER");
                if (action.equals("SIGN_ACTION")) {
                    String objName = request.getParameter("OBJ_NAME");
                    String refSer = request.getParameter("REF_SER");
                    int lineNo = Integer.parseInt(request.getParameter("LINE_NO"));
                    String refID = request.getParameter("REF_ID");
                    String signDate = request.getParameter("SIGN_DATE");
                    String createDate = request.getParameter("CREATE_DATE");
                    String operand = request.getParameter("OPERAND");
                    String userId = request.getParameter("USER");
                    String password = request.getParameter("PASSWORD");
                    String site_code = request.getParameter("SITE_CODE");
                    BaseLogger.log("3", this.userInfo, null, "[SIGN_ACTION]Boolean.valueOf(request.getParameter(ISVIEWALL)).booleanValue(); :[" + Boolean.valueOf(request.getParameter("ISVIEWALL")) + "]");
                    boolean isViewAll = Boolean.valueOf(request.getParameter("ISVIEWALL"));
                    responseStr = this.getSignXmlString(objName, refSer, lineNo, refID, false, signDate, createDate, operand, isViewAll, session, userId, password, site_code);
                } else if (action.equals("REF_SER")) {
                    responseStr = this.getRefSer(user);
                } else if (action.equals("SIGN_DETAIL_ACTION")) {
                    String objName = request.getParameter("OBJ_NAME");
                    String refSer = request.getParameter("REF_SER");
                    int lineNo = Integer.parseInt(request.getParameter("LINE_NO"));
                    String refID = request.getParameter("REF_ID");
                    String signDate = request.getParameter("SIGN_DATE");
                    String createDate = request.getParameter("CREATE_DATE");
                    String operand = request.getParameter("OPERAND");
                    BaseLogger.log("3", this.userInfo, null, "[SIGN_DETAIL_ACTION]Boolean.valueOf(request.getParameter(ISVIEWALL)).booleanValue(); :[" + Boolean.valueOf(request.getParameter("ISVIEWALL")) + "]");
                    boolean isViewAll = Boolean.valueOf(request.getParameter("ISVIEWALL"));
                    String userId = request.getParameter("USER");
                    String password = request.getParameter("PASSWORD");
                    String site_code = request.getParameter("SITE_CODE");
                    BaseLogger.log("3", this.userInfo, null, "Forwarding to /ibase/webitm/jsp/SignatureDetail.jsp");
                    RequestDispatcher reqDis = this.servletContext.getRequestDispatcher("/webitm/jsp/SignatureDetail.jsp");
                    reqDis.forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                BaseLogger.log("3", this.userInfo, null, "XXXXXX[ITMSignatureServlet] responseStr from Server ........:XXXXXX\n" + responseStr);
                CommonConstants.setIBASEHOME();
                BaseLogger.log("3", this.userInfo, null, "CONTENT_ENCODING :" + CommonConstants.CONTENT_ENCODING);
                response.setBufferSize(1024);
                if (CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip")) {
                    response.setHeader("Content-Encoding", "gzip");
                    GZIPOutputStream gzOutStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
                    gzOutStream.write(responseStr.getBytes());
                    gzOutStream.flush();
                    gzOutStream.close();
                } else {
                    response.setHeader("Content-Encoding", "");
                    ServletOutputStream outStream = response.getOutputStream();
                    outStream.write(responseStr.getBytes());
                    outStream.flush();
                    outStream.close();
                }
            }
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                itme.printStackTrace(new PrintStream(baos));
                response.setContentLength(baos.toString().length());
                writer.println(baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                String errMsg = "";
                response.setContentLength(baos.toString().length());
                writer.println("ERR_MSG :" + errMsg + "\n" + baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String getSignXmlString(String objName, String refSer, int lineNo, String refID, boolean isSelTransInfo, String signDate, String createDate, String operand, boolean isViewAll, HttpSession session, String userId, String password, String site_code) throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "******************** Getting signXmlString *********************");
        String retXMLStr = "";
        String userCode = "";
        String siteCode = "";
        try {
            UserInfoBean userInfo = (UserInfoBean)session.getAttribute("USER_INFO");
            if (userInfo != null) {
                userId = userInfo.getLoginCode();
                siteCode = userInfo.getSiteCode();
            }
            if (this.ctx == null) {
                this.ctx = this.getInitialContext();
            }
            retXMLStr = this.getSignManager().getSignXMLString(userId, siteCode, objName, refSer, refID, lineNo, isSelTransInfo, isViewAll, signDate, createDate, operand, userInfo.toString(), null);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :ITMSignatureServlet :getSignXMLString :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMSignatureServlet :getSignXMLString :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    private String getRefSer(String user) throws ITMException {
        Object refSerInfoList = null;
        String refSerXML = null;
        try {
            BaseLogger.log("3", this.userInfo, null, "******************** ITMSignatureServlet::Getting refSer *********************");
            if (this.ctx == null) {
                this.ctx = this.getInitialContext();
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            refSerXML = dbAccess.getRefSerXMLStr(user);
            dbAccess = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :ITMSignatureServlet :getRefSer :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMSignatureServlet :getRefSer :==>");
            throw new ITMException(e);
        }
        return refSerXML;
    }

    public String getSignDetailData(String objName, String refSer, int lineNo, String refID, String signDate, String createDate, String operand, boolean isViewAll, HttpSession session, String user, String password, String site_code) throws ITMException {
        String xslFileName = null;
        String retString = null;
        String data = null;
        try {
            BaseLogger.log("3", this.userInfo, null, "*************** Getting Sign detail data ****************");
            E12GenericUtility genericUtility = new E12GenericUtility();
            BaseLogger.log("3", this.userInfo, null, "ITMSignatureServlet::getSignDetailData::xslFileName :[" + xslFileName + "]");
            data = this.getSignXmlString(objName, refSer, lineNo, refID, true, signDate, createDate, operand, isViewAll, session, user, password, site_code);
            BaseLogger.log("3", this.userInfo, null, "data.length() [" + data + "]");
            Document dom = genericUtility.parseString(data);
            String roleCode = "";
            xslFileName = this.getSignManager().getUserXSLFileName(refSer, refID, lineNo, roleCode, null);
            String xslString = genericUtility.readFile(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "xsl" + File.separator + xslFileName);
            BaseLogger.log("3", this.userInfo, null, "xslString.length() [" + xslString + "]");
            if (xslString != null && xslString.length() > 0) {
                System.setProperty("javax.xml.transformer.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(new StreamSource(new ByteArrayInputStream(xslString.getBytes())));
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                transformer.transform(new DOMSource(dom), new StreamResult(bos));
                retString = bos.toString();
            } else {
                BaseLogger.log("3", this.userInfo, null, "[SignBean]System defined xsl file not found -- returning the same dom as xml string ......");
                retString = genericUtility.serializeDom(dom);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", this.userInfo, null, "Exception : SignBean :applyXSL :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning Transformed String ...........");
        return retString;
    }

    private SignManagerRemote getSignManager() throws ITMException {
        try {
            if (this.signManager == null) {
                if (this.ctx == null) {
                    this.ctx = this.getInitialContext();
                }
                this.signManager = new SignManagerEJB();
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :SignBean :getDBAccessRemote :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return this.signManager;
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :RequestHandlerServlet :getInitialContext :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :RequestHandlerServlet :getInitialContext :==>");
            throw new ITMException(e);
        }
        return ctx;
    }
}

