/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import javax.servlet.http.HttpSession;

public class ITMTransactionEditorBean {
    private UserInfoBean userInfo = null;
    private HttpSession session = null;

    public ITMTransactionEditorBean() {
    }

    public ITMTransactionEditorBean(HttpSession session) {
        try {
            this.session = session;
            this.userInfo = (UserInfoBean)this.session.getAttribute("USER_INFO");
            this.setUserInfo(this.userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public String getObjType(String objName, String transDB) {
        String objType = "";
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            objType = dbAccess.getObjType(objName, transDB);
            BaseLogger.log("3", this.userInfo, null, "OBJ_TYPE : [" + objType + "]");
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception - getObjType : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return objType;
    }

    public String getDocTransactionLinkDocId(String objName, String tranId, UserInfoBean userInfo) {
        String docId = "";
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            docId = dbAccess.getDocTransactionLinkDocId(objName, tranId, userInfo);
            BaseLogger.log("3", userInfo, null, "DOC_CONTENTS_DTL : [" + docId + "]");
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception - getDocTransactionLinkDocId : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return docId;
    }

    public boolean isAttachConfig(String objName, String transDB) {
        boolean isAttachConfig = false;
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            isAttachConfig = dbAccess.isAttachConfig(objName, transDB);
            dbAccess = null;
            BaseLogger.log("3", this.userInfo, null, "isAttachConfig : [" + isAttachConfig + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception - isAttachConfig : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return isAttachConfig;
    }

    public String getObjAttachConfigDtl(String objName, String tranId, String editFlag) {
        String xmlString = "";
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            xmlString = dbAccess.getObjAttachConfigDtl(objName, tranId, this.getUserInfo(), editFlag);
            String xslFileName = this.getXSLFileName("E12Attachments.xsl");
            E12GenericUtility genericUtility = new E12GenericUtility();
            xmlString = genericUtility.transformToString(xslFileName, xmlString, String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp", "Output", ".html");
            BaseLogger.log("9", this.userInfo, null, "xmlString : [" + xmlString + "]");
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception - getObjAttachConfigDtl : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return xmlString;
    }

    private String getXSLFileName(String xslFileName) throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = null;
            defaultPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            File xslPath = new File(String.valueOf(defaultPath) + File.separator + "xsl");
            if (!xslPath.exists()) {
                xslPath.mkdir();
            }
            BaseLogger.log("3", this.userInfo, null, " xslPath [" + xslPath + "] xslFileName [" + xslFileName + "]");
            File xslFile = new File(xslPath, xslFileName);
            if (!xslFile.exists()) {
                throw new ITMException(new Exception(String.valueOf(retFileName) + " Wizard XSL file Not Found"));
            }
            retFileName = xslFile.getAbsolutePath();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception - getXSLFileName : [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return retFileName;
    }

    public boolean getRightsInfo(String objName, UserInfoBean userInfo, String editFlag) throws ITMException {
        if (userInfo != null) {
            String userLevel = userInfo.getUserLevel();
            if ("0".equalsIgnoreCase(userLevel)) {
                return true;
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            return dbAccess.objRightsCheck(objName, userInfo, editFlag);
        }
        return false;
    }
}

