/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import ibase.bi.bean.DateBean;
import ibase.bi.common.system.config.DBInfo;
import ibase.bi.ejb.session.Argument;
import ibase.bi.ejb.session.Column;
import ibase.bi.ejb.session.DBAccessEJB;
import ibase.bi.utility.BIException;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DB2XMLGenerator
extends DefaultHandler {
    boolean columnsFlag;
    TreeMap tMap = new TreeMap();
    Vector vPK = new Vector(1, 1);
    String resultFileName = null;
    static char[] symbolsArray = new char[]{'\"', '\'', '\ufffd', '\ufffd', '\ufffd', '\ufffd'};
    static String[] entityArray = new String[]{"&quot;", "&#x2018;", "&euro;", "&pound;", "&sup3;", "&sup2;"};
    ArrayList secureColList = null;
    String countStatus = null;
    String defDoc = "";
    final String FREE_HAND = "F";

    public String[] executeQuery(String SQL, String baName, ArrayList argumentList, Column[] columns, ArrayList dbNames, String profileID, int baID, String baType) throws Exception {
        Connection myCon = null;
        Statement pstmt = null;
        String[] returnArray = null;
        try {
            try {
                Object newArgumentList = null;
                if (argumentList != null) {
                    SQL = this.getUpdatedSql(SQL, argumentList);
                }
                returnArray = new String[3];
                int appMaxRows = Integer.parseInt(CommonConstants.APP_MAX_ROWS);
                boolean isUserMaxRows = false;
                int userMaxRows = Integer.parseInt(CommonConstants.USER_MAX_ROWS);
                this.countStatus = null;
                String xmlFile = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common" + File.separator + "xml" + File.separator + baName + ".xml";
                long start = System.currentTimeMillis();
                this.getSecureCols(profileID, baID, baName);
                this.parseDocument(columns);
                long end = System.currentTimeMillis();
                ConnDriver con = new ConnDriver();
                myCon = con.getConnectDB(DBInfo.getDataProfileName(baName));
                pstmt = myCon.prepareStatement(SQL);
                ResultSet rs = null;
                String temp = "";
                int dbNamesSize = dbNames.size();
                if (argumentList != null && argumentList.size() > 0) {
                    this.setArgument(argumentList, (PreparedStatement)pstmt);
                }
                int queryTimeout = Integer.parseInt(CommonConstants.QUERYEXE_TIMEOUT);
                BaseLogger.log("3", null, null, "Query time limit for final query [" + queryTimeout + "]");
                pstmt.setQueryTimeout(queryTimeout);
                long queryTimer = System.currentTimeMillis();
                rs = pstmt.executeQuery();
                BaseLogger.log("3", null, null, "Query Executed !!!!!!!!!!!  In :" + (System.currentTimeMillis() - queryTimer));
                int tMapSize = this.tMap.size();
                int vSize = this.vPK.size();
                ResultSetMetaData rsmdata = rs.getMetaData();
                if ("F".equalsIgnoreCase(baType)) {
                    this.setDefDoc(this.getMetaInfo(rsmdata));
                    dbNamesSize = rsmdata.getColumnCount();
                }
                long count = 0L;
                StringBuffer dataToBeAdded = new StringBuffer();
                BaseLogger.log("3", null, null, "Reading Record Set  ................");
                while (rs.next()) {
                    if (++count <= (long)userMaxRows) {
                        StringBuffer postBuffer = new StringBuffer();
                        int j = 1;
                        while (j <= dbNamesSize) {
                            StringBuffer recordDataBuffer = new StringBuffer();
                            String k = "F".equalsIgnoreCase(baType) ? "" : (String)dbNames.get(j - 1);
                            int metaType = rsmdata.getColumnType(j);
                            String data = null;
                            data = metaType == 91 ? "" + rs.getDate(j) : (metaType == 93 ? "" + rs.getTimestamp(j) : String.valueOf(rs.getString(j)));
                            if (data.length() <= 0 || data.equalsIgnoreCase("NULL")) {
                                recordDataBuffer.append("");
                            } else {
                                recordDataBuffer.append(data);
                            }
                            if (vSize != 0) {
                                int vIndex = 0;
                                while (vIndex < vSize) {
                                    if (j == Integer.parseInt((String)this.vPK.get(vIndex))) {
                                        temp = temp.concat(String.valueOf(recordDataBuffer.toString()) + "_");
                                    }
                                    ++vIndex;
                                }
                            } else if (vSize == 0) {
                                temp = "";
                            }
                            if ("F".equalsIgnoreCase(baType)) {
                                postBuffer.append("<" + rsmdata.getColumnName(j) + "><![CDATA[" + recordDataBuffer.toString() + "]]></" + rsmdata.getColumnName(j) + ">" + "\n");
                            } else if (this.tMap.get(k) == null && !"null".equalsIgnoreCase((String)this.tMap.get(k))) {
                                if (columns[j - 1] != null) {
                                    postBuffer.append("<" + columns[j - 1].getLogicalName() + "><![CDATA[" + recordDataBuffer.toString() + "]]></" + columns[j - 1].getLogicalName() + ">" + "\n");
                                } else {
                                    postBuffer.append("<" + rsmdata.getColumnName(j) + "><![CDATA[" + recordDataBuffer.toString() + "]]></" + rsmdata.getColumnName(j) + ">" + "\n");
                                }
                            } else {
                                postBuffer.append("<" + (String)this.tMap.get(k) + "><![CDATA[" + recordDataBuffer.toString() + "]]></" + (String)this.tMap.get(k) + ">" + "\n");
                            }
                            ++j;
                        }
                        postBuffer.append("</Detail>\n");
                        StringBuffer preBuffer = new StringBuffer();
                        if (temp.endsWith("_")) {
                            temp = temp.substring(0, temp.length() - 1);
                        }
                        temp = "";
                        preBuffer.append("<Detail id='" + temp.substring(0, temp.indexOf(" ") != -1 ? temp.indexOf(" ") : temp.length()) + "'>" + "\n");
                        temp = "";
                        dataToBeAdded.append(preBuffer.toString()).append(postBuffer.toString());
                        continue;
                    }
                    isUserMaxRows = true;
                    break;
                }
                if (isUserMaxRows) {
                    if (count >= (long)appMaxRows) {
                        dataToBeAdded = dataToBeAdded.delete(0, dataToBeAdded.length());
                        this.countStatus = "APPLICATIONOVERFLOW";
                    } else {
                        this.countStatus = "OVERFLOW";
                    }
                } else {
                    this.countStatus = "NORMAL";
                }
                pstmt.close();
                pstmt = null;
                myCon.commit();
                myCon.close();
                myCon = null;
                this.vPK.clear();
                this.tMap.clear();
                this.writeToFile(dataToBeAdded.toString(), this.countStatus);
                returnArray[0] = this.getResultFileName();
                returnArray[1] = new Long(count).toString();
                returnArray[2] = this.countStatus;
            }
            catch (Exception e) {
                BIException.setErrorCode(0);
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (myCon != null) {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                myCon.close();
                myCon = null;
            }
        }
        return returnArray;
    }

    private void getSecureCols(String profileID, int baID, String baName) throws Exception {
        this.secureColList = new ArrayList();
        AppConnectParm appConnect = new AppConnectParm("bi");
        Properties props = appConnect.getProperty();
        InitialContext ctx = new InitialContext(props);
        DBAccessEJB dBAccessEJB = new DBAccessEJB();
        String secureColXml = dBAccessEJB.getSecureColumns(profileID, baID, baName);
        ByteArrayInputStream bais = new ByteArrayInputStream(secureColXml.getBytes());
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = documentBuilder.parse(new InputSource(bais));
        NodeList nl = doc.getElementsByTagName("COL");
        int ctr = 0;
        while (ctr < nl.getLength()) {
            String col = nl.item(ctr).getFirstChild().getNodeValue();
            this.secureColList.add(col);
            ++ctr;
        }
    }

    private void writeToFile(String dataToBeAdded, String countStatus) throws Exception {
        BaseLogger.log("3", null, null, "Generating XML.........");
        this.setResultFileName();
        FileOutputStream fout = new FileOutputStream(this.getResultFileName());
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, CommonConstants.ENCODING));
        bw.write("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
        bw.write("<DocumentRoot>\n");
        bw.write("<description>Datawindow Root</description>\n<group0><description>Group0 description</description>\n");
        bw.write("<Header0>\n");
        bw.write("<Description>");
        bw.write(countStatus);
        bw.write("</Description>\n");
        if (dataToBeAdded.length() > 0) {
            bw.write(dataToBeAdded);
        }
        bw.flush();
        bw.write("</Header0>\n");
        bw.write("</group0>\n");
        bw.write("</DocumentRoot>\n");
        bw.flush();
        BaseLogger.log("3", null, null, "XML Generated !!!!!!!!!!!!");
    }

    private void setResultFileName() throws Exception {
        String file_Name = "DataSource_";
        file_Name = String.valueOf(System.currentTimeMillis());
        String xmlDirName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator;
        File dir = new File(xmlDirName);
        BaseLogger.log("3", null, null, "xmldatafiles folder exists  :" + dir.exists());
        if (!dir.exists()) {
            dir.mkdirs();
            BaseLogger.log("3", null, null, "xmldatafiles folder created..." + dir.getAbsolutePath());
        }
        String fileName = String.valueOf(xmlDirName) + file_Name + ".xml";
        String prefix = file_Name;
        String suffix = ".xml";
        File tempDirectory = new File(String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles");
        File tempFile = File.createTempFile(prefix, suffix, tempDirectory);
        this.resultFileName = fileName = tempFile.getAbsolutePath();
    }

    private String getResultFileName() throws Exception {
        return this.resultFileName;
    }

    private void setArgument(ArrayList argumentList, PreparedStatement pstmt) throws Exception {
        DateBean dtbean = new DateBean();
        int cnt = 1;
        BaseLogger.log("3", null, null, "Setting Run Time Parameters..........");
        BaseLogger.log("3", null, null, "argumentList-->" + argumentList);
        BaseLogger.log("3", null, null, "Datatype :\tArgorder\tArgvalue");
        int ctrOrder = 0;
        while (ctrOrder < argumentList.size()) {
            String argValue;
            int valCount;
            ArrayList argValueList = ((Argument)argumentList.get(ctrOrder)).getArgValue();
            String dataType = ((Argument)argumentList.get(ctrOrder)).getDataType();
            String displayPattern = ((Argument)argumentList.get(ctrOrder)).getDisplayPattern();
            String dbPattern = ((Argument)argumentList.get(ctrOrder)).getDBPattern();
            if (dataType.equalsIgnoreCase("java.lang.String") || dataType.equalsIgnoreCase("String")) {
                valCount = 0;
                while (valCount < argValueList.size()) {
                    argValue = (String)argValueList.get(valCount);
                    BaseLogger.log("3", null, null, " argValue11 [" + argValue + "]");
                    if (argValue == null) {
                        argValue = "";
                    }
                    if (argValue.startsWith("'")) {
                        argValue = argValue.substring(1, argValue.length());
                    }
                    if (argValue.endsWith("'")) {
                        argValue = argValue.substring(0, argValue.length() - 1);
                    }
                    if (dbPattern != null && !dbPattern.equalsIgnoreCase("null")) {
                        BaseLogger.log("3", null, null, "displayPattern [" + displayPattern + "], dbPattern [" + dbPattern + "]");
                        argValue = dtbean.convertPattern(displayPattern, dbPattern, argValue);
                    }
                    BaseLogger.log("3", null, null, String.valueOf(dataType) + "\t" + cnt + "\t" + argValue);
                    pstmt.setString(cnt, argValue);
                    ++cnt;
                    ++valCount;
                }
            } else if (dataType.equalsIgnoreCase("Double") || dataType.equalsIgnoreCase("java.lang.Double") || dataType.equalsIgnoreCase("java.lang.Float") || dataType.equalsIgnoreCase("Float") || dataType.equalsIgnoreCase("BigDecimal") || dataType.equalsIgnoreCase("java.math.BigDecimal") || dataType.equalsIgnoreCase("BigInteger") || dataType.equalsIgnoreCase("java.math.BigInteger")) {
                valCount = 0;
                while (valCount < argValueList.size()) {
                    argValue = (String)argValueList.get(valCount);
                    if (dbPattern != null && !dbPattern.equalsIgnoreCase("null")) {
                        BaseLogger.log("3", null, null, "displayPattern [" + displayPattern + "], dbPattern [" + dbPattern + "]");
                        argValue = dtbean.convertPattern(displayPattern, dbPattern, argValue);
                    }
                    BaseLogger.log("3", null, null, String.valueOf(dataType) + "\t" + cnt + "\t" + argValue);
                    pstmt.setDouble(cnt, Double.parseDouble(argValue));
                    ++cnt;
                    ++valCount;
                }
            } else if (dataType.equalsIgnoreCase("Date") || dataType.equalsIgnoreCase("java.lang.Date") || dataType.equalsIgnoreCase("java.sql.Date") || dataType.equalsIgnoreCase("java.sql.Timestamp") || dataType.equalsIgnoreCase("Timestamp")) {
                valCount = 0;
                while (valCount < argValueList.size()) {
                    argValue = (String)argValueList.get(valCount);
                    if (argValue.startsWith("'")) {
                        argValue = argValue.substring(1, argValue.length());
                    }
                    if (argValue.endsWith("'")) {
                        argValue = argValue.substring(0, argValue.length() - 1);
                    }
                    if (dataType.equalsIgnoreCase("java.lang.Date") || dataType.equalsIgnoreCase("java.sql.Date") || dataType.equalsIgnoreCase("Date")) {
                        BaseLogger.log("3", null, null, "displayPattern [" + displayPattern + "], dbPattern [yyyy-MM-dd]");
                        argValue = dtbean.convertPattern(displayPattern, "yyyy-MM-dd", argValue);
                        Date date = Date.valueOf(argValue);
                        BaseLogger.log("3", null, null, String.valueOf(dataType) + "\t" + cnt + "\t" + argValue);
                        pstmt.setDate(cnt, date);
                    }
                    if (dataType.equalsIgnoreCase("java.sql.Timestamp") || dataType.equalsIgnoreCase("Timestamp")) {
                        BaseLogger.log("3", null, null, "displayPattern [" + displayPattern + "], dbPattern [yyyy-MM-dd 00:00:00]");
                        argValue = dtbean.convertPattern(displayPattern, "yyyy-MM-dd 00:00:00", argValue);
                        Timestamp timeStamp = Timestamp.valueOf(argValue);
                        BaseLogger.log("3", null, null, String.valueOf(dataType) + "\t" + cnt + "\t" + argValue);
                        pstmt.setTimestamp(cnt, timeStamp);
                    }
                    ++cnt;
                    ++valCount;
                }
            } else if (dataType.equalsIgnoreCase("java.lang.Integer") || dataType.equalsIgnoreCase("Integer") || dataType.equalsIgnoreCase("java.lang.Short") || dataType.equalsIgnoreCase("Short") || dataType.equalsIgnoreCase("java.lang.Byte") || dataType.equalsIgnoreCase("Byte")) {
                valCount = 0;
                while (valCount < argValueList.size()) {
                    argValue = (String)argValueList.get(valCount);
                    if (dbPattern != null && !dbPattern.equalsIgnoreCase("null")) {
                        BaseLogger.log("3", null, null, "displayPattern [" + displayPattern + "], dbPattern [" + dbPattern + "]");
                        argValue = dtbean.convertPattern(displayPattern, dbPattern, argValue);
                    }
                    BaseLogger.log("3", null, null, String.valueOf(dataType) + "\t" + cnt + "\t" + argValue);
                    pstmt.setInt(cnt, Integer.parseInt(argValue));
                    ++cnt;
                    ++valCount;
                }
            } else if (dataType.equalsIgnoreCase("BigDecimal") || dataType.equalsIgnoreCase("java.math.BigDecimal") || dataType.equalsIgnoreCase("BigInteger") || dataType.equalsIgnoreCase("java.math.BigInteger")) {
                valCount = 0;
                while (valCount < argValueList.size()) {
                    argValue = (String)argValueList.get(valCount);
                    if (dbPattern != null && !dbPattern.equalsIgnoreCase("null")) {
                        BaseLogger.log("3", null, null, "displayPattern [" + displayPattern + "], dbPattern [" + dbPattern + "]");
                        argValue = dtbean.convertPattern(displayPattern, dbPattern, argValue);
                    }
                    BaseLogger.log("3", null, null, String.valueOf(dataType) + "\t" + cnt + "\t" + argValue);
                    pstmt.setDouble(cnt, Double.parseDouble(argValue));
                    ++cnt;
                    ++valCount;
                }
            }
            ++ctrOrder;
        }
    }

    private void parseDocument(Column[] columnArr) throws Exception {
        int noOfCols = columnArr.length;
        int ctr = 0;
        while (ctr < noOfCols) {
            Column currCol = columnArr[ctr];
            if (currCol.getPhysicalName() != null && !"null".equalsIgnoreCase(currCol.getPhysicalName())) {
                this.tMap.put(String.valueOf(currCol.getTable()) + "." + currCol.getPhysicalName(), currCol.getLogicalName());
            }
            ++ctr;
        }
        BaseLogger.log("3", null, null, "this.tMap :" + this.tMap);
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        try {
            if (rawName.equalsIgnoreCase("COLUMNS")) {
                this.columnsFlag = true;
            } else if (rawName.equalsIgnoreCase("COLUMN")) {
                String tableName = null;
                if (attributes != null) {
                    int index;
                    int dbindex = attributes.getIndex("DBTABLE");
                    if (dbindex != -1) {
                        tableName = attributes.getValue("DBTABLE");
                    }
                    if ((index = attributes.getIndex("KEY")) != -1 && attributes.getValue("KEY").equalsIgnoreCase("true")) {
                        this.vPK.addElement(attributes.getValue("COLID"));
                    }
                    String dbNameStr = attributes.getValue("DBNAME");
                    String logName = attributes.getValue("NAME");
                    if (!this.secureColList.contains(logName)) {
                        this.tMap.put(String.valueOf(tableName) + "." + dbNameStr, logName);
                    }
                }
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        try {
            if (rawName.equalsIgnoreCase("COLUMNS")) {
                this.columnsFlag = false;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    private String getUpdatedSql(String SQL, ArrayList argumentList) {
        StringBuffer sqlBuffer = new StringBuffer(SQL);
        try {
            int index = 0;
            int count = 0;
            while (index != -1) {
                index = sqlBuffer.toString().indexOf("?", index);
                if (index == -1) continue;
                Argument argObj = (Argument)argumentList.get(count);
                ArrayList argValueList = argObj.getArgValue();
                String placeholders = "";
                BaseLogger.log("3", null, null, "argValueList :" + argValueList);
                int phcount = 0;
                while (phcount < argValueList.size()) {
                    placeholders = String.valueOf(placeholders) + "?,";
                    ++phcount;
                }
                sqlBuffer.replace(index, index + 1, placeholders.substring(0, placeholders.length() - 1));
                index += placeholders.length();
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sqlBuffer.toString();
    }

    private String[] getProperties(int sqlType) throws Exception {
        String[] properties = new String[]{"VARCHAR", "text", "1", "java.lang.String", CommonConstants.DB_ALPHANUM_PATTERN == null ? "" : CommonConstants.DB_ALPHANUM_PATTERN};
        try {
            switch (sqlType) {
                case -5: {
                    properties[0] = "NUMBER";
                    properties[1] = "number";
                    properties[2] = "2";
                    properties[3] = "java.math.BigDecimal";
                    properties[4] = CommonConstants.DISPLAY_NUMBER_PATTERN;
                    break;
                }
                case -1: {
                    properties[0] = "VARCHAR";
                    break;
                }
                case 1: {
                    properties[0] = "CHAR";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    properties[0] = "NUMBER";
                    properties[1] = "number";
                    properties[2] = "2";
                    properties[3] = "java.lang.Double";
                    properties[4] = CommonConstants.DISPLAY_NUMBER_PATTERN;
                    break;
                }
                case 12: {
                    properties[0] = "VARCHAR";
                    break;
                }
                case 91: {
                    properties[0] = "DATE";
                    properties[1] = "date";
                    properties[2] = "1";
                    properties[3] = "java.sql.Date";
                    properties[4] = CommonConstants.DISPLAY_DATE_PATTERN;
                    break;
                }
                case 92: 
                case 93: {
                    properties[0] = "TIMESTAMP";
                    properties[1] = "date";
                    properties[2] = "1";
                    properties[3] = "java.sql.Timestamp";
                    properties[4] = CommonConstants.DISPLAY_TIMESTAMP_PATTERN;
                    break;
                }
                default: {
                    properties[0] = "VARCHAR";
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception: DB2XMLGenerator: getDBType:\n" + e);
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return properties;
    }

    public void setDefDoc(String defDoc) {
        this.defDoc = defDoc;
    }

    public String getDefDoc() {
        return this.defDoc;
    }

    private String getMetaInfo(ResultSetMetaData rsmd) throws Exception {
        String rtnVal = "false";
        try {
            StringBuffer colDefXml = new StringBuffer("<COLUMNS>");
            if (rsmd != null) {
                BaseLogger.log("9", null, null, "No of Columns" + rsmd.getColumnCount());
                int i = 1;
                while (i <= rsmd.getColumnCount()) {
                    String colName = rsmd.getColumnName(i);
                    String colTitle = rsmd.getColumnLabel(i);
                    String tabName = rsmd.getTableName(i);
                    String[] properties = this.getProperties(rsmd.getColumnType(i));
                    String colType = properties[0];
                    String sortType = properties[1];
                    String alignment = properties[2];
                    String javaType = properties[3];
                    String pattern = properties[4];
                    int colDispSize = rsmd.getColumnDisplaySize(i);
                    if (colName.indexOf("(") != -1 || colName.indexOf(")") != -1) {
                        throw new BIException("Select valid alias for the column [ " + colName + " ]");
                    }
                    colDefXml.append("<COLUMN ");
                    colDefXml.append(" NAME='").append(colName).append("'");
                    colDefXml.append(" F_NAME='").append(colName).append("'");
                    colDefXml.append(" T_NAME='").append(colName).append("'");
                    colDefXml.append(" DBNAME='").append(colName).append("'");
                    colDefXml.append(" DBTABLE='").append(tabName).append("'");
                    colDefXml.append(" HIDDEN=''");
                    colDefXml.append(" JAVATYPE='").append(javaType).append("'");
                    colDefXml.append(" NATIVETYPE='AN'");
                    colDefXml.append(" EXPRESSIONTYPE='C'");
                    colDefXml.append(" DEFAULTFUNCTION=''");
                    colDefXml.append(" COLTYPE='").append(colType).append("'");
                    colDefXml.append(" DBSIZE='").append(String.valueOf(colDispSize)).append("'");
                    colDefXml.append(" PATTERN='" + pattern + "'");
                    colDefXml.append(" COLID='1'");
                    colDefXml.append(" SORT='").append(sortType).append("'");
                    colDefXml.append(" BOLD='0'");
                    colDefXml.append(" ITALIC='0'");
                    colDefXml.append(" UNDERLINE='0'");
                    colDefXml.append(" WIDTH='100'");
                    colDefXml.append(" FONT='TIMES NEW ROMAN'");
                    colDefXml.append(" FONTSIZE='10'");
                    colDefXml.append(" ALIGNMENT='").append(alignment).append("'");
                    colDefXml.append(" BGCOLOR=''");
                    colDefXml.append(" FGCOLOR='#000000'");
                    colDefXml.append(" >");
                    colDefXml.append("<![CDATA[");
                    colDefXml.append(colTitle);
                    colDefXml.append("]]>");
                    colDefXml.append("</COLUMN>");
                    ++i;
                }
                colDefXml.append("</COLUMNS>");
            }
            rtnVal = colDefXml.toString();
        }
        catch (Exception e) {
            System.err.println("Exception: DB2XMLGenerator: verifySql:\n" + e);
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return rtnVal;
    }
}

