/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.ai.entityid.AIEngine;
import ibase.ai.entityid.RasaAIEngine;
import ibase.ai.entityid.WitAIEngine;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.io.File;
import java.util.Map;
import org.json.JSONObject;

public class InvoiceReader {
    String templatePath;
    File invoiceFile;

    public InvoiceReader(File invoiceFile) {
        this.invoiceFile = invoiceFile;
        String fileSeperator = File.separator;
        this.templatePath = String.valueOf(CommonConstants.getBIHOME()) + fileSeperator + "server" + fileSeperator + "default" + fileSeperator + "deploy" + fileSeperator + "ibase.ear" + fileSeperator + "ibase.war" + fileSeperator + "webitm" + fileSeperator + "InvoiceTemplate";
    }

    public String readInvoice(UserInfoBean userInfo, String extractTempl) {
        return this.readInvoice(userInfo, extractTempl, true);
    }

    public String readInvoice(UserInfoBean userInfo, String extractTempl, boolean itemCodeRequired) {
        String extData;
        block10: {
            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() extractTempl[" + extractTempl + "],itemCodeRequired[" + itemCodeRequired + "]");
            extData = "";
            if (this.invoiceFile.exists()) break block10;
            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() file not exist");
            return "";
        }
        try {
            String dataExtractorService = this.getDataExtractorServiceURL();
            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() dataExtractorService::" + dataExtractorService);
            if (extractTempl.length() > 1) {
                dataExtractorService = String.valueOf(dataExtractorService) + "?extract_templ=" + extractTempl;
            }
            byte[] response = E12GenericUtility.makeMultipartRequest(dataExtractorService, this.invoiceFile);
            String result = new String(response);
            JSONObject jsonObject = new JSONObject(result);
            BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "jsonObject[" + jsonObject + "]");
            int status = jsonObject.getInt("status");
            if (status == 1) {
                JSONObject extractedData = jsonObject.getJSONObject("result");
                BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "extractedData[" + extractedData + "]");
                String dataJsonStr = extractedData.toString();
                if (!itemCodeRequired) {
                    BaseLogger.log("3", null, null, "InvoiceReader.readInvoice() hanse itemcode not required returning dataJsonStr:: " + dataJsonStr + "]");
                    return dataJsonStr;
                }
                String AIEngineStr = CommonConstants.AI_ENGINE;
                BaseLogger.log("3", null, null, "postdata dataJsonStr[" + dataJsonStr + "]AIEngineStr[" + AIEngineStr + "]");
                AIEngine aiEngine = null;
                if ("wit".equalsIgnoreCase(AIEngineStr)) {
                    aiEngine = new WitAIEngine();
                    result = aiEngine.getItemCodeList(dataJsonStr, null);
                    BaseLogger.log("3", null, null, "readInvoice GET_ITEM_CODE_LIST WitAIEngine result[" + result + "]");
                    JSONObject jsonItemCodes = new JSONObject(result);
                    jsonItemCodes = jsonItemCodes.getJSONObject("result");
                    jsonItemCodes = jsonItemCodes.getJSONObject("itemCodeList");
                    BaseLogger.log("3", null, null, "result jsonItemCodes[" + jsonItemCodes + "]");
                    extractedData.put("itemCodeList", (Object)jsonItemCodes);
                } else if ("rasa".equalsIgnoreCase(AIEngineStr)) {
                    aiEngine = new RasaAIEngine();
                    result = aiEngine.getItemCodeList(dataJsonStr, userInfo);
                    JSONObject jsonItemCodes = new JSONObject(result);
                    BaseLogger.log("3", null, null, " rasa result jsonItemCodes[" + jsonItemCodes + "]");
                    extractedData.put("itemCodeList", (Object)jsonItemCodes);
                }
                BaseLogger.log("3", null, null, "result extractedData[" + extractedData + "]");
                extData = String.valueOf(extractedData);
            } else {
                BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "Error occurred while extracting data [" + jsonObject.get("error") + "]");
            }
        }
        catch (Exception ex) {
            extData = "";
            BaseLogger.log("0", null, "InvoiceReader.readInvoice()", "Exception in readInvoice : " + ex);
        }
        BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "Extracted data : [" + extData + "]");
        return extData;
    }

    private String getDataExtractorServiceURL() {
        String dataExtractorServiceURL = null;
        Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
        BaseLogger.log("3", null, null, "InvoiceReader readInvoice() getDataExtractorServiceURL pythonServicesMap::" + pythonServicesMap);
        if (pythonServicesMap != null) {
            Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("DATA_EXTRACTOR");
            String protocol = proteusSenseServiceDetails.get("PROTOCOL");
            String host = proteusSenseServiceDetails.get("HOST");
            String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
            String path = proteusSenseServiceDetails.get("ENDPOINT");
            dataExtractorServiceURL = String.format("%s://%s%s/%s", protocol, host, port, path);
        }
        return dataExtractorServiceURL;
    }
}

