/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.utility.XMLtoJSONConverter;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class APISampleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    UserInfoBean userInfoGlobal = new UserInfoBean();
    E12GenericUtility genericUtility = new E12GenericUtility();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("Inside doGet method :: APISampleServlet");
        this.genericUtility = new E12GenericUtility();
        String action = request.getParameter("action");
        BaseLogger.log("3", null, null, "action with file Type: APISample.jsp => [ " + action + " ] ");
        if (action != null && action.equals("downloadSampleData")) {
            BaseLogger.log("3", null, null, "action: APISample.jsp => [ " + action + " ] ");
            String result = "";
            String objName = request.getParameter("objName");
            String fileType = request.getParameter("fileType");
            String refId = request.getParameter("reffId");
            String primaryKey = this.getTableAndPrimaryKey(objName, this.userInfoGlobal.getLoginCode()).get(1);
            BaseLogger.log("3", null, null, "refId: APISample.jsp => [ " + refId + " ] ");
            BaseLogger.log("3", null, null, "fileType: APISample.jsp ==> [ " + fileType + " ] ");
            BaseLogger.log("3", null, null, "userInfoGlobal.getLoginCode(): APISample.jsp => [ " + this.userInfoGlobal.getLoginCode() + " ] ");
            if (fileType != null && fileType.equalsIgnoreCase("xml")) {
                result = this.downloadSampleDataWithAttributes(objName, refId, request, response);
            } else if (fileType != null && fileType.equalsIgnoreCase("json")) {
                result = this.downloadJSONSampleData(objName, refId, request, response);
                BaseLogger.log("3", null, null, "JSON Data: APISample.jsp ==> [ " + result + " ] ");
            }
            BaseLogger.log("3", null, null, "result: APISample.jsp => [ " + result + " ] ");
            return;
        }
        String userCode = request.getParameter("userCode");
        BaseLogger.log("3", null, null, "userCode in APISampleCode from APISampleServlet : [" + userCode + "]");
        String appId = request.getParameter("appId");
        BaseLogger.log("3", null, null, "appId in APISampleCode from APISampleServlet : [" + appId + "]");
        Map<Object, Object> endpoint_objectMap = new HashMap();
        endpoint_objectMap = this.APISampleDropDown(userCode, appId);
        BaseLogger.log("3", null, null, "endpoint_objectMaps: APISample.jssp => [ " + endpoint_objectMap + " ] ");
        PrintWriter out = response.getWriter();
        JSONObject endpointObjectJSON = new JSONObject(endpoint_objectMap);
        response.setContentType("application/json");
        out.print(endpointObjectJSON);
        BaseLogger.log("3", null, null, "endpointObjectJSON: APISample.jsp => [ " + endpointObjectJSON + " ] ");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected void service(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        super.service(arg0, arg1);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    public Map<String, List<String>> APISampleDropDown(String userCode, String appId) {
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        HashMap<String, List<String>> endpoint_objectMap = new HashMap<String, List<String>>();
        try {
            UserInfoBean userInfo;
            this.userInfoGlobal = userInfo = commonDBAccessEJB.createUserInfo(userCode);
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            ConnDriver connDriver = new ConnDriver();
            String sqlEndpointandObjectList = "SELECT ENDPOINT, OBJ_NAME FROM AUTH_APPS_API WHERE APP_ID = ?";
            try {
                try {
                    if (userInfo != null) {
                        BaseLogger.log("3", null, null, "userInfo: APISample.jsp => [ " + userInfo + " ] ");
                    }
                    conn = connDriver.getConnectDB(userInfo);
                    pstmt = conn.prepareStatement(sqlEndpointandObjectList);
                    pstmt.setString(1, appId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (endpoint_objectMap.containsKey(rs.getString("OBJ_NAME"))) {
                            ((List)endpoint_objectMap.get(rs.getString("OBJ_NAME"))).add(rs.getString("ENDPOINT"));
                            continue;
                        }
                        ArrayList<String> endpointList = new ArrayList<String>();
                        endpointList.add(rs.getString("ENDPOINT"));
                        endpoint_objectMap.put(rs.getString("OBJ_NAME"), endpointList);
                    }
                    BaseLogger.log("3", null, null, "endpoint_objectMap: APISample.jsp => [ " + endpoint_objectMap + " ] ");
                }
                catch (SQLException e) {
                    throw new ibase.planner.utility.ITMException(e);
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return endpoint_objectMap;
    }

    public String downloadSampleDataWithAttributes(String objName, String refId, HttpServletRequest request, HttpServletResponse response) {
        BaseLogger.log("3", null, null, "Inside downloadSampleData() ");
        String result = "";
        try {
            result = this.getDetailXMLDomString(objName, "1", "V", refId, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        catch (ibase.planner.utility.ITMException e) {
            e.printStackTrace();
        }
        String formattedXML = this.getFormattedXML(result, objName);
        BaseLogger.log("3", null, null, "result: downloadSampleData() => [ " + formattedXML + " ] ");
        byte[] byteArrray = formattedXML.getBytes();
        BaseLogger.log("3", null, null, "byteArrray: downloadSampleData() => [ " + byteArrray + " ] ");
        response.setContentType("text/xml");
        response.setHeader("Content-Disposition", "attachment;filename=SampleData.xml");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(byteArrray);
        }
        catch (IOException e) {
            BaseLogger.log("3", null, null, "catch: downloadSampleData() => [ " + e.getMessage() + " ] ");
            e.printStackTrace();
        }
        return result;
    }

    public String downloadJSONSampleData(String objName, String refId, HttpServletRequest request, HttpServletResponse response) {
        BaseLogger.log("3", null, null, "Inside downloadSampleData() ");
        String result = "";
        String JSONString = "";
        try {
            result = this.getDetailXMLDomString(objName, "1", "V", refId, null);
            XMLtoJSONConverter converter = new XMLtoJSONConverter();
            String formattedXML = this.getFormattedXML(result, objName);
            JSONString = converter.xmlToJSONString(formattedXML);
        }
        catch (Exception e) {
            System.out.println("Error=====>" + e.getMessage());
            e.printStackTrace();
        }
        BaseLogger.log("3", null, null, "result: downloadSampleData() => [ " + JSONString + " ] ");
        byte[] byteArrray = JSONString.getBytes();
        BaseLogger.log("3", null, null, "byteArrray: downloadSampleData() => [ " + byteArrray + " ] ");
        response.setContentType("application/text");
        response.setHeader("Content-Disposition", "attachment;filename=SampleData.json");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(byteArrray);
        }
        catch (IOException e) {
            BaseLogger.log("3", null, null, "catch: downloadSampleData() => [ " + e.getMessage() + " ] ");
            e.printStackTrace();
        }
        return result;
    }

    private String getFormattedXML(String result, String objName) {
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><DocumentRoot>");
        try {
            UploadFileEJB uploadFileEJB = new UploadFileEJB();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(result.getBytes()));
            TreeMap<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, this.userInfoGlobal);
            int mapIndex = 1;
            while (mapIndex <= formDetailInfo.size()) {
                NodeList nodes = document.getElementsByTagName("Detail" + mapIndex);
                int i = 0;
                while (i < nodes.getLength()) {
                    System.out.println("detailNodeName===>" + nodes.item(i).getNodeName());
                    NodeList detailList = nodes.item(i).getChildNodes();
                    if (xml.indexOf("<" + nodes.item(i).getNodeName() + ">") == -1) {
                        BaseLogger.log("3", null, null, "detail not exist=======><" + nodes.item(i).getNodeName() + ">");
                        xml.append("<" + nodes.item(i).getNodeName() + ">");
                        int dindex = 0;
                        while (dindex < detailList.getLength()) {
                            Node colNode = detailList.item(dindex);
                            if (!colNode.getNodeName().contains("#") && !colNode.getNodeName().equals("attribute")) {
                                BaseLogger.log("3", null, null, "NodeName===>" + detailList.item(dindex).getNodeName());
                                String data = "\"\"";
                                if (colNode.hasChildNodes()) {
                                    data = colNode.getFirstChild().getTextContent();
                                }
                                xml.append("<" + colNode.getNodeName() + ">" + data);
                                xml.append("</" + colNode.getNodeName() + ">");
                            }
                            ++dindex;
                        }
                        xml.append("</" + nodes.item(i).getNodeName() + ">");
                    }
                    ++i;
                }
                ++mapIndex;
            }
            xml.append("</DocumentRoot>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml.toString();
    }

    private String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues) throws RemoteException, ITMException, ibase.planner.utility.ITMException {
        String resultString = "";
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                masterStateful = (MasterStatefulLocal)this.getInitialContext().lookup("ibase/MasterStatefulEJB/local");
                int randInt = new Random().nextInt();
                masterStateful.setEditorId("" + randInt);
                masterStateful.setUserInfo(this.userInfoGlobal);
                resultString = masterStateful.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues);
            }
            catch (NamingException e) {
                BaseLogger.log("0", null, null, "NamingException :: getDetailXMLDomString() :==>\n" + e.getMessage());
                throw new ibase.planner.utility.ITMException(e);
            }
        }
        finally {
            if (masterStateful != null) {
                masterStateful.remove();
                masterStateful = null;
            }
        }
        return resultString;
    }

    private InitialContext getInitialContext() throws ibase.planner.utility.ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ibase.planner.utility.ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException : getInitialContext : " + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getInitialContext : " + e.getMessage());
            throw new ibase.planner.utility.ITMException(e);
        }
        return ctx;
    }

    private List<String> getTableAndPrimaryKey(String objName, String userCode) {
        ArrayList<String> dataList = new ArrayList<String>();
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                ConnDriver connDriver = new ConnDriver();
                UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
                String sql = "SELECT TABLE_NAME,TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + objName + "'";
                conn = connDriver.getConnectDB(userInfo);
                pstmt = conn.createStatement();
                ResultSet rs = pstmt.executeQuery(sql);
                if (rs.next()) {
                    dataList.add(rs.getString("TABLE_NAME"));
                    dataList.add(rs.getString("TRAN_ID_COL"));
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (dataList.size() > 0) {
                    System.out.println("Query=" + (String)dataList.get(1));
                    if ("null".equals(dataList.get(1)) || dataList.get(1) == null || ((String)dataList.get(1)).equals("")) {
                        String query = "SELECT cols.column_name FROM all_constraints cons, all_cons_columns cols WHERE cols.table_name = '" + ((String)dataList.get(0)).toUpperCase() + "' " + "AND cons.constraint_type = 'P' " + "AND cons.constraint_name = cols.constraint_name " + "AND cons.owner = cols.owner " + "AND POSITION='1' " + "ORDER BY cols.table_name, cols.position";
                        System.out.println("Query=" + query);
                        pstmt = conn.createStatement();
                        rs = pstmt.executeQuery(query);
                        if (rs.next()) {
                            dataList.add(1, rs.getString("column_name"));
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        return dataList;
    }

    public String getRandomPrimaryKeyValue(String primaryKey, String tableName, String userCode) {
        String randomValue = "";
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                ConnDriver connDriver = new ConnDriver();
                UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
                String sql = "SELECT " + primaryKey + " FROM " + tableName + " ORDER BY DBMS_RANDOM.value FETCH NEXT 1 ROWS ONLY";
                conn = connDriver.getConnectDB(userInfo);
                pstmt = conn.createStatement();
                ResultSet rs = pstmt.executeQuery(sql);
                if (rs.next()) {
                    randomValue = rs.getString(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        return randomValue;
    }

    public FileOutputStream writeFile(String fileContent) {
        String fileName = "SampleData.txt";
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(fileName);
            byte[] strToBytes = fileContent.getBytes();
            outputStream.write(strToBytes);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream;
    }
}

