/*
 * Decompiled with CFR 0.152.
 */
package ibase.ai.entityid;

import ibase.bis.utility.BISDictionary;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import org.json.JSONObject;

public class ItemUOM {
    public int getStandardQuantity(int quantity, String itemCode, String unitFR, Connection con) throws ITMException {
        PreparedStatement pst = null;
        ResultSet rset = null;
        int factor = 0;
        String itemCodeDB = "";
        int stdQuantity = 0;
        try {
            try {
                String sql = "SELECT ITEM_CODE, FACT FROM UOMCONV WHERE UNIT__FR=? AND ITEM_CODE IN (?,?)";
                pst = con.prepareStatement(sql);
                pst.setString(1, unitFR);
                pst.setString(2, "X");
                pst.setString(3, itemCode);
                rset = pst.executeQuery();
                while (rset.next()) {
                    itemCodeDB = E12GenericUtility.checkNull(rset.getString("ITEM_CODE"));
                    if (!"X".equalsIgnoreCase(itemCodeDB)) {
                        factor = rset.getInt("FACT");
                        break;
                    }
                    factor = rset.getInt("FACT");
                }
                stdQuantity = quantity * factor;
                rset.close();
                rset = null;
                pst.close();
                pst = null;
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, " ItemUOM getStandardQuantity :::[" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
                if (rset != null) {
                    rset.close();
                    rset = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("2", null, null, "ItemUOM getStandardQuantity finally Exception : [" + E12GenericUtility.getStackTrace(e2) + "]");
                throw new ITMException(e2);
            }
        }
        BaseLogger.log("3", null, null, " ItemUOM getStandardQuantity [" + stdQuantity + "]");
        return stdQuantity;
    }

    public int updateOrInsertUOM(UserInfoBean userInfo, JSONObject object) throws ITMException {
        Statement pst = null;
        ResultSet rset = null;
        Connection con = null;
        int count = 0;
        int exeCount = 0;
        String descr = "";
        int decOpt = 0;
        String round = "N";
        int roundTO = 0;
        String chgDate = "";
        String chgUser = "";
        String chgTerm = "";
        boolean stdQuantity = false;
        boolean quantity = false;
        ConnDriver connDriver = new ConnDriver();
        chgUser = userInfo.getLoginCode();
        chgTerm = userInfo.getRemoteHostName();
        try {
            try {
                if (chgTerm != null && chgTerm.length() > 15) {
                    chgTerm = chgTerm.substring(0, 15);
                } else if (chgTerm == null || chgTerm.length() == 0) {
                    chgTerm = userInfo.getRemoteHost();
                }
                BISDictionary bisDictionary = new BISDictionary();
                con = connDriver.getConnectDB(userInfo.getTransDB());
                String itemCode = object.optString("item_code");
                String packing = object.optString("packing");
                int factor = object.optInt("factor");
                String standardUnit = object.optString("std_unit");
                JSONObject bisObj = new JSONObject();
                bisObj.put("PHRASE", (Object)packing);
                bisObj.put("RES_VALUE", (Object)standardUnit);
                bisObj.put("PHRASE_SCOPE", (Object)"E");
                bisObj.put("RES_TYPE", (Object)"D");
                bisObj.put("USER_ID", (Object)userInfo.getEnterprise());
                bisObj.put("BIS_ENTITY_ID", (Object)object.optString("extract_phy_attrib_1"));
                bisDictionary.InsertOrUpdateBISDictionary(bisObj, null, userInfo);
                String sql = "SELECT COUNT(*) AS COUNT FROM UOMCONV WHERE ITEM_CODE=? AND UNIT__FR=?";
                pst = con.prepareStatement(sql);
                pst.setString(1, itemCode);
                pst.setString(2, standardUnit);
                rset = pst.executeQuery();
                if (rset.next()) {
                    count = rset.getInt("COUNT");
                }
                rset.close();
                rset = null;
                pst.close();
                pst = null;
                if (count > 0) {
                    String updateSql = "UPDATE UOMCONV SET FACT=? WHERE ITEM_CODE=? AND UNIT__FR=?";
                    pst = con.prepareStatement(updateSql);
                    pst.setInt(1, factor);
                    pst.setString(2, itemCode);
                    pst.setString(3, standardUnit);
                    exeCount = pst.executeUpdate();
                    if (exeCount > 0) {
                        con.commit();
                    }
                    if (pst != null) {
                        pst.close();
                        pst = null;
                    }
                } else {
                    String insertSql = "Insert into UOMCONV (UNIT__FR,UNIT__TO,ITEM_CODE,DESCR,DEC_OPT,ROUND,ROUND_TO,CHG_USER,CHG_TERM,CHG_DATE) values (?,?,?,?,?,?,?,?,?,?)";
                    pst = con.prepareStatement(insertSql);
                    pst.setString(1, standardUnit);
                    pst.setString(2, standardUnit);
                    pst.setString(3, itemCode);
                    pst.setString(4, descr);
                    pst.setInt(5, decOpt);
                    pst.setString(6, round);
                    pst.setInt(7, roundTO);
                    pst.setString(8, chgUser);
                    pst.setString(9, chgTerm);
                    pst.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
                    exeCount = pst.executeUpdate();
                    if (exeCount > 0) {
                        con.commit();
                    }
                    if (pst != null) {
                        pst.close();
                        pst = null;
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("2", userInfo, null, "ItemUOM getStandardQuantity Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                    con = null;
                }
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
                if (rset != null) {
                    rset.close();
                    rset = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("2", userInfo, null, "ItemUOM getStandardQuantity finally Exception : [" + E12GenericUtility.getStackTrace(e2) + "]");
                throw new ITMException(e2);
            }
        }
        return exeCount;
    }
}

